/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kafka.api.PartitionLinkState;
import kafka.availability.BrokerHealthManager;
import kafka.cluster.AlterPartitionListener;
import kafka.cluster.ClusterLinkState;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.ReplicaManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.TopicLinkFailedMirror$;
import kafka.server.link.TopicLinkState;
import kafka.server.link.TopicLinkState$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.OffsetAndEpoch;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

public final class Partition$
implements KafkaMetricsGroup {
    public static final Partition$ MODULE$ = new Partition$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$(this, metricName, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$(this, metricName);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Option<Executor> $lessinit$greater$default$12() {
        return None$.MODULE$;
    }

    public boolean $lessinit$greater$default$15() {
        return false;
    }

    public Option<BrokerHealthManager> $lessinit$greater$default$16() {
        return None$.MODULE$;
    }

    public Partition apply(TopicPartition topicPartition, Time time, ReplicaManager replicaManager, Option<OffsetAndEpoch> metadataOffsetAndEpoch) {
        AlterPartitionListener alterPartitionListener = new AlterPartitionListener(replicaManager){
            private final ReplicaManager replicaManager$1;

            public void markIsrExpand() {
                this.replicaManager$1.isrExpandRate().mark();
            }

            public void markIsrShrink() {
                this.replicaManager$1.isrShrinkRate().mark();
            }

            public void markFailed() {
                this.replicaManager$1.failedIsrUpdatesRate().mark();
            }

            public void markFollowerStateUpdated(Partition partition) {
                this.replicaManager$1.clusterLinkManager().foreach((Function1 & Serializable)manager -> {
                    anon.1.$anonfun$markFollowerStateUpdated$1(partition, manager);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$markFollowerStateUpdated$1(Partition partition$1, ClusterLinkFactory.LinkManager manager) {
                manager.maybeNotifyReadyForFetch(partition$1);
            }
            {
                this.replicaManager$1 = replicaManager$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$markFollowerStateUpdated$1$adapted(kafka.cluster.Partition kafka.server.link.ClusterLinkFactory$LinkManager )}, serializedLambda);
            }
        };
        DelayedOperations delayedOperations = new DelayedOperations(topicPartition, replicaManager.delayedProducePurgatory(), replicaManager.delayedFetchPurgatory(), replicaManager.delayedDeleteRecordsPurgatory());
        return new Partition(topicPartition, Predef$.MODULE$.Long2long(replicaManager.config().replicaLagTimeMaxMs()), replicaManager.config().interBrokerProtocolVersion(), replicaManager.config().brokerId(), time, alterPartitionListener, delayedOperations, replicaManager.metadataCache(), replicaManager.logManager(), replicaManager.tierReplicaComponents().replicaManagerOpt(), replicaManager.tierReplicaComponents().stateFetcherOpt(), (Option<Executor>)new Some((Object)replicaManager.executor()), replicaManager.alterPartitionManager(), metadataOffsetAndEpoch, replicaManager.deferIsrShrinkEnable(), replicaManager.brokerHealthManager());
    }

    public void removeMetrics(TopicPartition topicPartition) {
        Map tags = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)topicPartition.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)Integer.toString(topicPartition.partition()))}));
        String removeMetric_name = "UnderReplicated";
        KafkaMetricsGroup.removeMetric$(this, removeMetric_name, tags);
        Object var3_3 = null;
        String removeMetric_name2 = "UnderMinIsr";
        KafkaMetricsGroup.removeMetric$(this, removeMetric_name2, tags);
        Object var4_4 = null;
        String removeMetric_name3 = "DeferredUnderMinIsr";
        KafkaMetricsGroup.removeMetric$(this, removeMetric_name3, tags);
        Object var5_5 = null;
        String removeMetric_name4 = "InSyncReplicasCount";
        KafkaMetricsGroup.removeMetric$(this, removeMetric_name4, tags);
        Object var6_6 = null;
        String removeMetric_name5 = "CaughtUpReplicasCount";
        KafkaMetricsGroup.removeMetric$(this, removeMetric_name5, tags);
        Object var7_7 = null;
        String removeMetric_name6 = "ReplicasCount";
        KafkaMetricsGroup.removeMetric$(this, removeMetric_name6, tags);
        Object var8_8 = null;
        String removeMetric_name7 = "LastStableOffsetLag";
        KafkaMetricsGroup.removeMetric$(this, removeMetric_name7, tags);
        Object var9_9 = null;
        String removeMetric_name8 = "AtMinIsr";
        KafkaMetricsGroup.removeMetric$(this, removeMetric_name8, tags);
        Object var10_10 = null;
        String removeMetric_name9 = "IsNotCaughtUp";
        KafkaMetricsGroup.removeMetric$(this, removeMetric_name9, tags);
        Object var11_11 = null;
        String removeMetric_name10 = "ObserverReplicasCount";
        KafkaMetricsGroup.removeMetric$(this, removeMetric_name10, tags);
        Object var12_12 = null;
        String removeMetric_name11 = "ObserversInIsrCount";
        KafkaMetricsGroup.removeMetric$(this, removeMetric_name11, tags);
        Object var13_13 = null;
        String removeMetric_name12 = "MirrorReplicasCount";
        KafkaMetricsGroup.removeMetric$(this, removeMetric_name12, tags);
        Object var14_14 = null;
        String removeMetric_name13 = "UnderReplicatedMirror";
        KafkaMetricsGroup.removeMetric$(this, removeMetric_name13, tags);
        Object var15_15 = null;
        String removeMetric_name14 = "UnderMinIsrMirror";
        KafkaMetricsGroup.removeMetric$(this, removeMetric_name14, tags);
        Object var16_16 = null;
        String removeMetric_name15 = "AtMinIsrMirror";
        KafkaMetricsGroup.removeMetric$(this, removeMetric_name15, tags);
        Object var17_17 = null;
        String removeMetric_name16 = "BlockedOnMirrorSource";
        KafkaMetricsGroup.removeMetric$(this, removeMetric_name16, tags);
    }

    public Option<ClusterLinkState> clusterLinkState(LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState) {
        return Option$.MODULE$.apply((Object)partitionState.clusterLinkId()).map((Function1 & Serializable)x$1 -> UUID.fromString(x$1)).flatMap((Function1 & Serializable)linkId -> Option$.MODULE$.apply((Object)partitionState.clusterLinkTopicState()).map((Function1 & Serializable)state -> {
            TopicLinkState topicLinkState;
            try {
                topicLinkState = TopicLinkState$.MODULE$.fromString((String)state);
            }
            catch (IllegalArgumentException e) {
                Partition$ error_this = MODULE$;
                if (error_this.logger().underlying().isErrorEnabled()) {
                    String msgWithLogIdent_msg = Partition$.$anonfun$clusterLinkState$4(state);
                    Object var8_5 = null;
                    error_this.logger().underlying().error(Logging.msgWithLogIdent$(error_this, msgWithLogIdent_msg), (Throwable)e);
                }
                Object var7_4 = null;
                topicLinkState = TopicLinkFailedMirror$.MODULE$;
            }
            TopicLinkState topicState = topicLinkState;
            TopicLinkState topicLinkState2 = topicState;
            TopicLinkFailedMirror$ topicLinkFailedMirror$ = TopicLinkFailedMirror$.MODULE$;
            PartitionLinkState linkedPartitionState = new PartitionLinkState(partitionState.linkedLeaderEpoch(), topicLinkState2 != null && topicLinkState2.equals(topicLinkFailedMirror$));
            return new ClusterLinkState((UUID)linkId, topicState, linkedPartitionState);
        }));
    }

    public boolean isActiveLinkDestination(LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState) {
        return this.clusterLinkState(partitionState).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isActiveLinkDestination()));
    }

    public static final /* synthetic */ String $anonfun$clusterLinkState$4(String state$1) {
        return new StringBuilder(46).append("Unknown cluster link state ").append(state$1).append(", disable mirroring").toString();
    }

    public static final /* synthetic */ IllegalArgumentException $anonfun$clusterLinkState$5(IllegalArgumentException e$1) {
        return e$1;
    }

    private Partition$() {
    }
}

