/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import kafka.cluster.ReplicaState;
import kafka.cluster.ReplicaState$;
import kafka.log.MergedLog$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ea\u0001B\b\u0011\u0001UA\u0001B\t\u0001\u0003\u0006\u0004%\ta\t\u0005\tO\u0001\u0011\t\u0011)A\u0005I!A\u0001\u0006\u0001BC\u0002\u0013\u0005\u0011\u0006\u0003\u00056\u0001\t\u0005\t\u0015!\u0003+\u0011\u00151\u0004\u0001\"\u00018\u0011\u001da\u0004A1A\u0005\nuBa!\u0014\u0001!\u0002\u0013q\u0004\"\u0002(\u0001\t\u0003y\u0005\"\u0002)\u0001\t\u0003\t\u0006\"\u00024\u0001\t\u00039\u0007\"\u0002:\u0001\t\u0003\u0019\b\"\u0002<\u0001\t\u0003:\bbBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003+\u0001A\u0011IA\f\u0005\u001d\u0011V\r\u001d7jG\u0006T!!\u0005\n\u0002\u000f\rdWo\u001d;fe*\t1#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u00011B\u0004\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VM\u001a\t\u0003;\u0001j\u0011A\b\u0006\u0003?I\tQ!\u001e;jYNL!!\t\u0010\u0003\u000f1{wmZ5oO\u0006A!M]8lKJLE-F\u0001%!\t9R%\u0003\u0002'1\t\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0002UA\u00111fM\u0007\u0002Y)\u0011QFL\u0001\u0007G>lWn\u001c8\u000b\u0005My#B\u0001\u00192\u0003\u0019\t\u0007/Y2iK*\t!'A\u0002pe\u001eL!\u0001\u000e\u0017\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004qiZ\u0004CA\u001d\u0001\u001b\u0005\u0001\u0002\"\u0002\u0012\u0006\u0001\u0004!\u0003\"\u0002\u0015\u0006\u0001\u0004Q\u0013\u0001\u0004:fa2L7-Y*uCR,W#\u0001 \u0011\u0007}B%*D\u0001A\u0015\t\t%)\u0001\u0004bi>l\u0017n\u0019\u0006\u0003\u0007\u0012\u000b!bY8oGV\u0014(/\u001a8u\u0015\t)e)\u0001\u0003vi&d'\"A$\u0002\t)\fg/Y\u0005\u0003\u0013\u0002\u0013q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\t\u0003s-K!\u0001\u0014\t\u0003\u0019I+\u0007\u000f\\5dCN#\u0018\r^3\u0002\u001bI,\u0007\u000f\\5dCN#\u0018\r^3!\u00035\u0019H/\u0019;f':\f\u0007o\u001d5piV\t!*\u0001\tva\u0012\fG/\u001a$fi\u000eD7\u000b^1uKR)!+V/cIB\u0011qcU\u0005\u0003)b\u0011A!\u00168ji\")a+\u0003a\u0001/\u0006Ybm\u001c7m_^,'OR3uG\"|eMZ:fi6+G/\u00193bi\u0006\u0004\"\u0001W.\u000e\u0003eS!A\u0017\n\u0002\rM,'O^3s\u0013\ta\u0016LA\tM_\u001e|eMZ:fi6+G/\u00193bi\u0006DQAX\u0005A\u0002}\u000b1CZ8mY><XM]*uCJ$xJ\u001a4tKR\u0004\"a\u00061\n\u0005\u0005D\"\u0001\u0002'p]\u001eDQaY\u0005A\u0002}\u000b1CZ8mY><XM\u001d$fi\u000eDG+[7f\u001bNDQ!Z\u0005A\u0002}\u000bq\u0002\\3bI\u0016\u0014XI\u001c3PM\u001a\u001cX\r^\u0001\u0012e\u0016\u001cX\r\u001e*fa2L7-Y*uCR,G#\u0002*iU.\u0004\b\"B5\u000b\u0001\u0004y\u0016!D2veJ,g\u000e\u001e+j[\u0016l5\u000fC\u0003f\u0015\u0001\u0007q\fC\u0003m\u0015\u0001\u0007Q.A\u0006jg:+w\u000fT3bI\u0016\u0014\bCA\fo\u0013\ty\u0007DA\u0004C_>dW-\u00198\t\u000bET\u0001\u0019A7\u0002!%\u001chi\u001c7m_^,'/\u00138Ts:\u001c\u0017AG7bs\n,'+Z:fi2\u000b7\u000f^\"bk\u001eDG/\u00169US6,Gc\u0001*uk\")\u0011n\u0003a\u0001?\")Qm\u0003a\u0001?\u0006AAo\\*ue&tw\rF\u0001y!\rI\u0018\u0011\u0001\b\u0003uz\u0004\"a\u001f\r\u000e\u0003qT!! \u000b\u0002\rq\u0012xn\u001c;?\u0013\ty\b$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\t)A\u0001\u0004TiJLgn\u001a\u0006\u0003\u007fb\ta!Z9vC2\u001cHcA7\u0002\f!9\u0011QB\u0007A\u0002\u0005=\u0011\u0001\u0002;iCR\u00042aFA\t\u0013\r\t\u0019\u0002\u0007\u0002\u0004\u0003:L\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003\u0011\u0002")
public class Replica
implements Logging {
    private final int brokerId;
    private final TopicPartition topicPartition;
    private final AtomicReference<ReplicaState> replicaState;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private AtomicReference<ReplicaState> replicaState() {
        return this.replicaState;
    }

    public ReplicaState stateSnapshot() {
        return this.replicaState().get();
    }

    public void updateFetchState(LogOffsetMetadata followerFetchOffsetMetadata, long followerStartOffset, long followerFetchTimeMs, long leaderEndOffset) {
        this.replicaState().updateAndGet(currentReplicaState -> {
            long lastCaughtUpTime = followerFetchOffsetMetadata.messageOffset() >= leaderEndOffset ? package$.MODULE$.max(currentReplicaState.lastCaughtUpTimeMs(), followerFetchTimeMs) : (followerFetchOffsetMetadata.messageOffset() >= currentReplicaState.lastFetchLeaderLogEndOffset() ? package$.MODULE$.max(currentReplicaState.lastCaughtUpTimeMs(), currentReplicaState.lastFetchTimeMs()) : currentReplicaState.lastCaughtUpTimeMs());
            return new ReplicaState(followerStartOffset, followerFetchOffsetMetadata, package$.MODULE$.max(leaderEndOffset, currentReplicaState.lastFetchLeaderLogEndOffset()), followerFetchTimeMs, lastCaughtUpTime);
        });
    }

    public void resetReplicaState(long currentTimeMs, long leaderEndOffset, boolean isNewLeader, boolean isFollowerInSync) {
        this.replicaState().updateAndGet(currentReplicaState -> {
            long lastCaughtUpTimeMs;
            long l = lastCaughtUpTimeMs = isFollowerInSync ? currentTimeMs : 0L;
            if (isNewLeader) {
                return new ReplicaState(MergedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata(), MergedLog$.MODULE$.UnknownOffset(), 0L, lastCaughtUpTimeMs);
            }
            return new ReplicaState(currentReplicaState.logStartOffset(), currentReplicaState.logEndOffsetMetadata(), leaderEndOffset, isFollowerInSync ? currentTimeMs : 0L, lastCaughtUpTimeMs);
        });
        this.trace((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(26).append("Reset state of replica to ").append(this).toString());
    }

    public void maybeResetLastCaughtUpTime(long currentTimeMs, long leaderEndOffset) {
        this.replicaState().updateAndGet(currentReplicaState -> {
            if (currentReplicaState.logEndOffset() == currentReplicaState.lastFetchLeaderLogEndOffset() && currentReplicaState.logEndOffset() < leaderEndOffset && currentReplicaState.lastCaughtUpTimeMs() > 0L) {
                return new ReplicaState(currentReplicaState.logStartOffset(), currentReplicaState.logEndOffsetMetadata(), leaderEndOffset, package$.MODULE$.max(currentTimeMs, currentReplicaState.lastFetchTimeMs()), package$.MODULE$.max(currentTimeMs, currentReplicaState.lastCaughtUpTimeMs()));
            }
            return currentReplicaState;
        });
    }

    public String toString() {
        ReplicaState replicaState = this.replicaState().get();
        StringBuilder replicaString = new StringBuilder();
        replicaString.append(new java.lang.StringBuilder(18).append("Replica(replicaId=").append(this.brokerId()).toString());
        replicaString.append(new java.lang.StringBuilder(8).append(", topic=").append(this.topicPartition().topic()).toString());
        replicaString.append(new java.lang.StringBuilder(12).append(", partition=").append(this.topicPartition().partition()).toString());
        replicaString.append(new java.lang.StringBuilder(21).append(", lastCaughtUpTimeMs=").append(replicaState.lastCaughtUpTimeMs()).toString());
        replicaString.append(new java.lang.StringBuilder(17).append(", logStartOffset=").append(replicaState.logStartOffset()).toString());
        replicaString.append(new java.lang.StringBuilder(15).append(", logEndOffset=").append(replicaState.logEndOffsetMetadata().messageOffset()).toString());
        replicaString.append(new java.lang.StringBuilder(23).append(", logEndOffsetMetadata=").append(replicaState.logEndOffsetMetadata()).toString());
        replicaString.append(new java.lang.StringBuilder(30).append(", lastFetchLeaderLogEndOffset=").append(replicaState.lastFetchLeaderLogEndOffset()).toString());
        replicaString.append(new java.lang.StringBuilder(18).append(", lastFetchTimeMs=").append(replicaState.lastFetchTimeMs()).toString());
        replicaString.append(")");
        return replicaString.toString();
    }

    public boolean equals(Object that) {
        if (that instanceof Replica) {
            Replica replica = (Replica)that;
            if (this.brokerId() == replica.brokerId()) {
                TopicPartition topicPartition = this.topicPartition();
                TopicPartition topicPartition2 = replica.topicPartition();
                if (!(topicPartition != null ? !topicPartition.equals(topicPartition2) : topicPartition2 != null)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return 31 + this.topicPartition().hashCode() + 17 * this.brokerId();
    }

    public Replica(int brokerId, TopicPartition topicPartition) {
        this.brokerId = brokerId;
        this.topicPartition = topicPartition;
        this.replicaState = new AtomicReference<ReplicaState>(ReplicaState$.MODULE$.Empty());
    }
}

