/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kafka.common.AliveBrokersMetadata;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.network.ListenerName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliveBrokersSnapshot
implements AliveBrokersMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(AliveBrokersSnapshot.class);
    public static final AliveBrokersSnapshot EMPTY_SNAPSHOT = new AliveBrokersSnapshot(Collections.emptyMap(), Collections.emptySet(), Collections.emptySet());
    private final Map<Integer, Long> liveBrokerIdsAndEpochs;
    private final Set<Integer> brokerReplicaExclusions;
    private final Set<Integer> demotedBrokers;

    public AliveBrokersSnapshot(Map<Integer, Long> liveBrokerIdsAndEpochs, Set<Integer> brokerReplicaExclusions, Set<Integer> demotedBrokers) {
        this.liveBrokerIdsAndEpochs = Collections.unmodifiableMap(liveBrokerIdsAndEpochs);
        this.brokerReplicaExclusions = Collections.unmodifiableSet(brokerReplicaExclusions);
        this.demotedBrokers = demotedBrokers;
    }

    @Override
    public Set<Integer> aliveBrokers() {
        return new HashSet<Integer>(this.liveBrokerIdsAndEpochs.keySet());
    }

    @Override
    public Set<Integer> replicaExclusions() {
        return new HashSet<Integer>(this.brokerReplicaExclusions);
    }

    @Override
    public Set<Integer> demotedBrokers() {
        return new HashSet<Integer>(this.demotedBrokers);
    }

    @Override
    public Optional<Long> epochFor(int brokerId) {
        return Optional.ofNullable(this.liveBrokerIdsAndEpochs.get(brokerId));
    }

    @Override
    public Optional<Endpoint> endpointFor(ListenerName listenerName) {
        LOG.warn("Attempted to fetch endpoint for listener {} from {} but {} does not have this information.", new Object[]{listenerName, this.getClass().getSimpleName(), this.getClass().getSimpleName()});
        return Optional.empty();
    }

    @Override
    public boolean isEmpty() {
        return this.equals(EMPTY_SNAPSHOT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliveBrokersSnapshot that = (AliveBrokersSnapshot)o;
        return Objects.equals(this.liveBrokerIdsAndEpochs, that.liveBrokerIdsAndEpochs) && Objects.equals(this.brokerReplicaExclusions, that.brokerReplicaExclusions) && Objects.equals(this.demotedBrokers, that.demotedBrokers);
    }

    public int hashCode() {
        return Objects.hash(this.liveBrokerIdsAndEpochs, this.brokerReplicaExclusions, this.demotedBrokers);
    }

    public String toString() {
        return "AliveBrokersSnapshot{liveBrokerIdsAndEpochs=" + this.liveBrokerIdsAndEpochs + ", brokerReplicaExclusions=" + this.brokerReplicaExclusions + ", demotedBrokers=" + this.demotedBrokers + "}";
    }
}

