/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.controller.ControlMetadataAccumulator;
import kafka.controller.ControlMetadataBatch;
import kafka.controller.ControlMetadataBatchResult;
import kafka.controller.ControllerBrokerStateInfo;
import kafka.controller.ControllerChannelManager$;
import kafka.controller.ControllerContext;
import kafka.controller.QueueItem;
import kafka.controller.RequestSendThread;
import kafka.controller.StateChangeLogger;
import kafka.controller.UnhealthyBroker;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055x!B\u0013'\u0011\u0003Yc!B\u0017'\u0011\u0003q\u0003\"B\u001b\u0002\t\u00031\u0004bB\u001c\u0002\u0005\u0004%\t\u0001\u000f\u0005\u0007\u0003\u0006\u0001\u000b\u0011B\u001d\t\u000f\t\u000b!\u0019!C\u0001q!11)\u0001Q\u0001\neBq\u0001R\u0001C\u0002\u0013\u0005\u0001\b\u0003\u0004F\u0003\u0001\u0006I!\u000f\u0005\b\r\u0006\t\n\u0011\"\u0001H\r\u0011ic\u0005A0\t\u00111T!\u0011!Q\u0001\n5D\u0001\u0002\u001d\u0006\u0003\u0002\u0003\u0006I!\u001d\u0005\to*\u0011\t\u0011)A\u0005q\"I\u0011N\u0003B\u0001B\u0003%\u0011\u0011\u0002\u0005\u000b\u0003'Q!\u0011!Q\u0001\n\u0005U\u0001\"CA\u000e\u0015\t\u0005\t\u0015!\u0003J\u0011\u0019)$\u0002\"\u0001\u0002\u001e!I\u0011Q\u0006\u0006C\u0002\u0013E\u0011q\u0006\u0005\t\u0003\u001bR\u0001\u0015!\u0003\u00022!I\u0011q\n\u0006C\u0002\u0013%\u0011\u0011\u000b\u0005\t\u00033R\u0001\u0015!\u0003\u0002T!I\u00111\f\u0006C\u0002\u0013\u0005\u0011Q\f\u0005\t\u0003WR\u0001\u0015!\u0003\u0002`!9\u0011Q\u000e\u0006\u0005\n\u0005=\u0004bBA@\u0015\u0011\u0005\u0011\u0011\u0011\u0005\b\u0003\u0007SA\u0011AAC\u0011\u001d\tII\u0003C\u0001\u0003\u0003Cq!a#\u000b\t\u0003\t\t\tC\u0004\u0002\u000e*!\t!a$\t\u0013\u00055&\"%A\u0005\u0002\u0005=\u0006bBAZ\u0015\u0011\u0005\u0011Q\u0017\u0005\b\u0003\u000fTA\u0011AAe\u0011\u001d\tiM\u0003C\t\u0003\u001fDq!a5\u000b\t\u0013\t)\u000eC\u0004\u0002`*!\t\"!9\t\u000f\u0005\u001d(\u0002\"\u0005\u0002j\u0006A2i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u000b\u0005\u001dB\u0013AC2p]R\u0014x\u000e\u001c7fe*\t\u0011&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u00051\nQ\"\u0001\u0014\u00031\r{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'o\u0005\u0002\u0002_A\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0016\u0002'E+X-^3TSj,W*\u001a;sS\u000et\u0015-\\3\u0016\u0003e\u0002\"AO \u000e\u0003mR!\u0001P\u001f\u0002\t1\fgn\u001a\u0006\u0002}\u0005!!.\u0019<b\u0013\t\u00015H\u0001\u0004TiJLgnZ\u0001\u0015#V,W/Z*ju\u0016lU\r\u001e:jG:\u000bW.\u001a\u0011\u0002CI+\u0017/^3tiJ\u000bG/Z!oIF+X-^3US6,W*\u001a;sS\u000et\u0015-\\3\u0002EI+\u0017/^3tiJ\u000bG/Z!oIF+X-^3US6,W*\u001a;sS\u000et\u0015-\\3!\u0003\u0005*f\u000e[3bYRD\u0017P\u0011:pW\u0016\u00148\u000b[;uI><h.T3ue&\u001cg*Y7f\u0003\t*f\u000e[3bYRD\u0017P\u0011:pW\u0016\u00148\u000b[;uI><h.T3ue&\u001cg*Y7fA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*\u0012\u0001\u0013\u0016\u0003\u0013Z\u00032\u0001\r&M\u0013\tY\u0015G\u0001\u0004PaRLwN\u001c\t\u0003\u001bRs!A\u0014*\u0011\u0005=\u000bT\"\u0001)\u000b\u0005ES\u0013A\u0002\u001fs_>$h(\u0003\u0002Tc\u00051\u0001K]3eK\u001aL!\u0001Q+\u000b\u0005M\u000b4&A,\u0011\u0005akV\"A-\u000b\u0005i[\u0016!C;oG\",7m[3e\u0015\ta\u0016'\u0001\u0006b]:|G/\u0019;j_:L!AX-\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWm\u0005\u0003\u000b_\u00014\u0007CA1e\u001b\u0005\u0011'BA2)\u0003\u0015)H/\u001b7t\u0013\t)'MA\u0004M_\u001e<\u0017N\\4\u0011\u0005\u001dTW\"\u00015\u000b\u0005%D\u0013aB7fiJL7m]\u0005\u0003W\"\u0014\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003E\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\t\u0003Y9L!a\u001c\u0014\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH/\u0001\u0004d_:4\u0017n\u001a\t\u0003eVl\u0011a\u001d\u0006\u0003i\"\naa]3sm\u0016\u0014\u0018B\u0001<t\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\tQLW.\u001a\t\u0004s\u0006\u0015Q\"\u0001>\u000b\u0005\r\\(B\u0001?~\u0003\u0019\u0019w.\\7p]*\u0011\u0011F \u0006\u0004\u007f\u0006\u0005\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u0004\u0005\u0019qN]4\n\u0007\u0005\u001d!P\u0001\u0003US6,\u0007\u0003BA\u0006\u0003\u001fi!!!\u0004\u000b\u0005%\\\u0018\u0002BA\t\u0003\u001b\u0011q!T3ue&\u001c7/A\tti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\u00042\u0001LA\f\u0013\r\tIB\n\u0002\u0012'R\fG/Z\"iC:<W\rT8hO\u0016\u0014\u0018\u0001\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y)9\ty\"!\t\u0002$\u0005\u0015\u0012qEA\u0015\u0003W\u0001\"\u0001\f\u0006\t\u000b1\f\u0002\u0019A7\t\u000bA\f\u0002\u0019A9\t\u000b]\f\u0002\u0019\u0001=\t\r%\f\u0002\u0019AA\u0005\u0011\u001d\t\u0019\"\u0005a\u0001\u0003+A\u0001\"a\u0007\u0012!\u0003\u0005\r!S\u0001\u0010EJ|7.\u001a:Ti\u0006$X-\u00138g_V\u0011\u0011\u0011\u0007\t\t\u0003g\ti$!\u0011\u0002H5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$A\u0004nkR\f'\r\\3\u000b\u0007\u0005m\u0012'\u0001\u0006d_2dWm\u0019;j_:LA!a\u0010\u00026\t9\u0001*Y:i\u001b\u0006\u0004\bc\u0001\u0019\u0002D%\u0019\u0011QI\u0019\u0003\u0007%sG\u000fE\u0002-\u0003\u0013J1!a\u0013'\u0005e\u0019uN\u001c;s_2dWM\u001d\"s_.,'o\u0015;bi\u0016LeNZ8\u0002!\t\u0014xn[3s'R\fG/Z%oM>\u0004\u0013A\u00032s_.,'\u000fT8dWV\u0011\u00111\u000b\t\u0004u\u0005U\u0013bAA,w\t1qJ\u00196fGR\f1B\u0019:pW\u0016\u0014Hj\\2lA\u0005\u0011RO\u001c5fC2$\b.\u001f\"s_.,'/T1q+\t\ty\u0006\u0005\u0005\u00024\u0005\u0005\u0014\u0011IA3\u0013\u0011\t\u0019'!\u000e\u0003\u00075\u000b\u0007\u000fE\u0002-\u0003OJ1!!\u001b'\u0005=)f\u000e[3bYRD\u0017P\u0011:pW\u0016\u0014\u0018aE;oQ\u0016\fG\u000e\u001e5z\u0005J|7.\u001a:NCB\u0004\u0013aI2sK\u0006$X-\u00168iK\u0006dG\u000f[=Ce>\\WM]*ikR$wn\u001e8NKR\u0014\u0018n\u0019\u000b\u0007\u0003c\n9(a\u001f\u0011\u0007A\n\u0019(C\u0002\u0002vE\u0012A!\u00168ji\"9\u0011\u0011\u0010\rA\u0002\u0005\u0005\u0013\u0001\u00032s_.,'/\u00133\t\r\u0005u\u0004\u00041\u0001M\u0003\u0019\u0011\u0018mY6JI\u0006i2\r\\3b]V\u0003XK\u001c5fC2$\b.\u001f\"s_.,'/T3ue&\u001c7\u000f\u0006\u0002\u0002r\u0005)\u0013N\\2sK6,g\u000e^+oQ\u0016\fG\u000e\u001e5z\u0005J|7.\u001a:TQV$Hm\\<o\u0007>,h\u000e\u001e\u000b\u0005\u0003c\n9\tC\u0004\u0002zi\u0001\r!!\u0011\u0002\u000fM$\u0018M\u001d;va\u0006A1\u000f[;uI><h.\u0001\rtK:$7i\u001c8ue>dW*\u001a;bI\u0006$\u0018MQ1uG\"$\u0002\"!\u001d\u0002\u0012\u0006M\u0015Q\u0014\u0005\b\u0003sj\u0002\u0019AA!\u0011\u001d\t)*\ba\u0001\u0003/\u000bQAY1uG\"\u00042\u0001LAM\u0013\r\tYJ\n\u0002\u0015\u0007>tGO]8m\u001b\u0016$\u0018\rZ1uC\n\u000bGo\u00195\t\u0013\u0005}U\u0004%AA\u0002\u0005\u0005\u0016\u0001C2bY2\u0014\u0017mY6\u0011\u0013A\n\u0019+a&\u0002(\u0006E\u0014bAASc\tIa)\u001e8di&|gN\r\t\u0004Y\u0005%\u0016bAAVM\tQ2i\u001c8ue>dW*\u001a;bI\u0006$\u0018MQ1uG\"\u0014Vm];mi\u0006\u00113/\u001a8e\u0007>tGO]8m\u001b\u0016$\u0018\rZ1uC\n\u000bGo\u00195%I\u00164\u0017-\u001e7uIM*\"!!-+\u0007\u0005\u0005f+A\u0005bI\u0012\u0014%o\\6feR!\u0011\u0011OA\\\u0011\u001d\tIl\ba\u0001\u0003w\u000baA\u0019:pW\u0016\u0014\b\u0003BA_\u0003\u0007l!!a0\u000b\u0007\u0005\u0005\u0007&A\u0004dYV\u001cH/\u001a:\n\t\u0005\u0015\u0017q\u0018\u0002\u0007\u0005J|7.\u001a:\u0002\u0019I,Wn\u001c<f\u0005J|7.\u001a:\u0015\t\u0005E\u00141\u001a\u0005\b\u0003s\u0002\u0003\u0019AA!\u00031\tG\r\u001a(fo\n\u0013xn[3s)\u0011\t\t(!5\t\u000f\u0005e\u0016\u00051\u0001\u0002<\u0006\u0001\"M]8lKJlU\r\u001e:jGR\u000bwm\u001d\u000b\u0005\u0003/\fi\u000e\u0005\u0004\u0002Z\u0006m\u0017(O\u0007\u0003\u0003sIA!a\u0019\u0002:!9\u0011\u0011\u0010\u0012A\u0002\u0005\u0005\u0013\u0001\u0006:f[>4X-\u0012=jgRLgn\u001a\"s_.,'\u000f\u0006\u0003\u0002r\u0005\r\bbBAsG\u0001\u0007\u0011qI\u0001\fEJ|7.\u001a:Ti\u0006$X-\u0001\fti\u0006\u0014HOU3rk\u0016\u001cHoU3oIRC'/Z1e)\u0011\t\t(a;\t\u000f\u0005eD\u00051\u0001\u0002B\u0001")
public class ControllerChannelManager
implements KafkaMetricsGroup {
    private final ControllerContext controllerContext;
    private final KafkaConfig config;
    private final Time time;
    private final Metrics metrics;
    private final StateChangeLogger stateChangeLogger;
    private final Option<String> threadNamePrefix;
    private final HashMap<Object, ControllerBrokerStateInfo> brokerStateInfo;
    private final Object brokerLock;
    private final scala.collection.mutable.Map<Object, UnhealthyBroker> unhealthyBrokerMap;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public static String UnhealthyBrokerShutdownMetricName() {
        return ControllerChannelManager$.MODULE$.UnhealthyBrokerShutdownMetricName();
    }

    public static String RequestRateAndQueueTimeMetricName() {
        return ControllerChannelManager$.MODULE$.RequestRateAndQueueTimeMetricName();
    }

    public static String QueueSizeMetricName() {
        return ControllerChannelManager$.MODULE$.QueueSizeMetricName();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$(this, metricName, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$(this, metricName);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public HashMap<Object, ControllerBrokerStateInfo> brokerStateInfo() {
        return this.brokerStateInfo;
    }

    private Object brokerLock() {
        return this.brokerLock;
    }

    public scala.collection.mutable.Map<Object, UnhealthyBroker> unhealthyBrokerMap() {
        return this.unhealthyBrokerMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createUnhealthyBrokerShutdownMetric(int brokerId, String rackId) {
        String rackString = (String)Option$.MODULE$.apply((Object)rackId).getOrElse((Function0 & Serializable)() -> "");
        UnhealthyBroker unhealthyBroker = (UnhealthyBroker)this.unhealthyBrokerMap().apply((Object)BoxesRunTime.boxToInteger((int)brokerId));
        if (unhealthyBroker != null) {
            Object object = unhealthyBroker.shutdownTag().apply((Object)"rack-id");
            if (!(object == null ? rackString != null : !object.equals(rackString))) return;
            this.removeMetric(ControllerChannelManager$.MODULE$.UnhealthyBrokerShutdownMetricName(), (Map<String, String>)unhealthyBroker.shutdownTag());
        } else {
            unhealthyBroker = new UnhealthyBroker();
            this.unhealthyBrokerMap().update((Object)BoxesRunTime.boxToInteger((int)brokerId), (Object)unhealthyBroker);
        }
        unhealthyBroker.shutdownTag_$eq((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)Integer.toString(brokerId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rack-id"), (Object)rackString)}))));
        unhealthyBroker.meter_$eq(this.newMeter(ControllerChannelManager$.MODULE$.UnhealthyBrokerShutdownMetricName(), "requests", TimeUnit.SECONDS, (Map<String, String>)unhealthyBroker.shutdownTag()));
    }

    public void cleanUpUnhealthyBrokerMetrics() {
        this.unhealthyBrokerMap().foreach((Function1 & Serializable)x0$1 -> {
            ControllerChannelManager.$anonfun$cleanUpUnhealthyBrokerMetrics$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void incrementUnhealthyBrokerShutdownCount(int brokerId) {
        UnhealthyBroker unhealthyBroker = (UnhealthyBroker)this.unhealthyBrokerMap().apply((Object)BoxesRunTime.boxToInteger((int)brokerId));
        if (unhealthyBroker != null) {
            unhealthyBroker.meter().mark();
            return;
        }
    }

    public void startup() {
        this.controllerContext.liveOrShuttingDownBrokers().foreach((Function1 & Serializable)broker -> {
            this.addNewBroker(broker);
            return BoxedUnit.UNIT;
        });
        Object object = this.brokerLock();
        synchronized (object) {
            this.brokerStateInfo().foreach((Function1 & Serializable)brokerState -> {
                this.startRequestSendThread(brokerState._1$mcI$sp());
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void shutdown() {
        Object object = this.brokerLock();
        synchronized (object) {
            this.brokerStateInfo().values().toList().foreach((Function1 & Serializable)brokerState -> {
                this.removeExistingBroker(brokerState);
                return BoxedUnit.UNIT;
            });
            this.cleanUpUnhealthyBrokerMetrics();
            return;
        }
    }

    public void sendControlMetadataBatch(int brokerId, ControlMetadataBatch batch, Function2<ControlMetadataBatch, ControlMetadataBatchResult, BoxedUnit> callback) {
        Object object = this.brokerLock();
        synchronized (object) {
            Option stateInfoOpt = this.brokerStateInfo().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
            if (stateInfoOpt instanceof Some) {
                ((ControllerBrokerStateInfo)((Some)stateInfoOpt).value()).messageQueue().put(new QueueItem(batch, callback, this.time.milliseconds()));
            } else if (None$.MODULE$.equals(stateInfoOpt)) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Not sending batch ").append(batch).append(" to broker ").append(brokerId).append(", since it is offline.").toString());
            } else {
                throw new MatchError((Object)stateInfoOpt);
            }
            return;
        }
    }

    public Function2<ControlMetadataBatch, ControlMetadataBatchResult, BoxedUnit> sendControlMetadataBatch$default$3() {
        return null;
    }

    public void addBroker(Broker broker) {
        Object object = this.brokerLock();
        synchronized (object) {
            if (!this.brokerStateInfo().contains((Object)BoxesRunTime.boxToInteger((int)broker.id()))) {
                this.addNewBroker(broker);
                this.startRequestSendThread(broker.id());
            }
            return;
        }
    }

    public void removeBroker(int brokerId) {
        Object object = this.brokerLock();
        synchronized (object) {
            this.removeExistingBroker((ControllerBrokerStateInfo)this.brokerStateInfo().apply((Object)BoxesRunTime.boxToInteger((int)brokerId)));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addNewBroker(Broker broker) {
        void var11_16;
        void var10_15;
        String string;
        void var8_13;
        None$ none$;
        void clientChannelBuilder_saslHandshakeRequestEnable;
        void clientChannelBuilder_time;
        void clientChannelBuilder_clientSaslMechanism;
        void clientChannelBuilder_config;
        ControlMetadataAccumulator messageQueue = new ControlMetadataAccumulator();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Controller ").append($this.config.brokerId()).append(" trying to connect to broker ").append(broker.id()).toString());
        ListenerName controllerToBrokerListenerName = (ListenerName)this.config.controlPlaneListenerName().getOrElse((Function0 & Serializable)() -> $this.config.interBrokerListenerName());
        SecurityProtocol controllerToBrokerSecurityProtocol = (SecurityProtocol)this.config.controlPlaneSecurityProtocol().getOrElse((Function0 & Serializable)() -> $this.config.interBrokerSecurityProtocol());
        Node brokerNode = broker.node(controllerToBrokerListenerName);
        LogContext logContext = new LogContext(new StringBuilder(34).append("[Controller id=").append(this.config.brokerId()).append(", targetBrokerId=").append(brokerNode.idString()).append("] ").toString());
        boolean bl = this.config.saslInterBrokerHandshakeRequestEnable();
        Time time = this.time;
        String string2 = this.config.saslMechanismInterBrokerProtocol();
        KafkaConfig kafkaConfig = this.config;
        JaasContext.Type clientChannelBuilder_contextType = JaasContext.Type.SERVER;
        Object var18_11 = null;
        kafkaConfig = null;
        string2 = null;
        time = null;
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)controllerToBrokerSecurityProtocol, (JaasContext.Type)clientChannelBuilder_contextType, (AbstractConfig)clientChannelBuilder_config, (ListenerName)controllerToBrokerListenerName, (String)clientChannelBuilder_clientSaslMechanism, (Time)clientChannelBuilder_time, (boolean)clientChannelBuilder_saslHandshakeRequestEnable, (LogContext)logContext, null);
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
            none$ = new Some((Object)channelBuilder);
        } else {
            none$ = None$.MODULE$;
        }
        None$ reconfigurableChannelBuilder = none$;
        Selector selector = new Selector(-1, -1L, this.metrics, this.time, "controller-channel", CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)brokerNode.idString())}))).asJava(), false, channelBuilder, logContext);
        NetworkClient networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)brokerNode, (List)Nil$.MODULE$)).asJava()), Integer.toString(this.config.brokerId()), 1, 0L, 0L, -1, -1, Predef$.MODULE$.Integer2int(this.config.requestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, false, new ApiVersions(), logContext);
        Option reconfigurableChannelBuilder2 = (Option)var8_13;
        Option<String> option = this.threadNamePrefix;
        if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(34).append("Controller-").append(this.config.brokerId()).append("-to-broker-").append(broker.id()).append("-send-thread").toString();
        } else if (option instanceof Some) {
            String name = (String)((Some)option).value();
            string = new StringBuilder(35).append(name).append(":Controller-").append(this.config.brokerId()).append("-to-broker-").append(broker.id()).append("-send-thread").toString();
        } else {
            throw new MatchError(option);
        }
        String threadName = string;
        Timer requestRateAndQueueTimeMetrics = this.newTimer(ControllerChannelManager$.MODULE$.RequestRateAndQueueTimeMetricName(), TimeUnit.MILLISECONDS, TimeUnit.SECONDS, this.brokerMetricTags(broker.id()));
        RequestSendThread requestThread = new RequestSendThread(this.config.brokerId(), this.controllerContext, messageQueue, (NetworkClient)var10_15, brokerNode, this.config, this.time, requestRateAndQueueTimeMetrics, this.stateChangeLogger, threadName);
        requestThread.setDaemon(false);
        Gauge<Object> queueSizeGauge = this.newGauge(ControllerChannelManager$.MODULE$.QueueSizeMetricName(), new Gauge<Object>(this, messageQueue){
            private final /* synthetic */ ControllerChannelManager $outer;
            private final ControlMetadataAccumulator messageQueue$1;

            public final int value() {
                return this.messageQueue$1.size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.messageQueue$1 = messageQueue$1;
            }
        }, this.brokerMetricTags(broker.id()));
        this.brokerStateInfo().put((Object)BoxesRunTime.boxToInteger((int)broker.id()), (Object)new ControllerBrokerStateInfo((NetworkClient)var10_15, brokerNode, messageQueue, requestThread, queueSizeGauge, requestRateAndQueueTimeMetrics, (Option<Reconfigurable>)var11_16));
        this.createUnhealthyBrokerShutdownMetric(brokerNode.id(), brokerNode.rack());
    }

    private Map<String, String> brokerMetricTags(int brokerId) {
        return (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)Integer.toString(brokerId))}));
    }

    public void removeExistingBroker(ControllerBrokerStateInfo brokerState) {
        try {
            brokerState.reconfigurableChannelBuilder().foreach((Function1 & Serializable)reconfigurable -> {
                this.config.removeReconfigurable(reconfigurable);
                return BoxedUnit.UNIT;
            });
            brokerState.requestSendThread().shutdown();
            brokerState.networkClient().close();
            brokerState.messageQueue().close();
            this.removeMetric(ControllerChannelManager$.MODULE$.QueueSizeMetricName(), this.brokerMetricTags(brokerState.brokerNode().id()));
            this.removeMetric(ControllerChannelManager$.MODULE$.RequestRateAndQueueTimeMetricName(), this.brokerMetricTags(brokerState.brokerNode().id()));
            this.brokerStateInfo().remove((Object)BoxesRunTime.boxToInteger((int)brokerState.brokerNode().id()));
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Error while removing broker by the controller", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public void startRequestSendThread(int brokerId) {
        block7: {
            RequestSendThread requestThread;
            block6: {
                Thread.State state;
                Thread.State state2;
                block5: {
                    requestThread = ((ControllerBrokerStateInfo)this.brokerStateInfo().apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).requestSendThread();
                    state2 = requestThread.getState();
                    state = Thread.State.NEW;
                    if (state2 != null) break block5;
                    if (state != null) {
                        return;
                    }
                    break block6;
                }
                if (!((Object)((Object)state2)).equals((Object)state)) break block7;
            }
            requestThread.start();
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$new$2(ControllerBrokerStateInfo x$1) {
        return x$1.messageQueue().size();
    }

    public final /* synthetic */ int kafka$controller$ControllerChannelManager$$$anonfun$new$1() {
        Object object = this.brokerLock();
        synchronized (object) {
            int n = BoxesRunTime.unboxToInt((Object)this.brokerStateInfo().values().iterator().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ControllerChannelManager.$anonfun$new$2(x$1))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            return n;
        }
    }

    public static final /* synthetic */ void $anonfun$cleanUpUnhealthyBrokerMetrics$1(ControllerChannelManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            UnhealthyBroker unhealthyBroker = (UnhealthyBroker)x0$1._2();
            $this.removeMetric(ControllerChannelManager$.MODULE$.UnhealthyBrokerShutdownMetricName(), (Map<String, String>)unhealthyBroker.shutdownTag());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int kafka$controller$ControllerChannelManager$$$anonfun$addNewBroker$4(ControlMetadataAccumulator messageQueue$1) {
        return messageQueue$1.size();
    }

    public ControllerChannelManager(ControllerContext controllerContext, KafkaConfig config, Time time, Metrics metrics, StateChangeLogger stateChangeLogger, Option<String> threadNamePrefix) {
        this.controllerContext = controllerContext;
        this.config = config;
        this.time = time;
        this.metrics = metrics;
        this.stateChangeLogger = stateChangeLogger;
        this.threadNamePrefix = threadNamePrefix;
        this.brokerStateInfo = new HashMap();
        this.brokerLock = new Object();
        this.logIdent_$eq(new StringBuilder(34).append("[Channel manager on controller ").append(config.brokerId()).append("]: ").toString());
        this.newGauge("TotalQueueSize", new Gauge<Object>(this){
            private final /* synthetic */ ControllerChannelManager $outer;

            public final int value() {
                return this.$outer.kafka$controller$ControllerChannelManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.unhealthyBrokerMap = ((scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)).withDefaultValue(null);
    }
}

