/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import kafka.controller.ControlMetadataAccumulator;
import kafka.controller.ControlMetadataBatch;
import kafka.controller.ControlMetadataBatchResult;
import kafka.controller.ControllerContext;
import kafka.controller.QueueItem;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractControlResponse;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\rc\u0001\u0002\u000e\u001c\u0001\u0001B\u0001b\n\u0001\u0003\u0006\u0004%\t\u0001\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005S!A\u0001\u0007\u0001BC\u0002\u0013\u0005\u0011\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00033\u0011!9\u0004A!b\u0001\n\u0003A\u0004\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011u\u0002!Q1A\u0005\u0002yB\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0017\u0002\u0011)\u0019!C\u0001\u0019\"A1\u000b\u0001B\u0001B\u0003%Q\n\u0003\u0005U\u0001\t\u0015\r\u0011\"\u0001V\u0011!a\u0006A!A!\u0002\u00131\u0006\u0002C/\u0001\u0005\u000b\u0007I\u0011\u00010\t\u0011\u0011\u0004!\u0011!Q\u0001\n}C\u0001\"\u001a\u0001\u0003\u0006\u0004%\tA\u001a\u0005\tg\u0002\u0011\t\u0011)A\u0005O\"AA\u000f\u0001BC\u0002\u0013\u0005Q\u000f\u0003\u0005z\u0001\t\u0005\t\u0015!\u0003w\u0011)Q\bA!A!\u0002\u0013Y\u0018Q\u0002\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0011!\tI\u0003\u0001b\u0001\n\u0013A\u0003bBA\u0016\u0001\u0001\u0006I!\u000b\u0005\b\u0003[\u0001A\u0011IA\u0018\u0011\u001d\t9\u0004\u0001C\u0005\u0003sAq!!\u0011\u0001\t\u0003\nIDA\tSKF,Xm\u001d;TK:$G\u000b\u001b:fC\u0012T!\u0001H\u000f\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u001f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011j\u0012!B;uS2\u001c\u0018B\u0001\u0014$\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u0002\u0019\r|g\u000e\u001e:pY2,'/\u00133\u0016\u0003%\u0002\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u00121!\u00138u\u00035\u0019wN\u001c;s_2dWM]%eA\u0005\t2m\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0016\u0003I\u0002\"a\r\u001b\u000e\u0003mI!!N\u000e\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH/\u0001\nd_:$(o\u001c7mKJ\u001cuN\u001c;fqR\u0004\u0013!B9vKV,W#A\u001d\u0011\u0005MR\u0014BA\u001e\u001c\u0005i\u0019uN\u001c;s_2lU\r^1eCR\f\u0017iY2v[Vd\u0017\r^8s\u0003\u0019\tX/Z;fA\u0005ia.\u001a;x_J\\7\t\\5f]R,\u0012a\u0010\t\u0003\u0001\"k\u0011!\u0011\u0006\u0003\u0005\u000e\u000bqa\u00197jK:$8O\u0003\u0002\u001f\t*\u0011QIR\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\u000b1a\u001c:h\u0013\tI\u0015IA\u0007OKR<xN]6DY&,g\u000e^\u0001\u000f]\u0016$xo\u001c:l\u00072LWM\u001c;!\u0003)\u0011'o\\6fe:{G-Z\u000b\u0002\u001bB\u0011a*U\u0007\u0002\u001f*\u0011\u0001kQ\u0001\u0007G>lWn\u001c8\n\u0005I{%\u0001\u0002(pI\u0016\f1B\u0019:pW\u0016\u0014hj\u001c3fA\u000511m\u001c8gS\u001e,\u0012A\u0016\t\u0003/jk\u0011\u0001\u0017\u0006\u00033v\taa]3sm\u0016\u0014\u0018BA.Y\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005!A/[7f+\u0005y\u0006C\u00011c\u001b\u0005\t'B\u0001\u0013P\u0013\t\u0019\u0017M\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013A\b:fcV,7\u000f\u001e*bi\u0016\fe\u000eZ)vKV,G+[7f\u001b\u0016$(/[2t+\u00059\u0007C\u00015r\u001b\u0005I'B\u00016l\u0003\u0011\u0019wN]3\u000b\u00051l\u0017aB7fiJL7m\u001d\u0006\u0003]>\fa!_1n[\u0016\u0014(\"\u00019\u0002\u0007\r|W.\u0003\u0002sS\n)A+[7fe\u0006y\"/Z9vKN$(+\u0019;f\u0003:$\u0017+^3vKRKW.Z'fiJL7m\u001d\u0011\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/F\u0001w!\t\u0019t/\u0003\u0002y7\t\t2\u000b^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0002%M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'\u000fI\u0001\u0005]\u0006lW\rE\u0002}\u0003\u000fq1!`A\u0002!\tq8&D\u0001\u0000\u0015\r\t\taH\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u00151&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0013\tYA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000bY\u0013B\u0001>&\u0003\u0019a\u0014N\\5u}Q1\u00121CA\u000b\u0003/\tI\"a\u0007\u0002\u001e\u0005}\u0011\u0011EA\u0012\u0003K\t9\u0003\u0005\u00024\u0001!)q\u0005\u0006a\u0001S!)\u0001\u0007\u0006a\u0001e!)q\u0007\u0006a\u0001s!)Q\b\u0006a\u0001\u007f!)1\n\u0006a\u0001\u001b\")A\u000b\u0006a\u0001-\")Q\f\u0006a\u0001?\")Q\r\u0006a\u0001O\")A\u000f\u0006a\u0001m\")!\u0010\u0006a\u0001w\u0006y1o\\2lKR$\u0016.\\3pkRl5/\u0001\tt_\u000e\\W\r\u001e+j[\u0016|W\u000f^'tA\u00051Am\\,pe.$\"!!\r\u0011\u0007)\n\u0019$C\u0002\u00026-\u0012A!\u00168ji\u0006Y!M]8lKJ\u0014V-\u00193z)\t\tY\u0004E\u0002+\u0003{I1!a\u0010,\u0005\u001d\u0011un\u001c7fC:\f\u0001#\u001b8ji&\fG/Z*ikR$wn\u001e8")
public class RequestSendThread
extends ShutdownableThread {
    private final int controllerId;
    private final ControllerContext controllerContext;
    private final ControlMetadataAccumulator queue;
    private final NetworkClient networkClient;
    private final Node brokerNode;
    private final KafkaConfig config;
    private final Time time;
    private final Timer requestRateAndQueueTimeMetrics;
    private final StateChangeLogger stateChangeLogger;
    private final int socketTimeoutMs;

    public int controllerId() {
        return this.controllerId;
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public ControlMetadataAccumulator queue() {
        return this.queue;
    }

    public NetworkClient networkClient() {
        return this.networkClient;
    }

    public Node brokerNode() {
        return this.brokerNode;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Time time() {
        return this.time;
    }

    public Timer requestRateAndQueueTimeMetrics() {
        return this.requestRateAndQueueTimeMetrics;
    }

    public StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private int socketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doWork() {
        void var3_3;
        void var2_2;
        QueueItem item = this.queue().take();
        if (item == null) {
            return;
        }
        ControlMetadataBatch batch = item.batch();
        Function2<ControlMetadataBatch, ControlMetadataBatchResult, BoxedUnit> callback = item.callback();
        long l = item.enqueueTimeMs();
        this.requestRateAndQueueTimeMetrics().update(this.time().milliseconds() - l, TimeUnit.MILLISECONDS);
        ArrayBuffer responses = ArrayBuffer$.MODULE$.empty();
        var2_2.requests(this.stateChangeLogger()).foreach((Function1 & Serializable)requestBuilder -> {
            RequestSendThread.$anonfun$doWork$1(this, responses, requestBuilder);
            return BoxedUnit.UNIT;
        });
        if (var3_3 != null) {
            var3_3.apply((Object)var2_2, (Object)new ControlMetadataBatchResult((Seq<AbstractControlResponse>)responses));
            return;
        }
    }

    private boolean brokerReady() {
        try {
            if (!NetworkClientUtils.isReady((KafkaClient)this.networkClient(), (Node)this.brokerNode(), (long)this.time().milliseconds())) {
                if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)this.brokerNode(), (Time)this.time(), (long)this.socketTimeoutMs())) {
                    throw new SocketTimeoutException(new StringBuilder(28).append("Failed to connect within ").append(this.socketTimeoutMs()).append(" ms").toString());
                }
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("Controller ").append(this.controllerId()).append(" connected to ").append(this.brokerNode()).append(" for sending state change requests").toString());
            }
            return true;
        }
        catch (Throwable e) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Controller ").append(this.controllerId()).append("'s connection to broker ").append(this.brokerNode()).append(" was unsuccessful").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.networkClient().close(this.brokerNode().idString());
            return false;
        }
    }

    @Override
    public boolean initiateShutdown() {
        if (super.initiateShutdown()) {
            this.networkClient().initiateClose();
            return true;
        }
        return false;
    }

    private final void backoff$1() {
        this.pause(100L, TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ void $anonfun$doWork$1(RequestSendThread $this, ArrayBuffer responses$1, AbstractControlRequest.Builder requestBuilder) {
        ClientResponse clientResponse = null;
        try {
            boolean isSendSuccessful = false;
            while ($this.isRunning() && !isSendSuccessful) {
                try {
                    if (!$this.brokerReady()) {
                        isSendSuccessful = false;
                        $this.pause(100L, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    ClientRequest clientRequest = $this.networkClient().newClientRequest($this.brokerNode().idString(), (AbstractRequest.Builder)requestBuilder, $this.time().milliseconds(), true);
                    clientResponse = NetworkClientUtils.sendAndReceive((KafkaClient)$this.networkClient(), (ClientRequest)clientRequest, (Time)$this.time());
                    isSendSuccessful = true;
                }
                catch (Throwable e) {
                    $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Controller ").append($this.controllerId()).append(" epoch ").append($this.controllerContext().epoch()).append(" fails to send request ").append(requestBuilder).append(" ").append("to broker ").append($this.brokerNode()).append(". Reconnecting to broker.").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    $this.networkClient().close($this.brokerNode().idString());
                    isSendSuccessful = false;
                    $this.pause(100L, TimeUnit.MILLISECONDS);
                }
            }
            if (clientResponse != null) {
                ApiKeys api;
                RequestHeader requestHeader = clientResponse.requestHeader();
                ApiKeys apiKeys = api = requestHeader.apiKey();
                ApiKeys apiKeys2 = ApiKeys.LEADER_AND_ISR;
                if (apiKeys == null ? apiKeys2 != null : !apiKeys.equals(apiKeys2)) {
                    ApiKeys apiKeys3 = api;
                    ApiKeys apiKeys4 = ApiKeys.STOP_REPLICA;
                    if (apiKeys3 == null ? apiKeys4 != null : !apiKeys3.equals(apiKeys4)) {
                        ApiKeys apiKeys5 = api;
                        ApiKeys apiKeys6 = ApiKeys.UPDATE_METADATA;
                        if (apiKeys5 == null ? apiKeys6 != null : !apiKeys5.equals(apiKeys6)) {
                            throw new KafkaException(new StringBuilder(28).append("Unexpected apiKey received: ").append(requestBuilder.apiKey()).toString());
                        }
                    }
                }
                AbstractControlResponse response = (AbstractControlResponse)clientResponse.responseBody();
                responses$1.$plus$eq((Object)response);
                $this.stateChangeLogger().withControllerEpoch($this.controllerContext().epoch()).trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Received response ").append(response).append(" for request ").append(api).append(" with correlation id ").append(requestHeader.correlationId()).append(" sent to broker ").append($this.brokerNode()).toString());
            }
        }
        catch (Throwable e) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Controller ").append($this.controllerId()).append(" fails to send a request to broker ").append($this.brokerNode()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            $this.networkClient().close($this.brokerNode().idString());
        }
    }

    public RequestSendThread(int controllerId, ControllerContext controllerContext, ControlMetadataAccumulator queue, NetworkClient networkClient, Node brokerNode, KafkaConfig config, Time time, Timer requestRateAndQueueTimeMetrics, StateChangeLogger stateChangeLogger, String name) {
        this.controllerId = controllerId;
        this.controllerContext = controllerContext;
        this.queue = queue;
        this.networkClient = networkClient;
        this.brokerNode = brokerNode;
        this.config = config;
        this.time = time;
        this.requestRateAndQueueTimeMetrics = requestRateAndQueueTimeMetrics;
        this.stateChangeLogger = stateChangeLogger;
        super(name, true);
        this.logIdent_$eq(new StringBuilder(34).append("[RequestSendThread controllerId=").append(controllerId).append("] ").toString());
        this.socketTimeoutMs = config.controllerSocketTimeoutMs();
    }
}

