/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import com.typesafe.scalalogging.Logger;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.coordinator.quota.ComputedQuotasCacheEntry;
import kafka.coordinator.quota.QuotaCoordinatorConfig;
import kafka.coordinator.quota.QuotaCoordinatorConfig$;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntityCoordinatorEpoch;
import kafka.coordinator.quota.QuotaEntry;
import kafka.coordinator.quota.QuotaStateManager$;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin$Coordinator$;
import kafka.log.LogConfig;
import kafka.server.AbstractFetchDataInfo;
import kafka.server.FetchDataInfo;
import kafka.server.FetchLogEnd$;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Scheduler;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0015r!B$I\u0011\u0003ye!B)I\u0011\u0003\u0011\u0006\"B-\u0002\t\u0003Q\u0006bB.\u0002\u0005\u0004%\t\u0001\u0018\u0005\u0007Q\u0006\u0001\u000b\u0011B/\t\u000f%\f!\u0019!C\u00019\"1!.\u0001Q\u0001\nuCQa[\u0001\u0005\u00021DQA_\u0001\u0005\u0002mDq!a\u0003\u0002\t\u0003\ti\u0001C\u0004\u0002\u001e\u0005!\t!a\b\u0007\r\u0005\u0015\u0012\u0001AA\u0014\u0011\u0019I6\u0002\"\u0001\u0002L!9\u0011\u0011K\u0006\u0005\u0002\u0005M\u0003bBA@\u0003\u0011\u0005\u0011\u0011\u0011\u0004\u0006#\"\u0003\u0011\u0011\u0014\u0005\u000b\u0003O{!\u0011!Q\u0001\n\u0005%\u0006BCAX\u001f\t\u0005\t\u0015!\u0003\u00022\"Q\u0011qW\b\u0003\u0002\u0003\u0006I!!/\t\u0015\u0005\u0015wB!A!\u0002\u0013\t9\r\u0003\u0006\u0002R>\u0011\t\u0011)A\u0005\u0003'Da!W\b\u0005\u0002\u0005u\u0007\"CAv\u001f\t\u0007I\u0011BAw\u0011!\u0011Ya\u0004Q\u0001\n\u0005=\b\"\u0003B\u0007\u001f\t\u0007I\u0011\u0002B\b\u0011!\u00119b\u0004Q\u0001\n\tE\u0001b\u0003B\r\u001f\u0001\u0007\t\u0019!C\u0005\u00057A1B!\b\u0010\u0001\u0004\u0005\r\u0011\"\u0003\u0003 !Y!QE\bA\u0002\u0003\u0005\u000b\u0015BA\u0000\u0011%\u0011yc\u0004b\u0001\n\u0013\u0011\t\u0004\u0003\u0005\u0003H=\u0001\u000b\u0011\u0002B\u001a\u0011%\u0011Ie\u0004b\u0001\n\u0013\u0011Y\u0005\u0003\u0005\u0003T=\u0001\u000b\u0011\u0002B'\u0011%\u0011)f\u0004b\u0001\n\u0013\u0011Y\u0005\u0003\u0005\u0003X=\u0001\u000b\u0011\u0002B'\u0011%\u0011If\u0004b\u0001\n\u0013\u0011Y\u0005\u0003\u0005\u0003\\=\u0001\u000b\u0011\u0002B'\u0011%\u0011if\u0004b\u0001\n\u0013\u0011y\u0006\u0003\u0005\u0003n=\u0001\u000b\u0011\u0002B1\u0011%\u0011yg\u0004b\u0001\n\u0013\u0011\t\b\u0003\u0005\u0003\u0002>\u0001\u000b\u0011\u0002B:\u0011%\u0011\u0019i\u0004b\u0001\n\u0013\u0011)\t\u0003\u0005\u0003\u000e>\u0001\u000b\u0011\u0002BD\u0011\u001d\u0011yi\u0004C\u0001\u0005#CqA!*\u0010\t\u0003\u00119\u000bC\u0004\u00032>!\tAa-\t\u000f\t]v\u0002\"\u0001\u0003:\"9!QX\b\u0005\u0002\t}\u0006b\u0002Bb\u001f\u0011\u0005!Q\u0019\u0005\b\u0005\u001f|A\u0011\u0002Bi\u0011!\u0011Io\u0004C\u0001\u0011\n-\b\u0002\u0003By\u001f\u0011\u0005\u0001Ja=\t\u0011\t]x\u0002\"\u0001I\u0005sDqA!@\u0010\t\u0013\u0011y\u0010C\u0004\u0004\n=!\taa\u0003\t\u000f\rUq\u0002\"\u0003\u0004\u0018!91QD\b\u0005\u0002\r}\u0001\"CB(\u001fE\u0005I\u0011AB)\u0011\u001d\u00199g\u0004C\u0005\u0007SBqaa\u001c\u0010\t\u0013\u0019\t\bC\u0004\u00040>!Ia!-\t\u000f\rmv\u0002\"\u0003\u0004>\"91\u0011[\b\u0005\n\rM\u0007bBBp\u001f\u0011%1\u0011\u001d\u0005\b\u0007c|A\u0011BBz\u0011\u001d\u0019Yp\u0004C\u0005\u0007{Dqaa@\u0010\t\u0013\u0019i\u0010C\u0004\u0005\u0002=!\t\u0001b\u0001\t\u000f\u0011\u001dq\u0002\"\u0001\u0005\n!9A1D\b\u0005\u0002\ru\bb\u0002C\u000f\u001f\u0011\u0005AqD\u0001\u0012#V|G/Y*uCR,W*\u00198bO\u0016\u0014(BA%K\u0003\u0015\tXo\u001c;b\u0015\tYE*A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A'\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001+A\u0007\u0002\u0011\n\t\u0012+^8uCN#\u0018\r^3NC:\fw-\u001a:\u0014\u0005\u0005\u0019\u0006C\u0001+X\u001b\u0005)&\"\u0001,\u0002\u000bM\u001c\u0017\r\\1\n\u0005a+&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u001f\u0006aQ*\u001a;sS\u000e\u001cxI]8vaV\tQ\f\u0005\u0002_K:\u0011ql\u0019\t\u0003AVk\u0011!\u0019\u0006\u0003E:\u000ba\u0001\u0010:p_Rt\u0014B\u00013V\u0003\u0019\u0001&/\u001a3fM&\u0011am\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011,\u0016!D'fiJL7m]$s_V\u0004\b%\u0001\bM_\u0006$G+[7f'\u0016t7o\u001c:\u0002\u001f1{\u0017\r\u001a+j[\u0016\u001cVM\\:pe\u0002\naB]3bI6+7o]1hK.+\u0017\u0010\u0006\u0002naB\u0011\u0001K\\\u0005\u0003_\"\u00131\"U;pi\u0006,e\u000e^5us\")\u0011o\u0002a\u0001e\u00061!-\u001e4gKJ\u0004\"a\u001d=\u000e\u0003QT!!\u001e<\u0002\u00079LwNC\u0001x\u0003\u0011Q\u0017M^1\n\u0005e$(A\u0003\"zi\u0016\u0014UO\u001a4fe\u0006\u0001\"/Z1e\u001b\u0016\u001c8/Y4f-\u0006dW/\u001a\u000b\u0006y\u0006\u0015\u0011\u0011\u0002\t\u0004)v|\u0018B\u0001@V\u0005\u0019y\u0005\u000f^5p]B\u0019\u0001+!\u0001\n\u0007\u0005\r\u0001J\u0001\u0006Rk>$\u0018-\u00128uefDa!a\u0002\t\u0001\u0004i\u0017aC9v_R\fWI\u001c;jifDQ!\u001d\u0005A\u0002I\fQ\"];pi\u0006,e\u000e\u001e:z\u0017\u0016LH\u0003BA\b\u00037\u0001R\u0001VA\t\u0003+I1!a\u0005V\u0005\u0015\t%O]1z!\r!\u0016qC\u0005\u0004\u00033)&\u0001\u0002\"zi\u0016Da!a\u0002\n\u0001\u0004i\u0017aD9v_R\fWI\u001c;ssZ\u000bG.^3\u0015\t\u0005=\u0011\u0011\u0005\u0005\u0007\u0003GQ\u0001\u0019A@\u0002\u0015E,x\u000e^1F]R\u0014\u0018P\u0001\u000eRk>$\u0018-\u00128ueflUm]:bO\u00164uN]7biR,'oE\u0003\f\u0003S\t)\u0004\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r\tyC^\u0001\u0005Y\u0006tw-\u0003\u0003\u00024\u00055\"AB(cU\u0016\u001cG\u000f\u0005\u0003\u00028\u0005\u001dSBAA\u001d\u0015\u0011\tY$!\u0010\u0002\r\r|W.\\8o\u0015\ri\u0015q\b\u0006\u0005\u0003\u0003\n\u0019%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u000b\n1a\u001c:h\u0013\u0011\tI%!\u000f\u0003!5+7o]1hK\u001a{'/\\1ui\u0016\u0014HCAA'!\r\tyeC\u0007\u0002\u0003\u00059qO]5uKR{GCBA+\u00037\ny\u0007E\u0002U\u0003/J1!!\u0017V\u0005\u0011)f.\u001b;\t\u000f\u0005uS\u00021\u0001\u0002`\u0005q1m\u001c8tk6,'OU3d_J$\u0007\u0003CA1\u0003W\ny!a\u0004\u000e\u0005\u0005\r$\u0002BA3\u0003O\n\u0001bY8ogVlWM\u001d\u0006\u0005\u0003S\ni$A\u0004dY&,g\u000e^:\n\t\u00055\u00141\r\u0002\u000f\u0007>t7/^7feJ+7m\u001c:e\u0011\u001d\t\t(\u0004a\u0001\u0003g\naa\\;uaV$\b\u0003BA;\u0003wj!!a\u001e\u000b\u0007\u0005ed/\u0001\u0002j_&!\u0011QPA<\u0005-\u0001&/\u001b8u'R\u0014X-Y7\u0002/\u0019|'/\\1u%\u0016\u001cwN\u001d3LKf\fe\u000e\u001a,bYV,G\u0003BAB\u0003\u0017\u0003r\u0001VAC\u0003\u0013\u000bI)C\u0002\u0002\bV\u0013a\u0001V;qY\u0016\u0014\u0004c\u0001+~;\"9\u0011Q\u0012\bA\u0002\u0005=\u0015A\u0002:fG>\u0014H\r\u0005\u0003\u0002\u0012\u0006UUBAAJ\u0015\u0011\ti)!\u000f\n\t\u0005]\u00151\u0013\u0002\u0007%\u0016\u001cwN\u001d3\u0014\t=\u0019\u00161\u0014\t\u0005\u0003;\u000b\u0019+\u0004\u0002\u0002 *\u0019\u0011\u0011\u0015'\u0002\u000bU$\u0018\u000e\\:\n\t\u0005\u0015\u0016q\u0014\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jOB\u0019\u0001+a+\n\u0007\u00055\u0006J\u0001\fRk>$\u0018mQ8pe\u0012Lg.\u0019;pe\u000e{gNZ5h\u0003%\u00198\r[3ek2,'\u000f\u0005\u0003\u0002\u001e\u0006M\u0016\u0002BA[\u0003?\u0013\u0011bU2iK\u0012,H.\u001a:\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB!\u00111XAa\u001b\t\tiLC\u0002\u0002@2\u000baa]3sm\u0016\u0014\u0018\u0002BAb\u0003{\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'/A\u0004nKR\u0014\u0018nY:\u0011\t\u0005%\u0017QZ\u0007\u0003\u0003\u0017TA!!2\u0002:%!\u0011qZAf\u0005\u001diU\r\u001e:jGN\fA\u0001^5nKB!\u0011Q[Am\u001b\t\t9N\u0003\u0003\u0002\"\u0006e\u0012\u0002BAn\u0003/\u0014A\u0001V5nKRa\u0011q\\Aq\u0003G\f)/a:\u0002jB\u0011\u0001k\u0004\u0005\b\u0003O+\u0002\u0019AAU\u0011\u001d\ty+\u0006a\u0001\u0003cCq!a.\u0016\u0001\u0004\tI\fC\u0004\u0002FV\u0001\r!a2\t\u000f\u0005EW\u00031\u0001\u0002T\u0006\u00192m\\7qkR,G-U;pi\u0006\u001c8)Y2iKV\u0011\u0011q\u001e\t\t\u0003c\fY0a@\u0003\u00065\u0011\u00111\u001f\u0006\u0005\u0003k\f90A\u0004nkR\f'\r\\3\u000b\u0007\u0005eX+\u0001\u0006d_2dWm\u0019;j_:LA!!@\u0002t\n\u0019Q*\u00199\u0011\u0007Q\u0013\t!C\u0002\u0003\u0004U\u00131!\u00138u!\r\u0001&qA\u0005\u0004\u0005\u0013A%\u0001G\"p[B,H/\u001a3Rk>$\u0018m]\"bG\",WI\u001c;ss\u0006!2m\\7qkR,G-U;pi\u0006\u001c8)Y2iK\u0002\nqbY8naJ,7o]5p]RK\b/Z\u000b\u0003\u0005#\u0001B!!%\u0003\u0014%!!QCAJ\u0005=\u0019u.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0017\u0001E2p[B\u0014Xm]:j_:$\u0016\u0010]3!\u0003a\tXo\u001c;b)>\u0004\u0018n\u0019)beRLG/[8o\u0007>,h\u000e^\u000b\u0003\u0003\u007f\fA$];pi\u0006$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u0002V\t\u0005\u0002\"\u0003B\u00127\u0005\u0005\t\u0019AA\u0000\u0003\rAH%M\u0001\u001acV|G/\u0019+pa&\u001c\u0007+\u0019:uSRLwN\\\"pk:$\b\u0005K\u0002\u001d\u0005S\u00012\u0001\u0016B\u0016\u0013\r\u0011i#\u0016\u0002\tm>d\u0017\r^5mK\u0006\u0011\u0002/\u0019:uSRLwN\\*uCR,Gj\\2l+\t\u0011\u0019\u0004\u0005\u0003\u00036\t\rSB\u0001B\u001c\u0015\u0011\u0011IDa\u000f\u0002\u000b1|7m[:\u000b\t\tu\"qH\u0001\u000bG>t7-\u001e:sK:$(b\u0001B!m\u0006!Q\u000f^5m\u0013\u0011\u0011)Ea\u000e\u0003-I+WM\u001c;sC:$(+Z1e/JLG/\u001a'pG.\f1\u0003]1si&$\u0018n\u001c8Ti\u0006$X\rT8dW\u0002\n\u0011\u0003\\8bI&tw\rU1si&$\u0018n\u001c8t+\t\u0011i\u0005\u0005\u0004\u0002r\n=\u0013q`\u0005\u0005\u0005#\n\u0019PA\u0002TKR\f!\u0003\\8bI&tw\rU1si&$\u0018n\u001c8tA\u0005yqn\u001e8fIB\u000b'\u000f^5uS>t7/\u0001\tpo:,G\rU1si&$\u0018n\u001c8tA\u0005\u0001b-Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\u0001\u0012M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u0004\u0013\u0001D:ikR$\u0018N\\4E_^tWC\u0001B1!\u0011\u0011\u0019G!\u001b\u000e\u0005\t\u0015$\u0002\u0002B4\u0005w\ta!\u0019;p[&\u001c\u0017\u0002\u0002B6\u0005K\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017!D:ikR$\u0018N\\4E_^t\u0007%A\nfa>\u001c\u0007NR8s!\u0006\u0014H/\u001b;j_:LE-\u0006\u0002\u0003tAA!Q\u000fB<\u0003\u007f\u0014Y(\u0004\u0002\u0003<%!!\u0011\u0010B\u001e\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0005\u0003W\u0011i(\u0003\u0003\u0003\u0000\u00055\"aB%oi\u0016<WM]\u0001\u0015KB|7\r\u001b$peB\u000b'\u000f^5uS>t\u0017\n\u001a\u0011\u0002'A\f'\u000f^5uS>tGj\\1e'\u0016t7o\u001c:\u0016\u0005\t\u001d\u0005\u0003BAe\u0005\u0013KAAa#\u0002L\n11+\u001a8t_J\fA\u0003]1si&$\u0018n\u001c8M_\u0006$7+\u001a8t_J\u0004\u0013a\u0006:fG>l\u0007/\u001e;fIF+x\u000e^1F]RLG/[3t)\t\u0011\u0019\nE\u0003\u0003\u0016\n}UN\u0004\u0003\u0003\u0018\nmeb\u00011\u0003\u001a&\ta+C\u0002\u0003\u001eV\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003\"\n\r&\u0001C%uKJ\f'\r\\3\u000b\u0007\tuU+A\bpo:\u001c\u0018+^8uC\u0016sG/\u001b;z)\u0011\u0011IKa,\u0011\u0007Q\u0013Y+C\u0002\u0003.V\u0013qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002\b1\u0002\r!\\\u0001\u0015SNdu.\u00193j]\u001e\fVo\u001c;b\u000b:$\u0018\u000e^=\u0015\t\t%&Q\u0017\u0005\u0007\u0003\u000fi\u0003\u0019A7\u0002\u0011\u001d,G/U;pi\u0006$2\u0001 B^\u0011\u0019\t9A\fa\u0001[\u0006\u0019r-\u001a;B]\u0012l\u0015-\u001f2f!V$\u0018+^8uCR\u0019qP!1\t\r\u0005\u001dq\u00061\u0001n\u00039aw.\u00193Rk>$\u0018m\u0015;bi\u0016$b!!\u0016\u0003H\n-\u0007b\u0002Bea\u0001\u0007\u0011q`\u0001\u0016cV|G/\u0019+pa&\u001c\u0007+\u0019:uSRLwN\\%e\u0011\u001d\u0011i\r\ra\u0001\u0003\u007f\f\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\u0002\u00151|\u0017\rZ)v_R\f7\u000f\u0006\u0005\u0002V\tM'Q\u001cBp\u0011\u001d\u0011).\ra\u0001\u0005/\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u00028\te\u0017\u0002\u0002Bn\u0003s\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0003NF\u0002\r!a@\t\u000f\t\u0005\u0018\u00071\u0001\u0003d\u0006Y1\u000f^1siRKW.Z't!\u0011\tYC!:\n\t\t\u001d\u0018Q\u0006\u0002\u0005\u0019>tw-A\nbI\u0012du.\u00193j]\u001e\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0003*\n5\bb\u0002Bxe\u0001\u0007\u0011q`\u0001\na\u0006\u0014H/\u001b;j_:\f\u0011#\u00193e\u001f^tW\r\u001a)beRLG/[8o)\u0011\t)F!>\t\u000f\t=8\u00071\u0001\u0002\u0000\u0006!\"/Z7pm\u0016|uO\\3e!\u0006\u0014H/\u001b;j_:$B!!\u0016\u0003|\"9!q\u001e\u001bA\u0002\u0005}\u0018\u0001\u00043p\u0019>\fG-U;pi\u0006\u001cH\u0003BB\u0001\u0007\u000f\u0001b!!(\u0004\u00045|\u0018\u0002BB\u0003\u0003?\u0013A\u0001U8pY\"9!Q[\u001bA\u0002\t]\u0017\u0001E;oY>\fG-U;pi\u0006\u001cF/\u0019;f)\u0019\t)f!\u0004\u0004\u0012!91q\u0002\u001cA\u0002\u0005}\u0018AD9v_R\f\u0007+\u0019:uSRLwN\u001c\u0005\b\u0005\u001b4\u0004\u0019AB\n!\u0011!V0a@\u0002!I,Wn\u001c<f#V|G/Y*uCR,GCBA+\u00073\u0019Y\u0002C\u0004\u0003V^\u0002\rAa6\t\u000f\t5w\u00071\u0001\u0004\u0014\u0005Y1\u000f^8sKF+x\u000e^1t)!\t)f!\t\u0004.\r\u0015\u0003bBB\u0012q\u0001\u00071QE\u0001\u0019cV|G/Y#oiJLWm\u001d)feB\u000b'\u000f^5uS>t\u0007\u0003CB\u0014\u0007S\u00119na\u000b\u000e\u0005\u0005]\u0018\u0002BA\u007f\u0003o\u0004RA!&\u0003 ~Dqaa\f9\u0001\u0004\u0019\t$\u0001\tsKN\u0004xN\\:f\u0007\u0006dGNY1dWB9Aka\r\u00048\u0005U\u0013bAB\u001b+\nIa)\u001e8di&|g.\r\t\t\u0007O\u0019I#a@\u0004:A!11HB!\u001b\t\u0019iD\u0003\u0003\u0004@\u0005e\u0012\u0001\u00039s_R|7m\u001c7\n\t\r\r3Q\b\u0002\u0007\u000bJ\u0014xN]:\t\u0013\r\u001d\u0003\b%AA\u0002\r%\u0013\u0001\u0004:fcV,7\u000f\u001e'pG\u0006d\u0007\u0003BA^\u0007\u0017JAa!\u0014\u0002>\na!+Z9vKN$Hj\\2bY\u0006)2\u000f^8sKF+x\u000e^1tI\u0011,g-Y;mi\u0012\u001aTCAB*U\u0011\u0019Ie!\u0016,\u0005\r]\u0003\u0003BB-\u0007Gj!aa\u0017\u000b\t\ru3qL\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!\u0019V\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007K\u001aYFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001bZ3u\u001b\u0006<\u0017n\u0019\u000b\u0005\u0007W\u001ai\u0007\u0005\u0003U{\u0006U\u0001b\u0002Bxu\u0001\u0007\u0011q`\u0001\u0013CB\u0004XM\u001c3Rk>$\u0018-T3tg\u0006<W\r\u0006\u0005\u0002V\rM4qPBA\u0011\u001d\u0019)h\u000fa\u0001\u0007o\nqA]3d_J$7\u000f\u0005\u0005\u0004(\r%\"q[B=!\u0011\t\tja\u001f\n\t\ru\u00141\u0013\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u000f\r\u001d3\b1\u0001\u0004J!911Q\u001eA\u0002\r\u0015\u0015\u0001C2bY2\u0014\u0017mY6\u0011\u000fQ\u001b\u0019da\"\u0002VAA1qEB\u0015\u0005/\u001cI\t\u0005\u0003\u0004\f\u000e%f\u0002BBG\u0007GsAaa$\u0004 :!1\u0011SBO\u001d\u0011\u0019\u0019ja'\u000f\t\rU5\u0011\u0014\b\u0004A\u000e]\u0015BAA#\u0013\u0011\t\t%a\u0011\n\u00075\u000by$\u0003\u0003\u0002<\u0005u\u0012\u0002BBQ\u0003s\t\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0007K\u001b9+A\bQe>$WoY3SKN\u0004xN\\:f\u0015\u0011\u0019\t+!\u000f\n\t\r-6Q\u0016\u0002\u0012!\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,'\u0002BBS\u0007O\u000b1$\\1zE\u0016,\u0006\u000fZ1uK\u000e{wN\u001d3j]\u0006$xN]#q_\u000eDGC\u0002BU\u0007g\u001b9\fC\u0004\u00046r\u0002\r!a@\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\b\u0007sc\u0004\u0019AB\n\u0003!)\u0007o\\2i\u001fB$\u0018AJ<sSR,Gk\\7cgR|g.Z:G_J,\u0005\u0010]5sK\u0012\fVo\u001c;b\u000b:$\u0018\u000e^5fgRA\u0011QKB`\u0007\u0003\u001ci\rC\u0004\u0004\u0010u\u0002\rAa6\t\u000f\r\rW\b1\u0001\u0004F\u0006\u0019R\r\u001f9je\u0016$gi\u001c:QCJ$\u0018\u000e^5p]B1!Q\u0013BP\u0007\u000f\u00042\u0001UBe\u0013\r\u0019Y\r\u0013\u0002\u001c#V|G/Y#oi&$\u0018pQ8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\t\u000f\r=W\b1\u0001\u0004z\u0005\u0001Bo\\7cgR|g.\u001a*fG>\u0014Hm]\u0001\rg\"|W\u000f\u001c3FqBL'/\u001a\u000b\u0007\u0005S\u001b)na6\t\r\u0005\rb\b1\u0001\u0000\u0011\u001d\u0019IN\u0010a\u0001\u00077\fQbY;se\u0016tG\u000fV5nK6\u001b\bc\u0001+\u0004^&\u0019!q]+\u0002+5\f\u0017PY3BaB,g\u000eZ#ya&\u0014\u0018\r^5p]RA!\u0011VBr\u0007K\u001cy\u000f\u0003\u0004\u0002\b}\u0002\r!\u001c\u0005\b\u0007O|\u0004\u0019ABu\u00039\u0011XmY8sIN\u0014U/\u001b7eKJ\u0004B!!%\u0004l&!1Q^AJ\u0005QiU-\\8ssJ+7m\u001c:eg\n+\u0018\u000e\u001c3fe\"91\u0011\\ A\u0002\rm\u0017!\u0007:f[>4X-\u0012=qSJ,G-U;pi\u0006,e\u000e\u001e:jKN$b!!\u0016\u0004v\u000e]\bbBB\b\u0001\u0002\u0007!q\u001b\u0005\b\u0007s\u0004\u0005\u0019\u0001B\u0003\u0003a\u0019w.\u001c9vi\u0016$\u0017+^8uCN\u001c\u0015m\u00195f\u000b:$(/_\u0001\u0014e\u0016lwN^3FqBL'/\u001a3Rk>$\u0018m\u001d\u000b\u0003\u0003+\nqc]2iK\u0012,H.Z)v_R\fW\t\u001f9je\u0006$\u0018n\u001c8\u0002\u0019A\f'\u000f^5uS>tgi\u001c:\u0015\t\u0005}HQ\u0001\u0005\u0007\u0003\u000f\u0019\u0005\u0019A7\u0002\u000fM$\u0018M\u001d;vaR1\u0011Q\u000bC\u0006\t+Aq\u0001\"\u0004E\u0001\u0004!y!\u0001\u0011sKR\u0014\u0018.\u001a<f#V|G/\u0019+pa&\u001c\u0007+\u0019:uSRLwN\\\"pk:$\b#\u0002+\u0005\u0012\u0005}\u0018b\u0001C\n+\nIa)\u001e8di&|g\u000e\r\u0005\b\t/!\u0005\u0019\u0001C\r\u0003Ai\u0017-\u001f2f\u0007J,\u0017\r^3U_BL7\rE\u0003U\t#\t)&\u0001\u0005tQV$Hm\\<o\u0003-\u0011XmY8oM&<WO]3\u0015\t\u0005UC\u0011\u0005\u0005\b\tG1\u0005\u0019AAU\u0003%qWm^\"p]\u001aLw\r")
public class QuotaStateManager
implements Logging {
    private final QuotaCoordinatorConfig config;
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final Metrics metrics;
    private final Time time;
    private final scala.collection.mutable.Map<Object, ComputedQuotasCacheEntry> computedQuotasCache;
    private final CompressionType compressionType;
    private volatile int quotaTopicPartitionCount;
    private final ReentrantReadWriteLock partitionStateLock;
    private final Set<Object> loadingPartitions;
    private final Set<Object> ownedPartitions;
    private final Set<Object> failedPartitions;
    private final AtomicBoolean shuttingDown;
    private final ConcurrentHashMap<Object, Integer> epochForPartitionId;
    private final Sensor partitionLoadSensor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Tuple2<Option<String>, Option<String>> formatRecordKeyAndValue(Record record) {
        return QuotaStateManager$.MODULE$.formatRecordKeyAndValue(record);
    }

    public static byte[] quotaEntryValue(QuotaEntry quotaEntry) {
        return QuotaStateManager$.MODULE$.quotaEntryValue(quotaEntry);
    }

    public static byte[] quotaEntryKey(QuotaEntity quotaEntity) {
        return QuotaStateManager$.MODULE$.quotaEntryKey(quotaEntity);
    }

    public static Option<QuotaEntry> readMessageValue(QuotaEntity quotaEntity, ByteBuffer buffer) {
        return QuotaStateManager$.MODULE$.readMessageValue(quotaEntity, buffer);
    }

    public static QuotaEntity readMessageKey(ByteBuffer buffer) {
        return QuotaStateManager$.MODULE$.readMessageKey(buffer);
    }

    public static String LoadTimeSensor() {
        return QuotaStateManager$.MODULE$.LoadTimeSensor();
    }

    public static String MetricsGroup() {
        return QuotaStateManager$.MODULE$.MetricsGroup();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private scala.collection.mutable.Map<Object, ComputedQuotasCacheEntry> computedQuotasCache() {
        return this.computedQuotasCache;
    }

    private CompressionType compressionType() {
        return this.compressionType;
    }

    private int quotaTopicPartitionCount() {
        return this.quotaTopicPartitionCount;
    }

    private void quotaTopicPartitionCount_$eq(int x$1) {
        this.quotaTopicPartitionCount = x$1;
    }

    private ReentrantReadWriteLock partitionStateLock() {
        return this.partitionStateLock;
    }

    private Set<Object> loadingPartitions() {
        return this.loadingPartitions;
    }

    private Set<Object> ownedPartitions() {
        return this.ownedPartitions;
    }

    private Set<Object> failedPartitions() {
        return this.failedPartitions;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    private ConcurrentHashMap<Object, Integer> epochForPartitionId() {
        return this.epochForPartitionId;
    }

    private Sensor partitionLoadSensor() {
        return this.partitionLoadSensor;
    }

    public Iterable<QuotaEntity> recomputedQuotaEntities() {
        return (Iterable)this.computedQuotasCache().values().flatMap((Function1 & Serializable)e -> e.computedQuotas().keys());
    }

    public boolean ownsQuotaEntity(QuotaEntity quotaEntity) {
        boolean bl;
        Lock inReadLock_inLock_lock = this.partitionStateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            bl = QuotaStateManager.$anonfun$ownsQuotaEntity$1(this, quotaEntity);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return bl;
    }

    public boolean isLoadingQuotaEntity(QuotaEntity quotaEntity) {
        boolean bl;
        Lock inReadLock_inLock_lock = this.partitionStateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            bl = QuotaStateManager.$anonfun$isLoadingQuotaEntity$1(this, quotaEntity);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return bl;
    }

    public Option<QuotaEntry> getQuota(QuotaEntity quotaEntity) {
        Option computedQuotasOpt = this.computedQuotasCache().get((Object)BoxesRunTime.boxToInteger((int)this.partitionFor(quotaEntity))).map((Function1 & Serializable)cacheEntry -> cacheEntry.computedQuotas());
        if (computedQuotasOpt instanceof Some) {
            Pool computedQuotas = (Pool)((Some)computedQuotasOpt).value();
            if (computedQuotas.contains(quotaEntity)) {
                return new Some(computedQuotas.get(quotaEntity));
            }
            return None$.MODULE$;
        }
        if (None$.MODULE$.equals(computedQuotasOpt)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)computedQuotasOpt);
    }

    public QuotaEntry getAndMaybePutQuota(QuotaEntity quotaEntity2) {
        int partition = this.partitionFor(quotaEntity2);
        Option option = this.computedQuotasCache().get((Object)BoxesRunTime.boxToInteger((int)partition));
        if (option instanceof Some) {
            ((ComputedQuotasCacheEntry)((Some)option).value()).computedQuotas().getAndMaybePut(quotaEntity2);
        } else if (None$.MODULE$.equals(option)) {
            Pool<QuotaEntity, QuotaEntry> computedQuotas = new Pool<QuotaEntity, QuotaEntry>((Option<Function1<QuotaEntity, QuotaEntry>>)new Some((Function1 & Serializable)quotaEntity -> new QuotaEntry((QuotaEntity)quotaEntity, $this.time.milliseconds())));
            this.computedQuotasCache().put((Object)BoxesRunTime.boxToInteger((int)partition), (Object)new ComputedQuotasCacheEntry(Predef$.MODULE$.Integer2int(this.epochForPartitionId().get(BoxesRunTime.boxToInteger((int)partition))), computedQuotas));
            computedQuotas.getAndMaybePut(quotaEntity2);
        } else {
            throw new MatchError((Object)option);
        }
        return ((ComputedQuotasCacheEntry)this.computedQuotasCache().apply((Object)BoxesRunTime.boxToInteger((int)partition))).computedQuotas().getAndMaybePut(quotaEntity2);
    }

    public void loadQuotaState(int quotaTopicPartitionId, int coordinatorEpoch) {
        TopicPartition topicPartition = new TopicPartition("_confluent-quotas", quotaTopicPartitionId);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Scheduling loading of quota state from ").append(topicPartition).append(" for epoch ").append(coordinatorEpoch).toString());
        long startTimeMs = this.time.milliseconds();
        this.scheduler.schedule(new StringBuilder(5).append("load-").append(topicPartition).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.loadQuotas(topicPartition, coordinatorEpoch, Predef$.MODULE$.long2Long(startTimeMs)), this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    private void loadQuotas(TopicPartition topicPartition, int coordinatorEpoch, Long startTimeMs) {
        if (!this.maybeUpdateCoordinatorEpoch(topicPartition.partition(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch)))) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Not loading quota state for ").append(topicPartition).append(" ").append("in epoch ").append(coordinatorEpoch).append(" since current epoch is ").append(this.epochForPartitionId().get(BoxesRunTime.boxToInteger((int)topicPartition.partition()))).toString());
            return;
        }
        if (!this.addLoadingPartition(topicPartition.partition())) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Already loaded quota state from ").append(topicPartition).toString());
            return;
        }
        try {
            try {
                this.replicaManager.logManager().abortAndPauseCleaning(topicPartition);
                long schedulerTimeMs = this.time.milliseconds() - Predef$.MODULE$.Long2long(startTimeMs);
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Started loading quota state from ").append(topicPartition).append(" for epoch ").append(coordinatorEpoch).toString());
                Pool<QuotaEntity, QuotaEntry> quotaEntries = this.doLoadQuotas(topicPartition);
                long endTimeMs = this.time.milliseconds();
                long totalLoadingTimeMs = endTimeMs - Predef$.MODULE$.Long2long(startTimeMs);
                this.partitionLoadSensor().record((double)totalLoadingTimeMs, endTimeMs, false);
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(117).append("Finished loading ").append(quotaEntries.size()).append(" quota entries from ").append(topicPartition).append(" ").append("in ").append(totalLoadingTimeMs).append(" milliseconds for epoch ").append(coordinatorEpoch).append(", of which ").append(schedulerTimeMs).append(" milliseconds was spent in the scheduler.").toString());
                Lock inWriteLock_inLock_lock = this.partitionStateLock().writeLock();
                inWriteLock_inLock_lock.lock();
                try {
                    QuotaStateManager.$anonfun$loadQuotas$5(this, topicPartition, coordinatorEpoch, quotaEntries);
                }
                finally {
                    inWriteLock_inLock_lock.unlock();
                }
                Object var13_8 = null;
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Failed loading quota state from ").append(topicPartition).append(" due to ").append(t.getMessage()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                Lock inWriteLock_inLock_lock = this.partitionStateLock().writeLock();
                inWriteLock_inLock_lock.lock();
                try {
                    QuotaStateManager.$anonfun$loadQuotas$10(this, topicPartition);
                }
                finally {
                    inWriteLock_inLock_lock.unlock();
                }
                Object var15_11 = null;
            }
        }
        finally {
            this.replicaManager.logManager().resumeCleaning(topicPartition);
        }
    }

    public boolean addLoadingPartition(int partition) {
        boolean bl;
        Lock inWriteLock_inLock_lock = this.partitionStateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            bl = QuotaStateManager.$anonfun$addLoadingPartition$1(this, partition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        return bl;
    }

    public void addOwnedPartition(int partition) {
        Lock inWriteLock_inLock_lock = this.partitionStateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            QuotaStateManager.$anonfun$addOwnedPartition$1(this, partition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void removeOwnedPartition(int partition) {
        Lock inWriteLock_inLock_lock = this.partitionStateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            QuotaStateManager.$anonfun$removeOwnedPartition$1(this, partition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private Pool<QuotaEntity, QuotaEntry> doLoadQuotas(TopicPartition topicPartition) {
        BufferSupplier bufferSupplier = BufferSupplier.create();
        Pool<QuotaEntity, QuotaEntry> computedQuotas = new Pool<QuotaEntity, QuotaEntry>((Option<Function1<QuotaEntity, QuotaEntry>>)new Some((Function1 & Serializable)quotaEntity -> new QuotaEntry((QuotaEntity)quotaEntity, $this.time.milliseconds())));
        Option<AbstractLog> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Attempted to load quota state from ").append(topicPartition).append(", but found no log").toString());
        } else if (option instanceof Some) {
            AbstractLog log = (AbstractLog)((Some)option).value();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            LongRef currOffset = LongRef.create((long)log.logStartOffset());
            boolean readAtLeastOneRecord = true;
            while (currOffset.elem < this.logEndOffset$1(topicPartition) && readAtLeastOneRecord && !this.shuttingDown().get()) {
                MemoryRecords memoryRecords;
                AbstractFetchDataInfo abstractFetchDataInfo = log.read(currOffset.elem, this.config.loadBufferSize(), FetchLogEnd$.MODULE$, true, false);
                if (!(abstractFetchDataInfo instanceof FetchDataInfo)) {
                    throw new IllegalStateException(new StringBuilder(53).append("Unexpected tiered segment for ").append("_confluent-quotas").append(" topic").toString());
                }
                FetchDataInfo fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
                readAtLeastOneRecord = fetchDataInfo.records().sizeInBytes() > 0;
                Records records = fetchDataInfo.records();
                if (records instanceof MemoryRecords) {
                    memoryRecords = (MemoryRecords)records;
                } else if (records instanceof FileRecords) {
                    FileRecords fileRecords = (FileRecords)records;
                    int sizeInBytes = fileRecords.sizeInBytes();
                    int bytesNeeded = Math.max(this.config.loadBufferSize(), sizeInBytes);
                    if (buffer.capacity() < bytesNeeded) {
                        if (this.config.loadBufferSize() < bytesNeeded) {
                            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(106).append("Loaded quota state from ").append(topicPartition).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").append("configured quota.topic.load.buffer.size (").append($this.config.loadBufferSize()).append(" bytes)").toString());
                        }
                        buffer = ByteBuffer.allocate(bytesNeeded);
                    } else {
                        buffer.clear();
                    }
                    fileRecords.readInto(buffer, 0);
                    memoryRecords = new MemoryRecords(buffer);
                } else {
                    throw new MatchError((Object)records);
                }
                memoryRecords.batches().forEach(batch -> {
                    try (CloseableIterator iterator = batch.streamingIterator(bufferSupplier);){
                        CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)iterator).asScala().foreach((Function1 & Serializable)record -> {
                            Predef$.MODULE$.require(record.hasKey(), (Function0 & Serializable)() -> "Quota entry key should not be null");
                            QuotaEntity quotaEntity = QuotaStateManager$.MODULE$.readMessageKey(record.key());
                            Option<QuotaEntry> quotaEntryOpt = QuotaStateManager$.MODULE$.readMessageValue(quotaEntity, record.value());
                            if (quotaEntryOpt instanceof Some) {
                                QuotaEntry quotaEntry = (QuotaEntry)((Some)quotaEntryOpt).value();
                                return computedQuotas.put(quotaEntity, quotaEntry);
                            }
                            if (None$.MODULE$.equals(quotaEntryOpt)) {
                                return (QuotaEntry)computedQuotas.remove(quotaEntity);
                            }
                            throw new MatchError(quotaEntryOpt);
                        });
                    }
                    currOffset$1.elem = batch.nextOffset();
                });
            }
        } else {
            throw new MatchError(option);
        }
        return computedQuotas;
    }

    public void unloadQuotaState(int quotaPartition, Option<Object> coordinatorEpoch) {
        TopicPartition topicPartition = new TopicPartition("_confluent-quotas", quotaPartition);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Scheduling unloading of quota state from ").append(topicPartition).toString());
        this.scheduler.schedule(new StringBuilder(7).append("unload-").append(topicPartition).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.removeQuotaState(topicPartition, coordinatorEpoch), this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    private void removeQuotaState(TopicPartition topicPartition, Option<Object> coordinatorEpoch) {
        int quotaPartition = topicPartition.partition();
        if (this.maybeUpdateCoordinatorEpoch(quotaPartition, coordinatorEpoch)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Started unloading quota state for ").append(topicPartition).append(" for ").append("coordinator epoch ").append(coordinatorEpoch).toString());
            Lock inWriteLock_inLock_lock = this.partitionStateLock().writeLock();
            inWriteLock_inLock_lock.lock();
            try {
                QuotaStateManager.$anonfun$removeQuotaState$2(this, quotaPartition, topicPartition, coordinatorEpoch);
            }
            finally {
                inWriteLock_inLock_lock.unlock();
            }
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Not removing quota state for ").append(topicPartition).append(" ").append("in epoch ").append(coordinatorEpoch).append(" since current epoch is ").append(this.epochForPartitionId().get(BoxesRunTime.boxToInteger((int)topicPartition.partition()))).toString());
    }

    /*
     * WARNING - void declaration
     */
    public void storeQuotas(Map<TopicPartition, Iterable<QuotaEntry>> quotaEntriesPerPartition, Function1<Map<Object, Errors>, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        void appendQuotaMessage_callback;
        scala.collection.mutable.Map invalidPartitions = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map recordsPerPartition = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        quotaEntriesPerPartition.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                Iterable quotaEntries = (Iterable)x0$1._2();
                Option<Object> option = this.getMagic(tp.partition());
                if (option instanceof Some) {
                    void withRecords_records;
                    void withRecords_timestampType;
                    byte magicValue = BoxesRunTime.unboxToByte((Object)((Some)option).value());
                    IntRef recordCount = IntRef.create((int)0);
                    Iterable records = (Iterable)quotaEntries.map((Function1 & Serializable)quotaEntry -> {
                        long currentTimeMs = $this.time.milliseconds();
                        byte[] key = QuotaStateManager$.MODULE$.quotaEntryKey(quotaEntry.quotaEntity());
                        byte[] value = QuotaStateManager$.MODULE$.quotaEntryValue((QuotaEntry)quotaEntry);
                        ++recordCount$1.elem;
                        return new SimpleRecord(currentTimeMs, key, value);
                    });
                    SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
                    CompressionType withRecords_compressionType = this.compressionType();
                    TimestampType timestampType = TimestampType.CREATE_TIME;
                    long withRecords_initialOffset = 0L;
                    timestampType = null;
                    Object var10_11 = null;
                    simpleRecordArray = null;
                    recordsPerPartition.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)MemoryRecords.withRecords((byte)magicValue, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records)));
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Writing ").append(recordCount$1.elem).append(" quota entries to quotas partition ").append(tp).toString());
                    return BoxedUnit.UNIT;
                }
                if (None$.MODULE$.equals(option)) {
                    return invalidPartitions.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Errors.NOT_COORDINATOR));
                }
                throw new MatchError(option);
            }
            throw new MatchError(null);
        });
        Function1 & Serializable intersect = (Function1 & Serializable)responseStatus -> {
            this.appendCallback$1(responseStatus, responseCallback, invalidPartitions);
            return BoxedUnit.UNIT;
        };
        scala.collection.immutable.Map appendQuotaMessage_records = recordsPerPartition.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        long appendQuotaMessage_x$1 = this.config.quotasTopicAppendTimeoutMs();
        short appendQuotaMessage_x$2 = QuotaCoordinatorConfig$.MODULE$.RequiredAcks();
        AppendOrigin$Coordinator$ appendQuotaMessage_x$4 = AppendOrigin$Coordinator$.MODULE$;
        Option<Lock> appendQuotaMessage_x$8 = this.replicaManager.appendRecords$default$7();
        Function1<Map<TopicPartition, RecordConversionStats>, BoxedUnit> appendQuotaMessage_x$9 = this.replicaManager.appendRecords$default$8();
        this.replicaManager.appendRecords(appendQuotaMessage_x$1, appendQuotaMessage_x$2, true, appendQuotaMessage_x$4, (Map<TopicPartition, MemoryRecords>)appendQuotaMessage_records, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)appendQuotaMessage_callback, appendQuotaMessage_x$8, appendQuotaMessage_x$9, requestLocal);
    }

    public RequestLocal storeQuotas$default$3() {
        return RequestLocal$.MODULE$.NoCaching();
    }

    private Option<Object> getMagic(int partition) {
        return this.replicaManager.getMagic(new TopicPartition("_confluent-quotas", partition));
    }

    private void appendQuotaMessage(Map<TopicPartition, MemoryRecords> records, RequestLocal requestLocal, Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit> callback) {
        long x$1 = this.config.quotasTopicAppendTimeoutMs();
        short x$2 = QuotaCoordinatorConfig$.MODULE$.RequiredAcks();
        AppendOrigin$Coordinator$ x$4 = AppendOrigin$Coordinator$.MODULE$;
        Option<Lock> x$8 = this.replicaManager.appendRecords$default$7();
        Function1<Map<TopicPartition, RecordConversionStats>, BoxedUnit> x$9 = this.replicaManager.appendRecords$default$8();
        this.replicaManager.appendRecords(x$1, x$2, true, x$4, records, callback, x$8, x$9, requestLocal);
    }

    private boolean maybeUpdateCoordinatorEpoch(int partitionId, Option<Object> epochOpt) {
        Integer updatedEpoch = this.epochForPartitionId().compute(BoxesRunTime.boxToInteger((int)partitionId), (x$2, currentEpoch) -> QuotaStateManager.$anonfun$maybeUpdateCoordinatorEpoch$1(epochOpt, BoxesRunTime.unboxToInt((Object)x$2), currentEpoch));
        return epochOpt.forall((Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)x$3), (Object)updatedEpoch));
    }

    private void writeTombstonesForExpiredQuotaEntities(TopicPartition quotaPartition, Iterable<QuotaEntityCoordinatorEpoch> expiredForPartition, MemoryRecords tombstoneRecords) {
        Lock inReadLock_inLock_lock = this.partitionStateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            QuotaStateManager.$anonfun$writeTombstonesForExpiredQuotaEntities$7(this, quotaPartition, tombstoneRecords, expiredForPartition);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private boolean shouldExpire(QuotaEntry quotaEntry, long currentTimeMs) {
        return this.config.quotasExpirationTimeMs() > 0 && quotaEntry.lastUpdatedTimestamp() <= currentTimeMs - (long)this.config.quotasExpirationTimeMs();
    }

    private boolean maybeAppendExpiration(QuotaEntity quotaEntity, MemoryRecordsBuilder recordsBuilder, long currentTimeMs) {
        byte[] keyBytes = QuotaStateManager$.MODULE$.quotaEntryKey(quotaEntity);
        if (recordsBuilder.hasRoomFor(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS)) {
            recordsBuilder.append(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS);
            return true;
        }
        return false;
    }

    private void removeExpiredQuotaEntries(TopicPartition quotaPartition, ComputedQuotasCacheEntry computedQuotasCacheEntry) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Checking partition ").append(quotaPartition).append(" for expired quota entries").toString());
        Lock inReadLock_inLock_lock = this.partitionStateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            QuotaStateManager.$anonfun$removeExpiredQuotaEntries$2(this, quotaPartition, computedQuotasCacheEntry);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private void removeExpiredQuotas() {
        Lock inReadLock_inLock_lock = this.partitionStateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            QuotaStateManager.$anonfun$removeExpiredQuotas$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private void scheduleQuotaExpiration() {
        if (this.config.quotasExpirationIntervalMs() > 0) {
            this.scheduler.schedule("quota-expiration", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.removeExpiredQuotas(), this.config.quotasExpirationIntervalMs(), this.config.quotasExpirationIntervalMs(), this.scheduler.schedule$default$5());
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Scheduled quota expiration thread with an interval of ").append($this.config.quotasExpirationIntervalMs()).append(" ms").toString());
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("Not scheduling quota expiration because the expiration interval is ").append($this.config.quotasExpirationIntervalMs()).append(" ms").toString());
    }

    public int partitionFor(QuotaEntity quotaEntity) {
        return Utils.abs((int)quotaEntity.hashCode()) % this.quotaTopicPartitionCount();
    }

    public void startup(Function0<Object> retrieveQuotaTopicPartitionCount, Function0<BoxedUnit> maybeCreateTopic) {
        this.scheduler.schedule(new StringBuilder(26).append("_confluent-quotas").append("-creation").toString(), maybeCreateTopic, this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
        this.quotaTopicPartitionCount_$eq(retrieveQuotaTopicPartitionCount.apply$mcI$sp());
        this.scheduleQuotaExpiration();
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        if (this.scheduler.isStarted()) {
            this.scheduler.shutdown();
        }
        this.loadingPartitions().clear();
        this.ownedPartitions().clear();
        this.computedQuotasCache().clear();
        this.metrics.removeSensor(QuotaStateManager$.MODULE$.LoadTimeSensor());
    }

    public void reconfigure(QuotaCoordinatorConfig newConfig) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Updating quota expiration time to ").append(newConfig.quotasExpirationTimeMs()).toString());
        this.config.quotasExpirationTimeMs_$eq(newConfig.quotasExpirationTimeMs());
    }

    public static final /* synthetic */ boolean $anonfun$ownsQuotaEntity$1(QuotaStateManager $this, QuotaEntity quotaEntity$1) {
        return $this.ownedPartitions().contains((Object)BoxesRunTime.boxToInteger((int)$this.partitionFor(quotaEntity$1)));
    }

    public static final /* synthetic */ boolean $anonfun$isLoadingQuotaEntity$1(QuotaStateManager $this, QuotaEntity quotaEntity$2) {
        return $this.loadingPartitions().contains((Object)BoxesRunTime.boxToInteger((int)$this.partitionFor(quotaEntity$2)));
    }

    public static final /* synthetic */ Object $anonfun$loadQuotas$5(QuotaStateManager $this, TopicPartition topicPartition$2, int coordinatorEpoch$2, Pool quotaEntries$1) {
        if ($this.loadingPartitions().contains((Object)BoxesRunTime.boxToInteger((int)topicPartition$2.partition()))) {
            $this.computedQuotasCache().put((Object)BoxesRunTime.boxToInteger((int)topicPartition$2.partition()), (Object)new ComputedQuotasCacheEntry(coordinatorEpoch$2, quotaEntries$1)).foreach((Function1 & Serializable)previousComputedQuotasCacheEntry -> {
                $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Unloaded computed quotas ").append(previousComputedQuotasCacheEntry).append(" from ").append(topicPartition$2).append(" as part of ").append("loading metadata at epoch ").append(coordinatorEpoch$2).toString());
                return BoxedUnit.UNIT;
            });
            $this.ownedPartitions().add((Object)BoxesRunTime.boxToInteger((int)topicPartition$2.partition()));
            return BoxesRunTime.boxToBoolean((boolean)$this.loadingPartitions().remove((Object)BoxesRunTime.boxToInteger((int)topicPartition$2.partition())));
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$loadQuotas$10(QuotaStateManager $this, TopicPartition topicPartition$2) {
        $this.ownedPartitions().remove((Object)BoxesRunTime.boxToInteger((int)topicPartition$2.partition()));
        $this.failedPartitions().add((Object)BoxesRunTime.boxToInteger((int)topicPartition$2.partition()));
        return $this.loadingPartitions().remove((Object)BoxesRunTime.boxToInteger((int)topicPartition$2.partition()));
    }

    public static final /* synthetic */ boolean $anonfun$addLoadingPartition$1(QuotaStateManager $this, int partition$1) {
        if ($this.ownedPartitions().contains((Object)BoxesRunTime.boxToInteger((int)partition$1))) {
            return false;
        }
        return $this.loadingPartitions().add((Object)BoxesRunTime.boxToInteger((int)partition$1));
    }

    public static final /* synthetic */ boolean $anonfun$addOwnedPartition$1(QuotaStateManager $this, int partition$2) {
        return $this.ownedPartitions().add((Object)BoxesRunTime.boxToInteger((int)partition$2));
    }

    public static final /* synthetic */ boolean $anonfun$removeOwnedPartition$1(QuotaStateManager $this, int partition$3) {
        return $this.ownedPartitions().remove((Object)BoxesRunTime.boxToInteger((int)partition$3));
    }

    private final long logEndOffset$1(TopicPartition topicPartition$3) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(topicPartition$3).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    public static final /* synthetic */ void $anonfun$removeQuotaState$2(QuotaStateManager $this, int quotaPartition$1, TopicPartition topicPartition$5, Option coordinatorEpoch$4) {
        $this.ownedPartitions().remove((Object)BoxesRunTime.boxToInteger((int)quotaPartition$1));
        $this.loadingPartitions().remove((Object)BoxesRunTime.boxToInteger((int)quotaPartition$1));
        $this.failedPartitions().remove((Object)BoxesRunTime.boxToInteger((int)quotaPartition$1));
        Option option = $this.computedQuotasCache().remove((Object)BoxesRunTime.boxToInteger((int)topicPartition$5.partition()));
        if (option instanceof Some) {
            ComputedQuotasCacheEntry computedQuotaCacheEntry = (ComputedQuotasCacheEntry)((Some)option).value();
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(79).append("Finished unloading ").append(topicPartition$5).append(" for coordinator epoch ").append(coordinatorEpoch$4).append(". ").append("Removed quotas for ").append(computedQuotaCacheEntry.computedQuotas().size()).append(" quota entities.").toString());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("No quotas found for ").append(topicPartition$5).append(" during become-follower transition").toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    private final void appendCallback$1(Map responseStatus, Function1 responseCallback$1, scala.collection.mutable.Map invalidPartitions$1) {
        Map partitionStatuses = (Map)responseStatus.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Errors errors;
                TopicPartition tp = (TopicPartition)x0$1._1();
                ProduceResponse.PartitionResponse status = (ProduceResponse.PartitionResponse)x0$1._2();
                Errors errors2 = status.error;
                Errors errors3 = Errors.NONE;
                if (!(errors2 != null ? !errors2.equals(errors3) : errors3 != null)) {
                    errors = Errors.NONE;
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Quota state for partition ").append(tp).append(" failed when appending to log ").append("due to ").append(status$1.error.exceptionName()).toString());
                    Errors errors4 = status.error;
                    if (Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(errors4) ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(errors4) ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(errors4) ? true : Errors.REQUEST_TIMED_OUT.equals(errors4)))) {
                        errors = Errors.COORDINATOR_NOT_AVAILABLE;
                    } else if (Errors.NOT_LEADER_OR_FOLLOWER.equals(errors4) ? true : Errors.KAFKA_STORAGE_ERROR.equals(errors4)) {
                        errors = Errors.NOT_COORDINATOR;
                    } else if (Errors.MESSAGE_TOO_LARGE.equals(errors4) ? true : (Errors.RECORD_LIST_TOO_LARGE.equals(errors4) ? true : Errors.INVALID_FETCH_SIZE.equals(errors4))) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(104).append("Appending quota state messages for partition ").append(tp).append(" failed due to ").append(status$1.error.exceptionName()).append(", returning UNKNOWN error code to the client").toString());
                        errors = Errors.UNKNOWN_SERVER_ERROR;
                    } else {
                        this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Appending quota state message for partition ").append(tp).append(" failed ").append("due to unexpected error: ").append(status$1.error.exceptionName()).toString());
                        errors = errors4;
                    }
                }
                Errors responseError = errors;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)responseError);
            }
            throw new MatchError(null);
        });
        responseCallback$1.apply((Object)partitionStatuses.$plus$plus((IterableOnce)invalidPartitions$1));
    }

    public static final /* synthetic */ Integer $anonfun$maybeUpdateCoordinatorEpoch$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$maybeUpdateCoordinatorEpoch$1(Option epochOpt$1, int x$2, Integer currentEpoch) {
        int epoch;
        if (currentEpoch == null) {
            return (Integer)epochOpt$1.map((Function1 & Serializable)x -> QuotaStateManager.$anonfun$maybeUpdateCoordinatorEpoch$2(BoxesRunTime.unboxToInt((Object)x))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        if (epochOpt$1 instanceof Some && (epoch = BoxesRunTime.unboxToInt((Object)((Some)epochOpt$1).value())) > Predef$.MODULE$.Integer2int(currentEpoch)) {
            return Predef$.MODULE$.int2Integer(epoch);
        }
        return currentEpoch;
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredQuotaEntities$2(QuotaStateManager $this, TopicPartition topicPartition$6, Iterable expiredForPartition$1, ProduceResponse.PartitionResponse response$1) {
        $this.computedQuotasCache().get((Object)BoxesRunTime.boxToInteger((int)topicPartition$6.partition())).foreach((Function1 & Serializable)computedQuotasCacheEntry -> {
            expiredForPartition$1.foreach((Function1 & Serializable)entityAndEpoch -> {
                QuotaEntity quotaEntity = entityAndEpoch.quotaEntity();
                return computedQuotasCacheEntry.computedQuotas().get(quotaEntity).inLock((Function0 & Serializable)() -> {
                    if (computedQuotasCacheEntry.coordinatorEpoch() == entityAndEpoch.coordinatorEpoch()) {
                        Errors errors = response$1.error;
                        Errors errors2 = Errors.NONE;
                        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                            return computedQuotasCacheEntry.computedQuotas().remove(quotaEntity);
                        }
                    }
                    $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(130).append("Failed to remove expired quota entity: ").append(quotaEntity).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").append(" coordinatorEpoch: ").append(computedQuotasCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").append(entityAndEpoch.coordinatorEpoch()).toString());
                    return BoxedUnit.UNIT;
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredQuotaEntities$1(QuotaStateManager $this, Iterable expiredForPartition$1, TopicPartition topicPartition, ProduceResponse.PartitionResponse response) {
        Lock inReadLock_inLock_lock = $this.partitionStateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            QuotaStateManager.$anonfun$writeTombstonesForExpiredQuotaEntities$2($this, topicPartition, expiredForPartition$1, response);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private final void removeFromCacheCallback$1(Map responses, Iterable expiredForPartition$1) {
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, response) -> {
            QuotaStateManager.$anonfun$writeTombstonesForExpiredQuotaEntities$1(this, expiredForPartition$1, topicPartition, response);
            return BoxedUnit.UNIT;
        };
        responses.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredQuotaEntities$7(QuotaStateManager $this, TopicPartition quotaPartition$2, MemoryRecords tombstoneRecords$1, Iterable expiredForPartition$1) {
        long x$1 = $this.config.quotasTopicAppendTimeoutMs();
        short x$2 = QuotaCoordinatorConfig$.MODULE$.RequiredAcks();
        AppendOrigin$Coordinator$ x$4 = AppendOrigin$Coordinator$.MODULE$;
        Map x$5 = (Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaPartition$2), (Object)tombstoneRecords$1)}));
        Function1 & Serializable x$6 = (Function1 & Serializable)responses -> {
            $this.removeFromCacheCallback$1(responses, expiredForPartition$1);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$7 = RequestLocal$.MODULE$.NoCaching();
        Option<Lock> x$8 = $this.replicaManager.appendRecords$default$7();
        Function1<Map<TopicPartition, RecordConversionStats>, BoxedUnit> x$9 = $this.replicaManager.appendRecords$default$8();
        $this.replicaManager.appendRecords(x$1, x$2, true, x$4, (Map<TopicPartition, MemoryRecords>)x$5, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)x$6, x$8, x$9, x$7);
    }

    private final void flushRecordsBuilder$1(TopicPartition quotaPartition$3, ListBuffer expired$1, ObjectRef recordsBuilder$1) {
        this.writeTombstonesForExpiredQuotaEntities(quotaPartition$3, (Iterable<QuotaEntityCoordinatorEpoch>)expired$1.toSeq(), ((MemoryRecordsBuilder)recordsBuilder$1.elem).build());
        expired$1.clear();
        recordsBuilder$1.elem = null;
    }

    public static final /* synthetic */ void $anonfun$removeExpiredQuotaEntries$2(QuotaStateManager $this, TopicPartition quotaPartition$3, ComputedQuotasCacheEntry computedQuotasCacheEntry$2) {
        Option<LogConfig> option = $this.replicaManager.getLogConfig(quotaPartition$3);
        if (option instanceof Some) {
            LogConfig logConfig = (LogConfig)((Some)option).value();
            long currentTimeMs = $this.time.milliseconds();
            Integer maxBatchSize = logConfig.maxMessageSize();
            ListBuffer expired = ListBuffer$.MODULE$.empty();
            ObjectRef recordsBuilder = ObjectRef.create(null);
            BufferedIterator stateEntries = computedQuotasCacheEntry$2.computedQuotas().values().iterator().buffered();
            while (stateEntries.hasNext()) {
                QuotaEntry quotaEntry = (QuotaEntry)stateEntries.head();
                QuotaEntity quotaEntity = quotaEntry.quotaEntity();
                BooleanRef fullBatch = BooleanRef.create((boolean)false);
                quotaEntry.inLock((Function0 & Serializable)() -> {
                    if ($this.shouldExpire(quotaEntry, currentTimeMs)) {
                        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Expiring quota entry for entity ").append(quotaEntry.quotaEntity()).toString());
                        if ((MemoryRecordsBuilder)recordsBuilder$1.elem == null) {
                            recordsBuilder$1.elem = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(package$.MODULE$.min(16384, Predef$.MODULE$.Integer2int(maxBatchSize))), (CompressionType)$this.compressionType(), (TimestampType)TimestampType.CREATE_TIME, (long)0L, (int)Predef$.MODULE$.Integer2int(maxBatchSize));
                        }
                        if ($this.maybeAppendExpiration(quotaEntity, (MemoryRecordsBuilder)recordsBuilder$1.elem, currentTimeMs)) {
                            return expired.$plus$eq((Object)new QuotaEntityCoordinatorEpoch(quotaEntity, computedQuotasCacheEntry$2.coordinatorEpoch()));
                        }
                        fullBatch$1.elem = true;
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                });
                if (fullBatch.elem) {
                    $this.writeTombstonesForExpiredQuotaEntities(quotaPartition$3, (Iterable<QuotaEntityCoordinatorEpoch>)expired.toSeq(), ((MemoryRecordsBuilder)recordsBuilder.elem).build());
                    expired.clear();
                    recordsBuilder.elem = null;
                    continue;
                }
                stateEntries.next();
            }
            if (expired.nonEmpty()) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Found ").append(expired.size()).append(" expired quota entries").toString());
                $this.writeTombstonesForExpiredQuotaEntities(quotaPartition$3, (Iterable<QuotaEntityCoordinatorEpoch>)expired.toSeq(), ((MemoryRecordsBuilder)recordsBuilder.elem).build());
                expired.clear();
                recordsBuilder.elem = null;
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(150).append("Quota expiration for partition ").append(quotaPartition$3).append(" failed because the log ").append("config was not available, which likely means the partition is not online or is no longer local.").toString());
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$removeExpiredQuotas$2(QuotaStateManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            int partitionId = x0$1._1$mcI$sp();
            ComputedQuotasCacheEntry computedQuotasCacheEntry = (ComputedQuotasCacheEntry)x0$1._2();
            TopicPartition quotasPartition = new TopicPartition("_confluent-quotas", partitionId);
            $this.removeExpiredQuotaEntries(quotasPartition, computedQuotasCacheEntry);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$removeExpiredQuotas$1(QuotaStateManager $this) {
        $this.computedQuotasCache().foreach((Function1 & Serializable)x0$1 -> {
            QuotaStateManager.$anonfun$removeExpiredQuotas$2($this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public QuotaStateManager(QuotaCoordinatorConfig config, Scheduler scheduler, ReplicaManager replicaManager, Metrics metrics, Time time) {
        void add_stat;
        void add_metricName;
        void add_stat2;
        void add_metricName2;
        this.config = config;
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.metrics = metrics;
        this.time = time;
        this.computedQuotasCache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.compressionType = CompressionType.forId((int)config.quotasTopicCompressionCodec().codec());
        this.partitionStateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.ownedPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.failedPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.shuttingDown = new AtomicBoolean(false);
        this.epochForPartitionId = new ConcurrentHashMap();
        this.partitionLoadSensor = metrics.sensor(QuotaStateManager$.MODULE$.LoadTimeSensor());
        Sensor sensor = this.partitionLoadSensor();
        Max max = new Max();
        MetricName metricName = metrics.metricName("partition-load-time-max", QuotaStateManager$.MODULE$.MetricsGroup(), "The max time it took to load the partitions in the last 30sec");
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName2, (MeasurableStat)add_stat2, null);
        metricName = null;
        max = null;
        Sensor sensor2 = this.partitionLoadSensor();
        Avg avg = new Avg();
        MetricName metricName2 = metrics.metricName("partition-load-time-avg", QuotaStateManager$.MODULE$.MetricsGroup(), "The avg time it took to load the partitions in the last 30sec");
        if (sensor2 == null) {
            throw null;
        }
        sensor2.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
    }

    public static class QuotaEntryMessageFormatter
    implements MessageFormatter {
        public void configure(java.util.Map<String, ?> x$1) {
            super.configure(x$1);
        }

        public void close() {
            super.close();
        }

        public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
            Option$.MODULE$.apply(consumerRecord.key()).map((Function1 & Serializable)key -> QuotaStateManager$.MODULE$.readMessageKey(ByteBuffer.wrap(key))).foreach((Function1 & Serializable)quotaEntity -> {
                QuotaEntryMessageFormatter.$anonfun$writeTo$2(consumerRecord, output, quotaEntity);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$writeTo$2(ConsumerRecord consumerRecord$1, PrintStream output$1, QuotaEntity quotaEntity) {
            byte[] value = (byte[])consumerRecord$1.value();
            Option<QuotaEntry> quotaEntry = value == null ? None$.MODULE$ : QuotaStateManager$.MODULE$.readMessageValue(quotaEntity, ByteBuffer.wrap(value));
            output$1.write(quotaEntity.toString().getBytes(StandardCharsets.UTF_8));
            output$1.write("::".getBytes(StandardCharsets.UTF_8));
            output$1.write(quotaEntry.getOrElse((Function0 & Serializable)() -> "NULL").toString().getBytes(StandardCharsets.UTF_8));
            output$1.write("\n".getBytes(StandardCharsets.UTF_8));
        }
    }
}

