/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.common.InterBrokerSendThread;
import kafka.common.RequestAndCompletionHandler;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PendingCompleteTxn;
import kafka.coordinator.transaction.TransactionMarkerChannelManager$;
import kafka.coordinator.transaction.TransactionMarkerRequestCompletionHandler;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnIdAndMarkerEntry;
import kafka.coordinator.transaction.TxnMarkerQueue;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.RequestLocal$;
import kafka.utils.CoreUtils$;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\tut!\u0002\u0014(\u0011\u0003qc!\u0002\u0019(\u0011\u0003\t\u0004\"\u0002\u001d\u0002\t\u0003I\u0004\"\u0002\u001e\u0002\t\u0003Yd\u0001\u0002\u0019(\u0001uB\u0001\u0002\u0015\u0003\u0003\u0002\u0003\u0006I!\u0015\u0005\t/\u0012\u0011\t\u0011)A\u00051\"A1\f\u0002B\u0001B\u0003%A\f\u0003\u0005h\t\t\u0005\t\u0015!\u0003i\u0011!YGA!A!\u0002\u0013a\u0007\"\u0002\u001d\u0005\t\u0003\u0011\bb\u0002=\u0005\u0005\u0004%I!\u001f\u0005\b\u0003\u0003!\u0001\u0015!\u0003{\u0011%\t\u0019\u0001\u0002b\u0001\n\u0013\t)\u0001\u0003\u0005\u0002$\u0011\u0001\u000b\u0011BA\u0004\u0011%\t)\u0003\u0002b\u0001\n\u0013\t9\u0003\u0003\u0005\u0002*\u0011\u0001\u000b\u0011BA\u000f\u0011%\tY\u0003\u0002b\u0001\n\u0013\ti\u0003\u0003\u0005\u0002H\u0011\u0001\u000b\u0011BA\u0018\u0011%\tI\u0005\u0002b\u0001\n\u0013\tY\u0005\u0003\u0005\u0002j\u0011\u0001\u000b\u0011BA'\u0011%\tY\u0007\u0002b\u0001\n\u0003\ti\u0007\u0003\u0005\u0002v\u0011\u0001\u000b\u0011BA8\u0011\u001d\t9\b\u0002C!\u0003sB\u0001\"!!\u0005\t\u00039\u00131\u0011\u0005\t\u0003\u001f#A\u0011A\u0014\u0002(!A\u0011\u0011\u0013\u0003\u0005\u0002\u001d\n\u0019\nC\u0004\u00020\u0012!\t!!\u001f\t\u000f\u0005EF\u0001\"\u0011\u00024\"9\u0011Q\u001a\u0003\u0005\n\u0005=\u0007bBAk\t\u0011\u0005\u0011q\u001b\u0005\b\u0005\u0003!A\u0011\u0001B\u0002\u0011\u001d\u0011)\u0001\u0002C\u0005\u0005\u000fAqA!\u0005\u0005\t\u0003\u0011\u0019\u0002C\u0004\u0003\u001a\u0011!IAa\u0007\t\u000f\t\u0005B\u0001\"\u0001\u0003$!9!\u0011\u000b\u0003\u0005\u0002\tM\u0003b\u0002B-\t\u0011\u0005!1L\u0001 )J\fgn]1di&|g.T1sW\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014(B\u0001\u0015*\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005)Z\u0013aC2p_J$\u0017N\\1u_JT\u0011\u0001L\u0001\u0006W\u000647.Y\u0002\u0001!\ty\u0013!D\u0001(\u0005}!&/\u00198tC\u000e$\u0018n\u001c8NCJ\\WM]\"iC:tW\r\\'b]\u0006<WM]\n\u0003\u0003I\u0002\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001/\u0003\u0015\t\u0007\u000f\u001d7z)5a$q\fB1\u0005[\u0012yG!\u001d\u0003tA\u0011q\u0006B\n\u0005\ty\"%\n\u0005\u0002@\u00056\t\u0001I\u0003\u0002BW\u000511m\\7n_:L!a\u0011!\u0003+%sG/\u001a:Ce>\\WM]*f]\u0012$\u0006N]3bIB\u0011Q\tS\u0007\u0002\r*\u0011qiK\u0001\u0006kRLGn]\u0005\u0003\u0013\u001a\u0013q\u0001T8hO&tw\r\u0005\u0002L\u001d6\tAJ\u0003\u0002NW\u00059Q.\u001a;sS\u000e\u001c\u0018BA(M\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f]\u0001\u0007G>tg-[4\u0011\u0005I+V\"A*\u000b\u0005Q[\u0013AB:feZ,'/\u0003\u0002W'\nY1*\u00194lC\u000e{gNZ5h\u00035iW\r^1eCR\f7)Y2iKB\u0011!+W\u0005\u00035N\u0013Q\"T3uC\u0012\fG/Y\"bG\",\u0017!\u00048fi^|'o[\"mS\u0016tG\u000f\u0005\u0002^K6\taL\u0003\u0002`A\u000691\r\\5f]R\u001c(B\u0001\u0017b\u0015\t\u00117-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I\u0006\u0019qN]4\n\u0005\u0019t&!\u0004(fi^|'o[\"mS\u0016tG/A\buq:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s!\ty\u0013.\u0003\u0002kO\t9BK]1og\u0006\u001cG/[8o'R\fG/Z'b]\u0006<WM]\u0001\u0005i&lW\r\u0005\u0002na6\taN\u0003\u0002H_*\u0011\u0011\tY\u0005\u0003c:\u0014A\u0001V5nKR1Ah\u001d;vm^DQ\u0001\u0015\u0006A\u0002ECQa\u0016\u0006A\u0002aCQa\u0017\u0006A\u0002qCQa\u001a\u0006A\u0002!DQa\u001b\u0006A\u00021\fq#\u001b8uKJ\u0014%o\\6fe2K7\u000f^3oKJt\u0015-\\3\u0016\u0003i\u0004\"a\u001f@\u000e\u0003qT!!`8\u0002\u000f9,Go^8sW&\u0011q\u0010 \u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u0019S:$XM\u001d\"s_.,'\u000fT5ti\u0016tWM\u001d(b[\u0016\u0004\u0013!F7be.,'o])vKV,\u0007+\u001a:Ce>\\WM]\u000b\u0003\u0003\u000f\u0001\u0002\"!\u0003\u0002\u0014\u0005]\u0011QD\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005EA'\u0001\u0006d_2dWm\u0019;j_:LA!!\u0006\u0002\f\t\u0019Q*\u00199\u0011\u0007M\nI\"C\u0002\u0002\u001cQ\u00121!\u00138u!\ry\u0013qD\u0005\u0004\u0003C9#A\u0004+y]6\u000b'o[3s#V,W/Z\u0001\u0017[\u0006\u00148.\u001a:t#V,W/\u001a)fe\n\u0013xn[3sA\u0005aR.\u0019:lKJ\u001c\u0018+^3vK\u001a{'/\u00168l]><hN\u0011:pW\u0016\u0014XCAA\u000f\u0003ui\u0017M]6feN\fV/Z;f\r>\u0014XK\\6o_^t'I]8lKJ\u0004\u0013A\u0006;y]2{w-\u00119qK:$'+\u001a;ssF+X-^3\u0016\u0005\u0005=\u0002CBA\u0019\u0003{\t\t%\u0004\u0002\u00024)!\u0011QBA\u001b\u0015\u0011\t9$!\u000f\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003w\tAA[1wC&!\u0011qHA\u001a\u0005Ma\u0015N\\6fI\ncwnY6j]\u001e\fV/Z;f!\ry\u00131I\u0005\u0004\u0003\u000b:#A\u0005)f]\u0012LgnZ\"p[BdW\r^3Uq:\fq\u0003\u001e=o\u0019><\u0017\t\u001d9f]\u0012\u0014V\r\u001e:z#V,W/\u001a\u0011\u0002=Q\u0014\u0018M\\:bGRLwN\\:XSRD\u0007+\u001a8eS:<W*\u0019:lKJ\u001cXCAA'!!\t\t$a\u0014\u0002T\u0005\u0005\u0013\u0002BA)\u0003g\u0011\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\u0011\t)&a\u0019\u000f\t\u0005]\u0013q\f\t\u0004\u00033\"TBAA.\u0015\r\ti&L\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0005D'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003K\n9G\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003C\"\u0014a\b;sC:\u001c\u0018m\u0019;j_:\u001cx+\u001b;i!\u0016tG-\u001b8h\u001b\u0006\u00148.\u001a:tA\u0005irO]5uKRCh.T1sW\u0016\u00148OU3rk\u0016\u001cHOV3sg&|g.\u0006\u0002\u0002pA\u00191'!\u001d\n\u0007\u0005MDGA\u0003TQ>\u0014H/\u0001\u0010xe&$X\r\u0016=o\u001b\u0006\u00148.\u001a:t%\u0016\fX/Z:u-\u0016\u00148/[8oA\u0005A1\u000f[;uI><h\u000e\u0006\u0002\u0002|A\u00191'! \n\u0007\u0005}DG\u0001\u0003V]&$\u0018AD9vKV,gi\u001c:Ce>\\WM\u001d\u000b\u0005\u0003\u000b\u000bY\tE\u00034\u0003\u000f\u000bi\"C\u0002\u0002\nR\u0012aa\u00149uS>t\u0007bBAG1\u0001\u0007\u0011qC\u0001\tEJ|7.\u001a:JI\u0006)\u0012/^3vK\u001a{'/\u00168l]><hN\u0011:pW\u0016\u0014\u0018aE1eI6\u000b'o[3sg\u001a{'O\u0011:pW\u0016\u0014H\u0003CA>\u0003+\u000b\t+!*\t\u000f\u0005]%\u00041\u0001\u0002\u001a\u00061!M]8lKJ\u0004B!a'\u0002\u001e6\tq.C\u0002\u0002 >\u0014AAT8eK\"9\u00111\u0015\u000eA\u0002\u0005]\u0011!\u0005;y]R{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011q\u0015\u000eA\u0002\u0005%\u0016A\u0004;y]&#\u0017I\u001c3NCJ\\WM\u001d\t\u0004_\u0005-\u0016bAAWO\t\u0019B\u000b\u001f8JI\u0006sG-T1sW\u0016\u0014XI\u001c;ss\u0006y!/\u001a;ss2{w-\u00119qK:$7/\u0001\thK:,'/\u0019;f%\u0016\fX/Z:ugR\u0011\u0011Q\u0017\t\u0007\u0003o\u000b\t-a2\u000f\t\u0005e\u0016Q\u0018\b\u0005\u00033\nY,C\u00016\u0013\r\ty\fN\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019-!2\u0003\u0011%#XM]1cY\u0016T1!a05!\ry\u0014\u0011Z\u0005\u0004\u0003\u0017\u0004%a\u0007*fcV,7\u000f^!oI\u000e{W\u000e\u001d7fi&|g\u000eS1oI2,'/\u0001\nxe&$X\r\u0016=o\u0007>l\u0007\u000f\\3uS>tG\u0003BA>\u0003#Dq!a5\u001e\u0001\u0004\t\t%\u0001\nqK:$\u0017N\\4D_6\u0004H.\u001a;f)bt\u0017aE1eIRCh.T1sW\u0016\u00148\u000fV8TK:$GCCA>\u00033\fi.!<\u0002x\"9\u00111\u001c\u0010A\u0002\u0005]\u0011\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0011\u001d\tyN\ba\u0001\u0003C\f\u0011\u0002\u001e=o%\u0016\u001cX\u000f\u001c;\u0011\t\u0005\r\u0018\u0011^\u0007\u0003\u0003KT1!a:p\u0003!\u0011X-];fgR\u001c\u0018\u0002BAv\u0003K\u0014\u0011\u0003\u0016:b]N\f7\r^5p]J+7/\u001e7u\u0011\u001d\tyO\ba\u0001\u0003c\f1\u0002\u001e=o\u001b\u0016$\u0018\rZ1uCB\u0019q&a=\n\u0007\u0005UxEA\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\rC\u0004\u0002zz\u0001\r!a?\u0002\u00179,w/T3uC\u0012\fG/\u0019\t\u0004_\u0005u\u0018bAA\u0000O\t\u0011B\u000b\u001f8Ue\u0006t7/\u001b;NKR\fG-\u0019;b\u0003eqW/\u001c+y]N<\u0016\u000e\u001e5QK:$\u0017N\\4NCJ\\WM]:\u0016\u0005\u0005]\u0011\u0001\u00075bgB+g\u000eZ5oO6\u000b'o[3sgR{wK]5uKR!!\u0011\u0002B\b!\r\u0019$1B\u0005\u0004\u0005\u001b!$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003_\u0004\u0003\u0019AAy\u0003]i\u0017-\u001f2f/JLG/\u001a+y]\u000e{W\u000e\u001d7fi&|g\u000e\u0006\u0003\u0002|\tU\u0001b\u0002B\fC\u0001\u0007\u00111K\u0001\u0010iJ\fgn]1di&|g.\u00197JI\u0006qAO]=BaB,g\u000e\u001a+p\u0019><G\u0003BA>\u0005;AqAa\b#\u0001\u0004\t\t%\u0001\u0007uq:dunZ!qa\u0016tG-\u0001\u000ebI\u0012$\u0006P\\'be.,'o\u001d+p\u0005J|7.\u001a:Rk\u0016,X\r\u0006\b\u0002|\t\u0015\"q\u0005B\u0019\u0005k\u0011IDa\u000f\t\u000f\t]1\u00051\u0001\u0002T!9!\u0011F\u0012A\u0002\t-\u0012A\u00039s_\u0012,8-\u001a:JIB\u00191G!\f\n\u0007\t=BG\u0001\u0003M_:<\u0007b\u0002B\u001aG\u0001\u0007\u0011qN\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\t\u000f\t]2\u00051\u0001\u0002b\u00061!/Z:vYRDq!a7$\u0001\u0004\t9\u0002C\u0004\u0003>\r\u0002\rAa\u0010\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004bA!\u0011\u0003H\t-SB\u0001B\"\u0015\u0011\u0011)%a\u0004\u0002\u0013%lW.\u001e;bE2,\u0017\u0002\u0002B%\u0005\u0007\u00121aU3u!\u0011\tYJ!\u0014\n\u0007\t=sN\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002CI,Wn\u001c<f\u001b\u0006\u00148.\u001a:t\r>\u0014H\u000b\u001f8U_BL7\rU1si&$\u0018n\u001c8\u0015\t\u0005m$Q\u000b\u0005\b\u0005/\"\u0003\u0019AA\f\u0003M!\bP\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\%e\u0003U\u0011X-\\8wK6\u000b'o[3sg\u001a{'\u000f\u0016=o\u0013\u0012$B!a\u001f\u0003^!9!qC\u0013A\u0002\u0005M\u0003\"\u0002)\u0004\u0001\u0004\t\u0006BB'\u0004\u0001\u0004\u0011\u0019\u0007\u0005\u0003\u0003f\t%TB\u0001B4\u0015\tiu.\u0003\u0003\u0003l\t\u001d$aB'fiJL7m\u001d\u0005\u0006/\u000e\u0001\r\u0001\u0017\u0005\u0006O\u000e\u0001\r\u0001\u001b\u0005\u0006W\u000e\u0001\r\u0001\u001c\u0005\b\u0005k\u001a\u0001\u0019\u0001B<\u0003)awnZ\"p]R,\u0007\u0010\u001e\t\u0004[\ne\u0014b\u0001B>]\nQAj\\4D_:$X\r\u001f;")
public class TransactionMarkerChannelManager
extends InterBrokerSendThread
implements KafkaMetricsGroup {
    private final MetadataCache metadataCache;
    private final TransactionStateManager txnStateManager;
    private final Time time;
    private final ListenerName interBrokerListenerName;
    private final scala.collection.concurrent.Map<Object, TxnMarkerQueue> markersQueuePerBroker;
    private final TxnMarkerQueue markersQueueForUnknownBroker;
    private final LinkedBlockingQueue<PendingCompleteTxn> txnLogAppendRetryQueue;
    private final ConcurrentHashMap<String, PendingCompleteTxn> transactionsWithPendingMarkers;
    private final short writeTxnMarkersRequestVersion;

    public static TransactionMarkerChannelManager apply(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, TransactionStateManager txnStateManager, Time time, LogContext logContext) {
        return TransactionMarkerChannelManager$.MODULE$.apply(config, metrics, metadataCache, txnStateManager, time, logContext);
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$(this, metricName, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$(this, metricName);
    }

    private ListenerName interBrokerListenerName() {
        return this.interBrokerListenerName;
    }

    private scala.collection.concurrent.Map<Object, TxnMarkerQueue> markersQueuePerBroker() {
        return this.markersQueuePerBroker;
    }

    private TxnMarkerQueue markersQueueForUnknownBroker() {
        return this.markersQueueForUnknownBroker;
    }

    private LinkedBlockingQueue<PendingCompleteTxn> txnLogAppendRetryQueue() {
        return this.txnLogAppendRetryQueue;
    }

    private ConcurrentHashMap<String, PendingCompleteTxn> transactionsWithPendingMarkers() {
        return this.transactionsWithPendingMarkers;
    }

    public short writeTxnMarkersRequestVersion() {
        return this.writeTxnMarkersRequestVersion;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.markersQueuePerBroker().clear();
    }

    public Option<TxnMarkerQueue> queueForBroker(int brokerId) {
        return this.markersQueuePerBroker().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
    }

    public TxnMarkerQueue queueForUnknownBroker() {
        return this.markersQueueForUnknownBroker();
    }

    /*
     * WARNING - void declaration
     */
    public void addMarkersForBroker(Node broker, int txnTopicPartition, TxnIdAndMarkerEntry txnIdAndMarker) {
        Object object;
        void atomicGetOrUpdate_key;
        int brokerId = broker.id();
        Integer n = BoxesRunTime.boxToInteger((int)brokerId);
        scala.collection.concurrent.Map<Object, TxnMarkerQueue> atomicGetOrUpdate_map = this.markersQueuePerBroker();
        Option option = atomicGetOrUpdate_map.get((Object)atomicGetOrUpdate_key);
        if (option instanceof Some) {
            object = ((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            TxnMarkerQueue atomicGetOrUpdate_value = new TxnMarkerQueue(broker);
            object = atomicGetOrUpdate_map.putIfAbsent((Object)atomicGetOrUpdate_key, (Object)atomicGetOrUpdate_value).getOrElse(() -> CoreUtils$.$anonfun$atomicGetOrUpdate$1(atomicGetOrUpdate_value));
        } else {
            throw new MatchError((Object)option);
        }
        Object var6_6 = null;
        n = null;
        option = null;
        Object var9_8 = null;
        TxnMarkerQueue brokerRequestQueue = (TxnMarkerQueue)object;
        brokerRequestQueue.destination_$eq(broker);
        brokerRequestQueue.addMarkers(txnTopicPartition, txnIdAndMarker);
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Added marker ").append(txnIdAndMarker.txnMarkerEntry()).append(" for transactional id ").append(txnIdAndMarker.txnId()).append(" to destination broker ").append(brokerId).toString());
    }

    public void retryLogAppends() {
        ArrayList txnLogAppendRetries = new ArrayList();
        this.txnLogAppendRetryQueue().drainTo(txnLogAppendRetries);
        txnLogAppendRetries.forEach(txnLogAppend -> {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Retry appending ").append(txnLogAppend).append(" transaction log").toString());
            this.tryAppendToLog((PendingCompleteTxn)txnLogAppend);
        });
    }

    @Override
    public Iterable<RequestAndCompletionHandler> generateRequests() {
        this.retryLogAppends();
        ArrayList txnIdAndMarkerEntries = new ArrayList();
        this.markersQueueForUnknownBroker().forEachTxnTopicPartition((Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)x1$1.drainTo(txnIdAndMarkerEntries)));
        CollectionConverters$.MODULE$.ListHasAsScala(txnIdAndMarkerEntries).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$generateRequests$2(check$ifrefutable$1))).foreach((Function1 & Serializable)txnIdAndMarker -> {
            TransactionMarkerChannelManager.$anonfun$generateRequests$3(this, txnIdAndMarker);
            return BoxedUnit.UNIT;
        });
        long currentTimeMs = this.time.milliseconds();
        return (Iterable)((IterableOps)((IterableOps)((IterableOps)this.markersQueuePerBroker().values().filter((Function1 & Serializable)brokerRequestQueue -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$generateRequests$4(this, brokerRequestQueue)))).map((Function1 & Serializable)brokerRequestQueue -> {
            ArrayList txnIdAndMarkerEntries = new ArrayList();
            brokerRequestQueue.forEachTxnTopicPartition((Function2 & Serializable)(x0$2, x1$2) -> BoxesRunTime.boxToInteger((int)x1$2.drainTo(txnIdAndMarkerEntries)));
            return new Tuple2((Object)brokerRequestQueue.destination(), txnIdAndMarkerEntries);
        })).filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$generateRequests$7(x0$3)))).map((Function1 & Serializable)x0$4 -> {
            if (x0$4 != null) {
                Node node = (Node)x0$4._1();
                ArrayList entries = (ArrayList)x0$4._2();
                List markersToSend = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala((List)entries).asScala().map((Function1 & Serializable)x$4 -> x$4.txnMarkerEntry())).asJava();
                TransactionMarkerRequestCompletionHandler requestCompletionHandler = new TransactionMarkerRequestCompletionHandler(node.id(), $this.txnStateManager, this, entries);
                WriteTxnMarkersRequest.Builder request = new WriteTxnMarkersRequest.Builder(this.writeTxnMarkersRequestVersion(), markersToSend);
                return new RequestAndCompletionHandler(currentTimeMs, node, (AbstractRequest.Builder<? extends AbstractRequest>)request, requestCompletionHandler);
            }
            throw new MatchError(null);
        });
    }

    private void writeTxnCompletion(PendingCompleteTxn pendingCompleteTxn) {
        Option option;
        Errors errors;
        String transactionalId = pendingCompleteTxn.transactionalId();
        TransactionMetadata txnMetadata = pendingCompleteTxn.txnMetadata();
        TxnTransitMetadata newMetadata = pendingCompleteTxn.newMetadata();
        int coordinatorEpoch = pendingCompleteTxn.coordinatorEpoch();
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Completed sending transaction markers for ").append(transactionalId).append("; begin transition ").append("to ").append(newMetadata.txnState()).toString());
        boolean bl = false;
        Left left = null;
        boolean bl2 = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.txnStateManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Errors errors2 = (Errors)left.value();
            if (Errors.NOT_COORDINATOR.equals(errors2)) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("No longer the coordinator for ").append(transactionalId).append(" with coordinator epoch ").append(coordinatorEpoch).append("; cancel appending ").append(newMetadata).append(" to transaction log").toString());
                return;
            }
        }
        if (bl && Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(errors = (Errors)left.value())) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(187).append("Loading the transaction partition that contains ").append(transactionalId).append(" while my ").append("current coordinator epoch is ").append(coordinatorEpoch).append("; so cancel appending ").append(newMetadata).append(" to ").append("transaction log since the loading process will continue the remaining work").toString());
            return;
        }
        if (bl) {
            Errors unexpectedError = (Errors)left.value();
            throw new IllegalStateException(new StringBuilder(56).append("Unhandled error ").append(unexpectedError).append(" when fetching current transaction state").toString());
        }
        if (either instanceof Right) {
            bl2 = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (option2 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option2).value();
                if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(116).append("Sending ").append(transactionalId).append("'s transaction markers for ").append(txnMetadata).append(" with ").append("coordinator epoch ").append(coordinatorEpoch).append(" succeeded, trying to append complete transaction log now").toString());
                    this.tryAppendToLog(new PendingCompleteTxn(transactionalId, coordinatorEpoch, txnMetadata, newMetadata));
                    return;
                }
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(178).append("The cached metadata ").append(txnMetadata).append(" has changed to ").append(epochAndMetadata).append(" after ").append("completed sending the markers with coordinator epoch ").append(coordinatorEpoch).append("; abort ").append("transiting the metadata to ").append(newMetadata).append(" as it may have been updated by another process").toString());
                return;
            }
        }
        if (bl2 && None$.MODULE$.equals(option = (Option)right.value())) {
            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", ").append("but there is no metadata in the cache; this is not expected").toString();
            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        throw new MatchError(either);
    }

    public void addTxnMarkersToSend(int coordinatorEpoch, TransactionResult txnResult, TransactionMetadata txnMetadata, TxnTransitMetadata newMetadata) {
        String transactionalId = txnMetadata.transactionalId();
        PendingCompleteTxn pendingCompleteTxn = new PendingCompleteTxn(transactionalId, coordinatorEpoch, txnMetadata, newMetadata);
        this.transactionsWithPendingMarkers().put(transactionalId, pendingCompleteTxn);
        this.addTxnMarkersToBrokerQueue(transactionalId, txnMetadata.producerId(), txnMetadata.producerEpoch(), txnResult, coordinatorEpoch, (Set<TopicPartition>)txnMetadata.topicPartitions().toSet());
        this.maybeWriteTxnCompletion(transactionalId);
    }

    public int numTxnsWithPendingMarkers() {
        return this.transactionsWithPendingMarkers().size();
    }

    private boolean hasPendingMarkersToWrite(TransactionMetadata txnMetadata) {
        return BoxesRunTime.unboxToBoolean(txnMetadata.inLock((JFunction0.mcZ.sp & Serializable)() -> txnMetadata.topicPartitions().nonEmpty()));
    }

    public void maybeWriteTxnCompletion(String transactionalId) {
        Option$.MODULE$.apply((Object)this.transactionsWithPendingMarkers().get(transactionalId)).foreach((Function1 & Serializable)pendingCompleteTxn -> {
            TransactionMarkerChannelManager.$anonfun$maybeWriteTxnCompletion$1(this, transactionalId, pendingCompleteTxn);
            return BoxedUnit.UNIT;
        });
    }

    private void tryAppendToLog(PendingCompleteTxn txnLogAppend) {
        this.txnStateManager.appendTransactionToLog(txnLogAppend.transactionalId(), txnLogAppend.coordinatorEpoch(), txnLogAppend.newMetadata(), (Function1<Errors, BoxedUnit>)(Function1 & Serializable)error -> {
            this.appendCallback$1(error, txnLogAppend);
            return BoxedUnit.UNIT;
        }, (Function1<Errors, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$tryAppendToLog$7(x$5)), RequestLocal$.MODULE$.NoCaching());
    }

    public void addTxnMarkersToBrokerQueue(String transactionalId, long producerId, short producerEpoch, TransactionResult result, int coordinatorEpoch, Set<TopicPartition> topicPartitions) {
        int txnTopicPartition = this.txnStateManager.partitionFor(transactionalId);
        topicPartitions.groupBy((Function1 & Serializable)topicPartition -> $this.metadataCache.getPartitionLeaderEndpoint(topicPartition.topic(), topicPartition.partition(), this.interBrokerListenerName())).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$addTxnMarkersToBrokerQueue$2(check$ifrefutable$2))).foreach((Function1 & Serializable)x$6 -> {
            if (x$6 != null) {
                Option broker = (Option)x$6._1();
                Set topicPartitions = (Set)x$6._2();
                if (broker != null && topicPartitions != null) {
                    if (broker instanceof Some) {
                        Node brokerNode = (Node)((Some)broker).value();
                        WriteTxnMarkersRequest.TxnMarkerEntry marker = new WriteTxnMarkersRequest.TxnMarkerEntry(producerId, producerEpoch, coordinatorEpoch, result, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topicPartitions.toList()).asJava());
                        TxnIdAndMarkerEntry txnIdAndMarker = new TxnIdAndMarkerEntry(transactionalId, marker);
                        Node node = brokerNode;
                        Node node2 = Node.noNode();
                        if (!(node != null ? !node.equals(node2) : node2 != null)) {
                            this.markersQueueForUnknownBroker().addMarkers(txnTopicPartition, txnIdAndMarker);
                            return BoxedUnit.UNIT;
                        }
                        this.addMarkersForBroker(brokerNode, txnTopicPartition, txnIdAndMarker);
                        return BoxedUnit.UNIT;
                    }
                    if (None$.MODULE$.equals(broker)) {
                        Option option;
                        boolean bl = false;
                        Right right = null;
                        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnStateManager.getTransactionState(transactionalId);
                        if (either instanceof Left) {
                            Errors error = (Errors)((Left)either).value();
                            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(127).append("Encountered ").append(error).append(" trying to fetch transaction metadata for ").append(transactionalId).append(" with coordinator epoch ").append(coordinatorEpoch).append("; cancel sending markers to its partition leaders").toString());
                            return this.transactionsWithPendingMarkers().remove(transactionalId);
                        }
                        if (either instanceof Right) {
                            bl = true;
                            right = (Right)either;
                            Option option2 = (Option)right.value();
                            if (option2 instanceof Some) {
                                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option2).value();
                                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch) {
                                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(144).append("The cached metadata has changed to ").append(epochAndMetadata).append(" (old coordinator epoch is ").append(coordinatorEpoch).append(") since preparing to send markers; cancel sending markers to its partition leaders").toString());
                                    return this.transactionsWithPendingMarkers().remove(transactionalId);
                                }
                                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(161).append("Couldn't find leader endpoint for partitions ").append(topicPartitions).append(" while trying to send transaction markers for ").append(transactionalId).append(", these partitions are likely deleted already and hence can be skipped").toString());
                                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                                txnMetadata.inLock((JFunction0.mcV.sp & Serializable)() -> topicPartitions.foreach((Function1 & Serializable)topicPartition -> {
                                    txnMetadata.removePartition(topicPartition);
                                    return BoxedUnit.UNIT;
                                }));
                                this.maybeWriteTxnCompletion(transactionalId);
                                return BoxedUnit.UNIT;
                            }
                        }
                        if (bl && None$.MODULE$.equals(option = (Option)right.value())) {
                            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError(either);
                    }
                    throw new MatchError((Object)broker);
                }
            }
            throw new MatchError(x$6);
        });
        this.wakeup();
    }

    public void removeMarkersForTxnTopicPartition(int txnTopicPartitionId) {
        this.markersQueueForUnknownBroker().removeMarkersForTxnTopicPartition(txnTopicPartitionId).foreach((Function1 & Serializable)queue -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$1(this, queue);
            return BoxedUnit.UNIT;
        });
        this.markersQueuePerBroker().foreach((Function1 & Serializable)x0$1 -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$4(this, txnTopicPartitionId, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void removeMarkersForTxnId(String transactionalId) {
        this.transactionsWithPendingMarkers().remove(transactionalId);
    }

    public final /* synthetic */ int kafka$coordinator$transaction$TransactionMarkerChannelManager$$$anonfun$new$1() {
        return this.markersQueueForUnknownBroker().totalNumMarkers();
    }

    public final /* synthetic */ int kafka$coordinator$transaction$TransactionMarkerChannelManager$$$anonfun$new$2() {
        return this.txnLogAppendRetryQueue().size();
    }

    public static final /* synthetic */ TxnMarkerQueue $anonfun$addMarkersForBroker$1(Node broker$1) {
        return new TxnMarkerQueue(broker$1);
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$2(TxnIdAndMarkerEntry check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$generateRequests$3(TransactionMarkerChannelManager $this, TxnIdAndMarkerEntry txnIdAndMarker) {
        String transactionalId = txnIdAndMarker.txnId();
        long producerId = txnIdAndMarker.txnMarkerEntry().producerId();
        short producerEpoch = txnIdAndMarker.txnMarkerEntry().producerEpoch();
        TransactionResult txnResult = txnIdAndMarker.txnMarkerEntry().transactionResult();
        int coordinatorEpoch = txnIdAndMarker.txnMarkerEntry().coordinatorEpoch();
        Set topicPartitions = CollectionConverters$.MODULE$.ListHasAsScala(txnIdAndMarker.txnMarkerEntry().partitions()).asScala().toSet();
        $this.addTxnMarkersToBrokerQueue(transactionalId, producerId, producerEpoch, txnResult, coordinatorEpoch, (Set<TopicPartition>)topicPartitions);
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$4(TransactionMarkerChannelManager $this, TxnMarkerQueue brokerRequestQueue) {
        return !$this.hasInFlightRequests(brokerRequestQueue.destination());
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$7(Tuple2 x0$3) {
        if (x0$3 != null) {
            return !((ArrayList)x0$3._2()).isEmpty();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$maybeWriteTxnCompletion$1(TransactionMarkerChannelManager $this, String transactionalId$2, PendingCompleteTxn pendingCompleteTxn) {
        if (!$this.hasPendingMarkersToWrite(pendingCompleteTxn.txnMetadata()) && $this.transactionsWithPendingMarkers().remove(transactionalId$2, pendingCompleteTxn)) {
            $this.writeTxnCompletion(pendingCompleteTxn);
            return;
        }
    }

    private final void appendCallback$1(Errors error, PendingCompleteTxn txnLogAppend$2) {
        if (Errors.NONE.equals(error)) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Completed transaction for ").append(txnLogAppend$2.transactionalId()).append(" with coordinator epoch ").append(txnLogAppend$2.coordinatorEpoch()).append(", final state after commit: ").append(txnLogAppend$2.txnMetadata().state()).toString());
            return;
        }
        if (Errors.NOT_COORDINATOR.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(122).append("No longer the coordinator for transactionalId: ").append(txnLogAppend$2.transactionalId()).append(" while trying to append to transaction log, skip writing to transaction log").toString());
            return;
        }
        if (Errors.COORDINATOR_NOT_AVAILABLE.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(76).append("Not available to append ").append(txnLogAppend$2).append(": possible causes include ").append(Errors.UNKNOWN_TOPIC_OR_PARTITION).append(", ").append(Errors.NOT_ENOUGH_REPLICAS).append(", ").append(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND).append(" and ").append(Errors.REQUEST_TIMED_OUT).append("; retry appending").toString());
            this.txnLogAppendRetryQueue().add(txnLogAppend$2);
            return;
        }
        if (Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(149).append("Coordinator is loading the partition ").append($this.txnStateManager.partitionFor(txnLogAppend$2.transactionalId())).append(" and hence cannot complete append of ").append(txnLogAppend$2).append("; ").append("skip writing to transaction log as the loading process should complete it").toString());
            return;
        }
        if (error != null) {
            String errorMsg = new StringBuilder(57).append("Unexpected error ").append(error.exceptionName()).append(" while appending to transaction log for ").append(txnLogAppend$2.transactionalId()).toString();
            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$tryAppendToLog$7(Errors x$5) {
        Errors errors = x$5;
        Errors errors2 = Errors.COORDINATOR_NOT_AVAILABLE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$addTxnMarkersToBrokerQueue$2(Tuple2 check$ifrefutable$2) {
        if (check$ifrefutable$2 != null) {
            Option broker = (Option)check$ifrefutable$2._1();
            Set topicPartitions = (Set)check$ifrefutable$2._2();
            if (broker != null && topicPartitions != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$removeMarkersForTxnTopicPartition$2(TxnIdAndMarkerEntry check$ifrefutable$3) {
        return check$ifrefutable$3 != null;
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$1(TransactionMarkerChannelManager $this, BlockingQueue queue) {
        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)queue).asScala().withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$2(check$ifrefutable$3))).foreach((Function1 & Serializable)entry -> {
            $this.removeMarkersForTxnId(entry.txnId());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$removeMarkersForTxnTopicPartition$6(TxnIdAndMarkerEntry check$ifrefutable$4) {
        return check$ifrefutable$4 != null;
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$5(TransactionMarkerChannelManager $this, BlockingQueue queue) {
        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)queue).asScala().withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$6(check$ifrefutable$4))).foreach((Function1 & Serializable)entry -> {
            $this.removeMarkersForTxnId(entry.txnId());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$4(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ((TxnMarkerQueue)x0$1._2()).removeMarkersForTxnTopicPartition(txnTopicPartitionId$1).foreach((Function1 & Serializable)queue -> {
                TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$5($this, queue);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public TransactionMarkerChannelManager(KafkaConfig config, MetadataCache metadataCache, NetworkClient networkClient, TransactionStateManager txnStateManager, Time time) {
        this.metadataCache = metadataCache;
        this.txnStateManager = txnStateManager;
        this.time = time;
        super(new StringBuilder(22).append("TxnMarkerSenderThread-").append(config.brokerId()).toString(), (KafkaClient)networkClient, Predef$.MODULE$.Integer2int(config.requestTimeoutMs()), time, true);
        this.logIdent_$eq(new StringBuilder(39).append("[Transaction Marker Channel Manager ").append(config.brokerId()).append("]: ").toString());
        this.interBrokerListenerName = config.interBrokerListenerName();
        this.markersQueuePerBroker = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        this.markersQueueForUnknownBroker = new TxnMarkerQueue(Node.noNode());
        this.txnLogAppendRetryQueue = new LinkedBlockingQueue();
        this.transactionsWithPendingMarkers = new ConcurrentHashMap();
        this.writeTxnMarkersRequestVersion = config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_2_8_IV0) ? (short)1 : 0;
        this.newGauge("UnknownDestinationQueueSize", new Gauge<Object>(this){
            private final /* synthetic */ TransactionMarkerChannelManager $outer;

            public final int value() {
                return this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("LogAppendRetryQueueSize", new Gauge<Object>(this){
            private final /* synthetic */ TransactionMarkerChannelManager $outer;

            public final int value() {
                return this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManager$$$anonfun$new$2();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

