/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability;

import java.io.Serializable;
import java.util.Date;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.durability.Utils;
import kafka.durability.audit.DurabilityAuditCheck$;
import kafka.durability.events.DurabilityEventType$;
import kafka.log.AbstractLog;
import kafka.server.HostedPartition;
import kafka.server.ReplicaManager;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.tier.state.SegmentState;
import kafka.utils.CoreUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.Topic;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class Utils$ {
    public static final Utils$ MODULE$ = new Utils$();

    public Option<Tuple4<Object, Object, Object, Set<Object>>> getLiveOffset(ReplicaManager replicaManager, TopicPartition topicPartition) {
        Option<AbstractLog> log = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (log instanceof Some) {
            AbstractLog l = (AbstractLog)((Some)log).value();
            Option<Set<Object>> option = this.getIsrIfLeaderPartition(replicaManager, topicPartition);
            if (option instanceof Some) {
                Set isr = (Set)((Some)option).value();
                return new Some((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)l.highWatermark()), (Object)BoxesRunTime.boxToLong((long)l.logStartOffset()), l.latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1), (Object)isr));
            }
            return None$.MODULE$;
        }
        if (None$.MODULE$.equals(log)) {
            return None$.MODULE$;
        }
        throw new MatchError(log);
    }

    public Option<Set<Object>> getIsrIfLeaderPartition(ReplicaManager replicaManager, TopicPartition topicPartition) {
        HostedPartition hostedPartition = replicaManager.getPartition(topicPartition);
        if (hostedPartition instanceof HostedPartition.Online) {
            Partition partition = ((HostedPartition.Online)hostedPartition).partition();
            if (partition.leaderLogIfLocal() instanceof Some) {
                return Option$.MODULE$.apply(partition.inSyncReplicaIds());
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public int getLocalReplicaEpochIfLeader(ReplicaManager replicaManager, TopicPartition topicPartition) {
        HostedPartition hostedPartition = replicaManager.getPartition(topicPartition);
        if (hostedPartition instanceof HostedPartition.Online) {
            Option<AbstractLog> option = ((HostedPartition.Online)hostedPartition).partition().leaderLogIfLocal();
            if (option instanceof Some) {
                return BoxesRunTime.unboxToInt((Object)((AbstractLog)((Some)option).value()).latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
            }
            return -1;
        }
        return -1;
    }

    public boolean getMirrorState(ReplicaManager replicaManager, TopicPartition topicPartition) {
        HostedPartition hostedPartition = replicaManager.getPartition(topicPartition);
        if (hostedPartition instanceof HostedPartition.Online) {
            return ((HostedPartition.Online)hostedPartition).partition().isActiveLinkDestinationLeader();
        }
        return false;
    }

    public Option<Object> getLogEndOffset(ReplicaManager replicaManager, TopicPartition topicPartition) {
        return replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.logEndOffset()));
    }

    public Option<Object> getLatestEpoch(ReplicaManager replicaManager, TopicPartition topicPartition) {
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some) {
            return ((AbstractLog)((Some)option).value()).latestEpoch();
        }
        return None$.MODULE$;
    }

    public boolean isTieredLog(AbstractLog log) {
        return Predef$.MODULE$.Boolean2boolean(log.config().confluentLogConfig().tierEnable()) && !log.config().compact() && !Topic.isInternal((String)log.topicPartition().topic());
    }

    public Option<Utils.MaxTimestampWithSize> getPreviousTierSegmentInfo(ReplicaManager replicaManager, TopicPartition topicPartition, long offset) {
        boolean bl = false;
        Some some = null;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            AbstractLog log = (AbstractLog)some.value();
            if (!this.isTieredLog(log)) {
                return None$.MODULE$;
            }
        }
        if (bl) {
            Optional<SegmentState> state = ((AbstractLog)some.value()).tierPartitionState().previousMetadataBeforeOffset(offset);
            if (state.isPresent()) {
                return new Some((Object)new Utils.MaxTimestampWithSize(state.get().maxTimestamp(), state.get().size()));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public Option<Utils.MaxTimestampWithSize> getTierSegmentInfoForRange(ReplicaManager replicaManager, TopicPartition topicPartition, long start, long end) {
        AbstractLog log;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some && this.isTieredLog(log = (AbstractLog)((Some)option).value())) {
            Buffer states = CollectionConverters$.MODULE$.ListHasAsScala(log.tierPartitionState().segmentInMemoryMetadataRange(start, end)).asScala();
            if (states.isEmpty()) {
                return None$.MODULE$;
            }
            return new Some((Object)new Utils.MaxTimestampWithSize(BoxesRunTime.unboxToLong((Object)((IterableOnceOps)states.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.maxTimestamp()))).max((Ordering)Ordering.Long$.MODULE$)), BoxesRunTime.unboxToInt((Object)((IterableOnceOps)states.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$))));
        }
        return None$.MODULE$;
    }

    public Option<Object> getEstimatedLogRangeSize(ReplicaManager replicaManager, TopicPartition topicPartition, long startOffset) {
        Option<Utils.MaxTimestampWithSize> option = this.getPreviousTierSegmentInfo(replicaManager, topicPartition, startOffset);
        Option<AbstractLog> option2 = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option2 instanceof Some) {
            AbstractLog log = (AbstractLog)((Some)option2).value();
            if (option instanceof Some) {
                Utils.MaxTimestampWithSize prev = (Utils.MaxTimestampWithSize)((Some)option).value();
                if (log.logStartOffset() == startOffset) {
                    return new Some((Object)BoxesRunTime.boxToLong((long)(log.size() + prev.size())));
                }
                if (log.logStartOffset() > startOffset) {
                    Option<Utils.MaxTimestampWithSize> gapSize = this.getTierSegmentInfoForRange(replicaManager, topicPartition, startOffset, log.logStartOffset() - 1L);
                    if (gapSize.isDefined()) {
                        return new Some((Object)BoxesRunTime.boxToLong((long)(log.size() + prev.size() + ((Utils.MaxTimestampWithSize)gapSize.get()).size())));
                    }
                    return None$.MODULE$;
                }
                Option<Utils.MaxTimestampWithSize> extraSize = this.getTierSegmentInfoForRange(replicaManager, topicPartition, log.logStartOffset(), startOffset - 1L);
                if (extraSize.isDefined()) {
                    return new Some((Object)BoxesRunTime.boxToLong((long)(log.size() - ((Utils.MaxTimestampWithSize)extraSize.get()).size() + prev.size())));
                }
                return None$.MODULE$;
            }
        }
        return None$.MODULE$;
    }

    public int getBrokerId(ReplicaManager replicaManager) {
        return replicaManager.config().brokerId();
    }

    public Option<Object> getLocalLogRetentionSize(ReplicaManager replicaManager, TopicPartition topicPartition) {
        AbstractLog log;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some && (log = (AbstractLog)((Some)option).value()) != null) {
            return new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(log.config().retentionSize())));
        }
        return None$.MODULE$;
    }

    public Option<Object> getLocalLogRetentionMs(ReplicaManager replicaManager, TopicPartition topicPartition) {
        AbstractLog log;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some && (log = (AbstractLog)((Some)option).value()) != null) {
            return new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(log.config().retentionMs())));
        }
        return None$.MODULE$;
    }

    public Option<Object> getLocalStartOffsetForEpoch(ReplicaManager replicaManager, TopicPartition topicPartition, int epoch) {
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some) {
            Option<LeaderEpochFileCache> option2 = ((AbstractLog)((Some)option).value()).leaderEpochCache();
            if (option2 instanceof Some) {
                LeaderEpochFileCache cache = (LeaderEpochFileCache)((Some)option2).value();
                return new Some((Object)BoxesRunTime.boxToLong((long)cache.offsetForEpoch(epoch)));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public boolean isCompacted(ReplicaManager replicaManager, TopicPartition topicPartition) {
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some) {
            return ((AbstractLog)((Some)option).value()).config().compact();
        }
        return false;
    }

    public String consumerRecordMetadata(ConsumerRecord<byte[], byte[]> record) {
        Date date = new Date(record.timestamp());
        return new StringBuilder(34).append("Partition: ").append(record.partition()).append(", Offset: ").append(record.offset()).append(", Timestamp: ").append(date).toString();
    }

    public Set<Enumeration.Value> parseDurabilityEventCsvLists(String events) {
        return ((IterableOnceOps)CoreUtils$.MODULE$.parseCsvList(events).flatMap((Function1 & Serializable)evt -> DurabilityEventType$.MODULE$.withNameOpt((String)evt))).toSet();
    }

    public Set<Enumeration.Value> parseDurabilityAuditsCsvLists(String audits) {
        return ((IterableOnceOps)CoreUtils$.MODULE$.parseCsvList(audits).flatMap((Function1 & Serializable)evt -> DurabilityAuditCheck$.MODULE$.withNameOpt((String)evt))).toSet();
    }

    private Utils$() {
    }
}

