/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import com.amazonaws.AmazonServiceException;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Calendar;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import kafka.durability.audit.AuditJob$;
import kafka.durability.audit.AuditJobResult;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.DurabilityAuditCheck$;
import kafka.durability.audit.DurabilityAuditConfig;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.PartialAuditJobResult;
import kafka.durability.db.AuditRunState;
import kafka.durability.db.ConfigFlag$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState;
import kafka.durability.db.PartitionState$;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.durability.utils.CommitAndSwapEvent;
import kafka.durability.utils.DurabilityTierTopicReader;
import kafka.durability.utils.TierTopicEvents;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.TierLogSegment;
import kafka.server.HostedPartition;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierUtils;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tools.TierMetadataValidator;
import kafka.tier.topic.TierTopicPartitioner;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011\ra\u0001B A\u0001\u001dC\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\tu\u0002\u0011\t\u0011)A\u0005w\"Y\u00111\u0001\u0001\u0003\u0006\u0004%\t\u0001QA\u0003\u0011)\t9\u0002\u0001B\u0001B\u0003%\u0011q\u0001\u0005\u000b\u00033\u0001!\u0011!Q\u0001\n\u0005m\u0001BCA\u0012\u0001\t\u0005\t\u0015!\u0003\u0002&!Q\u00111\u0006\u0001\u0003\u0002\u0003\u0006I!!\f\t\u0015\u0005\r\u0003A!A!\u0002\u0013\t)\u0005\u0003\u0006\u0002P\u0001\u0011)\u0019!C\u0001\u0003#B!\"! \u0001\u0005\u0003\u0005\u000b\u0011BA*\u0011)\ty\b\u0001BC\u0002\u0013\u0005\u0011\u0011\u0011\u0005\u000b\u0003\u0013\u0003!\u0011!Q\u0001\n\u0005\r\u0005BCAF\u0001\t\u0015\r\u0011\"\u0001\u0002\u000e\"Q\u0011\u0011\u0014\u0001\u0003\u0002\u0003\u0006I!a$\t\u0015\u0005m\u0005A!b\u0001\n\u0003\ti\n\u0003\u0006\u0002.\u0002\u0011\t\u0011)A\u0005\u0003?Cq!a,\u0001\t\u0003\t\t\fC\u0005\u0002L\u0002\u0001\r\u0011\"\u0003\u0002N\"I\u0011q\u001a\u0001A\u0002\u0013%\u0011\u0011\u001b\u0005\t\u0003;\u0004\u0001\u0015)\u0003\u0002&!I\u0011q\u001d\u0001A\u0002\u0013%\u0011\u0011\u001e\u0005\n\u0003W\u0004\u0001\u0019!C\u0005\u0003[Dq!!=\u0001A\u0003&q\u000fC\u0005\u0002t\u0002\u0001\r\u0011\"\u0003\u0002j\"I\u0011Q\u001f\u0001A\u0002\u0013%\u0011q\u001f\u0005\b\u0003w\u0004\u0001\u0015)\u0003x\u0011\u001d\ti\u0010\u0001C\u0005\u0003\u007fDqAa\u0003\u0001\t\u0003\u0012i\u0001\u0003\u0005\u0003\u0010\u0001!\tA\u0011B\t\u0011!\u0011)\u0003\u0001C\u0001\u0005\n\u001d\u0002b\u0002B\u0017\u0001\u0011%!q\u0006\u0005\b\u0005k\u0001A\u0011\u0002B\u001c\u0011!\u0011)\u0005\u0001C\u0001\u0005\n\u001d\u0003\u0002\u0003B'\u0001\u0011\u0005!Ia\u0014\t\u0013\t5\u0004A1A\u0005\n\t=\u0004\u0002\u0003BB\u0001\u0001\u0006IA!\u001d\t\u0011\t\u0015\u0005\u0001\"\u0005A\u0005\u000fC\u0001B!)\u0001\t\u0003\u0011%1\u0015\u0005\t\u0005g\u0003A\u0011\u0001\"\u00036\"A!Q\u001a\u0001\u0005\u0002\t\u0013y\r\u0003\u0005\u0003R\u0002!\tA\u0011Bj\u0011!\u0011\u0019\u000f\u0001C\u0001\u0005\n\u0015\b\u0002\u0003Bv\u0001\u0011\u0005\u0001I!<\t\u0011\t}\b\u0001\"\u0001A\u0007\u0003A\u0001b!\t\u0001\t\u0003\u000151\u0005\u0005\t\u0007\u000b\u0002A\u0011\u0001!\u0004H!91\u0011\f\u0001\u0005\n\rm\u0003bBB9\u0001\u0011%11\u000f\u0005\t\u0007o\u0002A\u0011\u0001!\u0004z!91Q\u0011\u0001\u0005\n\r\u001duaBB]\u0001\"\u000511\u0018\u0004\u0007\u007f\u0001C\ta!0\t\u000f\u0005=F\u0007\"\u0001\u0004F\"91q\u0019\u001b\u0005\u0002\r%\u0007bBBhi\u0011\u00051\u0011\u001b\u0005\u000b\u00077$$\u0019!C\u0001\u0001\u0006%\bbBBoi\u0001\u0006Ia\u001e\u0005\u000b\u0007?$$\u0019!C\u0001\u0001\u00065\u0007\u0002CBqi\u0001\u0006I!!\n\t\u0013\r\rH'%A\u0005\u0002\r\u0015\b\"CB|iE\u0005I\u0011AB}\u0011%\u0019i\u0010NI\u0001\n\u0003\u0019yP\u0001\u0005Bk\u0012LGOS8c\u0015\t\t%)A\u0003bk\u0012LGO\u0003\u0002D\t\u0006QA-\u001e:bE&d\u0017\u000e^=\u000b\u0003\u0015\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u0011B\u001b\u0006CA%O\u001b\u0005Q%BA&M\u0003\u0011a\u0017M\\4\u000b\u00035\u000bAA[1wC&\u0011qJ\u0013\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005%\u000b\u0016B\u0001*K\u0005!\u0011VO\u001c8bE2,\u0007C\u0001+X\u001b\u0005)&B\u0001,E\u0003\u0015)H/\u001b7t\u0013\tAVKA\u0004M_\u001e<\u0017N\\4\u0002'Q|\u0007/[2QCJ$\u0018\u000e^5p]NLeNZ8\u0011\u0007m+\u0007N\u0004\u0002]E:\u0011Q\fY\u0007\u0002=*\u0011qLR\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005\fQa]2bY\u0006L!a\u00193\u0002\u000fA\f7m[1hK*\t\u0011-\u0003\u0002gO\n\u00191+Z9\u000b\u0005\r$\u0007\u0003B5kY^l\u0011\u0001Z\u0005\u0003W\u0012\u0014a\u0001V;qY\u0016\u0014\u0004CA7v\u001b\u0005q'BA8q\u0003\u0019\u0019w.\\7p]*\u0011Q)\u001d\u0006\u0003eN\fa!\u00199bG\",'\"\u0001;\u0002\u0007=\u0014x-\u0003\u0002w]\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007CA5y\u0013\tIHM\u0001\u0003M_:<\u0017A\u00037pO6\u000bg.Y4feB\u0011Ap`\u0007\u0002{*\u0011a\u0010R\u0001\u0004Y><\u0017bAA\u0001{\nQAj\\4NC:\fw-\u001a:\u0002'=t7i\\7qY\u0016$XmU5h]\u0006dG.\u001a:\u0016\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003'i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u000bG>t7-\u001e:sK:$(bAA\t\u0019\u0006!Q\u000f^5m\u0013\u0011\t)\"a\u0003\u0003\u001d\r{WO\u001c;E_^tG*\u0019;dQ\u0006!rN\\\"p[BdW\r^3TS\u001et\u0017\r\u001c7fe\u0002\nQ\"Y;eSR\u0014V\r]8si\u0016\u0014\b\u0003BA\u000f\u0003?i\u0011\u0001Q\u0005\u0004\u0003C\u0001%!D!vI&$(+\u001a9peR,'/A\u0003k_\nLE\rE\u0002j\u0003OI1!!\u000be\u0005\rIe\u000e^\u0001\u0010i&,'o\u00142k'R|'/Z(qiB)\u0011.a\f\u00024%\u0019\u0011\u0011\u00073\u0003\r=\u0003H/[8o!\u0011\t)$a\u0010\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\tQa\u001d;pe\u0016T1!!\u0010E\u0003\u0011!\u0018.\u001a:\n\t\u0005\u0005\u0013q\u0007\u0002\u0010)&,'o\u00142kK\u000e$8\u000b^8sK\u0006!A/[7f!\u0011\t9%a\u0013\u000e\u0005\u0005%#B\u0001,o\u0013\u0011\ti%!\u0013\u0003\tQKW.Z\u0001\u000eCV$\u0017\u000e^:BY2|w/\u001a3\u0016\u0005\u0005M\u0003CBA+\u0003;\n\u0019G\u0004\u0003\u0002X\u0005e\u0003CA/e\u0013\r\tY\u0006Z\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0013\u0011\r\u0002\u0004'\u0016$(bAA.IB!\u0011QMA<\u001d\u0011\t9'a\u001d\u000f\t\u0005%\u0014\u0011\u000f\b\u0005\u0003W\nyGD\u0002^\u0003[J\u0011!R\u0005\u0003\u0007\u0012K!!\u0011\"\n\u0007\u0005U\u0004)\u0001\u000bEkJ\f'-\u001b7jif\fU\u000fZ5u\u0007\",7m[\u0005\u0005\u0003s\nYH\u0001\u000bEkJ\f'-\u001b7jif\fU\u000fZ5u\u0007\",7m\u001b\u0006\u0004\u0003k\u0002\u0015AD1vI&$8/\u00117m_^,G\rI\u0001\u0007G>tg-[4\u0016\u0005\u0005\r\u0005\u0003BA\u000f\u0003\u000bK1!a\"A\u0005U!UO]1cS2LG/_!vI&$8i\u001c8gS\u001e\fqaY8oM&<\u0007%\u0001\u0002eEV\u0011\u0011q\u0012\t\u0005\u0003#\u000b)*\u0004\u0002\u0002\u0014*\u0019\u00111\u0012\"\n\t\u0005]\u00151\u0013\u0002\r\tV\u0014\u0018MY5mSRLHIQ\u0001\u0004I\n\u0004\u0013!\u0004:fa2L7-Y'he>\u0003H/\u0006\u0002\u0002 B)\u0011.a\f\u0002\"B!\u00111UAU\u001b\t\t)KC\u0002\u0002(\u0012\u000baa]3sm\u0016\u0014\u0018\u0002BAV\u0003K\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'/\u0001\bsKBd\u0017nY1NOJ|\u0005\u000f\u001e\u0011\u0002\rqJg.\u001b;?)a\t\u0019,!.\u00028\u0006e\u00161XA_\u0003\u007f\u000b\t-a1\u0002F\u0006\u001d\u0017\u0011\u001a\t\u0004\u0003;\u0001\u0001\"B-\u0012\u0001\u0004Q\u0006\"\u0002>\u0012\u0001\u0004Y\bbBA\u0002#\u0001\u0007\u0011q\u0001\u0005\b\u00033\t\u0002\u0019AA\u000e\u0011\u001d\t\u0019#\u0005a\u0001\u0003KAq!a\u000b\u0012\u0001\u0004\ti\u0003C\u0005\u0002DE\u0001\n\u00111\u0001\u0002F!I\u0011qJ\t\u0011\u0002\u0003\u0007\u00111\u000b\u0005\b\u0003\u007f\n\u0002\u0019AAB\u0011\u001d\tY)\u0005a\u0001\u0003\u001fC\u0011\"a'\u0012!\u0003\u0005\r!a(\u0002/I,W.Y5oS:<\u0007+\u0019:uSRLwN\\\"pk:$XCAA\u0013\u0003m\u0011X-\\1j]&tw\rU1si&$\u0018n\u001c8D_VtGo\u0018\u0013fcR!\u00111[Am!\rI\u0017Q[\u0005\u0004\u0003/$'\u0001B+oSRD\u0011\"a7\u0014\u0003\u0003\u0005\r!!\n\u0002\u0007a$\u0013'\u0001\rsK6\f\u0017N\\5oOB\u000b'\u000f^5uS>t7i\\;oi\u0002B3\u0001FAq!\rI\u00171]\u0005\u0004\u0003K$'\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002AQ|G/\u00197PM\u001a\u001cX\r^\"pk:$\u0018i\u0019:pgN\u0004\u0016M\u001d;ji&|gn]\u000b\u0002o\u0006!Co\u001c;bY>3gm]3u\u0007>,h\u000e^!de>\u001c8\u000fU1si&$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0003\u0002T\u0006=\b\u0002CAn-\u0005\u0005\t\u0019A<\u0002CQ|G/\u00197PM\u001a\u001cX\r^\"pk:$\u0018i\u0019:pgN\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002;Q|G/\u00197HCB\u001cu.\u001e8u\u0003\u000e\u0014xn]:QCJ$\u0018\u000e^5p]N\f\u0011\u0005^8uC2<\u0015\r]\"pk:$\u0018i\u0019:pgN\u0004\u0016M\u001d;ji&|gn]0%KF$B!a5\u0002z\"A\u00111\\\r\u0002\u0002\u0003\u0007q/\u0001\u0010u_R\fGnR1q\u0007>,h\u000e^!de>\u001c8\u000fU1si&$\u0018n\u001c8tA\u0005)R\u000f\u001d3bi\u0016Le\u000e^3s]\u0006dW*\u001a;sS\u000e\u001cH\u0003BAj\u0005\u0003AqAa\u0001\u001c\u0001\u0004\u0011)!\u0001\u0004sKN,H\u000e\u001e\t\u0005\u0003;\u00119!C\u0002\u0003\n\u0001\u0013a\"Q;eSRTuN\u0019*fgVdG/A\u0002sk:$\"!a5\u0002-\u0005,H-\u001b;SKR,g\u000e^5p]\n\u000b7/\u001a3M_\u001e$bA!\u0002\u0003\u0014\tm\u0001B\u0002@\u001e\u0001\u0004\u0011)\u0002E\u0002}\u0005/I1A!\u0007~\u0005-\t%m\u001d;sC\u000e$Hj\\4\t\u000f\tuQ\u00041\u0001\u0003 \u0005iAn\\2bY2{w-\u00133f]R\u0004B!!\u0016\u0003\"%!!1EA1\u0005\u0019\u0019FO]5oO\u0006)\u0012-\u001e3jiRKWM]\"p[B\f7\r^3e\u0019><GC\u0002B\u0003\u0005S\u0011Y\u0003\u0003\u0004\u007f=\u0001\u0007!Q\u0003\u0005\b\u0005;q\u0002\u0019\u0001B\u0010\u0003I\tW\u000fZ5u\rR\u00048o\u00115fG.\u001cX/\\:\u0015\r\u0005M'\u0011\u0007B\u001a\u0011\u0019qx\u00041\u0001\u0003\u0016!9!QD\u0010A\u0002\t}\u0011!D8oG\u0016\u001cu.\u001c9bGR,G\r\u0006\u0004\u0003:\t}\"\u0011\t\t\u0004S\nm\u0012b\u0001B\u001fI\n9!i\\8mK\u0006t\u0007B\u0002@!\u0001\u0004\u0011)\u0002\u0003\u0004\u0003D\u0001\u0002\ra^\u0001\u000ei>\u0004\u0018n\u0019#c\u0007>tg-[4\u0002\u001b\u0011|\u0017)\u001e3jiN\u000bg-\u001a7z)\u0019\u0011)A!\u0013\u0003L!1a0\ta\u0001\u0005+AaAa\u0011\"\u0001\u00049\u0018!\u0006<fe&4\u0017\u0010T8dC2dunZ*fO6,g\u000e\u001e\u000b\u000b\u0005#\u00129Fa\u0017\u0003f\t-\u0004\u0003BA\u000f\u0005'J1A!\u0016A\u0005U\u0001\u0016M\u001d;jC2\fU\u000fZ5u\u0015>\u0014'+Z:vYRDaA!\u0017#\u0001\u0004a\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0005;\u0012\u0003\u0019\u0001B0\u0003\u001d\u0019XmZ7f]R\u00042\u0001 B1\u0013\r\u0011\u0019' \u0002\u000b\u0019><7+Z4nK:$\bb\u0002B4E\u0001\u0007!\u0011N\u0001\u0015aJ,g/[8vg\u0016sGm\u00144gg\u0016$x\n\u001d;\u0011\t%\fyc\u001e\u0005\u0007}\n\u0002\rA!\u0006\u0002\u0019M\u001cTI\u001d:pe\u000e{G-Z:\u0016\u0005\tE\u0004C\u0002B:\u0005{\u0012y(\u0004\u0002\u0003v)!!q\u000fB=\u0003%IW.\\;uC\ndWMC\u0002\u0003|\u0011\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\tyF!\u001e\u0011\u0007%\u0013\t)C\u0002\u0003$)\u000bQb]\u001aFeJ|'oQ8eKN\u0004\u0013\u0001E:i_VdGmQ8v]Rd\u0015\r]:f)\u0011\u0011ID!#\t\u000f\t-U\u00051\u0001\u0003\u000e\u0006!B/[3s-\u0006d\u0017\u000eZ1uS>t'+Z:vYR\u0004BAa$\u0003\u001c:!!\u0011\u0013BL\u001b\t\u0011\u0019J\u0003\u0003\u0003\u0016\u0006m\u0012!\u0002;p_2\u001c\u0018\u0002\u0002BM\u0005'\u000bQ\u0003V5fe6+G/\u00193bi\u00064\u0016\r\\5eCR|'/\u0003\u0003\u0003\u001e\n}%AF(gMN,GOV1mS\u0012\fG/[8o%\u0016\u001cX\u000f\u001c;\u000b\t\te%1S\u0001\u001bm\u0016\u0014\u0018NZ=US\u0016\u0014X\r\u001a'pON+w-\\3oiNK'0\u001a\u000b\t\u0003'\u0014)Ka*\u00030\"1!\u0011\f\u0014A\u00021DqA!\u0018'\u0001\u0004\u0011I\u000bE\u0002}\u0005WK1A!,~\u00059!\u0016.\u001a:M_\u001e\u001cVmZ7f]RDaA!-'\u0001\u00049\u0018\u0001B:ju\u0016\faC^3sS\u001aLH+[3sK\u0012dunZ*fO6,g\u000e\u001e\u000b\u000f\u0005#\u00129L!/\u0003<\nu&\u0011\u0019Bf\u0011\u0019\u0011If\na\u0001Y\"9!QL\u0014A\u0002\t%\u0006b\u0002B4O\u0001\u0007!\u0011\u000e\u0005\b\u0005\u007f;\u0003\u0019AA\u0017\u0003-y'M[*u_J,w\n\u001d;\t\u000f\t\rw\u00051\u0001\u0003F\u0006\u0019b-\u001b:tiZ\u000bG.\u001b3PM\u001a\u001cX\r^$f]B)\u0011Na2mo&\u0019!\u0011\u001a3\u0003\u0013\u0019+hn\u0019;j_:\f\u0004b\u0002B\u001bO\u0001\u0007!\u0011H\u0001\u000bSN\u001cu.\u001c9mKR,WC\u0001B\u001d\u0003y\u0001XO\u00197jg\"Le\u000e^3s[\u0016$\u0017.\u0019;f\u0019\u0006\u00048/Z*bM\u0016d\u0017\u0010\u0006\u0006\u0002T\nU'q\u001bBn\u0005?DaA!\u0017*\u0001\u0004a\u0007B\u0002BmS\u0001\u0007q/A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\bB\u0002BoS\u0001\u0007q/\u0001\u0005hCB\u001cu.\u001e8u\u0011\u001d\u0011\t/\u000ba\u0001\u0005?\t1!\\:h\u0003M\u0001XO\u00197jg\"\u0014Vm];miN\u000bg-\u001a7z)\u0011\t\u0019Na:\t\u000f\t%(\u00061\u0001\u0003\u0006\u0005q\u0011-\u001e3ji*{'MU3tk2$\u0018A\u0007<fe&4\u0017\u0010V5fe\u0016$7+Z4nK:$8oU1gK2LHC\u0003B)\u0005_\u0014\tPa?\u0003~\"1!\u0011L\u0016A\u00021DqAa=,\u0001\u0004\u0011)0A\tuS\u0016\u0014X\r\u001a'pON+w-\\3oiN\u0004Ra\u0017B|\u0005SK1A!?h\u0005!IE/\u001a:bi>\u0014\bb\u0002BbW\u0001\u0007!Q\u0019\u0005\b\u0005kY\u0003\u0019\u0001B\u001d\u0003i)\b\u000fZ1uKZ+'/\u001b4jK\u0012\u001cVmZ7f]R\u001c\u0018J\u001c#C)!\t\u0019na\u0001\u0004\u0010\ru\u0001bBB\u0003Y\u0001\u00071qA\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004Ba!\u0003\u0004\f5\u0011\u00111H\u0005\u0005\u0007\u001b\tYD\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\"91\u0011\u0003\u0017A\u0002\rM\u0011a\u00053fgRLg.\u0019;j_:\u001cVmZ7f]R\u001c\bCBA+\u0003;\u001a)\u0002\u0005\u0003\u0004\u0018\reQBAA\b\u0013\u0011\u0019Y\"a\u0004\u0003\tU+\u0016\n\u0012\u0005\u0007\u0007?a\u0003\u0019A<\u0002'1\f7\u000f^\"p[B\f7\r^3e\u001f\u001a47/\u001a;\u0002CY\fG.\u001b3bi\u0016\u001c8k\\;sG\u00164uN]'jgNLgnZ*fO6,g\u000e^:\u0015\u0015\u0005M7QEB\u0015\u0007[\u0019\u0019\u0005C\u0004\u0004(5\u0002\raa\u0005\u0002\u001dU\u0004Hn\\1e'\u0016<W.\u001a8ug\"911F\u0017A\u0002\rM\u0011AD:pkJ\u001cWmU3h[\u0016tGo\u001d\u0005\b\u0007_i\u0003\u0019AB\u0019\u0003)\u0019XmZ7f]Rl\u0015\r\u001d\t\t\u0003+\u001a\u0019d!\u0006\u00048%!1QGA1\u0005\ri\u0015\r\u001d\t\u0005\u0007s\u0019y$\u0004\u0002\u0004<)!1QHA\u001e\u0003\u0019!w.\\1j]&!1\u0011IB\u001e\u0005e!\u0016.\u001a:TK\u001elWM\u001c;Va2|\u0017\rZ%oSRL\u0017\r^3\t\r\r}Q\u00061\u0001x\u0003a1XM]5gs\u000e{W\u000e]1di\u0016$\u0007+\u0019:uSRLwN\u001c\u000b\u0007\u0003'\u001cIea\u0013\t\u000f\r\u0015a\u00061\u0001\u0004\b!91Q\n\u0018A\u0002\r=\u0013a\u0004;jKJ$v\u000e]5d\u000bZ,g\u000e^:\u0011\t\rE3QK\u0007\u0003\u0007'R!A\u0016\"\n\t\r]31\u000b\u0002\u0010)&,'\u000fV8qS\u000e,e/\u001a8ug\u0006\u0011r-\u001a;US\u0016\u0014Hk\u001c9jG\u00163XM\u001c;t)\u0019\u0019ifa\u001a\u0004nAA1qLB3\u0007\u000f\u0019y%\u0004\u0002\u0004b)!11\rB=\u0003\u001diW\u000f^1cY\u0016LAa!\u000e\u0004b!91\u0011N\u0018A\u0002\r-\u0014a\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o\u001b\u0006\u0004\bcBA+\u0007g\u00199a\u001e\u0005\b\u0007_z\u0003\u0019AA\u0013\u0003)\u0011X\r\u001e:z\u0007>,h\u000e^\u0001\u001am\u0016\u0014\u0018NZ=D_6\u0004\u0018m\u0019;fIB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0002T\u000eU\u0004bBB5a\u0001\u000711N\u0001\u001dCV$\u0017\u000e\u001e+jKJ\u001cu.\u001c9bGR,G\rU1si&$\u0018n\u001c8t)\u0011\t\u0019na\u001f\t\u000f\ru\u0014\u00071\u0001\u0004\u0000\u0005YB/[3s\u0007>l\u0007/Y2uK\u0012\u0004\u0016M\u001d;ji&|gn\u001d'jgR\u0004baa\u0018\u0004\u0002\u000e\u001d\u0011\u0002BBB\u0007C\u0012!\u0002T5ti\n+hMZ3s\u0003]\u0019\u0017\r^2i+B|e\u000eV5fe\u0016$7+Z4nK:$8\u000f\u0006\u0007\u0003R\r%5\u0011TBR\u0007O\u001bI\u000bC\u0004\u0004\fJ\u0002\ra!$\u0002%QLWM\u001d)beRLG/[8o'R\fG/\u001a\t\u0005\u0007\u001f\u001b)*\u0004\u0002\u0004\u0012*!11SA\u001e\u0003\u0015\u0019H/\u0019;f\u0013\u0011\u00199j!%\u0003%QKWM\u001d)beRLG/[8o'R\fG/\u001a\u0005\b\u00077\u0013\u0004\u0019ABO\u0003MawnY1m'R\f'\u000f^(gMN,GoR3o!\u0011I7qT<\n\u0007\r\u0005FMA\u0005Gk:\u001cG/[8oa!91Q\u0015\u001aA\u0002\tE\u0013A\u00049sKZLw.^:SKN,H\u000e\u001e\u0005\b\u0005\u0007\u0014\u0004\u0019\u0001Bc\u0011\u001d\u0011)D\ra\u0001\u0005sA3AMBW!\u0011\u0019yk!.\u000e\u0005\rE&bABZI\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r]6\u0011\u0017\u0002\bi\u0006LGN]3d\u0003!\tU\u000fZ5u\u0015>\u0014\u0007cAA\u000fiM\u0019Aga0\u0011\u0007%\u001c\t-C\u0002\u0004D\u0012\u0014a!\u00118z%\u00164GCAB^\u00039\u0019\bn\\;mI\u0006+H-\u001b;M_\u001e$Baa3\u0004NB)\u0011.a\f\u0003 !1aP\u000ea\u0001\u0005+\tQcZ3u)&,'o\u00142kK\u000e$X*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0004T\u000ee\u0007\u0003BB\u001d\u0007+LAaa6\u0004<\t\u0011B+[3s\u001f\nTWm\u0019;NKR\fG-\u0019;b\u0011\u001d\u0011if\u000ea\u0001\u0005S\u000bQb\u0015'F\u000bB{F+S'F?6\u001b\u0016AD*M\u000b\u0016\u0003v\fV%N\u000b~k5\u000bI\u0001\u0018)&+%kX*F\u000f6+e\nV0C\u0003R\u001b\u0005jX*J5\u0016\u000b\u0001\u0004V%F%~\u001bViR'F\u001dR{&)\u0011+D\u0011~\u001b\u0016JW#!\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u00111q\u001d\u0016\u0005\u0003\u000b\u001aIo\u000b\u0002\u0004lB!1Q^Bz\u001b\t\u0019yO\u0003\u0003\u0004r\u000eE\u0016!C;oG\",7m[3e\u0013\u0011\u0019)pa<\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005O\u000b\u0003\u0007wTC!a\u0015\u0004j\u0006aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\nTC\u0001C\u0001U\u0011\tyj!;")
public class AuditJob
implements Runnable,
Logging {
    private final Seq<Tuple2<TopicPartition, Object>> topicPartitionsInfo;
    private final LogManager logManager;
    private final CountDownLatch onCompleteSignaller;
    private final AuditReporter auditReporter;
    private final int jobId;
    private final Option<TierObjectStore> tierObjStoreOpt;
    private final Time time;
    private final scala.collection.immutable.Set<Enumeration.Value> auditsAllowed;
    private final DurabilityAuditConfig config;
    private final DurabilityDB db;
    private final Option<ReplicaManager> replicaMgrOpt;
    private volatile int remainingPartitionCount;
    private long totalOffsetCountAcrossPartitions;
    private long totalGapCountAcrossPartitions;
    private final scala.collection.immutable.Set<String> s3ErrorCodes;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<ReplicaManager> $lessinit$greater$default$11() {
        return None$.MODULE$;
    }

    public static scala.collection.immutable.Set<Enumeration.Value> $lessinit$greater$default$8() {
        return AuditJob$.MODULE$.$lessinit$greater$default$8();
    }

    public static Time $lessinit$greater$default$7() {
        return Time.SYSTEM;
    }

    public static TierObjectMetadata getTierObjectMetadata(TierLogSegment segment) {
        return AuditJob$.MODULE$.getTierObjectMetadata(segment);
    }

    public static Option<String> shouldAuditLog(AbstractLog log) {
        return AuditJob$.MODULE$.shouldAuditLog(log);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CountDownLatch onCompleteSignaller() {
        return this.onCompleteSignaller;
    }

    public scala.collection.immutable.Set<Enumeration.Value> auditsAllowed() {
        return this.auditsAllowed;
    }

    public DurabilityAuditConfig config() {
        return this.config;
    }

    public DurabilityDB db() {
        return this.db;
    }

    public Option<ReplicaManager> replicaMgrOpt() {
        return this.replicaMgrOpt;
    }

    private int remainingPartitionCount() {
        return this.remainingPartitionCount;
    }

    private void remainingPartitionCount_$eq(int x$1) {
        this.remainingPartitionCount = x$1;
    }

    private long totalOffsetCountAcrossPartitions() {
        return this.totalOffsetCountAcrossPartitions;
    }

    private void totalOffsetCountAcrossPartitions_$eq(long x$1) {
        this.totalOffsetCountAcrossPartitions = x$1;
    }

    private long totalGapCountAcrossPartitions() {
        return this.totalGapCountAcrossPartitions;
    }

    private void totalGapCountAcrossPartitions_$eq(long x$1) {
        this.totalGapCountAcrossPartitions = x$1;
    }

    private void updateInternalMetrics(AuditJobResult result) {
        this.totalOffsetCountAcrossPartitions_$eq(this.totalOffsetCountAcrossPartitions() + result.totalOffsetCount());
        this.totalGapCountAcrossPartitions_$eq(this.totalGapCountAcrossPartitions() + result.totalGapCount());
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(97).append("Finished topicPartition: ").append(result.topicPartition()).append(", error: ").append(result.errorOpt().isDefined()).append(" ").append("totalOffsetCount: ").append(this.totalOffsetCountAcrossPartitions()).append(", totalGapCount: ").append(this.totalGapCountAcrossPartitions()).append(", ").append("remainingPartitionCount: ").append(this.remainingPartitionCount()).toString());
    }

    @Override
    public void run() {
        Object object = new Object();
        try {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("Going to start execution for the audit run with topicPartition count: ").append($this.topicPartitionsInfo.size()).toString());
            Instant startTime = this.auditReporter.startAuditJob();
            try {
                try {
                    ListBuffer tierCompactedPartitionsList = new ListBuffer();
                    this.topicPartitionsInfo.foreach((Function1 & Serializable)x0$1 -> {
                        if (x0$1 != null) {
                            TopicPartition topicPartition = (TopicPartition)x0$1._1();
                            long topicDbConfig = x0$1._2$mcJ$sp();
                            if (this.onCompleteSignaller().getCount() == 0L) {
                                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                            }
                            Option<AbstractLog> option = $this.logManager.getLog(topicPartition, $this.logManager.getLog$default$2());
                            if (option instanceof Some) {
                                AbstractLog log = (AbstractLog)((Some)option).value();
                                long partitionStartTimeMs = $this.time.hiResClockMs();
                                AuditJobResult result = this.doAuditSafely(log, topicDbConfig);
                                if (result.errorOpt().isEmpty()) {
                                    this.updateInternalMetrics(result);
                                    this.publishResultSafely(result);
                                    long partitionDurationTimeMs = $this.time.hiResClockMs() - partitionStartTimeMs;
                                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Completed audit for ").append(topicPartition).append(" in ").append(partitionDurationTimeMs / 1000L).append(" seconds").toString());
                                }
                                if (log.isTierCompactable()) {
                                    return tierCompactedPartitionsList.$plus$eq((Object)new TopicIdPartition(topicPartition.topic(), CoreUtils$.MODULE$.toJavaUUID((Uuid)log.topicId().getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID)), topicPartition.partition()));
                                }
                                return BoxedUnit.UNIT;
                            }
                            if (None$.MODULE$.equals(option)) {
                                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("AbstractLog not found for: ").append(topicPartition).toString());
                                return BoxedUnit.UNIT;
                            }
                            throw new MatchError(option);
                        }
                        throw new MatchError(null);
                    });
                    if (this.auditsAllowed().contains((Object)DurabilityAuditCheck$.MODULE$.CompactTopicAudit())) {
                        this.auditTierCompactedPartitions((ListBuffer<TopicIdPartition>)tierCompactedPartitionsList);
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> "Received interrupted exception, will shutdown");
                }
                catch (Exception e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Received error while executing, will exit", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    throw e;
                }
            }
            finally {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(90).append("Completed execution for audit run with totalOffsetCount: ").append(this.totalOffsetCountAcrossPartitions()).append(" ").append("and totalGapCount: ").append(this.totalGapCountAcrossPartitions()).append(" in ").append(Duration.between(startTime, Instant.ofEpochMilli($this.time.milliseconds()))).append("  seconds").toString());
                this.auditReporter.updateAuditDbSize(this.db().getDbSize());
                this.auditReporter.resetAuditMetrics();
                this.onCompleteSignaller().countDown();
            }
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    public AuditJobResult auditRetentionBasedLog(AbstractLog log, String localLogIdent) {
        TopicPartition topicPartition = log.topicPartition();
        ObjectRef previousEndOffsetOpt = ObjectRef.create((Object)None$.MODULE$);
        LongRef totalOffsetCount = LongRef.create((long)0L);
        LongRef totalGapCount = LongRef.create((long)0L);
        Iterator<TierLogSegment> tieredLogs = log.tieredLogSegments();
        if (tieredLogs.nonEmpty()) {
            AbstractLog log2;
            Option<AbstractLog> option;
            long l;
            PartialAuditJobResult tieredPartialResult = this.verifyTieredSegmentsSafely(topicPartition, tieredLogs, (Function1<TopicPartition, Object>)(Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)log.logStartOffset()), false);
            Option option2 = log.localLogSegments().headOption();
            if (option2 instanceof Some) {
                LogSegment localSegment2 = (LogSegment)((Some)option2).value();
                l = package$.MODULE$.max(0L, localSegment2.baseOffset() - tieredPartialResult.currentEndOffset() - 1L);
            } else if (None$.MODULE$.equals(option2)) {
                l = 0L;
            } else {
                throw new MatchError((Object)option2);
            }
            long offsetGap = l;
            if (offsetGap > 0L) {
                tieredPartialResult = this.catchUpOnTieredSegments(log.tierPartitionState(), (Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> ((LogSegment)log.localLogSegments().head()).baseOffset(), tieredPartialResult, (Function1<TopicPartition, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)log.logStartOffset()), false);
                offsetGap = package$.MODULE$.max(0L, ((LogSegment)log.localLogSegments().head()).baseOffset() - tieredPartialResult.currentEndOffset() - 1L);
            }
            if (offsetGap > 0L && (option = this.logManager.getLog(topicPartition, this.logManager.getLog$default$2())) instanceof Some && (log2 = (AbstractLog)((Some)option).value()).logStartOffset() >= log2.localLogStartOffset()) {
                offsetGap = 0L;
            }
            if (offsetGap > 0L) {
                String msg = new StringBuilder(130).append("durability lapse on validation of offset gap between tiered and local segments.\n").append(localLogIdent).append("\n").append("partition: ").append(topicPartition).append("\n").append("tier endOffset: ").append(tieredPartialResult.currentEndOffset()).append(", local startOffset: ").append(((LogSegment)log.localLogSegments().head()).baseOffset()).toString();
                this.publishIntermediateLapseSafely(topicPartition, ((LogSegment)log.localLogSegments().head()).baseOffset(), offsetGap, msg);
            }
            totalOffsetCount.elem += tieredPartialResult.offsetCount();
            totalGapCount.elem += tieredPartialResult.gapCount();
            totalGapCount.elem += offsetGap;
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append(localLogIdent).append(": Completed tier portion with totalOffsetCount: ").append(totalOffsetCount$1.elem).append(" ").append("and totalGapCount: ").append(totalGapCount$1.elem).toString());
        previousEndOffsetOpt.elem = None$.MODULE$;
        log.localLogSegments().foreach((Function1 & Serializable)localSegment -> {
            AuditJob.$anonfun$auditRetentionBasedLog$5(this, localLogIdent, topicPartition, previousEndOffsetOpt, log, totalOffsetCount, totalGapCount, localSegment);
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append(localLogIdent).append(": Completed entire audit with totalOffsetCount: ").append(totalOffsetCount$1.elem).append(" ").append("and totalGapCount: ").append(totalGapCount$1.elem).toString());
        return new AuditJobResult(topicPartition, totalOffsetCount.elem, totalGapCount.elem, this.jobId, (Option<Exception>)None$.MODULE$);
    }

    public AuditJobResult auditTierCompactedLog(AbstractLog log, String localLogIdent) {
        TopicPartition topicPartition = log.topicPartition();
        Iterator<TierLogSegment> tieredLogs = log.tieredLogSegments();
        PartialAuditJobResult partialTieredResult = tieredLogs.nonEmpty() ? this.verifyTieredSegmentsSafely(topicPartition, tieredLogs, (Function1<TopicPartition, Object>)(Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)log.logStartOffset()), true) : new PartialAuditJobResult(0L, 0L, 0L);
        long localOffsetCount = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)log.localLogSegments().map((Function1 & Serializable)seg -> BoxesRunTime.boxToLong((long)AuditJob.$anonfun$auditTierCompactedLog$2(seg)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long totalOffsetCount = partialTieredResult.offsetCount() + localOffsetCount;
        long totalGapCount = partialTieredResult.gapCount();
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(219).append(localLogIdent).append(": Completed entire audit of tier compacted partition ").append(topicPartition).append(" with totalOffsetCount: ").append(totalOffsetCount).append(" ").append("and totalGapCount: ").append(totalGapCount).append(". Note that for tier compacted partitions the offset count only counts segment ranges and may not match available offsets.").toString());
        return new AuditJobResult(topicPartition, totalOffsetCount, totalGapCount, this.jobId, (Option<Exception>)None$.MODULE$);
    }

    private void auditFtpsChecksums(AbstractLog log, String localLogIdent) {
        if (!this.auditsAllowed().contains((Object)DurabilityAuditCheck$.MODULE$.ChecksumAudit())) {
            return;
        }
        TopicPartition topicPartition = log.topicPartition();
        if (log.tierPartitionState().mayContainTieredData()) {
            boolean isValidChecksum = log.tierPartitionState().validateChecksum();
            if (!isValidChecksum) {
                String msg = new StringBuilder(71).append("durability lapse on checksum validation of tier state file.\n").append("partition: ").append(topicPartition).toString();
                this.auditReporter.reportDurabilityLapse(topicPartition, 0L, 1L, DurabilityLapseType$.MODULE$.ChecksumValidation(), msg, false);
            }
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append(localLogIdent).append(": ").append("Checksum validation of tier state file: ").append(isValidChecksum).toString());
            return;
        }
    }

    private boolean onceCompacted(AbstractLog log, long topicDbConfig) {
        return log.config().compact() || (topicDbConfig & (long)ConfigFlag$.MODULE$.OnceCompacted().id()) != 0L;
    }

    public AuditJobResult doAuditSafely(AbstractLog log, long topicDbConfig) {
        Object object = new Object();
        try {
            AuditJobResult auditJobResult;
            String localLogIdent = new StringBuilder(2).append("[").append(log.topicIdPartition().getOrElse((Function0 & Serializable)() -> log.topicPartition())).append("]").toString();
            try {
                try {
                    AuditJob$.MODULE$.shouldAuditLog(log).foreach((Function1 & Serializable)nonAuditableCause -> {
                        UnsupportedOperationException err = new UnsupportedOperationException(new StringBuilder(25).append(log).append(" is not audited as it is ").append((String)nonAuditableCause).toString());
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append(localLogIdent).append(": Avoiding audit for log: ").append(log).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> err);
                        throw new NonLocalReturnControl(object, (Object)new AuditJobResult(log.topicPartition(), 0L, 0L, $this.jobId, (Option<Exception>)new Some((Object)err)));
                    });
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append(localLogIdent).append(": Going to start durability audit").toString());
                    this.auditFtpsChecksums(log, localLogIdent);
                    auditJobResult = log.isTierCompactable() || this.onceCompacted(log, topicDbConfig) ? this.auditTierCompactedLog(log, localLogIdent) : this.auditRetentionBasedLog(log, localLogIdent);
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                catch (Exception e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append(localLogIdent).append(": Received exception, will continue with other partition").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    auditJobResult = new AuditJobResult(log.topicPartition(), 0L, 0L, this.jobId, (Option<Exception>)new Some((Object)e));
                }
            }
            finally {
                this.remainingPartitionCount_$eq(this.remainingPartitionCount() - 1);
            }
            return auditJobResult;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (AuditJobResult)ex.value();
            }
            throw ex;
        }
    }

    public PartialAuditJobResult verifyLocalLogSegment(TopicPartition topicPartition, LogSegment segment, Option<Object> previousEndOffsetOpt, AbstractLog log) {
        long l;
        long currentEndOffset = segment.readNextOffset() - 1L;
        long totalNumMsgs = currentEndOffset - segment.baseOffset() + 1L;
        if (previousEndOffsetOpt instanceof Some) {
            long prev = BoxesRunTime.unboxToLong((Object)((Some)previousEndOffsetOpt).value());
            l = package$.MODULE$.max(0L, segment.baseOffset() - package$.MODULE$.max(log.tierPartitionState().endOffset(), prev) - 1L);
        } else if (None$.MODULE$.equals(previousEndOffsetOpt)) {
            l = 0L;
        } else {
            throw new MatchError(previousEndOffsetOpt);
        }
        long totalGapMsgs = l;
        if (totalGapMsgs > 0L) {
            String msg = new StringBuilder(82).append("durability lapse on validation of offset gap in local.\n").append("partition: ").append(topicPartition).append("\n").append("segment: ").append(segment).append("\n").append("gap: ").append(totalGapMsgs).toString();
            this.publishIntermediateLapseSafely(topicPartition, segment.baseOffset(), totalGapMsgs, msg);
        }
        return new PartialAuditJobResult(totalNumMsgs, totalGapMsgs, currentEndOffset);
    }

    private scala.collection.immutable.Set<String> s3ErrorCodes() {
        return this.s3ErrorCodes;
    }

    public boolean shouldCountLapse(TierMetadataValidator.OffsetValidationResult tierValidationResult) {
        return BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)tierValidationResult.exception).map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AuditJob.$anonfun$shouldCountLapse$1(this, x0$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> !tierValidationResult$1.result));
    }

    public void verifyTieredLogSegmentSize(TopicPartition topicPartition, TierLogSegment segment, long size) {
        if (size != (long)segment.size()) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("durability lapse on validation of size [").append(size).append(", ").append(segment.size()).append("], ").append(segment).toString());
            String msg = new StringBuilder(125).append("durability lapse on validation of size of segment in tiered part.\n").append("partition: ").append(topicPartition).append("\n").append("segment: ").append(segment).append("\n").append("segment size: ").append(segment.size()).append(", tiered segment size: ").append(size).toString();
            if (this.auditsAllowed().contains((Object)DurabilityAuditCheck$.MODULE$.CompactTopicAudit())) {
                this.publishIntermediateLapseSafely(topicPartition, segment.baseOffset(), RichLong$.MODULE$.abs$extension(Predef$.MODULE$.longWrapper(size - (long)segment.size())), msg);
                return;
            }
            return;
        }
    }

    public PartialAuditJobResult verifyTieredLogSegment(TopicPartition topicPartition, TierLogSegment segment, Option<Object> previousEndOffsetOpt, Option<TierObjectStore> objStoreOpt, Function1<TopicPartition, Object> firstValidOffsetGen, boolean onceCompacted) {
        return (PartialAuditJobResult)this.logManager.getLog(topicPartition, this.logManager.getLog$default$2()).map(arg_0 -> AuditJob.$anonfun$verifyTieredLogSegment$1(this, segment, onceCompacted, previousEndOffsetOpt, objStoreOpt, firstValidOffsetGen, topicPartition, arg_0)).getOrElse((Function0 & Serializable)() -> new PartialAuditJobResult(0L, 0L, segment.endOffset()));
    }

    public boolean isComplete() {
        return this.remainingPartitionCount() == 0;
    }

    public void publishIntermediateLapseSafely(TopicPartition topicPartition, long startOffset, long gapCount, String msg) {
        try {
            HostedPartition hostedPartition;
            Option<ReplicaManager> option = this.replicaMgrOpt();
            if (!(option instanceof Some ? ((hostedPartition = ((ReplicaManager)((Some)option).value()).getPartition(topicPartition)) instanceof HostedPartition.Online ? ((HostedPartition.Online)hostedPartition).partition().leaderLogIfLocal() instanceof Some : false) : true)) {
                this.auditReporter.reportDurabilityLapse(topicPartition, startOffset, gapCount, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false);
                return;
            }
            this.auditReporter.reportDurabilityLapse(topicPartition, startOffset, gapCount, DurabilityLapseType$.MODULE$.PeriodicalAudit(), msg, true);
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("publishIntermediateLapseSafely received error for: ").append(topicPartition).append(", at ").append(startOffset).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
        }
    }

    public void publishResultSafely(AuditJobResult auditJobResult) {
        try {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Going to publish results: ").append(auditJobResult).toString());
            this.auditReporter.reportDurabilityAudit(this.jobId, auditJobResult.topicPartition(), auditJobResult.totalOffsetCount(), this.auditReporter.reportDurabilityAudit$default$4());
            return;
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Received error while publishing result: ").append(auditJobResult).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public PartialAuditJobResult verifyTieredSegmentsSafely(TopicPartition topicPartition, Iterator<TierLogSegment> tieredLogSegments, Function1<TopicPartition, Object> firstValidOffsetGen, boolean onceCompacted) {
        ObjectRef previousEndOffsetOpt = ObjectRef.create((Object)None$.MODULE$);
        LongRef totalOffsetCount = LongRef.create((long)0L);
        LongRef totalGapCount = LongRef.create((long)0L);
        tieredLogSegments.grouped(AuditJob$.MODULE$.TIER_SEGMENT_BATCH_SIZE()).foreach((Function1 & Serializable)tieredLogBatch -> {
            AuditJob.$anonfun$verifyTieredSegmentsSafely$1(this, topicPartition, previousEndOffsetOpt, firstValidOffsetGen, onceCompacted, totalOffsetCount, totalGapCount, tieredLogBatch);
            return BoxedUnit.UNIT;
        });
        return new PartialAuditJobResult(totalOffsetCount.elem, totalGapCount.elem, BoxesRunTime.unboxToLong((Object)((Option)previousEndOffsetOpt.elem).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
    }

    /*
     * WARNING - void declaration
     */
    public void updateVerifiedSegmentsInDB(TopicIdPartition topicIdPartition, scala.collection.immutable.Set<UUID> destinationSegments, long lastCompactedOffset) {
        void apply_validatedObjectIds;
        void apply_failedAttempts;
        String auditId = new SimpleDateFormat("d-M-y").format(Calendar.getInstance().getTime());
        PartitionState state = (PartitionState)this.db().fetchPartitionState(topicIdPartition.topicPartition()).getOrElse((Function0 & Serializable)() -> PartitionState$.MODULE$.apply(topicIdPartition.topicPartition().partition(), ConfigFlag$.MODULE$.OnceCompacted().id()));
        scala.collection.immutable.Set set = Predef$.MODULE$.Set().empty();
        boolean bl = false;
        int apply_auditTimeNsPerRecord = 0;
        set = null;
        state.auditInfo_$eq(new AuditRunState(lastCompactedOffset, apply_auditTimeNsPerRecord, auditId, (int)apply_failedAttempts, (scala.collection.immutable.Set<UUID>)apply_validatedObjectIds));
        this.db().addAuditInfo(topicIdPartition.topicPartition(), state);
    }

    public void validatesSourceForMissingSegments(scala.collection.immutable.Set<UUID> uploadSegments, scala.collection.immutable.Set<UUID> sourceSegments, scala.collection.immutable.Map<UUID, TierSegmentUploadInitiate> segmentMap, long lastCompactedOffset) {
        Object object = new Object();
        try {
            uploadSegments.foreach((Function1 & Serializable)regularSegment -> {
                AuditJob.$anonfun$validatesSourceForMissingSegments$1(this, sourceSegments, segmentMap, lastCompactedOffset, object, regularSegment);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    public void verifyCompactedPartition(TopicIdPartition topicIdPartition, TierTopicEvents tierTopicEvents) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(99).append("Verifying tier compacted Partition ").append(topicIdPartition).append(", commitSwapMessage: ").append(tierTopicEvents.commitAndSwapMessages().size()).append(",").append("uploadInitMessages: ").append(tierTopicEvents.uploadInitMessages()).append(" uploadInitMessages: ").append(tierTopicEvents.uploadInitMessages()).append(" ").toString());
        try {
            if (tierTopicEvents.commitAndSwapMessages().isEmpty()) {
                this.auditReporter.addCompactedPartitionIdle(1L);
                return;
            }
            HashMap dependencyMatrix = new HashMap();
            HashMap segmentMap = new HashMap();
            Set sourceSegments = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            Set destinationSegments = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            Set uploadSegments = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            LongRef lastCompactedOffset = LongRef.create((long)-1L);
            LongRef lastTierReadOffset = LongRef.create((long)-1L);
            tierTopicEvents.uploadInitMessages().foreach((Function1 & Serializable)event -> segmentMap.put((Object)event.objectId(), (Object)event.message()));
            tierTopicEvents.uploadMessages().foreach((Function1 & Serializable)event -> (Set)uploadSegments.$plus$eq((Object)event.objectId()));
            tierTopicEvents.commitAndSwapMessages().foreach((Function1 & Serializable)event -> {
                AuditJob.$anonfun$verifyCompactedPartition$4(this, dependencyMatrix, destinationSegments, sourceSegments, segmentMap, lastCompactedOffset, lastTierReadOffset, event);
                return BoxedUnit.UNIT;
            });
            this.validatesSourceForMissingSegments((scala.collection.immutable.Set<UUID>)uploadSegments.toSet(), (scala.collection.immutable.Set<UUID>)sourceSegments.toSet(), (scala.collection.immutable.Map<UUID, TierSegmentUploadInitiate>)segmentMap.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), lastCompactedOffset.elem);
            this.updateVerifiedSegmentsInDB(topicIdPartition, (scala.collection.immutable.Set<UUID>)destinationSegments.toSet(), lastTierReadOffset.elem);
            this.auditReporter.addCompactedPartitionAudited(1L);
            return;
        }
        catch (InterruptedException e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("Thread Interrupted ").append(e).toString());
            throw e;
        }
        catch (Exception e) {
            this.auditReporter.addTierAuditUnknownExceptions(1L);
            this.auditReporter.addCompactedPartitionSkipped(1L);
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("Running into an unhandled exception ").append(e).append(", skipping the partition").toString());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<TopicIdPartition, TierTopicEvents> getTierTopicEvents(scala.collection.immutable.Map<TopicIdPartition, Object> topicIdPartitionMap, int retryCount) {
        while (true) {
            try {
                void apply_onCompleteSignaller;
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("Reading tier topic events for topicPartition group of size ").append(topicIdPartitionMap.size()).toString());
                CountDownLatch countDownLatch = this.onCompleteSignaller();
                DurabilityAuditConfig apply_config = this.config();
                Object var5_4 = null;
                countDownLatch = null;
                return new DurabilityTierTopicReader(apply_config, (CountDownLatch)apply_onCompleteSignaller, topicIdPartitionMap).retrieveTierRecords();
            }
            catch (TimeoutException e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Running into ").append((Object)e).append(" while reading the tier topic events ").append(retryCount).toString());
                this.auditReporter.addTierAuditRetryExceptions(1L);
                if (retryCount < 3) {
                    ++retryCount;
                    continue;
                }
                this.auditReporter.addCompactedPartitionSkipped(topicIdPartitionMap.size());
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("Repeated timeouts, skipping the topicPartitions count ").append(topicIdPartitionMap.size()).toString());
                throw e;
            }
            catch (Exception e) {
                this.auditReporter.addTierAuditUnknownExceptions(1L);
                this.auditReporter.addCompactedPartitionSkipped(topicIdPartitionMap.size());
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Running into an unhandled exception ").append(e).append(", skipping some topic partitions").toString());
                throw e;
            }
            break;
        }
    }

    private void verifyCompactedPartitions(scala.collection.immutable.Map<TopicIdPartition, Object> topicIdPartitionMap) {
        try {
            this.getTierTopicEvents(topicIdPartitionMap, 0).foreach((Function1 & Serializable)x0$1 -> {
                AuditJob.$anonfun$verifyCompactedPartitions$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (InterruptedException e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("Thread Interrupted ").append(e).toString());
            throw e;
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Running into an unhandled exception ").append(e).append(", skipping some topic partitions").toString());
            return;
        }
    }

    public void auditTierCompactedPartitions(ListBuffer<TopicIdPartition> tierCompactedPartitionsList) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Starting audit for tier compacted topicPartition count: ").append(tierCompactedPartitionsList.size()).toString());
        Instant startTime = this.auditReporter.startAuditCompactionJob();
        TierTopicPartitioner tierTopicPartitioner = new TierTopicPartitioner(this.config().tierTopicPartitionNum());
        tierCompactedPartitionsList.groupBy((Function1 & Serializable)topicIdPartition -> BoxesRunTime.boxToInteger((int)tierTopicPartitioner.partitionId(topicIdPartition))).foreach((Function1 & Serializable)x0$1 -> {
            AuditJob.$anonfun$auditTierCompactedPartitions$3(this, x0$1);
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Completed audit for tier compacted topicPartition count: ").append(tierCompactedPartitionsList.size()).append(" in ").append(Duration.between(startTime, Instant.ofEpochMilli($this.time.milliseconds()))).append(" seconds").toString());
    }

    private PartialAuditJobResult catchUpOnTieredSegments(TierPartitionState tierPartitionState, Function0<Object> localStartOffsetGen, PartialAuditJobResult previousResult, Function1<TopicPartition, Object> firstValidOffsetGen, boolean onceCompacted) {
        Option option;
        while (true) {
            long prevEndOffset;
            if (None$.MODULE$.equals(option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TierUtils.tierLogSegmentForOffset(tierPartitionState, (prevEndOffset = previousResult.currentEndOffset()) + 1L))))) {
                return previousResult;
            }
            if (!(option instanceof Some)) break;
            TierLogSegment tierLogSegment = (TierLogSegment)((Some)option).value();
            PartialAuditJobResult partialResult = this.verifyTieredLogSegment(tierPartitionState.topicPartition(), tierLogSegment, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)prevEndOffset)), this.tierObjStoreOpt, firstValidOffsetGen, onceCompacted);
            PartialAuditJobResult cumulativePartialResult = previousResult.add(partialResult);
            if (cumulativePartialResult.currentEndOffset() >= localStartOffsetGen.apply$mcJ$sp() - 1L) {
                return cumulativePartialResult;
            }
            previousResult = cumulativePartialResult;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$auditRetentionBasedLog$5(AuditJob $this, String localLogIdent$1, TopicPartition topicPartition$2, ObjectRef previousEndOffsetOpt$1, AbstractLog log$1, LongRef totalOffsetCount$1, LongRef totalGapCount$1, LogSegment localSegment) {
        if ($this.onCompleteSignaller().getCount() == 0L) {
            throw new InterruptedException(new StringBuilder(42).append(localLogIdent$1).append(": onCompleteSignaller signalled, will quit").toString());
        }
        PartialAuditJobResult partialResult = $this.verifyLocalLogSegment(topicPartition$2, localSegment, (Option<Object>)((Option)previousEndOffsetOpt$1.elem), log$1);
        previousEndOffsetOpt$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)partialResult.currentEndOffset()));
        totalOffsetCount$1.elem += partialResult.offsetCount();
        totalGapCount$1.elem += partialResult.gapCount();
    }

    public static final /* synthetic */ long $anonfun$auditTierCompactedLog$2(LogSegment seg) {
        return seg.readNextOffset() - seg.baseOffset();
    }

    public static final /* synthetic */ boolean $anonfun$shouldCountLapse$1(AuditJob $this, Exception x0$1) {
        if (x0$1 instanceof TierObjectStoreRetriableException) {
            Throwable throwable = ((TierObjectStoreRetriableException)((Object)x0$1)).getCause();
            if (throwable instanceof AmazonServiceException) {
                AmazonServiceException amazonServiceException = (AmazonServiceException)throwable;
                if ($this.s3ErrorCodes().contains((Object)amazonServiceException.getErrorCode())) {
                    return true;
                }
            }
            return false;
        }
        if (x0$1 instanceof InterruptedException) {
            throw (InterruptedException)x0$1;
        }
        return false;
    }

    public static final /* synthetic */ Long $anonfun$verifyTieredLogSegment$2(Function1 firstValidOffsetGen$1, TopicPartition topicPartition) {
        return Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)firstValidOffsetGen$1.apply((Object)topicPartition)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyTieredLogSegment$3(TierLogSegment segment$2, TierLogSegment x$4) {
        UUID uUID = x$4.objectId();
        UUID uUID2 = segment$2.objectId();
        return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
    }

    public static final /* synthetic */ String $anonfun$verifyTieredLogSegment$4() {
        return "Going to ignore false result with underlying cause";
    }

    public static final /* synthetic */ Exception $anonfun$verifyTieredLogSegment$5(TierMetadataValidator.OffsetValidationResult tierValidationResult$2) {
        return tierValidationResult$2.exception;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ PartialAuditJobResult $anonfun$verifyTieredLogSegment$1(AuditJob $this, TierLogSegment segment$2, boolean onceCompacted$1, Option previousEndOffsetOpt$2, Option objStoreOpt$1, Function1 firstValidOffsetGen$1, TopicPartition topicPartition$4, AbstractLog log) {
        block15: {
            block14: {
                segmentOffsetRange = segment$2.endOffset() - segment$2.baseOffset() + 1L;
                if (onceCompacted$1) {
                    v0 = 0L;
                } else if (previousEndOffsetOpt$2 instanceof Some) {
                    prev = BoxesRunTime.unboxToLong((Object)((Some)previousEndOffsetOpt$2).value());
                    v0 = log.logStartOffset() >= segment$2.baseOffset() ? 0L : package$.MODULE$.max(0L, segment$2.baseOffset() - prev - 1L);
                } else if (None$.MODULE$.equals(previousEndOffsetOpt$2)) {
                    v0 = 0L;
                } else {
                    throw new MatchError((Object)previousEndOffsetOpt$2);
                }
                segmentLoss = v0;
                if (!(objStoreOpt$1 instanceof Some)) ** GOTO lbl36
                objStore = (TierObjectStore)((Some)objStoreOpt$1).value();
                tierValidationResult = TierMetadataValidator.verifyObjectInBackend(AuditJob$.MODULE$.getTierObjectMetadata(segment$2), BoxesRunTime.unboxToLong((Object)firstValidOffsetGen$1.apply((Object)topicPartition$4)), objStore, $this.auditsAllowed().contains((Object)DurabilityAuditCheck$.MODULE$.DeepOffsetScan()), CancellationContext.newContext(), (Function<TopicPartition, Long>)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$verifyTieredLogSegment$2(scala.Function1 org.apache.kafka.common.TopicPartition ), (Lorg/apache/kafka/common/TopicPartition;)Ljava/lang/Long;)((Function1)firstValidOffsetGen$1));
                var18_13 = false;
                var19_14 = tierValidationResult.result;
                if (!var19_14) break block14;
                $this.verifyTieredLogSegmentSize(topicPartition$4, segment$2, tierValidationResult.size);
                v1 = 0L;
                break block15;
            }
            if (var19_14) ** GOTO lbl-1000
            var18_13 = true;
            if ($this.onCompleteSignaller().getCount() > 0L && $this.shouldCountLapse(tierValidationResult)) {
                v1 = log.isTierCompactable() && OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(log.tierPartitionState().metadata(segment$2.baseOffset()))).exists((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$verifyTieredLogSegment$3$adapted(kafka.log.TierLogSegment kafka.log.TierLogSegment ), (Lkafka/log/TierLogSegment;)Ljava/lang/Object;)((TierLogSegment)segment$2)) ? 0L : segmentOffsetRange;
            } else if (var18_13 && $this.onCompleteSignaller().getCount() > 0L) {
                $this.debug((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$verifyTieredLogSegment$4(), ()Ljava/lang/String;)(), (Function0<Throwable>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$verifyTieredLogSegment$5(kafka.tier.tools.TierMetadataValidator$OffsetValidationResult ), ()Ljava/lang/Exception;)((TierMetadataValidator.OffsetValidationResult)tierValidationResult));
                v1 = 0L;
            } else {
                if (var18_13) {
                    throw new InterruptedException("AuditJob has received onCompleteSignaller signal, will shutdown!");
                }
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)var19_14));
lbl36:
                // 1 sources

                if (None$.MODULE$.equals(objStoreOpt$1)) {
                    v1 = 0L;
                } else {
                    throw new MatchError((Object)objStoreOpt$1);
                }
            }
        }
        tierSegmentLoss = v1;
        gapCount = segmentLoss + tierSegmentLoss;
        if (gapCount > 0L) {
            msg = new StringBuilder(115).append("durability lapse on validation of offset gap in tiered part.\n").append("partition: ").append(topicPartition$4).append("\n").append("segment: ").append(segment$2).append("\n").append("gapMsgs: ").append(segmentLoss).append(", tiered segment loss: ").append(tierSegmentLoss).toString();
            $this.publishIntermediateLapseSafely(topicPartition$4, segment$2.baseOffset(), gapCount, msg);
        }
        return new PartialAuditJobResult(segmentOffsetRange, gapCount, segment$2.endOffset());
    }

    public static final /* synthetic */ void $anonfun$verifyTieredSegmentsSafely$2(AuditJob $this, TopicPartition topicPartition$6, ObjectRef previousEndOffsetOpt$3, Function1 firstValidOffsetGen$2, boolean onceCompacted$2, LongRef totalOffsetCount$3, LongRef totalGapCount$3, TierLogSegment tieredSegment) {
        PartialAuditJobResult partialResult = $this.verifyTieredLogSegment(topicPartition$6, tieredSegment, (Option<Object>)((Option)previousEndOffsetOpt$3.elem), $this.tierObjStoreOpt, (Function1<TopicPartition, Object>)firstValidOffsetGen$2, onceCompacted$2);
        previousEndOffsetOpt$3.elem = new Some((Object)BoxesRunTime.boxToLong((long)partialResult.currentEndOffset()));
        totalOffsetCount$3.elem += partialResult.offsetCount();
        totalGapCount$3.elem += partialResult.gapCount();
    }

    public static final /* synthetic */ void $anonfun$verifyTieredSegmentsSafely$1(AuditJob $this, TopicPartition topicPartition$6, ObjectRef previousEndOffsetOpt$3, Function1 firstValidOffsetGen$2, boolean onceCompacted$2, LongRef totalOffsetCount$3, LongRef totalGapCount$3, Seq tieredLogBatch) {
        tieredLogBatch.foreach((Function1 & Serializable)tieredSegment -> {
            AuditJob.$anonfun$verifyTieredSegmentsSafely$2($this, topicPartition$6, previousEndOffsetOpt$3, firstValidOffsetGen$2, onceCompacted$2, totalOffsetCount$3, totalGapCount$3, tieredSegment);
            return BoxedUnit.UNIT;
        });
        $this.time.sleep(AuditJob$.MODULE$.SLEEP_TIME_MS());
        if ($this.onCompleteSignaller().getCount() == 0L) {
            throw new InterruptedException(new StringBuilder(60).append($this.logIdent()).append(" onCompleteSignaller has been signalled, will stop verifying").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$validatesSourceForMissingSegments$1(AuditJob $this, scala.collection.immutable.Set sourceSegments$1, scala.collection.immutable.Map segmentMap$1, long lastCompactedOffset$1, Object nonLocalReturnKey3$1, UUID regularSegment) {
        if (!sourceSegments$1.apply((Object)regularSegment)) {
            TierSegmentUploadInitiate v;
            Option option = segmentMap$1.get((Object)regularSegment);
            if (option instanceof Some && (v = (TierSegmentUploadInitiate)((Some)option).value()) != null) {
                if (v.endOffset() > lastCompactedOffset$1) {
                    $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Skipped a newer segment, it not a part of compaction iteration ").append(regularSegment).toString());
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey3$1, BoxedUnit.UNIT);
                }
                boolean bl = false;
                Some some = null;
                Option<AbstractLog> option2 = $this.logManager.getLog(v.topicIdPartition().topicPartition(), $this.logManager.getLog$default$2());
                if (option2 instanceof Some) {
                    bl = true;
                    some = (Some)option2;
                    AbstractLog log = (AbstractLog)some.value();
                    if (log.logStartOffset() > v.endOffset()) {
                        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("Skipped older segment: ").append(regularSegment).append(" with endOffset: ").append(v.endOffset()).append(" smaller than logStartOffset: ").append(log.logStartOffset()).toString());
                        return;
                    }
                }
                if (bl) {
                    AbstractLog value = (AbstractLog)some.value();
                    String msg = new StringBuilder(80).append("topicIdPartition: ").append(v.topicIdPartition()).append(", skipped a valid segment ").append(regularSegment).append(", logStartOffset ").append(value.logStartOffset()).append(" in tier compaction").toString();
                    $this.auditReporter.reportDurabilityLapse(v.topicIdPartition().topicPartition(), v.baseOffset(), v.endOffset() - v.baseOffset() + 1L, DurabilityLapseType$.MODULE$.PeriodicalAudit(), msg, true);
                    return;
                }
                $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Failed to get log for topicIdPartition: ").append(v.topicIdPartition()).toString());
                $this.auditReporter.addTierAuditErrors(1L);
                return;
            }
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Failed to find segment ").append(regularSegment).append(" in segmentMap").toString());
            $this.auditReporter.addTierAuditErrors(1L);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$verifyCompactedPartition$6(AuditJob $this, Set destinationSegments$1, Set sourceSegments$2, HashMap segmentMap$2, LongRef lastCompactedOffset$2, UUID sourceUUID) {
        TierSegmentUploadInitiate segment;
        if (destinationSegments$1.apply((Object)sourceUUID)) {
            destinationSegments$1.$minus$eq((Object)sourceUUID);
        } else {
            sourceSegments$2.$plus$eq((Object)sourceUUID);
        }
        Option option = segmentMap$2.get((Object)sourceUUID);
        if (option instanceof Some && (segment = (TierSegmentUploadInitiate)((Some)option).value()) != null) {
            lastCompactedOffset$2.elem = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(lastCompactedOffset$2.elem), segment.endOffset());
            return;
        }
        $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Failed to get InitiateEvent for source segment ").append(sourceUUID).toString());
        $this.auditReporter.addTierAuditErrors(1L);
    }

    public static final /* synthetic */ void $anonfun$verifyCompactedPartition$5(AuditJob $this, HashMap dependencyMatrix$1, CommitAndSwapEvent event$1, Set destinationSegments$1, Set sourceSegments$2, HashMap segmentMap$2, LongRef lastCompactedOffset$2, UUID destUUID) {
        TierSegmentUploadInitiate segment;
        dependencyMatrix$1.put((Object)destUUID, event$1.sourceObjectIds());
        event$1.sourceObjectIds().foreach((Function1 & Serializable)sourceUUID -> {
            AuditJob.$anonfun$verifyCompactedPartition$6($this, destinationSegments$1, sourceSegments$2, segmentMap$2, lastCompactedOffset$2, sourceUUID);
            return BoxedUnit.UNIT;
        });
        destinationSegments$1.$plus$eq((Object)destUUID);
        Option option = segmentMap$2.get((Object)destUUID);
        if (option instanceof Some && (segment = (TierSegmentUploadInitiate)((Some)option).value()) != null) {
            lastCompactedOffset$2.elem = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(lastCompactedOffset$2.elem), segment.endOffset());
            return;
        }
        $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Failed to get InitiateEvent for destination segment ").append(destUUID).toString());
        $this.auditReporter.addTierAuditErrors(1L);
    }

    public static final /* synthetic */ void $anonfun$verifyCompactedPartition$4(AuditJob $this, HashMap dependencyMatrix$1, Set destinationSegments$1, Set sourceSegments$2, HashMap segmentMap$2, LongRef lastCompactedOffset$2, LongRef lastTierReadOffset$1, CommitAndSwapEvent event) {
        event.destinationObjectIds().foreach((Function1 & Serializable)destUUID -> {
            AuditJob.$anonfun$verifyCompactedPartition$5($this, dependencyMatrix$1, event, destinationSegments$1, sourceSegments$2, segmentMap$2, lastCompactedOffset$2, destUUID);
            return BoxedUnit.UNIT;
        });
        lastTierReadOffset$1.elem = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(lastTierReadOffset$1.elem), event.offset());
    }

    public static final /* synthetic */ void $anonfun$verifyCompactedPartitions$1(AuditJob $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicIdPartition partition = (TopicIdPartition)x0$1._1();
            TierTopicEvents events = (TierTopicEvents)x0$1._2();
            $this.verifyCompactedPartition(partition, events);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$auditTierCompactedPartitions$3(AuditJob $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            ListBuffer v = (ListBuffer)x0$1._2();
            $this.verifyCompactedPartitions((scala.collection.immutable.Map<TopicIdPartition, Object>)((IterableOnceOps)v.map((Function1 & Serializable)a -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(a), $this.db().fetchNextAuditOffset(a.topicPartition()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> DurabilityAuditConstants$.MODULE$.TIER_TOPIC_INITIAL_SEEK())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return;
        }
        throw new MatchError(null);
    }

    public AuditJob(Seq<Tuple2<TopicPartition, Object>> topicPartitionsInfo, LogManager logManager, CountDownLatch onCompleteSignaller, AuditReporter auditReporter, int jobId, Option<TierObjectStore> tierObjStoreOpt, Time time, scala.collection.immutable.Set<Enumeration.Value> auditsAllowed, DurabilityAuditConfig config, DurabilityDB db, Option<ReplicaManager> replicaMgrOpt) {
        this.topicPartitionsInfo = topicPartitionsInfo;
        this.logManager = logManager;
        this.onCompleteSignaller = onCompleteSignaller;
        this.auditReporter = auditReporter;
        this.jobId = jobId;
        this.tierObjStoreOpt = tierObjStoreOpt;
        this.time = time;
        this.auditsAllowed = auditsAllowed;
        this.config = config;
        this.db = db;
        this.replicaMgrOpt = replicaMgrOpt;
        this.remainingPartitionCount = topicPartitionsInfo.size();
        this.totalOffsetCountAcrossPartitions = 0L;
        this.totalGapCountAcrossPartitions = 0L;
        this.logIdent_$eq(new StringBuilder(14).append("[AuditJob:(").append(jobId).append(")] ").toString());
        this.s3ErrorCodes = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"AccessDenied", "AccountProblem", "AllAccessDisabled", "InvalidAccessKeyId", "MethodNotAllowed", "NoSuchBucket", "NoSuchKey", "NoSuchUpload", "NoSuchVersion"}));
    }

    public static final /* synthetic */ Object $anonfun$verifyTieredLogSegment$3$adapted(TierLogSegment segment$2, TierLogSegment x$4) {
        return BoxesRunTime.boxToBoolean((boolean)AuditJob.$anonfun$verifyTieredLogSegment$3(segment$2, x$4));
    }
}

