/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditJob;
import kafka.durability.audit.AuditManager$;
import kafka.durability.audit.AuditManagerRequest;
import kafka.durability.audit.AuditManagerTrait;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.DeleteMessagesRequest;
import kafka.durability.audit.DeletePartitionRequest;
import kafka.durability.audit.DurabilityAuditCheck$;
import kafka.durability.audit.DurabilityAuditConfig;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.EpochChangeRequest;
import kafka.durability.audit.HealthCheckRequest;
import kafka.durability.audit.HighWatermarkUpdateRequest;
import kafka.durability.audit.ISRExpandRequest;
import kafka.durability.audit.RegisterPartitionRequest;
import kafka.durability.audit.RetentionConfigChangeRequest;
import kafka.durability.audit.StartOffsetChangeRequest;
import kafka.durability.db.ConfigFlag$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.DurabilityDB$;
import kafka.durability.db.PartitionState;
import kafka.durability.db.PartitionState$;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.DeletePartitionEvent$;
import kafka.durability.events.DeleteRecordsEvent$;
import kafka.durability.events.EpochChangeEvent$;
import kafka.durability.events.HealthCheckEvent;
import kafka.durability.events.IsrExpandEvent$;
import kafka.durability.events.OffsetChangeEvent$;
import kafka.durability.events.RetentionChangeEvent$;
import kafka.durability.events.StartOffsetChangeEvent$;
import kafka.durability.materialization.DurabilityEventsMaterialize;
import kafka.durability.topic.DurabilityTopicConfig;
import kafka.durability.topic.DurabilityTopicManager;
import kafka.server.ReplicaManager;
import kafka.tier.store.TierObjectStore;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r\re\u0001B*U\u0001mC\u0001B\u0019\u0001\u0003\u0006\u0004%\ta\u0019\u0005\tQ\u0002\u0011\t\u0011)A\u0005I\"A\u0011\u000e\u0001BC\u0002\u0013\u0005!\u000e\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003l\u0011!\u0011\bA!A!\u0002\u0013\u0019\bBCA\u0002\u0001\t\u0015\r\u0011\"\u0001\u0002\u0006!Q\u0011q\u0004\u0001\u0003\u0002\u0003\u0006I!a\u0002\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!I\u0011q\u0006\u0001C\u0002\u0013%\u0011\u0011\u0007\u0005\t\u0003\u0003\u0002\u0001\u0015!\u0003\u00024!Y\u00111\t\u0001A\u0002\u0003\u0007I\u0011BA#\u0011-\ti\u0005\u0001a\u0001\u0002\u0004%I!a\u0014\t\u0017\u0005m\u0003\u00011A\u0001B\u0003&\u0011q\t\u0005\u000b\u0003;\u0002\u0001\u0019!C\u0001)\u0006}\u0003BCA4\u0001\u0001\u0007I\u0011\u0001+\u0002j!A\u0011Q\u000e\u0001!B\u0013\t\t\u0007\u0003\u0006\u0002p\u0001\u0001\r\u0011\"\u0001U\u0003cB!\"a!\u0001\u0001\u0004%\t\u0001VAC\u0011!\tI\t\u0001Q!\n\u0005M\u0004BCAF\u0001\t\u0007I\u0011\u0001+\u0002\u000e\"A\u00111\u0015\u0001!\u0002\u0013\ty\tC\u0005\u0002&\u0002\u0011\r\u0011\"\u0001\u0002(\"A\u0011Q\u0017\u0001!\u0002\u0013\tI\u000b\u0003\u0006\u00028\u0002\u0001\r\u0011\"\u0001U\u0003sC!\"!1\u0001\u0001\u0004%\t\u0001VAb\u0011!\t9\r\u0001Q!\n\u0005m\u0006BCAi\u0001\u0001\u0007I\u0011\u0001+\u0002:\"Q\u00111\u001b\u0001A\u0002\u0013\u0005A+!6\t\u0011\u0005e\u0007\u0001)Q\u0005\u0003wC!\"!8\u0001\u0005\u0004%\t\u0001VAp\u0011!\t9\u000f\u0001Q\u0001\n\u0005\u0005\bbBAu\u0001\u0011\u0005\u00111\u001e\u0005\n\u0003g\u0004!\u0019!C\u0001\u0003WD\u0001\"!?\u0001A\u0003%\u0011Q\u001e\u0005\n\u0003w\u0004!\u0019!C\u0001\u0003{D\u0001Ba\u0002\u0001A\u0003%\u0011q \u0005\n\u0005\u0013\u0001!\u0019!C\u0001\u0005\u0017A\u0001Ba\u0005\u0001A\u0003%!Q\u0002\u0005\n\u0005+\u0001!\u0019!C\u0001\u0005/A\u0001B!\n\u0001A\u0003%!\u0011\u0004\u0005\u000b\u0005O\u0001!\u0019!C\u0001)\n%\u0002\u0002\u0003B\u001c\u0001\u0001\u0006IAa\u000b\t\u0013\te\u0002A1A\u0005\u0002Q\u001b\u0007b\u0002B\u001e\u0001\u0001\u0006I\u0001\u001a\u0005\n\u0005{\u0001\u0001\u0019!C\u0001\u0005\u007fA\u0011B!\u001e\u0001\u0001\u0004%\tAa\u001e\t\u0011\tm\u0004\u0001)Q\u0005\u0005\u0003B\u0011B! \u0001\u0001\u0004%\tAa \t\u0013\tU\u0005\u00011A\u0005\u0002\t]\u0005\u0002\u0003BN\u0001\u0001\u0006KA!!\t\u000f\tu\u0005\u0001\"\u0001\u0003 \"Q!q\u0015\u0001C\u0002\u0013\u0005AKa(\t\u0011\t%\u0006\u0001)A\u0005\u0005CCqAa+\u0001\t\u0003\u0012i\u000bC\u0004\u0003>\u0002!\tA!,\t\u000f\t\u0005\u0007\u0001\"\u0003\u0003D\"9!1\u001a\u0001\u0005\n\t5\u0007\u0002\u0003Bl\u0001\u0011\u0005AK!7\t\u000f\tm\u0007\u0001\"\u0003\u0003.\"9!Q\u001c\u0001\u0005\n\t}\u0007b\u0002Bq\u0001\u0011%!\u0011\u001c\u0005\t\u0005G\u0004A\u0011\u0001+\u0003f\"Q!1\u001f\u0001\u0012\u0002\u0013\u0005AK!>\t\u0015\r-\u0001!%A\u0005\u0002Q\u0013)\u0010\u0003\u0006\u0004\u000e\u0001\t\n\u0011\"\u0001U\u0005kDqaa\u0004\u0001\t\u0013\u0011i\u000b\u0003\u0005\u0004\u0012\u0001!\t\u0001VB\n\u0011!\u0019I\u0002\u0001C\u0001)\u000em\u0001bBB\u0010\u0001\u0011%1\u0011\u0005\u0005\n\u0007_\u0001\u0011\u0013!C\u0005\u0005kDqa!\r\u0001\t\u0013\u0019\u0019\u0004\u0003\u0005\u0004@\u0001!\t\u0001VB!\u0011)\u00199\u0005AI\u0001\n\u0003!&Q\u001f\u0005\b\u0007\u0013\u0002A\u0011BB&\u0011\u001d\u0019)\u0006\u0001C\u0005\u0007/B\u0011ba\u0017\u0001#\u0003%IA!>\t\u0011\ru\u0003\u0001\"\u0001U\u0005[Cqaa\u0018\u0001\t\u0003\u0019\tgB\u0004\u0004jQC\taa\u001b\u0007\rM#\u0006\u0012AB7\u0011\u001d\t\t\u0003\u0015C\u0001\u0007wBqa! Q\t\u0013\u0019yH\u0001\u0007Bk\u0012LG/T1oC\u001e,'O\u0003\u0002V-\u0006)\u0011-\u001e3ji*\u0011q\u000bW\u0001\u000bIV\u0014\u0018MY5mSRL(\"A-\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0018\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?b\u000bQ!\u001e;jYNL!!\u00190\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\rZ\u0001\u0007G>tg-[4\u0016\u0003\u0011\u0004\"!\u001a4\u000e\u0003QK!a\u001a+\u0003+\u0011+(/\u00192jY&$\u00180Q;eSR\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0002WB\u0011An\\\u0007\u0002[*\u0011a\u000eW\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005Al'A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005\u0011B/[3s\u001f\nTWm\u0019;Ti>\u0014Xm\u00149u!\r!x/_\u0007\u0002k*\ta/A\u0003tG\u0006d\u0017-\u0003\u0002yk\n1q\n\u001d;j_:\u0004\"A_@\u000e\u0003mT!\u0001`?\u0002\u000bM$xN]3\u000b\u0005yD\u0016\u0001\u0002;jKJL1!!\u0001|\u0005=!\u0016.\u001a:PE*,7\r^*u_J,\u0017\u0001\u0002;j[\u0016,\"!a\u0002\u0011\t\u0005%\u00111D\u0007\u0003\u0003\u0017Q1aXA\u0007\u0015\u0011\ty!!\u0005\u0002\r\r|W.\\8o\u0015\rI\u00161\u0003\u0006\u0005\u0003+\t9\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u00033\t1a\u001c:h\u0013\u0011\ti\"a\u0003\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u0005\u0015\u0012qEA\u0015\u0003W\ti\u0003\u0005\u0002f\u0001!)!\r\u0003a\u0001I\")\u0011\u000e\u0003a\u0001W\")!\u000f\u0003a\u0001g\"9\u00111\u0001\u0005A\u0002\u0005\u001d\u0011\u0001D:uCJ$\u0018J\\:uC:$XCAA\u001a!\u0011\t)$!\u0010\u000e\u0005\u0005]\"\u0002BA\u0002\u0003sQ!!a\u000f\u0002\t)\fg/Y\u0005\u0005\u0003\u007f\t9DA\u0004J]N$\u0018M\u001c;\u0002\u001bM$\u0018M\u001d;J]N$\u0018M\u001c;!\u00039\tW\u000fZ5u\u0015>\u0014G\u000b\u001b:fC\u0012,\"!a\u0012\u0011\t\u0005%\u0011\u0011J\u0005\u0005\u0003\u0017\nYAA\u0006LC\u001a\\\u0017\r\u00165sK\u0006$\u0017AE1vI&$(j\u001c2UQJ,\u0017\rZ0%KF$B!!\u0015\u0002XA\u0019A/a\u0015\n\u0007\u0005USO\u0001\u0003V]&$\b\"CA-\u0019\u0005\u0005\t\u0019AA$\u0003\rAH%M\u0001\u0010CV$\u0017\u000e\u001e&pERC'/Z1eA\u0005a1-\u001e:sK:$(j\u001c2JIV\u0011\u0011\u0011\r\t\u0004i\u0006\r\u0014bAA3k\n\u0019\u0011J\u001c;\u0002!\r,(O]3oi*{'-\u00133`I\u0015\fH\u0003BA)\u0003WB\u0011\"!\u0017\u0010\u0003\u0003\u0005\r!!\u0019\u0002\u001b\r,(O]3oi*{'-\u00133!\u0003Y\tW\u000fZ5u\u0015>\u00147i\\;oi\u0012|wO\u001c'bi\u000eDWCAA:!\u0011\t)(a \u000e\u0005\u0005]$\u0002BA=\u0003w\n!bY8oGV\u0014(/\u001a8u\u0015\u0011\ti(!\u000f\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0003\u000b9H\u0001\bD_VtG\u000fR8x]2\u000bGo\u00195\u00025\u0005,H-\u001b;K_\n\u001cu.\u001e8uI><h\u000eT1uG\"|F%Z9\u0015\t\u0005E\u0013q\u0011\u0005\n\u00033\u0012\u0012\u0011!a\u0001\u0003g\nq#Y;eSRTuNY\"pk:$Hm\\<o\u0019\u0006$8\r\u001b\u0011\u00027!Lw\r[,bi\u0016\u0014X.\u0019:l+B$\u0017\r^3SKF,Xm\u001d;t+\t\ty\t\u0005\u0005\u0002v\u0005E\u0015QSAO\u0013\u0011\t\u0019*a\u001e\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0003\u0002\u0018\u0006eUBAA\u0007\u0013\u0011\tY*!\u0004\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0019Q-a(\n\u0007\u0005\u0005FK\u0001\u000eIS\u001eDw+\u0019;fe6\f'o[+qI\u0006$XMU3rk\u0016\u001cH/\u0001\u000fiS\u001eDw+\u0019;fe6\f'o[+qI\u0006$XMU3rk\u0016\u001cHo\u001d\u0011\u0002%\u0005,H-\u001b;SKF,Xm\u001d;t#V,W/Z\u000b\u0003\u0003S\u0003b!!\u001e\u0002,\u0006=\u0016\u0002BAW\u0003o\u00121\u0003T5oW\u0016$'\t\\8dW&tw-U;fk\u0016\u00042!ZAY\u0013\r\t\u0019\f\u0016\u0002\u0014\u0003V$\u0017\u000e^'b]\u0006<WM\u001d*fcV,7\u000f^\u0001\u0014CV$\u0017\u000e\u001e*fcV,7\u000f^:Rk\u0016,X\rI\u0001\u0013Y\u0006\u001cHOQ1uG\",e/\u001a8u)&lW-\u0006\u0002\u0002<B\u0019A/!0\n\u0007\u0005}VO\u0001\u0003M_:<\u0017A\u00067bgR\u0014\u0015\r^2i\u000bZ,g\u000e\u001e+j[\u0016|F%Z9\u0015\t\u0005E\u0013Q\u0019\u0005\n\u00033J\u0012\u0011!a\u0001\u0003w\u000b1\u0003\\1ti\n\u000bGo\u00195Fm\u0016tG\u000fV5nK\u0002B3AGAf!\r!\u0018QZ\u0005\u0004\u0003\u001f,(\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002'1\f7\u000f\u001e%fC2$\bn\u00115fG.$\u0016.\\3\u0002/1\f7\u000f\u001e%fC2$\bn\u00115fG.$\u0016.\\3`I\u0015\fH\u0003BA)\u0003/D\u0011\"!\u0017\u001d\u0003\u0003\u0005\r!a/\u0002)1\f7\u000f\u001e%fC2$\bn\u00115fG.$\u0016.\\3!Q\ri\u00121Z\u0001\u0015Q\u0016\fG\u000e\u001e5DQ\u0016\u001c7\u000eU1si&$\u0018n\u001c8\u0016\u0005\u0005\u0005\b\u0003BAL\u0003GLA!!:\u0002\u000e\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\\\u0001\u0016Q\u0016\fG\u000e\u001e5DQ\u0016\u001c7\u000eU1si&$\u0018n\u001c8!\u0003\u00159W\r\u001e#C+\t\ti\u000f\u0005\u0003\u0002p\u0006UXBAAy\u0015\r\t\u0019PV\u0001\u0003I\nLA!a>\u0002r\naA)\u001e:bE&d\u0017\u000e^=E\u0005\u0006\u0019AM\u0019\u0011\u0002\u001d5,GO]5dg6\u000bg.Y4feV\u0011\u0011q \t\u0005\u0005\u0003\u0011\u0019!D\u0001W\u0013\r\u0011)A\u0016\u0002\u0019\tV\u0014\u0018MY5mSRLX*\u001a;sS\u000e\u001cX*\u00198bO\u0016\u0014\u0018aD7fiJL7m]'b]\u0006<WM\u001d\u0011\u0002\u0011I,\u0007o\u001c:uKJ,\"A!\u0004\u0011\u0007\u0015\u0014y!C\u0002\u0003\u0012Q\u0013Q\"Q;eSR\u0014V\r]8si\u0016\u0014\u0018!\u0003:fa>\u0014H/\u001a:!\u0003-i\u0017\r^3sS\u0006d\u0017N_3\u0016\u0005\te\u0001\u0003\u0002B\u000e\u0005Ci!A!\b\u000b\u0007\t}a+A\bnCR,'/[1mSj\fG/[8o\u0013\u0011\u0011\u0019C!\b\u00037\u0011+(/\u00192jY&$\u00180\u0012<f]R\u001cX*\u0019;fe&\fG.\u001b>f\u00031i\u0017\r^3sS\u0006d\u0017N_3!\u0003-!x\u000e]5d\u0007>tg-[4\u0016\u0005\t-\u0002\u0003\u0002B\u0017\u0005gi!Aa\f\u000b\u0007\tEb+A\u0003u_BL7-\u0003\u0003\u00036\t=\"!\u0006#ve\u0006\u0014\u0017\u000e\\5usR{\u0007/[2D_:4\u0017nZ\u0001\ri>\u0004\u0018nY\"p]\u001aLw\rI\u0001\fCV$\u0017\u000e^\"p]\u001aLw-\u0001\u0007bk\u0012LGoQ8oM&<\u0007%A\u0006bk\u0012LG/\u0012<f]R\u001cXC\u0001B!!\u0019\u0011\u0019E!\u0015\u0003X9!!Q\tB'!\r\u00119%^\u0007\u0003\u0005\u0013R1Aa\u0013[\u0003\u0019a$o\\8u}%\u0019!qJ;\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011\u0019F!\u0016\u0003\u0007M+GOC\u0002\u0003PU\u0004BA!\u0017\u0003p9!!1\fB5\u001d\u0011\u0011iF!\u001a\u000f\t\t}#1\r\b\u0005\u0005\u000f\u0012\t'C\u0001Z\u0013\t9\u0006,C\u0002\u0003hY\u000ba!\u001a<f]R\u001c\u0018\u0002\u0002B6\u0005[\n1\u0003R;sC\nLG.\u001b;z\u000bZ,g\u000e\u001e+za\u0016T1Aa\u001aW\u0013\u0011\u0011\tHa\u001d\u0003'\u0011+(/\u00192jY&$\u00180\u0012<f]R$\u0016\u0010]3\u000b\t\t-$QN\u0001\u0010CV$\u0017\u000e^#wK:$8o\u0018\u0013fcR!\u0011\u0011\u000bB=\u0011%\tIFLA\u0001\u0002\u0004\u0011\t%\u0001\u0007bk\u0012LG/\u0012<f]R\u001c\b%A\u0006bk\u0012LGo\u00115fG.\u001cXC\u0001BA!\u0019\u0011\u0019E!\u0015\u0003\u0004B!!Q\u0011BH\u001d\u0011\u00119Ia#\u000f\t\tu#\u0011R\u0005\u0003+ZK1A!$U\u0003Q!UO]1cS2LG/_!vI&$8\t[3dW&!!\u0011\u0013BJ\u0005Q!UO]1cS2LG/_!vI&$8\t[3dW*\u0019!Q\u0012+\u0002\u001f\u0005,H-\u001b;DQ\u0016\u001c7n]0%KF$B!!\u0015\u0003\u001a\"I\u0011\u0011L\u0019\u0002\u0002\u0003\u0007!\u0011Q\u0001\rCV$\u0017\u000e^\"iK\u000e\\7\u000fI\u0001\u0010O\u0016$Hk\u001c9jG6\u000bg.Y4feV\u0011!\u0011\u0015\t\u0005\u0005[\u0011\u0019+\u0003\u0003\u0003&\n=\"A\u0006#ve\u0006\u0014\u0017\u000e\\5usR{\u0007/[2NC:\fw-\u001a:\u0002\u0019Q|\u0007/[2NC:\fw-\u001a:\u0002\u001bQ|\u0007/[2NC:\fw-\u001a:!\u0003\r\u0011XO\u001c\u000b\u0003\u0003#B3A\u000eBY!\u0011\u0011\u0019L!/\u000e\u0005\tU&\u0002\u0002B\\\u0003s\tA\u0001\\1oO&!!1\u0018B[\u0005!ye/\u001a:sS\u0012,\u0017A\u00023p/>\u00148\u000eK\u00028\u0005c\u000b1c]2iK\u0012,H.\u001a(fo\u0006+H-\u001b;K_\n$\"A!2\u0011\u0007\u0015\u00149-C\u0002\u0003JR\u0013\u0001\"Q;eSRTuNY\u0001\u0011S:LG/[1m\t\u0016d\u0017-\u001f#p]\u0016$BAa4\u0003VB\u0019AO!5\n\u0007\tMWOA\u0004C_>dW-\u00198\t\u000f\u0005\r\u0011\b1\u0001\u0002\b\u0005I2\u000f[8vY\u0012\u001c6\r[3ek2,g*Z<Bk\u0012LGOS8c)\t\u0011y-\u0001\u000bti>\u0004X\t_5ti&tw-Q;eSRTuNY\u0001\u0018g\u0016tG-\u0012<f]R\u0014\u0015\r^2i)&lWm\u00115fG.,\"Aa4\u0002)M,g\u000eZ#wK:$\b*Z1mi\"\u001c\u0005.Z2l\u00031!wnV8sW\u0006\u001bG/^1m)!\t\tFa:\u0003l\n=\b\"\u0003Bu}A\u0005\t\u0019\u0001Bh\u0003A\u00198\r[3ek2,\u0017)\u001e3ji*{'\rC\u0005\u0003nz\u0002\n\u00111\u0001\u0003P\u0006Qa\r\\;tQ\n\u000bGo\u00195\t\u0013\tEh\b%AA\u0002\t=\u0017aC;tK2{7-\u00197M_\u001e\fa\u0003Z8X_J\\\u0017i\u0019;vC2$C-\u001a4bk2$H%M\u000b\u0003\u0005oTCAa4\u0003z.\u0012!1 \t\u0005\u0005{\u001c9!\u0004\u0002\u0003\u0000*!1\u0011AB\u0002\u0003%)hn\u00195fG.,GMC\u0002\u0004\u0006U\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0019IAa@\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\fe_^{'o[!diV\fG\u000e\n3fM\u0006,H\u000e\u001e\u00133\u0003Y!wnV8sW\u0006\u001bG/^1mI\u0011,g-Y;mi\u0012\u001a\u0014!\u00059s_\u000e,7o]#wK:$()\u0019;dQ\u0006)b-\u001a;dQ\u0016\u0003xn\u00195JM2+\u0017\rZ3s\u0019><G\u0003BA1\u0007+Aqaa\u0006D\u0001\u0004\t)*\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0002#%\u001cX*\u001b:s_J\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0003P\u000eu\u0001bBB\f\t\u0002\u0007\u0011QS\u0001\rSN\u0014VmZ5ti\u0016\u0014X\r\u001a\u000b\t\u0005\u001f\u001c\u0019ca\n\u0004,!91QE#A\u0002\u0005\u0005\u0018\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u001d\u0019I#\u0012a\u0001\u0003C\nQ!\u001a9pG\"D\u0011b!\fF!\u0003\u0005\rAa4\u0002\u001b%\u001cX\t]8dQ\u000eC\u0017M\\4f\u0003YI7OU3hSN$XM]3eI\u0011,g-Y;mi\u0012\u001a\u0014AG5t'R\fG.\u001a#fY\u0016$XMU3d_J$'+Z9vKN$H\u0003\u0002Bh\u0007kAqaa\u000eH\u0001\u0004\u0019I$\u0001\u0004sK\u000e|'\u000f\u001a\t\u0004K\u000em\u0012bAB\u001f)\n)B)\u001a7fi\u0016lUm]:bO\u0016\u001c(+Z9vKN$\u0018!C:f]\u0012,e/\u001a8u)\u0019\u0011yma\u0011\u0004F!91q\u0007%A\u0002\u0005=\u0006\"\u0003By\u0011B\u0005\t\u0019\u0001Bh\u0003M\u0019XM\u001c3Fm\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003E\u0011XmZ5ti\u0016\u0014\b+\u0019:uSRLwN\u001c\u000b\u0005\u0003#\u001ai\u0005C\u0004\u00048)\u0003\raa\u0014\u0011\u0007\u0015\u001c\t&C\u0002\u0004TQ\u0013\u0001DU3hSN$XM\u001d)beRLG/[8o%\u0016\fX/Z:u\u0003E1G.^:i%\u0016\u001cwN\u001d3t#V,W/\u001a\u000b\u0005\u0003#\u001aI\u0006C\u0005\u0003r.\u0003\n\u00111\u0001\u0003P\u0006Yb\r\\;tQJ+7m\u001c:egF+X-^3%I\u00164\u0017-\u001e7uIE\nqa\u00197fC:,\b/A\bhKR\fV/Z;fI\u00163XM\u001c;t+\t\u0019\u0019\u0007E\u0004u\u0007K\n\t'a/\n\u0007\r\u001dTO\u0001\u0004UkBdWMM\u0001\r\u0003V$\u0017\u000e^'b]\u0006<WM\u001d\t\u0003KB\u001bR\u0001UB8\u0007k\u00022\u0001^B9\u0013\r\u0019\u0019(\u001e\u0002\u0007\u0003:L(+\u001a4\u0011\u0007\u0015\u001c9(C\u0002\u0004zQ\u0013\u0011#Q;eSRl\u0015M\\1hKJ$&/Y5u)\t\u0019Y'\u0001\u0007hKR$\u0015-_(g3\u0016\f'\u000f\u0006\u0003\u0002b\r\u0005\u0005bBA\u0002%\u0002\u0007\u0011q\u0001")
public class AuditManager
extends ShutdownableThread {
    private final DurabilityAuditConfig config;
    private final ReplicaManager replicaManager;
    private final Option<TierObjectStore> tierObjectStoreOpt;
    private final Time time;
    private final Instant startInstant;
    private KafkaThread auditJobThread;
    private int currentJobId;
    private CountDownLatch auditJobCountdownLatch;
    private final ConcurrentHashMap<TopicPartition, HighWatermarkUpdateRequest> highWatermarkUpdateRequests;
    private final LinkedBlockingQueue<AuditManagerRequest> auditRequestsQueue;
    private volatile long lastBatchEventTime;
    private volatile long lastHealthCheckTime;
    private final TopicIdPartition healthCheckPartition;
    private final DurabilityDB db;
    private final DurabilityMetricsManager metricsManager;
    private final AuditReporter reporter;
    private final DurabilityEventsMaterialize materialize;
    private final DurabilityTopicConfig topicConfig;
    private final DurabilityAuditConfig auditConfig;
    private Set<Enumeration.Value> auditEvents;
    private Set<Enumeration.Value> auditChecks;
    private final DurabilityTopicManager topicManager;

    public static void reconfigureConfigValues(String events, String checks) {
        AuditManagerTrait.reconfigureConfigValues$(AuditManager$.MODULE$, events, checks);
    }

    public static void submitAuditRequest(AuditManagerRequest auditRequest) {
        AuditManagerTrait.submitAuditRequest$(AuditManager$.MODULE$, auditRequest);
    }

    public static boolean stopAuditManager$default$1() {
        return true;
    }

    public static void stopAuditManager(boolean shutdown) {
        AuditManagerTrait.stopAuditManager$(AuditManager$.MODULE$, shutdown);
    }

    public static void startAuditManager() {
        AuditManagerTrait.startAuditManager$(AuditManager$.MODULE$);
    }

    public static Option<AuditManager> initialize(DurabilityAuditConfig config, ReplicaManager replicaManager, Option<TierObjectStore> tierObjectStoreOpt, Time time) {
        return AuditManagerTrait.initialize$(AuditManager$.MODULE$, config, replicaManager, tierObjectStoreOpt, time);
    }

    public static ConcurrentHashMap<TopicIdPartition, RegisterPartitionRequest> pendingRegistration() {
        return AuditManager$.MODULE$.pendingRegistration();
    }

    public static void instance_$eq(AuditManager x$1) {
        AuditManager$.MODULE$.instance_$eq(x$1);
    }

    public static AuditManager instance() {
        return AuditManager$.MODULE$.instance();
    }

    public DurabilityAuditConfig config() {
        return this.config;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public Time time() {
        return this.time;
    }

    private Instant startInstant() {
        return this.startInstant;
    }

    private KafkaThread auditJobThread() {
        return this.auditJobThread;
    }

    private void auditJobThread_$eq(KafkaThread x$1) {
        this.auditJobThread = x$1;
    }

    public int currentJobId() {
        return this.currentJobId;
    }

    public void currentJobId_$eq(int x$1) {
        this.currentJobId = x$1;
    }

    public CountDownLatch auditJobCountdownLatch() {
        return this.auditJobCountdownLatch;
    }

    public void auditJobCountdownLatch_$eq(CountDownLatch x$1) {
        this.auditJobCountdownLatch = x$1;
    }

    public ConcurrentHashMap<TopicPartition, HighWatermarkUpdateRequest> highWatermarkUpdateRequests() {
        return this.highWatermarkUpdateRequests;
    }

    public LinkedBlockingQueue<AuditManagerRequest> auditRequestsQueue() {
        return this.auditRequestsQueue;
    }

    public long lastBatchEventTime() {
        return this.lastBatchEventTime;
    }

    public void lastBatchEventTime_$eq(long x$1) {
        this.lastBatchEventTime = x$1;
    }

    public long lastHealthCheckTime() {
        return this.lastHealthCheckTime;
    }

    public void lastHealthCheckTime_$eq(long x$1) {
        this.lastHealthCheckTime = x$1;
    }

    public TopicIdPartition healthCheckPartition() {
        return this.healthCheckPartition;
    }

    public DurabilityDB getDB() {
        return DurabilityDB$.MODULE$.apply(this.config().dbPath());
    }

    public DurabilityDB db() {
        return this.db;
    }

    public DurabilityMetricsManager metricsManager() {
        return this.metricsManager;
    }

    public AuditReporter reporter() {
        return this.reporter;
    }

    public DurabilityEventsMaterialize materialize() {
        return this.materialize;
    }

    public DurabilityTopicConfig topicConfig() {
        return this.topicConfig;
    }

    public DurabilityAuditConfig auditConfig() {
        return this.auditConfig;
    }

    public Set<Enumeration.Value> auditEvents() {
        return this.auditEvents;
    }

    public void auditEvents_$eq(Set<Enumeration.Value> x$1) {
        this.auditEvents = x$1;
    }

    public Set<Enumeration.Value> auditChecks() {
        return this.auditChecks;
    }

    public void auditChecks_$eq(Set<Enumeration.Value> x$1) {
        this.auditChecks = x$1;
    }

    public DurabilityTopicManager getTopicManager() {
        return new DurabilityTopicManager(this.topicConfig(), this.db(), this.materialize(), this.config().internalAdminSupplier(), Time.SYSTEM);
    }

    public DurabilityTopicManager topicManager() {
        return this.topicManager;
    }

    @Override
    public void run() {
        this.topicManager().start();
        super.run();
    }

    @Override
    public void doWork() {
        this.doWorkActual(true, this.doWorkActual$default$2(), this.doWorkActual$default$3());
        this.pause(DurabilityAuditConstants$.MODULE$.DURABILITY_JOB_LOOP_WAIT_MS(), TimeUnit.MILLISECONDS);
    }

    private AuditJob scheduleNewAuditJob() {
        this.stopExistingAuditJob();
        int newJobId = AuditManager$.MODULE$.kafka$durability$audit$AuditManager$$getDayOfYear(this.time());
        int oldJobId = this.reporter().resetJob(newJobId);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Going to schedule new AuditJob, (").append(oldJobId).append(" -> ").append(newJobId).append(")").toString());
        this.auditJobCountdownLatch_$eq(new CountDownLatch(1));
        this.currentJobId_$eq(newJobId);
        AuditJob auditJob = new AuditJob(this.db().getTopicPartitionsForAudit(), this.replicaManager().logManager(), this.auditJobCountdownLatch(), this.reporter(), this.currentJobId(), this.tierObjectStoreOpt, this.time(), this.auditChecks(), this.auditConfig(), this.db(), (Option<ReplicaManager>)new Some((Object)this.replicaManager()));
        String nonDaemon_name = new StringBuilder(9).append("AuditJob-").append(this.currentJobId()).toString();
        Object var4_4 = null;
        this.auditJobThread_$eq(new KafkaThread(nonDaemon_name, (Runnable)auditJob, false));
        this.auditJobThread().start();
        return auditJob;
    }

    private boolean initialDelayDone(Time time) {
        Instant now = Instant.ofEpochMilli(time.milliseconds());
        return Duration.between(this.startInstant(), now).toMillis() > this.config().initialAuditJobDelayMs() && this.db().getTopicPartitionsForAudit().nonEmpty();
    }

    public boolean shouldScheduleNewAuditJob() {
        Option option = Option$.MODULE$.apply((Object)this.auditJobThread());
        if (option instanceof Some && ((KafkaThread)((Some)option).value()).isAlive()) {
            return false;
        }
        int currDay = AuditManager$.MODULE$.kafka$durability$audit$AuditManager$$getDayOfYear(this.time());
        return this.auditJobCountdownLatch().getCount() == 0L && (currDay > this.currentJobId() || currDay == 1 && this.currentJobId() >= 365) && this.initialDelayDone(this.time());
    }

    private void stopExistingAuditJob() {
        if (this.auditJobThread() != null && this.auditJobThread().isAlive()) {
            this.auditJobCountdownLatch().countDown();
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("AuditManager cancelled AuditJob with jobId: ").append(this.currentJobId()).toString());
            return;
        }
    }

    private boolean sendEventBatchTimeCheck() {
        long currentTimeMs = this.time().milliseconds();
        if (currentTimeMs - this.lastBatchEventTime() >= this.config().batchEventFlushFrequencyMs()) {
            this.lastBatchEventTime_$eq(currentTimeMs);
            return true;
        }
        return false;
    }

    private boolean sendEventHealthCheck() {
        long currentTimeMs = this.time().milliseconds();
        if (currentTimeMs - this.lastHealthCheckTime() >= DurabilityAuditConstants$.MODULE$.HEALTH_CHECK_UPDATE_TIME_MS()) {
            this.lastHealthCheckTime_$eq(currentTimeMs);
            return true;
        }
        return false;
    }

    public void doWorkActual(boolean scheduleAuditJob, boolean flushBatch, boolean useLocalLog) {
        if (scheduleAuditJob && this.shouldScheduleNewAuditJob() && this.config().auditChecks().contains((Object)DurabilityAuditCheck$.MODULE$.PeriodicalAudit())) {
            this.scheduleNewAuditJob();
        }
        if (this.sendEventHealthCheck()) {
            AuditManagerTrait.submitAuditRequest$(AuditManager$.MODULE$, new HealthCheckRequest(this.healthCheckPartition(), -1, this.topicConfig().brokerId(), this.time().milliseconds()));
        }
        if (this.sendEventBatchTimeCheck() || flushBatch) {
            this.processEventBatch();
            return;
        }
        this.flushRecordsQueue(useLocalLog);
    }

    public boolean doWorkActual$default$1() {
        return false;
    }

    public boolean doWorkActual$default$2() {
        return false;
    }

    public boolean doWorkActual$default$3() {
        return true;
    }

    private void processEventBatch() {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Process batchedRequest, auditRequest queue size is ").append(this.highWatermarkUpdateRequests().size()).toString());
        HashMap<TopicPartition, HighWatermarkUpdateRequest> snapshot = new HashMap<TopicPartition, HighWatermarkUpdateRequest>(this.highWatermarkUpdateRequests());
        AuditManagerRequest record = this.auditRequestsQueue().poll();
        for (int size = this.auditRequestsQueue().size(); size > 0 && record != null; --size) {
            if (this.sendEvent(record, this.sendEvent$default$2())) {
                snapshot.remove(record.topicIdPartition().topicPartition());
                this.highWatermarkUpdateRequests().remove(record.topicIdPartition().topicPartition());
            }
            record = this.auditRequestsQueue().poll();
        }
        snapshot.forEach((x0$1, x1$1) -> {
            if (this.isRegistered(x1$1.topicIdPartition(), x1$1.epoch(), false)) {
                this.topicManager().addDurabilityEvent(OffsetChangeEvent$.MODULE$.apply(x1$1.topicIdPartition(), x1$1.epoch(), x1$1.hwm(), x1$1.startOffset(), x1$1.isr()));
            }
            this.highWatermarkUpdateRequests().remove(x0$1);
        });
        snapshot.clear();
        this.db().checkpoint();
    }

    public int fetchEpochIfLeaderLog(TopicPartition topicPartition) {
        return Utils$.MODULE$.getLocalReplicaEpochIfLeader(this.replicaManager(), topicPartition);
    }

    public boolean isMirrorPartition(TopicPartition topicPartition) {
        return Utils$.MODULE$.getMirrorState(this.replicaManager(), topicPartition);
    }

    private boolean isRegistered(TopicIdPartition topicIdPartition, int epoch, boolean isEpochChange) {
        PartitionState state;
        boolean bl = false;
        Some some = null;
        Option<PartitionState> option = this.db().fetchPartitionState(topicIdPartition.topicPartition());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            if (((PartitionState)some.value()).isMirror()) {
                return false;
            }
        }
        if (bl && (state = (PartitionState)some.value()).isLeader() && (state.latestLocalEpoch() == epoch || isEpochChange && epoch == -1)) {
            return true;
        }
        int localEpoch = this.fetchEpochIfLeaderLog(topicIdPartition.topicPartition());
        if (localEpoch == -1 || localEpoch > epoch || epoch == -1) {
            return false;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(81).append("Durability registration for ").append(topicIdPartition).append(" was found missing, recovering for epoch ").append(epoch).append(" localEpoch ").append(localEpoch).toString());
        this.registerPartition(new RegisterPartitionRequest(topicIdPartition, localEpoch, true));
        return !this.isMirrorPartition(topicIdPartition.topicPartition());
    }

    private boolean isRegistered$default$3() {
        return false;
    }

    private boolean isStaleDeleteRecordRequest(DeleteMessagesRequest record) {
        Option<PartitionState> option = this.db().fetchPartitionState(record.topicIdPartition().topicPartition());
        return !(option instanceof Some) || ((PartitionState)((Some)option).value()).committedStartOffset() >= record.trimOffset();
    }

    /*
     * WARNING - void declaration
     */
    public boolean sendEvent(AuditManagerRequest record, boolean useLocalLog) {
        None$ event;
        DeletePartitionRequest deletePartitionRequest;
        DeleteMessagesRequest deleteMessagesRequest;
        ISRExpandRequest iSRExpandRequest;
        RetentionConfigChangeRequest retentionConfigChangeRequest;
        EpochChangeRequest epochChangeRequest;
        StartOffsetChangeRequest startOffsetChangeRequest;
        Object object;
        if (record instanceof RegisterPartitionRequest) {
            RegisterPartitionRequest registerPartitionRequest = (RegisterPartitionRequest)record;
            this.registerPartition(registerPartitionRequest);
            this.highWatermarkUpdateRequests().remove(registerPartitionRequest.topicIdPartition().topicPartition());
            object = None$.MODULE$;
        } else if (record instanceof StartOffsetChangeRequest && this.isRegistered((startOffsetChangeRequest = (StartOffsetChangeRequest)record).topicIdPartition(), startOffsetChangeRequest.epoch(), false)) {
            Option<Set<Object>> option = Utils$.MODULE$.getIsrIfLeaderPartition(this.replicaManager(), startOffsetChangeRequest.topicIdPartition().topicPartition());
            if (option instanceof Some) {
                Set isr = (Set)((Some)option).value();
                object = new Some((Object)StartOffsetChangeEvent$.MODULE$.apply(startOffsetChangeRequest.topicIdPartition(), startOffsetChangeRequest.epoch(), startOffsetChangeRequest.highWatermark(), startOffsetChangeRequest.startOffset(), (byte)startOffsetChangeRequest.retentionType().id(), startOffsetChangeRequest.retentionValue(), (Set<Object>)isr));
            } else {
                object = !useLocalLog ? new Some((Object)StartOffsetChangeEvent$.MODULE$.apply(startOffsetChangeRequest.topicIdPartition(), startOffsetChangeRequest.epoch(), startOffsetChangeRequest.highWatermark(), startOffsetChangeRequest.startOffset(), (byte)startOffsetChangeRequest.retentionType().id(), startOffsetChangeRequest.retentionValue(), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))))) : None$.MODULE$;
            }
        } else if (record instanceof EpochChangeRequest && this.isRegistered((epochChangeRequest = (EpochChangeRequest)record).topicIdPartition(), -1, true)) {
            object = new Some((Object)EpochChangeEvent$.MODULE$.apply(epochChangeRequest.topicIdPartition(), epochChangeRequest.firstOffset(), epochChangeRequest.epoch(), epochChangeRequest.highWaterMark(), epochChangeRequest.startOffset(), epochChangeRequest.isr()));
        } else if (record instanceof RetentionConfigChangeRequest && this.isRegistered((retentionConfigChangeRequest = (RetentionConfigChangeRequest)record).topicIdPartition(), retentionConfigChangeRequest.epoch(), false)) {
            object = new Some((Object)RetentionChangeEvent$.MODULE$.apply(retentionConfigChangeRequest.topicIdPartition(), retentionConfigChangeRequest.retentionMs(), retentionConfigChangeRequest.retentionSz(), retentionConfigChangeRequest.epoch(), -1L, -1L));
        } else if (record instanceof ISRExpandRequest && this.isRegistered((iSRExpandRequest = (ISRExpandRequest)record).topicIdPartition(), iSRExpandRequest.epoch(), false)) {
            object = new Some((Object)IsrExpandEvent$.MODULE$.apply(iSRExpandRequest.topicIdPartition(), iSRExpandRequest.brokerId(), iSRExpandRequest.epoch(), -1L, -1L));
        } else if (record instanceof DeleteMessagesRequest && this.isRegistered((deleteMessagesRequest = (DeleteMessagesRequest)record).topicIdPartition(), deleteMessagesRequest.epoch(), false) && !this.isStaleDeleteRecordRequest(deleteMessagesRequest)) {
            object = new Some((Object)DeleteRecordsEvent$.MODULE$.apply(deleteMessagesRequest.topicIdPartition(), deleteMessagesRequest.trimOffset(), deleteMessagesRequest.epoch(), deleteMessagesRequest.highWatermark(), deleteMessagesRequest.startOffset(), deleteMessagesRequest.isr()));
        } else if (record instanceof DeletePartitionRequest && this.isRegistered((deletePartitionRequest = (DeletePartitionRequest)record).topicIdPartition(), deletePartitionRequest.epoch(), false)) {
            object = new Some((Object)DeletePartitionEvent$.MODULE$.apply(deletePartitionRequest.topicIdPartition(), deletePartitionRequest.epoch()));
        } else if (record instanceof HealthCheckRequest) {
            void apply_timeStamp;
            void apply_brokerId;
            void apply_logStartOffset;
            void apply_highWatermark;
            void apply_epoch;
            void apply_version;
            HealthCheckRequest healthCheckRequest = (HealthCheckRequest)record;
            long l = healthCheckRequest.timeStamp();
            int n = healthCheckRequest.brokerId();
            long l2 = -1L;
            long l3 = -1L;
            int n2 = healthCheckRequest.epoch();
            int n3 = 2;
            TopicIdPartition apply_id = healthCheckRequest.topicIdPartition();
            Object var15_19 = null;
            Some some = new Some((Object)new HealthCheckEvent(apply_id, (int)apply_version, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_brokerId, (long)apply_timeStamp));
            object = some;
        } else {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Rejected record for sending as event ").append(record).append(", ignoring").toString());
            object = event = None$.MODULE$;
        }
        if (event instanceof Some) {
            AbstractDurabilityEvent e = (AbstractDurabilityEvent)((Some)event).value();
            this.topicManager().addDurabilityEvent(e);
            this.highWatermarkUpdateRequests().remove(record.topicIdPartition().topicPartition());
            return true;
        }
        return false;
    }

    public boolean sendEvent$default$2() {
        return true;
    }

    private void registerPartition(RegisterPartitionRequest record) {
        Option<PartitionState> option = this.db().fetchPartitionState(record.topicIdPartition().topicPartition());
        if (option instanceof Some) {
            PartitionState state = (PartitionState)((Some)option).value();
            if (state.latestLocalEpoch() >= record.epoch()) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(121).append("Durability Registration event from stale/registered replica for ").append(record.topicIdPartition()).append(" for ").append(record.epoch()).append(" with leader flag set to ").append(record.isLeader()).append(". The existing db state is ").append(state).toString());
                return;
            }
        } else if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        ObjectRef state = ObjectRef.create((Object)((PartitionState)this.db().fetchPartitionState(record.topicIdPartition().topicPartition()).getOrElse((Function0 & Serializable)() -> PartitionState$.MODULE$.apply(record.topicIdPartition().topicPartition().partition(), 0L))));
        Uuid uuid = ((PartitionState)state.elem).topicId();
        Uuid uuid2 = Uuid.ZERO_UUID;
        if (uuid == null ? uuid2 != null : !uuid.equals(uuid2)) {
            Uuid uuid3 = record.topicIdPartition().topicId();
            Uuid uuid4 = Uuid.ZERO_UUID;
            if (uuid3 == null ? uuid4 != null : !uuid3.equals(uuid4)) {
                Uuid uuid5 = record.topicIdPartition().topicId();
                Uuid uuid6 = ((PartitionState)state.elem).topicId();
                if (uuid5 == null ? uuid6 != null : !uuid5.equals(uuid6)) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(110).append("Durability partition reset for ").append(record.topicIdPartition()).append(" old topicID ").append(((PartitionState)state$2.elem).topicId()).append(" due to change in topicId likely due to missing partition deletion").toString());
                    state.elem = PartitionState$.MODULE$.apply(record.topicIdPartition().topicPartition().partition(), ((PartitionState)state.elem).config());
                }
            }
        }
        ((PartitionState)state.elem).latestLocalEpoch_$eq(record.epoch());
        ((PartitionState)state.elem).isLeader_$eq(record.isLeader());
        ((PartitionState)state.elem).isMirror_$eq(this.isMirrorPartition(record.topicIdPartition().topicPartition()));
        ((PartitionState)state.elem).topicId_$eq(record.topicIdPartition().topicId());
        if (Utils$.MODULE$.isCompacted(this.replicaManager(), record.topicIdPartition().topicPartition())) {
            PartitionState partitionState = (PartitionState)state.elem;
            partitionState.config_$eq(partitionState.config() | (long)ConfigFlag$.MODULE$.OnceCompacted().id());
        }
        this.db().addPartition(record.topicIdPartition().topicPartition(), (PartitionState)state.elem);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Durability registration for ").append(record.topicIdPartition()).append(" epoch ").append(record.epoch()).append(" isLeader ").append(record.isLeader()).append(" isMirror ").append(((PartitionState)state$2.elem).isMirror()).append(" is done.").toString());
    }

    private void flushRecordsQueue(boolean useLocalLog) {
        int count = 0;
        ObjectRef record = ObjectRef.create((Object)this.auditRequestsQueue().poll());
        while ((AuditManagerRequest)record.elem != null) {
            AuditManagerRequest auditManagerRequest = (AuditManagerRequest)record.elem;
            if (auditManagerRequest != null) {
                this.sendEvent(auditManagerRequest, useLocalLog);
            } else {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(16).append("Unknown request ").append((AuditManagerRequest)record$3.elem).toString());
            }
            if (++count >= DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP()) {
                return;
            }
            record.elem = this.auditRequestsQueue().poll();
        }
    }

    private boolean flushRecordsQueue$default$1() {
        return true;
    }

    public void cleanup() {
        try {
            Instant cleanupStart = Instant.ofEpochMilli(this.time().milliseconds());
            this.stopExistingAuditJob();
            this.processEventBatch();
            this.flushRecordsQueue(true);
            this.topicManager().shutdown();
            long cleanupDuration = Duration.between(cleanupStart, Instant.ofEpochMilli(this.time().milliseconds())).toMillis();
            this.metricsManager().shutdown();
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("AuditManager cleanup complete in ").append(cleanupDuration).append(" ms").toString());
            return;
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Received error while cleaning up AuditManager", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public Tuple2<Object, Object> getQueuedEvents() {
        return new Tuple2.mcIJ.sp(this.auditRequestsQueue().size(), (long)this.highWatermarkUpdateRequests().size());
    }

    /*
     * WARNING - void declaration
     */
    public AuditManager(DurabilityAuditConfig config, ReplicaManager replicaManager, Option<TierObjectStore> tierObjectStoreOpt, Time time) {
        void apply_reportingDelayMs;
        void apply_metrics;
        this.config = config;
        this.replicaManager = replicaManager;
        this.tierObjectStoreOpt = tierObjectStoreOpt;
        this.time = time;
        super("AuditManager", true);
        this.startInstant = Instant.ofEpochMilli(time.milliseconds());
        this.currentJobId = 0;
        this.auditJobCountdownLatch = new CountDownLatch(0);
        this.highWatermarkUpdateRequests = new ConcurrentHashMap();
        this.auditRequestsQueue = new LinkedBlockingQueue(DurabilityAuditConstants$.MODULE$.DURABILITY_RECORD_MAX_QUEUE_SIZE());
        this.lastBatchEventTime = time.milliseconds();
        this.lastHealthCheckTime = time.milliseconds();
        this.healthCheckPartition = new TopicIdPartition(Uuid.ZERO_UUID, new TopicPartition("durability-health-check", 0));
        this.db = this.getDB();
        long l = config.reportingBatchMs();
        Metrics metrics = config.metrics();
        String apply_brokerId = Integer.toString(config.brokerId());
        Object var5_7 = null;
        metrics = null;
        this.metricsManager = new DurabilityMetricsManager(apply_brokerId, (Metrics)apply_metrics, time, (long)apply_reportingDelayMs);
        DurabilityMetricsManager apply_metricManager = this.metricsManager();
        Object var9_8 = null;
        this.reporter = new AuditReporter(apply_metricManager);
        this.materialize = new DurabilityEventsMaterialize(replicaManager, this.db(), this.reporter(), time);
        this.topicConfig = new DurabilityTopicConfig(config.interBrokerClientConfigs(), DurabilityAuditConstants$.MODULE$.TOPIC_NAME(), config.topicPartitionCount(), config.topicReplicationFactor(), config.brokerId(), config.clusterId(), DurabilityAuditConstants$.MODULE$.DURABILITY_CONSUMER_POLL_DURATION_MS(), Predef$.MODULE$.int2Integer(DurabilityAuditConstants$.MODULE$.DURABILITY_PRODUCER_REQUEST_TIMEOUT_MS()), DurabilityAuditConstants$.MODULE$.DURABILITY_TOPIC_RETENTION_MS());
        this.auditConfig = config;
        this.auditEvents = config.allowedEvents();
        this.auditChecks = config.auditChecks();
        this.topicManager = this.getTopicManager();
    }
}

