/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import java.io.Serializable;
import java.time.Instant;
import kafka.Kafka$;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.DurabilityStats;
import kafka.durability.audit.SegmentOffsetMap;
import kafka.durability.audit.SegmentRange;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001\u0002\u0010 \u0001\u0019B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\u0006e\u0001!Ia\r\u0005\bo\u0001\u0001\r\u0011\"\u00039\u0011\u001da\u0004\u00011A\u0005\nuBaa\u0011\u0001!B\u0013I\u0004b\u0002#\u0001\u0005\u0004%I!\u0012\u0005\u0007?\u0002\u0001\u000b\u0011\u0002$\t\u000f\u0001\u0004!\u0019!C\u0005C\"1Q\r\u0001Q\u0001\n\tDQA\u001a\u0001\u0005\u0002\u001dDq!a\t\u0001\t\u0003\t)\u0003C\u0005\u00024\u0001\t\n\u0011\"\u0001\u00026!9\u00111\n\u0001\u0005\u0002\u00055\u0003bBA,\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0003W\u0002A\u0011AA-\u0011\u001d\ti\u0007\u0001C\u0001\u0003_Bq!!\u001e\u0001\t\u0003\t9\bC\u0004\u0002|\u0001!\t!! \t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\"9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0005bBAG\u0001\u0011\u0005\u0011q\u0012\u0005\b\u0003'\u0003A\u0011AAK\u0011\u001d\tY\n\u0001C\u0001\u0003;Cq!a(\u0001\t\u0003\t\t\u000bC\u0004\u0002(\u0002!\t!!+\b\u000f\u0005=v\u0004#\u0001\u00022\u001a1ad\bE\u0001\u0003gCaAM\u000e\u0005\u0002\u0005U\u0006bBA\\7\u0011\u0005\u0011\u0011\u0018\u0002\u000e\u0003V$\u0017\u000e\u001e*fa>\u0014H/\u001a:\u000b\u0005\u0001\n\u0013!B1vI&$(B\u0001\u0012$\u0003)!WO]1cS2LG/\u001f\u0006\u0002I\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001(!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fM\u0006iQ.\u001a;sS\u000el\u0015M\\1hKJ\u0004\"a\f\u0019\u000e\u0003\u0005J!!M\u0011\u00031\u0011+(/\u00192jY&$\u00180T3ue&\u001c7/T1oC\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u0003iY\u0002\"!\u000e\u0001\u000e\u0003}AQ!\f\u0002A\u00029\nQA[8c\u0013\u0012,\u0012!\u000f\t\u0003QiJ!aO\u0015\u0003\u0007%sG/A\u0005k_\nLEm\u0018\u0013fcR\u0011a(\u0011\t\u0003Q}J!\u0001Q\u0015\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005\u0012\t\t\u00111\u0001:\u0003\rAH%M\u0001\u0007U>\u0014\u0017\n\u001a\u0011\u0002\u0015M\u001cwN]5oO6\u000b\u0007/F\u0001G!\u00119EJT-\u000e\u0003!S!!\u0013&\u0002\u000f5,H/\u00192mK*\u00111*K\u0001\u000bG>dG.Z2uS>t\u0017BA'I\u0005\u001dA\u0015m\u001d5NCB\u0004\"aT,\u000e\u0003AS!!\u0015*\u0002\r\r|W.\\8o\u0015\t!3K\u0003\u0002U+\u00061\u0011\r]1dQ\u0016T\u0011AV\u0001\u0004_J<\u0017B\u0001-Q\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B\u0001\u000b.]9&\u00111,\u000b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005!j\u0016B\u00010*\u0005\u0011auN\\4\u0002\u0017M\u001cwN]5oO6\u000b\u0007\u000fI\u0001\u0011g\u0016<W.\u001a8u\u001f\u001a47/\u001a;NCB,\u0012A\u0019\t\u0003k\rL!\u0001Z\u0010\u0003!M+w-\\3oi>3gm]3u\u001b\u0006\u0004\u0018!E:fO6,g\u000e^(gMN,G/T1qA\u0005)\"/\u001a9peR$UO]1cS2LG/\u001f'baN,G#\u0003 iU2t\u0017QAA\r\u0011\u0015I'\u00021\u0001O\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:DQa\u001b\u0006A\u0002q\u000b1b\u001d;beR|eMZ:fi\")QN\u0003a\u00019\u0006IAn\\:t\u0007>,h\u000e\u001e\u0005\u0006_*\u0001\r\u0001]\u0001\nY\u0006\u00048/\u001a+za\u0016\u0004\"!]@\u000f\u0005IdhBA:{\u001d\t!\u0018P\u0004\u0002vq6\taO\u0003\u0002xK\u00051AH]8pizJ\u0011\u0001J\u0005\u0003E\rJ!a_\u0011\u0002\u001f5\fG/\u001a:jC2L'0\u0019;j_:L!! @\u0002'\u0011+(/\u00192jY&$\u0018\u0010T1qg\u0016$\u0016\u0010]3\u000b\u0005m\f\u0013\u0002BA\u0001\u0003\u0007\u00111\u0003R;sC\nLG.\u001b;z\u0019\u0006\u00048/\u001a+za\u0016T!! @\t\u000f\u0005\u001d!\u00021\u0001\u0002\n\u0005\u0019Qn]4\u0011\t\u0005-\u00111\u0003\b\u0005\u0003\u001b\ty\u0001\u0005\u0002vS%\u0019\u0011\u0011C\u0015\u0002\rA\u0013X\rZ3g\u0013\u0011\t)\"a\u0006\u0003\rM#(/\u001b8h\u0015\r\t\t\"\u000b\u0005\b\u00037Q\u0001\u0019AA\u000f\u0003\u0015\u00198m\u001c:f!\rA\u0013qD\u0005\u0004\u0003CI#a\u0002\"p_2,\u0017M\\\u0001\u0016e\u0016\u0004xN\u001d;EkJ\f'-\u001b7jif\fU\u000fZ5u)%q\u0014qEA\u0015\u0003W\ty\u0003C\u00038\u0017\u0001\u0007\u0011\bC\u0003j\u0017\u0001\u0007a\n\u0003\u0004\u0002.-\u0001\r\u0001X\u0001\ti>$\u0018\r\\'tO\"A\u0011\u0011G\u0006\u0011\u0002\u0003\u0007A,\u0001\u0006u_R\fG\u000eT1qg\u0016\fqD]3q_J$H)\u001e:bE&d\u0017\u000e^=Bk\u0012LG\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t9DK\u0002]\u0003sY#!a\u000f\u0011\t\u0005u\u0012qI\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000bJ\u0013AC1o]>$\u0018\r^5p]&!\u0011\u0011JA \u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0012kB$\u0017\r^3IK\u0006dG\u000f[\"iK\u000e\\G#\u0002 \u0002P\u0005M\u0003bBA)\u001b\u0001\u0007\u0011\u0011B\u0001\nEJ|7.\u001a:Te\u000eDa!!\u0016\u000e\u0001\u0004a\u0016!\u0003;j[\u0016\u001cF/Y7q\u00035\u0019H/\u0019:u\u0003V$\u0017\u000e\u001e&pER\u0011\u00111\f\t\u0005\u0003;\n9'\u0004\u0002\u0002`)!\u0011\u0011MA2\u0003\u0011!\u0018.\\3\u000b\u0005\u0005\u0015\u0014\u0001\u00026bm\u0006LA!!\u001b\u0002`\t9\u0011J\\:uC:$\u0018aF:uCJ$\u0018)\u001e3ji\u000e{W\u000e]1di&|gNS8c\u0003I\tG\r\u001a+jKJ\fU\u000fZ5u\u000bJ\u0014xN]:\u0015\u0007y\n\t\b\u0003\u0004\u0002tA\u0001\r\u0001X\u0001\u0006G>,h\u000e^\u0001\u001eC\u0012$G+[3s\u0003V$\u0017\u000e^+oW:|wO\\#yG\u0016\u0004H/[8ogR\u0019a(!\u001f\t\r\u0005M\u0014\u00031\u0001]\u0003m\tG\r\u001a+jKJ\fU\u000fZ5u%\u0016$(/_#yG\u0016\u0004H/[8ogR\u0019a(a \t\r\u0005M$\u00031\u0001]\u0003q\tG\rZ\"p[B\f7\r^3e!\u0006\u0014H/\u001b;j_:\u001c6.\u001b9qK\u0012$2APAC\u0011\u0019\t\u0019h\u0005a\u00019\u0006I\u0012\r\u001a3D_6\u0004\u0018m\u0019;fIB\u000b'\u000f^5uS>t\u0017\n\u001a7f)\rq\u00141\u0012\u0005\u0007\u0003g\"\u0002\u0019\u0001/\u00029\u0005$GmQ8na\u0006\u001cG/\u001a3QCJ$\u0018\u000e^5p]\u0006+H-\u001b;fIR\u0019a(!%\t\r\u0005MT\u00031\u0001]\u0003E)\b\u000fZ1uK\u0006+H-\u001b;EENK'0\u001a\u000b\u0004}\u0005]\u0005BBAM-\u0001\u0007A,\u0001\u0003tSj,\u0017!\u0005:fg\u0016$\u0018)\u001e3ji6+GO]5dgR\ta(A\u000bhKR$UO]1cS2LG/_\"pk:$XM]:\u0015\u0007e\u000b\u0019\u000b\u0003\u0004\u0002&b\u0001\rAT\u0001\u0003S\u0012\f\u0001B]3tKRTuN\u0019\u000b\u0004s\u0005-\u0006BBAW3\u0001\u0007\u0011(\u0001\u0005oK^TuNY%e\u00035\tU\u000fZ5u%\u0016\u0004xN\u001d;feB\u0011QgG\n\u00037\u001d\"\"!!-\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007Q\nY\fC\u0003.;\u0001\u0007a\u0006")
public class AuditReporter {
    private final DurabilityMetricsManager metricManager;
    private int jobId;
    private final HashMap<TopicPartition, Tuple2<Object, Object>> scoringMap;
    private final SegmentOffsetMap segmentOffsetMap;

    public static AuditReporter apply(DurabilityMetricsManager metricManager) {
        return new AuditReporter(metricManager);
    }

    private int jobId() {
        return this.jobId;
    }

    private void jobId_$eq(int x$1) {
        this.jobId = x$1;
    }

    private HashMap<TopicPartition, Tuple2<Object, Object>> scoringMap() {
        return this.scoringMap;
    }

    private SegmentOffsetMap segmentOffsetMap() {
        return this.segmentOffsetMap;
    }

    /*
     * WARNING - void declaration
     */
    public void reportDurabilityLapse(TopicPartition topicPartition, long startOffset, long lossCount, Enumeration.Value lapseType, String msg, boolean score) {
        void var14_13;
        void var13_12;
        String customerFacing = score ? "Customer impacting" : "Non Customer impacting";
        String lapseMsg = new StringBuilder(13).append(customerFacing).append(" ").append(msg).append("\n").append("lapseType: ").append(lapseType).toString();
        Enumeration.Value value = lapseType;
        Enumeration.Value value2 = DurabilityLapseType$.MODULE$.ChecksumValidation();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            Kafka$ error_this = Kafka$.MODULE$;
            if (error_this.logger().underlying().isErrorEnabled()) {
                error_this.logger().underlying().error(Logging.msgWithLogIdent$(error_this, lapseMsg));
            }
            Object var20_10 = null;
            this.metricManager.reportDurabilityLoss(lapseType, lossCount);
            return;
        }
        Tuple2<Object, Object> tuple2 = this.segmentOffsetMap().insert(topicPartition, new SegmentRange(startOffset, startOffset + lossCount - 1L, this.jobId(), true));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean reportAlert = tuple2._1$mcZ$sp();
        boolean reportLapse = tuple2._2$mcZ$sp();
        if (var13_12 != false) {
            if (score) {
                Kafka$ error_this = Kafka$.MODULE$;
                if (error_this.logger().underlying().isErrorEnabled()) {
                    error_this.logger().underlying().error(Logging.msgWithLogIdent$(error_this, lapseMsg));
                }
                Object var21_14 = null;
            } else {
                Kafka$ warn_this = Kafka$.MODULE$;
                if (warn_this.logger().underlying().isWarnEnabled()) {
                    warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, lapseMsg));
                }
                Object var22_15 = null;
            }
            this.metricManager.reportDurabilityLoss(lapseType, lossCount);
        }
        if (var14_13 != false) {
            if (var13_12 == false) {
                Kafka$ warn_this = Kafka$.MODULE$;
                if (warn_this.logger().underlying().isWarnEnabled()) {
                    String msgWithLogIdent_msg = AuditReporter.$anonfun$reportDurabilityLapse$4(lapseMsg);
                    Object var24_17 = null;
                    warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                }
                Object var23_16 = null;
            }
            if (score) {
                if (this.scoringMap().contains((Object)topicPartition)) {
                    void var18_20;
                    void var16_19;
                    Tuple2 tuple22 = (Tuple2)this.scoringMap().apply((Object)topicPartition);
                    if (tuple22 == null) {
                        throw new MatchError(null);
                    }
                    long total = tuple22._1$mcJ$sp();
                    long lapse = tuple22._2$mcJ$sp();
                    this.scoringMap().put((Object)topicPartition, (Object)new Tuple2.mcJJ.sp((long)var16_19, (long)(var18_20 + lossCount)));
                    return;
                }
                this.scoringMap().put((Object)topicPartition, (Object)new Tuple2.mcJJ.sp(0L, lossCount));
                return;
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void reportDurabilityAudit(int jobId, TopicPartition topicPartition, long totalMsg, long totalLapse) {
        long l;
        if (this.scoringMap().contains((Object)topicPartition)) {
            void var8_6;
            Tuple2 tuple2 = (Tuple2)this.scoringMap().apply((Object)topicPartition);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            long lapse = tuple2._2$mcJ$sp();
            this.scoringMap().put((Object)topicPartition, (Object)new Tuple2.mcJJ.sp(totalMsg, (long)(var8_6 + totalLapse)));
            l = var8_6 + totalLapse;
        } else {
            this.scoringMap().put((Object)topicPartition, (Object)new Tuple2.mcJJ.sp(totalMsg, totalLapse));
            l = totalLapse;
        }
        long l2 = l;
        this.metricManager.updateStats(topicPartition, new DurabilityStats(totalMsg, l2));
    }

    public long reportDurabilityAudit$default$4() {
        return 0L;
    }

    public void updateHealthCheck(String brokerSrc, long timeStamp) {
        this.metricManager.updateHealthCheck(brokerSrc, timeStamp);
    }

    public Instant startAuditJob() {
        return this.metricManager.startAuditJob();
    }

    public Instant startAuditCompactionJob() {
        return this.metricManager.startAuditCompactionJob();
    }

    public void addTierAuditErrors(long count) {
        this.metricManager.addTierAuditError(count);
    }

    public void addTierAuditUnknownExceptions(long count) {
        this.metricManager.addTierAuditUnknownExceptions(count);
    }

    public void addTierAuditRetryExceptions(long count) {
        this.metricManager.addTierAuditRetryExceptions(count);
    }

    public void addCompactedPartitionSkipped(long count) {
        this.metricManager.addCompactedPartitionSkipped(count);
    }

    public void addCompactedPartitionIdle(long count) {
        this.metricManager.addCompactedPartitionIdle(count);
    }

    public void addCompactedPartitionAudited(long count) {
        this.metricManager.addCompactedPartitionAudited(count);
    }

    public void updateAuditDbSize(long size) {
        this.metricManager.updateDurabilityAuditDbSize(size);
    }

    public void resetAuditMetrics() {
        this.metricManager.resetAuditMetrics();
    }

    public Tuple2<Object, Object> getDurabilityCounters(TopicPartition id) {
        return (Tuple2)this.scoringMap().getOrElse((Object)id, (Function0 & Serializable)() -> new Tuple2.mcJJ.sp(0L, 0L));
    }

    public int resetJob(int newJobId) {
        int old = this.jobId();
        this.jobId_$eq(newJobId);
        this.metricManager.resetDurabilityRunSpan(newJobId);
        this.scoringMap().clear();
        return old;
    }

    public static final /* synthetic */ String $anonfun$reportDurabilityLapse$1(String lapseMsg$1) {
        return lapseMsg$1;
    }

    public static final /* synthetic */ String $anonfun$reportDurabilityLapse$2(String lapseMsg$1) {
        return lapseMsg$1;
    }

    public static final /* synthetic */ String $anonfun$reportDurabilityLapse$3(String lapseMsg$1) {
        return lapseMsg$1;
    }

    public static final /* synthetic */ String $anonfun$reportDurabilityLapse$4(String lapseMsg$1) {
        return new StringBuilder(10).append("Duplicate ").append(lapseMsg$1).toString();
    }

    public AuditReporter(DurabilityMetricsManager metricManager) {
        this.metricManager = metricManager;
        this.jobId = -1;
        this.scoringMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.segmentOffsetMap = new SegmentOffsetMap();
    }
}

