/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.db.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kafka.durability.db.serdes.AuditRunInfo;
import kafka.durability.db.serdes.EpochChain;

public final class PartitionInfo
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_2_0_0();
    }

    public static PartitionInfo getRootAsPartitionInfo(ByteBuffer _bb) {
        return PartitionInfo.getRootAsPartitionInfo(_bb, new PartitionInfo());
    }

    public static PartitionInfo getRootAsPartitionInfo(ByteBuffer _bb, PartitionInfo obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public PartitionInfo __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public int partition() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public long startOffset() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long highWatermark() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long committedStartOffset() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long externalLostMessages() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long totalMessages() {
        int o = this.__offset(14);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long retentionTime() {
        int o = this.__offset(16);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long retentionSize() {
        int o = this.__offset(18);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public EpochChain epochChain(int j) {
        return this.epochChain(new EpochChain(), j);
    }

    public EpochChain epochChain(EpochChain obj, int j) {
        int o = this.__offset(20);
        return o != 0 ? obj.__assign(this.__vector(o) + j * 16, this.bb) : null;
    }

    public int epochChainLength() {
        int o = this.__offset(20);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public EpochChain.Vector epochChainVector() {
        return this.epochChainVector(new EpochChain.Vector());
    }

    public EpochChain.Vector epochChainVector(EpochChain.Vector obj) {
        int o = this.__offset(20);
        return o != 0 ? obj.__assign(this.__vector(o), 16, this.bb) : null;
    }

    public String topicId() {
        int o = this.__offset(22);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer topicIdAsByteBuffer() {
        return this.__vector_as_bytebuffer(22, 1);
    }

    public ByteBuffer topicIdInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 22, 1);
    }

    public long config() {
        int o = this.__offset(24);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public AuditRunInfo lastAuditRunInfo() {
        return this.lastAuditRunInfo(new AuditRunInfo());
    }

    public AuditRunInfo lastAuditRunInfo(AuditRunInfo obj) {
        int o = this.__offset(26);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public static int createPartitionInfo(FlatBufferBuilder builder, int partition, long start_offset, long high_watermark, long committed_start_offset, long external_lost_messages, long total_messages, long retention_time, long retention_size, int epoch_chainOffset, int topic_idOffset, long config, int last_audit_run_infoOffset) {
        builder.startTable(12);
        PartitionInfo.addConfig(builder, config);
        PartitionInfo.addRetentionSize(builder, retention_size);
        PartitionInfo.addRetentionTime(builder, retention_time);
        PartitionInfo.addTotalMessages(builder, total_messages);
        PartitionInfo.addExternalLostMessages(builder, external_lost_messages);
        PartitionInfo.addCommittedStartOffset(builder, committed_start_offset);
        PartitionInfo.addHighWatermark(builder, high_watermark);
        PartitionInfo.addStartOffset(builder, start_offset);
        PartitionInfo.addLastAuditRunInfo(builder, last_audit_run_infoOffset);
        PartitionInfo.addTopicId(builder, topic_idOffset);
        PartitionInfo.addEpochChain(builder, epoch_chainOffset);
        PartitionInfo.addPartition(builder, partition);
        return PartitionInfo.endPartitionInfo(builder);
    }

    public static void startPartitionInfo(FlatBufferBuilder builder) {
        builder.startTable(12);
    }

    public static void addPartition(FlatBufferBuilder builder, int partition) {
        builder.addInt(0, partition, 0);
    }

    public static void addStartOffset(FlatBufferBuilder builder, long startOffset) {
        builder.addLong(1, startOffset, 0L);
    }

    public static void addHighWatermark(FlatBufferBuilder builder, long highWatermark) {
        builder.addLong(2, highWatermark, 0L);
    }

    public static void addCommittedStartOffset(FlatBufferBuilder builder, long committedStartOffset) {
        builder.addLong(3, committedStartOffset, 0L);
    }

    public static void addExternalLostMessages(FlatBufferBuilder builder, long externalLostMessages) {
        builder.addLong(4, externalLostMessages, 0L);
    }

    public static void addTotalMessages(FlatBufferBuilder builder, long totalMessages) {
        builder.addLong(5, totalMessages, 0L);
    }

    public static void addRetentionTime(FlatBufferBuilder builder, long retentionTime) {
        builder.addLong(6, retentionTime, 0L);
    }

    public static void addRetentionSize(FlatBufferBuilder builder, long retentionSize) {
        builder.addLong(7, retentionSize, 0L);
    }

    public static void addEpochChain(FlatBufferBuilder builder, int epochChainOffset) {
        builder.addOffset(8, epochChainOffset, 0);
    }

    public static void startEpochChainVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(16, numElems, 8);
    }

    public static void addTopicId(FlatBufferBuilder builder, int topicIdOffset) {
        builder.addOffset(9, topicIdOffset, 0);
    }

    public static void addConfig(FlatBufferBuilder builder, long config) {
        builder.addLong(10, config, 0L);
    }

    public static void addLastAuditRunInfo(FlatBufferBuilder builder, int lastAuditRunInfoOffset) {
        builder.addOffset(11, lastAuditRunInfoOffset, 0);
    }

    public static int endPartitionInfo(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public PartitionInfo get(int j) {
            return this.get(new PartitionInfo(), j);
        }

        public PartitionInfo get(PartitionInfo obj, int j) {
            return obj.__assign(PartitionInfo.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

