/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.events;

import com.google.flatbuffers.FlatBufferBuilder;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.durability.events.DeserializerTrait;
import kafka.durability.events.serdes.EventKey;
import kafka.durability.exceptions.DurabilityMetadataDeserializationException;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u000594QAD\b\u0002\u0002YA\u0001\"\t\u0001\u0003\u0006\u0004%\tA\t\u0005\t]\u0001\u0011\t\u0011)A\u0005G!Aq\u0006\u0001BC\u0002\u0013\u0005\u0001\u0007\u0003\u00055\u0001\t\u0005\t\u0015!\u00032\u0011!)\u0004A!b\u0001\n\u0003\u0001\u0004\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u000b]\u0002A\u0011\u0001\u001d\t\u000bu\u0002A\u0011\u0001 \t\u000b\u0015\u0003A\u0011\u0001 \t\u000b\u0019\u0003a\u0011A$\t\u000bA\u0003a\u0011A)\t\u000b\t\u0004A\u0011I2\t\u000b1\u0004A\u0011I7\u0003/\u0005\u00137\u000f\u001e:bGR$UO]1cS2LG/_#wK:$(B\u0001\t\u0012\u0003\u0019)g/\u001a8ug*\u0011!cE\u0001\u000bIV\u0014\u0018MY5mSRL(\"\u0001\u000b\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001aF\u000f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g!\tqr$D\u0001\u0010\u0013\t\u0001sBA\tEKN,'/[1mSj,'\u000f\u0016:bSR\f\u0001\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8\u0016\u0003\r\u0002\"\u0001\n\u0017\u000e\u0003\u0015R!AJ\u0014\u0002\r\r|W.\\8o\u0015\t!\u0002F\u0003\u0002*U\u00051\u0011\r]1dQ\u0016T\u0011aK\u0001\u0004_J<\u0017BA\u0017&\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.A\tu_BL7-\u00133QCJ$\u0018\u000e^5p]\u0002\nQ!\u001a9pG\",\u0012!\r\t\u00031IJ!aM\r\u0003\u0007%sG/\u0001\u0004fa>\u001c\u0007\u000eI\u0001\bm\u0016\u00148/[8o\u0003!1XM]:j_:\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003:umb\u0004C\u0001\u0010\u0001\u0011\u0015\ts\u00011\u0001$\u0011\u0015ys\u00011\u00012\u0011\u0015)t\u00011\u00012\u00031\u0019XM]5bY&TXmS3z+\u0005y\u0004c\u0001\rA\u0005&\u0011\u0011)\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00031\rK!\u0001R\r\u0003\t\tKH/Z\u0001\u000fg\u0016\u0014\u0018.\u00197ju\u00164\u0016\r\\;f\u00035\u0001\u0018-\u001f7pC\u0012\u0014UO\u001a4feV\t\u0001\n\u0005\u0002J\u001d6\t!J\u0003\u0002L\u0019\u0006\u0019a.[8\u000b\u00035\u000bAA[1wC&\u0011qJ\u0013\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018!C3wK:$H+\u001f9f+\u0005\u0011\u0006CA*`\u001d\t!VL\u0004\u0002V9:\u0011ak\u0017\b\u0003/jk\u0011\u0001\u0017\u0006\u00033V\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000b\n\u0005I\u0019\u0012B\u0001\t\u0012\u0013\tqv\"A\nEkJ\f'-\u001b7jif,e/\u001a8u)f\u0004X-\u0003\u0002aC\n\u0019B)\u001e:bE&d\u0017\u000e^=Fm\u0016tG\u000fV=qK*\u0011alD\u0001\u0007KF,\u0018\r\\:\u0015\u0005\u0011<\u0007C\u0001\rf\u0013\t1\u0017DA\u0004C_>dW-\u00198\t\u000b!d\u0001\u0019A5\u0002\u000b=$\b.\u001a:\u0011\u0005aQ\u0017BA6\u001a\u0005\r\te._\u0001\tQ\u0006\u001c\bnQ8eKR\t\u0011\u0007")
public abstract class AbstractDurabilityEvent
implements DeserializerTrait {
    private final TopicIdPartition topicIdPartition;
    private final int epoch;
    private final int version;
    private int KEY_INITIAL_LENGTH;
    private int EVENT_TYPE_LENGTH;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public Enumeration.Value deserializeEventType(byte value) {
        return DeserializerTrait.deserializeEventType$(this, value);
    }

    @Override
    public AbstractDurabilityEvent deserialize(byte[] key, byte[] value) throws DurabilityMetadataDeserializationException {
        return DeserializerTrait.deserialize$(this, key, value);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public int KEY_INITIAL_LENGTH() {
        return this.KEY_INITIAL_LENGTH;
    }

    @Override
    public int EVENT_TYPE_LENGTH() {
        return this.EVENT_TYPE_LENGTH;
    }

    @Override
    public void kafka$durability$events$DeserializerTrait$_setter_$KEY_INITIAL_LENGTH_$eq(int x$1) {
        this.KEY_INITIAL_LENGTH = x$1;
    }

    @Override
    public void kafka$durability$events$DeserializerTrait$_setter_$EVENT_TYPE_LENGTH_$eq(int x$1) {
        this.EVENT_TYPE_LENGTH = x$1;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public int epoch() {
        return this.epoch;
    }

    public int version() {
        return this.version;
    }

    public byte[] serializeKey() {
        FlatBufferBuilder builder = new FlatBufferBuilder(this.KEY_INITIAL_LENGTH()).forceDefaults(true);
        int topicNameOffset = builder.createString((CharSequence)this.topicIdPartition().topicPartition().topic());
        int topicIdOffset = builder.createString((CharSequence)this.topicIdPartition().topicId().toString());
        EventKey.startEventKey(builder);
        EventKey.addTopicName(builder, topicNameOffset);
        EventKey.addPartition(builder, this.topicIdPartition().topicPartition().partition());
        EventKey.addTopicId(builder, topicIdOffset);
        int end = EventKey.endEventKey(builder);
        builder.finish(end);
        ByteBuffer buffer = builder.dataBuffer();
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    public byte[] serializeValue() {
        ByteBuffer payload = this.payloadBuffer();
        ByteBuffer buf = ByteBuffer.allocate(payload.remaining() + this.EVENT_TYPE_LENGTH());
        buf.put((byte)this.eventType().id());
        buf.put(payload);
        return buf.array();
    }

    public abstract ByteBuffer payloadBuffer();

    public abstract Enumeration.Value eventType();

    public boolean equals(Object other) {
        if (other instanceof AbstractDurabilityEvent) {
            AbstractDurabilityEvent abstractDurabilityEvent = (AbstractDurabilityEvent)other;
            TopicIdPartition topicIdPartition = this.topicIdPartition();
            TopicIdPartition topicIdPartition2 = abstractDurabilityEvent.topicIdPartition();
            if (!(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null)) {
                Enumeration.Value value = this.eventType();
                Enumeration.Value value2 = abstractDurabilityEvent.eventType();
                if (!(value != null ? !value.equals(value2) : value2 != null)) {
                    if (Predef$.MODULE$.wrapByteArray(this.payloadBuffer().array()).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(abstractDurabilityEvent.payloadBuffer().array())) && this.epoch() == abstractDurabilityEvent.epoch() && this.version() == abstractDurabilityEvent.version()) {
                        return true;
                    }
                }
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.topicIdPartition().topicPartition(), this.eventType(), this.payloadBuffer(), BoxesRunTime.boxToInteger((int)this.epoch()), BoxesRunTime.boxToInteger((int)this.version())}))).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.hashCode()))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(a, b) -> 31 * a + b));
    }

    public AbstractDurabilityEvent(TopicIdPartition topicIdPartition, int epoch, int version) {
        this.topicIdPartition = topicIdPartition;
        this.epoch = epoch;
        this.version = version;
        DeserializerTrait.$init$(this);
        Statics.releaseFence();
    }
}

