/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.durability.Utils;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.db.PartitionState;
import kafka.durability.events.EpochChangeEvent;
import kafka.durability.events.RetentionType$;
import kafka.durability.events.StartOffsetChangeEvent;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.log.AbstractLog;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0005\t]a\u0001\u0002\u0012$\u0001)B\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005s!A\u0001\t\u0001BC\u0002\u0013\u0005\u0011\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003C\u0011!I\u0005A!A!\u0002\u0013Q\u0005\"\u0002,\u0001\t\u00039\u0006\u0002C/\u0001\u0005\u0004%\t!\n0\t\r\t\u0004\u0001\u0015!\u0003`\u0011\u001d\u0019\u0007A1A\u0005\nyCa\u0001\u001a\u0001!\u0002\u0013y\u0006\u0002C3\u0001\u0005\u0004%\t!\n0\t\r\u0019\u0004\u0001\u0015!\u0003`\u0011\u00159\u0007\u0001\"\u0001i\u0011%\t9\u0003AI\u0001\n\u0003\tI\u0003C\u0005\u0002@\u0001\t\n\u0011\"\u0001\u0002B!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0003\"CA*\u0001E\u0005I\u0011AA\u0015\u0011!\t)\u0006\u0001C\u0001G\u0005]\u0003bBAC\u0001\u0011\u0005\u0011q\u0011\u0005\n\u00033\u0003\u0011\u0013!C\u0001\u0003SAq!a'\u0001\t\u0013\ti\nC\u0004\u0002*\u0002!I!a+\t\u000f\u0005U\u0006\u0001\"\u0001\u00028\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0007bBAi\u0001\u0011\u0005\u00111\u001b\u0005\b\u00033\u0004A\u0011AAn\u0011\u001d\t\u0019\u000f\u0001C\u0005\u0003KDq!a<\u0001\t\u0013\t\t\u0010\u0003\u0005\u0002|\u0002!\taIA\u007f\u000f%\u0011IaIA\u0001\u0012\u0003\u0011YA\u0002\u0005#G\u0005\u0005\t\u0012\u0001B\u0007\u0011\u00191v\u0004\"\u0001\u0003\u0010!I!\u0011C\u0010\u0012\u0002\u0013\u0005!1\u0003\u0002\n-\u0006d\u0017\u000eZ1u_JT!\u0001J\u0013\u0002\u001f5\fG/\u001a:jC2L'0\u0019;j_:T!AJ\u0014\u0002\u0015\u0011,(/\u00192jY&$\u0018PC\u0001)\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u00162!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0019\te.\u001f*fMB\u0011!'N\u0007\u0002g)\u0011AgJ\u0001\u0006kRLGn]\u0005\u0003mM\u0012q\u0001T8hO&tw-\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0003e\u0002\"AO\u001f\u000e\u0003mR!\u0001P\u0014\u0002\rM,'O^3s\u0013\tq4H\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u001fI,\u0007\u000f\\5dC6\u000bg.Y4fe\u0002\n\u0001B]3q_J$XM]\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\u0011Q)J\u0001\u0006CV$\u0017\u000e^\u0005\u0003\u000f\u0012\u0013Q\"Q;eSR\u0014V\r]8si\u0016\u0014\u0018!\u0003:fa>\u0014H/\u001a:!\u0003\u0011!\u0018.\\3\u0011\u0005-#V\"\u0001'\u000b\u0005Qj%B\u0001(P\u0003\u0019\u0019w.\\7p]*\u0011\u0001\u0006\u0015\u0006\u0003#J\u000ba!\u00199bG\",'\"A*\u0002\u0007=\u0014x-\u0003\u0002V\u0019\n!A+[7f\u0003\u0019a\u0014N\\5u}Q!\u0001LW.]!\tI\u0006!D\u0001$\u0011\u00159d\u00011\u0001:\u0011\u0015\u0001e\u00011\u0001C\u0011\u001dIe\u0001%AA\u0002)\u000bADU3uK:$\u0018n\u001c8US6,W*\u0019:hS:|e-\u0012:s_Jl5/F\u0001`!\ta\u0003-\u0003\u0002b[\t\u0019\u0011J\u001c;\u0002;I+G/\u001a8uS>tG+[7f\u001b\u0006\u0014x-\u001b8PM\u0016\u0013(o\u001c:Ng\u0002\n!DU3uK:$\u0018n\u001c8TSj,W*\u0019:hS:|e-\u0012:s_J\f1DU3uK:$\u0018n\u001c8TSj,W*\u0019:hS:|e-\u0012:s_J\u0004\u0013\u0001I'B1~{eIR*F)~;\u0015\tU0U\u001f2+%+\u0011(D\u000b~#\u0016*T#`\u001bN\u000b\u0011%T!Y?>3eiU#U?\u001e\u000b\u0005k\u0018+P\u0019\u0016\u0013\u0016IT\"F?RKU*R0N'\u0002\nqC^1mS\u0012\fG/\u001a#C\u0011&<\u0007nV1uKJl\u0017M]6\u0015\u0013%d'\u000f^=\u0002\u0004\u0005u\u0001C\u0001\u0017k\u0013\tYWF\u0001\u0003V]&$\b\"B7\u000e\u0001\u0004q\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003_Bl\u0011!T\u0005\u0003c6\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0003t\u001b\u0001\u0007q,A\u0003fa>\u001c\u0007\u000eC\u0003v\u001b\u0001\u0007a/A\u0002io6\u0004\"\u0001L<\n\u0005al#\u0001\u0002'p]\u001eDQA_\u0007A\u0002m\fQa\u001d;bi\u0016\u0004\"\u0001`@\u000e\u0003uT!A`\u0013\u0002\u0005\u0011\u0014\u0017bAA\u0001{\nq\u0001+\u0019:uSRLwN\\*uCR,\u0007\"CA\u0003\u001bA\u0005\t\u0019AA\u0004\u0003!iW\r^1eCR\f\u0007\u0003BA\u0005\u0003/qA!a\u0003\u0002\u0014A\u0019\u0011QB\u0017\u000e\u0005\u0005=!bAA\tS\u00051AH]8pizJ1!!\u0006.\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011DA\u000e\u0005\u0019\u0019FO]5oO*\u0019\u0011QC\u0017\t\u0013\u0005}Q\u0002%AA\u0002\u0005\u0005\u0012!D5t\u000bB|7\r[\"iC:<W\rE\u0002-\u0003GI1!!\n.\u0005\u001d\u0011un\u001c7fC:\f\u0011E^1mS\u0012\fG/\u001a#C\u0011&<\u0007nV1uKJl\u0017M]6%I\u00164\u0017-\u001e7uIU*\"!a\u000b+\t\u0005\u001d\u0011QF\u0016\u0003\u0003_\u0001B!!\r\u0002<5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011H\u0017\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002>\u0005M\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\tc/\u00197jI\u0006$X\r\u0012\"IS\u001eDw+\u0019;fe6\f'o\u001b\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u00111\t\u0016\u0005\u0003C\ti#A\rwC2LG-\u0019;f\u0019>\u001c\u0017\r\u001c'pO\u0016sGm\u00144gg\u0016$HcC5\u0002J\u0005-\u0013QJA(\u0003#BQ!\u001c\tA\u00029DQa\u001d\tA\u0002}CQ!\u001e\tA\u0002YDQA\u001f\tA\u0002mD\u0011\"!\u0002\u0011!\u0003\u0005\r!a\u0002\u0002GY\fG.\u001b3bi\u0016dunY1m\u0019><WI\u001c3PM\u001a\u001cX\r\u001e\u0013eK\u001a\fW\u000f\u001c;%k\u0005\tr-\u001a;SKR,g\u000e^5p]Z\u000bG.^3\u0015\u0011\u0005e\u0013qLA1\u0003G\u0002B\u0001LA.m&\u0019\u0011QL\u0017\u0003\r=\u0003H/[8o\u0011\u0015i'\u00031\u0001o\u0011\u0015Q(\u00031\u0001|\u0011\u001d\t)G\u0005a\u0001\u0003O\nQB]3uK:$\u0018n\u001c8UsB,\u0007\u0003BA5\u0003\u007frA!a\u001b\u0002z9!\u0011QNA;\u001d\u0011\ty'a\u001d\u000f\t\u00055\u0011\u0011O\u0005\u0002Q%\u0011aeJ\u0005\u0004\u0003o*\u0013AB3wK:$8/\u0003\u0003\u0002|\u0005u\u0014!\u0004*fi\u0016tG/[8o)f\u0004XMC\u0002\u0002x\u0015JA!!!\u0002\u0004\ni!+\u001a;f]RLwN\u001c+za\u0016TA!a\u001f\u0002~\u0005Ab/\u00197jI\u0006$X\r\u0012\"M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0015\u0011\u0005\u0005\u0012\u0011RAK\u0003/Cq!a#\u0014\u0001\u0004\ti)A\u0003fm\u0016tG\u000f\u0005\u0003\u0002\u0010\u0006EUBAA?\u0013\u0011\t\u0019*! \u0003-M#\u0018M\u001d;PM\u001a\u001cX\r^\"iC:<W-\u0012<f]RDQA_\nA\u0002mD\u0011\"!\u0002\u0014!\u0003\u0005\r!a\u0002\u0002EY\fG.\u001b3bi\u0016$%\tT8h'R\f'\u000f^(gMN,G\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003Q\u0019\u0018N_3MCB\u001cXmQ1mGVd\u0017\r^5p]RQ\u0011\u0011EAP\u0003C\u000b\u0019+a*\t\u000f\u0005-U\u00031\u0001\u0002\u000e\")!0\u0006a\u0001w\"1\u0011QU\u000bA\u0002Y\faB]3uK:$\u0018n\u001c8WC2,X\rC\u0004\u0002\u0006U\u0001\r!a\u0002\u0002)QLW.\u001a'baN,7)\u00197dk2\fG/[8o))\t\t#!,\u00020\u0006E\u00161\u0017\u0005\b\u0003\u00173\u0002\u0019AAG\u0011\u0015Qh\u00031\u0001|\u0011\u0019\t)K\u0006a\u0001m\"9\u0011Q\u0001\fA\u0002\u0005\u001d\u0011a\u0007<bY&$\u0017\r^3M_\u000e\fG\u000eT8h'R\f'\u000f^(gMN,G\u000fF\u0004j\u0003s\u000bY,a0\t\u000b5<\u0002\u0019\u00018\t\r\u0005uv\u00031\u0001w\u00031aW-\u00193fe>3gm]3u\u0011\u001d\t)a\u0006a\u0001\u0003\u000f\tQC^1mS\u0012\fG/\u001a#C\u000bB|7\r[\"iC:<W\rF\u0004j\u0003\u000b\fi-a4\t\u000f\u0005-\u0005\u00041\u0001\u0002HB!\u0011qRAe\u0013\u0011\tY-! \u0003!\u0015\u0003xn\u00195DQ\u0006tw-Z#wK:$\b\"\u0002>\u0019\u0001\u0004Y\bbBA\u00031\u0001\u0007\u0011qA\u0001\u001dm\u0006d\u0017\u000eZ1uK\u0016\u0003xn\u00195DQ\u0006tw-Z,ji\"dunY1m)\u0015I\u0017Q[Al\u0011\u001d\tY)\u0007a\u0001\u0003\u000fDq!!\u0002\u001a\u0001\u0004\t9!A\u000ewC2LG-\u0019;f\u000bB|7\r[\"iC&tw+\u001b;i\u0019>\u001c\u0017\r\u001c\u000b\bS\u0006u\u0017q\\Aq\u0011\u0015i'\u00041\u0001o\u0011\u0015Q(\u00041\u0001|\u0011\u001d\t)A\u0007a\u0001\u0003\u000f\tQe^5uQ&tW*\u0019:hS:|e-\u0012:s_J4uN\u001d+j[\u0016l5OU3uK:$\u0018n\u001c8\u0015\r\u0005\u0005\u0012q]Av\u0011\u0019\tIo\u0007a\u0001m\u00061A/[7f\u001bNDa!!<\u001c\u0001\u00041\u0018a\u0003:fi\u0016tG/[8o\u001bN\f1e^5uQ&tW*\u0019:hS:|e-\u0012:s_J4uN]*ju\u0016\u0014V\r^3oi&|g\u000e\u0006\u0004\u0002\"\u0005M\u0018q\u001f\u0005\u0007\u0003kd\u0002\u0019\u0001<\u0002\tML'0\u001a\u0005\u0007\u0003sd\u0002\u0019\u0001<\u0002\u001bI,G/\u001a8uS>t7+\u001b>f\u0003!I7/\u00138Ts:\u001cG\u0003BA\u0011\u0003\u007fDqA!\u0001\u001e\u0001\u0004\u0011\u0019!A\u0002jgJ\u0004R!!\u0003\u0003\u0006}KAAa\u0002\u0002\u001c\t\u00191+\u001a;\u0002\u0013Y\u000bG.\u001b3bi>\u0014\bCA- '\ty2\u0006\u0006\u0002\u0003\f\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"A!\u0006+\u0007)\u000bi\u0003")
public class Validator
implements Logging {
    private final ReplicaManager replicaManager;
    private final AuditReporter reporter;
    private final Time time;
    private final int RetentionTimeMarginOfErrorMs;
    private final int RetentionSizeMarginOfError;
    private final int MAX_OFFSET_GAP_TOLERANCE_TIME_MS;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$3() {
        return Time.SYSTEM;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public AuditReporter reporter() {
        return this.reporter;
    }

    public int RetentionTimeMarginOfErrorMs() {
        return this.RetentionTimeMarginOfErrorMs;
    }

    private int RetentionSizeMarginOfError() {
        return this.RetentionSizeMarginOfError;
    }

    public int MAX_OFFSET_GAP_TOLERANCE_TIME_MS() {
        return this.MAX_OFFSET_GAP_TOLERANCE_TIME_MS;
    }

    public void validateDBHighWatermark(TopicPartition topicPartition, int epoch, long hwm, PartitionState state, String metadata, boolean isEpochChange) {
        if (isEpochChange) {
            return;
        }
        if (hwm < state.highWatermark()) {
            String msg = new StringBuilder(175).append("durability lapse on validation with hwm stored in database, hwm decreased from a previous committed value.\n").append("new hwm: ").append(hwm).append(", db hwm: ").append(state.highWatermark()).append(", event epoch: ").append(epoch).append("\n").append("partition: ").append(topicPartition).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
            this.reporter().reportDurabilityLapse(topicPartition, hwm, state.highWatermark() - hwm, DurabilityLapseType$.MODULE$.HighWatermark(), msg, true);
            return;
        }
    }

    public String validateDBHighWatermark$default$5() {
        return "";
    }

    public boolean validateDBHighWatermark$default$6() {
        return false;
    }

    public void validateLocalLogEndOffset(TopicPartition topicPartition, int epoch, long hwm, PartitionState state, String metadata) {
        Option<Object> option = Utils$.MODULE$.getLogEndOffset(this.replicaManager(), topicPartition);
        if (option instanceof Some) {
            long localEndOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            if (localEndOffset < hwm) {
                String msg = new StringBuilder(200).append("durability lapse on validation with local log end offset, log end offset is found to be less than hwm.\n").append("local end offset: ").append(localEndOffset).append(", hwm: ").append(hwm).append(", event epoch: ").append(epoch).append(", local replica epoch: ").append(state.latestLocalEpoch()).append("\n").append("partition: ").append(topicPartition).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
                this.reporter().reportDurabilityLapse(topicPartition, localEndOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false);
                return;
            }
            return;
        }
    }

    public String validateLocalLogEndOffset$default$5() {
        return "";
    }

    public Option<Object> getRetentionValue(TopicPartition topicPartition, PartitionState state, Enumeration.Value retentionType) {
        Enumeration.Value value = RetentionType$.MODULE$.TimeBasedRetention();
        if (!(value != null ? !value.equals(retentionType) : retentionType != null)) {
            if (state.retentionMs() != -1L) {
                return new Some((Object)BoxesRunTime.boxToLong((long)state.retentionMs()));
            }
            return Utils$.MODULE$.getLocalLogRetentionMs(this.replicaManager(), topicPartition);
        }
        Enumeration.Value value2 = RetentionType$.MODULE$.SizeBasedRetention();
        if (!(value2 != null ? !value2.equals(retentionType) : retentionType != null)) {
            if (state.retentionSz() != -1L) {
                return new Some((Object)BoxesRunTime.boxToLong((long)state.retentionSz()));
            }
            return Utils$.MODULE$.getLocalLogRetentionSize(this.replicaManager(), topicPartition);
        }
        return None$.MODULE$;
    }

    public boolean validateDBLogStartOffset(StartOffsetChangeEvent event, PartitionState state, String metadata) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Validating db log startOffset ").append(event).append(" ").append(state).toString());
        Enumeration.Value value = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value2 = RetentionType$.MODULE$.SizeBasedRetention();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            return this.sizeLapseCalculation(event, state, event.retentionValue(), metadata);
        }
        Enumeration.Value value3 = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value4 = RetentionType$.MODULE$.TimeBasedRetention();
        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
            return this.timeLapseCalculation(event, state, event.retentionValue(), metadata);
        }
        Enumeration.Value value5 = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value6 = RetentionType$.MODULE$.Other();
        if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
            Option<Object> option = this.getRetentionValue(event.topicIdPartition().topicPartition(), state, RetentionType$.MODULE$.TimeBasedRetention());
            Option<Object> option2 = this.getRetentionValue(event.topicIdPartition().topicPartition(), state, RetentionType$.MODULE$.SizeBasedRetention());
            if (option2 instanceof Some) {
                long retentionSz = BoxesRunTime.unboxToLong((Object)((Some)option2).value());
                if (option instanceof Some) {
                    long retentionMs = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Validating for db log start offset lapse for ").append(event).append(" ").append(state).append(" with retentions (").append(retentionSz).append(", ").append(retentionMs).append(")").toString());
                    Option<Object> estimatedSize = Utils$.MODULE$.getEstimatedLogRangeSize(this.replicaManager(), event.topicIdPartition().topicPartition(), event.logStartOffset());
                    Option<Utils.MaxTimestampWithSize> prevSegInfo = Utils$.MODULE$.getPreviousTierSegmentInfo(this.replicaManager(), event.topicIdPartition().topicPartition(), event.logStartOffset());
                    if (estimatedSize instanceof Some) {
                        long estimatedSize2 = BoxesRunTime.unboxToLong((Object)((Some)estimatedSize).value());
                        if (prevSegInfo instanceof Some) {
                            Utils.MaxTimestampWithSize prevSegInfo2 = (Utils.MaxTimestampWithSize)((Some)prevSegInfo).value();
                            if (!this.withinMarginOfErrorForSizeRetention(estimatedSize2, retentionSz) && !this.withinMarginOfErrorForTimeMsRetention(prevSegInfo2.maxTimestamp(), retentionMs)) {
                                String msg = new StringBuilder(397).append("durability lapse on validation with db log start offset, the start offset is more than expected retention window.\n").append("Time based lapse info - maxTimestamp in previous deleted segment: ").append(prevSegInfo2.maxTimestamp()).append(", retentionMs: ").append(retentionMs).append(", current time: ").append(this.time.milliseconds()).append(", RetentionTimeMarginOfErrorMs: ").append(this.RetentionTimeMarginOfErrorMs()).append("\n").append("Size based lapse info - estimatedSize including previous segment: ").append(estimatedSize2).append(", retentionSz: ").append(retentionSz).append(", RetentionSizeMarginOfError: ").append(this.RetentionSizeMarginOfError()).append("\n").append("partition: ").append(event.topicIdPartition()).append("\n").append("event: ").append(event).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
                                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(13).append("Lapse with ").append(estimatedSize2).append(" ").append(prevSegInfo2).append(" ").append(msg).toString());
                                if (state.retentionMs() == -1L && state.retentionSz() == -1L && (state.lapseWatchStartTime() == 0L || this.time.milliseconds() - state.lapseWatchStartTime() < (long)this.MAX_OFFSET_GAP_TOLERANCE_TIME_MS())) {
                                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Postponing start offset lapse with details: ").append(msg).toString());
                                    if (state.lapseWatchStartTime() == 0L) {
                                        state.lapseWatchStartTime_$eq(this.time.milliseconds());
                                    }
                                    return false;
                                }
                                this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), state.startOffset(), Math.max(event.logStartOffset() - state.startOffset(), 1L), DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false);
                                return true;
                            }
                            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Validation against db log start offset went fine  ").append(estimatedSize2).append(", ").append(prevSegInfo2).toString());
                            return true;
                        }
                    }
                    return true;
                }
            }
            return true;
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("validateDBLogStartOffset exits as not able to fetch comparing value ").append(event).append(" ").append(state).toString());
        return true;
    }

    public String validateDBLogStartOffset$default$3() {
        return "";
    }

    private boolean sizeLapseCalculation(StartOffsetChangeEvent event, PartitionState state, long retentionValue, String metadata) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("sizeLapseCalculation ").append(event).append(" ").append(state).append(" ").append(retentionValue).toString());
        Option<Object> option = Utils$.MODULE$.getEstimatedLogRangeSize(this.replicaManager(), event.topicIdPartition().topicPartition(), event.logStartOffset());
        if (option instanceof Some) {
            long estimatedSize = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            if (!this.withinMarginOfErrorForSizeRetention(estimatedSize, retentionValue)) {
                String msg = new StringBuilder(289).append("durability lapse on validation with db log start offset based on size, the start offset is more than expected retention window size.\n").append("Size based lapse info - estimatedSize including previous segment: ").append(estimatedSize).append(", retentionValue: ").append(retentionValue).append(", RetentionSizeMarginOfError: ").append(this.RetentionSizeMarginOfError()).append("\n").append("partition: ").append(event.topicIdPartition()).append("\n").append("event: ").append(event).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
                this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), state.startOffset(), Math.max(event.logStartOffset() - state.startOffset(), 1L), DurabilityLapseType$.MODULE$.StartOffset(), msg, true);
                return true;
            }
            return true;
        }
        return true;
    }

    private boolean timeLapseCalculation(StartOffsetChangeEvent event, PartitionState state, long retentionValue, String metadata) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("timeLapseCalculation ").append(event).append(" ").append(state).append(" ").append(retentionValue).toString());
        Option<Utils.MaxTimestampWithSize> option = Utils$.MODULE$.getPreviousTierSegmentInfo(this.replicaManager(), event.topicIdPartition().topicPartition(), event.logStartOffset());
        if (option instanceof Some) {
            Utils.MaxTimestampWithSize prevMs = (Utils.MaxTimestampWithSize)((Some)option).value();
            if (!this.withinMarginOfErrorForTimeMsRetention(prevMs.maxTimestamp(), retentionValue)) {
                String msg = new StringBuilder(307).append("durability lapse on validation with db log start offset based on size, the start offset is more than expected retention window time.\n").append("Time based lapse info - maxTimestamp in previous deleted segment: ").append(prevMs.maxTimestamp()).append(", retentionValue: ").append(retentionValue).append(", current time: ").append(this.time.milliseconds()).append(", RetentionTimeMarginOfErrorMs: ").append(this.RetentionTimeMarginOfErrorMs()).append("\n").append("partition: ").append(event.topicIdPartition()).append("\n").append("event: ").append(event).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
                this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), state.startOffset(), Math.max(event.logStartOffset() - state.startOffset(), 1L), DurabilityLapseType$.MODULE$.StartOffset(), msg, true);
                return true;
            }
            return true;
        }
        return true;
    }

    public void validateLocalLogStartOffset(TopicPartition topicPartition, long leaderOffset, String metadata) {
        AbstractLog log;
        Option<AbstractLog> option = this.replicaManager().logManager().getLog(topicPartition, this.replicaManager().logManager().getLog$default$2());
        if (option instanceof Some && (log = (AbstractLog)((Some)option).value()) != null && log.logStartOffset() > leaderOffset) {
            Utils.MaxTimestampWithSize prevSegmentState;
            Option<Utils.MaxTimestampWithSize> option2 = Utils$.MODULE$.getPreviousTierSegmentInfo(this.replicaManager(), topicPartition, log.logStartOffset());
            if (option2 instanceof Some && !this.withinMarginOfErrorForTimeMsRetention((prevSegmentState = (Utils.MaxTimestampWithSize)((Some)option2).value()).maxTimestamp(), Predef$.MODULE$.Long2long(log.config().retentionMs())) && !this.withinMarginOfErrorForSizeRetention(log.size() + prevSegmentState.size(), Predef$.MODULE$.Long2long(log.config().retentionSize()))) {
                String msg = new StringBuilder(241).append("durability lapse on validation with local log start offset.\n").append("Time based lapse info - maxTimestamp in previous deleted segment: ").append(prevSegmentState.maxTimestamp()).append(", retentionMs: ").append(log.config().retentionMs()).append("\n").append("Size based lapse info - prevSegmentSize: ").append(prevSegmentState.size()).append(", logSize: ").append(log.size()).append(", retentionSz: ").append(log.config().retentionSize()).append("\n").append("broker: ").append(Utils$.MODULE$.getBrokerId(this.replicaManager())).append("\n").append("partition: ").append(topicPartition).append("\n").append("metadata: ").append(metadata).toString();
                this.reporter().reportDurabilityLapse(topicPartition, log.logStartOffset(), Math.max(log.logStartOffset() - leaderOffset, 1L), DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false);
                return;
            }
            return;
        }
    }

    public void validateDBEpochChange(EpochChangeEvent event, PartitionState state, String metadata) {
        if (event.firstOffset() < state.highWatermark() || event.epoch() < state.latestEpoch()) {
            String msg = new StringBuilder(208).append("durability lapse on epoch change event with db, first offset for new epoch is less than previous recorded db state hwm").append("event first offset: ").append(event.firstOffset()).append(", new epoch: ").append(event.epoch()).append("\n").append("db state hwm: ").append(state.highWatermark()).append("\n").append("partition: ").append(event.topicIdPartition()).append("\n").append("event: ").append(event).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
            this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), event.firstOffset(), Math.max(state.highWatermark() - event.firstOffset(), 1L), DurabilityLapseType$.MODULE$.EpochChange(), msg, true);
            return;
        }
    }

    public void validateEpochChangeWithLocal(EpochChangeEvent event, String metadata) {
        if (!this.isInSync(event.isr())) {
            return;
        }
        Option<Object> option = Utils$.MODULE$.getLogEndOffset(this.replicaManager(), event.topicIdPartition().topicPartition());
        Option<Object> option2 = Utils$.MODULE$.getLatestEpoch(this.replicaManager(), event.topicIdPartition().topicPartition());
        if (option2 instanceof Some) {
            int epoch = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
            if (option instanceof Some) {
                long localEndOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                if (epoch >= event.epoch() && localEndOffset < event.firstOffset()) {
                    String msg = new StringBuilder(218).append("durability lapse on validation of epoch change with local, local end offset is less than first offset of new event\n.").append("in-sync partition ").append(event.topicIdPartition()).append("\n").append("local end offset: ").append(localEndOffset).append(", local epoch ").append(epoch).append("\n").append("first offset: ").append(event.firstOffset()).append(" of the new epoch\n").append("event: ").append(event).append("\n").append("metadata: ").append(metadata).toString();
                    this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), localEndOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false);
                } else if (localEndOffset < event.highWatermark()) {
                    String msg = new StringBuilder(182).append("durability lapse on validation of epoch change with local, local end offset is less than hwm of new event\n.").append("in-sync partition: ").append(event.topicIdPartition()).append("\n").append("local end offset ").append(localEndOffset).append(",local epoch ").append(epoch).append("\n").append("hwm: ").append(event.highWatermark()).append("\n").append("event: ").append(event).append("\n").append("metadata: ").append(metadata).toString();
                    this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), localEndOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false);
                }
            }
        }
        if (Utils$.MODULE$.isCompacted(this.replicaManager(), event.topicIdPartition().topicPartition())) {
            return;
        }
        Option<Object> localOffset = Utils$.MODULE$.getLocalStartOffsetForEpoch(this.replicaManager(), event.topicIdPartition().topicPartition(), event.epoch());
        Option<AbstractLog> log = this.replicaManager().logManager().getLog(event.topicIdPartition().topicPartition(), this.replicaManager().logManager().getLog$default$2());
        if (localOffset instanceof Some) {
            long firstOffset = BoxesRunTime.unboxToLong((Object)((Some)localOffset).value());
            if (log instanceof Some) {
                AbstractLog localLog = (AbstractLog)((Some)log).value();
                if (firstOffset != -1L) {
                    if (firstOffset != event.firstOffset() && (firstOffset < event.firstOffset() || firstOffset > localLog.logStartOffset())) {
                        String msg = new StringBuilder(195).append("durability lapse on validation of epoch change with local, local first offset is not equal to first offset of new event\n.").append("in-sync partition: ").append(event.topicIdPartition()).append("\n").append("local first offset: ").append(localOffset).append("\n").append("first offset: ").append(event.firstOffset()).append("\n").append("event: ").append(event).append("\n").append("metadata: ").append(metadata).toString();
                        this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), firstOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false);
                        return;
                    }
                    return;
                }
            }
        }
    }

    public void validateEpochChainWithLocal(TopicPartition topicPartition, PartitionState state, String metadata) {
        Object object = new Object();
        try {
            if (Utils$.MODULE$.isCompacted(this.replicaManager(), topicPartition)) {
                return;
            }
            LongRef prevLocalEpochFirstOffset = LongRef.create((long)-1L);
            IntRef prevEpoch = IntRef.create((int)-1);
            ((List)state.epochChain().toList().sortWith((Function2 & Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)Validator.$anonfun$validateEpochChainWithLocal$1(x, y)))).foreach((Function1 & Serializable)x0$1 -> {
                Validator.$anonfun$validateEpochChainWithLocal$2(this, topicPartition, prevLocalEpochFirstOffset, prevEpoch, state, metadata, object, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    private boolean withinMarginOfErrorForTimeMsRetention(long timeMs, long retentionMs) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("validating ").append(timeMs).append(" against ").append(retentionMs).toString());
        if (timeMs == -1L) {
            return true;
        }
        if (retentionMs == -1L) {
            return false;
        }
        long diff = this.time.milliseconds() - timeMs;
        return retentionMs - diff <= (long)this.RetentionTimeMarginOfErrorMs();
    }

    private boolean withinMarginOfErrorForSizeRetention(long size, long retentionSize) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("Validating ").append(size).append(" against ").append(retentionSize).toString());
        if (size == -1L) {
            return true;
        }
        if (retentionSize == -1L) {
            return false;
        }
        return retentionSize - size <= (long)this.RetentionSizeMarginOfError();
    }

    public boolean isInSync(Set<Object> isr) {
        return isr.contains((Object)BoxesRunTime.boxToInteger((int)Utils$.MODULE$.getBrokerId(this.replicaManager())));
    }

    public static final /* synthetic */ boolean $anonfun$validateEpochChainWithLocal$1(Tuple2 x, Tuple2 y) {
        return x._1$mcI$sp() < y._1$mcI$sp();
    }

    public static final /* synthetic */ void $anonfun$validateEpochChainWithLocal$2(Validator $this, TopicPartition topicPartition$1, LongRef prevLocalEpochFirstOffset$1, IntRef prevEpoch$1, PartitionState state$4, String metadata$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            long localEpochFirstOffset;
            int dbEpoch = x0$1._1$mcI$sp();
            long dbEpochFirstOffset = x0$1._2$mcJ$sp();
            Option<Object> option = Utils$.MODULE$.getLocalStartOffsetForEpoch($this.replicaManager(), topicPartition$1, dbEpoch);
            if (option instanceof Some && (localEpochFirstOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value())) != -1L) {
                AbstractLog log;
                Option<AbstractLog> option2;
                if (dbEpochFirstOffset < prevLocalEpochFirstOffset$1.elem) {
                    String msg = new StringBuilder(218).append("durability lapse on epoch chain validation with db, local first offset is greater than or equal to next epoch's first offset\n").append("partition ").append(topicPartition$1).append("\n").append("prevEpoch: ").append(prevEpoch$1.elem).append(", prevLocalFirstOffset: ").append(prevLocalEpochFirstOffset$1.elem).append("\n").append("dbEpoch: ").append(dbEpoch).append(", db first offset ").append(dbEpochFirstOffset).append("\n").append("state: ").append(state$4).append("\n").append("metadata: ").append(metadata$1).toString();
                    $this.reporter().reportDurabilityLapse(topicPartition$1, dbEpochFirstOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false);
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                if (localEpochFirstOffset != dbEpochFirstOffset && (option2 = $this.replicaManager().logManager().getLog(topicPartition$1, $this.replicaManager().logManager().getLog$default$2())) instanceof Some && ((log = (AbstractLog)((Some)option2).value()).logStartOffset() < localEpochFirstOffset || dbEpochFirstOffset > localEpochFirstOffset)) {
                    String msg = new StringBuilder(199).append("durability lapse on epoch chain validation, db first offset is greater than local first offset\n").append("partition: ").append(topicPartition$1).append("\n").append("dbEpoch: ").append(dbEpoch).append(", the local first offset: ").append(localEpochFirstOffset).append("\n").append("db first offset: ").append(dbEpochFirstOffset).append(", log start offset: ").append(log.logStartOffset()).append("\n").append("state: ").append(state$4).append("\n").append("metadata: ").append(metadata$1).toString();
                    $this.reporter().reportDurabilityLapse(topicPartition$1, dbEpochFirstOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false);
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                prevLocalEpochFirstOffset$1.elem = localEpochFirstOffset;
                prevEpoch$1.elem = dbEpoch;
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public Validator(ReplicaManager replicaManager, AuditReporter reporter, Time time) {
        this.replicaManager = replicaManager;
        this.reporter = reporter;
        this.time = time;
        this.RetentionTimeMarginOfErrorMs = 3600000;
        this.RetentionSizeMarginOfError = 0x100000;
        this.MAX_OFFSET_GAP_TOLERANCE_TIME_MS = 900000;
    }
}

