/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.tools;

import java.io.File;
import kafka.durability.tools.DumpDB$;
import kafka.tier.tools.RecoveryUtils;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;

public class DumpDurabilityDb {
    public static final String INPUT_PATH_CONFIG = "path";
    public static final String INPUT_PATH_DOC = "The path to durability db data, e.g., /mnt/data/data0/logs/";
    public static final String TOPIC_CONFIG = "topic";
    public static final String TOPIC_DOC = "The topic for which TopicState is requested, e.g., test";
    public static final String PARTITION_CONFIG = "partition";
    public static final String PARTITION_DOC = "The partition for which TopicState is requested, e.g., 1";

    public static void main(String[] args) throws ArgumentParserException {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)DumpDurabilityDb.class.getName()).defaultHelp(true).description("Utility to dump partition state for each partition in the durability database");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(INPUT_PATH_CONFIG)}).dest(INPUT_PATH_CONFIG).type(String.class).required(true).help(INPUT_PATH_DOC);
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(TOPIC_CONFIG)}).dest(TOPIC_CONFIG).type(String.class).help(TOPIC_DOC);
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(PARTITION_CONFIG)}).dest(PARTITION_CONFIG).type(String.class).help(PARTITION_DOC);
        Namespace np = parser.parseArgs(args);
        String inputPath = np.getString(INPUT_PATH_CONFIG);
        File path = new File(inputPath);
        String topic = np.getString(TOPIC_CONFIG);
        String partition = np.getString(PARTITION_CONFIG);
        DumpDB$.MODULE$.dump(path, topic, partition);
    }
}

