/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.topic;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Duration;
import java.util.function.Supplier;
import kafka.durability.db.DurabilityDB;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.materialization.DurabilityEventsMaterialize;
import kafka.durability.topic.DurabilityTopicConfig;
import kafka.durability.topic.DurabilityTopicConsumer;
import kafka.durability.topic.DurabilityTopicProducer;
import kafka.server.InternalAdmin;
import kafka.utils.Logging;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005mf\u0001\u0002\u0013&\u00011B\u0001\"\u000f\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005w!A\u0001\t\u0001BC\u0002\u0013\u0005\u0011\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003C\u0011!I\u0005A!b\u0001\n\u0003Q\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u0011I\u0003!Q1A\u0005\u0002MC\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\tK\u0002\u0011\t\u0011)A\u0005M\")!\u000f\u0001C\u0001g\"9!\u0010\u0001b\u0001\n\u0013Y\bBB@\u0001A\u0003%A\u0010C\u0006\u0002\u0002\u0001A)\u0019!C\u0001K\u0005\r\u0001bCA\u0006\u0001!\u0015\r\u0011\"\u0001&\u0003\u001bA\u0011\"!\u0006\u0001\u0001\u0004%\t!a\u0006\t\u0013\u0005}\u0001\u00011A\u0005\u0002\u0005\u0005\u0002\u0002CA\u0017\u0001\u0001\u0006K!!\u0007\t\u0013\u0005]\u0002\u00011A\u0005\u0002\u0005]\u0001\"CA\u001d\u0001\u0001\u0007I\u0011AA\u001e\u0011!\ty\u0004\u0001Q!\n\u0005e\u0001\"CA\"\u0001\t\u0007I\u0011AA#\u0011!\t\u0019\u0007\u0001Q\u0001\n\u0005\u001d\u0003bBA3\u0001\u0011\u0005\u0011q\r\u0005\b\u0003S\u0002A\u0011AA6\u0011\u001d\ti\u0007\u0001C\u0005\u0003WBq!a\u001c\u0001\t\u0003\t9\u0007C\u0004\u0002r\u0001!I!a\u001a\t\u000f\u0005M\u0004\u0001\"\u0003\u0002h!9\u0011Q\u000f\u0001\u0005\n\u0005]\u0004bBA?\u0001\u0011%\u0011q\u0010\u0005\b\u0003'\u0003A\u0011AAK\u000f%\tY*JA\u0001\u0012\u0003\tiJ\u0002\u0005%K\u0005\u0005\t\u0012AAP\u0011\u0019\u0011\u0018\u0005\"\u0001\u0002\"\"I\u00111U\u0011\u0012\u0002\u0013\u0005\u0011Q\u0015\u0002\u0017\tV\u0014\u0018MY5mSRLHk\u001c9jG6\u000bg.Y4fe*\u0011aeJ\u0001\u0006i>\u0004\u0018n\u0019\u0006\u0003Q%\n!\u0002Z;sC\nLG.\u001b;z\u0015\u0005Q\u0013!B6bM.\f7\u0001A\n\u0004\u00015\u001a\u0004C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#AB!osJ+g\r\u0005\u00025o5\tQG\u0003\u00027S\u0005)Q\u000f^5mg&\u0011\u0001(\u000e\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jOV\t1\b\u0005\u0002={5\tQ%\u0003\u0002?K\t)B)\u001e:bE&d\u0017\u000e^=U_BL7mQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\tI\u0006$\u0018MY1tKV\t!\t\u0005\u0002D\r6\tAI\u0003\u0002FO\u0005\u0011AMY\u0005\u0003\u000f\u0012\u0013A\u0002R;sC\nLG.\u001b;z\t\n\u000b\u0011\u0002Z1uC\n\f7/\u001a\u0011\u0002\u00175\fG/\u001a:jC2L'0Z\u000b\u0002\u0017B\u0011AjT\u0007\u0002\u001b*\u0011ajJ\u0001\u0010[\u0006$XM]5bY&T\u0018\r^5p]&\u0011\u0001+\u0014\u0002\u001c\tV\u0014\u0018MY5mSRLXI^3oiNl\u0015\r^3sS\u0006d\u0017N_3\u0002\u00195\fG/\u001a:jC2L'0\u001a\u0011\u0002+%tG/\u001a:oC2\fE-\\5o'V\u0004\b\u000f\\5feV\tA\u000bE\u0002V9zk\u0011A\u0016\u0006\u0003/b\u000b\u0001BZ;oGRLwN\u001c\u0006\u00033j\u000bA!\u001e;jY*\t1,\u0001\u0003kCZ\f\u0017BA/W\u0005!\u0019V\u000f\u001d9mS\u0016\u0014\bCA0c\u001b\u0005\u0001'BA1*\u0003\u0019\u0019XM\u001d<fe&\u00111\r\u0019\u0002\u000e\u0013:$XM\u001d8bY\u0006#W.\u001b8\u0002-%tG/\u001a:oC2\fE-\\5o'V\u0004\b\u000f\\5fe\u0002\nA\u0001^5nKB\u0011q\r]\u0007\u0002Q*\u0011a'\u001b\u0006\u0003U.\faaY8n[>t'B\u0001\u0016m\u0015\tig.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002_\u0006\u0019qN]4\n\u0005ED'\u0001\u0002+j[\u0016\fa\u0001P5oSRtDC\u0002;vm^D\u0018\u0010\u0005\u0002=\u0001!)\u0011H\u0003a\u0001w!)\u0001I\u0003a\u0001\u0005\")\u0011J\u0003a\u0001\u0017\")!K\u0003a\u0001)\"9QM\u0003I\u0001\u0002\u00041\u0017A\b#V%\u0006\u0013\u0015\nT%U3~\u001b%+R!U\u0013>suLQ!D\u0017>3eiX'T+\u0005a\bC\u0001\u0018~\u0013\tqxF\u0001\u0003M_:<\u0017a\b#V%\u0006\u0013\u0015\nT%U3~\u001b%+R!U\u0013>suLQ!D\u0017>3eiX'TA\u0005\u00012m\u001c8tk6,'\u000f\u0015:pm&$WM]\u000b\u0003\u0003\u000b\u00012\u0001PA\u0004\u0013\r\tI!\n\u0002\u0018\tV\u0014\u0018MY5mSRLHk\u001c9jG\u000e{gn];nKJ\f\u0001\u0003\u001d:pIV\u001cWM\u001d)s_ZLG-\u001a:\u0016\u0005\u0005=\u0001c\u0001\u001f\u0002\u0012%\u0019\u00111C\u0013\u0003/\u0011+(/\u00192jY&$\u0018\u0010V8qS\u000e\u0004&o\u001c3vG\u0016\u0014\u0018!\u0002:fC\u0012LXCAA\r!\rq\u00131D\u0005\u0004\u0003;y#a\u0002\"p_2,\u0017M\\\u0001\ne\u0016\fG-_0%KF$B!a\t\u0002*A\u0019a&!\n\n\u0007\u0005\u001drF\u0001\u0003V]&$\b\"CA\u0016!\u0005\u0005\t\u0019AA\r\u0003\rAH%M\u0001\u0007e\u0016\fG-\u001f\u0011)\u0007E\t\t\u0004E\u0002/\u0003gI1!!\u000e0\u0005!1x\u000e\\1uS2,\u0017AC5t'\",H\u000fZ8x]\u0006q\u0011n]*ikR$wn\u001e8`I\u0015\fH\u0003BA\u0012\u0003{A\u0011\"a\u000b\u0014\u0003\u0003\u0005\r!!\u0007\u0002\u0017%\u001c8\u000b[;uI><h\u000e\t\u0015\u0004)\u0005E\u0012\u0001D9vKV,G-\u0012<f]R\u001cXCAA$!\u0019\tI%a\u0015\u0002X5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%A\u0004nkR\f'\r\\3\u000b\u0007\u0005Es&\u0001\u0006d_2dWm\u0019;j_:LA!!\u0016\u0002L\t)\u0011+^3vKB!\u0011\u0011LA0\u001b\t\tYFC\u0002\u0002^\u001d\na!\u001a<f]R\u001c\u0018\u0002BA1\u00037\u0012q#\u00112tiJ\f7\r\u001e#ve\u0006\u0014\u0017\u000e\\5us\u00163XM\u001c;\u0002\u001bE,X-^3e\u000bZ,g\u000e^:!\u0003\u0015\u0019H/\u0019:u)\t\t\u0019#A\u0004jgJ+\u0017\rZ=\u0015\u0005\u0005e\u0011A\u0004;ss\n+7m\\7f%\u0016\fG-_\u0001\tg\",H\u000fZ8x]\u0006i1\u000f^1si\u000e{gn];nKJ\fqa\u00197fC:,\b/A\u0006f]N,(/\u001a+pa&\u001cG\u0003BA\u0012\u0003sBa!a\u001f\u001e\u0001\u0004q\u0016!D5oi\u0016\u0014h.\u00197BI6Lg.A\u0006u_B\u000b'\u000f^5uS>tG\u0003BAA\u0003\u000f\u00032ALAB\u0013\r\t)i\f\u0002\u0004\u0013:$\bbBAE=\u0001\u0007\u00111R\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\ti)a$\u000e\u0003%L1!!%j\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f!#\u00193e\tV\u0014\u0018MY5mSRLXI^3oiR!\u00111EAL\u0011\u001d\tIj\ba\u0001\u0003/\nQ!\u001a<f]R\fa\u0003R;sC\nLG.\u001b;z)>\u0004\u0018nY'b]\u0006<WM\u001d\t\u0003y\u0005\u001a\"!I\u0017\u0015\u0005\u0005u\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0002(*\u001aa-!+,\u0005\u0005-\u0006\u0003BAW\u0003ok!!a,\u000b\t\u0005E\u00161W\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!.0\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003s\u000byKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class DurabilityTopicManager
implements Logging {
    private DurabilityTopicConsumer consumerProvider;
    private DurabilityTopicProducer producerProvider;
    private final DurabilityTopicConfig config;
    private final DurabilityDB database;
    private final DurabilityEventsMaterialize materialize;
    private final Supplier<InternalAdmin> internalAdminSupplier;
    private final Time time;
    private final long DURABILITY_CREATION_BACKOFF_MS;
    private volatile boolean ready;
    private volatile boolean isShutdown;
    private final Queue<AbstractDurabilityEvent> queuedEvents;
    private Logger logger;
    private String logIdent;
    private volatile byte bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return Time.SYSTEM;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public DurabilityTopicConfig config() {
        return this.config;
    }

    public DurabilityDB database() {
        return this.database;
    }

    public DurabilityEventsMaterialize materialize() {
        return this.materialize;
    }

    public Supplier<InternalAdmin> internalAdminSupplier() {
        return this.internalAdminSupplier;
    }

    private long DURABILITY_CREATION_BACKOFF_MS() {
        return this.DURABILITY_CREATION_BACKOFF_MS;
    }

    private DurabilityTopicConsumer consumerProvider$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.consumerProvider = new DurabilityTopicConsumer(this.config(), this.database(), this.materialize());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.consumerProvider;
    }

    public DurabilityTopicConsumer consumerProvider() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.consumerProvider$lzycompute();
        }
        return this.consumerProvider;
    }

    private DurabilityTopicProducer producerProvider$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.producerProvider = new DurabilityTopicProducer(this.config());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.producerProvider;
    }

    public DurabilityTopicProducer producerProvider() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.producerProvider$lzycompute();
        }
        return this.producerProvider;
    }

    public boolean ready() {
        return this.ready;
    }

    public void ready_$eq(boolean x$1) {
        this.ready = x$1;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public void isShutdown_$eq(boolean x$1) {
        this.isShutdown = x$1;
    }

    public Queue<AbstractDurabilityEvent> queuedEvents() {
        return this.queuedEvents;
    }

    public void start() {
        try {
            while (!this.ready() && !this.isShutdown()) {
                if (this.tryBecomeReady()) continue;
                this.warn((Function0<String>)(Function0 & Serializable)() -> "Failed to become ready.");
                this.time.sleep(this.DURABILITY_CREATION_BACKOFF_MS());
            }
        }
        catch (Exception e) {
            if (this.isShutdown()) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> "Ignoring exception caught during shutdown", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
            this.error((Function0<String>)(Function0 & Serializable)() -> "Caught exception while starting DurabilityTopicManager", (Function0<Throwable>)(Function0 & Serializable)() -> e);
        }
    }

    public boolean isReady() {
        return this.ready() && this.consumerProvider().isReady();
    }

    private boolean tryBecomeReady() {
        if (this.config().interBrokerClientConfigs().get().isEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Could not resolve bootstrap server. Will retry.");
            return false;
        }
        try {
            this.ensureTopic(this.internalAdminSupplier().get());
        }
        catch (Exception e) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Caught exception when ensuring durability topic is created. Will retry.", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return false;
        }
        this.startConsumer();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Started consumer for DurabilityTopicManager");
        return true;
    }

    public void shutdown() {
        this.isShutdown_$eq(true);
        this.cleanup();
    }

    private void startConsumer() {
        this.consumerProvider().startConsumer(this.consumerProvider().startConsumer$default$1());
        synchronized (this) {
            this.ready_$eq(true);
            this.queuedEvents().foreach((Function1 & Serializable)event -> {
                this.addDurabilityEvent(event);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private synchronized void cleanup() {
        try {
            this.ready_$eq(false);
            if (this.producerProvider() != null) {
                try {
                    this.producerProvider().get().close(Duration.ofSeconds(2L));
                }
                catch (InterruptException interruptException) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> "Received interrupt while being blocked on producer, will close", (Function0<Throwable>)(Function0 & Serializable)() -> interruptException);
                }
                catch (Exception e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Received unknown error while closing producer", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
        }
        finally {
            this.consumerProvider().shutdown();
        }
    }

    private void ensureTopic(InternalAdmin internalAdmin) {
        internalAdmin.ensureTopic(this.config().topicName(), this.config().configuredNumPartitions(), this.config().configuredReplicationFactor(), this.config().toTopicProperties());
    }

    private int toPartition(TopicPartition topicPartition) {
        return Math.abs(topicPartition.hashCode()) % this.config().configuredNumPartitions();
    }

    public void addDurabilityEvent(AbstractDurabilityEvent event) {
        synchronized (this) {
            if (this.isShutdown()) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Durability Topic Manager service shutting down, ignoring append request ").append(event).toString());
            } else {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("DurabilityEvent: Sending ").append(event).append(" to durability topic").toString());
                this.liftedTree1$1(event);
            }
            return;
        }
    }

    private final /* synthetic */ Object liftedTree1$1(AbstractDurabilityEvent event$1) {
        Object object;
        try {
            if (this.ready()) {
                return this.producerProvider().get().send(new ProducerRecord(this.config().topicName(), Predef$.MODULE$.int2Integer(this.toPartition(event$1.topicIdPartition().topicPartition())), (Object)event$1.serializeKey(), (Object)event$1.serializeValue()));
            }
            object = this.queuedEvents().$colon$plus((Object)event$1);
        }
        catch (Exception ex) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Exception in addDurabilityEvent ").append(ex.getCause()).append(" ").append(ex.getMessage()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> ex);
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public DurabilityTopicManager(DurabilityTopicConfig config, DurabilityDB database, DurabilityEventsMaterialize materialize, Supplier<InternalAdmin> internalAdminSupplier, Time time) {
        this.config = config;
        this.database = database;
        this.materialize = materialize;
        this.internalAdminSupplier = internalAdminSupplier;
        this.time = time;
        this.DURABILITY_CREATION_BACKOFF_MS = 5000L;
        this.ready = false;
        this.isShutdown = false;
        this.queuedEvents = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

