/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import kafka.durability.audit.DurabilityAuditConfig;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.utils.CommitAndSwapEvent;
import kafka.durability.utils.DurabilityTierTopicReaderClient$;
import kafka.durability.utils.DurabilityTierTopicReaderConfig;
import kafka.durability.utils.TierTopicEvents;
import kafka.durability.utils.TierTopicReaderMetricReporter;
import kafka.durability.utils.UploadCompleteEvent;
import kafka.durability.utils.UploadInitiateEvent;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierCompactionCommitAndSwap;
import kafka.tier.domain.TierRecordType;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.topic.TierTopicPartitioner;
import kafka.utils.Logging;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005h\u0001B\u0014)\u0001=B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005{!AA\t\u0001BC\u0002\u0013\u0005Q\t\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003G\u0011!\t\u0006A!b\u0001\n\u0003\u0011\u0006\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u000b!\u0004A\u0011B5\t\u000f=\u0004!\u0019!C\u0005a\"1q\u000f\u0001Q\u0001\nEDq\u0001\u001f\u0001C\u0002\u0013%\u0011\u0010\u0003\u0004}\u0001\u0001\u0006IA\u001f\u0005\b{\u0002\u0011\r\u0011\"\u0003\u007f\u0011\u001d\t)\u0001\u0001Q\u0001\n}D\u0011\"a\u0002\u0001\u0005\u0004%I!!\u0003\t\u0011\u0005=\u0002\u0001)A\u0005\u0003\u0017A\u0011\"!\r\u0001\u0005\u0004%I!a\r\t\u0011\u0005m\u0002\u0001)A\u0005\u0003kA\u0011\"!\u0010\u0001\u0005\u0004%I!a\u0010\t\u0011\u00055\u0003\u0001)A\u0005\u0003\u0003B\u0011\"a\u0014\u0001\u0005\u0004%I!!\u0015\t\u0011\u0005\u001d\u0004\u0001)A\u0005\u0003'B\u0011\"!\u001b\u0001\u0001\u0004%\t!a\u001b\t\u0013\u0005U\u0004\u00011A\u0005\u0002\u0005]\u0004\u0002CAB\u0001\u0001\u0006K!!\u001c\t\u0013\u0005\u0015\u0005A1A\u0005\u0002\u0005\u001d\u0005\u0002CAH\u0001\u0001\u0006I!!#\t\u000f\u0005E\u0005\u0001\"\u0003\u0002R!9\u00111\u0013\u0001\u0005\n\u0005U\u0005bBAL\u0001\u0011%\u0011Q\u0013\u0005\b\u00033\u0003A\u0011BAN\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KCq!!2\u0001\t\u0003\tI\u0001C\u0004\u0002H\u0002!\t!!\u0015\t\u000f\u0005%\u0007\u0001\"\u0001\u0002L\u001e9\u0011Q\u001a\u0015\t\u0002\u0005=gAB\u0014)\u0011\u0003\t\t\u000e\u0003\u0004iI\u0011\u0005\u00111\u001b\u0005\b\u0003+$C\u0011AAl\u0005e!UO]1cS2LG/\u001f+jKJ$v\u000e]5d%\u0016\fG-\u001a:\u000b\u0005%R\u0013!B;uS2\u001c(BA\u0016-\u0003)!WO]1cS2LG/\u001f\u0006\u0002[\u0005)1.\u00194lC\u000e\u00011c\u0001\u00011mA\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t1\u0011I\\=SK\u001a\u0004\"aN\u001d\u000e\u0003aR!!\u000b\u0017\n\u0005iB$a\u0002'pO\u001eLgnZ\u0001\u0007G>tg-[4\u0016\u0003u\u0002\"AP!\u000e\u0003}R!\u0001\u0011\u0016\u0002\u000b\u0005,H-\u001b;\n\u0005\t{$!\u0006#ve\u0006\u0014\u0017\u000e\\5us\u0006+H-\u001b;D_:4\u0017nZ\u0001\bG>tg-[4!\u0003MygnQ8na2,G/Z*jO:\fG\u000e\\3s+\u00051\u0005CA$O\u001b\u0005A%BA%K\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u00172\u000bA!\u001e;jY*\tQ*\u0001\u0003kCZ\f\u0017BA(I\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"\fAc\u001c8D_6\u0004H.\u001a;f'&<g.\u00197mKJ\u0004\u0013!\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\'baV\t1\u000b\u0005\u0003U7z#gBA+Z!\t1&'D\u0001X\u0015\tAf&\u0001\u0004=e>|GOP\u0005\u00035J\na\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\ri\u0015\r\u001d\u0006\u00035J\u0002\"a\u00182\u000e\u0003\u0001T!!\u0019\u0017\u0002\tQLWM]\u0005\u0003G\u0002\u0014\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0011\u0005E*\u0017B\u000143\u0005\u0011auN\\4\u0002%Q|\u0007/[2QCJ$\u0018\u000e^5p]6\u000b\u0007\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t)dWN\u001c\t\u0003W\u0002i\u0011\u0001\u000b\u0005\u0006w\u001d\u0001\r!\u0010\u0005\u0006\t\u001e\u0001\rA\u0012\u0005\u0006#\u001e\u0001\raU\u0001\u000bG2LWM\u001c;UsB,W#A9\u0011\u0005I,X\"A:\u000b\u0005Qd\u0015\u0001\u00027b]\u001eL!A^:\u0003\rM#(/\u001b8h\u0003-\u0019G.[3oiRK\b/\u001a\u0011\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012,\u0012A\u001f\t\u0003)nL!A^/\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0013AD2p]N,X.\u001a:D_:4\u0017nZ\u000b\u0002\u007fB\u00191.!\u0001\n\u0007\u0005\r\u0001FA\u0010EkJ\f'-\u001b7jif$\u0016.\u001a:U_BL7MU3bI\u0016\u00148i\u001c8gS\u001e\fqbY8ogVlWM]\"p]\u001aLw\rI\u0001\tG>t7/^7feV\u0011\u00111\u0002\t\t\u0003\u001b\ty\"a\t\u0002$5\u0011\u0011q\u0002\u0006\u0005\u0003\u000f\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011aB2mS\u0016tGo\u001d\u0006\u0004[\u0005]!\u0002BA\r\u00037\ta!\u00199bG\",'BAA\u000f\u0003\ry'oZ\u0005\u0005\u0003C\tyA\u0001\u0005D_:\u001cX/\\3s!\u0015\t\u0014QEA\u0015\u0013\r\t9C\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004c\u0005-\u0012bAA\u0017e\t!!)\u001f;f\u0003%\u0019wN\\:v[\u0016\u0014\b%\u0001\u0007m_>\\')Y2l)&lW-\u0006\u0002\u00026A\u0019\u0011'a\u000e\n\u0007\u0005e\"GA\u0002J]R\fQ\u0002\\8pW\n\u000b7m\u001b+j[\u0016\u0004\u0013\u0001\u0006;jKJ$v\u000e]5d!\u0006\u0014H/\u001b;j_:,'/\u0006\u0002\u0002BA!\u00111IA%\u001b\t\t)EC\u0002\u0002H\u0001\fQ\u0001^8qS\u000eLA!a\u0013\u0002F\t!B+[3s)>\u0004\u0018n\u0019)beRLG/[8oKJ\fQ\u0003^5feR{\u0007/[2QCJ$\u0018\u000e^5p]\u0016\u0014\b%A\nuS\u0016\u0014Hk\u001c9jGB\u000b'\u000f^5uS>t7/\u0006\u0002\u0002TA1\u0011QKA,\u00037j\u0011AS\u0005\u0004\u00033R%aA*fiB!\u0011QLA2\u001b\t\tyF\u0003\u0003\u0002b\u0005U\u0011AB2p[6|g.\u0003\u0003\u0002f\u0005}#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0015i&,'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u0015\u0015tGm\u00144gg\u0016$8/\u0006\u0002\u0002nAA\u0011QKA8\u00037\n\t(\u0003\u0002]\u0015B\u0019!/a\u001d\n\u0005\u0019\u001c\u0018AD3oI>3gm]3ug~#S-\u001d\u000b\u0005\u0003s\ny\bE\u00022\u0003wJ1!! 3\u0005\u0011)f.\u001b;\t\u0013\u0005\u0005u#!AA\u0002\u00055\u0014a\u0001=%c\u0005YQM\u001c3PM\u001a\u001cX\r^:!\u0003=iW\r\u001e:jGN\u0014V\r]8si\u0016\u0014XCAAE!\rY\u00171R\u0005\u0004\u0003\u001bC#!\b+jKJ$v\u000e]5d%\u0016\fG-\u001a:NKR\u0014\u0018n\u0019*fa>\u0014H/\u001a:\u0002!5,GO]5dgJ+\u0007o\u001c:uKJ\u0004\u0013!F4fiRKWM\u001d+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0016S:LG\u000fV5feR{\u0007/[2D_:\u001cX/\\3s)\t\tI(\u0001\fdY>\u001cX\rV5feR{\u0007/[2D_:\u001cX/\\3s\u0003]A\u0017m]'pe\u0016lUm]:bO\u0016$vnQ8ogVlW-\u0006\u0002\u0002\u001eB\u0019\u0011'a(\n\u0007\u0005\u0005&GA\u0004C_>dW-\u00198\u0002/\u0019LG\u000e^3s\u0007>l\u0007/Y2uS>tW*Z:tC\u001e,G\u0003BAT\u0003w\u0003r!!+\u00024z\u000b),\u0004\u0002\u0002,*!\u0011QVAX\u0003\u001diW\u000f^1cY\u0016T1!!-3\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00049\u0006-\u0006cA6\u00028&\u0019\u0011\u0011\u0018\u0015\u0003\u001fQKWM\u001d+pa&\u001cWI^3oiNDq!!0 \u0001\u0004\ty,A\u0004sK\u000e|'\u000fZ:\u0011\u0011\u00055\u0011\u0011YA\u0012\u0003GIA!a1\u0002\u0010\ty1i\u001c8tk6,'OU3d_J$7/A\u0006hKR\u001cuN\\:v[\u0016\u0014\u0018AF4fiRKWM\u001d+pa&\u001c\u0007+\u0019:uSRLwN\\:\u0002'I,GO]5fm\u0016$\u0016.\u001a:SK\u000e|'\u000fZ:\u0015\u0005\u0005\u001d\u0016!\u0007#ve\u0006\u0014\u0017\u000e\\5usRKWM\u001d+pa&\u001c'+Z1eKJ\u0004\"a\u001b\u0013\u0014\u0005\u0011\u0002DCAAh\u0003\u0015\t\u0007\u000f\u001d7z)\u001dQ\u0017\u0011\\An\u0003;DQa\u000f\u0014A\u0002uBQ\u0001\u0012\u0014A\u0002\u0019Ca!a8'\u0001\u0004\u0019\u0016A\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\:NCB\u0004")
public class DurabilityTierTopicReader
implements Logging {
    private final DurabilityAuditConfig config;
    private final CountDownLatch onCompleteSignaller;
    private final scala.collection.immutable.Map<TopicIdPartition, Object> topicPartitionMap;
    private final String clientType;
    private final String clientId;
    private final DurabilityTierTopicReaderConfig consumerConfig;
    private final Consumer<byte[], byte[]> consumer;
    private final int lookBackTime;
    private final TierTopicPartitioner tierTopicPartitioner;
    private final Set<TopicPartition> tierTopicPartitions;
    private Map<TopicPartition, Long> endOffsets;
    private final TierTopicReaderMetricReporter metricsReporter;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static DurabilityTierTopicReader apply(DurabilityAuditConfig config, CountDownLatch onCompleteSignaller, scala.collection.immutable.Map<TopicIdPartition, Object> topicPartitionsMap) {
        return new DurabilityTierTopicReader(config, onCompleteSignaller, topicPartitionsMap);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public DurabilityAuditConfig config() {
        return this.config;
    }

    public CountDownLatch onCompleteSignaller() {
        return this.onCompleteSignaller;
    }

    public scala.collection.immutable.Map<TopicIdPartition, Object> topicPartitionMap() {
        return this.topicPartitionMap;
    }

    private String clientType() {
        return this.clientType;
    }

    private String clientId() {
        return this.clientId;
    }

    private DurabilityTierTopicReaderConfig consumerConfig() {
        return this.consumerConfig;
    }

    private Consumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    private int lookBackTime() {
        return this.lookBackTime;
    }

    private TierTopicPartitioner tierTopicPartitioner() {
        return this.tierTopicPartitioner;
    }

    private Set<TopicPartition> tierTopicPartitions() {
        return this.tierTopicPartitions;
    }

    public Map<TopicPartition, Long> endOffsets() {
        return this.endOffsets;
    }

    public void endOffsets_$eq(Map<TopicPartition, Long> x$1) {
        this.endOffsets = x$1;
    }

    public TierTopicReaderMetricReporter metricsReporter() {
        return this.metricsReporter;
    }

    private Set<TopicPartition> getTierTopicPartition() {
        HashSet<TopicPartition> tierTopic = new HashSet<TopicPartition>();
        this.topicPartitionMap().foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DurabilityTierTopicReader.$anonfun$getTierTopicPartition$1(this, tierTopic, x0$1)));
        return tierTopic;
    }

    private void initTierTopicConsumer() {
        this.consumer().assign(this.tierTopicPartitions());
        long lookBackTimeInMs = Time.SYSTEM.milliseconds() - (long)this.lookBackTime();
        HashMap timeStampToSearch = new HashMap();
        scala.collection.mutable.Map validOffsetMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.topicPartitionMap().foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicIdPartition k = (TopicIdPartition)x0$1._1();
                long v = x0$1._2$mcJ$sp();
                TopicPartition tierTopicPartition = new TopicPartition("_confluent-tier-state", this.tierTopicPartitioner().partitionId(k));
                if (v == DurabilityAuditConstants$.MODULE$.TIER_TOPIC_INITIAL_SEEK()) {
                    return timeStampToSearch.put(tierTopicPartition, BoxesRunTime.boxToLong((long)lookBackTimeInMs));
                }
                return validOffsetMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tierTopicPartition), (Object)BoxesRunTime.boxToLong((long)RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)validOffsetMap.getOrElse((Object)tierTopicPartition, (Function0)(JFunction0.mcJ.sp & Serializable)() -> v))), v))));
            }
            this.error((Function0<String>)(Function0 & Serializable)() -> "Empty Map give by user");
            throw new RuntimeException("Empty Map provided");
        });
        ObjectRef timestampOffsets = ObjectRef.create((Object)new HashMap<TopicPartition, OffsetAndTimestamp>(null){});
        if (!timeStampToSearch.isEmpty()) {
            timestampOffsets.elem = this.consumer().offsetsForTimes(timeStampToSearch);
        }
        this.tierTopicPartitions().forEach(tierTopicPartition -> {
            Option option = validOffsetMap.get(tierTopicPartition);
            Object v = ((Map)timestampOffsets$1.elem).get(tierTopicPartition);
            OffsetAndTimestamp timeOffset = (OffsetAndTimestamp)v;
            if (option instanceof Some) {
                long explicitOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                if (timeOffset != null) {
                    this.consumer().seek(tierTopicPartition, RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timeOffset.offset()), explicitOffset));
                    return;
                }
            }
            OffsetAndTimestamp timeOffset2 = (OffsetAndTimestamp)v;
            if (None$.MODULE$.equals(option) && timeOffset2 != null) {
                this.consumer().seek(tierTopicPartition, timeOffset2.offset());
                return;
            }
            if (option instanceof Some) {
                long explicitOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                this.consumer().seek(tierTopicPartition, explicitOffset);
                return;
            }
            this.consumer().seekToBeginning(Collections.singletonList(tierTopicPartition));
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(49).append("Not able to find in timestamp for topicPartition ").append(tierTopicPartition).toString());
        });
        this.endOffsets_$eq(this.consumer().endOffsets(this.tierTopicPartitions()));
    }

    private void closeTierTopicConsumer() {
        if (this.consumer() != null) {
            this.consumer().close();
            return;
        }
    }

    private boolean hasMoreMessageToConsume() {
        Object object = new Object();
        try {
            this.tierTopicPartitions().forEach(tierTopicPartition -> {
                Long l = this.endOffsets().get(tierTopicPartition);
                if (l != null && this.consumer().position(tierTopicPartition) < Predef$.MODULE$.Long2long(l)) {
                    throw new NonLocalReturnControl.mcZ.sp(object, true);
                }
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("Invalid offset for ").append(tierTopicPartition).toString());
            });
            return false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    private scala.collection.mutable.Map<TopicIdPartition, TierTopicEvents> filterCompactionMessage(ConsumerRecords<byte[], byte[]> records) {
        scala.collection.mutable.Map messages = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        DoubleRef bytesRead = DoubleRef.create((double)0.0);
        records.forEach(record -> {
            block6: {
                block7: {
                    Some some;
                    boolean bl;
                    AbstractTierMetadata tierMetadata;
                    block8: {
                        TierRecordType tierRecordType;
                        block9: {
                            bytesRead$1.elem += (double)(record.serializedKeySize() + record.serializedValueSize());
                            Option metadataEntryOpt = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(AbstractTierMetadata.deserialize((byte[])record.key(), (byte[])record.value(), record.timestamp())));
                            if (!(metadataEntryOpt instanceof Some) || (tierMetadata = (AbstractTierMetadata)((Some)metadataEntryOpt).value()) == null) break block7;
                            bl = false;
                            some = null;
                            Option option = this.topicPartitionMap().get((Object)tierMetadata.topicIdPartition());
                            if (!(option instanceof Some)) break block8;
                            bl = true;
                            some = (Some)option;
                            long value = BoxesRunTime.unboxToLong((Object)some.value());
                            if (record.offset() <= value && DurabilityAuditConstants$.MODULE$.TIER_TOPIC_INITIAL_SEEK() != value) break block8;
                            tierRecordType = tierMetadata.type();
                            if (!((Object)((Object)TierRecordType.CompactionCommitAndSwap)).equals((Object)tierRecordType)) break block9;
                            TierCompactionCommitAndSwap message = (TierCompactionCommitAndSwap)tierMetadata;
                            ObjectRef destObjectIds = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
                            ObjectRef sourceObjectIds = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
                            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), message.destinationObjectIdsLength()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)ii -> {
                                destObjectIds$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)destObjectIds$1.elem).$plus((Object)message.destinationObjectIdsGet(ii));
                            });
                            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), message.sourceObjectIdsLength()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)ii -> {
                                sourceObjectIds$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)sourceObjectIds$1.elem).$plus((Object)message.sourceObjectIdsGet(ii));
                            });
                            messages.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tierMetadata.topicIdPartition()), (Object)((TierTopicEvents)messages.getOrElse((Object)tierMetadata.topicIdPartition(), (Function0 & Serializable)() -> new TierTopicEvents((Seq<CommitAndSwapEvent>)((Seq)package$.MODULE$.Seq().empty()), (Seq<UploadInitiateEvent>)((Seq)package$.MODULE$.Seq().empty()), (Seq<UploadCompleteEvent>)((Seq)package$.MODULE$.Seq().empty())))).$plus(new TierTopicEvents((Seq<CommitAndSwapEvent>)new .colon.colon((Object)new CommitAndSwapEvent((scala.collection.immutable.Set<UUID>)((scala.collection.immutable.Set)sourceObjectIds.elem), (scala.collection.immutable.Set<UUID>)((scala.collection.immutable.Set)destObjectIds.elem), record.offset()), (List)Nil$.MODULE$), (Seq<UploadInitiateEvent>)((Seq)package$.MODULE$.Seq().empty()), (Seq<UploadCompleteEvent>)((Seq)package$.MODULE$.Seq().empty())))));
                            break block6;
                        }
                        if (((Object)((Object)TierRecordType.SegmentUploadInitiate)).equals((Object)tierRecordType)) {
                            TierSegmentUploadInitiate message = (TierSegmentUploadInitiate)tierMetadata;
                            messages.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tierMetadata.topicIdPartition()), (Object)((TierTopicEvents)messages.getOrElse((Object)tierMetadata.topicIdPartition(), (Function0 & Serializable)() -> new TierTopicEvents((Seq<CommitAndSwapEvent>)((Seq)package$.MODULE$.Seq().empty()), (Seq<UploadInitiateEvent>)((Seq)package$.MODULE$.Seq().empty()), (Seq<UploadCompleteEvent>)((Seq)package$.MODULE$.Seq().empty())))).$plus(new TierTopicEvents((Seq<CommitAndSwapEvent>)((Seq)package$.MODULE$.Seq().empty()), (Seq<UploadInitiateEvent>)new .colon.colon((Object)new UploadInitiateEvent(message.objectId(), message), (List)Nil$.MODULE$), (Seq<UploadCompleteEvent>)((Seq)package$.MODULE$.Seq().empty())))));
                            break block6;
                        } else if (((Object)((Object)TierRecordType.SegmentUploadComplete)).equals((Object)tierRecordType)) {
                            TierSegmentUploadComplete message = (TierSegmentUploadComplete)tierMetadata;
                            messages.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tierMetadata.topicIdPartition()), (Object)((TierTopicEvents)messages.getOrElse((Object)tierMetadata.topicIdPartition(), (Function0 & Serializable)() -> new TierTopicEvents((Seq<CommitAndSwapEvent>)((Seq)package$.MODULE$.Seq().empty()), (Seq<UploadInitiateEvent>)((Seq)package$.MODULE$.Seq().empty()), (Seq<UploadCompleteEvent>)((Seq)package$.MODULE$.Seq().empty())))).$plus(new TierTopicEvents((Seq<CommitAndSwapEvent>)((Seq)package$.MODULE$.Seq().empty()), (Seq<UploadInitiateEvent>)((Seq)package$.MODULE$.Seq().empty()), (Seq<UploadCompleteEvent>)new .colon.colon((Object)new UploadCompleteEvent(message.objectId()), (List)Nil$.MODULE$)))));
                            break block6;
                        } else {
                            this.debug((Function0<String>)(Function0 & Serializable)() -> "Events skipped");
                        }
                        break block6;
                    }
                    if (bl) {
                        long value = BoxesRunTime.unboxToLong((Object)some.value());
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("TopicIdPartition skipped ").append(tierMetadata.topicIdPartition()).append(" ").append("as offset read ").append(record.offset()).append(" is  lower than given ").append(value).toString());
                        break block6;
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("TopicIdPartition skipped  ").append(tierMetadata.topicIdPartition()).append(" as not given in input").toString());
                    }
                    break block6;
                }
                this.error((Function0<String>)(Function0 & Serializable)() -> "Cannot deserialize the record correctly");
            }
            this.metricsReporter().updateAuditTierTopicReadBytes(bytesRead$1.elem);
        });
        return messages;
    }

    public Consumer<byte[], byte[]> getConsumer() {
        return this.consumer();
    }

    public Set<TopicPartition> getTierTopicPartitions() {
        return this.tierTopicPartitions();
    }

    public scala.collection.mutable.Map<TopicIdPartition, TierTopicEvents> retrieveTierRecords() {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        IntRef count = IntRef.create((int)0);
        try {
            try {
                this.initTierTopicConsumer();
                while (this.hasMoreMessageToConsume() && this.onCompleteSignaller().getCount() != 0L && count.elem < this.config().tierBatchRecordsToConsume()) {
                    ConsumerRecords records = this.consumer().poll(Duration.ofMillis(this.config().tierPollDurationMs()));
                    this.filterCompactionMessage((ConsumerRecords<byte[], byte[]>)records).foreach((Function1 & Serializable)x0$1 -> {
                        DurabilityTierTopicReader.$anonfun$retrieveTierRecords$1(result, count, x0$1);
                        return BoxedUnit.UNIT;
                    });
                }
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("DurabilityTierTopicReader retrieved number of topicPartition ").append(result).append(".size").toString());
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Received error while executing", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
        }
        finally {
            this.closeTierTopicConsumer();
        }
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$getTierTopicPartition$1(DurabilityTierTopicReader $this, Set tierTopic$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicIdPartition topicIdPartition = (TopicIdPartition)x0$1._1();
            return tierTopic$1.add(new TopicPartition("_confluent-tier-state", $this.tierTopicPartitioner().partitionId(topicIdPartition)));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$retrieveTierRecords$1(scala.collection.mutable.Map result$1, IntRef count$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicIdPartition partition = (TopicIdPartition)x0$1._1();
            TierTopicEvents events = (TierTopicEvents)x0$1._2();
            result$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)((TierTopicEvents)result$1.getOrElse((Object)partition, (Function0 & Serializable)() -> new TierTopicEvents((Seq<CommitAndSwapEvent>)((Seq)package$.MODULE$.Seq().empty()), (Seq<UploadInitiateEvent>)((Seq)package$.MODULE$.Seq().empty()), (Seq<UploadCompleteEvent>)((Seq)package$.MODULE$.Seq().empty())))).$plus(events)));
            count$1.elem += events.commitAndSwapMessages().size();
            return;
        }
        throw new MatchError(null);
    }

    public DurabilityTierTopicReader(DurabilityAuditConfig config, CountDownLatch onCompleteSignaller, scala.collection.immutable.Map<TopicIdPartition, Object> topicPartitionMap) {
        this.config = config;
        this.onCompleteSignaller = onCompleteSignaller;
        this.topicPartitionMap = topicPartitionMap;
        this.clientType = "consumer";
        this.clientId = DurabilityTierTopicReaderClient$.MODULE$.clientId(this.clientType(), config.clusterId(), config.brokerId(), 0);
        this.consumerConfig = new DurabilityTierTopicReaderConfig(config);
        this.consumer = new KafkaConsumer(this.consumerConfig().consumerProperties(this.clientId()));
        this.lookBackTime = config.maxLookBackInDays() * 24 * 60 * 60 * 1000;
        this.tierTopicPartitioner = new TierTopicPartitioner(config.tierTopicPartitionNum());
        this.tierTopicPartitions = this.getTierTopicPartition();
        this.endOffsets = new HashMap<TopicPartition, Long>();
        this.metricsReporter = new TierTopicReaderMetricReporter(config.metrics());
    }
}

