/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.nio.ByteBuffer;
import kafka.log.AbstractLog;
import kafka.log.LogSegment;
import kafka.log.LogSegmentReadAdapter;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005]3AAC\u0006\u0001!!AA\u0002\u0001B\u0001B\u0003%\u0011\u0005\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0011\u0015A\u0003\u0001\"\u0001*\u0011\u0015i\u0003\u0001\"\u0011/\u0011\u0015\u0011\u0004\u0001\"\u0011/\u0011\u0015\u0019\u0004\u0001\"\u00115\u0011\u0015A\u0004\u0001\"\u00115\u0011\u0015I\u0004\u0001\"\u0011;\u0011\u0015Q\u0005\u0001\"\u0011L\u0005iaunY1m\u0019><7+Z4nK:$(+Z1e\u0003\u0012\f\u0007\u000f^3s\u0015\taQ\"A\u0002m_\u001eT\u0011AD\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0011cF\u000e\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g!\tA\u0012$D\u0001\f\u0013\tQ2BA\u000bM_\u001e\u001cVmZ7f]R\u0014V-\u00193BI\u0006\u0004H/\u001a:\u0011\u0005qyR\"A\u000f\u000b\u0005yi\u0011!B;uS2\u001c\u0018B\u0001\u0011\u001e\u0005\u001daunZ4j]\u001e\u0004\"\u0001\u0007\u0012\n\u0005\rZ!aC!cgR\u0014\u0018m\u0019;M_\u001e\fqa]3h[\u0016tG\u000f\u0005\u0002\u0019M%\u0011qe\u0003\u0002\u000b\u0019><7+Z4nK:$\u0018A\u0002\u001fj]&$h\bF\u0002+W1\u0002\"\u0001\u0007\u0001\t\u000b1\u0019\u0001\u0019A\u0011\t\u000b\u0011\u001a\u0001\u0019A\u0013\u0002\u0015\t\f7/Z(gMN,G/F\u00010!\t\u0011\u0002'\u0003\u00022'\t!Aj\u001c8h\u0003%)g\u000eZ(gMN,G/A\u0007ti\u0006\u0014H\u000fU8tSRLwN\\\u000b\u0002kA\u0011!CN\u0005\u0003oM\u00111!\u00138u\u0003-)g\u000e\u001a)pg&$\u0018n\u001c8\u0002\u0013I,\u0017\r\u001a\"zi\u0016\u001cHcA\u001e?\u0011B\u0011!\u0003P\u0005\u0003{M\u0011A!\u00168ji\")q\b\u0003a\u0001\u0001\u00061!-\u001e4gKJ\u0004\"!\u0011$\u000e\u0003\tS!a\u0011#\u0002\u00079LwNC\u0001F\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0013%A\u0003\"zi\u0016\u0014UO\u001a4fe\")\u0011\n\u0003a\u0001k\u0005A\u0001o\\:ji&|g.\u0001\u0005u_N#(/\u001b8h)\u0005a\u0005CA'U\u001d\tq%\u000b\u0005\u0002P'5\t\u0001K\u0003\u0002R\u001f\u00051AH]8pizJ!aU\n\u0002\rA\u0013X\rZ3g\u0013\t)fK\u0001\u0004TiJLgn\u001a\u0006\u0003'N\u0001")
public class LocalLogSegmentReadAdapter
implements LogSegmentReadAdapter,
Logging {
    private final AbstractLog log;
    private final LogSegment segment;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public long baseOffset() {
        return this.segment.baseOffset();
    }

    @Override
    public long endOffset() {
        return this.segment.readNextOffset() - 1L;
    }

    @Override
    public int startPosition() {
        return 0;
    }

    @Override
    public int endPosition() {
        return (int)this.segment.log().channel().size();
    }

    @Override
    public void readBytes(ByteBuffer buffer, int position) {
        if (position < this.startPosition() || position > this.endPosition()) {
            throw new IllegalArgumentException(new StringBuilder(48).append("Invalid position: ").append(position).append(". Valid position range is [").append(this.startPosition()).append(", ").append(this.endPosition()).append("]").toString());
        }
        try {
            this.segment.log().readInto(buffer, position);
            return;
        }
        catch (Exception e) {
            throw new KafkaException(new StringBuilder(58).append("Failed to read from segment ").append(this.segment).append(" of partition ").append(this.log).append(".topicPartition ").toString(), (Throwable)e);
        }
    }

    public String toString() {
        return new StringBuilder(99).append("LocalLogSegmentReadAdapter(").append("log segment: ").append(this.segment.log().file()).append(", startPosition: ").append(this.startPosition()).append(", endPosition: ").append(this.endPosition()).append(", baseOffset: ").append(this.baseOffset()).append(", endOffset:").append(this.endOffset()).append(")").toString();
    }

    public LocalLogSegmentReadAdapter(AbstractLog log, LogSegment segment) {
        this.log = log;
        this.segment = segment;
    }
}

