/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.availability.FilesWrapper;
import io.confluent.kafka.availability.ThreadCountersManager;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import kafka.common.FetchedTimestampAndOffset;
import kafka.common.FetchedTimestampAndOffset$;
import kafka.common.FollowerRestorePoint;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.AppendOrigin$Replication$;
import kafka.log.CompletedTxn;
import kafka.log.LazyIndex;
import kafka.log.LogConfig;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateManager;
import kafka.log.RollParams;
import kafka.log.SegmentStats$;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.log.TimestampOffset$;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import kafka.server.FetchDataInfo;
import kafka.server.LogOffsetMetadata;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011ec\u0001B1c\u0001\u001dD\u0001b\u0019\u0001\u0003\u0006\u0004%\t\u0001\u001e\u0005\n\u0003\u000b\u0001!\u0011!Q\u0001\nUD!\"a\u0002\u0001\u0005\u000b\u0007I\u0011AA\u0005\u0011)\tI\u0002\u0001B\u0001B\u0003%\u00111\u0002\u0005\u000b\u00037\u0001!Q1A\u0005\u0002\u0005u\u0001BCA\u0014\u0001\t\u0005\t\u0015!\u0003\u0002 !Q\u0011\u0011\u0006\u0001\u0003\u0006\u0004%\t!a\u000b\t\u0015\u0005M\u0002A!A!\u0002\u0013\ti\u0003\u0003\u0006\u00026\u0001\u0011)\u0019!C\u0001\u0003oA!\"a\u0010\u0001\u0005\u0003\u0005\u000b\u0011BA\u001d\u0011)\t\t\u0005\u0001BC\u0002\u0013\u0005\u00111\t\u0005\u000b\u0003\u0017\u0002!\u0011!Q\u0001\n\u0005\u0015\u0003BCA'\u0001\t\u0015\r\u0011\"\u0001\u00028!Q\u0011q\n\u0001\u0003\u0002\u0003\u0006I!!\u000f\t\u0015\u0005E\u0003A!b\u0001\n\u0003\t\u0019\u0006\u0003\u0006\u0002`\u0001\u0011\t\u0011)A\u0005\u0003+B\u0001\"!\u0019\u0001\t\u0003\u0011\u00171\r\u0005\b\u0003o\u0002A\u0011AA=\u0011\u001d\tY\b\u0001C\u0001\u0003{Bq!a \u0001\t\u0003\t\t\tC\u0004\u0002\u0014\u0002!\t!!&\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002$\"I\u0011\u0011\u0016\u0001A\u0002\u0013%\u0011q\u0007\u0005\n\u0003W\u0003\u0001\u0019!C\u0005\u0003[C\u0001\"a-\u0001A\u0003&\u0011\u0011\b\u0005\n\u0003k\u0003\u0001\u0019!C\u0005\u0003\u0007B\u0011\"a.\u0001\u0001\u0004%I!!/\t\u0011\u0005u\u0006\u0001)Q\u0005\u0003\u000bB\u0011\"a0\u0001\u0001\u0004%I!!1\t\u0013\u0005%\u0007\u00011A\u0005\n\u0005-\u0007\u0002CAh\u0001\u0001\u0006K!a1\t\u0013\u0005e\u0007\u00011A\u0005\u0002\u0005\u0005\u0007\"CAn\u0001\u0001\u0007I\u0011AAo\u0011!\t\t\u000f\u0001Q!\n\u0005\r\u0007\"CAs\u0001\u0001\u0007I\u0011BAt\u0011%\ty\u000f\u0001a\u0001\n\u0013\t\t\u0010\u0003\u0005\u0002v\u0002\u0001\u000b\u0015BAu\u0011\u001d\tI\u0010\u0001C\u0001\u0003wDqA!\u0001\u0001\t\u0003\t9\u000fC\u0004\u0003\u0004\u0001!\t!a\u000e\t\u000f\t\u0015\u0001\u0001\"\u0001\u00028!9\u0011q\u0014\u0001\u0005\u0002\u0005\r\u0003b\u0002B\u0004\u0001\u0011\u0005!\u0011\u0002\u0005\b\u0005\u001f\u0001A\u0011\u0001B\t\u0011\u001d\u0011I\u0003\u0001C\u0005\u0005WAqAa\f\u0001\t\u0013\u0011\t\u0004C\u0004\u0003D\u0001!IA!\u0012\t\u000f\tU\u0003\u0001\"\u0001\u0003X!9!q\f\u0001\u0005\u0002\t\u0005\u0004b\u0002B:\u0001\u0011%!Q\u000f\u0005\t\u0005\u000f\u0003A\u0011\u00012\u0003\n\"Q!\u0011\u0019\u0001\u0012\u0002\u0013\u0005!Ma1\t\u000f\te\u0007\u0001\"\u0001\u0003\\\"I!1 \u0001\u0012\u0002\u0013\u0005!Q \u0005\n\u0007\u0003\u0001\u0011\u0013!C\u0001\u0007\u0007Aqaa\u0002\u0001\t\u0003\u0019I\u0001C\u0004\u0004\u001a\u0001!\taa\u0007\t\u0013\rM\u0002!%A\u0005\u0002\rU\u0002bBB\u001d\u0001\u0011%11\b\u0005\b\u0007{\u0001A\u0011AB \u0011\u001d\u0019\t\u0005\u0001C\u0001\u0007\u0007Bqaa\u0015\u0001\t\u0003\u001a)\u0006C\u0004\u0004h\u0001!\ta!\u001b\t\u000f\r=\u0004\u0001\"\u0001\u0004r!A11\u000f\u0001!\u0002\u0013\u0019)\bC\u0004\u0004\u000e\u0002!\t!a\u000e\t\u000f\rE\u0005\u0001\"\u0001\u0004<!91Q\u0013\u0001\u0005\u0002\r]\u0005bBBU\u0001\u0011\u000511\u0016\u0005\b\u0007k\u0003A\u0011AB\\\u0011\u001d\u0019i\f\u0001C\u0001\u0007wAqaa0\u0001\t\u0013\u0019Y\u0004C\u0004\u0004B\u0002!\taa1\t\u000f\r5\u0007\u0001\"\u0001\u0004r!91q\u001a\u0001\u0005\u0002\rE\u0007\"CBt\u0001E\u0005I\u0011\u0001B\u007f\u0011\u001d\u0019I\u000f\u0001C\u0001\u0007wAqaa;\u0001\t\u0003\u0019Y\u0004C\u0004\u0004n\u0002!\taa\u000f\t\u000f\r=\b\u0001\"\u0001\u0004r\"911\u001f\u0001\u0005\u0002\u0005]\u0002bBB{\u0001\u0011\u0005\u0011\u0011\u0019\u0005\b\u0007o\u0004A\u0011AA\u001c\u0011\u001d\u0019I\u0010\u0001C\u0001\u0007w<q\u0001b\u0005c\u0011\u0003!)B\u0002\u0004bE\"\u0005Aq\u0003\u0005\b\u0003C2F\u0011\u0001C\r\u0011%!YB\u0016b\u0001\n\u0013\t9\u0004\u0003\u0005\u0005\u001eY\u0003\u000b\u0011BA\u001d\u0011\u001d!yB\u0016C\u0001\tCA\u0011\u0002b\u0011W#\u0003%\taa\u0001\t\u0013\u0011\u0015c+%A\u0005\u0002\t\r\u0007\"\u0003C$-F\u0005I\u0011AB\u0002\u0011%!IEVI\u0001\n\u0003!Y\u0005C\u0004\u0004nZ#\t\u0001b\u0014\t\u0013\u0011]c+%A\u0005\u0002\u0011-#A\u0003'pON+w-\\3oi*\u00111\rZ\u0001\u0004Y><'\"A3\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u001b8\u0011\u0005%dW\"\u00016\u000b\u0003-\fQa]2bY\u0006L!!\u001c6\u0003\r\u0005s\u0017PU3g!\ty'/D\u0001q\u0015\t\tH-A\u0003vi&d7/\u0003\u0002ta\n9Aj\\4hS:<W#A;\u0011\u0007Y\f\t!D\u0001x\u0015\tA\u00180\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0003un\faaY8n[>t'BA3}\u0015\tih0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u007f\u0006\u0019qN]4\n\u0007\u0005\rqOA\u0006GS2,'+Z2pe\u0012\u001c\u0018\u0001\u00027pO\u0002\nq\u0002\\1{s>3gm]3u\u0013:$W\r_\u000b\u0003\u0003\u0017\u0001b!!\u0004\u0002\u0010\u0005MQ\"\u00012\n\u0007\u0005E!MA\u0005MCjL\u0018J\u001c3fqB!\u0011QBA\u000b\u0013\r\t9B\u0019\u0002\f\u001f\u001a47/\u001a;J]\u0012,\u00070\u0001\tmCjLxJ\u001a4tKRLe\u000eZ3yA\u0005iA.\u0019>z)&lW-\u00138eKb,\"!a\b\u0011\r\u00055\u0011qBA\u0011!\u0011\ti!a\t\n\u0007\u0005\u0015\"MA\u0005US6,\u0017J\u001c3fq\u0006qA.\u0019>z)&lW-\u00138eKb\u0004\u0013\u0001\u0003;y]&sG-\u001a=\u0016\u0005\u00055\u0002\u0003BA\u0007\u0003_I1!!\rc\u0005A!&/\u00198tC\u000e$\u0018n\u001c8J]\u0012,\u00070A\u0005uq:Le\u000eZ3yA\u0005Q!-Y:f\u001f\u001a47/\u001a;\u0016\u0005\u0005e\u0002cA5\u0002<%\u0019\u0011Q\b6\u0003\t1{gnZ\u0001\fE\u0006\u001cXm\u00144gg\u0016$\b%\u0001\nj]\u0012,\u00070\u00138uKJ4\u0018\r\u001c\"zi\u0016\u001cXCAA#!\rI\u0017qI\u0005\u0004\u0003\u0013R'aA%oi\u0006\u0019\u0012N\u001c3fq&sG/\u001a:wC2\u0014\u0015\u0010^3tA\u0005a!o\u001c7m\u0015&$H/\u001a:Ng\u0006i!o\u001c7m\u0015&$H/\u001a:Ng\u0002\nA\u0001^5nKV\u0011\u0011Q\u000b\t\u0005\u0003/\nY&\u0004\u0002\u0002Z)\u0011\u0011/_\u0005\u0005\u0003;\nIF\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\n\u0002f\u0005\u001d\u0014\u0011NA6\u0003[\ny'!\u001d\u0002t\u0005U\u0004cAA\u0007\u0001!)1-\u0005a\u0001k\"9\u0011qA\tA\u0002\u0005-\u0001bBA\u000e#\u0001\u0007\u0011q\u0004\u0005\b\u0003S\t\u0002\u0019AA\u0017\u0011\u001d\t)$\u0005a\u0001\u0003sAq!!\u0011\u0012\u0001\u0004\t)\u0005C\u0004\u0002NE\u0001\r!!\u000f\t\u000f\u0005E\u0013\u00031\u0001\u0002V\u0005YqN\u001a4tKRLe\u000eZ3y+\t\t\u0019\"A\u0005uS6,\u0017J\u001c3fqV\u0011\u0011\u0011E\u0001\u000bg\"|W\u000f\u001c3S_2dG\u0003BAB\u0003\u0013\u00032![AC\u0013\r\t9I\u001b\u0002\b\u0005>|G.Z1o\u0011\u001d\tY\t\u0006a\u0001\u0003\u001b\u000b!B]8mYB\u000b'/Y7t!\u0011\ti!a$\n\u0007\u0005E%M\u0001\u0006S_2d\u0007+\u0019:b[N\fQB]3tSj,\u0017J\u001c3fq\u0016\u001cH\u0003BAL\u0003;\u00032![AM\u0013\r\tYJ\u001b\u0002\u0005+:LG\u000fC\u0004\u0002 V\u0001\r!!\u0012\u0002\tML'0Z\u0001\fg\u0006t\u0017\u000e^=DQ\u0016\u001c7\u000e\u0006\u0003\u0002\u0018\u0006\u0015\u0006bBAT-\u0001\u0007\u00111Q\u0001\u001ai&lW-\u00138eKb4\u0015\u000e\\3OK^d\u0017p\u0011:fCR,G-A\u0004de\u0016\fG/\u001a3\u0002\u0017\r\u0014X-\u0019;fI~#S-\u001d\u000b\u0005\u0003/\u000by\u000bC\u0005\u00022b\t\t\u00111\u0001\u0002:\u0005\u0019\u0001\u0010J\u0019\u0002\u0011\r\u0014X-\u0019;fI\u0002\n\u0001DY=uKN\u001c\u0016N\\2f\u0019\u0006\u001cH/\u00138eKb,e\u000e\u001e:z\u0003q\u0011\u0017\u0010^3t'&t7-\u001a'bgRLe\u000eZ3y\u000b:$(/_0%KF$B!a&\u0002<\"I\u0011\u0011W\u000e\u0002\u0002\u0003\u0007\u0011QI\u0001\u001aEf$Xm]*j]\u000e,G*Y:u\u0013:$W\r_#oiJL\b%A\u000bs_2d\u0017N\\4CCN,G\rV5nKN$\u0018-\u001c9\u0016\u0005\u0005\r\u0007#B5\u0002F\u0006e\u0012bAAdU\n1q\n\u001d;j_:\f\u0011D]8mY&twMQ1tK\u0012$\u0016.\\3ti\u0006l\u0007o\u0018\u0013fcR!\u0011qSAg\u0011%\t\tLHA\u0001\u0002\u0004\t\u0019-\u0001\fs_2d\u0017N\\4CCN,G\rV5nKN$\u0018-\u001c9!Q\ry\u00121\u001b\t\u0004S\u0006U\u0017bAAlU\nAao\u001c7bi&dW-A\tmCN$h\t\\;tQ\u0016$G+[7f\u001bN\fQ\u0003\\1ti\u001acWo\u001d5fIRKW.Z't?\u0012*\u0017\u000f\u0006\u0003\u0002\u0018\u0006}\u0007\"CAYC\u0005\u0005\t\u0019AAb\u0003Ia\u0017m\u001d;GYV\u001c\b.\u001a3US6,Wj\u001d\u0011)\u0007\t\n\u0019.A\u000e`[\u0006DH+[7fgR\fW\u000e]!oI>3gm]3u'>4\u0015M]\u000b\u0003\u0003S\u0004B!!\u0004\u0002l&\u0019\u0011Q\u001e2\u0003\u001fQKW.Z:uC6\u0004xJ\u001a4tKR\fqdX7bqRKW.Z:uC6\u0004\u0018I\u001c3PM\u001a\u001cX\r^*p\r\u0006\u0014x\fJ3r)\u0011\t9*a=\t\u0013\u0005EF%!AA\u0002\u0005%\u0018\u0001H0nCb$\u0016.\\3ti\u0006l\u0007/\u00118e\u001f\u001a47/\u001a;T_\u001a\u000b'\u000f\t\u0015\u0004K\u0005M\u0017AH7bqRKW.Z:uC6\u0004\u0018I\u001c3PM\u001a\u001cX\r^*p\r\u0006\u0014x\fJ3r)\u0011\t9*!@\t\u000f\u0005}h\u00051\u0001\u0002j\u0006yA/[7fgR\fW\u000e](gMN,G/\u0001\u000enCb$\u0016.\\3ti\u0006l\u0007/\u00118e\u001f\u001a47/\u001a;T_\u001a\u000b'/A\tnCb$\u0016.\\3ti\u0006l\u0007oU8GCJ\f\u0011d\u001c4gg\u0016$xJZ'bqRKW.Z:uC6\u00048k\u001c$be\u0006Q2-\u00198D_:4XM\u001d;U_J+G.\u0019;jm\u0016|eMZ:fiR!\u00111\u0011B\u0006\u0011\u001d\u0011ia\u000ba\u0001\u0003s\taa\u001c4gg\u0016$\u0018AB1qa\u0016tG\r\u0006\u0004\u0002\u0018\nM!q\u0003\u0005\b\u0005+a\u0003\u0019AA\u001d\u0003)a\u0017m\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u00053a\u0003\u0019\u0001B\u000e\u0003\u001d\u0011XmY8sIN\u00042A\u001eB\u000f\u0013\r\u0011yb\u001e\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:)\u00071\u0012\u0019\u0003E\u0002p\u0005KI1Aa\nq\u00055qwN\u001c;ie\u0016\fGm]1gK\u0006\u0019RM\\:ve\u0016|eMZ:fi&s'+\u00198hKR!\u0011q\u0013B\u0017\u0011\u001d\u0011i!\fa\u0001\u0003s\tQ#\u001e9eCR,7+Z4nK:$X*\u001a;bI\u0006$\u0018\r\u0006\u0004\u0002\u0018\nM\"q\u0007\u0005\b\u0005kq\u0003\u0019AA#\u0003!\u0001xn]5uS>t\u0007b\u0002B\u001d]\u0001\u0007!1H\u0001\u0006E\u0006$8\r\u001b\t\u0004m\nu\u0012b\u0001B o\nY!+Z2pe\u0012\u0014\u0015\r^2iQ\rq#1E\u0001\u0014CB\u0004XM\u001c3DQVt7N\u0012:p[\u001aKG.\u001a\u000b\t\u0003\u000b\u00129E!\u0013\u0003L!1!\u0011D\u0018A\u0002UDqA!\u000e0\u0001\u0004\t)\u0005C\u0004\u0003N=\u0002\rAa\u0014\u0002\u001d\t,hMZ3s'V\u0004\b\u000f\\5feB!\u0011q\u000bB)\u0013\u0011\u0011\u0019&!\u0017\u0003\u001d\t+hMZ3s'V\u0004\b\u000f\\5fe\u0006q\u0011\r\u001d9f]\u00124%o\\7GS2,GCBA#\u00053\u0012Y\u0006\u0003\u0004\u0003\u001aA\u0002\r!\u001e\u0005\b\u0005;\u0002\u0004\u0019AA#\u0003\u0015\u0019H/\u0019:u\u00039)\b\u000fZ1uKRCh.\u00138eKb$b!a&\u0003d\t5\u0004b\u0002B3c\u0001\u0007!qM\u0001\rG>l\u0007\u000f\\3uK\u0012$\u0006P\u001c\t\u0005\u0003\u001b\u0011I'C\u0002\u0003l\t\u0014AbQ8na2,G/\u001a3Uq:DqAa\u001c2\u0001\u0004\tI$\u0001\tmCN$8\u000b^1cY\u0016|eMZ:fi\"\u001a\u0011Ga\t\u0002'U\u0004H-\u0019;f!J|G-^2feN#\u0018\r^3\u0015\u0011\u0005]%q\u000fBA\u0005\u0007CqA!\u001f3\u0001\u0004\u0011Y(\u0001\u000bqe>$WoY3s'R\fG/Z'b]\u0006<WM\u001d\t\u0005\u0003\u001b\u0011i(C\u0002\u0003\u0000\t\u0014A\u0003\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u0014\bb\u0002B\u001de\u0001\u0007!1\b\u0005\b\u0005\u000b\u0013\u0004\u0019AA\u001d\u00035\u0019WO\u001d:f]R$\u0016.\\3Ng\u0006yAO]1og2\fG/Z(gMN,G\u000f\u0006\u0004\u0003\f\nM&Q\u0017\t\u0005\u0005\u001b\u0013iK\u0004\u0003\u0003\u0010\n%f\u0002\u0002BI\u0005OsAAa%\u0003&:!!Q\u0013BR\u001d\u0011\u00119J!)\u000f\t\te%qT\u0007\u0003\u00057S1A!(g\u0003\u0019a$o\\8u}%\tq0\u0003\u0002~}&\u0011Q\r`\u0005\u0003unL!\u0001_=\n\u0007\t-v/A\u0006GS2,'+Z2pe\u0012\u001c\u0018\u0002\u0002BX\u0005c\u0013\u0011\u0003T8h\u001f\u001a47/\u001a;Q_NLG/[8o\u0015\r\u0011Yk\u001e\u0005\b\u0005\u001b\u0019\u0004\u0019AA\u001d\u0011%\u00119l\rI\u0001\u0002\u0004\t)%\u0001\u000bti\u0006\u0014H/\u001b8h\r&dW\rU8tSRLwN\u001c\u0015\u0004g\tm\u0006cA8\u0003>&\u0019!q\u00189\u0003\u0015QD'/Z1eg\u00064W-A\rue\u0006t7\u000f\\1uK>3gm]3uI\u0011,g-Y;mi\u0012\u0012TC\u0001BcU\u0011\t)Ea2,\u0005\t%\u0007\u0003\u0002Bf\u0005+l!A!4\u000b\t\t='\u0011[\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa5k\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005/\u0014iMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAA]3bIRQ!Q\u001cBu\u0005[\u0014\tP!>\u0011\t\t}'Q]\u0007\u0003\u0005CT1Aa9e\u0003\u0019\u0019XM\u001d<fe&!!q\u001dBq\u000551U\r^2i\t\u0006$\u0018-\u00138g_\"9!1^\u001bA\u0002\u0005e\u0012aC:uCJ$xJ\u001a4tKRDqAa<6\u0001\u0004\t)%A\u0004nCb\u001c\u0016N_3\t\u0013\tMX\u0007%AA\u0002\u0005e\u0012aC7bqB{7/\u001b;j_:D\u0011Ba>6!\u0003\u0005\r!a!\u0002\u001b5Lgn\u00148f\u001b\u0016\u001c8/Y4fQ\r)$1X\u0001\u000fe\u0016\fG\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011yP\u000b\u0003\u0002:\t\u001d\u0017A\u0004:fC\u0012$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007\u000bQC!a!\u0003H\u0006)b-\u001a;dQV\u0003\b/\u001a:C_VtGm\u00144gg\u0016$HCBAb\u0007\u0017\u0019)\u0002C\u0004\u0004\u000ea\u0002\raa\u0004\u0002'M$\u0018M\u001d;PM\u001a\u001cX\r\u001e)pg&$\u0018n\u001c8\u0011\t\u000551\u0011C\u0005\u0004\u0007'\u0011'AD(gMN,G\u000fU8tSRLwN\u001c\u0005\b\u0007/A\u0004\u0019AA#\u0003%1W\r^2i'&TX-A\u0004sK\u000e|g/\u001a:\u0015\r\u0005\u00153QDB\u0010\u0011\u001d\u0011I(\u000fa\u0001\u0005wB\u0011b!\t:!\u0003\u0005\raa\t\u0002!1,\u0017\rZ3s\u000bB|7\r[\"bG\",\u0007#B5\u0002F\u000e\u0015\u0002\u0003BB\u0014\u0007[i!a!\u000b\u000b\t\r-\"\u0011]\u0001\u0006KB|7\r[\u0005\u0005\u0007_\u0019IC\u0001\u000bMK\u0006$WM]#q_\u000eDg)\u001b7f\u0007\u0006\u001c\u0007.\u001a\u0015\u0004s\t\r\u0012!\u0005:fG>4XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u00111q\u0007\u0016\u0005\u0007G\u00119-\u0001\u000bm_\u0006$G*\u0019:hKN$H+[7fgR\fW\u000e\u001d\u000b\u0003\u0003/\u000b1\u0002[1t\u001fZ,'O\u001a7poV\u0011\u00111Q\u0001\u0013G>dG.Z2u\u0003\n|'\u000f^3e)bt7\u000f\u0006\u0004\u0004F\r-3q\n\t\u0005\u0003\u001b\u00199%C\u0002\u0004J\t\u0014A\u0003\u0016=o\u0013:$W\r_*fCJ\u001c\u0007NU3tk2$\bbBB'{\u0001\u0007\u0011\u0011H\u0001\fM\u0016$8\r[(gMN,G\u000fC\u0004\u0004Ru\u0002\r!!\u000f\u0002!U\u0004\b/\u001a:C_VtGm\u00144gg\u0016$\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\r]\u0003\u0003BB-\u0007CrAaa\u0017\u0004^A\u0019!\u0011\u00146\n\u0007\r}#.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0007G\u001a)G\u0001\u0004TiJLgn\u001a\u0006\u0004\u0007?R\u0017A\u0003;sk:\u001c\u0017\r^3U_R!\u0011QIB6\u0011\u001d\u0011ia\u0010a\u0001\u0003sA3a\u0010B\u0012\u00039\u00198-\u00198OKb$xJ\u001a4tKR$\"!!\u000f\u0002#1\f7\u000f^*fO6,g\u000e^(gMN,G\u000f\u0005\u0003\u0004x\r%UBAB=\u0015\u0011\u0019Yh! \u0002\r\u0005$x.\\5d\u0015\u0011\u0019yh!!\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0004\u0004\u000e\u0015\u0015\u0001B;uS2T!aa\"\u0002\t)\fg/Y\u0005\u0005\u0007\u0017\u001bIH\u0001\u0006Bi>l\u0017n\u0019'p]\u001e\faB]3bI:+\u0007\u0010^(gMN,G\u000fK\u0002C\u0005w\u000bQA\u001a7vg\"D3a\u0011B^\u0003=)\b\u000fZ1uKB\u000b'/\u001a8u\t&\u0014H\u0003BAL\u00073Cqaa'E\u0001\u0004\u0019i*A\u0002eSJ\u0004Baa(\u0004&6\u00111\u0011\u0015\u0006\u0005\u0007G\u001b))\u0001\u0002j_&!1qUBQ\u0005\u00111\u0015\u000e\\3\u0002%\rD\u0017M\\4f\r&dWmU;gM&DXm\u001d\u000b\u0007\u0003/\u001bik!-\t\u000f\r=V\t1\u0001\u0004X\u0005Iq\u000e\u001c3Tk\u001a4\u0017\u000e\u001f\u0005\b\u0007g+\u0005\u0019AB,\u0003%qWm^*vM\u001aL\u00070A\u0005iCN\u001cVO\u001a4jqR!\u00111QB]\u0011\u001d\u0019YL\u0012a\u0001\u0007/\naa];gM&D\u0018aF8o\u0005\u0016\u001cw.\\3J]\u0006\u001cG/\u001b<f'\u0016<W.\u001a8u\u0003]aw.\u00193GSJ\u001cHOQ1uG\"$\u0016.\\3ti\u0006l\u0007/A\tuS6,w+Y5uK\u00124uN\u001d*pY2$b!!\u000f\u0004F\u000e%\u0007bBBd\u0013\u0002\u0007\u0011\u0011H\u0001\u0004]><\bbBBf\u0013\u0002\u0007\u0011\u0011H\u0001\u0011[\u0016\u001c8/Y4f)&lWm\u001d;b[B\facZ3u\r&\u00148\u000f\u001e\"bi\u000eDG+[7fgR\fW\u000e]\u0001\u0016M&tGm\u00144gg\u0016$()\u001f+j[\u0016\u001cH/Y7q)\u0019\u0019\u0019na8\u0004dB)\u0011.!2\u0004VB!1q[Bn\u001b\t\u0019IN\u0003\u0002{I&!1Q\\Bm\u0005e1U\r^2iK\u0012$\u0016.\\3ti\u0006l\u0007/\u00118e\u001f\u001a47/\u001a;\t\u000f\r\u00058\n1\u0001\u0002:\u0005IA/[7fgR\fW\u000e\u001d\u0005\n\u0007K\\\u0005\u0013!a\u0001\u0003s\tab\u001d;beRLgnZ(gMN,G/A\u0010gS:$wJ\u001a4tKR\u0014\u0015\u0010V5nKN$\u0018-\u001c9%I\u00164\u0017-\u001e7uII\nQa\u00197pg\u0016\fQb\u00197pg\u0016D\u0015M\u001c3mKJ\u001c\u0018A\u00043fY\u0016$X-\u00134Fq&\u001cHo]\u0001\bI\u0016dW\r^3e)\t\t\u0019)\u0001\u0007mCN$Xj\u001c3jM&,G-\u0001\fmCJ<Wm\u001d;SK\u000e|'\u000f\u001a+j[\u0016\u001cH/Y7q\u0003Aa\u0017M]4fgR$\u0016.\\3ti\u0006l\u0007/\u0001\tmCN$Xj\u001c3jM&,Gm\u0018\u0013fcR!1Q C\u0007!\u0011\u0019y\u0010\"\u0003\u000e\u0005\u0011\u0005!\u0002\u0002C\u0002\t\u000b\tAAZ5mK*!AqABC\u0003\rq\u0017n\\\u0005\u0005\t\u0017!\tA\u0001\u0003QCRD\u0007b\u0002C\b)\u0002\u0007\u0011\u0011H\u0001\u0003[ND3\u0001\u0001B\u0012\u0003)aunZ*fO6,g\u000e\u001e\t\u0004\u0003\u001b16C\u0001,i)\t!)\"A\tV].twn\u001e8MCN$xJ\u001a4tKR\f!#\u00168l]><h\u000eT1ti>3gm]3uA\u0005!q\u000e]3o)I\t)\u0007b\t\u0005&\u0011\u001dB\u0011\u0007C\u001a\to!Y\u0004b\u0010\t\u000f\rm%\f1\u0001\u0004\u001e\"9\u0011Q\u0007.A\u0002\u0005e\u0002b\u0002C\u00155\u0002\u0007A1F\u0001\u0007G>tg-[4\u0011\t\u00055AQF\u0005\u0004\t_\u0011'!\u0003'pO\u000e{gNZ5h\u0011\u001d\t\tF\u0017a\u0001\u0003+B\u0011\u0002\"\u000e[!\u0003\u0005\r!a!\u0002#\u0019LG.Z!me\u0016\fG-_#ySN$8\u000fC\u0005\u0005:i\u0003\n\u00111\u0001\u0002F\u0005a\u0011N\\5u\r&dWmU5{K\"IAQ\b.\u0011\u0002\u0003\u0007\u00111Q\u0001\faJ,\u0017\r\u001c7pG\u0006$X\rC\u0005\u0005Bi\u0003\n\u00111\u0001\u0004X\u0005Qa-\u001b7f'V4g-\u001b=\u0002\u001d=\u0004XM\u001c\u0013eK\u001a\fW\u000f\u001c;%k\u0005qq\u000e]3oI\u0011,g-Y;mi\u00122\u0014AD8qK:$C-\u001a4bk2$HeN\u0001\u000f_B,g\u000e\n3fM\u0006,H\u000e\u001e\u00139+\t!iE\u000b\u0003\u0004X\t\u001dG\u0003CAL\t#\"\u0019\u0006\"\u0016\t\u000f\rmu\f1\u0001\u0004\u001e\"9\u0011QG0A\u0002\u0005e\u0002\"\u0003C!?B\u0005\t\u0019AB,\u0003a!W\r\\3uK&3W\t_5tiN$C-\u001a4bk2$He\r")
public class LogSegment
implements Logging {
    private final FileRecords log;
    private final LazyIndex<OffsetIndex> lazyOffsetIndex;
    private final LazyIndex<TimeIndex> lazyTimeIndex;
    private final TransactionIndex txnIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private volatile Option<Object> rollingBasedTimestamp;
    private volatile Option<Object> lastFlushedTimeMs;
    private volatile TimestampOffset _maxTimestampAndOffsetSoFar;
    private final AtomicLong lastSegmentOffset;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String deleteIfExists$default$3() {
        return "";
    }

    public static String open$default$8() {
        return "";
    }

    public static boolean open$default$7() {
        return false;
    }

    public static int open$default$6() {
        return 0;
    }

    public static boolean open$default$5() {
        return false;
    }

    public static LogSegment open(File dir, long baseOffset, LogConfig config, Time time, boolean fileAlreadyExists, int initFileSize, boolean preallocate, String fileSuffix) {
        return LogSegment$.MODULE$.open(dir, baseOffset, config, time, fileAlreadyExists, initFileSize, preallocate, fileSuffix);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FileRecords log() {
        return this.log;
    }

    public LazyIndex<OffsetIndex> lazyOffsetIndex() {
        return this.lazyOffsetIndex;
    }

    public LazyIndex<TimeIndex> lazyTimeIndex() {
        return this.lazyTimeIndex;
    }

    public TransactionIndex txnIndex() {
        return this.txnIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public Time time() {
        return this.time;
    }

    public OffsetIndex offsetIndex() {
        return this.lazyOffsetIndex().get();
    }

    public TimeIndex timeIndex() {
        return this.lazyTimeIndex().get();
    }

    public boolean shouldRoll(RollParams rollParams) {
        boolean reachedRollMs;
        boolean bl = reachedRollMs = this.timeWaitedForRoll(rollParams.now(), rollParams.maxTimestampInMessages()) > rollParams.maxSegmentMs() - this.rollJitterMs();
        return this.size() > rollParams.maxSegmentBytes() - rollParams.messagesSize() || this.size() > 0 && reachedRollMs || this.offsetIndex().isFull() || this.timeIndex().isFull() || !this.canConvertToRelativeOffset(rollParams.maxOffsetInMessages());
    }

    public void resizeIndexes(int size) {
        ThreadCountersManager.wrapIO(() -> BoxesRunTime.boxToBoolean((boolean)LogSegment.$anonfun$resizeIndexes$1(this, size)));
    }

    public void sanityCheck(boolean timeIndexFileNewlyCreated) {
        ThreadCountersManager.wrapIO(() -> {
            LogSegment.$anonfun$sanityCheck$1(this, timeIndexFileNewlyCreated);
            return BoxedUnit.UNIT;
        });
    }

    private long created() {
        return this.created;
    }

    private void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    public Option<Object> lastFlushedTimeMs() {
        return this.lastFlushedTimeMs;
    }

    public void lastFlushedTimeMs_$eq(Option<Object> x$1) {
        this.lastFlushedTimeMs = x$1;
    }

    private TimestampOffset _maxTimestampAndOffsetSoFar() {
        return this._maxTimestampAndOffsetSoFar;
    }

    private void _maxTimestampAndOffsetSoFar_$eq(TimestampOffset x$1) {
        this._maxTimestampAndOffsetSoFar = x$1;
    }

    public void maxTimestampAndOffsetSoFar_$eq(TimestampOffset timestampOffset) {
        this._maxTimestampAndOffsetSoFar_$eq(timestampOffset);
    }

    public TimestampOffset maxTimestampAndOffsetSoFar() {
        TimestampOffset timestampOffset = this._maxTimestampAndOffsetSoFar();
        TimestampOffset timestampOffset2 = TimestampOffset$.MODULE$.Unknown();
        if (!(timestampOffset != null ? !((Object)timestampOffset).equals(timestampOffset2) : timestampOffset2 != null)) {
            this._maxTimestampAndOffsetSoFar_$eq(this.timeIndex().lastEntry());
        }
        return this._maxTimestampAndOffsetSoFar();
    }

    public long maxTimestampSoFar() {
        return this.maxTimestampAndOffsetSoFar().timestamp();
    }

    public long offsetOfMaxTimestampSoFar() {
        return this.maxTimestampAndOffsetSoFar().offset();
    }

    public int size() {
        return this.log().sizeInBytes();
    }

    public boolean canConvertToRelativeOffset(long offset) {
        return this.offsetIndex().canAppendOffset(offset);
    }

    public void append(long lastOffset, MemoryRecords records) {
        ThreadCountersManager.wrapIO(() -> {
            LogSegment.$anonfun$append$1(this, records, lastOffset);
            return BoxedUnit.UNIT;
        });
    }

    private void ensureOffsetInRange(long offset) {
        if (!this.canConvertToRelativeOffset(offset)) {
            throw new LogSegmentOffsetOverflowException(this, offset);
        }
    }

    private void updateSegmentMetadata(int position, RecordBatch batch) {
        long lastOffset = batch.lastOffset();
        long batchMaxTimestamp = batch.maxTimestamp();
        this.lastSegmentOffset.set(lastOffset);
        this.ensureOffsetInRange(lastOffset);
        if (position == 0) {
            this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)batchMaxTimestamp)));
        }
        if (batchMaxTimestamp > this.maxTimestampSoFar()) {
            this.maxTimestampAndOffsetSoFar_$eq(new TimestampOffset(batchMaxTimestamp, lastOffset));
        }
        if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
            if (!this.offsetIndex().isFull()) {
                SegmentStats$.MODULE$.offsetIndexAppendTimeMs().time((JFunction0.mcV.sp & Serializable)() -> this.offsetIndex().append(lastOffset, position));
            }
            if (!this.timeIndex().isFull()) {
                SegmentStats$.MODULE$.timestampIndexAppendTimeMs().time((JFunction0.mcV.sp & Serializable)() -> {
                    TimeIndex qual$1 = this.timeIndex();
                    long x$1 = this.maxTimestampAndOffsetSoFar().timestamp();
                    long x$2 = this.maxTimestampAndOffsetSoFar().offset();
                    boolean x$3 = qual$1.maybeAppend$default$3();
                    qual$1.maybeAppend(x$1, x$2, x$3);
                });
            }
            this.bytesSinceLastIndexEntry_$eq(0);
        }
        this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + batch.sizeInBytes());
    }

    private int appendChunkFromFile(FileRecords records, int position, BufferSupplier bufferSupplier) {
        IntRef bytesToAppend = IntRef.create((int)0);
        LongRef maxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef offsetOfMaxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef maxOffset = LongRef.create((long)Long.MIN_VALUE);
        ObjectRef readBuffer = ObjectRef.create((Object)bufferSupplier.get(0x100000));
        CollectionConverters$.MODULE$.IterableHasAsScala(records.batchesFrom(position)).asScala().iterator().takeWhile((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)this.canAppend$1(batch, bytesToAppend, readBuffer))).foreach((Function1 & Serializable)batch -> {
            LogSegment.$anonfun$appendChunkFromFile$2(maxTimestamp, offsetOfMaxTimestamp, maxOffset, bytesToAppend, batch);
            return BoxedUnit.UNIT;
        });
        if (bytesToAppend.elem > 0) {
            if (((ByteBuffer)readBuffer.elem).capacity() < bytesToAppend.elem) {
                readBuffer.elem = bufferSupplier.get(bytesToAppend.elem);
            }
            ((ByteBuffer)readBuffer.elem).limit(bytesToAppend.elem);
            records.readInto((ByteBuffer)readBuffer.elem, position);
            ByteBuffer readableRecords_buffer = (ByteBuffer)readBuffer.elem;
            Object var9_9 = null;
            this.append(maxOffset.elem, new MemoryRecords(readableRecords_buffer));
        }
        bufferSupplier.release((ByteBuffer)readBuffer.elem);
        return bytesToAppend.elem;
    }

    public int appendFromFile(FileRecords records, int start) {
        Object object = new Object();
        try {
            return BoxesRunTime.unboxToInt((Object)ThreadCountersManager.wrapIO(() -> BoxesRunTime.boxToInteger((int)LogSegment.$anonfun$appendFromFile$1(this, start, records, object))));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcI$sp();
            }
            throw ex;
        }
    }

    public void updateTxnIndex(CompletedTxn completedTxn, long lastStableOffset) {
        ThreadCountersManager.wrapIO(() -> {
            LogSegment.$anonfun$updateTxnIndex$1(this, completedTxn, lastStableOffset);
            return BoxedUnit.UNIT;
        });
    }

    private void updateProducerState(ProducerStateManager producerStateManager, RecordBatch batch, long currentTimeMs) {
        if (batch.hasProducerId()) {
            long producerId = batch.producerId();
            ProducerAppendInfo appendInfo = producerStateManager.prepareUpdate(producerId, AppendOrigin$Replication$.MODULE$, currentTimeMs);
            Option<CompletedTxn> maybeCompletedTxn = appendInfo.append(batch, (Option<LogOffsetMetadata>)None$.MODULE$);
            producerStateManager.update(appendInfo);
            maybeCompletedTxn.foreach((Function1 & Serializable)completedTxn -> {
                LogSegment.$anonfun$updateProducerState$1(this, producerStateManager, completedTxn);
                return BoxedUnit.UNIT;
            });
        }
        producerStateManager.updateMapEndOffset(batch.lastOffset() + 1L);
    }

    public FileRecords.LogOffsetPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.offsetIndex().lookup(offset);
        return this.log().searchForOffsetWithSize(offset, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        Object object = new Object();
        try {
            return (FetchDataInfo)ThreadCountersManager.wrapIO(() -> {
                int adjustedMaxSize;
                if (maxSize < 0) {
                    throw new IllegalArgumentException(new StringBuilder(44).append("Invalid max size ").append(maxSize).append(" for log read from segment ").append(this.log()).toString());
                }
                FileRecords.LogOffsetPosition startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
                if (startOffsetAndSize == null) {
                    throw new NonLocalReturnControl(object, null);
                }
                int startPosition = startOffsetAndSize.position;
                LogOffsetMetadata offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition);
                int n = adjustedMaxSize = minOneMessage ? package$.MODULE$.max(maxSize, startOffsetAndSize.size) : maxSize;
                if (adjustedMaxSize == 0) {
                    throw new NonLocalReturnControl(object, (Object)new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, false, (Option<List<FetchResponseData.AbortedTransaction>>)None$.MODULE$));
                }
                int fetchSize = package$.MODULE$.min((int)(maxPosition - (long)startPosition), adjustedMaxSize);
                return new FetchDataInfo(offsetMetadata, (Records)this.log().slice(startPosition, fetchSize), adjustedMaxSize < startOffsetAndSize.size, (Option<List<FetchResponseData.AbortedTransaction>>)None$.MODULE$);
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (FetchDataInfo)ex.value();
            }
            throw ex;
        }
    }

    public long read$default$3() {
        return this.size();
    }

    public boolean read$default$4() {
        return false;
    }

    public Option<Object> fetchUpperBoundOffset(OffsetPosition startOffsetPosition, int fetchSize) {
        return (Option)ThreadCountersManager.wrapIO(() -> this.offsetIndex().fetchUpperBoundOffset(startOffsetPosition, fetchSize).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.offset())));
    }

    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochFileCache> leaderEpochCache) {
        return BoxesRunTime.unboxToInt((Object)ThreadCountersManager.wrapIO(() -> BoxesRunTime.boxToInteger((int)LogSegment.$anonfun$recover$1(this, leaderEpochCache, producerStateManager))));
    }

    public Option<LeaderEpochFileCache> recover$default$2() {
        return None$.MODULE$;
    }

    private void loadLargestTimestamp() {
        TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
        this.maxTimestampAndOffsetSoFar_$eq(lastTimeIndexEntry);
        OffsetPosition offsetPosition = this.offsetIndex().lookup(lastTimeIndexEntry.offset());
        FileRecords.FileTimestampAndOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position());
        if (maxTimestampOffsetAfterLastEntry.timestamp > lastTimeIndexEntry.timestamp()) {
            this.maxTimestampAndOffsetSoFar_$eq(new TimestampOffset(maxTimestampOffsetAfterLastEntry.timestamp, maxTimestampOffsetAfterLastEntry.offset));
            return;
        }
    }

    public boolean hasOverflow() {
        long nextOffset = this.readNextOffset();
        return nextOffset > this.baseOffset() && !this.canConvertToRelativeOffset(nextOffset - 1L);
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        return (TxnIndexSearchResult)ThreadCountersManager.wrapIO(() -> this.txnIndex().collectAbortedTxns(fetchOffset, upperBoundOffset));
    }

    public String toString() {
        return new StringBuilder(74).append("LogSegment(baseOffset=").append(this.baseOffset()).append(", size=").append(this.size()).append(", lastModifiedTime=").append(this.lastModified()).append(", largestRecordTimestamp=").append(this.largestRecordTimestamp()).append(")").toString();
    }

    public int truncateTo(long offset) {
        return BoxesRunTime.unboxToInt((Object)ThreadCountersManager.wrapIO(() -> BoxesRunTime.boxToInteger((int)LogSegment.$anonfun$truncateTo$1(this, offset))));
    }

    public long scanNextOffset() {
        return BoxesRunTime.unboxToLong((Object)ThreadCountersManager.wrapIO(() -> BoxesRunTime.boxToLong((long)LogSegment.$anonfun$scanNextOffset$1(this))));
    }

    public long readNextOffset() {
        Object object = new Object();
        try {
            return BoxesRunTime.unboxToLong((Object)ThreadCountersManager.wrapIO(() -> BoxesRunTime.boxToLong((long)LogSegment.$anonfun$readNextOffset$1(this, object))));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcJ$sp();
            }
            throw ex;
        }
    }

    public void flush() {
        ThreadCountersManager.wrapIO(() -> {
            LogSegment.$anonfun$flush$1(this);
            return BoxedUnit.UNIT;
        });
    }

    public void updateParentDir(File dir) {
        ThreadCountersManager.wrapIO(() -> {
            LogSegment.$anonfun$updateParentDir$1(this, dir);
            return BoxedUnit.UNIT;
        });
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        ThreadCountersManager.wrapIO(() -> {
            LogSegment.$anonfun$changeFileSuffixes$1(this, oldSuffix, newSuffix);
            return BoxedUnit.UNIT;
        });
    }

    public boolean hasSuffix(String suffix) {
        return this.log().file().getName().endsWith(suffix) && this.lazyOffsetIndex().file().getName().endsWith(suffix) && this.lazyTimeIndex().file().getName().endsWith(suffix) && this.txnIndex().file().getName().endsWith(suffix);
    }

    public void onBecomeInactiveSegment() {
        ThreadCountersManager.wrapIO(() -> {
            LogSegment.$anonfun$onBecomeInactiveSegment$1(this);
            return BoxedUnit.UNIT;
        });
    }

    private void loadFirstBatchTimestamp() {
        if (this.rollingBasedTimestamp().isEmpty()) {
            Iterator iter = this.log().batches().iterator();
            if (iter.hasNext()) {
                this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)((FileLogInputStream.FileChannelRecordBatch)iter.next()).maxTimestamp())));
                return;
            }
            return;
        }
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        return BoxesRunTime.unboxToLong((Object)ThreadCountersManager.wrapIO(() -> BoxesRunTime.boxToLong((long)LogSegment.$anonfun$timeWaitedForRoll$1(this, messageTimestamp, now))));
    }

    public long getFirstBatchTimestamp() {
        return BoxesRunTime.unboxToLong((Object)ThreadCountersManager.wrapIO(() -> BoxesRunTime.boxToLong((long)LogSegment.$anonfun$getFirstBatchTimestamp$1(this))));
    }

    public Option<FetchedTimestampAndOffset> findOffsetByTimestamp(long timestamp, long startingOffset) {
        return (Option)ThreadCountersManager.wrapIO(() -> {
            TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp);
            int position = this.offsetIndex().lookup(package$.MODULE$.max(timestampOffset.offset(), startingOffset)).position();
            return Option$.MODULE$.apply((Object)this.log().searchForTimestamp(timestamp, position, startingOffset)).map((Function1 & Serializable)found -> {
                if (found.exception == null) {
                    void apply_apply_responseException;
                    void apply_leaderEpoch;
                    Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(found.leaderEpoch)).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$4)));
                    long apply_offset = found.offset;
                    long apply_timestamp = found.timestamp;
                    None$ none$ = None$.MODULE$;
                    None$ apply_apply_followerRestorePoint = None$.MODULE$;
                    return new FetchedTimestampAndOffset(apply_timestamp, apply_offset, (Option<Object>)apply_leaderEpoch, (Option<FollowerRestorePoint>)apply_apply_followerRestorePoint, (Option<Exception>)apply_apply_responseException);
                }
                return FetchedTimestampAndOffset$.MODULE$.apply(found.exception);
            });
        });
    }

    public long findOffsetByTimestamp$default$2() {
        return this.baseOffset();
    }

    public void close() {
        ThreadCountersManager.wrapIO(() -> {
            LogSegment.$anonfun$close$1(this);
            return BoxedUnit.UNIT;
        });
    }

    public void closeHandlers() {
        ThreadCountersManager.wrapIO(() -> {
            LogSegment.$anonfun$closeHandlers$1(this);
            return BoxedUnit.UNIT;
        });
    }

    public void deleteIfExists() {
        ThreadCountersManager.wrapIO(() -> {
            CoreUtils$.MODULE$.tryAll((Seq<Function0<BoxedUnit>>)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> {
                boolean bl = true;
                File delete$1_file = $this.log().file();
                String delete$1_fileType = "log";
                try {
                    void delete$1_logIfMissing;
                    if (LogSegment.$anonfun$deleteIfExists$5($this)) {
                        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                    } else if (delete$1_logIfMissing != false) {
                        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                    }
                }
                catch (IOException delete$1_e) {
                    throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
                }
            }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> {
                boolean bl = true;
                File delete$1_file = $this.lazyOffsetIndex().file();
                String delete$1_fileType = "offset index";
                try {
                    void delete$1_logIfMissing;
                    if (LogSegment.$anonfun$deleteIfExists$7($this)) {
                        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                    } else if (delete$1_logIfMissing != false) {
                        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                    }
                }
                catch (IOException delete$1_e) {
                    throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
                }
            }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> {
                boolean bl = true;
                File delete$1_file = $this.lazyTimeIndex().file();
                String delete$1_fileType = "time index";
                try {
                    void delete$1_logIfMissing;
                    if (LogSegment.$anonfun$deleteIfExists$9($this)) {
                        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                    } else if (delete$1_logIfMissing != false) {
                        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                    }
                }
                catch (IOException delete$1_e) {
                    throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
                }
            }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> {
                boolean bl = false;
                File delete$1_file = $this.txnIndex().file();
                String delete$1_fileType = "transaction index";
                try {
                    void delete$1_logIfMissing;
                    if (LogSegment.$anonfun$deleteIfExists$11($this)) {
                        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                    } else if (delete$1_logIfMissing != false) {
                        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                    }
                }
                catch (IOException delete$1_e) {
                    throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
                }
            }, (List)Nil$.MODULE$)))));
            return BoxedUnit.UNIT;
        });
        this.lastSegmentOffset.set(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset());
    }

    public boolean deleted() {
        return BoxesRunTime.unboxToBoolean((Object)ThreadCountersManager.wrapIO(() -> BoxesRunTime.boxToBoolean((boolean)LogSegment.$anonfun$deleted$1(this))));
    }

    public long lastModified() {
        return BoxesRunTime.unboxToLong((Object)ThreadCountersManager.wrapIO(() -> BoxesRunTime.boxToLong((long)LogSegment.$anonfun$lastModified$1(this))));
    }

    public Option<Object> largestRecordTimestamp() {
        if (this.maxTimestampSoFar() >= 0L) {
            return new Some((Object)BoxesRunTime.boxToLong((long)this.maxTimestampSoFar()));
        }
        return None$.MODULE$;
    }

    public long largestTimestamp() {
        if (this.maxTimestampSoFar() >= 0L) {
            return this.maxTimestampSoFar();
        }
        return this.lastModified();
    }

    public Path lastModified_$eq(long ms) {
        FileTime fileTime = FileTime.fromMillis(ms);
        FilesWrapper.setLastModifiedTime((Path)this.log().file().toPath(), (FileTime)fileTime);
        FilesWrapper.setLastModifiedTime((Path)this.lazyOffsetIndex().file().toPath(), (FileTime)fileTime);
        return FilesWrapper.setLastModifiedTime((Path)this.lazyTimeIndex().file().toPath(), (FileTime)fileTime);
    }

    public static final /* synthetic */ boolean $anonfun$resizeIndexes$1(LogSegment $this, int size$1) {
        $this.offsetIndex().resize(size$1);
        return $this.timeIndex().resize(size$1);
    }

    public static final /* synthetic */ void $anonfun$sanityCheck$1(LogSegment $this, boolean timeIndexFileNewlyCreated$1) {
        if ($this.lazyOffsetIndex().file().exists()) {
            if (timeIndexFileNewlyCreated$1) {
                $this.timeIndex().resize(0);
            }
            $this.txnIndex().sanityCheck();
            return;
        }
        throw new NoSuchFileException(new StringBuilder(33).append("Offset index file ").append($this.lazyOffsetIndex().file().getAbsolutePath()).append(" does not exist").toString());
    }

    public static final /* synthetic */ void $anonfun$append$1(LogSegment $this, MemoryRecords records$1, long lastOffset$1) {
        if (records$1.sizeInBytes() > 0) {
            IntRef position = IntRef.create((int)$this.log().sizeInBytes());
            boolean traceEnabled = $this.isTraceEnabled();
            if (traceEnabled) {
                $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Inserting ").append(records$1.sizeInBytes()).append(" bytes at end offset ").append(lastOffset$1).append(" at position ").append($this.log().sizeInBytes()).toString());
            }
            $this.ensureOffsetInRange(lastOffset$1);
            int appendedBytes = BoxesRunTime.unboxToInt(SegmentStats$.MODULE$.segmentAppendTimeMs().time((JFunction0.mcI.sp & Serializable)() -> $this.log().append(records$1)));
            if (traceEnabled) {
                $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Appended ").append(appendedBytes).append(" to ").append($this.log().file()).append(" at end offset ").append(lastOffset$1).toString());
            }
            records$1.batches().forEach(batch -> {
                $this.updateSegmentMetadata(position$1.elem, (RecordBatch)batch);
                position$1.elem += batch.sizeInBytes();
            });
            return;
        }
    }

    private final boolean canAppend$1(RecordBatch batch, IntRef bytesToAppend$1, ObjectRef readBuffer$1) {
        return this.canConvertToRelativeOffset(batch.lastOffset()) && (bytesToAppend$1.elem == 0 || bytesToAppend$1.elem + batch.sizeInBytes() < ((ByteBuffer)readBuffer$1.elem).capacity());
    }

    public static final /* synthetic */ void $anonfun$appendChunkFromFile$2(LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, LongRef maxOffset$1, IntRef bytesToAppend$1, FileLogInputStream.FileChannelRecordBatch batch) {
        if (batch.maxTimestamp() > maxTimestamp$1.elem) {
            maxTimestamp$1.elem = batch.maxTimestamp();
            offsetOfMaxTimestamp$1.elem = batch.lastOffset();
        }
        maxOffset$1.elem = batch.lastOffset();
        bytesToAppend$1.elem += batch.sizeInBytes();
    }

    public static final /* synthetic */ int $anonfun$appendFromFile$1(LogSegment $this, int start$1, FileRecords records$2, Object nonLocalReturnKey1$1) {
        int position;
        int bytesAppended;
        BufferSupplier.GrowableBufferSupplier bufferSupplier = new BufferSupplier.GrowableBufferSupplier();
        for (position = start$1; position < start$1 + records$2.sizeInBytes(); position += bytesAppended) {
            bytesAppended = $this.appendChunkFromFile(records$2, position, (BufferSupplier)bufferSupplier);
            if (bytesAppended != 0) continue;
            throw new NonLocalReturnControl.mcI.sp(nonLocalReturnKey1$1, position - start$1);
        }
        return position - start$1;
    }

    public static final /* synthetic */ void $anonfun$updateTxnIndex$1(LogSegment $this, CompletedTxn completedTxn$1, long lastStableOffset$1) {
        if (completedTxn$1.isAborted()) {
            $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(73).append("Writing aborted transaction ").append(completedTxn$1).append(" to transaction index, last stable offset is ").append(lastStableOffset$1).toString());
            $this.txnIndex().append(new AbortedTxn(completedTxn$1, lastStableOffset$1));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateProducerState$1(LogSegment $this, ProducerStateManager producerStateManager$1, CompletedTxn completedTxn) {
        long lastStableOffset = producerStateManager$1.proposedLastStableOffset(completedTxn);
        $this.updateTxnIndex(completedTxn, lastStableOffset);
        producerStateManager$1.completeTxn(completedTxn);
    }

    public static final /* synthetic */ void $anonfun$recover$3(FileLogInputStream.FileChannelRecordBatch batch$1, LeaderEpochFileCache cache) {
        if (batch$1.partitionLeaderEpoch() >= 0 && cache.latestEpoch().forall((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> batch$1.partitionLeaderEpoch() > x$2)) {
            cache.assign(batch$1.partitionLeaderEpoch(), batch$1.baseOffset());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$recover$2(LogSegment $this, IntRef validBytes$1, Option leaderEpochCache$1, ProducerStateManager producerStateManager$2, long currentTimeMs$1, FileLogInputStream.FileChannelRecordBatch batch) {
        batch.ensureValid();
        $this.updateSegmentMetadata(validBytes$1.elem, (RecordBatch)batch);
        validBytes$1.elem += batch.sizeInBytes();
        if (batch.magic() >= 2) {
            leaderEpochCache$1.foreach((Function1 & Serializable)cache -> {
                LogSegment.$anonfun$recover$3(batch, cache);
                return BoxedUnit.UNIT;
            });
            $this.updateProducerState(producerStateManager$2, (RecordBatch)batch, currentTimeMs$1);
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$recover$1(LogSegment $this, Option leaderEpochCache$1, ProducerStateManager producerStateManager$2) {
        $this.offsetIndex().reset();
        $this.timeIndex().reset();
        $this.txnIndex().reset();
        IntRef validBytes = IntRef.create((int)0);
        $this.maxTimestampAndOffsetSoFar_$eq(TimestampOffset$.MODULE$.Unknown());
        try {
            long currentTimeMs = $this.time().milliseconds();
            CollectionConverters$.MODULE$.IterableHasAsScala($this.log().batches()).asScala().foreach((Function1 & Serializable)batch -> {
                LogSegment.$anonfun$recover$2($this, validBytes, leaderEpochCache$1, producerStateManager$2, currentTimeMs, batch);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            if (throwable instanceof CorruptRecordException ? true : throwable instanceof InvalidRecordException) {
                $this.warn((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s. %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{$this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)validBytes$1.elem), throwable.getMessage(), throwable.getCause()})));
            }
            throw throwable;
        }
        int truncated = $this.log().sizeInBytes() - validBytes.elem;
        if (truncated > 0) {
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Truncated ").append(truncated).append(" invalid bytes at the end of segment ").append($this.log().file().getAbsoluteFile()).append(" during recovery").toString());
        }
        $this.log().truncateTo(validBytes.elem);
        $this.offsetIndex().trimToValidSize();
        $this.timeIndex().maybeAppend($this.maxTimestampSoFar(), $this.offsetOfMaxTimestampSoFar(), true);
        $this.timeIndex().trimToValidSize();
        return truncated;
    }

    public static final /* synthetic */ int $anonfun$truncateTo$1(LogSegment $this, long offset$1) {
        int bytesTruncated;
        FileRecords.LogOffsetPosition mapping = $this.translateOffset(offset$1, $this.translateOffset$default$2());
        $this.offsetIndex().truncateTo(offset$1);
        $this.timeIndex().truncateTo(offset$1);
        $this.txnIndex().truncateTo(offset$1);
        $this.offsetIndex().resize($this.offsetIndex().maxIndexSize());
        $this.timeIndex().resize($this.timeIndex().maxIndexSize());
        int n = bytesTruncated = mapping == null ? 0 : $this.log().truncateTo(mapping.position);
        if ($this.log().sizeInBytes() == 0) {
            $this.created_$eq($this.time().milliseconds());
            $this.rollingBasedTimestamp_$eq((Option<Object>)None$.MODULE$);
        }
        $this.bytesSinceLastIndexEntry_$eq(0);
        if ($this.maxTimestampSoFar() >= 0L) {
            $this.loadLargestTimestamp();
        }
        $this.lastSegmentOffset.set(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset());
        return bytesTruncated;
    }

    public static final /* synthetic */ long $anonfun$scanNextOffset$1(LogSegment $this) {
        FetchDataInfo fetchData = $this.read($this.offsetIndex().lastOffset(), $this.log().sizeInBytes(), $this.read$default$3(), $this.read$default$4());
        if (fetchData == null) {
            return $this.baseOffset();
        }
        return BoxesRunTime.unboxToLong((Object)CollectionConverters$.MODULE$.IterableHasAsScala(fetchData.records().batches()).asScala().lastOption().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.nextOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> $this.baseOffset()));
    }

    public static final /* synthetic */ long $anonfun$readNextOffset$1(LogSegment $this, Object nonLocalReturnKey3$1) {
        long scannedNextOffset;
        $this.lastSegmentOffset.get();
        do {
            long cachedLastSegmentOffset;
            if ((cachedLastSegmentOffset = $this.lastSegmentOffset.get()) != LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset()) {
                throw new NonLocalReturnControl.mcJ.sp(nonLocalReturnKey3$1, cachedLastSegmentOffset + 1L);
            }
            scannedNextOffset = $this.scanNextOffset();
        } while (!$this.lastSegmentOffset.compareAndSet(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset(), scannedNextOffset - 1L));
        return scannedNextOffset;
    }

    public static final /* synthetic */ void $anonfun$flush$1(LogSegment $this) {
        LogFlushStats$.MODULE$.logFlushTimer().time((JFunction0.mcV.sp & Serializable)() -> {
            $this.log().flush();
            $this.offsetIndex().flush();
            $this.timeIndex().flush();
            $this.txnIndex().flush();
            $this.lastFlushedTimeMs_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)$this.time().milliseconds())));
        });
    }

    public static final /* synthetic */ void $anonfun$updateParentDir$1(LogSegment $this, File dir$1) {
        $this.log().updateParentDir(dir$1);
        $this.lazyOffsetIndex().updateParentDir(dir$1);
        $this.lazyTimeIndex().updateParentDir(dir$1);
        $this.txnIndex().updateParentDir(dir$1);
    }

    public static final /* synthetic */ void $anonfun$changeFileSuffixes$1(LogSegment $this, String oldSuffix$1, String newSuffix$1) {
        $this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix($this.log().file().getPath(), oldSuffix$1, newSuffix$1)));
        $this.lazyOffsetIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix($this.lazyOffsetIndex().file().getPath(), oldSuffix$1, newSuffix$1)));
        $this.lazyTimeIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix($this.lazyTimeIndex().file().getPath(), oldSuffix$1, newSuffix$1)));
        $this.txnIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix($this.txnIndex().file().getPath(), oldSuffix$1, newSuffix$1)));
    }

    public static final /* synthetic */ void $anonfun$onBecomeInactiveSegment$1(LogSegment $this) {
        $this.timeIndex().maybeAppend($this.maxTimestampSoFar(), $this.offsetOfMaxTimestampSoFar(), true);
        $this.offsetIndex().trimToValidSize();
        $this.timeIndex().trimToValidSize();
        $this.log().trim();
    }

    public static final /* synthetic */ long $anonfun$timeWaitedForRoll$1(LogSegment $this, long messageTimestamp$1, long now$1) {
        long t;
        $this.loadFirstBatchTimestamp();
        Option<Object> option = $this.rollingBasedTimestamp();
        if (option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)((Some)option).value())) >= 0L) {
            return messageTimestamp$1 - t;
        }
        return now$1 - $this.created();
    }

    public static final /* synthetic */ long $anonfun$getFirstBatchTimestamp$1(LogSegment $this) {
        long t;
        $this.loadFirstBatchTimestamp();
        Option<Object> option = $this.rollingBasedTimestamp();
        if (option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)((Some)option).value())) >= 0L) {
            return t;
        }
        return Long.MAX_VALUE;
    }

    public static final /* synthetic */ void $anonfun$close$1(LogSegment $this) {
        TimestampOffset timestampOffset = $this._maxTimestampAndOffsetSoFar();
        TimestampOffset timestampOffset2 = TimestampOffset$.MODULE$.Unknown();
        if (timestampOffset == null ? timestampOffset2 != null : !((Object)timestampOffset).equals(timestampOffset2)) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.timeIndex().maybeAppend($this.maxTimestampSoFar(), $this.offsetOfMaxTimestampSoFar(), true), $this, Level.WARN);
        }
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.lazyOffsetIndex().close(), $this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.lazyTimeIndex().close(), $this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.log().close(), $this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.txnIndex().close(), $this, Level.WARN);
        $this.lastSegmentOffset.set(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset());
    }

    public static final /* synthetic */ void $anonfun$closeHandlers$1(LogSegment $this) {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.lazyOffsetIndex().closeHandler(), $this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.lazyTimeIndex().closeHandler(), $this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.log().closeHandlers(), $this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.txnIndex().close(), $this, Level.WARN);
    }

    private final void delete$1(Function0 delete, String fileType, File file, boolean logIfMissing) {
        try {
            if (delete.apply$mcZ$sp()) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
            } else if (logIfMissing) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
            }
        }
        catch (IOException e) {
            throw new IOException(new StringBuilder(19).append("Delete of ").append(fileType).append(" ").append(file.getAbsolutePath()).append(" failed.").toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$5(LogSegment $this) {
        return $this.log().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$7(LogSegment $this) {
        return $this.lazyOffsetIndex().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$9(LogSegment $this) {
        return $this.lazyTimeIndex().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$11(LogSegment $this) {
        return $this.txnIndex().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleted$1(LogSegment $this) {
        return !$this.log().file().exists() && !$this.lazyOffsetIndex().file().exists() && !$this.lazyTimeIndex().file().exists() && !$this.txnIndex().file().exists();
    }

    public static final /* synthetic */ long $anonfun$lastModified$1(LogSegment $this) {
        return $this.log().file().lastModified();
    }

    public LogSegment(FileRecords log, LazyIndex<OffsetIndex> lazyOffsetIndex, LazyIndex<TimeIndex> lazyTimeIndex, TransactionIndex txnIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.lazyOffsetIndex = lazyOffsetIndex;
        this.lazyTimeIndex = lazyTimeIndex;
        this.txnIndex = txnIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this.lastFlushedTimeMs = None$.MODULE$;
        this._maxTimestampAndOffsetSoFar = TimestampOffset$.MODULE$.Unknown();
        this.lastSegmentOffset = new AtomicLong(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset());
    }
}

