/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import kafka.log.AbstractIndex;
import kafka.log.CorruptIndexException;
import kafka.log.IndexSearchType$KEY$;
import kafka.log.IndexSearchType$VALUE$;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.Logging;
import kafka.utils.Logging$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ud\u0001\u0002\u0011\"\u0001\u0019B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\ni\u0001\u0011\t\u0011)A\u0005kmB\u0011\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010!\t\u0013\u0005\u0003!\u0011!Q\u0001\n\t+\u0005\"\u0003$\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"H\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0011\u0019\u0011\u0006\u0001)Q\u0005k!)1\u000b\u0001C\u0005)\")\u0001\f\u0001C\u00013\")!\f\u0001C\u00017\")a\f\u0001C\u0001?\")q\r\u0001C\u0005Q\")1\u000f\u0001C\u0005i\")q\u000f\u0001C)q\")1\u0010\u0001C\u0001y\")a\u0010\u0001C\u0001\u007f\"9\u0011q\u0002\u0001\u0005B\u0005E\u0001bBA\n\u0001\u0011\u0005\u0013Q\u0003\u0005\b\u00033\u0001A\u0011BA\u000e\u0011\u001d\t\t\u0003\u0001C!\u0003#AA\"a\t\u0001!\u0003\r\t\u0011!C\u0005#\u0002CA\"!\n\u0001!\u0003\r\t\u0011!C\u00053n:q!a\n\"\u0011\u0003\tIC\u0002\u0004!C!\u0005\u00111\u0006\u0005\u0007\u0011f!\t!a\u0010\t\u0013\u0005\u0005\u0013D1A\u0005B\u0005\r\u0003\u0002CA.3\u0001\u0006I!!\u0012\t\u0013\u0005u\u0013$%A\u0005\u0002\u0005}\u0003\"CA;3E\u0005I\u0011AA<\u0011%\tY(GI\u0001\n\u0003\t9HA\u0006PM\u001a\u001cX\r^%oI\u0016D(B\u0001\u0012$\u0003\rawn\u001a\u0006\u0002I\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001(!\tA\u0013&D\u0001\"\u0013\tQ\u0013EA\u0007BEN$(/Y2u\u0013:$W\r_\u0001\u0006?\u001aLG.\u001a\t\u0003[Ij\u0011A\f\u0006\u0003_A\n!![8\u000b\u0003E\nAA[1wC&\u00111G\f\u0002\u0005\r&dW-\u0001\u0006cCN,wJ\u001a4tKR\u0004\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012A\u0001T8oO&\u0011A'K\u0001\r[\u0006D\u0018J\u001c3fqNK'0\u001a\t\u0003myJ!aP\u001c\u0003\u0007%sG/\u0003\u0002=S\u0005\tb-\u001b7f\u00032\u0014X-\u00193z\u000bbL7\u000f^:\u0011\u0005Y\u001a\u0015B\u0001#8\u0005\u001d\u0011un\u001c7fC:L!!Q\u0015\u0002\u0011]\u0014\u0018\u000e^1cY\u0016L!AR\u0015\u0002\rqJg.\u001b;?)\u0019Q5\nT'O\u001fB\u0011\u0001\u0006\u0001\u0005\u0006W\u0019\u0001\r\u0001\f\u0005\u0006i\u0019\u0001\r!\u000e\u0005\by\u0019\u0001\n\u00111\u0001>\u0011\u001d\te\u0001%AA\u0002\tCqA\u0012\u0004\u0011\u0002\u0003\u0007!)A\u0005f]R\u0014\u0018pU5{KV\tQ(A\u0006`Y\u0006\u001cHo\u00144gg\u0016$\u0018!\u00037bgR,e\u000e\u001e:z+\u0005)\u0006C\u0001\u0015W\u0013\t9\u0016E\u0001\bPM\u001a\u001cX\r\u001e)pg&$\u0018n\u001c8\u0002\u00151\f7\u000f^(gMN,G/F\u00016\u0003\u0019awn\\6vaR\u0011Q\u000b\u0018\u0005\u0006;.\u0001\r!N\u0001\ri\u0006\u0014x-\u001a;PM\u001a\u001cX\r^\u0001\u0016M\u0016$8\r[+qa\u0016\u0014(i\\;oI>3gm]3u)\r\u00017-\u001a\t\u0004m\u0005,\u0016B\u000128\u0005\u0019y\u0005\u000f^5p]\")A\r\u0004a\u0001+\u0006Ya-\u001a;dQ>3gm]3u\u0011\u00151G\u00021\u0001>\u0003%1W\r^2i'&TX-\u0001\bsK2\fG/\u001b<f\u001f\u001a47/\u001a;\u0015\u0007uJ\u0017\u000fC\u0003k\u001b\u0001\u00071.\u0001\u0004ck\u001a4WM\u001d\t\u0003Y>l\u0011!\u001c\u0006\u0003]B\n1A\\5p\u0013\t\u0001XN\u0001\u0006CsR,')\u001e4gKJDQA]\u0007A\u0002u\n\u0011A\\\u0001\ta\"L8/[2bYR\u0019Q(\u001e<\t\u000b)t\u0001\u0019A6\t\u000bIt\u0001\u0019A\u001f\u0002\u0015A\f'o]3F]R\u0014\u0018\u0010F\u0002VsjDQA[\bA\u0002-DQA]\bA\u0002u\nQ!\u001a8uef$\"!V?\t\u000bI\u0004\u0002\u0019A\u001f\u0002\r\u0005\u0004\b/\u001a8e)\u0019\t\t!a\u0002\u0002\fA\u0019a'a\u0001\n\u0007\u0005\u0015qG\u0001\u0003V]&$\bBBA\u0005#\u0001\u0007Q'\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\u0007\u0003\u001b\t\u0002\u0019A\u001f\u0002\u0011A|7/\u001b;j_:\f\u0001\u0002\u001e:v]\u000e\fG/\u001a\u000b\u0003\u0003\u0003\t!\u0002\u001e:v]\u000e\fG/\u001a+p)\u0011\t\t!a\u0006\t\r\u0005%1\u00031\u00016\u0003E!(/\u001e8dCR,Gk\\#oiJLWm\u001d\u000b\u0005\u0003\u0003\ti\u0002\u0003\u0004\u0002 Q\u0001\r!P\u0001\bK:$(/[3t\u0003-\u0019\u0018M\\5us\u000eCWmY6\u0002%M,\b/\u001a:%[\u0006D\u0018J\u001c3fqNK'0Z\u0001\u0011gV\u0004XM\u001d\u0013cCN,wJ\u001a4tKR\f1b\u00144gg\u0016$\u0018J\u001c3fqB\u0011\u0001&G\n\u00063\u00055\u00121\u0007\t\u0004m\u0005=\u0012bAA\u0019o\t1\u0011I\\=SK\u001a\u0004B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003s\u0019\u0013!B;uS2\u001c\u0018\u0002BA\u001f\u0003o\u0011q\u0001T8hO&tw\r\u0006\u0002\u0002*\u0005QAn\\4hKJt\u0015-\\3\u0016\u0005\u0005\u0015\u0003\u0003BA$\u0003+rA!!\u0013\u0002RA\u0019\u00111J\u001c\u000e\u0005\u00055#bAA(K\u00051AH]8pizJ1!a\u00158\u0003\u0019\u0001&/\u001a3fM&!\u0011qKA-\u0005\u0019\u0019FO]5oO*\u0019\u00111K\u001c\u0002\u00171|wmZ3s\u001d\u0006lW\rI\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0005$fA\u001f\u0002d-\u0012\u0011Q\r\t\u0005\u0003O\n\t(\u0004\u0002\u0002j)!\u00111NA7\u0003%)hn\u00195fG.,GMC\u0002\u0002p]\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019(!\u001b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003sR3AQA2\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u0001")
public class OffsetIndex
extends AbstractIndex {
    private long _lastOffset = this.lastEntry().offset();

    public static boolean $lessinit$greater$default$5() {
        return true;
    }

    public static boolean $lessinit$greater$default$4() {
        return false;
    }

    public static int $lessinit$greater$default$3() {
        return -1;
    }

    public static String loggerName() {
        return OffsetIndex$.MODULE$.loggerName();
    }

    public static void fatal(Function0<String> msg, Function0<Throwable> e) {
        OffsetIndex$ fatal_this = OffsetIndex$.MODULE$;
        if (fatal_this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var3_3 = null;
            fatal_this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), Logging.msgWithLogIdent$(fatal_this, msgWithLogIdent_msg), (Throwable)e.apply());
            return;
        }
    }

    public static void fatal(Function0<String> msg) {
        OffsetIndex$ fatal_this = OffsetIndex$.MODULE$;
        if (fatal_this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var2_2 = null;
            fatal_this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), Logging.msgWithLogIdent$(fatal_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static void error(Function0<String> msg, Function0<Throwable> e) {
        OffsetIndex$ error_this = OffsetIndex$.MODULE$;
        if (error_this.logger().underlying().isErrorEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var3_3 = null;
            error_this.logger().underlying().error(Logging.msgWithLogIdent$(error_this, msgWithLogIdent_msg), (Throwable)e.apply());
            return;
        }
    }

    public static void error(Function0<String> msg) {
        OffsetIndex$ error_this = OffsetIndex$.MODULE$;
        if (error_this.logger().underlying().isErrorEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var2_2 = null;
            error_this.logger().underlying().error(Logging.msgWithLogIdent$(error_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static void warn(Function0<String> msg, Function0<Throwable> e) {
        OffsetIndex$ warn_this = OffsetIndex$.MODULE$;
        if (warn_this.logger().underlying().isWarnEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var3_3 = null;
            warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg), (Throwable)e.apply());
            return;
        }
    }

    public static void warn(Function0<String> msg) {
        OffsetIndex$ warn_this = OffsetIndex$.MODULE$;
        if (warn_this.logger().underlying().isWarnEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var2_2 = null;
            warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static void info(Function0<String> msg, Function0<Throwable> e) {
        OffsetIndex$ info_this = OffsetIndex$.MODULE$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var3_3 = null;
            info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg), (Throwable)e.apply());
            return;
        }
    }

    public static void info(Function0<String> msg) {
        OffsetIndex$ info_this = OffsetIndex$.MODULE$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var2_2 = null;
            info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static void debug(Function0<String> msg, Function0<Throwable> e) {
        OffsetIndex$ debug_this = OffsetIndex$.MODULE$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var3_3 = null;
            debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg), (Throwable)e.apply());
            return;
        }
    }

    public static void debug(Function0<String> msg) {
        OffsetIndex$ debug_this = OffsetIndex$.MODULE$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var2_2 = null;
            debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(OffsetIndex$.MODULE$);
    }

    public static boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(OffsetIndex$.MODULE$);
    }

    public static void trace(Function0<String> msg, Function0<Throwable> e) {
        OffsetIndex$ trace_this = OffsetIndex$.MODULE$;
        if (trace_this.logger().underlying().isTraceEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var3_3 = null;
            trace_this.logger().underlying().trace(Logging.msgWithLogIdent$(trace_this, msgWithLogIdent_msg), (Throwable)e.apply());
            return;
        }
    }

    public static void trace(Function0<String> msg) {
        OffsetIndex$ trace_this = OffsetIndex$.MODULE$;
        if (trace_this.logger().underlying().isTraceEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var2_2 = null;
            trace_this.logger().underlying().trace(Logging.msgWithLogIdent$(trace_this, msgWithLogIdent_msg));
            return;
        }
    }

    private /* synthetic */ int super$maxIndexSize() {
        return super.maxIndexSize();
    }

    private /* synthetic */ long super$baseOffset() {
        return super.baseOffset();
    }

    @Override
    public int entrySize() {
        return 8;
    }

    private OffsetPosition lastEntry() {
        OffsetPosition offsetPosition;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            offsetPosition = OffsetIndex.$anonfun$lastEntry$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return offsetPosition;
    }

    public long lastOffset() {
        return this._lastOffset;
    }

    public OffsetPosition lookup(long targetOffset) {
        return (OffsetPosition)this.maybeLock(this.lock(), (Function0 & Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, targetOffset, IndexSearchType$KEY$.MODULE$);
            if (slot == -1) {
                return new OffsetPosition(this.super$baseOffset(), 0);
            }
            return this.parseEntry(idx, slot);
        });
    }

    public Option<OffsetPosition> fetchUpperBoundOffset(OffsetPosition fetchOffset, int fetchSize) {
        return (Option)this.maybeLock(this.lock(), (Function0 & Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.smallestUpperBoundSlotFor(idx, fetchOffset.position() + fetchSize, IndexSearchType$VALUE$.MODULE$);
            if (slot == -1) {
                return None$.MODULE$;
            }
            return new Some((Object)this.parseEntry(idx, slot));
        });
    }

    private int relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize());
    }

    private int physical(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 4);
    }

    @Override
    public OffsetPosition parseEntry(ByteBuffer buffer, int n) {
        return new OffsetPosition(super.baseOffset() + (long)this.relativeOffset(buffer, n), this.physical(buffer, n));
    }

    public OffsetPosition entry(int n) {
        return (OffsetPosition)this.maybeLock(this.lock(), (Function0 & Serializable)() -> {
            if (n >= this._entries()) {
                throw new IllegalArgumentException(new StringBuilder(59).append("Attempt to fetch the ").append(n).append("th entry from index ").append(this.file().getAbsolutePath()).append(", ").append("which has size ").append(this._entries()).append(".").toString());
            }
            return this.parseEntry(this.mmap(), n);
        });
    }

    public void append(long offset, int position) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            OffsetIndex.$anonfun$append$1(this, offset, position);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    @Override
    public void truncate() {
        this.truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            OffsetIndex.$anonfun$truncateTo$1(this, offset);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    private void truncateToEntries(int entries) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            OffsetIndex.$anonfun$truncateToEntries$1(this, entries);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    @Override
    public void sanityCheck() {
        if (this._entries() != 0 && this._lastOffset < super.baseOffset()) {
            throw new CorruptIndexException(new StringBuilder(113).append("Corrupt index found, index file (").append(this.file().getAbsolutePath()).append(") has non-zero size ").append("but the last offset is ").append(this._lastOffset).append(" which is less than the base offset ").append(super.baseOffset()).append(".").toString());
        }
        if (this.length() % (long)this.entrySize() != 0L) {
            throw new CorruptIndexException(new StringBuilder(82).append("Index file ").append(this.file().getAbsolutePath()).append(" is corrupt, found ").append(this.length()).append(" bytes which is ").append("neither positive nor a multiple of ").append(this.entrySize()).append(".").toString());
        }
    }

    public static final /* synthetic */ String $anonfun$new$1(OffsetIndex $this) {
        return new StringBuilder(99).append("Loaded index file ").append($this.file().getAbsolutePath()).append(" with maxEntries = ").append($this.maxEntries()).append(", ").append("maxIndexSize = ").append($this.super$maxIndexSize()).append(", entries = ").append($this._entries()).append(", lastOffset = ").append($this._lastOffset).append(", file position = ").append($this.mmap().position()).toString();
    }

    public static final /* synthetic */ OffsetPosition $anonfun$lastEntry$1(OffsetIndex $this) {
        int n = $this._entries();
        switch (n) {
            case 0: {
                return new OffsetPosition($this.super$baseOffset(), 0);
            }
        }
        return $this.parseEntry($this.mmap(), n - 1);
    }

    public static final /* synthetic */ String $anonfun$append$3(OffsetIndex $this, long offset$1, int position$1) {
        return new StringBuilder(27).append("Adding index entry ").append(offset$1).append(" => ").append(position$1).append(" to ").append($this.file().getAbsolutePath()).toString();
    }

    public static final /* synthetic */ void $anonfun$append$1(OffsetIndex $this, long offset$1, int position$1) {
        Predef$.MODULE$.require(!$this.isFull(), (Function0 & Serializable)() -> new StringBuilder(44).append("Attempt to append to a full index (size = ").append($this._entries()).append(").").toString());
        if ($this._entries() == 0 || offset$1 > $this._lastOffset) {
            OffsetIndex$ trace_this = OffsetIndex$.MODULE$;
            if (trace_this.logger().underlying().isTraceEnabled()) {
                String msgWithLogIdent_msg = OffsetIndex.$anonfun$append$3($this, offset$1, position$1);
                Object var5_4 = null;
                trace_this.logger().underlying().trace(Logging.msgWithLogIdent$(trace_this, msgWithLogIdent_msg));
            }
            Object var4_3 = null;
            $this.mmap().putInt($this.relativeOffset(offset$1));
            $this.mmap().putInt(position$1);
            $this._entries_$eq($this._entries() + 1);
            $this._lastOffset = offset$1;
            Predef$.MODULE$.require($this._entries() * $this.entrySize() == $this.mmap().position(), (Function0 & Serializable)() -> new StringBuilder(40).append($this.entries()).append(" entries but file position in index is ").append($this.mmap().position()).append(".").toString());
            return;
        }
        throw new InvalidOffsetException(new StringBuilder(91).append("Attempt to append an offset (").append(offset$1).append(") to position ").append($this.entries()).append(" no larger than").append(" the last offset appended (").append($this._lastOffset).append(") to ").append($this.file().getAbsolutePath()).append(".").toString());
    }

    public static final /* synthetic */ void $anonfun$truncateTo$1(OffsetIndex $this, long offset$2) {
        ByteBuffer idx = $this.mmap().duplicate();
        int slot = $this.largestLowerBoundSlotFor(idx, offset$2, IndexSearchType$KEY$.MODULE$);
        int newEntries = slot < 0 ? 0 : ((long)$this.relativeOffset(idx, slot) == offset$2 - $this.super$baseOffset() ? slot : slot + 1);
        $this.truncateToEntries(newEntries);
    }

    public static final /* synthetic */ String $anonfun$truncateToEntries$2(OffsetIndex $this, int entries$1) {
        return new StringBuilder(70).append("Truncated index ").append($this.file().getAbsolutePath()).append(" to ").append(entries$1).append(" entries;").append(" position is now ").append($this.mmap().position()).append(" and last offset is now ").append($this._lastOffset).toString();
    }

    public static final /* synthetic */ void $anonfun$truncateToEntries$1(OffsetIndex $this, int entries$1) {
        $this._entries_$eq(entries$1);
        $this.mmap().position($this._entries() * $this.entrySize());
        $this._lastOffset = $this.lastEntry().offset();
        OffsetIndex$ debug_this = OffsetIndex$.MODULE$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = OffsetIndex.$anonfun$truncateToEntries$2($this, entries$1);
            Object var3_3 = null;
            debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
            return;
        }
    }

    public OffsetIndex(File _file, long baseOffset, int maxIndexSize, boolean fileAlreadyExists, boolean writable) {
        super(_file, baseOffset, maxIndexSize, fileAlreadyExists, writable);
        OffsetIndex$ debug_this = OffsetIndex$.MODULE$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = OffsetIndex.$anonfun$new$1(this);
            Object var8_7 = null;
            debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
            return;
        }
    }
}

