/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.util.ArrayDeque;
import kafka.log.BatchMetadata;
import kafka.log.ProducerStateEntry$;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.Iterable;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\ruA\u0002\u0014(\u0011\u000393F\u0002\u0004.O!\u0005qE\f\u0005\u0006k\u0005!\ta\u000e\u0005\bq\u0005\u0011\r\u0011\"\u0001:\u0011\u0019i\u0014\u0001)A\u0005u!)a(\u0001C\u0001\u007f!)1*\u0001C\u0001\u0019\u001a)Qf\n\u0001(\u001d\"Aqj\u0002BC\u0002\u0013\u0005\u0001\u000b\u0003\u0005U\u000f\t\u0005\t\u0015!\u0003R\u0011!)vA!b\u0001\n\u00031\u0006\u0002C,\b\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011a;!\u00111A\u0005\u0002eC\u0001\"X\u0004\u0003\u0002\u0004%\tA\u0018\u0005\tI\u001e\u0011\t\u0011)Q\u00055\"AQm\u0002BA\u0002\u0013\u0005\u0011\b\u0003\u0005g\u000f\t\u0005\r\u0011\"\u0001h\u0011!IwA!A!B\u0013Q\u0004\u0002\u00036\b\u0005\u0003\u0007I\u0011\u0001)\t\u0011-<!\u00111A\u0005\u00021D\u0001B\\\u0004\u0003\u0002\u0003\u0006K!\u0015\u0005\t_\u001e\u0011\t\u0019!C\u0001a\"AAo\u0002BA\u0002\u0013\u0005Q\u000f\u0003\u0005x\u000f\t\u0005\t\u0015)\u0003r\u0011\u0015)t\u0001\"\u0001y\u0011\u0015yx\u0001\"\u0001:\u0011\u0019\t\ta\u0002C\u0001!\"1\u00111A\u0004\u0005\u0002eBa!!\u0002\b\t\u0003\u0001\u0006BBA\u0004\u000f\u0011\u0005\u0011\bC\u0004\u0002\n\u001d!\t!a\u0003\t\u000f\u0005Mq\u0001\"\u0001\u0002\u0016!9\u0011qE\u0004\u0005\u0002\u0005%\u0002bBA\u0017\u000f\u0011%\u0011q\u0006\u0005\b\u0003k9A\u0011AA\u001c\u0011\u001d\tid\u0002C\u0001\u0003\u007fAq!a\u0018\b\t\u0003\t\t\u0007C\u0004\u0002h\u001d!\t%!\u001b\u0002%A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u000b:$(/\u001f\u0006\u0003Q%\n1\u0001\\8h\u0015\u0005Q\u0013!B6bM.\f\u0007C\u0001\u0017\u0002\u001b\u00059#A\u0005)s_\u0012,8-\u001a:Ti\u0006$X-\u00128uef\u001c\"!A\u0018\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#A\u0016\u0002%9+XNQ1uG\",7\u000fV8SKR\f\u0017N\\\u000b\u0002uA\u0011\u0001gO\u0005\u0003yE\u00121!\u00138u\u0003MqU/\u001c\"bi\u000eDWm\u001d+p%\u0016$\u0018-\u001b8!\u0003=)W\u000e\u001d;z\u0005\u0006$8\r[)vKV,G#\u0001!\u0011\u0007\u00053\u0005*D\u0001C\u0015\t\u0019E)\u0001\u0003vi&d'\"A#\u0002\t)\fg/Y\u0005\u0003\u000f\n\u0013!\"\u0011:sCf$U-];f!\ta\u0013*\u0003\u0002KO\ti!)\u0019;dQ6+G/\u00193bi\u0006\fQ!Z7qif$2!TAA!\tasa\u0005\u0002\b_\u0005Q\u0001O]8ek\u000e,'/\u00133\u0016\u0003E\u0003\"\u0001\r*\n\u0005M\u000b$\u0001\u0002'p]\u001e\f1\u0002\u001d:pIV\u001cWM]%eA\u0005i!-\u0019;dQ6+G/\u00193bi\u0006,\u0012\u0001Q\u0001\u000fE\u0006$8\r['fi\u0006$\u0017\r^1!\u00035\u0001(o\u001c3vG\u0016\u0014X\t]8dQV\t!\f\u0005\u000217&\u0011A,\r\u0002\u0006'\"|'\u000f^\u0001\u0012aJ|G-^2fe\u0016\u0003xn\u00195`I\u0015\fHCA0c!\t\u0001\u0004-\u0003\u0002bc\t!QK\\5u\u0011\u001d\u0019W\"!AA\u0002i\u000b1\u0001\u001f\u00132\u00039\u0001(o\u001c3vG\u0016\u0014X\t]8dQ\u0002\n\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\u0002)\r|wN\u001d3j]\u0006$xN]#q_\u000eDw\fJ3r)\ty\u0006\u000eC\u0004d!\u0005\u0005\t\u0019\u0001\u001e\u0002#\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0007%A\u0007mCN$H+[7fgR\fW\u000e]\u0001\u0012Y\u0006\u001cH\u000fV5nKN$\u0018-\u001c9`I\u0015\fHCA0n\u0011\u001d\u00197#!AA\u0002E\u000ba\u0002\\1tiRKW.Z:uC6\u0004\b%A\u000bdkJ\u0014XM\u001c;Uq:4\u0015N]:u\u001f\u001a47/\u001a;\u0016\u0003E\u00042\u0001\r:R\u0013\t\u0019\u0018G\u0001\u0004PaRLwN\\\u0001\u001aGV\u0014(/\u001a8u)btg)\u001b:ti>3gm]3u?\u0012*\u0017\u000f\u0006\u0002`m\"91MFA\u0001\u0002\u0004\t\u0018AF2veJ,g\u000e\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r\u001e\u0011\u0015\u000f5K(p\u001f?~}\")q\n\u0007a\u0001#\")Q\u000b\u0007a\u0001\u0001\")\u0001\f\u0007a\u00015\")Q\r\u0007a\u0001u!)!\u000e\u0007a\u0001#\")q\u000e\u0007a\u0001c\u0006Aa-\u001b:tiN+\u0017/A\bgSJ\u001cH\u000fR1uC>3gm]3u\u0003\u001da\u0017m\u001d;TKF\fa\u0002\\1ti\u0012\u000bG/Y(gMN,G/A\bmCN$xJ\u001a4tKR$U\r\u001c;b\u0003\u001dI7/R7qif,\"!!\u0004\u0011\u0007A\ny!C\u0002\u0002\u0012E\u0012qAQ8pY\u0016\fg.\u0001\u0005bI\u0012\u0014\u0015\r^2i)-y\u0016qCA\r\u00037\ty\"a\t\t\u000ba{\u0002\u0019\u0001.\t\r\u0005\rq\u00041\u0001;\u0011\u0019\tib\ba\u0001#\u0006QA.Y:u\u001f\u001a47/\u001a;\t\r\u0005\u0005r\u00041\u0001;\u0003-ygMZ:fi\u0012+G\u000e^1\t\r\u0005\u0015r\u00041\u0001R\u0003%!\u0018.\\3ti\u0006l\u0007/\u0001\rnCf\u0014W-\u00169eCR,\u0007K]8ek\u000e,'/\u00129pG\"$B!!\u0004\u0002,!)\u0001\f\ta\u00015\u0006\u0001\u0012\r\u001a3CCR\u001c\u0007.T3uC\u0012\fG/\u0019\u000b\u0004?\u0006E\u0002BBA\u001aC\u0001\u0007\u0001*A\u0003cCR\u001c\u0007.\u0001\u0004va\u0012\fG/\u001a\u000b\u0004?\u0006e\u0002BBA\u001eE\u0001\u0007Q*A\u0005oKb$XI\u001c;ss\u0006\u0011b-\u001b8e\tV\u0004H.[2bi\u0016\u0014\u0015\r^2i)\u0011\t\t%a\u0011\u0011\u0007A\u0012\b\nC\u0004\u00024\r\u0002\r!!\u0012\u0011\t\u0005\u001d\u00131L\u0007\u0003\u0003\u0013RA!a\u0013\u0002N\u00051!/Z2pe\u0012TA!a\u0014\u0002R\u000511m\\7n_:T1AKA*\u0015\u0011\t)&a\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tI&A\u0002pe\u001eLA!!\u0018\u0002J\tY!+Z2pe\u0012\u0014\u0015\r^2i\u0003Y\u0011\u0017\r^2i/&$\bnU3rk\u0016t7-\u001a*b]\u001e,GCBA!\u0003G\n)\u0007C\u0003\u0000I\u0001\u0007!\b\u0003\u0004\u0002\u0004\u0011\u0002\rAO\u0001\ti>\u001cFO]5oOR\u0011\u00111\u000e\t\u0005\u0003[\nYH\u0004\u0003\u0002p\u0005]\u0004cAA9c5\u0011\u00111\u000f\u0006\u0004\u0003k2\u0014A\u0002\u001fs_>$h(C\u0002\u0002zE\na\u0001\u0015:fI\u00164\u0017\u0002BA?\u0003\u007f\u0012aa\u0015;sS:<'bAA=c!)qJ\u0002a\u0001#\u0002")
public class ProducerStateEntry {
    private final long producerId;
    private final ArrayDeque<BatchMetadata> batchMetadata;
    private short producerEpoch;
    private int coordinatorEpoch;
    private long lastTimestamp;
    private Option<Object> currentTxnFirstOffset;

    public static ProducerStateEntry empty(long producerId) {
        return ProducerStateEntry$.MODULE$.empty(producerId);
    }

    public static ArrayDeque<BatchMetadata> emptyBatchQueue() {
        return ProducerStateEntry$.MODULE$.emptyBatchQueue();
    }

    public static int NumBatchesToRetain() {
        return ProducerStateEntry$.MODULE$.NumBatchesToRetain();
    }

    public long producerId() {
        return this.producerId;
    }

    public ArrayDeque<BatchMetadata> batchMetadata() {
        return this.batchMetadata;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public void coordinatorEpoch_$eq(int x$1) {
        this.coordinatorEpoch = x$1;
    }

    public long lastTimestamp() {
        return this.lastTimestamp;
    }

    public void lastTimestamp_$eq(long x$1) {
        this.lastTimestamp = x$1;
    }

    public Option<Object> currentTxnFirstOffset() {
        return this.currentTxnFirstOffset;
    }

    public void currentTxnFirstOffset_$eq(Option<Object> x$1) {
        this.currentTxnFirstOffset = x$1;
    }

    public int firstSeq() {
        if (this.isEmpty()) {
            return -1;
        }
        return this.batchMetadata().peek().firstSeq();
    }

    public long firstDataOffset() {
        if (this.isEmpty()) {
            return -1L;
        }
        return this.batchMetadata().peek().firstOffset();
    }

    public int lastSeq() {
        if (this.isEmpty()) {
            return -1;
        }
        return this.batchMetadata().getLast().lastSeq();
    }

    public long lastDataOffset() {
        if (this.isEmpty()) {
            return -1L;
        }
        return this.batchMetadata().getLast().lastOffset();
    }

    public int lastOffsetDelta() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.batchMetadata().getLast().offsetDelta();
    }

    public boolean isEmpty() {
        return this.batchMetadata().isEmpty();
    }

    public void addBatch(short producerEpoch, int lastSeq, long lastOffset, int offsetDelta, long timestamp) {
        this.maybeUpdateProducerEpoch(producerEpoch);
        this.addBatchMetadata(new BatchMetadata(lastSeq, lastOffset, offsetDelta, timestamp));
        this.lastTimestamp_$eq(timestamp);
    }

    public boolean maybeUpdateProducerEpoch(short producerEpoch) {
        if (this.producerEpoch() != producerEpoch) {
            this.batchMetadata().clear();
            this.producerEpoch_$eq(producerEpoch);
            return true;
        }
        return false;
    }

    private void addBatchMetadata(BatchMetadata batch) {
        if (this.batchMetadata().size() == ProducerStateEntry$.MODULE$.NumBatchesToRetain()) {
            this.batchMetadata().pop();
        }
        this.batchMetadata().add(batch);
    }

    public void update(ProducerStateEntry nextEntry) {
        this.maybeUpdateProducerEpoch(nextEntry.producerEpoch());
        while (CollectionConverters$.MODULE$.CollectionHasAsScala(nextEntry.batchMetadata()).asScala().nonEmpty()) {
            this.addBatchMetadata(nextEntry.batchMetadata().pop());
        }
        this.coordinatorEpoch_$eq(nextEntry.coordinatorEpoch());
        this.currentTxnFirstOffset_$eq(nextEntry.currentTxnFirstOffset());
        this.lastTimestamp_$eq(nextEntry.lastTimestamp());
    }

    public Option<BatchMetadata> findDuplicateBatch(RecordBatch batch) {
        if (batch.producerEpoch() != this.producerEpoch()) {
            return None$.MODULE$;
        }
        return this.batchWithSequenceRange(batch.baseSequence(), batch.lastSequence());
    }

    public Option<BatchMetadata> batchWithSequenceRange(int firstSeq, int lastSeq) {
        return ((Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(this.batchMetadata()).asScala().filter((Function1 & Serializable)metadata -> BoxesRunTime.boxToBoolean((boolean)ProducerStateEntry.$anonfun$batchWithSequenceRange$1(firstSeq, lastSeq, metadata)))).headOption();
    }

    public String toString() {
        return new StringBuilder(121).append("ProducerStateEntry(").append("producerId=").append(this.producerId()).append(", ").append("producerEpoch=").append(this.producerEpoch()).append(", ").append("currentTxnFirstOffset=").append(this.currentTxnFirstOffset()).append(", ").append("coordinatorEpoch=").append(this.coordinatorEpoch()).append(", ").append("lastTimestamp=").append(this.lastTimestamp()).append(", ").append("batchMetadata=").append(this.batchMetadata()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$batchWithSequenceRange$1(int firstSeq$1, int lastSeq$1, BatchMetadata metadata) {
        return firstSeq$1 == metadata.firstSeq() && lastSeq$1 == metadata.lastSeq();
    }

    public ProducerStateEntry(long producerId, ArrayDeque<BatchMetadata> batchMetadata, short producerEpoch, int coordinatorEpoch, long lastTimestamp, Option<Object> currentTxnFirstOffset) {
        this.producerId = producerId;
        this.batchMetadata = batchMetadata;
        this.producerEpoch = producerEpoch;
        this.coordinatorEpoch = coordinatorEpoch;
        this.lastTimestamp = lastTimestamp;
        this.currentTxnFirstOffset = currentTxnFirstOffset;
    }
}

