/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.FileStore;
import java.nio.file.Files;
import kafka.log.SegmentDeletionThrottlerConfig$;
import kafka.server.BrokerReconfigurable;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Logging;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ug\u0001\u0002\u0013&\u0001)B\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"Aa\n\u0001B\u0001B\u0003%q\nC\u0003S\u0001\u0011\u00051\u000b\u0003\u0005Z\u0001\u0001\u0007I\u0011A\u0013[\u0011!\u0019\u0007\u00011A\u0005\u0002\u0015\"\u0007B\u00026\u0001A\u0003&1\fC\u0004p\u0001\u0001\u0007I\u0011\u00029\t\u000fQ\u0004\u0001\u0019!C\u0005k\"1q\u000f\u0001Q!\nED\u0001\"\u001f\u0001A\u0002\u0013\u0005QE\u001f\u0005\t{\u0002\u0001\r\u0011\"\u0001&}\"9\u0011\u0011\u0001\u0001!B\u0013Y\bBCA\u0003\u0001\u0001\u0007I\u0011A\u0013\u0002\b!Q\u0011q\u0002\u0001A\u0002\u0013\u0005Q%!\u0005\t\u0011\u0005U\u0001\u0001)Q\u0005\u0003\u0013A\u0001\"a\u0006\u0001\u0001\u0004%IA\u001f\u0005\n\u00033\u0001\u0001\u0019!C\u0005\u00037Aq!a\b\u0001A\u0003&1\u0010C\u0004\u0002\"\u0001!\t\"a\t\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V!9\u00111\u000f\u0001\u0005B\u0005U\u0004bBA>\u0001\u0011\u0005\u0013Q\u0010\u0005\b\u0003\u000b\u0003A\u0011AAD\u0011\u001d\t\t\n\u0001C\u0001\u0003'Cq!a&\u0001\t\u0013\tIjB\u0004\u0002\"\u0016B\t!a)\u0007\r\u0011*\u0003\u0012AAS\u0011\u0019\u0011F\u0004\"\u0001\u0002(\"I\u0011\u0011\u0016\u000fC\u0002\u0013\u0005\u00111\u0016\u0005\b\u0003[c\u0002\u0015!\u0003P\u0011%\ty\u000b\bb\u0001\n\u0003\t\t\f\u0003\u0005\u0002:r\u0001\u000b\u0011BAZ\u0011\u0019IH\u0004\"\u0001\u0002<\"I\u0011Q\u0019\u000f\u0012\u0002\u0013\u0005\u0011q\u0019\u0002\u001f'\u0016<W.\u001a8u\t\u0016dW\r^5p]RC'o\u001c;uY\u0016\u00148i\u001c8gS\u001eT!AJ\u0014\u0002\u00071|wMC\u0001)\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\u00162oA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t1\u0011I\\=SK\u001a\u0004\"AM\u001b\u000e\u0003MR!\u0001N\u0014\u0002\u000bU$\u0018\u000e\\:\n\u0005Y\u001a$a\u0002'pO\u001eLgn\u001a\t\u0003qmj\u0011!\u000f\u0006\u0003u\u001d\naa]3sm\u0016\u0014\u0018B\u0001\u001f:\u0005Q\u0011%o\\6feJ+7m\u001c8gS\u001e,(/\u00192mK\u0006!A/[7f!\ty\u0004*D\u0001A\u0015\t!\u0014I\u0003\u0002C\u0007\u000611m\\7n_:T!\u0001\u000b#\u000b\u0005\u00153\u0015AB1qC\u000eDWMC\u0001H\u0003\ry'oZ\u0005\u0003\u0013\u0002\u0013A\u0001V5nK\u000611m\u001c8gS\u001e\u0004\"\u0001\u000f'\n\u00055K$aC&bM.\f7i\u001c8gS\u001e\f\u0001\u0003Z5tW\u000eCWmY6EK2\f\u00170T:\u0011\u00051\u0002\u0016BA).\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\tQ3v\u000b\u0017\t\u0003+\u0002i\u0011!\n\u0005\u0006{\u0011\u0001\rA\u0010\u0005\u0006\u0015\u0012\u0001\ra\u0013\u0005\b\u001d\u0012\u0001\n\u00111\u0001P\u0003\r\u001awN\u001c4jOV\u0014X\r\u001a#fY\u0016$\u0018n\u001c8NCb\u001cVmZ7f]R\u001c\b+\u001a:Sk:,\u0012a\u0017\t\u00039\u0006l\u0011!\u0018\u0006\u0003=~\u000bA\u0001\\1oO*\t\u0001-\u0001\u0003kCZ\f\u0017B\u00012^\u0005\u001dIe\u000e^3hKJ\fqeY8oM&<WO]3e\t\u0016dW\r^5p]6\u000b\u0007pU3h[\u0016tGo\u001d)feJ+hn\u0018\u0013fcR\u0011Q\r\u001b\t\u0003Y\u0019L!aZ\u0017\u0003\tUs\u0017\u000e\u001e\u0005\bS\u001a\t\t\u00111\u0001\\\u0003\rAH%M\u0001%G>tg-[4ve\u0016$G)\u001a7fi&|g.T1y'\u0016<W.\u001a8ugB+'OU;oA!\u0012q\u0001\u001c\t\u0003Y5L!A\\\u0017\u0003\u0011Y|G.\u0019;jY\u0016\fqdY8oM&<WO]3e\t&\u001c8N\u0012:fK\"+\u0017\r\u001a:p_6\u0014\u0015\u0010^3t+\u0005\t\bC\u0001/s\u0013\t\u0019XL\u0001\u0003M_:<\u0017aI2p]\u001aLw-\u001e:fI\u0012K7o\u001b$sK\u0016DU-\u00193s_>l')\u001f;fg~#S-\u001d\u000b\u0003KZDq![\u0005\u0002\u0002\u0003\u0007\u0011/\u0001\u0011d_:4\u0017nZ;sK\u0012$\u0015n]6Ge\u0016,\u0007*Z1ee>|WNQ=uKN\u0004\u0003F\u0001\u0006m\u0003Y!\u0017n]6Ge\u0016,G\u000b\u001b:fg\"|G\u000e\u001a\"zi\u0016\u001cX#A>\u0011\u00051b\u0018BA:.\u0003i!\u0017n]6Ge\u0016,G\u000b\u001b:fg\"|G\u000e\u001a\"zi\u0016\u001cx\fJ3r)\t)w\u0010C\u0004j\u0019\u0005\u0005\t\u0019A>\u0002/\u0011L7o\u001b$sK\u0016$\u0006N]3tQ>dGMQ=uKN\u0004\u0003FA\u0007m\u0003\tJ7\u000fR3mKRLwN\\'bqN+w-\\3oiN\u0004VM\u001d*v]\u0016s\u0017M\u00197fIV\u0011\u0011\u0011\u0002\t\u0004Y\u0005-\u0011bAA\u0007[\t9!i\\8mK\u0006t\u0017AJ5t\t\u0016dW\r^5p]6\u000b\u0007pU3h[\u0016tGo\u001d)feJ+h.\u00128bE2,Gm\u0018\u0013fcR\u0019Q-a\u0005\t\u0011%|\u0011\u0011!a\u0001\u0003\u0013\t1%[:EK2,G/[8o\u001b\u0006D8+Z4nK:$8\u000fU3s%VtWI\\1cY\u0016$\u0007%\u0001\rmCN$H)[:l+N\fw-Z\"iK\u000e\\G+[7f\u001bN\fA\u0004\\1ti\u0012K7o[+tC\u001e,7\t[3dWRKW.Z't?\u0012*\u0017\u000fF\u0002f\u0003;Aq!\u001b\n\u0002\u0002\u0003\u000710A\rmCN$H)[:l+N\fw-Z\"iK\u000e\\G+[7f\u001bN\u0004\u0013A\u00034jY\u0016\u001cFo\u001c:fgR!\u0011QEA!!\u0019\t9#!\f\u000225\u0011\u0011\u0011\u0006\u0006\u0004\u0003Wi\u0013AC2pY2,7\r^5p]&!\u0011qFA\u0015\u0005\r\u0019V-\u001d\t\u0005\u0003g\ti$\u0004\u0002\u00026)!\u0011qGA\u001d\u0003\u00111\u0017\u000e\\3\u000b\u0007\u0005mr,A\u0002oS>LA!a\u0010\u00026\tIa)\u001b7f'R|'/\u001a\u0005\b\u0003\u0007\"\u0002\u0019AA#\u0003\u001dawn\u001a#jeN\u0004b!a\n\u0002.\u0005\u001d\u0003\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055s,\u0001\u0002j_&!\u0011\u0011KA&\u0005\u00111\u0015\u000e\\3\u0002+I,7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\u0011\u0011q\u000b\t\u0007\u0003O\tI&!\u0018\n\t\u0005m\u0013\u0011\u0006\u0002\u0004'\u0016$\b\u0003BA0\u0003[rA!!\u0019\u0002jA\u0019\u00111M\u0017\u000e\u0005\u0005\u0015$bAA4S\u00051AH]8pizJ1!a\u001b.\u0003\u0019\u0001&/\u001a3fM&!\u0011qNA9\u0005\u0019\u0019FO]5oO*\u0019\u00111N\u0017\u0002/Y\fG.\u001b3bi\u0016\u0014VmY8oM&<WO]1uS>tGcA3\u0002x!1\u0011\u0011\u0010\fA\u0002-\u000b\u0011B\\3x\u0007>tg-[4\u0002\u0017I,7m\u001c8gS\u001e,(/\u001a\u000b\u0006K\u0006}\u00141\u0011\u0005\u0007\u0003\u0003;\u0002\u0019A&\u0002\u0013=dGmQ8oM&<\u0007BBA=/\u0001\u00071*A\u0011nCf\u0014W-\u00169eCR,G)[:l\rJ,W\r\u00165sKNDw\u000e\u001c3CsR,7\u000fF\u0003f\u0003\u0013\u000bi\tC\u0004\u0002\fb\u0001\r!!\u0003\u00023\u0015t\u0017M\u00197f\t&\u001c8NQ1tK\u0012$\u0006N]8ui2Lgn\u001a\u0005\u0007\u0003\u001fC\u0002\u0019A>\u0002=\t\f7m\u001b)sKN\u001cXO]3ESN\\G\u000b\u001b:fg\"|G\u000e\u001a\"zi\u0016\u001c\u0018!\u00073fY\u0016$\u0018n\u001c8NCb\u001cVmZ7f]R\u001c\b+\u001a:Sk:$2aTAK\u0011\u001d\t\u0019%\u0007a\u0001\u0003\u000b\nQ%\\1zE\u0016$\u0015n]1cY\u0016$U\r\\3uS>tW*\u0019=TK\u001elWM\u001c;t!\u0016\u0014(+\u001e8\u0015\u000b\u0015\fY*!(\t\u000f\u0005\r#\u00041\u0001\u0002F!1\u0011q\u0014\u000eA\u0002m\fQbY;se\u0016tG\u000fV5nK6\u001b\u0018AH*fO6,g\u000e\u001e#fY\u0016$\u0018n\u001c8UQJ|G\u000f\u001e7fe\u000e{gNZ5h!\t)Fd\u0005\u0002\u001dWQ\u0011\u00111U\u0001\u0018\t\u00164\u0017-\u001e7u\t&\u001c8n\u00115fG.$U\r\\1z\u001bN,\u0012aT\u0001\u0019\t\u00164\u0017-\u001e7u\t&\u001c8n\u00115fG.$U\r\\1z\u001bN\u0004\u0013!\u0006*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0003\u0003g\u0003b!a\n\u0002Z\u0005U\u0006c\u0001/\u00028&\u0019\u0011qN/\u0002-I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hg\u0002\"ra_A_\u0003\u0003\f\u0019\r\u0003\u0004\u0002@\n\u0002\ra_\u0001\u0016I&\u001c8N\u0012:fK\"+\u0017\r\u001a:p_6\u0014\u0015\u0010^3t\u0011\u001d\tYI\ta\u0001\u0003\u0013Aa!a$#\u0001\u0004Y\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002J*\u001aq*a3,\u0005\u00055\u0007\u0003BAh\u00033l!!!5\u000b\t\u0005M\u0017Q[\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a6.\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\f\tNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class SegmentDeletionThrottlerConfig
implements Logging,
BrokerReconfigurable {
    private final Time time;
    private final int diskCheckDelayMs;
    private volatile Integer configuredDeletionMaxSegmentsPerRun;
    private volatile Long configuredDiskFreeHeadroomBytes;
    private volatile long diskFreeThresholdBytes;
    private boolean isDeletionMaxSegmentsPerRunEnabled;
    private long lastDiskUsageCheckTimeMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return SegmentDeletionThrottlerConfig$.MODULE$.DefaultDiskCheckDelayMs();
    }

    public static Set<String> ReconfigurableConfigs() {
        return SegmentDeletionThrottlerConfig$.MODULE$.ReconfigurableConfigs();
    }

    public static int DefaultDiskCheckDelayMs() {
        return SegmentDeletionThrottlerConfig$.MODULE$.DefaultDiskCheckDelayMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Integer configuredDeletionMaxSegmentsPerRun() {
        return this.configuredDeletionMaxSegmentsPerRun;
    }

    public void configuredDeletionMaxSegmentsPerRun_$eq(Integer x$1) {
        this.configuredDeletionMaxSegmentsPerRun = x$1;
    }

    private Long configuredDiskFreeHeadroomBytes() {
        return this.configuredDiskFreeHeadroomBytes;
    }

    private void configuredDiskFreeHeadroomBytes_$eq(Long x$1) {
        this.configuredDiskFreeHeadroomBytes = x$1;
    }

    public long diskFreeThresholdBytes() {
        return this.diskFreeThresholdBytes;
    }

    public void diskFreeThresholdBytes_$eq(long x$1) {
        this.diskFreeThresholdBytes = x$1;
    }

    public boolean isDeletionMaxSegmentsPerRunEnabled() {
        return this.isDeletionMaxSegmentsPerRunEnabled;
    }

    public void isDeletionMaxSegmentsPerRunEnabled_$eq(boolean x$1) {
        this.isDeletionMaxSegmentsPerRunEnabled = x$1;
    }

    private long lastDiskUsageCheckTimeMs() {
        return this.lastDiskUsageCheckTimeMs;
    }

    private void lastDiskUsageCheckTimeMs_$eq(long x$1) {
        this.lastDiskUsageCheckTimeMs = x$1;
    }

    public Seq<FileStore> fileStores(Seq<File> logDirs) {
        return (Seq)logDirs.map((Function1 & Serializable)logDir -> Files.getFileStore(logDir.toPath()));
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return SegmentDeletionThrottlerConfig$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (Predef$.MODULE$.Integer2int(newConfig.logDeletionMaxSegmentsPerRun()) < 0) {
            throw new ConfigException(new StringBuilder(41).append(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp()).append(" cannot be less than 0, current value is ").append(this.configuredDeletionMaxSegmentsPerRun()).toString());
        }
        if (Predef$.MODULE$.Long2long(newConfig.logDeletionThrottlerDiskFreeHeadroomBytes()) <= 0L) {
            throw new ConfigException(new StringBuilder(34).append(KafkaConfig$.MODULE$.LogDeletionThrottlerDiskFreeHeadroomBytesProp()).append(" cannot be <= 0, current value is ").append(this.configuredDiskFreeHeadroomBytes()).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Integer n = this.configuredDeletionMaxSegmentsPerRun();
        Integer n2 = newConfig.logDeletionMaxSegmentsPerRun();
        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Reconfigure ").append(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp()).append(" from ").append(this.configuredDeletionMaxSegmentsPerRun()).append(" to ").append(newConfig.logDeletionMaxSegmentsPerRun()).toString());
            this.configuredDeletionMaxSegmentsPerRun_$eq(newConfig.logDeletionMaxSegmentsPerRun());
        }
        Long l = this.configuredDiskFreeHeadroomBytes();
        Long l2 = newConfig.logDeletionThrottlerDiskFreeHeadroomBytes();
        if (l == null ? l2 != null : !((Object)l).equals(l2)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Reconfigure ").append(KafkaConfig$.MODULE$.LogDeletionThrottlerDiskFreeHeadroomBytesProp()).append(" from ").append(this.configuredDiskFreeHeadroomBytes()).append(" to ").append(newConfig.logDeletionThrottlerDiskFreeHeadroomBytes()).toString());
            this.configuredDiskFreeHeadroomBytes_$eq(newConfig.logDeletionThrottlerDiskFreeHeadroomBytes());
            return;
        }
    }

    public void maybeUpdateDiskFreeThresholdBytes(boolean enableDiskBasedThrottling, long backPressureDiskThresholdBytes) {
        long newDiskFreeThresholdBytes = SegmentDeletionThrottlerConfig$.MODULE$.diskFreeThresholdBytes(Predef$.MODULE$.Long2long(this.configuredDiskFreeHeadroomBytes()), enableDiskBasedThrottling, backPressureDiskThresholdBytes);
        if (this.diskFreeThresholdBytes() != newDiskFreeThresholdBytes) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Update disk free threshold bytes from ").append(this.diskFreeThresholdBytes()).append(" to ").append(newDiskFreeThresholdBytes).toString());
            this.diskFreeThresholdBytes_$eq(newDiskFreeThresholdBytes);
            return;
        }
    }

    public int deletionMaxSegmentsPerRun(Seq<File> logDirs) {
        long currentTimeMs = this.time.milliseconds();
        long nextDiskUsageCheckTimeMs = this.lastDiskUsageCheckTimeMs() + (long)this.diskCheckDelayMs;
        if (nextDiskUsageCheckTimeMs <= currentTimeMs) {
            this.maybeDisableDeletionMaxSegmentsPerRun(logDirs, currentTimeMs);
        } else {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("Current time: ").append(currentTimeMs).append(" (ms), early to check disk usage for ").append(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp()).append(",").append(" next allowed disk usage check at: ").append(nextDiskUsageCheckTimeMs).append(" (ms)").toString());
        }
        if (this.isDeletionMaxSegmentsPerRunEnabled()) {
            return Predef$.MODULE$.Integer2int(this.configuredDeletionMaxSegmentsPerRun());
        }
        return Integer.MAX_VALUE;
    }

    private void maybeDisableDeletionMaxSegmentsPerRun(Seq<File> logDirs, long currentTimeMs) {
        if (!BoxesRunTime.equalsNumObject((Number)this.configuredDeletionMaxSegmentsPerRun(), (Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.LogDeletionMaxSegmentsPerRun()))) {
            this.lastDiskUsageCheckTimeMs_$eq(currentTimeMs);
            long minDiskUsableBytes = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.fileStores(logDirs).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.getUsableSpace()))).min((Ordering)Ordering.Long$.MODULE$));
            long currentDiskFreeThresholdBytes = this.diskFreeThresholdBytes();
            if (minDiskUsableBytes < currentDiskFreeThresholdBytes) {
                if (this.isDeletionMaxSegmentsPerRunEnabled()) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("Free disk space: ").append(minDiskUsableBytes).append(" is lower than the threshold: ").append(currentDiskFreeThresholdBytes).append(",").append(" disabling ").append(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp()).toString());
                    this.isDeletionMaxSegmentsPerRunEnabled_$eq(false);
                    return;
                }
                return;
            }
            if (!this.isDeletionMaxSegmentsPerRunEnabled()) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(16).append("Re-enabling ").append(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp()).append(" at ").append(this.configuredDeletionMaxSegmentsPerRun()).toString());
                this.isDeletionMaxSegmentsPerRunEnabled_$eq(true);
                return;
            }
            return;
        }
    }

    public SegmentDeletionThrottlerConfig(Time time, KafkaConfig config, int diskCheckDelayMs) {
        this.time = time;
        this.diskCheckDelayMs = diskCheckDelayMs;
        this.configuredDeletionMaxSegmentsPerRun = config.logDeletionMaxSegmentsPerRun();
        this.configuredDiskFreeHeadroomBytes = config.logDeletionThrottlerDiskFreeHeadroomBytes();
        this.diskFreeThresholdBytes = SegmentDeletionThrottlerConfig$.MODULE$.diskFreeThresholdBytes(Predef$.MODULE$.Long2long(this.configuredDiskFreeHeadroomBytes()), Predef$.MODULE$.Boolean2boolean(config.enableDiskBasedThrottling()), Predef$.MODULE$.Long2long(config.backPressureDiskThresholdBytes()));
        this.isDeletionMaxSegmentsPerRunEnabled = true;
        this.lastDiskUsageCheckTimeMs = time.milliseconds();
    }
}

