/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import kafka.log.AbstractIndex;
import kafka.log.CorruptIndexException;
import kafka.log.IndexSearchType$KEY$;
import kafka.log.IndexSearchType$VALUE$;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.utils.Logging;
import kafka.utils.Logging$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005}e\u0001B\u0013'\u0001-B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\ns\u0001\u0011\t\u0011)A\u0005u\u0001C\u0011\"\u0011\u0001\u0003\u0002\u0003\u0006IAQ#\t\u0013\u0019\u0003!\u0011!Q\u0001\n\u001dS\u0005\"C&\u0001\u0005\u0003\u0005\u000b\u0011B$M\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u001d)\u0006\u00011A\u0005\nYCqA\u0017\u0001A\u0002\u0013%1\f\u0003\u0004b\u0001\u0001\u0006Ka\u0016\u0005\u0006M\u0002!\te\u001a\u0005\u0006Q\u0002!\t%\u001b\u0005\u0006U\u0002!Ia\u001b\u0005\u0006m\u0002!Ia\u001e\u0005\u0006u\u0002!\tA\u0016\u0005\u0006w\u0002!IA\u0016\u0005\u0006y\u0002!\t! \u0005\u0007\u007f\u0002!\t%!\u0001\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n!I\u0011Q\u0003\u0001\u0012\u0002\u0013\u0005\u0011q\u0003\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011\u001d\t)\u0004\u0001C!\u0003oAq!!\u000f\u0001\t\u0003\nY\u0004C\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J!9\u0011q\n\u0001\u0005B\u0005]\u0002\u0002DA)\u0001A\u0005\u0019\u0011!A\u0005\n\u001d,\u0005\"DA*\u0001A\u0005\u0019\u0011!A\u0005\n\u0005U\u0003\t\u0003\b\u0002X\u0001\u0001\n1!A\u0001\n\u0013\tI&!\u0018\b\u000f\u0005}c\u0005#\u0001\u0002b\u00191QE\nE\u0001\u0003GBa!\u0014\u0010\u0005\u0002\u0005]\u0004\"CA==\t\u0007I\u0011IA>\u0011!\t\u0019J\bQ\u0001\n\u0005u\u0004\"CAK=E\u0005I\u0011AAL\u0011%\tYJHI\u0001\n\u0003\t9\u0002C\u0005\u0002\u001ez\t\n\u0011\"\u0001\u0002\u0018\tIA+[7f\u0013:$W\r\u001f\u0006\u0003O!\n1\u0001\\8h\u0015\u0005I\u0013!B6bM.\f7\u0001A\n\u0003\u00011\u0002\"!\f\u0018\u000e\u0003\u0019J!a\f\u0014\u0003\u001b\u0005\u00137\u000f\u001e:bGRLe\u000eZ3y\u0003\u0015yf-\u001b7f!\t\u0011t'D\u00014\u0015\t!T'\u0001\u0002j_*\ta'\u0001\u0003kCZ\f\u0017B\u0001\u001d4\u0005\u00111\u0015\u000e\\3\u0002\u0015\t\f7/Z(gMN,G\u000f\u0005\u0002<}5\tAHC\u0001>\u0003\u0015\u00198-\u00197b\u0013\tyDH\u0001\u0003M_:<\u0017BA\u001d/\u00031i\u0017\r_%oI\u0016D8+\u001b>f!\tY4)\u0003\u0002Ey\t\u0019\u0011J\u001c;\n\u0005\u0005s\u0013!\u00054jY\u0016\fEN]3bIf,\u00050[:ugB\u00111\bS\u0005\u0003\u0013r\u0012qAQ8pY\u0016\fg.\u0003\u0002G]\u0005AqO]5uC\ndW-\u0003\u0002L]\u00051A(\u001b8jiz\"ba\u0014)R%N#\u0006CA\u0017\u0001\u0011\u0015\u0001d\u00011\u00012\u0011\u0015Id\u00011\u0001;\u0011\u001d\te\u0001%AA\u0002\tCqA\u0012\u0004\u0011\u0002\u0003\u0007q\tC\u0004L\rA\u0005\t\u0019A$\u0002\u0015}c\u0017m\u001d;F]R\u0014\u00180F\u0001X!\ti\u0003,\u0003\u0002ZM\tyA+[7fgR\fW\u000e](gMN,G/\u0001\b`Y\u0006\u001cH/\u00128uef|F%Z9\u0015\u0005q{\u0006CA\u001e^\u0013\tqFH\u0001\u0003V]&$\bb\u00021\t\u0003\u0003\u0005\raV\u0001\u0004q\u0012\n\u0014aC0mCN$XI\u001c;ss\u0002B#!C2\u0011\u0005m\"\u0017BA3=\u0005!1x\u000e\\1uS2,\u0017!C3oiJL8+\u001b>f+\u0005\u0011\u0015AB5t\rVdG.F\u0001H\u0003%!\u0018.\\3ti\u0006l\u0007\u000fF\u0002;YRDQ!\u001c\u0007A\u00029\faAY;gM\u0016\u0014\bCA8s\u001b\u0005\u0001(BA96\u0003\rq\u0017n\\\u0005\u0003gB\u0014!BQ=uK\n+hMZ3s\u0011\u0015)H\u00021\u0001C\u0003\u0005q\u0017A\u0004:fY\u0006$\u0018N^3PM\u001a\u001cX\r\u001e\u000b\u0004\u0005bL\b\"B7\u000e\u0001\u0004q\u0007\"B;\u000e\u0001\u0004\u0011\u0015!\u00037bgR,e\u000e\u001e:z\u0003Ya\u0017m\u001d;F]R\u0014\u0018P\u0012:p[&sG-\u001a=GS2,\u0017!B3oiJLHCA,\u007f\u0011\u0015)\b\u00031\u0001C\u0003)\u0001\u0018M]:f\u000b:$(/\u001f\u000b\u0006/\u0006\r\u0011Q\u0001\u0005\u0006[F\u0001\rA\u001c\u0005\u0006kF\u0001\rAQ\u0001\f[\u0006L(-Z!qa\u0016tG\rF\u0004]\u0003\u0017\ti!!\u0005\t\u000b)\u0014\u0002\u0019\u0001\u001e\t\r\u0005=!\u00031\u0001;\u0003\u0019ygMZ:fi\"A\u00111\u0003\n\u0011\u0002\u0003\u0007q)A\u0007tW&\u0004h)\u001e7m\u0007\",7m[\u0001\u0016[\u0006L(-Z!qa\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00134+\t\tIBK\u0002H\u00037Y#!!\b\u0011\t\u0005}\u0011\u0011F\u0007\u0003\u0003CQA!a\t\u0002&\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Oa\u0014AC1o]>$\u0018\r^5p]&!\u00111FA\u0011\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0007Y>|7.\u001e9\u0015\u0007]\u000b\t\u0004\u0003\u0004\u00024Q\u0001\rAO\u0001\u0010i\u0006\u0014x-\u001a;US6,7\u000f^1na\u0006AAO];oG\u0006$X\rF\u0001]\u0003)!(/\u001e8dCR,Gk\u001c\u000b\u00049\u0006u\u0002BBA\b-\u0001\u0007!(\u0001\u0004sKNL'0\u001a\u000b\u0004\u000f\u0006\r\u0003BBA#/\u0001\u0007!)A\u0004oK^\u001c\u0016N_3\u0002#Q\u0014XO\\2bi\u0016$v.\u00128ue&,7\u000fF\u0002]\u0003\u0017Ba!!\u0014\u0019\u0001\u0004\u0011\u0015aB3oiJLWm]\u0001\fg\u0006t\u0017\u000e^=DQ\u0016\u001c7.\u0001\ntkB,'\u000fJ7bq&sG-\u001a=TSj,\u0017\u0001E:va\u0016\u0014HEY1tK>3gm]3u+\u0005Q\u0014\u0001D:va\u0016\u0014HE]3tSj,GcA$\u0002\\!1\u0011Q\t\u000fA\u0002\tK1!a\u0010/\u0003%!\u0016.\\3J]\u0012,\u0007\u0010\u0005\u0002.=M)a$!\u001a\u0002lA\u00191(a\u001a\n\u0007\u0005%DH\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0003[\n\u0019(\u0004\u0002\u0002p)\u0019\u0011\u0011\u000f\u0015\u0002\u000bU$\u0018\u000e\\:\n\t\u0005U\u0014q\u000e\u0002\b\u0019><w-\u001b8h)\t\t\t'\u0001\u0006m_\u001e<WM\u001d(b[\u0016,\"!! \u0011\t\u0005}\u0014Q\u0012\b\u0005\u0003\u0003\u000bI\tE\u0002\u0002\u0004rj!!!\"\u000b\u0007\u0005\u001d%&\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0017c\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0010\u0006E%AB*ue&twMC\u0002\u0002\fr\n1\u0002\\8hO\u0016\u0014h*Y7fA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!!'+\u0007\t\u000bY\"A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b")
public class TimeIndex
extends AbstractIndex {
    private volatile TimestampOffset _lastEntry = this.lastEntryFromIndexFile();

    public static boolean $lessinit$greater$default$5() {
        return true;
    }

    public static boolean $lessinit$greater$default$4() {
        return false;
    }

    public static int $lessinit$greater$default$3() {
        return -1;
    }

    public static String loggerName() {
        return TimeIndex$.MODULE$.loggerName();
    }

    public static void fatal(Function0<String> msg, Function0<Throwable> e) {
        TimeIndex$ fatal_this = TimeIndex$.MODULE$;
        if (fatal_this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var3_3 = null;
            fatal_this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), Logging.msgWithLogIdent$(fatal_this, msgWithLogIdent_msg), (Throwable)e.apply());
            return;
        }
    }

    public static void fatal(Function0<String> msg) {
        TimeIndex$ fatal_this = TimeIndex$.MODULE$;
        if (fatal_this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var2_2 = null;
            fatal_this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), Logging.msgWithLogIdent$(fatal_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static void error(Function0<String> msg, Function0<Throwable> e) {
        TimeIndex$ error_this = TimeIndex$.MODULE$;
        if (error_this.logger().underlying().isErrorEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var3_3 = null;
            error_this.logger().underlying().error(Logging.msgWithLogIdent$(error_this, msgWithLogIdent_msg), (Throwable)e.apply());
            return;
        }
    }

    public static void error(Function0<String> msg) {
        TimeIndex$ error_this = TimeIndex$.MODULE$;
        if (error_this.logger().underlying().isErrorEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var2_2 = null;
            error_this.logger().underlying().error(Logging.msgWithLogIdent$(error_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static void warn(Function0<String> msg, Function0<Throwable> e) {
        TimeIndex$ warn_this = TimeIndex$.MODULE$;
        if (warn_this.logger().underlying().isWarnEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var3_3 = null;
            warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg), (Throwable)e.apply());
            return;
        }
    }

    public static void warn(Function0<String> msg) {
        TimeIndex$ warn_this = TimeIndex$.MODULE$;
        if (warn_this.logger().underlying().isWarnEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var2_2 = null;
            warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static void info(Function0<String> msg, Function0<Throwable> e) {
        TimeIndex$ info_this = TimeIndex$.MODULE$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var3_3 = null;
            info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg), (Throwable)e.apply());
            return;
        }
    }

    public static void info(Function0<String> msg) {
        TimeIndex$ info_this = TimeIndex$.MODULE$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var2_2 = null;
            info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static void debug(Function0<String> msg, Function0<Throwable> e) {
        TimeIndex$ debug_this = TimeIndex$.MODULE$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var3_3 = null;
            debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg), (Throwable)e.apply());
            return;
        }
    }

    public static void debug(Function0<String> msg) {
        TimeIndex$ debug_this = TimeIndex$.MODULE$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var2_2 = null;
            debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(TimeIndex$.MODULE$);
    }

    public static boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(TimeIndex$.MODULE$);
    }

    public static void trace(Function0<String> msg, Function0<Throwable> e) {
        TimeIndex$ trace_this = TimeIndex$.MODULE$;
        if (trace_this.logger().underlying().isTraceEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var3_3 = null;
            trace_this.logger().underlying().trace(Logging.msgWithLogIdent$(trace_this, msgWithLogIdent_msg), (Throwable)e.apply());
            return;
        }
    }

    public static void trace(Function0<String> msg) {
        TimeIndex$ trace_this = TimeIndex$.MODULE$;
        if (trace_this.logger().underlying().isTraceEnabled()) {
            String msgWithLogIdent_msg = (String)msg.apply();
            Object var2_2 = null;
            trace_this.logger().underlying().trace(Logging.msgWithLogIdent$(trace_this, msgWithLogIdent_msg));
            return;
        }
    }

    private /* synthetic */ int super$maxIndexSize() {
        return super.maxIndexSize();
    }

    private /* synthetic */ long super$baseOffset() {
        return super.baseOffset();
    }

    private /* synthetic */ boolean super$resize(int newSize) {
        return super.resize(newSize);
    }

    private TimestampOffset _lastEntry() {
        return this._lastEntry;
    }

    private void _lastEntry_$eq(TimestampOffset x$1) {
        this._lastEntry = x$1;
    }

    @Override
    public int entrySize() {
        return 12;
    }

    @Override
    public boolean isFull() {
        return this.entries() >= this.maxEntries() - 1;
    }

    private long timestamp(ByteBuffer buffer, int n) {
        return buffer.getLong(n * this.entrySize());
    }

    private int relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 8);
    }

    public TimestampOffset lastEntry() {
        return this._lastEntry();
    }

    private TimestampOffset lastEntryFromIndexFile() {
        TimestampOffset timestampOffset;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            timestampOffset = TimeIndex.$anonfun$lastEntryFromIndexFile$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return timestampOffset;
    }

    public TimestampOffset entry(int n) {
        return (TimestampOffset)this.maybeLock(this.lock(), (Function0 & Serializable)() -> {
            if (n >= this._entries()) {
                throw new IllegalArgumentException(new StringBuilder(64).append("Attempt to fetch the ").append(n).append("th entry from  time index ").append(this.file().getAbsolutePath()).append(" ").append("which has size ").append(this._entries()).append(".").toString());
            }
            return this.parseEntry(this.mmap(), n);
        });
    }

    @Override
    public TimestampOffset parseEntry(ByteBuffer buffer, int n) {
        return new TimestampOffset(this.timestamp(buffer, n), super.baseOffset() + (long)this.relativeOffset(buffer, n));
    }

    public void maybeAppend(long timestamp, long offset, boolean skipFullCheck) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            TimeIndex.$anonfun$maybeAppend$1(this, skipFullCheck, offset, timestamp);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public boolean maybeAppend$default$3() {
        return false;
    }

    public TimestampOffset lookup(long targetTimestamp) {
        return (TimestampOffset)this.maybeLock(this.lock(), (Function0 & Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, targetTimestamp, IndexSearchType$KEY$.MODULE$);
            if (slot == -1) {
                return new TimestampOffset(-1L, this.super$baseOffset());
            }
            return this.parseEntry(idx, slot);
        });
    }

    @Override
    public void truncate() {
        this.truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            TimeIndex.$anonfun$truncateTo$1(this, offset);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    @Override
    public boolean resize(int newSize) {
        boolean bl;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            bl = TimeIndex.$anonfun$resize$1(this, newSize);
        }
        finally {
            inLock_lock.unlock();
        }
        return bl;
    }

    private void truncateToEntries(int entries) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            TimeIndex.$anonfun$truncateToEntries$1(this, entries);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    @Override
    public void sanityCheck() {
        long lastTimestamp = this.lastEntry().timestamp();
        long lastOffset = this.lastEntry().offset();
        if (this._entries() != 0 && lastTimestamp < this.timestamp(this.mmap(), 0)) {
            throw new CorruptIndexException(new StringBuilder(129).append("Corrupt time index found, time index file (").append(this.file().getAbsolutePath()).append(") has ").append("non-zero size but the last timestamp is ").append(lastTimestamp).append(" which is less than the first timestamp ").append(this.timestamp(this.mmap(), 0)).toString());
        }
        if (this._entries() != 0 && lastOffset < super.baseOffset()) {
            throw new CorruptIndexException(new StringBuilder(123).append("Corrupt time index found, time index file (").append(this.file().getAbsolutePath()).append(") has ").append("non-zero size but the last offset is ").append(lastOffset).append(" which is less than the first offset ").append(super.baseOffset()).toString());
        }
        if (this.length() % (long)this.entrySize() != 0L) {
            throw new CorruptIndexException(new StringBuilder(87).append("Time index file ").append(this.file().getAbsolutePath()).append(" is corrupt, found ").append(this.length()).append(" bytes ").append("which is neither positive nor a multiple of ").append(this.entrySize()).append(".").toString());
        }
    }

    public static final /* synthetic */ String $anonfun$new$1(TimeIndex $this) {
        return new StringBuilder(99).append("Loaded index file ").append($this.file().getAbsolutePath()).append(" with maxEntries = ").append($this.maxEntries()).append(", maxIndexSize = ").append($this.super$maxIndexSize()).append(",").append(" entries = ").append($this._entries()).append(", lastOffset = ").append($this._lastEntry()).append(", file position = ").append($this.mmap().position()).toString();
    }

    public static final /* synthetic */ TimestampOffset $anonfun$lastEntryFromIndexFile$1(TimeIndex $this) {
        int n = $this._entries();
        switch (n) {
            case 0: {
                return new TimestampOffset(-1L, $this.super$baseOffset());
            }
        }
        return $this.parseEntry($this.mmap(), n - 1);
    }

    public static final /* synthetic */ String $anonfun$maybeAppend$3(TimeIndex $this, long timestamp$1, long offset$1) {
        return new StringBuilder(28).append("Adding index entry ").append(timestamp$1).append(" => ").append(offset$1).append(" to ").append($this.file().getAbsolutePath()).append(".").toString();
    }

    public static final /* synthetic */ void $anonfun$maybeAppend$1(TimeIndex $this, boolean skipFullCheck$1, long offset$1, long timestamp$1) {
        if (!skipFullCheck$1) {
            Predef$.MODULE$.require(!$this.isFull(), (Function0 & Serializable)() -> new StringBuilder(49).append("Attempt to append to a full time index (size = ").append($this._entries()).append(").").toString());
        }
        if ($this._entries() != 0 && offset$1 < $this.lastEntry().offset()) {
            throw new InvalidOffsetException(new StringBuilder(87).append("Attempt to append an offset (").append(offset$1).append(") to slot ").append($this._entries()).append(" no larger than").append(" the last offset appended (").append($this.lastEntry().offset()).append(") to ").append($this.file().getAbsolutePath()).append(".").toString());
        }
        if ($this._entries() != 0 && timestamp$1 < $this.lastEntry().timestamp()) {
            throw new IllegalStateException(new StringBuilder(92).append("Attempt to append a timestamp (").append(timestamp$1).append(") to slot ").append($this._entries()).append(" no larger").append(" than the last timestamp appended (").append($this.lastEntry().timestamp()).append(") to ").append($this.file().getAbsolutePath()).append(".").toString());
        }
        if (timestamp$1 > $this.lastEntry().timestamp()) {
            TimeIndex$ trace_this = TimeIndex$.MODULE$;
            if (trace_this.logger().underlying().isTraceEnabled()) {
                String msgWithLogIdent_msg = TimeIndex.$anonfun$maybeAppend$3($this, timestamp$1, offset$1);
                Object var7_5 = null;
                trace_this.logger().underlying().trace(Logging.msgWithLogIdent$(trace_this, msgWithLogIdent_msg));
            }
            Object var6_4 = null;
            $this.mmap().putLong(timestamp$1);
            $this.mmap().putInt($this.relativeOffset(offset$1));
            $this._entries_$eq($this._entries() + 1);
            $this._lastEntry_$eq(new TimestampOffset(timestamp$1, offset$1));
            Predef$.MODULE$.require($this._entries() * $this.entrySize() == $this.mmap().position(), (Function0 & Serializable)() -> new StringBuilder(40).append($this._entries()).append(" entries but file position in index is ").append($this.mmap().position()).append(".").toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$truncateTo$1(TimeIndex $this, long offset$2) {
        ByteBuffer idx = $this.mmap().duplicate();
        int slot = $this.largestLowerBoundSlotFor(idx, offset$2, IndexSearchType$VALUE$.MODULE$);
        int newEntries = slot < 0 ? 0 : ((long)$this.relativeOffset(idx, slot) == offset$2 - $this.super$baseOffset() ? slot : slot + 1);
        $this.truncateToEntries(newEntries);
    }

    public static final /* synthetic */ boolean $anonfun$resize$1(TimeIndex $this, int newSize$1) {
        if ($this.super$resize(newSize$1)) {
            $this._lastEntry_$eq($this.lastEntryFromIndexFile());
            return true;
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$truncateToEntries$2(TimeIndex $this, int entries$1) {
        return new StringBuilder(69).append("Truncated index ").append($this.file().getAbsolutePath()).append(" to ").append(entries$1).append(" entries; position is now ").append($this.mmap().position()).append(" and last entry is now ").append($this._lastEntry()).toString();
    }

    public static final /* synthetic */ void $anonfun$truncateToEntries$1(TimeIndex $this, int entries$1) {
        $this._entries_$eq(entries$1);
        $this.mmap().position($this._entries() * $this.entrySize());
        $this._lastEntry_$eq($this.lastEntryFromIndexFile());
        TimeIndex$ debug_this = TimeIndex$.MODULE$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = TimeIndex.$anonfun$truncateToEntries$2($this, entries$1);
            Object var3_3 = null;
            debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
            return;
        }
    }

    public TimeIndex(File _file, long baseOffset, int maxIndexSize, boolean fileAlreadyExists, boolean writable) {
        super(_file, baseOffset, maxIndexSize, fileAlreadyExists, writable);
        TimeIndex$ debug_this = TimeIndex$.MODULE$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = TimeIndex.$anonfun$new$1(this);
            Object var8_7 = null;
            debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
            return;
        }
    }
}

