/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import kafka.metrics.LinuxCpuMetricsCollector$SystemCpuTime$;
import net.jcip.annotations.GuardedBy;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r5g\u0001B7o\u0001MD\u0001B\u001f\u0001\u0003\u0002\u0003\u0006Ia\u001f\u0005\u000b\u0003\u001b\u0001!Q1A\u0005\u0002\u0005=\u0001BCA\u0016\u0001\t\u0005\t\u0015!\u0003\u0002\u0012!Q\u0011Q\u0006\u0001\u0003\u0006\u0004%\t!a\f\t\u0015\u0005u\u0002A!A!\u0002\u0013\t\t\u0004\u0003\u0006\u0002@\u0001\u0011)\u0019!C\u0001\u0003\u0003B!\"a\u0014\u0001\u0005\u0003\u0005\u000b\u0011BA\"\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'B\u0011\"!\u0019\u0001\u0005\u0004%I!a\u0019\t\u0011\u0005e\u0004\u0001)A\u0005\u0003KB\u0011\"a\u001f\u0001\u0005\u0004%I!a\u0019\t\u0011\u0005u\u0004\u0001)A\u0005\u0003KB\u0011\"a \u0001\u0005\u0004%I!!!\t\u0011\u0005]\u0005\u0001)A\u0005\u0003\u0007C\u0011\"!'\u0001\u0001\u0004%I!a'\t\u0013\u0005u\u0005\u00011A\u0005\n\u0005}\u0005\u0002CAV\u0001\u0001\u0006K!a\u000e\t\u0013\u0005\u001d\u0007\u00011A\u0005\n\u0005%\u0007\"CAi\u0001\u0001\u0007I\u0011BAj\u0011!\t9\u000e\u0001Q!\n\u0005-\u0007\"CAn\u0001\u0001\u0007I\u0011BAe\u0011%\ti\u000e\u0001a\u0001\n\u0013\ty\u000e\u0003\u0005\u0002d\u0002\u0001\u000b\u0015BAf\u0011%\t9\u000f\u0001a\u0001\n\u0013\tI\rC\u0005\u0002j\u0002\u0001\r\u0011\"\u0003\u0002l\"A\u0011q\u001e\u0001!B\u0013\tY\rC\u0005\u0002t\u0002\u0011\r\u0011\"\u0003\u0002\u0002\"A\u0011Q\u001f\u0001!\u0002\u0013\t\u0019\tC\u0005\u0002x\u0002\u0001\r\u0011\"\u0003\u0002\u001c\"I\u0011\u0011 \u0001A\u0002\u0013%\u00111 \u0005\t\u0003\u007f\u0004\u0001\u0015)\u0003\u00028!I!Q\u0001\u0001A\u0002\u0013%\u00111\u0014\u0005\n\u0005\u000f\u0001\u0001\u0019!C\u0005\u0005\u0013A\u0001B!\u0004\u0001A\u0003&\u0011q\u0007\u0005\n\u0005#\u0001!\u0019!C\u0005\u0005'A\u0001B!\t\u0001A\u0003%!Q\u0003\u0005\n\u0005G\u0001!\u0019!C\u0005\u0005'A\u0001B!\n\u0001A\u0003%!Q\u0003\u0005\n\u0005O\u0001!\u0019!C\u0005\u0005SA\u0001B!\f\u0001A\u0003%!1\u0006\u0005\n\u0005_\u0001!\u0019!C\u0005\u0003\u0003C\u0001B!\r\u0001A\u0003%\u00111\u0011\u0005\n\u0005g\u0001\u0001\u0019!C\u0005\u00037C\u0011B!\u000e\u0001\u0001\u0004%IAa\u000e\t\u0011\tm\u0002\u0001)Q\u0005\u0003oA\u0011B!\u0011\u0001\u0001\u0004%I!a'\t\u0013\t\r\u0003\u00011A\u0005\n\t\u0015\u0003\u0002\u0003B%\u0001\u0001\u0006K!a\u000e\u0007\r\t5\u0003\u0001\u0011B(\u0011)\u0011I'\rBK\u0002\u0013\u0005\u00111\u0014\u0005\u000b\u0005W\n$\u0011#Q\u0001\n\u0005]\u0002B\u0003B7c\tU\r\u0011\"\u0001\u0002\u001c\"Q!qN\u0019\u0003\u0012\u0003\u0006I!a\u000e\t\u0015\tE\u0014G!f\u0001\n\u0003\tY\n\u0003\u0006\u0003tE\u0012\t\u0012)A\u0005\u0003oA!B!\u001e2\u0005+\u0007I\u0011AAN\u0011)\u00119(\rB\tB\u0003%\u0011q\u0007\u0005\u000b\u0005s\n$Q3A\u0005\u0002\u0005m\u0005B\u0003B>c\tE\t\u0015!\u0003\u00028!Q!QP\u0019\u0003\u0016\u0004%\t!a'\t\u0015\t}\u0014G!E!\u0002\u0013\t9\u0004\u0003\u0006\u0003\u0002F\u0012)\u001a!C\u0001\u00037C!Ba!2\u0005#\u0005\u000b\u0011BA\u001c\u0011)\u0011))\rBK\u0002\u0013\u0005\u00111\u0014\u0005\u000b\u0005\u000f\u000b$\u0011#Q\u0001\n\u0005]\u0002B\u0003BEc\tU\r\u0011\"\u0001\u0002\u001c\"Q!1R\u0019\u0003\u0012\u0003\u0006I!a\u000e\t\u0015\t5\u0015G!f\u0001\n\u0003\tY\n\u0003\u0006\u0003\u0010F\u0012\t\u0012)A\u0005\u0003oAq!!\u00152\t\u0003\u0011\t\nC\u0005\u0003,F\u0012\r\u0011\"\u0001\u0002\u001c\"A!QV\u0019!\u0002\u0013\t9\u0004C\u0005\u00030F\n\t\u0011\"\u0001\u00032\"I!qY\u0019\u0012\u0002\u0013\u0005!\u0011\u001a\u0005\n\u0005?\f\u0014\u0013!C\u0001\u0005\u0013D\u0011B!92#\u0003%\tA!3\t\u0013\t\r\u0018'%A\u0005\u0002\t%\u0007\"\u0003BscE\u0005I\u0011\u0001Be\u0011%\u00119/MI\u0001\n\u0003\u0011I\rC\u0005\u0003jF\n\n\u0011\"\u0001\u0003J\"I!1^\u0019\u0012\u0002\u0013\u0005!\u0011\u001a\u0005\n\u0005[\f\u0014\u0013!C\u0001\u0005\u0013D\u0011Ba<2#\u0003%\tA!3\t\u0013\tE\u0018'!A\u0005B\tM\b\"\u0003B\u0000c\u0005\u0005I\u0011AB\u0001\u0011%\u0019I!MA\u0001\n\u0003\u0019Y\u0001C\u0005\u0004\u0016E\n\t\u0011\"\u0011\u0004\u0018!I1QE\u0019\u0002\u0002\u0013\u00051q\u0005\u0005\n\u0007c\t\u0014\u0011!C!\u0007gA\u0011ba\u000e2\u0003\u0003%\te!\u000f\t\u0013\rm\u0012'!A\u0005B\ru\u0002\"CB c\u0005\u0005I\u0011IB!\u000f%\u0019)\u0005AA\u0001\u0012\u0003\u00199EB\u0005\u0003N\u0001\t\t\u0011#\u0001\u0004J!9\u0011\u0011\u000b0\u0005\u0002\r\u0005\u0004\"CB\u001e=\u0006\u0005IQIB\u001f\u0011%\u0019\u0019GXA\u0001\n\u0003\u001b)\u0007C\u0005\u0004|y\u000b\t\u0011\"!\u0004~!911\u0012\u0001\u0005\u0002\r5\u0005bBBH\u0001\u0011\u00051Q\u0012\u0005\b\u0007#\u0003A\u0011BBJ\u0011!\u0019I\n\u0001C\u0001]\u000em\u0005bBBO\u0001\u0011\u00051Q\u0012\u0005\b\u0007?\u0003A\u0011ABG\u0011\u001d\u0019\t\u000b\u0001C\u0001\u0007\u001bCqaa)\u0001\t\u0013\u0019)\u000bC\u0004\u0004,\u0002!\ta!,\t\u000f\r=\u0006\u0001\"\u0001\u00042\nAB*\u001b8vq\u000e\u0003X/T3ue&\u001c7oQ8mY\u0016\u001cGo\u001c:\u000b\u0005=\u0004\u0018aB7fiJL7m\u001d\u0006\u0002c\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001u!\t)\b0D\u0001w\u0015\u00059\u0018!B:dC2\f\u0017BA=w\u0005\u0019\te.\u001f*fM\u0006A\u0001O]8d%>|G\u000fE\u0002}\u0003\u000fq1!`A\u0002!\tqh/D\u0001\u0000\u0015\r\t\tA]\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0015a/\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0013\tYA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000b1\u0018\u0001\u0002;j[\u0016,\"!!\u0005\u0011\t\u0005M\u0011qE\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u0005)Q\u000f^5mg*!\u00111DA\u000f\u0003\u0019\u0019w.\\7p]*\u0019\u0011/a\b\u000b\t\u0005\u0005\u00121E\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\u0015\u0012aA8sO&!\u0011\u0011FA\u000b\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u0019A\u0014xnY3tg&#w\n\u001d;\u0016\u0005\u0005E\u0002#B;\u00024\u0005]\u0012bAA\u001bm\n1q\n\u001d;j_:\u00042!^A\u001d\u0013\r\tYD\u001e\u0002\u0005\u0019>tw-A\u0007qe>\u001cWm]:JI>\u0003H\u000fI\u0001\u0007Y><w-\u001a:\u0016\u0005\u0005\r\u0003\u0003BA#\u0003\u0017j!!a\u0012\u000b\t\u0005%\u00131E\u0001\u0006g24GG[\u0005\u0005\u0003\u001b\n9E\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003\u0019a\u0014N\\5u}QQ\u0011QKA-\u00037\ni&a\u0018\u0011\u0007\u0005]\u0003!D\u0001o\u0011\u0015Q\b\u00021\u0001|\u0011\u001d\ti\u0001\u0003a\u0001\u0003#Aq!!\f\t\u0001\u0004\t\t\u0004C\u0004\u0002@!\u0001\r!a\u0011\u0002\u00171|\u0017\rZ!wOB\u000bG\u000f[\u000b\u0003\u0003K\u0002B!a\u001a\u0002v5\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\ni'\u0001\u0003gS2,'\u0002BA8\u0003c\n1A\\5p\u0015\t\t\u0019(\u0001\u0003kCZ\f\u0017\u0002BA<\u0003S\u0012A\u0001U1uQ\u0006aAn\\1e\u0003Z<\u0007+\u0019;iA\u0005A1\u000f^1u!\u0006$\b.A\u0005ti\u0006$\b+\u0019;iA\u0005YAn\\1e\u0003Z<Gj\\2l+\t\t\u0019\t\u0005\u0003\u0002\u0006\u0006MUBAAD\u0015\u0011\tI)a#\u0002\u000b1|7m[:\u000b\t\u00055\u0015qR\u0001\u000bG>t7-\u001e:sK:$(\u0002BAI\u0003c\nA!\u001e;jY&!\u0011QSAD\u00055\u0011V-\u001a8ue\u0006tG\u000fT8dW\u0006aAn\\1e\u0003Z<Gj\\2lA\u0005\u0019B.Y:u\u0019>\fG-\u0011<h+B$\u0017\r^3NgV\u0011\u0011qG\u0001\u0018Y\u0006\u001cH\u000fT8bI\u00063x-\u00169eCR,Wj]0%KF$B!!)\u0002(B\u0019Q/a)\n\u0007\u0005\u0015fO\u0001\u0003V]&$\b\"CAU!\u0005\u0005\t\u0019AA\u001c\u0003\rAH%M\u0001\u0015Y\u0006\u001cH\u000fT8bI\u00063x-\u00169eCR,Wj\u001d\u0011)\u000fE\ty+a1\u0002FB!\u0011\u0011WA`\u001b\t\t\u0019L\u0003\u0003\u00026\u0006]\u0016aC1o]>$\u0018\r^5p]NTA!!/\u0002<\u0006!!nY5q\u0015\t\ti,A\u0002oKRLA!!1\u00024\nIq)^1sI\u0016$')_\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003\u007f\nQ\u0002\\8bI\u00063xm\u00148f\u001b&tWCAAf!\r)\u0018QZ\u0005\u0004\u0003\u001f4(A\u0002#pk\ndW-A\tm_\u0006$\u0017I^4P]\u0016l\u0015N\\0%KF$B!!)\u0002V\"I\u0011\u0011V\n\u0002\u0002\u0003\u0007\u00111Z\u0001\u000fY>\fG-\u0011<h\u001f:,W*\u001b8!Q\u001d!\u0012qVAb\u0003\u000b\fa\u0002\\8bI\u00063xMR5wK6Kg.\u0001\nm_\u0006$\u0017I^4GSZ,W*\u001b8`I\u0015\fH\u0003BAQ\u0003CD\u0011\"!+\u0017\u0003\u0003\u0005\r!a3\u0002\u001f1|\u0017\rZ!wO\u001aKg/Z'j]\u0002BsaFAX\u0003\u0007\f)-A\tm_\u0006$\u0017I^4GS\u001a$X-\u001a8NS:\fQ\u0003\\8bI\u00063xMR5gi\u0016,g.T5o?\u0012*\u0017\u000f\u0006\u0003\u0002\"\u00065\b\"CAU3\u0005\u0005\t\u0019AAf\u0003Iaw.\u00193Bm\u001e4\u0015N\u001a;fK:l\u0015N\u001c\u0011)\u000fi\ty+a1\u0002F\u0006i1/_:uK6\u001c\u0005/\u001e'pG.\fab]=ti\u0016l7\t];M_\u000e\\\u0007%\u0001\u0007u_R\fGn\u00119v)&lW-\u0001\tu_R\fGn\u00119v)&lWm\u0018\u0013fcR!\u0011\u0011UA\u007f\u0011%\tIKHA\u0001\u0002\u0004\t9$A\u0007u_R\fGn\u00119v)&lW\r\t\u0015\b?\u0005=\u00161\u0019B\u0002C\t\t\u00190A\u0007u_R\fG.\u00133mKRKW.Z\u0001\u0012i>$\u0018\r\\%eY\u0016$\u0016.\\3`I\u0015\fH\u0003BAQ\u0005\u0017A\u0011\"!+\"\u0003\u0003\u0005\r!a\u000e\u0002\u001dQ|G/\u00197JI2,G+[7fA!:!%a,\u0002D\n\r\u0011\u0001D:qC\u000e,\u0007+\u0019;uKJtWC\u0001B\u000b!\u0011\u00119B!\b\u000e\u0005\te!\u0002\u0002B\u000e\u0003\u001f\u000bQA]3hKbLAAa\b\u0003\u001a\t9\u0001+\u0019;uKJt\u0017!D:qC\u000e,\u0007+\u0019;uKJt\u0007%\u0001\u000eqCJ,g\u000e\u001e5fg&\u001cXI\\2m_N,G\rU1ui\u0016\u0014h.A\u000eqCJ,g\u000e\u001e5fg&\u001cXI\\2m_N,G\rU1ui\u0016\u0014h\u000eI\u0001\u0013aJ|7-Z:t'R\fG\u000fU1uQ>\u0003H/\u0006\u0002\u0003,A)Q/a\r\u0002f\u0005\u0019\u0002O]8dKN\u001c8\u000b^1u!\u0006$\bn\u00149uA\u0005q\u0001O]8dKN\u001c8\t];M_\u000e\\\u0017a\u00049s_\u000e,7o]\"qk2{7m\u001b\u0011\u0002#1\f7\u000f^*zgR,WNS5gM&,7/A\u000bmCN$8+_:uK6T\u0015N\u001a4jKN|F%Z9\u0015\t\u0005\u0005&\u0011\b\u0005\n\u0003Sc\u0013\u0011!a\u0001\u0003o\t!\u0003\\1tiNK8\u000f^3n\u0015&4g-[3tA!:Q&a,\u0002D\n}\u0012E\u0001B\u0018\u0003Ia\u0017m\u001d;Qe>\u001cWm]:KS\u001a4\u0017.Z:\u0002-1\f7\u000f\u001e)s_\u000e,7o\u001d&jM\u001aLWm]0%KF$B!!)\u0003H!I\u0011\u0011V\u0018\u0002\u0002\u0003\u0007\u0011qG\u0001\u0014Y\u0006\u001cH\u000f\u0015:pG\u0016\u001c8OS5gM&,7\u000f\t\u0015\ba\u0005=\u00161\u0019B \u00055\u0019\u0016p\u001d;f[\u000e\u0003X\u000fV5nKN1\u0011\u0007\u001eB)\u0005/\u00022!\u001eB*\u0013\r\u0011)F\u001e\u0002\b!J|G-^2u!\u0011\u0011IFa\u0019\u000f\t\tm#q\f\b\u0004}\nu\u0013\"A<\n\u0007\t\u0005d/A\u0004qC\u000e\\\u0017mZ3\n\t\t\u0015$q\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u0005C2\u0018\u0001B;tKJ\fQ!^:fe\u0002\nAA\\5dK\u0006)a.[2fA\u000511/_:uK6\fqa]=ti\u0016l\u0007%\u0001\u0003jI2,\u0017!B5eY\u0016\u0004\u0013AB5p/\u0006LG/A\u0004j_^\u000b\u0017\u000e\u001e\u0011\u0002\u0007%\u0014\u0018/\u0001\u0003jeF\u0004\u0013aB:pMRL%/]\u0001\tg>4G/\u0013:rA\u0005)1\u000f^3bY\u000611\u000f^3bY\u0002\nQaZ;fgR\faaZ;fgR\u0004\u0013!C4vKN$h*[2f\u0003)9W/Z:u\u001d&\u001cW\r\t\u000b\u0017\u0005'\u00139J!'\u0003\u001c\nu%q\u0014BQ\u0005G\u0013)Ka*\u0003*B\u0019!QS\u0019\u000e\u0003\u0001AqA!\u001bG\u0001\u0004\t9\u0004C\u0004\u0003n\u0019\u0003\r!a\u000e\t\u000f\tEd\t1\u0001\u00028!9!Q\u000f$A\u0002\u0005]\u0002b\u0002B=\r\u0002\u0007\u0011q\u0007\u0005\b\u0005{2\u0005\u0019AA\u001c\u0011\u001d\u0011\tI\u0012a\u0001\u0003oAqA!\"G\u0001\u0004\t9\u0004C\u0004\u0003\n\u001a\u0003\r!a\u000e\t\u000f\t5e\t1\u0001\u00028\u0005)Ao\u001c;bY\u00061Ao\u001c;bY\u0002\nAaY8qsR1\"1\u0013BZ\u0005k\u00139L!/\u0003<\nu&q\u0018Ba\u0005\u0007\u0014)\rC\u0005\u0003j%\u0003\n\u00111\u0001\u00028!I!QN%\u0011\u0002\u0003\u0007\u0011q\u0007\u0005\n\u0005cJ\u0005\u0013!a\u0001\u0003oA\u0011B!\u001eJ!\u0003\u0005\r!a\u000e\t\u0013\te\u0014\n%AA\u0002\u0005]\u0002\"\u0003B?\u0013B\u0005\t\u0019AA\u001c\u0011%\u0011\t)\u0013I\u0001\u0002\u0004\t9\u0004C\u0005\u0003\u0006&\u0003\n\u00111\u0001\u00028!I!\u0011R%\u0011\u0002\u0003\u0007\u0011q\u0007\u0005\n\u0005\u001bK\u0005\u0013!a\u0001\u0003o\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003L*\"\u0011q\u0007BgW\t\u0011y\r\u0005\u0003\u0003R\nmWB\u0001Bj\u0015\u0011\u0011)Na6\u0002\u0013Ut7\r[3dW\u0016$'b\u0001Bmm\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tu'1\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nabY8qs\u0012\"WMZ1vYR$S'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%o\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012B\u0014AD2paf$C-\u001a4bk2$H%O\u0001\u0010G>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132a\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!>\u0011\t\t](Q`\u0007\u0003\u0005sTAAa?\u0002r\u0005!A.\u00198h\u0013\u0011\tIA!?\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\r\r\u0001cA;\u0004\u0006%\u00191q\u0001<\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\r511\u0003\t\u0004k\u000e=\u0011bAB\tm\n\u0019\u0011I\\=\t\u0013\u0005%f+!AA\u0002\r\r\u0011a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\re\u0001CBB\u000e\u0007C\u0019i!\u0004\u0002\u0004\u001e)\u00191q\u0004<\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004$\ru!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$Ba!\u000b\u00040A\u0019Qoa\u000b\n\u0007\r5bOA\u0004C_>dW-\u00198\t\u0013\u0005%\u0006,!AA\u0002\r5\u0011A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BA!>\u00046!I\u0011\u0011V-\u0002\u0002\u0003\u000711A\u0001\tQ\u0006\u001c\bnQ8eKR\u001111A\u0001\ti>\u001cFO]5oOR\u0011!Q_\u0001\u0007KF,\u0018\r\\:\u0015\t\r%21\t\u0005\n\u0003Sc\u0016\u0011!a\u0001\u0007\u001b\tQbU=ti\u0016l7\t];US6,\u0007c\u0001BK=N)ala\u0013\u0004XAQ2QJB*\u0003o\t9$a\u000e\u00028\u0005]\u0012qGA\u001c\u0003o\t9$a\u000e\u0003\u00146\u00111q\n\u0006\u0004\u0007#2\u0018a\u0002:v]RLW.Z\u0005\u0005\u0007+\u001ayE\u0001\nBEN$(/Y2u\rVt7\r^5p]F\u0002\u0004\u0003BB-\u0007?j!aa\u0017\u000b\t\ru\u0013\u0011O\u0001\u0003S>LAA!\u001a\u0004\\Q\u00111qI\u0001\u0006CB\u0004H.\u001f\u000b\u0017\u0005'\u001b9g!\u001b\u0004l\r54qNB9\u0007g\u001a)ha\u001e\u0004z!9!\u0011N1A\u0002\u0005]\u0002b\u0002B7C\u0002\u0007\u0011q\u0007\u0005\b\u0005c\n\u0007\u0019AA\u001c\u0011\u001d\u0011)(\u0019a\u0001\u0003oAqA!\u001fb\u0001\u0004\t9\u0004C\u0004\u0003~\u0005\u0004\r!a\u000e\t\u000f\t\u0005\u0015\r1\u0001\u00028!9!QQ1A\u0002\u0005]\u0002b\u0002BEC\u0002\u0007\u0011q\u0007\u0005\b\u0005\u001b\u000b\u0007\u0019AA\u001c\u0003\u001d)h.\u00199qYf$Baa \u0004\bB)Q/a\r\u0004\u0002B9Roa!\u00028\u0005]\u0012qGA\u001c\u0003o\t9$a\u000e\u00028\u0005]\u0012qG\u0005\u0004\u0007\u000b3(a\u0002+va2,\u0017\u0007\r\u0005\n\u0007\u0013\u0013\u0017\u0011!a\u0001\u0005'\u000b1\u0001\u001f\u00131\u0003Q\u0019\u0018p\u001d;f[\u000e\u0003X/\u0016;jY&T\u0018\r^5p]R\u0011\u00111Z\u0001\u0016aJ|7-Z:t\u0007B,X\u000b^5mSj\fG/[8o\u0003U\u0019WO\u001d:f]R\u0004&o\\2fgNT\u0015N\u001a4jKN$B!a\u000e\u0004\u0016\"91qS3A\u0002\u0005\u0015\u0014\u0001\u00029bi\"\fAcY;se\u0016tGoU=ti\u0016l'*\u001b4gS\u0016\u001cHC\u0001BJ\u00035yg.Z'j]2{\u0017\rZ!wO\u0006qa-\u001b<f\u001b&tGj\\1e\u0003Z<\u0017!\u00054jMR,WM\\'j]2{\u0017\rZ!wO\u0006iQ\u000f\u001d3bi\u0016du.\u00193Bm\u001e$Ba!\u000b\u0004(\"91\u0011\u00166A\u0002\u0005]\u0012a\u00018po\u00061Qo]1cY\u0016$\"a!\u000b\u0002)5\f\u0017PY3SK\u001eL7\u000f^3s\u001b\u0016$(/[2t)\u0011\t\tka-\t\u000f\rUF\u000e1\u0001\u00048\u0006A!/Z4jgR\u0014\u0018\u0010\u0005\u0003\u0004:\u000e%WBAB^\u0015\u0011\u0019ila0\u0002\t\r|'/\u001a\u0006\u0004_\u000e\u0005'\u0002BBb\u0007\u000b\fa!_1n[\u0016\u0014(BABd\u0003\r\u0019w.\\\u0005\u0005\u0007\u0017\u001cYLA\bNKR\u0014\u0018nY:SK\u001eL7\u000f\u001e:z\u0001")
public class LinuxCpuMetricsCollector {
    private volatile LinuxCpuMetricsCollector$SystemCpuTime$ SystemCpuTime$module;
    private final String procRoot;
    private final Time time;
    private final Option<Object> processIdOpt;
    private final Logger logger;
    private final Path loadAvgPath;
    private final Path statPath;
    private final ReentrantLock loadAvgLock;
    @GuardedBy(value="loadAvgLock")
    private long lastLoadAvgUpdateMs;
    @GuardedBy(value="loadAvgLock")
    private double loadAvgOneMin;
    @GuardedBy(value="loadAvgLock")
    private double loadAvgFiveMin;
    @GuardedBy(value="loadAvgLock")
    private double loadAvgFifteenMin;
    private final ReentrantLock systemCpuLock;
    @GuardedBy(value="systemCpuLock")
    private long totalCpuTime;
    @GuardedBy(value="systemCpuLock")
    private long totalIdleTime;
    private final Pattern spacePattern;
    private final Pattern parenthesisEnclosedPattern;
    private final Option<Path> processStatPathOpt;
    private final ReentrantLock processCpuLock;
    @GuardedBy(value="processCpuLock")
    private long lastSystemJiffies;
    @GuardedBy(value="processCpuLock")
    private long lastProcessJiffies;

    public LinuxCpuMetricsCollector$SystemCpuTime$ SystemCpuTime() {
        if (this.SystemCpuTime$module == null) {
            this.SystemCpuTime$lzycompute$1();
        }
        return this.SystemCpuTime$module;
    }

    public Time time() {
        return this.time;
    }

    public Option<Object> processIdOpt() {
        return this.processIdOpt;
    }

    public Logger logger() {
        return this.logger;
    }

    private Path loadAvgPath() {
        return this.loadAvgPath;
    }

    private Path statPath() {
        return this.statPath;
    }

    private ReentrantLock loadAvgLock() {
        return this.loadAvgLock;
    }

    private long lastLoadAvgUpdateMs() {
        return this.lastLoadAvgUpdateMs;
    }

    private void lastLoadAvgUpdateMs_$eq(long x$1) {
        this.lastLoadAvgUpdateMs = x$1;
    }

    private double loadAvgOneMin() {
        return this.loadAvgOneMin;
    }

    private void loadAvgOneMin_$eq(double x$1) {
        this.loadAvgOneMin = x$1;
    }

    private double loadAvgFiveMin() {
        return this.loadAvgFiveMin;
    }

    private void loadAvgFiveMin_$eq(double x$1) {
        this.loadAvgFiveMin = x$1;
    }

    private double loadAvgFifteenMin() {
        return this.loadAvgFifteenMin;
    }

    private void loadAvgFifteenMin_$eq(double x$1) {
        this.loadAvgFifteenMin = x$1;
    }

    private ReentrantLock systemCpuLock() {
        return this.systemCpuLock;
    }

    private long totalCpuTime() {
        return this.totalCpuTime;
    }

    private void totalCpuTime_$eq(long x$1) {
        this.totalCpuTime = x$1;
    }

    private long totalIdleTime() {
        return this.totalIdleTime;
    }

    private void totalIdleTime_$eq(long x$1) {
        this.totalIdleTime = x$1;
    }

    private Pattern spacePattern() {
        return this.spacePattern;
    }

    private Pattern parenthesisEnclosedPattern() {
        return this.parenthesisEnclosedPattern;
    }

    private Option<Path> processStatPathOpt() {
        return this.processStatPathOpt;
    }

    private ReentrantLock processCpuLock() {
        return this.processCpuLock;
    }

    private long lastSystemJiffies() {
        return this.lastSystemJiffies;
    }

    private void lastSystemJiffies_$eq(long x$1) {
        this.lastSystemJiffies = x$1;
    }

    private long lastProcessJiffies() {
        return this.lastProcessJiffies;
    }

    private void lastProcessJiffies_$eq(long x$1) {
        this.lastProcessJiffies = x$1;
    }

    public double systemCpuUtilization() {
        double d;
        block7: {
            double d2;
            block6: {
                try {
                    try {
                        this.systemCpuLock().lock();
                        SystemCpuTime systemJiffies = this.currentSystemJiffies();
                        long total = systemJiffies.total();
                        long idleTime = systemJiffies.idle() + systemJiffies.ioWait();
                        if (this.totalCpuTime() == 0L) {
                            this.totalCpuTime_$eq(total);
                            this.totalIdleTime_$eq(idleTime);
                            d2 = 0.0;
                            break block6;
                        }
                        long currWindowCpuTime = total - this.totalCpuTime();
                        long currWindowIdleTime = idleTime - this.totalIdleTime();
                        this.totalCpuTime_$eq(total);
                        this.totalIdleTime_$eq(idleTime);
                        double idlePercentage = (double)currWindowIdleTime * 100.0 / (double)currWindowCpuTime;
                        d = 100.0 - idlePercentage;
                    }
                    catch (Throwable t) {
                        this.logger().warn("Unable to update CPU metrics", t);
                        d = -1.0;
                    }
                    break block7;
                }
                finally {
                    this.systemCpuLock().unlock();
                }
            }
            return d2;
        }
        return d;
    }

    public double processCpuUtilization() {
        Option<Path> option = this.processStatPathOpt();
        if (option instanceof Some) {
            double d;
            block10: {
                double d2;
                block9: {
                    Path path = (Path)((Some)option).value();
                    try {
                        try {
                            this.processCpuLock().lock();
                            SystemCpuTime systemJiffies = this.currentSystemJiffies();
                            long processJiffies = this.currentProcessJiffies(path);
                            if (this.lastProcessJiffies() == 0L || this.lastSystemJiffies() == 0L) {
                                this.lastSystemJiffies_$eq(systemJiffies.total());
                                this.lastProcessJiffies_$eq(processJiffies);
                                d2 = 0.0;
                                break block9;
                            }
                            long currentWindowSystemJiffies = systemJiffies.total() - this.lastSystemJiffies();
                            long currentWindowProcessJiffies = processJiffies - this.lastProcessJiffies();
                            this.lastSystemJiffies_$eq(systemJiffies.total());
                            this.lastProcessJiffies_$eq(processJiffies);
                            if (currentWindowSystemJiffies == 0L) {
                                d2 = 0.0;
                                break block9;
                            }
                            d = (double)currentWindowProcessJiffies * 100.0 / (double)currentWindowSystemJiffies;
                        }
                        catch (Throwable t) {
                            this.logger().warn("Unable to update CPU metrics for the process", t);
                            d = -1.0;
                        }
                        break block10;
                    }
                    finally {
                        this.processCpuLock().unlock();
                    }
                }
                return d2;
            }
            return d;
        }
        if (None$.MODULE$.equals(option)) {
            return -1.0;
        }
        throw new MatchError(option);
    }

    private long currentProcessJiffies(Path path) {
        String line = (String)CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(path)).asScala().head();
        line = this.parenthesisEnclosedPattern().matcher(line).replaceFirst("process_name");
        String[] cpu = this.spacePattern().split(line);
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[13])) + StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[14]));
    }

    public SystemCpuTime currentSystemJiffies() {
        String line = (String)CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(this.statPath())).asScala().head();
        String[] cpu = this.spacePattern().split(line);
        return new SystemCpuTime(this, StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[1])), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[2])), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[3])), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[4])), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[5])), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[6])), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[7])), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[8])), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[9])), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[10])));
    }

    public double oneMinLoadAvg() {
        double d;
        try {
            this.loadAvgLock().lock();
            long curMs = this.time().milliseconds();
            if (curMs != this.lastLoadAvgUpdateMs()) {
                this.updateLoadAvg(curMs);
            }
            d = this.loadAvgOneMin();
        }
        finally {
            this.loadAvgLock().unlock();
        }
        return d;
    }

    public double fiveMinLoadAvg() {
        double d;
        try {
            this.loadAvgLock().lock();
            long curMs = this.time().milliseconds();
            if (curMs != this.lastLoadAvgUpdateMs()) {
                this.updateLoadAvg(curMs);
            }
            d = this.loadAvgFiveMin();
        }
        finally {
            this.loadAvgLock().unlock();
        }
        return d;
    }

    public double fifteenMinLoadAvg() {
        double d;
        try {
            this.loadAvgLock().lock();
            long curMs = this.time().milliseconds();
            if (curMs != this.lastLoadAvgUpdateMs()) {
                this.updateLoadAvg(curMs);
            }
            d = this.loadAvgFifteenMin();
        }
        finally {
            this.loadAvgLock().unlock();
        }
        return d;
    }

    private boolean updateLoadAvg(long now) {
        try {
            this.loadAvgOneMin_$eq(-1.0);
            this.loadAvgFiveMin_$eq(-1.0);
            this.loadAvgFifteenMin_$eq(-1.0);
            String[] loadAvgArr = ((String)CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(this.loadAvgPath())).asScala().apply(0)).split("\\s+");
            this.loadAvgOneMin_$eq(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(loadAvgArr[0])));
            this.loadAvgFiveMin_$eq(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(loadAvgArr[1])));
            this.loadAvgFifteenMin_$eq(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(loadAvgArr[2])));
            this.lastLoadAvgUpdateMs_$eq(now);
            return true;
        }
        catch (Throwable t) {
            this.logger().warn("Unable to update CPU metrics", t);
            return false;
        }
    }

    public boolean usable() {
        return this.loadAvgPath().toFile().exists() && this.statPath().toFile().exists();
    }

    public void maybeRegisterMetrics(MetricsRegistry registry) {
        if (this.usable()) {
            LinuxCpuMetricsCollector.registerGauge$1("linux-load-avg-1m", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    LinuxCpuMetricsCollector linuxCpuMetricsCollector = this.$outer;
                    if (linuxCpuMetricsCollector == null) {
                        throw null;
                    }
                    return linuxCpuMetricsCollector.oneMinLoadAvg();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-load-avg-5m", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    LinuxCpuMetricsCollector linuxCpuMetricsCollector = this.$outer;
                    if (linuxCpuMetricsCollector == null) {
                        throw null;
                    }
                    return linuxCpuMetricsCollector.fiveMinLoadAvg();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-load-avg-15m", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    LinuxCpuMetricsCollector linuxCpuMetricsCollector = this.$outer;
                    if (linuxCpuMetricsCollector == null) {
                        throw null;
                    }
                    return linuxCpuMetricsCollector.fifteenMinLoadAvg();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-system-cpu-utilization", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    LinuxCpuMetricsCollector linuxCpuMetricsCollector = this.$outer;
                    if (linuxCpuMetricsCollector == null) {
                        throw null;
                    }
                    return linuxCpuMetricsCollector.systemCpuUtilization();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-process-cpu-utilization", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    LinuxCpuMetricsCollector linuxCpuMetricsCollector = this.$outer;
                    if (linuxCpuMetricsCollector == null) {
                        throw null;
                    }
                    return linuxCpuMetricsCollector.processCpuUtilization();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            return;
        }
    }

    private final void SystemCpuTime$lzycompute$1() {
        synchronized (this) {
            if (this.SystemCpuTime$module == null) {
                this.SystemCpuTime$module = new LinuxCpuMetricsCollector$SystemCpuTime$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ Path $anonfun$processStatPathOpt$1(LinuxCpuMetricsCollector $this, long pid) {
        return Paths.get($this.procRoot, Long.toString(pid), "stat");
    }

    /*
     * WARNING - void declaration
     */
    private static final void registerGauge$1(String name, Gauge gauge, MetricsRegistry registry$1) {
        void getMetricName_typeName;
        String string = "KafkaServer";
        String getMetricName_group = "kafka.server";
        Object var4_4 = null;
        string = null;
        MetricName metricName = KafkaYammerMetrics.getMetricName((String)getMetricName_group, (String)getMetricName_typeName, (String)name, null);
        registry$1.newGauge(metricName, gauge);
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$1() {
        return this.oneMinLoadAvg();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$3() {
        return this.fiveMinLoadAvg();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$5() {
        return this.fifteenMinLoadAvg();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$7() {
        return this.systemCpuUtilization();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$9() {
        return this.processCpuUtilization();
    }

    public LinuxCpuMetricsCollector(String procRoot, Time time, Option<Object> processIdOpt, Logger logger) {
        this.procRoot = procRoot;
        this.time = time;
        this.processIdOpt = processIdOpt;
        this.logger = logger;
        this.loadAvgPath = Paths.get(procRoot, "loadavg");
        this.statPath = Paths.get(procRoot, "stat");
        this.loadAvgLock = new ReentrantLock();
        this.lastLoadAvgUpdateMs = -1L;
        this.loadAvgOneMin = -1.0;
        this.loadAvgFiveMin = -1.0;
        this.loadAvgFifteenMin = -1.0;
        this.systemCpuLock = new ReentrantLock();
        this.totalCpuTime = 0L;
        this.totalIdleTime = 0L;
        this.spacePattern = Pattern.compile("\\s+");
        this.parenthesisEnclosedPattern = Pattern.compile("\\(.*?\\)");
        this.processStatPathOpt = processIdOpt.map((Function1 & Serializable)pid -> LinuxCpuMetricsCollector.$anonfun$processStatPathOpt$1(this, BoxesRunTime.unboxToLong((Object)pid)));
        this.processCpuLock = new ReentrantLock();
        this.lastSystemJiffies = 0L;
        this.lastProcessJiffies = 0L;
    }

    public class SystemCpuTime
    implements Product,
    Serializable {
        private final long user;
        private final long nice;
        private final long system;
        private final long idle;
        private final long ioWait;
        private final long irq;
        private final long softIrq;
        private final long steal;
        private final long guest;
        private final long guestNice;
        private final long total;
        public final /* synthetic */ LinuxCpuMetricsCollector $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long user() {
            return this.user;
        }

        public long nice() {
            return this.nice;
        }

        public long system() {
            return this.system;
        }

        public long idle() {
            return this.idle;
        }

        public long ioWait() {
            return this.ioWait;
        }

        public long irq() {
            return this.irq;
        }

        public long softIrq() {
            return this.softIrq;
        }

        public long steal() {
            return this.steal;
        }

        public long guest() {
            return this.guest;
        }

        public long guestNice() {
            return this.guestNice;
        }

        public long total() {
            return this.total;
        }

        public SystemCpuTime copy(long user, long nice, long system, long idle, long ioWait, long irq, long softIrq, long steal, long guest, long guestNice) {
            return new SystemCpuTime(this.kafka$metrics$LinuxCpuMetricsCollector$SystemCpuTime$$$outer(), user, nice, system, idle, ioWait, irq, softIrq, steal, guest, guestNice);
        }

        public long copy$default$1() {
            return this.user();
        }

        public long copy$default$10() {
            return this.guestNice();
        }

        public long copy$default$2() {
            return this.nice();
        }

        public long copy$default$3() {
            return this.system();
        }

        public long copy$default$4() {
            return this.idle();
        }

        public long copy$default$5() {
            return this.ioWait();
        }

        public long copy$default$6() {
            return this.irq();
        }

        public long copy$default$7() {
            return this.softIrq();
        }

        public long copy$default$8() {
            return this.steal();
        }

        public long copy$default$9() {
            return this.guest();
        }

        public String productPrefix() {
            return "SystemCpuTime";
        }

        public int productArity() {
            return 10;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.user());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.nice());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.system());
                }
                case 3: {
                    return BoxesRunTime.boxToLong((long)this.idle());
                }
                case 4: {
                    return BoxesRunTime.boxToLong((long)this.ioWait());
                }
                case 5: {
                    return BoxesRunTime.boxToLong((long)this.irq());
                }
                case 6: {
                    return BoxesRunTime.boxToLong((long)this.softIrq());
                }
                case 7: {
                    return BoxesRunTime.boxToLong((long)this.steal());
                }
                case 8: {
                    return BoxesRunTime.boxToLong((long)this.guest());
                }
                case 9: {
                    return BoxesRunTime.boxToLong((long)this.guestNice());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SystemCpuTime;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "user";
                }
                case 1: {
                    return "nice";
                }
                case 2: {
                    return "system";
                }
                case 3: {
                    return "idle";
                }
                case 4: {
                    return "ioWait";
                }
                case 5: {
                    return "irq";
                }
                case 6: {
                    return "softIrq";
                }
                case 7: {
                    return "steal";
                }
                case 8: {
                    return "guest";
                }
                case 9: {
                    return "guestNice";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.longHash((long)this.user())), (int)Statics.longHash((long)this.nice())), (int)Statics.longHash((long)this.system())), (int)Statics.longHash((long)this.idle())), (int)Statics.longHash((long)this.ioWait())), (int)Statics.longHash((long)this.irq())), (int)Statics.longHash((long)this.softIrq())), (int)Statics.longHash((long)this.steal())), (int)Statics.longHash((long)this.guest())), (int)Statics.longHash((long)this.guestNice())), (int)10);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof SystemCpuTime && ((SystemCpuTime)x$1).kafka$metrics$LinuxCpuMetricsCollector$SystemCpuTime$$$outer() == this.kafka$metrics$LinuxCpuMetricsCollector$SystemCpuTime$$$outer())) break block3;
                    SystemCpuTime systemCpuTime = (SystemCpuTime)x$1;
                    if (this.user() != systemCpuTime.user() || this.nice() != systemCpuTime.nice() || this.system() != systemCpuTime.system() || this.idle() != systemCpuTime.idle() || this.ioWait() != systemCpuTime.ioWait() || this.irq() != systemCpuTime.irq() || this.softIrq() != systemCpuTime.softIrq() || this.steal() != systemCpuTime.steal() || this.guest() != systemCpuTime.guest() || this.guestNice() != systemCpuTime.guestNice() || !systemCpuTime.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LinuxCpuMetricsCollector kafka$metrics$LinuxCpuMetricsCollector$SystemCpuTime$$$outer() {
            return this.$outer;
        }

        public SystemCpuTime(LinuxCpuMetricsCollector $outer, long user, long nice, long system, long idle, long ioWait, long irq, long softIrq, long steal, long guest, long guestNice) {
            this.user = user;
            this.nice = nice;
            this.system = system;
            this.idle = idle;
            this.ioWait = ioWait;
            this.irq = irq;
            this.softIrq = softIrq;
            this.steal = steal;
            this.guest = guest;
            this.guestNice = guestNice;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
            this.total = user + nice + system + idle + ioWait + irq + softIrq + steal;
        }
    }
}

