/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public final class PrincipalConvertToJson$ {
    public static final PrincipalConvertToJson$ MODULE$ = new PrincipalConvertToJson$();
    private static final String PrincipalClassKey = "class";
    private static final String PrincipalTypeKey = "type";
    private static final String PrincipalNameKey = "name";
    private static final String AuthenticationIdKey = "authenticationId";
    private static final String TokenAuthenticatedKey = "tokenAuthenticated";
    private static final String UserKey = "user";
    private static final String UserResourceIdKey = "userResourceIdKey";
    private static final String TenantNameKey = "tenantName";
    private static final String ClusterIdKey = "clusterId";
    private static final String EnvironmentIdKey = "environmentId";
    private static final String OrganizationIdKey = "organizationId";
    private static final String IsServiceAccountKey = "isServiceAccount";
    private static final String IsApiKeyAuthenticatedKey = "isApiKeyAuthenticated";
    private static final String IsHealthcheckTenantKey = "isHealthcheckTenant";

    public String PrincipalClassKey() {
        return PrincipalClassKey;
    }

    public String PrincipalTypeKey() {
        return PrincipalTypeKey;
    }

    public String PrincipalNameKey() {
        return PrincipalNameKey;
    }

    public String AuthenticationIdKey() {
        return AuthenticationIdKey;
    }

    public String TokenAuthenticatedKey() {
        return TokenAuthenticatedKey;
    }

    public String UserKey() {
        return UserKey;
    }

    public String UserResourceIdKey() {
        return UserResourceIdKey;
    }

    public String TenantNameKey() {
        return TenantNameKey;
    }

    public String ClusterIdKey() {
        return ClusterIdKey;
    }

    public String EnvironmentIdKey() {
        return EnvironmentIdKey;
    }

    public String OrganizationIdKey() {
        return OrganizationIdKey;
    }

    public String IsServiceAccountKey() {
        return IsServiceAccountKey;
    }

    public String IsApiKeyAuthenticatedKey() {
        return IsApiKeyAuthenticatedKey;
    }

    public String IsHealthcheckTenantKey() {
        return IsHealthcheckTenantKey;
    }

    public JsonNode convert(KafkaPrincipal principal) {
        ObjectNode principalNode = new ObjectNode(JsonNodeFactory.instance);
        principalNode.set(this.PrincipalClassKey(), (JsonNode)new TextNode(principal.getClass().getSimpleName()));
        principalNode.set(this.PrincipalTypeKey(), (JsonNode)new TextNode(principal.getPrincipalType()));
        principalNode.set(this.PrincipalNameKey(), (JsonNode)new TextNode(principal.getName()));
        principalNode.set(this.TokenAuthenticatedKey(), (JsonNode)BooleanNode.valueOf((boolean)principal.tokenAuthenticated()));
        if (principal instanceof MultiTenantPrincipal) {
            MultiTenantPrincipal multiTenantPrincipal = (MultiTenantPrincipal)principal;
            PrincipalConvertToJson$.setIfNonEmpty$1(this.AuthenticationIdKey(), multiTenantPrincipal.authenticationId(), principalNode);
            PrincipalConvertToJson$.setIfNonEmpty$1(this.UserKey(), multiTenantPrincipal.user(), principalNode);
            TenantMetadata tenantMetadata = multiTenantPrincipal.tenantMetadata();
            PrincipalConvertToJson$.setIfNonEmpty$1(this.UserResourceIdKey(), tenantMetadata.userResourceId, principalNode);
            PrincipalConvertToJson$.setIfNonEmpty$1(this.TenantNameKey(), tenantMetadata.tenantName, principalNode);
            PrincipalConvertToJson$.setIfNonEmpty$1(this.ClusterIdKey(), tenantMetadata.clusterId, principalNode);
            PrincipalConvertToJson$.setIfNonEmpty$1(this.OrganizationIdKey(), tenantMetadata.organizationId, principalNode);
            PrincipalConvertToJson$.setIfNonEmpty$1(this.EnvironmentIdKey(), tenantMetadata.environmentId, principalNode);
            principalNode.set(this.IsServiceAccountKey(), (JsonNode)BooleanNode.valueOf((boolean)tenantMetadata.isServiceAccount));
            principalNode.set(this.IsApiKeyAuthenticatedKey(), (JsonNode)BooleanNode.valueOf((boolean)tenantMetadata.isApiKeyAuthenticated));
            return principalNode.set(this.IsHealthcheckTenantKey(), (JsonNode)BooleanNode.valueOf((boolean)tenantMetadata.isHealthcheckTenant));
        }
        if (principal instanceof ConfluentPrincipal) {
            ConfluentPrincipal confluentPrincipal = (ConfluentPrincipal)principal;
            return PrincipalConvertToJson$.setIfNonEmpty$1(this.AuthenticationIdKey(), confluentPrincipal.authenticationId(), principalNode);
        }
        return principalNode;
    }

    private static final ObjectNode setIfNonEmpty$1(String field, String value, ObjectNode principalNode$1) {
        if (value != null && !value.isEmpty()) {
            return (ObjectNode)principalNode$1.set(field, (JsonNode)new TextNode(value));
        }
        return principalNode$1;
    }

    private PrincipalConvertToJson$() {
    }
}

