/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Optional;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin$RaftLeader$;
import kafka.log.LogAppendInfo;
import kafka.log.LogOffsetSnapshot;
import kafka.log.SnapshotGenerated$;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.MetadataLogConfig;
import kafka.raft.SegmentPosition;
import kafka.server.AbstractFetchDataInfo;
import kafka.server.FetchDataInfo;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchLogEnd$;
import kafka.server.LogOffsetMetadata;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.ControlRecordUtils;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.OffsetMetadata;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.Snapshots;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.MapOps;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\teh\u0001\u0002\u001b6\u0005iB\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0001\u0016\u0005\t5\u0002\u0011\t\u0011)A\u0005+\"A1\f\u0001B\u0001B\u0003%A\f\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003e\u0011!9\u0007A!A!\u0002\u0013A\u0007\"C@\u0001\u0005\u0003\u0005\u000b\u0011BA\u0001\u0011)\tI\u0001\u0001B\u0001B\u0003%\u00111\u0002\u0005\b\u0003'\u0001A\u0011BA\u000b\u0011\u001d\t)\u0003\u0001C!\u0003OAq!a\u0011\u0001\t\u0003\n)\u0005C\u0004\u0002h\u0001!\t%!\u001b\t\u000f\u00055\u0004\u0001\"\u0003\u0002p!9\u0011\u0011\u0010\u0001\u0005B\u0005m\u0004bBA?\u0001\u0011\u0005\u0013q\u0010\u0005\b\u0003\u0007\u0003A\u0011IAC\u0011\u001d\t\t\u0004\u0001C!\u0003\u001bCq!a$\u0001\t\u0003\n\t\nC\u0004\u0002\u001e\u0002!\t%a(\t\u000f\u0005\u001d\u0006\u0001\"\u0011\u0002*\"9\u0011Q\u0016\u0001\u0005B\u0005=\u0006bBA[\u0001\u0011\u0005\u0013Q\u0011\u0005\b\u0003o\u0003A\u0011IA]\u0011\u001d\ty\f\u0001C!\u0003\u001bCaa \u0001\u0005B\u0005\u0005\u0007bBAb\u0001\u0011\u0005\u0013Q\u0019\u0005\b\u0003\u001b\u0004A\u0011IAh\u0011\u001d\t9\u000f\u0001C!\u0003SDq!!<\u0001\t\u0003\ny\u000fC\u0004\u0002|\u0002!\t%!@\t\u000f\u0005}\b\u0001\"\u0011\u0003\u0002!9!Q\u0001\u0001\u0005B\t\u0005\u0001b\u0002B\u0004\u0001\u0011\u0005#\u0011\u0002\u0005\b\u0005\u001b\u0001A\u0011\tB\b\u0011\u001d\u0011\u0019\u0002\u0001C\u0005\u0005+AqA!\u000e\u0001\t\u0013\u00119\u0004C\u0004\u0003>\u0001!\t%a(\t\u000f\t}\u0002\u0001\"\u0003\u0003B!9!Q\n\u0001\u0005\n\u0005}\u0005b\u0002B(\u0001\u0011%\u0011q\u0014\u0005\b\u0005#\u0002A\u0011\u0002B*\u0011\u001d\u0011I\u0006\u0001C\u0005\u00057BqA!\u0019\u0001\t\u0003\u0012\u0019\u0007\u0003\u0005\u0003f\u0001!\t!NA>\u000f\u001d\u00119'\u000eE\u0001\u0005S2a\u0001N\u001b\t\u0002\t-\u0004bBA\n[\u0011\u0005!1\u000f\u0005\b\u0005kjC\u0011\u0001B<\u0011\u001d\u0011\t+\fC\u0001\u0005GCqAa-.\t\u0013\u0011)\fC\u0005\u0003>6\n\n\u0011\"\u0003\u0003@\"9!Q[\u0017\u0005\n\t]'\u0001E&bM.\fW*\u001a;bI\u0006$\u0018\rT8h\u0015\t1t'\u0001\u0003sC\u001a$(\"\u0001\u001d\u0002\u000b-\fgm[1\u0004\u0001M!\u0001aO\"N!\ta\u0014)D\u0001>\u0015\tqt(\u0001\u0003mC:<'\"\u0001!\u0002\t)\fg/Y\u0005\u0003\u0005v\u0012aa\u00142kK\u000e$\bC\u0001#L\u001b\u0005)%B\u0001\u001cG\u0015\tAtI\u0003\u0002I\u0013\u00061\u0011\r]1dQ\u0016T\u0011AS\u0001\u0004_J<\u0017B\u0001'F\u00055\u0011V\r\u001d7jG\u0006$X\r\u001a'pOB\u0011a*U\u0007\u0002\u001f*\u0011\u0001kN\u0001\u0006kRLGn]\u0005\u0003%>\u0013q\u0001T8hO&tw-A\u0002m_\u001e,\u0012!\u0016\t\u0003-bk\u0011a\u0016\u0006\u0003'^J!!W,\u0003\u0017\u0005\u00137\u000f\u001e:bGRdunZ\u0001\u0005Y><\u0007%\u0001\u0003uS6,\u0007CA/b\u001b\u0005q&B\u0001)`\u0015\t\u0001g)\u0001\u0004d_6lwN\\\u0005\u0003Ez\u0013A\u0001V5nK\u0006I1o\u00195fIVdWM\u001d\t\u0003\u001d\u0016L!AZ(\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018!C:oCB\u001c\bn\u001c;t!\u0011I\u0007O];\u000e\u0003)T!a\u001b7\u0002\u000f5,H/\u00192mK*\u0011QN\\\u0001\u000bG>dG.Z2uS>t'\"A8\u0002\u000bM\u001c\u0017\r\\1\n\u0005ET'a\u0002+sK\u0016l\u0015\r\u001d\t\u0003\tNL!\u0001^#\u0003\u001d=3gm]3u\u0003:$W\t]8dQB\u0019ao^=\u000e\u00039L!\u0001\u001f8\u0003\r=\u0003H/[8o!\tQX0D\u0001|\u0015\tah)\u0001\u0005t]\u0006\u00048\u000f[8u\u0013\tq8PA\u000bGS2,'+Y<T]\u0006\u00048\u000f[8u%\u0016\fG-\u001a:\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!\u00111AA\u0003\u001b\u0005y\u0016bAA\u0004?\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017AB2p]\u001aLw\r\u0005\u0003\u0002\u000e\u0005=Q\"A\u001b\n\u0007\u0005EQGA\tNKR\fG-\u0019;b\u0019><7i\u001c8gS\u001e\fa\u0001P5oSRtDCDA\f\u00033\tY\"!\b\u0002 \u0005\u0005\u00121\u0005\t\u0004\u0003\u001b\u0001\u0001\"B*\t\u0001\u0004)\u0006\"B.\t\u0001\u0004a\u0006\"B2\t\u0001\u0004!\u0007\"B4\t\u0001\u0004A\u0007BB@\t\u0001\u0004\t\t\u0001C\u0004\u0002\n!\u0001\r!a\u0003\u0002\tI,\u0017\r\u001a\u000b\u0007\u0003S\ty#!\u000f\u0011\u0007\u0011\u000bY#C\u0002\u0002.\u0015\u0013A\u0002T8h\r\u0016$8\r[%oM>Dq!!\r\n\u0001\u0004\t\u0019$A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\bc\u0001<\u00026%\u0019\u0011q\u00078\u0003\t1{gn\u001a\u0005\b\u0003wI\u0001\u0019AA\u001f\u00035\u0011X-\u00193Jg>d\u0017\r^5p]B\u0019A)a\u0010\n\u0007\u0005\u0005SIA\u0005Jg>d\u0017\r^5p]\u0006q\u0011\r\u001d9f]\u0012\f5\u000fT3bI\u0016\u0014HCBA$\u0003\u001b\ni\u0006E\u0002E\u0003\u0013J1!a\u0013F\u00055aunZ!qa\u0016tG-\u00138g_\"9\u0011q\n\u0006A\u0002\u0005E\u0013a\u0002:fG>\u0014Hm\u001d\t\u0005\u0003'\nI&\u0004\u0002\u0002V)\u0019\u0011qK0\u0002\rI,7m\u001c:e\u0013\u0011\tY&!\u0016\u0003\u000fI+7m\u001c:eg\"9\u0011q\f\u0006A\u0002\u0005\u0005\u0014!B3q_\u000eD\u0007c\u0001<\u0002d%\u0019\u0011Q\r8\u0003\u0007%sG/\u0001\tbaB,g\u000eZ!t\r>dGn\\<feR!\u0011qIA6\u0011\u001d\tye\u0003a\u0001\u0003#\nQ\u0004[1oI2,\u0017I\u001c3D_:4XM\u001d;M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u000b\u0005\u0003\u000f\n\t\bC\u0004\u0002t1\u0001\r!!\u001e\u0002\u0015\u0005\u0004\b/\u001a8e\u0013:4w\u000eE\u0002W\u0003oJ1!a\u0013X\u0003Aa\u0017m\u001d;GKR\u001c\u0007.\u001a3Fa>\u001c\u0007\u000e\u0006\u0002\u0002b\u0005\tRM\u001c3PM\u001a\u001cX\r\u001e$pe\u0016\u0003xn\u00195\u0015\u0007I\f\t\tC\u0004\u0002`9\u0001\r!!\u0019\u0002\u0013\u0015tGm\u00144gg\u0016$HCAAD!\r!\u0015\u0011R\u0005\u0004\u0003\u0017+%!\u0005'pO>3gm]3u\u001b\u0016$\u0018\rZ1uCR\u0011\u00111G\u0001\u000biJ,hnY1uKR{G\u0003BAJ\u00033\u00032A^AK\u0013\r\t9J\u001c\u0002\u0005+:LG\u000fC\u0004\u0002\u001cF\u0001\r!a\r\u0002\r=4gm]3u\u0003a!(/\u001e8dCR,Gk\u001c'bi\u0016\u001cHo\u00158baNDw\u000e\u001e\u000b\u0003\u0003C\u00032A^AR\u0013\r\t)K\u001c\u0002\b\u0005>|G.Z1o\u0003UIg.\u001b;jC2L'0\u001a'fC\u0012,'/\u00129pG\"$B!a%\u0002,\"9\u0011qL\nA\u0002\u0005\u0005\u0014aE;qI\u0006$X\rS5hQ^\u000bG/\u001a:nCJ\\G\u0003BAJ\u0003cCq!a-\u0015\u0001\u0004\t9)\u0001\bpM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\u0002\u001b!Lw\r[,bi\u0016\u0014X.\u0019:l\u0003\u00151G.^:i)\u0011\t\u0019*a/\t\u000f\u0005uf\u00031\u0001\u0002\"\u00069bm\u001c:dK\u001acWo\u001d5BGRLg/Z*fO6,g\u000e^\u0001\u0012Y\u0006\u001cHO\u00127vg\",Gm\u00144gg\u0016$HCAA\u0001\u0003\u001d!x\u000e]5d\u0013\u0012$\"!a2\u0011\t\u0005\r\u0011\u0011Z\u0005\u0004\u0003\u0017|&\u0001B+vS\u0012\f\u0011c\u0019:fCR,g*Z<T]\u0006\u00048\u000f[8u)\u0011\t\t.a9\u0011\r\u0005M\u0017\u0011\\Ao\u001b\t\t)NC\u0002\u0002X~\nA!\u001e;jY&!\u00111\\Ak\u0005!y\u0005\u000f^5p]\u0006d\u0007c\u0001>\u0002`&\u0019\u0011\u0011]>\u0003#I\u000bwo\u00158baNDw\u000e^,sSR,'\u000f\u0003\u0004\u0002fj\u0001\rA]\u0001\u000bg:\f\u0007o\u001d5pi&#\u0017!D:u_J,7K\\1qg\"|G\u000f\u0006\u0003\u0002R\u0006-\bBBAs7\u0001\u0007!/\u0001\u0007sK\u0006$7K\\1qg\"|G\u000f\u0006\u0003\u0002r\u0006e\bCBAj\u00033\f\u0019\u0010E\u0002{\u0003kL1!a>|\u0005E\u0011\u0016m^*oCB\u001c\bn\u001c;SK\u0006$WM\u001d\u0005\u0007\u0003Kd\u0002\u0019\u0001:\u0002\u001d1\fG/Z:u':\f\u0007o\u001d5piR\u0011\u0011\u0011_\u0001\u0011Y\u0006$Xm\u001d;T]\u0006\u00048\u000f[8u\u0013\u0012$\"Aa\u0001\u0011\u000b\u0005M\u0017\u0011\u001c:\u0002%\u0015\f'\u000f\\5fgR\u001cf.\u00199tQ>$\u0018\nZ\u0001\u0011_:\u001cf.\u00199tQ>$hI]8{K:$B!a%\u0003\f!1\u0011Q\u001d\u0011A\u0002I\fA\u0003Z3mKR,')\u001a4pe\u0016\u001cf.\u00199tQ>$H\u0003BAQ\u0005#Aa!!:\"\u0001\u0004\u0011\u0018!\u00057pC\u0012\u001cf.\u00199tQ>$8+\u001b>fgR\u0011!q\u0003\t\u0007\u00053\u0011ICa\f\u000f\t\tm!Q\u0005\b\u0005\u0005;\u0011\u0019#\u0004\u0002\u0003 )\u0019!\u0011E\u001d\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0017b\u0001B\u0014]\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0016\u0005[\u00111aU3r\u0015\r\u00119C\u001c\t\u0007m\nE\"/a\r\n\u0007\tMbN\u0001\u0004UkBdWMM\u0001\u0016e\u0016\fGm\u00158baNDw\u000e\u001e+j[\u0016\u001cH/Y7q)\u0011\u0011IDa\u000f\u0011\tY<\u00181\u0007\u0005\u0007\u0003K\u001c\u0003\u0019\u0001:\u0002\u00155\f\u0017PY3DY\u0016\fg.\u0001\bdY\u0016\fgn\u00158baNDw\u000e^:\u0015\t\u0005\u0005&1\t\u0005\b\u0005\u000b*\u0003\u0019\u0001B$\u0003%\u0001(/\u001a3jG\u0006$X\r\u0005\u0004w\u0005\u0013\u0012\u0018\u0011U\u0005\u0004\u0005\u0017r'!\u0003$v]\u000e$\u0018n\u001c82\u0003e\u0019G.Z1o':\f\u0007o\u001d5piN\u0014V\r^3oi&|g.T:\u00027\rdW-\u00198T]\u0006\u00048\u000f[8ugJ+G/\u001a8uS>t7+\u001b>f\u0003U1wN]4fiNs\u0017\r]:i_R\u001c()\u001a4pe\u0016$2\u0001\u001bB+\u0011\u0019\u00119\u0006\u000ba\u0001e\u0006\u0011Bn\\4Ti\u0006\u0014Ho\u00158baNDw\u000e^%e\u0003=\u0011X-\\8wKNs\u0017\r]:i_R\u001cH\u0003BAJ\u0005;BaAa\u0018*\u0001\u0004A\u0017\u0001E3ya&\u0014X\rZ*oCB\u001c\bn\u001c;t\u0003\u0015\u0019Gn\\:f)\t\t\u0019*A\u0007t]\u0006\u00048\u000f[8u\u0007>,h\u000e^\u0001\u0011\u0017\u000647.Y'fi\u0006$\u0017\r^1M_\u001e\u00042!!\u0004.'\u0011i#QN'\u0011\u0007Y\u0014y'C\u0002\u0003r9\u0014a!\u00118z%\u00164GC\u0001B5\u0003\u0015\t\u0007\u000f\u001d7z)A\t9B!\u001f\u0003|\tu$Q\u0012BH\u0005;\u0013y\n\u0003\u0004\u0000_\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003\u0007|\u0003\u0019AAd\u0011\u001d\u0011yh\fa\u0001\u0005\u0003\u000bq\u0001Z1uC\u0012K'\u000f\u0005\u0003\u0003\u0004\n%UB\u0001BC\u0015\r\u00119iP\u0001\u0003S>LAAa#\u0003\u0006\n!a)\u001b7f\u0011\u0015Yv\u00061\u0001]\u0011\u001d\u0011\tj\fa\u0001\u0005'\u000bq!\\3ue&\u001c7\u000f\u0005\u0003\u0003\u0016\neUB\u0001BL\u0015\r\u0011\tjX\u0005\u0005\u00057\u00139JA\u0004NKR\u0014\u0018nY:\t\u000b\r|\u0003\u0019\u00013\t\u000f\u0005%q\u00061\u0001\u0002\f\u0005)2M]3bi\u0016<\u0016\u000e\u001e5pkR\u0014VmY8wKJLH\u0003EA\f\u0005K\u00139K!+\u0003,\n5&q\u0016BY\u0011\u0019y\b\u00071\u0001\u0002\u0002!9\u00111\u0019\u0019A\u0002\u0005\u001d\u0007b\u0002B@a\u0001\u0007!\u0011\u0011\u0005\u00067B\u0002\r\u0001\u0018\u0005\b\u0005#\u0003\u0004\u0019\u0001BJ\u0011\u0015\u0019\u0007\u00071\u0001e\u0011\u001d\tI\u0001\ra\u0001\u0003\u0017\t\u0001C]3d_Z,'o\u00158baNDw\u000e^:\u0015\u000b!\u00149L!/\t\u000bM\u000b\u0004\u0019A+\t\u0013\tm\u0016\u0007%AA\u0002\u0005\u0005\u0016aC1mY><H)\u001a7fi\u0016\f!D]3d_Z,'o\u00158baNDw\u000e^:%I\u00164\u0017-\u001e7uII*\"A!1+\t\u0005\u0005&1Y\u0016\u0003\u0005\u000b\u0004BAa2\u0003R6\u0011!\u0011\u001a\u0006\u0005\u0005\u0017\u0014i-A\u0005v]\u000eDWmY6fI*\u0019!q\u001a8\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003T\n%'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0019B-\u001a7fi\u0016\u001cf.\u00199tQ>$h)\u001b7fgRA!\u0011\u001cBp\u0005g\u0014)\u0010E\u0003w\u00057\f\u0019*C\u0002\u0003^:\u0014\u0011BR;oGRLwN\u001c\u0019\t\u000f\t\u00058\u00071\u0001\u0003d\u00061An\\4ESJ\u0004BA!:\u0003p6\u0011!q\u001d\u0006\u0005\u0005S\u0014Y/\u0001\u0003gS2,'b\u0001Bw\u007f\u0005\u0019a.[8\n\t\tE(q\u001d\u0002\u0005!\u0006$\b\u000e\u0003\u0004\u0003`M\u0002\r\u0001\u001b\u0005\u0007\u0005o\u001c\u0004\u0019A'\u0002\u000f1|wmZ5oO\u0002")
public final class KafkaMetadataLog
implements ReplicatedLog,
Logging {
    private final AbstractLog log;
    private final Time time;
    private final Scheduler scheduler;
    private final TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots;
    private final TopicPartition topicPartition;
    private final MetadataLogConfig config;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaMetadataLog createWithoutRecovery(TopicPartition topicPartition, Uuid topicId, File dataDir, Time time, Metrics metrics, Scheduler scheduler, MetadataLogConfig config) {
        return KafkaMetadataLog$.MODULE$.createWithoutRecovery(topicPartition, topicId, dataDir, time, metrics, scheduler, config);
    }

    public static KafkaMetadataLog apply(TopicPartition topicPartition, Uuid topicId, File dataDir, Time time, Metrics metrics, Scheduler scheduler, MetadataLogConfig config) {
        return KafkaMetadataLog$.MODULE$.apply(topicPartition, topicId, dataDir, time, metrics, scheduler, config);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ValidOffsetAndEpoch validateOffsetAndEpoch(long x$1, int x$2) {
        return super.validateOffsetAndEpoch(x$1, x$2);
    }

    public long truncateToEndOffset(OffsetAndEpoch x$1) {
        return super.truncateToEndOffset(x$1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public AbstractLog log() {
        return this.log;
    }

    public LogFetchInfo read(long startOffset, Isolation readIsolation) {
        Product product;
        if (Isolation.COMMITTED.equals(readIsolation)) {
            product = FetchHighWatermark$.MODULE$;
        } else if (Isolation.UNCOMMITTED.equals(readIsolation)) {
            product = FetchLogEnd$.MODULE$;
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unhandled read isolation ").append(readIsolation).toString());
        }
        FetchHighWatermark$ isolation = product;
        AbstractFetchDataInfo abstractFetchDataInfo = this.log().read(startOffset, this.config.maxFetchSizeInBytes(), isolation, true, false);
        if (!(abstractFetchDataInfo instanceof FetchDataInfo)) {
            throw new IllegalStateException("Raft log should not have fetched tiered data");
        }
        FetchDataInfo fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
        return new LogFetchInfo(fetchDataInfo.records(), new org.apache.kafka.raft.LogOffsetMetadata(fetchDataInfo.fetchOffsetMetadata().messageOffset(), Optional.of(new SegmentPosition(fetchDataInfo.fetchOffsetMetadata().segmentBaseOffset(), fetchDataInfo.fetchOffsetMetadata().relativePositionInSegment()))));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsLeader(Records records, int epoch) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        MemoryRecords x$1 = (MemoryRecords)records;
        AppendOrigin$RaftLeader$ x$3 = AppendOrigin$RaftLeader$.MODULE$;
        RequestLocal x$4 = RequestLocal$.MODULE$.NoCaching();
        MetadataVersion x$5 = this.log().appendAsLeader$default$4();
        return this.handleAndConvertLogAppendInfo(this.log().appendAsLeader(x$1, epoch, x$3, x$5, x$4));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsFollower(Records records) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        return this.handleAndConvertLogAppendInfo(this.log().appendAsFollower((MemoryRecords)records));
    }

    private org.apache.kafka.raft.LogAppendInfo handleAndConvertLogAppendInfo(LogAppendInfo appendInfo) {
        Option<LogOffsetMetadata> option = appendInfo.firstOffset();
        if (option instanceof Some) {
            LogOffsetMetadata firstOffset = (LogOffsetMetadata)((Some)option).value();
            return new org.apache.kafka.raft.LogAppendInfo(firstOffset.messageOffset(), appendInfo.lastOffset());
        }
        if (None$.MODULE$.equals(option)) {
            throw new KafkaException(new StringBuilder(28).append("Append failed unexpectedly: ").append(appendInfo.errorMessage()).toString());
        }
        throw new MatchError(option);
    }

    public int lastFetchedEpoch() {
        return BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)this.latestSnapshotId().map(snapshotId -> BoxesRunTime.boxToInteger((int)KafkaMetadataLog.$anonfun$lastFetchedEpoch$2(this, snapshotId))).orElse(BoxesRunTime.boxToInteger((int)0)))));
    }

    public OffsetAndEpoch endOffsetForEpoch(int epoch) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.earliestSnapshotId()));
        Option<kafka.server.OffsetAndEpoch> option2 = this.log().endOffsetForEpoch(epoch);
        Tuple2 tuple2 = new Tuple2(option2, (Object)option);
        if (option2 instanceof Some) {
            kafka.server.OffsetAndEpoch offsetAndEpoch = (kafka.server.OffsetAndEpoch)((Some)option2).value();
            if (option instanceof Some) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)((Some)option).value();
                if (offsetAndEpoch.offset() == snapshotId.offset && offsetAndEpoch.leaderEpoch() == epoch) {
                    return new OffsetAndEpoch(snapshotId.offset, snapshotId.epoch);
                }
            }
        }
        if (option2 instanceof Some) {
            kafka.server.OffsetAndEpoch offsetAndEpoch = (kafka.server.OffsetAndEpoch)((Some)option2).value();
            return new OffsetAndEpoch(offsetAndEpoch.offset(), offsetAndEpoch.leaderEpoch());
        }
        if (None$.MODULE$.equals(option2)) {
            return new OffsetAndEpoch(this.endOffset().offset, this.lastFetchedEpoch());
        }
        throw new MatchError((Object)tuple2);
    }

    public org.apache.kafka.raft.LogOffsetMetadata endOffset() {
        LogOffsetMetadata endOffsetMetadata = this.log().logEndOffsetMetadata();
        return new org.apache.kafka.raft.LogOffsetMetadata(endOffsetMetadata.messageOffset(), Optional.of(new SegmentPosition(endOffsetMetadata.segmentBaseOffset(), endOffsetMetadata.relativePositionInSegment())));
    }

    public long startOffset() {
        return this.log().localLogStartOffset();
    }

    public void truncateTo(long offset) {
        if (offset < this.highWatermark().offset) {
            throw new IllegalArgumentException(new StringBuilder(74).append("Attempt to truncate to offset ").append(offset).append(", which is below ").append("the current high watermark ").append(this.highWatermark().offset).toString());
        }
        this.log().truncateTo(offset);
    }

    /*
     * Unable to fully structure code
     */
    public boolean truncateToLatestSnapshot() {
        latestEpoch = BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()I, $anonfun$truncateToLatestSnapshot$1(), ()I)()));
        var2_2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
        if (!(var2_2 instanceof Some)) ** GOTO lbl-1000
        snapshotId = (OffsetAndEpoch)((Some)var2_2).value();
        if (snapshotId.epoch > latestEpoch || snapshotId.epoch == latestEpoch && snapshotId.offset > this.endOffset().offset) {
            this.log().truncateFullyAndStartAt(snapshotId.offset);
            var4_4 = this.snapshots;
            synchronized (var4_4) {
                var7_5 = this.forgetSnapshotsBefore(snapshotId);
                var6_6 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl12 : MonitorExitStatement: MONITOREXIT : var4_4
                v0 = var6_6;
                v1 = var7_5;
            }
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
            v1 = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        }
        var8_7 = v1;
        truncated = v0;
        this.removeSnapshots(var8_7);
        return (boolean)var5_8;
    }

    public void initializeLeaderEpoch(int epoch) {
        this.log().maybeAssignEpochStartOffset(epoch, this.log().logEndOffset());
    }

    public void updateHighWatermark(org.apache.kafka.raft.LogOffsetMetadata offsetMetadata) {
        OffsetMetadata segmentPosition;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(offsetMetadata.metadata));
        if (option instanceof Some && (segmentPosition = (OffsetMetadata)((Some)option).value()) instanceof SegmentPosition) {
            SegmentPosition segmentPosition2 = (SegmentPosition)segmentPosition;
            this.log().updateHighWatermark(new LogOffsetMetadata(offsetMetadata.offset, segmentPosition2.baseOffset(), segmentPosition2.relativePosition()));
            return;
        }
        this.log().updateHighWatermark(offsetMetadata.offset);
    }

    /*
     * WARNING - void declaration
     */
    public org.apache.kafka.raft.LogOffsetMetadata highWatermark() {
        void var2_2;
        LogOffsetSnapshot logOffsetSnapshot = this.log().fetchOffsetSnapshot();
        if (logOffsetSnapshot == null) {
            throw new MatchError(null);
        }
        LogOffsetMetadata hwm = logOffsetSnapshot.highWatermark();
        Optional segmentPosition = var2_2.messageOffsetOnly() ? Optional.of(new SegmentPosition(var2_2.segmentBaseOffset(), var2_2.relativePositionInSegment())) : Optional.empty();
        return new org.apache.kafka.raft.LogOffsetMetadata(var2_2.messageOffset(), segmentPosition);
    }

    public void flush(boolean forceFlushActiveSegment) {
        this.log().flush(forceFlushActiveSegment);
    }

    public long lastFlushedOffset() {
        return this.log().recoveryPoint();
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Uuid topicId() {
        return (Uuid)this.log().topicId().get();
    }

    public Optional<RawSnapshotWriter> createNewSnapshot(OffsetAndEpoch snapshotId) {
        if (snapshotId.offset < this.startOffset()) {
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$createNewSnapshot$1(this, snapshotId);
                Object var6_2 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return Optional.empty();
        }
        long highWatermarkOffset = this.highWatermark().offset;
        if (snapshotId.offset > highWatermarkOffset) {
            throw new IllegalArgumentException(new StringBuilder(73).append("Cannot create a snapshot with an id (").append(snapshotId).append(") greater than the high-watermark (").append(highWatermarkOffset).append(")").toString());
        }
        ValidOffsetAndEpoch validOffsetAndEpoch = this.validateOffsetAndEpoch(snapshotId.offset, snapshotId.epoch);
        ValidOffsetAndEpoch.Kind kind = validOffsetAndEpoch.kind();
        ValidOffsetAndEpoch.Kind kind2 = ValidOffsetAndEpoch.Kind.VALID;
        if (kind == null ? kind2 != null : !kind.equals(kind2)) {
            throw new IllegalArgumentException(new StringBuilder(50).append("Snapshot id (").append(snapshotId).append(") is not valid according to the log: ").append(validOffsetAndEpoch).toString());
        }
        return this.storeSnapshot(snapshotId);
    }

    public Optional<RawSnapshotWriter> storeSnapshot(OffsetAndEpoch snapshotId) {
        boolean bl;
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            bl = this.snapshots.contains((Object)snapshotId);
        }
        if (bl) {
            return Optional.empty();
        }
        return Optional.of(FileRawSnapshotWriter.create((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId, Optional.of(this)));
    }

    /*
     * Unable to fully structure code
     */
    public Optional<RawSnapshotReader> readSnapshot(OffsetAndEpoch snapshotId) {
        var2_2 = this.snapshots;
        synchronized (var2_2) {
            block8: {
                block7: {
                    var5_3 = false;
                    var6_4 = null;
                    var7_5 = this.snapshots.get((Object)snapshotId);
                    if (!None$.MODULE$.equals(var7_5)) break block7;
                    v0 = None$.MODULE$;
                    break block8;
                }
                if (!(var7_5 instanceof Some)) ** GOTO lbl-1000
                var5_3 = true;
                var6_4 = (Some)var7_5;
                var8_6 = (Option)var6_4.value();
                if (None$.MODULE$.equals(var8_6)) {
                    v0 = this.liftedTree1$1(snapshotId);
                } else if (var5_3) {
                    v0 = (Option)var6_4.value();
                } else {
                    throw new MatchError((Object)var7_5);
                }
            }
            reader = v0;
            var3_8 = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8((Option)reader));
            return var3_8;
        }
    }

    public Optional<RawSnapshotReader> latestSnapshot() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional<RawSnapshotReader> optional = this.latestSnapshotId().flatMap(snapshotId -> this.readSnapshot((OffsetAndEpoch)snapshotId));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> latestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.snapshots.lastOption().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return (OffsetAndEpoch)x0$1._1();
                }
                throw new MatchError(null);
            })));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> earliestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.snapshots.headOption().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return (OffsetAndEpoch)x0$1._1();
                }
                throw new MatchError(null);
            })));
            return optional;
        }
    }

    public void onSnapshotFrozen(OffsetAndEpoch snapshotId) {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            this.snapshots.put((Object)snapshotId, (Object)None$.MODULE$);
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean deleteBeforeSnapshot(OffsetAndEpoch snapshotId) {
        var2_2 = this.snapshots;
        synchronized (var2_2) {
            var3_3 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
            if (!(var3_3 instanceof Some)) ** GOTO lbl-1000
            latestSnapshotId = (OffsetAndEpoch)((Some)var3_3).value();
            if (this.snapshots.contains((Object)snapshotId) && this.startOffset() < snapshotId.offset && snapshotId.offset <= latestSnapshotId.offset && this.log().maybeIncrementLogStartOffset(snapshotId.offset, SnapshotGenerated$.MODULE$)) {
                this.log().deleteOldSegments();
                v0 = true;
                v1 = this.forgetSnapshotsBefore(snapshotId);
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
                v1 = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            }
            var6_5 = v1;
            var5_6 = v0;
        }
        this.removeSnapshots(var6_5);
        return var5_6;
    }

    private Seq<Tuple2<OffsetAndEpoch, Object>> loadSnapshotSizes() {
        return (Seq)this.snapshots.keys().toSeq().flatMap((Function1 & Serializable)snapshotId -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.readSnapshot((OffsetAndEpoch)snapshotId))).map((Function1 & Serializable)reader -> new Tuple2(snapshotId, (Object)BoxesRunTime.boxToLong((long)reader.sizeInBytes()))));
    }

    private Option<Object> readSnapshotTimestamp(OffsetAndEpoch snapshotId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.readSnapshot(snapshotId))).flatMap((Function1 & Serializable)reader -> {
            RecordBatch firstBatch = (RecordBatch)reader.records().batchIterator().next();
            CloseableIterator records = firstBatch.streamingIterator((BufferSupplier)new BufferSupplier.GrowableBufferSupplier());
            if (firstBatch.isControlBatch()) {
                SnapshotHeaderRecord header = ControlRecordUtils.deserializedSnapshotHeaderRecord((Record)((Record)records.next()));
                return new Some((Object)BoxesRunTime.boxToLong((long)header.lastContainedLogTimestamp()));
            }
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = "Did not find control record at beginning of snapshot";
                Object var5_5 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return None$.MODULE$;
        });
    }

    public boolean maybeClean() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            boolean didClean = false;
            boolean bl = (didClean |= this.cleanSnapshotsRetentionSize()) | this.cleanSnapshotsRetentionMs();
            return bl;
        }
    }

    private boolean cleanSnapshots(Function1<OffsetAndEpoch, Object> predicate) {
        Object object = new Object();
        try {
            if (this.snapshots.size() < 2) {
                return false;
            }
            BooleanRef didClean = BooleanRef.create((boolean)false);
            this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaMetadataLog.$anonfun$cleanSnapshots$1(this, predicate, didClean, object, x0$1)));
            return didClean.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    private boolean cleanSnapshotsRetentionMs() {
        boolean bl;
        if (this.config.retentionMillis() < 0L) {
            return false;
        }
        Function1 & Serializable cleanSnapshots_predicate = (Function1 & Serializable)snapshotId -> BoxesRunTime.boxToBoolean((boolean)this.shouldClean$1(snapshotId));
        Object object = new Object();
        try {
            if (this.snapshots.size() >= 2) {
                BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
                this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaMetadataLog.$anonfun$cleanSnapshots$1(this, predicate, didClean, object, x0$1)));
                return cleanSnapshots_didClean.elem;
            }
            bl = false;
        }
        catch (NonLocalReturnControl cleanSnapshots_ex) {
            if (cleanSnapshots_ex.key() == object) {
                return cleanSnapshots_ex.value$mcZ$sp();
            }
            throw cleanSnapshots_ex;
        }
        return bl;
    }

    private boolean cleanSnapshotsRetentionSize() {
        boolean bl;
        if (this.config.retentionMaxBytes() < 0L) {
            return false;
        }
        Map snapshotSizes = this.loadSnapshotSizes().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        LongRef snapshotTotalSize = LongRef.create((long)BoxesRunTime.unboxToLong((Object)snapshotSizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        Function1 & Serializable cleanSnapshots_predicate = (Function1 & Serializable)snapshotId -> BoxesRunTime.boxToBoolean((boolean)this.shouldClean$2(snapshotId, snapshotSizes, snapshotTotalSize));
        Object object = new Object();
        try {
            if (this.snapshots.size() >= 2) {
                BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
                this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaMetadataLog.$anonfun$cleanSnapshots$1(this, predicate, didClean, object, x0$1)));
                return cleanSnapshots_didClean.elem;
            }
            bl = false;
        }
        catch (NonLocalReturnControl cleanSnapshots_ex) {
            if (cleanSnapshots_ex.key() == object) {
                return cleanSnapshots_ex.value$mcZ$sp();
            }
            throw cleanSnapshots_ex;
        }
        return bl;
    }

    private TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> forgetSnapshotsBefore(OffsetAndEpoch logStartSnapshotId) {
        TreeMap expiredSnapshots = (TreeMap)((MapOps)this.snapshots.until((Object)logStartSnapshotId)).clone();
        this.snapshots.$minus$minus$eq((IterableOnce)expiredSnapshots.keys());
        return expiredSnapshots;
    }

    private void removeSnapshots(TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> expiredSnapshots) {
        expiredSnapshots.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)x0$1._1();
                if (this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$removeSnapshots$2(snapshotId);
                    Object var3_3 = null;
                    this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                return Snapshots.markForDelete((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId);
            }
            throw new MatchError(null);
        });
        if (expiredSnapshots.nonEmpty()) {
            this.scheduler.schedule("delete-snapshot-files", KafkaMetadataLog$.MODULE$.kafka$raft$KafkaMetadataLog$$deleteSnapshotFiles(this.log().dir().toPath(), expiredSnapshots, this), this.config.fileDeleteDelayMs(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
            return;
        }
    }

    public void close() {
        this.log().close();
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            ((IterableOnceOps)this.snapshots.values().flatten(Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable)x$3 -> {
                x$3.close();
                return BoxedUnit.UNIT;
            });
            this.snapshots.clear();
            return;
        }
    }

    public int snapshotCount() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            int n = this.snapshots.size();
            return n;
        }
    }

    public static final /* synthetic */ int $anonfun$lastFetchedEpoch$2(KafkaMetadataLog $this, OffsetAndEpoch snapshotId) {
        long logEndOffset = $this.endOffset().offset;
        if (snapshotId.offset == $this.startOffset() && snapshotId.offset == logEndOffset) {
            return snapshotId.epoch;
        }
        throw new KafkaException(new StringBuilder(159).append("Log doesn't have a last fetch epoch and there is a snapshot (").append(snapshotId).append("). ").append("Expected the snapshot's end offset to match the log's end offset (").append(logEndOffset).append(") ").append("and the log start offset (").append($this.startOffset()).append(")").toString());
    }

    public static final /* synthetic */ int $anonfun$truncateToLatestSnapshot$1() {
        return 0;
    }

    public static final /* synthetic */ String $anonfun$createNewSnapshot$1(KafkaMetadataLog $this, OffsetAndEpoch snapshotId$1) {
        return new StringBuilder(72).append("Cannot create a snapshot with an id (").append(snapshotId$1).append(") less than the log start offset (").append($this.startOffset()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$readSnapshot$1(OffsetAndEpoch snapshotId$2, Path path$1) {
        return new StringBuilder(47).append("Couldn't read ").append(snapshotId$2).append("; expected to find snapshot file ").append(path$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ Option liftedTree1$1(OffsetAndEpoch snapshotId$2) {
        try {
            void var2_2;
            Some snapshotReader = new Some((Object)FileRawSnapshotReader.open((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2));
            this.snapshots.put((Object)snapshotId$2, (Object)snapshotReader);
            return var2_2;
        }
        catch (NoSuchFileException noSuchFileException) {
            Path path = Snapshots.snapshotPath((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2);
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$readSnapshot$1(snapshotId$2, path);
                Object var4_4 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            this.snapshots.remove((Object)snapshotId$2);
            return None$.MODULE$;
        }
    }

    public static final /* synthetic */ String $anonfun$readSnapshotTimestamp$2() {
        return "Did not find control record at beginning of snapshot";
    }

    public static final /* synthetic */ boolean $anonfun$cleanSnapshots$1(KafkaMetadataLog $this, Function1 predicate$1, BooleanRef didClean$1, Object nonLocalReturnKey1$1, Seq x0$1) {
        SeqOps seqOps;
        if (x0$1 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)x0$1))) {
            new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                OffsetAndEpoch snapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                if (snapshot != null && nextSnapshot != null) {
                    if (BoxesRunTime.unboxToBoolean((Object)predicate$1.apply((Object)snapshot)) && $this.deleteBeforeSnapshot(nextSnapshot)) {
                        didClean$1.elem = true;
                        return true;
                    }
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, didClean$1.elem);
                }
            }
        }
        return false;
    }

    private final boolean shouldClean$1(OffsetAndEpoch snapshotId) {
        long now = this.time.milliseconds();
        return this.readSnapshotTimestamp(snapshotId).exists((Function1)(JFunction1.mcZJ.sp & Serializable)timestamp -> now - timestamp > $this.config.retentionMillis());
    }

    private final boolean shouldClean$2(OffsetAndEpoch snapshotId, Map snapshotSizes$1, LongRef snapshotTotalSize$1) {
        return snapshotSizes$1.get((Object)snapshotId).exists((Function1)(JFunction1.mcZJ.sp & Serializable)snapshotSize -> {
            if (this.log().size() + snapshotTotalSize$1.elem > $this.config.retentionMaxBytes()) {
                snapshotTotalSize$1.elem -= snapshotSize;
                return true;
            }
            return false;
        });
    }

    public static final /* synthetic */ String $anonfun$removeSnapshots$2(OffsetAndEpoch snapshotId$4) {
        return new StringBuilder(30).append("Marking snapshot ").append(snapshotId$4).append(" for deletion").toString();
    }

    public KafkaMetadataLog(AbstractLog log, Time time, Scheduler scheduler, TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots, TopicPartition topicPartition, MetadataLogConfig config) {
        this.log = log;
        this.time = time;
        this.scheduler = scheduler;
        this.snapshots = snapshots;
        this.topicPartition = topicPartition;
        this.config = config;
        this.logIdent_$eq(new StringBuilder(34).append("[MetadataLog partition=").append(topicPartition).append(", nodeId=").append(config.nodeId()).append("] ").toString());
    }
}

