/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.configmap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kafka.restore.configmap.PartitionConfig;

public class TopicConfig {
    private String name;
    private long fromTimestamp;
    private List<PartitionConfig> partitionConfigs = new ArrayList<PartitionConfig>();

    public TopicConfig() {
    }

    public TopicConfig(String name, long fromTimestamp) {
        this.name = name;
        this.fromTimestamp = fromTimestamp;
    }

    public void addPartition(PartitionConfig pc) {
        this.partitionConfigs.add(pc);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getFromTimestamp() {
        return this.fromTimestamp;
    }

    public void setFromTimestamp(long fromTimestamp) {
        this.fromTimestamp = fromTimestamp;
    }

    public List<PartitionConfig> getPartitionConfigs() {
        return this.partitionConfigs;
    }

    public void setPartitionConfigs(List<PartitionConfig> partitionConfigs) {
        this.partitionConfigs = partitionConfigs;
    }

    public static TopicConfig fromMap(Map<String, Object> map) {
        TopicConfig topicConfig = new TopicConfig();
        if (map.containsKey("name")) {
            topicConfig.name = (String)map.get("name");
        }
        if (map.containsKey("fromTimestamp")) {
            Object ts = map.get("fromTimestamp");
            if (ts instanceof Integer) {
                topicConfig.fromTimestamp = new Long(((Integer)ts).intValue());
            } else if (ts instanceof Long) {
                topicConfig.fromTimestamp = (Long)ts;
            }
        }
        if (map.containsKey("partitionConfigs")) {
            List partitionList = (List)map.get("partitionConfigs");
            for (Object replica : partitionList) {
                topicConfig.partitionConfigs.add(PartitionConfig.fromMap((Map)replica));
            }
        }
        return topicConfig;
    }
}

