/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.schedulers;

import java.util.Set;
import java.util.UUID;
import kafka.restore.RestoreConfig;
import kafka.restore.RestoreMetricsManager;
import kafka.restore.messages.MessageResult;
import kafka.restore.messages.MessageStatusCode;
import kafka.restore.messages.RestoreObjectsInStoreRequest;
import kafka.restore.messages.RestoreObjectsInStoreResponse;
import kafka.restore.messages.UploadFtpsToStoreRequest;
import kafka.restore.messages.UploadFtpsToStoreResponse;
import kafka.restore.schedulers.AsyncServiceSchedulerResultsReceiver;
import kafka.restore.schedulers.ObjectStorePoolImpl;
import kafka.tier.store.TierObjectStore;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DryrunObjectStorePoolImpl
extends ObjectStorePoolImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(DryrunObjectStorePoolImpl.class);
    AsyncServiceSchedulerResultsReceiver resultsReceiver;

    public DryrunObjectStorePoolImpl(AsyncServiceSchedulerResultsReceiver resultsReceiver, int poolSize, TierObjectStore tierObjectStore, RestoreMetricsManager restoreMetricsManager, Time time) {
        super(resultsReceiver, poolSize, tierObjectStore, restoreMetricsManager, time);
        this.resultsReceiver = resultsReceiver;
    }

    @Override
    protected void submitRestoreObjectsInStoreRequest(RestoreObjectsInStoreRequest request) {
        if (RestoreConfig.dryRun || RestoreConfig.localMode) {
            LOGGER.debug(String.format("[%s-%s]: dry run: %s", request.getTopic(), request.getPartition(), request.name()));
            Set<UUID> failedRestoreSegmentIds = request.getSegmentStateAndPathMap().keySet();
            this.resultsReceiver.reportServiceSchedulerResponse(new RestoreObjectsInStoreResponse(0, request.getTopic(), request.getPartition(), request.getUuid(), MessageStatusCode.OK, MessageResult.SUCCESS, failedRestoreSegmentIds));
        } else {
            super.submitRestoreObjectsInStoreRequest(request);
        }
    }

    @Override
    protected void submitUploadFtpsToStoreRequest(UploadFtpsToStoreRequest request) {
        if (RestoreConfig.dryRun || RestoreConfig.localMode) {
            LOGGER.debug(String.format("[%s-%s]: dry run: %s", request.getTopic(), request.getPartition(), request.name()));
            UploadFtpsToStoreResponse response = new UploadFtpsToStoreResponse(0, request.getTopic(), request.getPartition(), request.getUuid(), MessageStatusCode.OK, MessageResult.SUCCESS);
            this.resultsReceiver.reportServiceSchedulerResponse(response);
        } else {
            super.submitUploadFtpsToStoreRequest(request);
        }
    }
}

