/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.schedulers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import kafka.restore.RestoreMetricsManager;
import kafka.restore.messages.ListObjectsInStoreRequest;
import kafka.restore.messages.ListObjectsInStoreResponse;
import kafka.restore.messages.MessageResult;
import kafka.restore.messages.MessageStatusCode;
import kafka.restore.messages.MultipleResponseHandler;
import kafka.restore.schedulers.RetryableException;
import kafka.restore.schedulers.SchedulerUtil;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.S3VersionInformation;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.VersionInformation;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListVersionsOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListVersionsOperator.class);
    private ListObjectsInStoreRequest request;
    private MultipleResponseHandler responseHandler;
    private TierObjectStore tierObjectStore;
    private ThreadPoolExecutor executor;
    private RestoreMetricsManager metrics;
    private final Time time;
    private static Set<String> requiredFileTypes = new HashSet<String>(Arrays.asList(".segment"));

    public ListVersionsOperator(ListObjectsInStoreRequest request, MultipleResponseHandler responseHandler, TierObjectStore tierObjectStore, ThreadPoolExecutor executor, RestoreMetricsManager metrics, Time time) {
        this.request = request;
        this.responseHandler = responseHandler;
        this.tierObjectStore = tierObjectStore;
        this.executor = executor;
        this.metrics = metrics;
        this.time = time;
    }

    public CompletableFuture<Map<String, String>> listVersions() {
        LOGGER.debug(SchedulerUtil.getThreadPoolExecutorStatus("in listVersions", this.executor));
        return CompletableFuture.supplyAsync(() -> {
            try {
                LOGGER.debug("call listObject to list: " + this.request.getSegmentDirectoryPath() + ", in thread: " + Thread.currentThread().getName());
                long startTimeMs = this.time.hiResClockMs();
                Map<String, List<VersionInformation>> versionListMap = this.tierObjectStore.listObject(this.request.getSegmentDirectoryPath(), true);
                long restoreListVersionsMs = this.time.hiResClockMs() - startTimeMs;
                this.metrics.restoreListVersionsMs().record((double)restoreListVersionsMs);
                LOGGER.trace("returned version list map:\n" + this.versionListMapToString(versionListMap));
                Map<String, String> versionMap = versionListMap.entrySet().stream().filter(e -> SchedulerUtil.getLastLiveVersionId((String)e.getKey(), (List)e.getValue()) != null).collect(Collectors.toMap(e -> (String)e.getKey(), e -> SchedulerUtil.getLastLiveVersionId((String)e.getKey(), (List)e.getValue())));
                LOGGER.trace("after filtering, versions need be restored from object store:\n" + this.versionMapToString(versionMap));
                if (ListVersionsOperator.containsRequiredFiles(versionMap)) {
                    this.responseHandler.addReceivedResponse(new ListObjectsInStoreResponse(0, this.request.getTopic(), this.request.getPartition(), this.request.getUuid(), MessageStatusCode.OK, MessageResult.SUCCESS, this.request.getSegmentId(), versionMap));
                    return versionMap;
                }
                LOGGER.trace(String.format("[%s]: ListObject failed for segment %s, most like it was deleted by CLM or bucket retention policy.", this.request.getTopicPartition(), this.request.getSegmentId()));
                this.responseHandler.addReceivedResponse(new ListObjectsInStoreResponse(0, this.request.getTopic(), this.request.getPartition(), this.request.getUuid(), MessageStatusCode.ILLEGAL_STATE_ERROR, MessageResult.FAILURE, this.request.getSegmentId(), null));
                return null;
            }
            catch (TierObjectStoreRetriableException ex) {
                String errorMessage = String.format("[%s]: Call listVersions failed", this.request.getTopicPartition());
                LOGGER.error(errorMessage, (Throwable)((Object)ex));
                throw new RetryableException(errorMessage, (Throwable)((Object)ex));
            }
        }, this.executor);
    }

    public static boolean containsRequiredFiles(Map<String, String> versionMap) {
        Set suffixSet = versionMap.keySet().stream().map(path -> ListVersionsOperator.getSuffix(path)).collect(Collectors.toSet());
        for (String fileType : requiredFileTypes) {
            if (suffixSet.contains(fileType)) continue;
            return false;
        }
        return true;
    }

    private String versionListMapToString(Map<String, List<VersionInformation>> versionListMap) {
        StringBuilder sb = new StringBuilder();
        versionListMap.forEach((k, vList) -> vList.stream().forEach(v -> {
            sb.append((String)k).append(": ").append(v.getVersionId());
            if (v instanceof S3VersionInformation) {
                S3VersionInformation s3v = (S3VersionInformation)v;
                sb.append("(isDeleteMarker: ").append(s3v.isDeleteMarker()).append(")");
            }
            sb.append("\n");
        }));
        return sb.toString();
    }

    private String versionMapToString(Map<String, String> versionMap) {
        StringBuilder sb = new StringBuilder();
        versionMap.forEach((k, v) -> sb.append((String)k).append(": ").append((String)v).append("\n"));
        return sb.toString();
    }

    private static String getSuffix(String objectStorePath) {
        int lastIndexOfDot = objectStorePath.lastIndexOf(".");
        if (lastIndexOfDot != -1) {
            return objectStorePath.substring(lastIndexOfDot);
        }
        return null;
    }
}

