/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine.transitions;

import java.util.List;
import kafka.restore.MessageEmitter;
import kafka.restore.configmap.NodeConfig;
import kafka.restore.messages.KafkaFenceResponse;
import kafka.restore.messages.KafkaTierPartitionStatusRequest;
import kafka.restore.statemachine.api.Event;
import kafka.restore.statemachine.api.FiniteStateMachine;
import kafka.restore.statemachine.api.State;
import kafka.restore.statemachine.transitions.AbstractTransition;
import kafka.tier.state.TierPartitionStatus;

public class StartToFenceEventSentTransition
extends AbstractTransition {
    public StartToFenceEventSentTransition(MessageEmitter messageEmitter) {
        super(messageEmitter);
    }

    @Override
    public State getSourceState() {
        return State.START;
    }

    @Override
    public State getTargetState() {
        return State.FENCE_EVENT_SENT;
    }

    public boolean handleEvent(FiniteStateMachine fsm, Event event) {
        Object responseObject = event.getData("message_response");
        if (!(responseObject instanceof KafkaFenceResponse)) {
            return false;
        }
        String topic = (String)fsm.getMetadata("topic");
        int partition = (Integer)fsm.getMetadata("partition");
        NodeConfig broker = (NodeConfig)fsm.getMetadata("partition_leader");
        List replicas = (List)fsm.getMetadata("partition_replicas");
        KafkaTierPartitionStatusRequest statusRequest = new KafkaTierPartitionStatusRequest(0, topic, partition, broker, replicas, TierPartitionStatus.FROZEN_LOG_START_OFFSET.ordinal());
        this.messageEmitter.submitRequest(statusRequest);
        return true;
    }
}

