/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.TimeUnit;
import kafka.cluster.BrokerEndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndFetcherId;
import kafka.server.FailedPartitions;
import kafka.server.FetchConnectionsMode;
import kafka.server.FetchConnectionsMode$Isolated$;
import kafka.server.FetcherLagMetrics;
import kafka.server.FetcherPool;
import kafka.server.FetcherPool$;
import kafka.server.FetcherPool$Default$;
import kafka.server.FetcherPool$InSync$;
import kafka.server.FetcherTag;
import kafka.server.InitialFetchState;
import kafka.server.PartitionFetchState;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\re!B\u0017/\u0003\u0003\u0019\u0004\u0002C$\u0001\u0005\u000b\u0007I\u0011\u0001%\t\u0011Q\u0003!\u0011!Q\u0001\n%C\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\t-\u0002\u0011\t\u0011)A\u0005/\"A!\f\u0001B\u0001B\u0003%1\f\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003a\u0011!1\u0007A!A!\u0002\u00139\u0007\"B7\u0001\t\u0003q\u0007BCA\u0002\u0001\t\u0007I\u0011\u0001\u0018\u0002\u0006!A\u0011\u0011\u0004\u0001!\u0002\u0013\t9\u0001C\u0005\u0002\u001c\u0001\u0011\r\u0011\"\u0005\u0002\u001e!A\u0011q\u0006\u0001!\u0002\u0013\ty\u0002C\u0005\u00022\u0001\u0001\r\u0011\"\u0003\u00024!I\u0011Q\u0007\u0001A\u0002\u0013%\u0011q\u0007\u0005\b\u0003\u0007\u0002\u0001\u0015)\u0003X\u0011%\t)\u0005\u0001b\u0001\n#\t9\u0005C\u0004\u0002J\u0001\u0001\u000b\u0011B.\t\u0013\u0005-\u0003A1A\u0005\u0002\u00055\u0003\u0002CA+\u0001\u0001\u0006I!a\u0014\t\u0013\u0005]\u0003A1A\u0005\n\u0005e\u0003\u0002CA1\u0001\u0001\u0006I!a\u0017\t\u0011\u0005\r\u0004\u0001\"\u0001/\u0003KBq!a\u001a\u0001\t\u0013\tI\u0007\u0003\u0005\u0002x\u0001!\tALA\u001a\u0011\u001d\tI\b\u0001C\u0001\u0003wB\u0001\"!!\u0001\t\u0003q\u00131\u0011\u0005\t\u0003C\u0003A\u0011\u0001\u0018\u0002$\"9\u0011q\u0015\u0001\u0005\u0002\u0005%\u0006bBA^\u0001\u0019\u0005\u0011Q\u0018\u0005\b\u0003;\u0004A\u0011AAp\u0011%\tI\u0010AI\u0001\n\u0003\tY\u0010C\u0004\u0003\u0012\u0001!\tAa\u0005\t\u000f\t]\u0001\u0001\"\u0005\u0003\u001a!9!1\u0005\u0001\u0005\u0002\u0005\u0015\u0004b\u0002B\u0013\u0001\u0011%!q\u0005\u0005\b\u0005s\u0001A\u0011\u0001B\u001e\u0011\u001d\u0011)\u0006\u0001C\u0001\u0005/BqAa\u0019\u0001\t\u0003\t)\u0007C\u0004\u0003f\u0001!\t!!\u001a\b\u0013\t\u001dd&!A\t\u0002\t%d\u0001C\u0017/\u0003\u0003E\tAa\u001b\t\r5LC\u0011\u0001B7\u0011%\u0011y'KI\u0001\n\u0003\u0011\t\bC\u0005\u0003z%\n\n\u0011\"\u0001\u0003|\t1\u0012IY:ue\u0006\u001cGOR3uG\",'/T1oC\u001e,'O\u0003\u00020a\u000511/\u001a:wKJT\u0011!M\u0001\u0006W\u000647.Y\u0002\u0001+\t!$o\u0005\u0003\u0001km\n\u0005C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$AB!osJ+g\r\u0005\u0002=\u007f5\tQH\u0003\u0002?a\u0005)Q\u000f^5mg&\u0011\u0001)\u0010\u0002\b\u0019><w-\u001b8h!\t\u0011U)D\u0001D\u0015\t!\u0005'A\u0004nKR\u0014\u0018nY:\n\u0005\u0019\u001b%!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006!a.Y7f+\u0005I\u0005C\u0001&R\u001d\tYu\n\u0005\u0002Mo5\tQJ\u0003\u0002Oe\u00051AH]8pizJ!\u0001U\u001c\u0002\rA\u0013X\rZ3g\u0013\t\u00116K\u0001\u0004TiJLgn\u001a\u0006\u0003!^\nQA\\1nK\u0002\n\u0001b\u00197jK:$\u0018\nZ\u0001\f]Vlg)\u001a;dQ\u0016\u00148\u000f\u0005\u000271&\u0011\u0011l\u000e\u0002\u0004\u0013:$\u0018!\u00034fi\u000eDWj\u001c3f!\taV,D\u0001/\u0013\tqfF\u0001\u000bGKR\u001c\u0007nQ8o]\u0016\u001cG/[8og6{G-Z\u0001\ng\u000eDW\rZ;mKJ\u00042AN1d\u0013\t\u0011wG\u0001\u0004PaRLwN\u001c\t\u0003y\u0011L!!Z\u001f\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018aD3yiJ\fW*\u001a;sS\u000e$\u0016mZ:\u0011\t!\\\u0017*S\u0007\u0002S*\u0011!nN\u0001\u000bG>dG.Z2uS>t\u0017B\u00017j\u0005\ri\u0015\r]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011=\\H0 @\u0000\u0003\u0003\u00012\u0001\u0018\u0001q!\t\t(\u000f\u0004\u0001\u0005\u000bM\u0004!\u0019\u0001;\u0003\u0003Q\u000b\"!\u001e=\u0011\u0005Y2\u0018BA<8\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001X=\n\u0005it#!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0005\u0006\u000f\"\u0001\r!\u0013\u0005\u0006+\"\u0001\r!\u0013\u0005\u0006-\"\u0001\ra\u0016\u0005\u00065\"\u0001\ra\u0017\u0005\b?\"\u0001\n\u00111\u0001a\u0011\u001d1\u0007\u0002%AA\u0002\u001d\f\u0001CZ3uG\",'\u000f\u00165sK\u0006$W*\u00199\u0016\u0005\u0005\u001d\u0001cBA\u0005\u0003\u001f\t\u0019\u0002]\u0007\u0003\u0003\u0017Q1!!\u0004j\u0003\u001diW\u000f^1cY\u0016LA!!\u0005\u0002\f\t9\u0001*Y:i\u001b\u0006\u0004\bc\u0001/\u0002\u0016%\u0019\u0011q\u0003\u0018\u0003\u0015\u0019+Go\u00195feR\u000bw-A\tgKR\u001c\u0007.\u001a:UQJ,\u0017\rZ'ba\u0002\nA\u0001\\8dWV\u0011\u0011q\u0004\t\u0005\u0003C\tY#\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003\u0011a\u0017M\\4\u000b\u0005\u0005%\u0012\u0001\u00026bm\u0006LA!!\f\u0002$\t1qJ\u00196fGR\fQ\u0001\\8dW\u0002\nAC\\;n\r\u0016$8\r[3sgB+'O\u0011:pW\u0016\u0014X#A,\u000219,XNR3uG\",'o\u001d)fe\n\u0013xn[3s?\u0012*\u0017\u000f\u0006\u0003\u0002:\u0005}\u0002c\u0001\u001c\u0002<%\u0019\u0011QH\u001c\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0003r\u0011\u0011!a\u0001/\u0006\u0019\u0001\u0010J\u0019\u0002+9,XNR3uG\",'o\u001d)fe\n\u0013xn[3sA\u0005Y\"/\u001a9mS\u000e\fg)\u001a;dQ\u000e{gN\\3di&|gn]'pI\u0016,\u0012aW\u0001\u001de\u0016\u0004H.[2b\r\u0016$8\r[\"p]:,7\r^5p]Nlu\u000eZ3!\u0003A1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7/\u0006\u0002\u0002PA\u0019A,!\u0015\n\u0007\u0005McF\u0001\tGC&dW\r\u001a)beRLG/[8og\u0006\tb-Y5mK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\tQ\fwm]\u000b\u0003\u00037\u0002R\u0001[6\u0002^%\u0003B!!\t\u0002`%\u0019!+a\t\u0002\u000bQ\fwm\u001d\u0011\u00029\r\u0014X-\u0019;f'\u0016\u0004\u0018M]1uK\u001a+Go\u00195fe6+GO]5dgR\u0011\u0011\u0011H\u0001\r[&tg)\u001a;dQJ\u000bG/\u001a\u000b\u0005\u0003W\n\t\bE\u00027\u0003[J1!a\u001c8\u0005\u0019!u.\u001e2mK\"9\u00111O\fA\u0002\u0005U\u0014A\u00034fi\u000eDWM]'baB)\u0001n[A\na\u0006yA-Z1e)\"\u0014X-\u00193D_VtG/\u0001\tsKNL'0\u001a+ie\u0016\fG\rU8pYR!\u0011\u0011HA?\u0011\u0019\ty(\u0007a\u0001/\u00069a.Z<TSj,\u0017AC4fi\u001a+Go\u00195feR!\u0011QQAD!\r1\u0014\r\u001d\u0005\b\u0003\u0013S\u0002\u0019AAF\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B!!$\u0002\u001e6\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*\u0001\u0004d_6lwN\u001c\u0006\u0004c\u0005U%\u0002BAL\u00033\u000ba!\u00199bG\",'BAAN\u0003\ry'oZ\u0005\u0005\u0003?\u000byI\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0019\u001d,GOR3uG\",'/\u00133\u0015\u0007]\u000b)\u000bC\u0004\u0002\nn\u0001\r!a#\u000275\f'o\u001b)beRLG/[8og\u001a{'\u000f\u0016:v]\u000e\fG/[8o)!\tI$a+\u00020\u0006E\u0006BBAW9\u0001\u0007q+\u0001\u0005ce>\\WM]%e\u0011\u001d\tI\t\ba\u0001\u0003\u0017Cq!a-\u001d\u0001\u0004\t),\u0001\tueVt7-\u0019;j_:|eMZ:fiB\u0019a'a.\n\u0007\u0005evG\u0001\u0003M_:<\u0017aE2sK\u0006$XMR3uG\",'\u000f\u00165sK\u0006$Gc\u00029\u0002@\u0006\r\u00171\u001b\u0005\u0007\u0003\u0003l\u0002\u0019A,\u0002\u0013\u0019,Go\u00195fe&#\u0007bBAc;\u0001\u0007\u0011qY\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0005\u0003\u0013\fy-\u0004\u0002\u0002L*\u0019\u0011Q\u001a\u0019\u0002\u000f\rdWo\u001d;fe&!\u0011\u0011[Af\u00059\u0011%o\\6fe\u0016sG\rU8j]RDq!!6\u001e\u0001\u0004\t9.A\u0006gKR\u001c\u0007.\u001a:Q_>d\u0007c\u0001/\u0002Z&\u0019\u00111\u001c\u0018\u0003\u0017\u0019+Go\u00195feB{w\u000e\\\u0001\u0018C\u0012$g)\u001a;dQ\u0016\u0014hi\u001c:QCJ$\u0018\u000e^5p]N$\u0002\"!\u000f\u0002b\u00065\u0018q\u001e\u0005\b\u0003Gt\u0002\u0019AAs\u0003M\u0001\u0018M\u001d;ji&|g.\u00118e\u001f\u001a47/\u001a;t!\u0019A7.a#\u0002hB\u0019A,!;\n\u0007\u0005-hFA\tJ]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016Dq!!6\u001f\u0001\u0004\t9\u000eC\u0005\u0002rz\u0001\n\u00111\u0001\u0002t\u0006A1-\u00197mE\u0006\u001c7\u000e\u0005\u00057\u0003k\fY\t]A\u001d\u0013\r\t9p\u000e\u0002\n\rVt7\r^5p]J\n\u0011%\u00193e\r\u0016$8\r[3s\r>\u0014\b+\u0019:uSRLwN\\:%I\u00164\u0017-\u001e7uIM*\"!!@+\t\u0005M\u0018q`\u0016\u0003\u0005\u0003\u0001BAa\u0001\u0003\u000e5\u0011!Q\u0001\u0006\u0005\u0005\u000f\u0011I!A\u0005v]\u000eDWmY6fI*\u0019!1B\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0010\t\u0015!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0011\u0012\r\u001a3GC&dW\r\u001a)beRLG/[8o)\u0011\tID!\u0006\t\u000f\u0005%\u0005\u00051\u0001\u0002\f\u0006a\u0012\r\u001a3QCJ$\u0018\u000e^5p]N$vNR3uG\",'\u000f\u00165sK\u0006$GCBA\u001d\u00057\u0011y\u0002\u0003\u0004\u0003\u001e\u0005\u0002\r\u0001]\u0001\u000eM\u0016$8\r[3s)\"\u0014X-\u00193\t\u000f\t\u0005\u0012\u00051\u0001\u0002f\u00061\u0012N\\5uS\u0006dwJ\u001a4tKR\fe\u000eZ#q_\u000eD7/\u0001\u000fnCf\u0014W-T5he\u0006$X-\u00138Ts:\u001c\u0007+\u0019:uSRLwN\\:\u0002'Q|\u0017J\\5uS\u0006dg)\u001a;dQN#\u0018\r^3\u0015\r\u0005\u0015(\u0011\u0006B\u0017\u0011\u0019\u0011Yc\ta\u0001q\u00069a-\u001a;dQ\u0016\u0014\bb\u0002B\u0018G\u0001\u0007!\u0011G\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fgB1\u0001n[AF\u0005g\u00012\u0001\u0018B\u001b\u0013\r\u00119D\f\u0002\u0014!\u0006\u0014H/\u001b;j_:4U\r^2i'R\fG/Z\u0001\u0014[\u0006L(-Z+qI\u0006$X\rV8qS\u000eLEm\u001d\u000b\u0007\u0003s\u0011iDa\u0011\t\u000f\t}B\u00051\u0001\u0003B\u0005\u0011\u0002/\u0019:uSRLwN\\:U_V\u0003H-\u0019;f!\u0015A7.a#X\u0011\u001d\u0011)\u0005\na\u0001\u0005\u000f\n\u0001\u0002^8qS\u000eLEm\u001d\t\u0007m\t%\u0013J!\u0014\n\u0007\t-sGA\u0005Gk:\u001cG/[8ocA!a'\u0019B(!\u0011\tiI!\u0015\n\t\tM\u0013q\u0012\u0002\u0005+VLG-\u0001\u000esK6|g/\u001a$fi\u000eDWM\u001d$peB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u00032\te\u0003b\u0002B.K\u0001\u0007!QL\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b#\u00025\u0003`\u0005-\u0015b\u0001B1S\n\u00191+\u001a;\u00025MDW\u000f\u001e3po:LE\r\\3GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ:\u0002!\rdwn]3BY24U\r^2iKJ\u001c\u0018AF!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:NC:\fw-\u001a:\u0011\u0005qK3CA\u00156)\t\u0011I'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0005\u0005g\u00129(\u0006\u0002\u0003v)\u001a\u0001-a@\u0005\u000bM\\#\u0019\u0001;\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\u0011\u0011iH!!\u0016\u0005\t}$fA4\u0002\u0000\u0012)1\u000f\fb\u0001i\u0002")
public abstract class AbstractFetcherManager<T extends AbstractFetcherThread>
implements KafkaMetricsGroup {
    private final String name;
    private final HashMap<FetcherTag, T> fetcherThreadMap;
    private final Object lock;
    private int numFetchersPerBroker;
    private final FetchConnectionsMode replicaFetchConnectionsMode;
    private final FailedPartitions failedPartitions;
    private final Map<String, String> tags;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <T extends AbstractFetcherThread> Map<String, String> $lessinit$greater$default$6() {
        return (Map)scala.collection.Map$.MODULE$.empty();
    }

    public static <T extends AbstractFetcherThread> Option<Scheduler> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$(this, metricName, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$(this, metricName);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    public HashMap<FetcherTag, T> fetcherThreadMap() {
        return this.fetcherThreadMap;
    }

    public Object lock() {
        return this.lock;
    }

    private int numFetchersPerBroker() {
        return this.numFetchersPerBroker;
    }

    private void numFetchersPerBroker_$eq(int x$1) {
        this.numFetchersPerBroker = x$1;
    }

    public FetchConnectionsMode replicaFetchConnectionsMode() {
        return this.replicaFetchConnectionsMode;
    }

    public FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    private Map<String, String> tags() {
        return this.tags;
    }

    public void createSeparateFetcherMetrics() {
        FetcherPool$.MODULE$.values().foreach((Function1 & Serializable)fetcherPool -> this.newGauge("MinFetchRate", new Gauge<Object>(this, fetcherPool){
            private final /* synthetic */ AbstractFetcherManager $outer;
            private final FetcherPool fetcherPool$1;

            public final double value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$createSeparateFetcherMetrics$2(this.fetcherPool$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetcherPool$1 = fetcherPool$1;
            }
        }, (Map<String, String>)((Map)this.tags().$plus$plus((IterableOnce)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FetcherPool"), (Object)fetcherPool.name())}))))));
    }

    private double minFetchRate(Map<FetcherTag, T> fetcherMap) {
        double headRate = BoxesRunTime.unboxToDouble((Object)fetcherMap.values().headOption().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToDouble((double)AbstractFetcherManager.$anonfun$minFetchRate$1(x$4))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
        return BoxesRunTime.unboxToDouble((Object)fetcherMap.values().foldLeft((Object)BoxesRunTime.boxToDouble((double)headRate), (Function2 & Serializable)(curMinAll, fetcherThread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.min(BoxesRunTime.unboxToDouble((Object)curMinAll), fetcherThread.fetcherStats().requestRate().oneMinuteRate()))));
    }

    public int deadThreadCount() {
        Object object = this.lock();
        synchronized (object) {
            int n = this.fetcherThreadMap().values().count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isThreadFailed()));
            return n;
        }
    }

    public void resizeThreadPool(int newSize) {
        Object object = this.lock();
        synchronized (object) {
            int currentSize = this.numFetchersPerBroker();
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Resizing fetcher thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
            this.numFetchersPerBroker_$eq(newSize);
            if (newSize != currentSize) {
                this.migratePartitions$1(newSize);
            }
            this.shutdownIdleFetcherThreads();
            return;
        }
    }

    public Option<T> getFetcher(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            Option option = this.fetcherThreadMap().values().find((Function1 & Serializable)fetcherThread -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$getFetcher$1(topicPartition, fetcherThread)));
            return option;
        }
    }

    public int getFetcherId(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            int n = Utils.abs((int)(31 * topicPartition.topic().hashCode() + topicPartition.partition())) % this.numFetchersPerBroker();
            return n;
        }
    }

    public void markPartitionsForTruncation(int brokerId, TopicPartition topicPartition, long truncationOffset) {
        Object object = this.lock();
        synchronized (object) {
            int fetcherId = this.getFetcherId(topicPartition);
            FetcherPool$.MODULE$.values().foreach((Function1 & Serializable)fetcherPool -> {
                AbstractFetcherManager.$anonfun$markPartitionsForTruncation$1(this, brokerId, fetcherId, topicPartition, truncationOffset, fetcherPool);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public abstract T createFetcherThread(int var1, BrokerEndPoint var2, FetcherPool var3);

    public void addFetcherForPartitions(Map<TopicPartition, InitialFetchState> partitionAndOffsets, FetcherPool fetcherPool, Function2<TopicPartition, T, BoxedUnit> callback) {
        Object object = this.lock();
        synchronized (object) {
            partitionAndOffsets.groupBy((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    TopicPartition topicPartition = (TopicPartition)x0$1._1();
                    InitialFetchState brokerAndInitialFetchOffset = (InitialFetchState)x0$1._2();
                    return new BrokerAndFetcherId(brokerAndInitialFetchOffset.leader(), this.getFetcherId(topicPartition));
                }
                throw new MatchError(null);
            }).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$addFetcherForPartitions$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$8 -> {
                AbstractFetcherManager.$anonfun$addFetcherForPartitions$3(this, fetcherPool, callback, x$8);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Function2<TopicPartition, T, BoxedUnit> addFetcherForPartitions$default$3() {
        return (Function2 & Serializable)(x$6, x$7) -> {
            AbstractFetcherManager.$anonfun$addFetcherForPartitions$default$3$1(x$6, x$7);
            return BoxedUnit.UNIT;
        };
    }

    public void addFailedPartition(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            this.failedPartitions().add(topicPartition);
            return;
        }
    }

    public void addPartitionsToFetcherThread(T fetcherThread, Map<TopicPartition, InitialFetchState> initialOffsetAndEpochs) {
        ((AbstractFetcherThread)fetcherThread).addPartitions(initialOffsetAndEpochs);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Added fetcher ").append(fetcherThread.name()).append(" to broker ").append(fetcherThread.leader().brokerEndPoint().id()).append(" for partitions ").append(initialOffsetAndEpochs).toString());
    }

    public void maybeMigrateInSyncPartitions() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$1(check$ifrefutable$2))).foreach((Function1 & Serializable)x$9 -> {
                AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$2(this, x$9);
                return BoxedUnit.UNIT;
            });
            this.shutdownIdleFetcherThreads();
            return;
        }
    }

    private Map<TopicPartition, InitialFetchState> toInitialFetchState(AbstractFetcherThread fetcher, Map<TopicPartition, PartitionFetchState> partitionStates) {
        return (Map)partitionStates.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                PartitionFetchState fetchState = (PartitionFetchState)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new InitialFetchState(fetchState.topicId(), fetcher.leader().brokerEndPoint(), fetchState.currentLeaderEpoch(), fetchState.fetchOffset()));
            }
            throw new MatchError(null);
        });
    }

    public void maybeUpdateTopicIds(Map<TopicPartition, Object> partitionsToUpdate, Function1<String, Option<Uuid>> topicIds) {
        Object object = this.lock();
        synchronized (object) {
            ((scala.collection.immutable.Map)partitionsToUpdate.groupBy((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    TopicPartition topicPartition = (TopicPartition)x0$1._1();
                    int leaderId = x0$1._2$mcI$sp();
                    return FetcherPool$.MODULE$.values().map((Function1 & Serializable)poolType -> new FetcherTag(leaderId, this.getFetcherId(topicPartition), (FetcherPool)poolType));
                }
                throw new MatchError(null);
            }).map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    List brokerAndFetcherId = (List)x0$2._1();
                    Map partitionsToUpdate = (Map)x0$2._2();
                    return new Tuple2((Object)brokerAndFetcherId, (Object)partitionsToUpdate.keySet());
                }
                throw new MatchError(null);
            })).withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$maybeUpdateTopicIds$4(check$ifrefutable$3))).foreach((Function1 & Serializable)x$11 -> {
                AbstractFetcherManager.$anonfun$maybeUpdateTopicIds$5(this, topicIds, x$11);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Map<TopicPartition, PartitionFetchState> removeFetcherForPartitions(Set<TopicPartition> partitions) {
        scala.collection.mutable.Map fetchStates = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().values().foreach((Function1 & Serializable)fetcher -> (scala.collection.mutable.Map)fetchStates.$plus$plus$eq(fetcher.removePartitions(partitions)));
            this.failedPartitions().removeAll(partitions);
        }
        if (partitions.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Removed fetcher for partitions ").append(partitions).toString());
        }
        return fetchStates;
    }

    public void shutdownIdleFetcherThreads() {
        Object object = this.lock();
        synchronized (object) {
            HashSet keysToBeRemoved = new HashSet();
            this.fetcherThreadMap().withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$shutdownIdleFetcherThreads$1(check$ifrefutable$4))).foreach((Function1 & Serializable)x$12 -> {
                if (x$12 != null) {
                    FetcherTag key = (FetcherTag)x$12._1();
                    AbstractFetcherThread fetcher = (AbstractFetcherThread)x$12._2();
                    if (fetcher.partitionCount() <= 0) {
                        fetcher.shutdown();
                        return keysToBeRemoved.$plus$eq((Object)key);
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError(null);
            });
            HashMap cfr_ignored_0 = (HashMap)this.fetcherThreadMap().$minus$minus$eq((IterableOnce)keysToBeRemoved);
            return;
        }
    }

    public void closeAllFetchers() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$1(check$ifrefutable$5))).foreach((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$2(x$13)));
            this.fetcherThreadMap().withFilter((Function1 & Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$3(check$ifrefutable$6))).foreach((Function1 & Serializable)x$14 -> {
                AbstractFetcherManager.$anonfun$closeAllFetchers$4(x$14);
                return BoxedUnit.UNIT;
            });
            this.fetcherThreadMap().clear();
            return;
        }
    }

    public static final /* synthetic */ long $anonfun$new$2(long curMaxLagAll, AbstractFetcherThread fetcherThread) {
        long maxLagThread = BoxesRunTime.unboxToLong((Object)fetcherThread.fetcherLagStats().stats().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable)(curMaxLagThread, lagMetrics) -> BoxesRunTime.boxToLong((long)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)curMaxLagThread), lagMetrics.lag()))));
        return package$.MODULE$.max(curMaxLagAll, maxLagThread);
    }

    public final /* synthetic */ long kafka$server$AbstractFetcherManager$$$anonfun$new$1() {
        return BoxesRunTime.unboxToLong((Object)this.fetcherThreadMap().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable)(curMaxLagAll, fetcherThread) -> BoxesRunTime.boxToLong((long)AbstractFetcherManager.$anonfun$new$2(BoxesRunTime.unboxToLong((Object)curMaxLagAll), fetcherThread))));
    }

    public static final /* synthetic */ long $anonfun$new$5(AbstractFetcherThread x$1) {
        return BoxesRunTime.unboxToLong((Object)x$1.fetcherLagStats().stats().values().iterator().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.lag())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public final /* synthetic */ long kafka$server$AbstractFetcherManager$$$anonfun$new$4() {
        return BoxesRunTime.unboxToLong((Object)this.fetcherThreadMap().valuesIterator().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)AbstractFetcherManager.$anonfun$new$5(x$1))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public final /* synthetic */ double kafka$server$AbstractFetcherManager$$$anonfun$new$7() {
        return this.minFetchRate((Map<FetcherTag, T>)this.fetcherThreadMap());
    }

    public static final /* synthetic */ double $anonfun$new$9(AbstractFetcherThread x$3) {
        return x$3.fetcherStats().requestRate().oneMinuteRate();
    }

    public final /* synthetic */ double kafka$server$AbstractFetcherManager$$$anonfun$new$8() {
        return BoxesRunTime.unboxToDouble((Object)this.fetcherThreadMap().valuesIterator().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToDouble((double)AbstractFetcherManager.$anonfun$new$9(x$3))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public final /* synthetic */ int kafka$server$AbstractFetcherManager$$$anonfun$new$10() {
        return this.failedPartitions().size();
    }

    public final /* synthetic */ int kafka$server$AbstractFetcherManager$$$anonfun$new$11() {
        return this.deadThreadCount();
    }

    public static final /* synthetic */ void $anonfun$new$12(AbstractFetcherManager $this, Scheduler s) {
        JFunction0.mcV.sp & Serializable x$2 = (JFunction0.mcV.sp & Serializable)() -> $this.maybeMigrateInSyncPartitions();
        long x$5 = s.schedule$default$3();
        s.schedule("migrate-in-sync-partitions-thread", (Function0<BoxedUnit>)x$2, x$5, 1000L, TimeUnit.MILLISECONDS);
        $this.createSeparateFetcherMetrics();
    }

    public static final /* synthetic */ boolean $anonfun$createSeparateFetcherMetrics$3(FetcherPool fetcherPool$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            FetcherPool fetcherPool = ((FetcherTag)x0$1._1()).fetcherPool();
            return !(fetcherPool != null ? !fetcherPool.equals(fetcherPool$1) : fetcherPool$1 != null);
        }
        throw new MatchError(null);
    }

    public final /* synthetic */ double kafka$server$AbstractFetcherManager$$$anonfun$createSeparateFetcherMetrics$2(FetcherPool fetcherPool$1) {
        return this.minFetchRate((Map)this.fetcherThreadMap().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$createSeparateFetcherMetrics$3(fetcherPool$1, x0$1))));
    }

    public static final /* synthetic */ double $anonfun$minFetchRate$1(AbstractFetcherThread x$4) {
        return x$4.fetcherStats().requestRate().oneMinuteRate();
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$2(AbstractFetcherThread thread$1, scala.collection.mutable.Map allRemovedPartitionsMapByFetcherPool$1, FetcherTag id$1, TopicPartition topicPartition, PartitionFetchState currentFetchState) {
        InitialFetchState initialFetchState = new InitialFetchState(currentFetchState.topicId(), thread$1.leader().brokerEndPoint(), currentFetchState.currentLeaderEpoch(), currentFetchState.fetchOffset());
        ((scala.collection.mutable.Map)allRemovedPartitionsMapByFetcherPool$1.getOrElseUpdate((Object)id$1.fetcherPool(), (Function0 & Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$))).update((Object)topicPartition, (Object)initialFetchState);
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$1(int newSize$1, scala.collection.mutable.Map allRemovedPartitionsMapByFetcherPool$1, FetcherTag id, AbstractFetcherThread thread) {
        Map<TopicPartition, PartitionFetchState> partitionStates = thread.removeAllPartitions();
        if (id.fetcherId() >= newSize$1) {
            thread.shutdown();
        }
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, currentFetchState) -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$2(thread, allRemovedPartitionsMapByFetcherPool$1, id, topicPartition, currentFetchState);
            return BoxedUnit.UNIT;
        };
        partitionStates.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
    }

    private final void migratePartitions$1(int newSize) {
        scala.collection.mutable.Map allRemovedPartitionsMapByFetcherPool = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.fetcherThreadMap().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(id, thread) -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$1(newSize, allRemovedPartitionsMapByFetcherPool, id, thread);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(fetcherPool, allRemovedPartitionsMap) -> {
            this.addFetcherForPartitions((Map<TopicPartition, InitialFetchState>)allRemovedPartitionsMap, fetcherPool, this.addFetcherForPartitions$default$3());
            return BoxedUnit.UNIT;
        };
        allRemovedPartitionsMapByFetcherPool.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
    }

    public static final /* synthetic */ boolean $anonfun$getFetcher$1(TopicPartition topicPartition$1, AbstractFetcherThread fetcherThread) {
        return fetcherThread.fetchState(topicPartition$1).isDefined();
    }

    public static final /* synthetic */ void $anonfun$markPartitionsForTruncation$1(AbstractFetcherManager $this, int brokerId$1, int fetcherId$1, TopicPartition topicPartition$2, long truncationOffset$1, FetcherPool fetcherPool) {
        FetcherTag fetcherTag = new FetcherTag(brokerId$1, fetcherId$1, fetcherPool);
        $this.fetcherThreadMap().get((Object)fetcherTag).foreach((Function1 & Serializable)thread -> {
            thread.markPartitionsForTruncation(topicPartition$2, truncationOffset$1);
            return BoxedUnit.UNIT;
        });
    }

    private final AbstractFetcherThread addAndStartFetcherThread$1(BrokerAndFetcherId brokerAndFetcherId, FetcherTag fetcherTag) {
        T fetcherThread = this.createFetcherThread(brokerAndFetcherId.fetcherId(), brokerAndFetcherId.broker(), fetcherTag.fetcherPool());
        this.fetcherThreadMap().put((Object)fetcherTag, fetcherThread);
        ((Thread)fetcherThread).start();
        return fetcherThread;
    }

    public static final /* synthetic */ boolean $anonfun$addFetcherForPartitions$2(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$3(AbstractFetcherManager $this, FetcherPool fetcherPool$2, Function2 callback$1, Tuple2 x$8) {
        block6: {
            if (x$8 == null) break block6;
            brokerAndFetcherId = (BrokerAndFetcherId)x$8._1();
            initialFetchOffsets = (Map)x$8._2();
            fetcherTag = new FetcherTag(brokerAndFetcherId.broker().id(), brokerAndFetcherId.fetcherId(), fetcherPool$2);
            var8_7 = false;
            var9_8 = null;
            var10_9 = $this.fetcherThreadMap().get((Object)fetcherTag);
            if (!(var10_9 instanceof Some)) ** GOTO lbl-1000
            var8_7 = true;
            var9_8 = (Some)var10_9;
            currentFetcherThread = (AbstractFetcherThread)var9_8.value();
            v0 = currentFetcherThread.leader().brokerEndPoint();
            var12_11 = brokerAndFetcherId.broker();
            if (!(v0 != null ? v0.equals(var12_11) == false : var12_11 != null)) {
                v1 = currentFetcherThread;
            } else if (var8_7) {
                ((AbstractFetcherThread)var9_8.value()).shutdown();
                v1 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, fetcherTag);
            } else if (None$.MODULE$.equals(var10_9)) {
                v1 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, fetcherTag);
            } else {
                throw new MatchError((Object)var10_9);
            }
            fetcherThread = v1;
            $this.addPartitionsToFetcherThread(fetcherThread, (Map<TopicPartition, InitialFetchState>)initialFetchOffsets);
            initialFetchOffsets.keys().foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$addFetcherForPartitions$4$adapted(scala.Function2 kafka.server.AbstractFetcherThread org.apache.kafka.common.TopicPartition ), (Lorg/apache/kafka/common/TopicPartition;)Ljava/lang/Object;)((Function2)callback$1, (AbstractFetcherThread)fetcherThread));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$default$3$1(TopicPartition x$6, AbstractFetcherThread x$7) {
    }

    public static final /* synthetic */ boolean $anonfun$maybeMigrateInSyncPartitions$1(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$maybeMigrateInSyncPartitions$3(Tuple2 x0$1) {
        FetcherLagMetrics lagMetrics;
        if (x0$1 != null && (lagMetrics = (FetcherLagMetrics)x0$1._2()) != null) {
            return lagMetrics.lag() == 0L;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ void $anonfun$maybeMigrateInSyncPartitions$2(AbstractFetcherManager $this, Tuple2 x$9) {
        if (x$9 != null) {
            FetcherTag tag = (FetcherTag)x$9._1();
            AbstractFetcherThread fetcher = (AbstractFetcherThread)x$9._2();
            FetcherPool fetcherPool = tag.fetcherPool();
            FetcherPool$Default$ fetcherPool$Default$ = FetcherPool$Default$.MODULE$;
            if (fetcherPool == null) {
                return;
            }
            if (fetcherPool.equals(fetcherPool$Default$)) {
                scala.collection.immutable.Set inSyncPartitions = ((IterableOnceOps)((IterableOps)fetcher.fetcherLagStats().stats().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$3(x0$1)))).map((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        return (TopicPartition)x0$2._1();
                    }
                    throw new MatchError(null);
                })).toSet();
                Map<TopicPartition, PartitionFetchState> partitionStates = fetcher.removePartitions((Set<TopicPartition>)inSyncPartitions);
                Map<TopicPartition, InitialFetchState> fetchStates = $this.toInitialFetchState(fetcher, partitionStates);
                $this.addFetcherForPartitions(fetchStates, FetcherPool$InSync$.MODULE$, $this.addFetcherForPartitions$default$3());
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Moved ").append(partitionStates.size()).append(" partitions from ").append(FetcherPool$Default$.MODULE$).append(" to ").append(FetcherPool$InSync$.MODULE$).append(" for ").append(tag).toString());
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$maybeUpdateTopicIds$4(Tuple2 check$ifrefutable$3) {
        return check$ifrefutable$3 != null;
    }

    public static final /* synthetic */ void $anonfun$maybeUpdateTopicIds$6(AbstractFetcherManager $this, Set partitions$1, Function1 topicIds$1, FetcherTag fetcherTag) {
        $this.fetcherThreadMap().get((Object)fetcherTag).foreach((Function1 & Serializable)x$10 -> {
            x$10.maybeUpdateTopicIds((Set<TopicPartition>)partitions$1, (Function1<String, Option<Uuid>>)topicIds$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$maybeUpdateTopicIds$5(AbstractFetcherManager $this, Function1 topicIds$1, Tuple2 x$11) {
        if (x$11 != null) {
            List fetcherTags = (List)x$11._1();
            Set partitions = (Set)x$11._2();
            fetcherTags.foreach((Function1 & Serializable)fetcherTag -> {
                AbstractFetcherManager.$anonfun$maybeUpdateTopicIds$6($this, partitions, topicIds$1, fetcherTag);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$shutdownIdleFetcherThreads$1(Tuple2 check$ifrefutable$4) {
        return check$ifrefutable$4 != null;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$1(Tuple2 check$ifrefutable$5) {
        return check$ifrefutable$5 != null;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$2(Tuple2 x$13) {
        if (x$13 != null) {
            return ((AbstractFetcherThread)x$13._2()).initiateShutdown();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$3(Tuple2 check$ifrefutable$6) {
        return check$ifrefutable$6 != null;
    }

    public static final /* synthetic */ void $anonfun$closeAllFetchers$4(Tuple2 x$14) {
        if (x$14 != null) {
            ((AbstractFetcherThread)x$14._2()).shutdown();
            return;
        }
        throw new MatchError(null);
    }

    public AbstractFetcherManager(String name, String clientId, int numFetchers, FetchConnectionsMode fetchMode, Option<Scheduler> scheduler, Map<String, String> extraMetricTags) {
        BoxedUnit boxedUnit;
        this.name = name;
        this.fetcherThreadMap = new HashMap();
        this.lock = new Object();
        this.numFetchersPerBroker = numFetchers;
        this.replicaFetchConnectionsMode = fetchMode;
        this.failedPartitions = new FailedPartitions();
        this.logIdent_$eq(new StringBuilder(3).append("[").append(name).append("] ").toString());
        this.tags = (Map)((MapOps)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))).$plus$plus(extraMetricTags);
        this.newGauge("MaxLag", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final long value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("TotalLag", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final long value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$4();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("MinFetchRate", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final double value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$7();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("TotalFetchRate", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final double value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$8();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("FailedPartitionsCount", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final int value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$10();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("DeadThreadCount", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final int value() {
                AbstractFetcherManager abstractFetcherManager = this.$outer;
                if (abstractFetcherManager == null) {
                    throw null;
                }
                return abstractFetcherManager.deadThreadCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        FetchConnectionsMode fetchConnectionsMode = this.replicaFetchConnectionsMode();
        FetchConnectionsMode$Isolated$ fetchConnectionsMode$Isolated$ = FetchConnectionsMode$Isolated$.MODULE$;
        if (fetchConnectionsMode != null && fetchConnectionsMode.equals(fetchConnectionsMode$Isolated$)) {
            scheduler.foreach((Function1 & Serializable)s -> {
                AbstractFetcherManager.$anonfun$new$12(this, s);
                return BoxedUnit.UNIT;
            });
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.locally((Object)boxedUnit);
    }

    public static final /* synthetic */ Object $anonfun$addFetcherForPartitions$4$adapted(Function2 callback$1, AbstractFetcherThread fetcherThread$1, TopicPartition tp) {
        callback$1.apply((Object)tp, (Object)fetcherThread$1);
        return BoxedUnit.UNIT;
    }
}

