/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kafka.common.InterBrokerSendThread;
import kafka.common.RequestAndCompletionHandler;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.server.KafkaConfig;
import kafka.server.PerNodeQueue;
import kafka.utils.CoreUtils$;
import kafka.utils.KafkaScheduler;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.concurrent.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t\u0005d!B\u0014)\u0003\u0003i\u0003\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u0011\u0001\u0003!\u0011!Q\u0001\n\u0005C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"Aq\u000b\u0001B\u0001B\u0003%\u0001\f\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003_\u0011\u0015Y\u0007\u0001\"\u0001m\u0011%\t\t\u0001\u0001b\u0001\n\u0003\t\u0019\u0001\u0003\u0005\u0002$\u0001\u0001\u000b\u0011BA\u0003\u0011%\t)\u0003\u0001b\u0001\n\u0003\t9\u0003\u0003\u0005\u00020\u0001\u0001\u000b\u0011BA\u0015\u0011-\t\t\u0004\u0001a\u0001\u0002\u0004%\t!a\r\t\u0017\u0005\u0015\u0003\u00011AA\u0002\u0013\u0005\u0011q\t\u0005\f\u0003'\u0002\u0001\u0019!A!B\u0013\t)\u0004C\u0005\u0002^\u0001\u0001\r\u0011\"\u0001\u0002`!I\u0011q\r\u0001A\u0002\u0013\u0005\u0011\u0011\u000e\u0005\t\u0003[\u0002\u0001\u0015)\u0003\u0002b!I\u0011\u0011\u000f\u0001C\u0002\u0013\u0005\u00111\u000f\u0005\b\u0003k\u0002\u0001\u0015!\u0003_\u0011%\t9\b\u0001b\u0001\n\u0003\t\u0019\bC\u0004\u0002z\u0001\u0001\u000b\u0011\u00020\t\u0013\u0005m\u0004A1A\u0005\u0002\u0005u\u0004\u0002CAC\u0001\u0001\u0006I!a \t\u0013\u0005\u001d\u0005A1A\u0005\u0002\u0005u\u0004\u0002CAE\u0001\u0001\u0006I!a \t\u0013\u0005-\u0005A1A\u0005\u0002\u0005u\u0004\u0002CAG\u0001\u0001\u0006I!a \t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\"9\u0011Q\u0013\u0001\u0005B\u0005]\u0005bBAM\u0001\u0011\u0005\u00111\u0014\u0005\b\u0003k\u0003A\u0011AA\\\u0011\u001d\t\t\u000e\u0001C\u0001\u0003'Dq!!5\u0001\t\u0003\tI\u000eC\u0004\u0002h\u0002!I!!;\t\u000f\t5\u0001\u0001\"\u0003\u0003\u0010!9!Q\u0003\u0001\u0007\u0002\t]\u0001b\u0002B!\u0001\u0019\u0005!1\t\u0005\n\u0005\u0013\u0002\u0011\u0013!C\u0001\u0005\u0017\u0012Q#\u00112tiJ\f7\r\u001e*fcV,7\u000f\u001e+ie\u0016\fGM\u0003\u0002*U\u000511/\u001a:wKJT\u0011aK\u0001\u0006W\u000647.Y\u0002\u0001+\tq\u0003oE\u0002\u0001_U\u0002\"\u0001M\u001a\u000e\u0003ER!A\r\u0016\u0002\r\r|W.\\8o\u0013\t!\u0014GA\u000bJ]R,'O\u0011:pW\u0016\u00148+\u001a8e)\"\u0014X-\u00193\u0011\u0005YJT\"A\u001c\u000b\u0005aR\u0013!B;uS2\u001c\u0018B\u0001\u001e8\u0005\u001daunZ4j]\u001e\faaY8oM&<\u0007CA\u001f?\u001b\u0005A\u0013BA )\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u000f5,GO]5dgB\u0011!IS\u0007\u0002\u0007*\u0011\u0001\t\u0012\u0006\u0003e\u0015S!a\u000b$\u000b\u0005\u001dC\u0015AB1qC\u000eDWMC\u0001J\u0003\ry'oZ\u0005\u0003\u0017\u000e\u0013q!T3ue&\u001c7/A\u0007oKR<xN]6DY&,g\u000e\u001e\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u0016\u000bqa\u00197jK:$8/\u0003\u0002S\u001f\nia*\u001a;x_J\\7\t\\5f]R\fab[1gW\u0006\u001c6\r[3ek2,'\u000f\u0005\u00027+&\u0011ak\u000e\u0002\u000f\u0017\u000647.Y*dQ\u0016$W\u000f\\3s\u0003\u0011!\u0018.\\3\u0011\u0005e[V\"\u0001.\u000b\u0005a\"\u0015B\u0001/[\u0005\u0011!\u0016.\\3\u0002\u0017I,\u0017/^3ti:\u000bW.\u001a\t\u0003?\"t!\u0001\u00194\u0011\u0005\u0005$W\"\u00012\u000b\u0005\rd\u0013A\u0002\u001fs_>$hHC\u0001f\u0003\u0015\u00198-\u00197b\u0013\t9G-\u0001\u0004Qe\u0016$WMZ\u0005\u0003S*\u0014aa\u0015;sS:<'BA4e\u0003\u0019a\u0014N\\5u}Q9QN_>}{z|\bcA\u001f\u0001]B\u0011q\u000e\u001d\u0007\u0001\t\u0015\t\bA1\u0001s\u0005\u0005!\u0016CA:x!\t!X/D\u0001e\u0013\t1HMA\u0004O_RD\u0017N\\4\u0011\u0005QD\u0018BA=e\u0005\r\te.\u001f\u0005\u0006w\u001d\u0001\r\u0001\u0010\u0005\u0006\u0001\u001e\u0001\r!\u0011\u0005\u0006\u0019\u001e\u0001\r!\u0014\u0005\u0006'\u001e\u0001\r\u0001\u0016\u0005\u0006/\u001e\u0001\r\u0001\u0017\u0005\u0006;\u001e\u0001\rAX\u0001\rcV,W/\u001a)fe:{G-Z\u000b\u0003\u0003\u000b\u0001\u0002\"a\u0002\u0002\u0012\u0005U\u0011QD\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005=A-\u0001\u0006d_2dWm\u0019;j_:LA!a\u0005\u0002\n\t\u0019Q*\u00199\u0011\t\u0005]\u0011\u0011D\u0007\u0002\t&\u0019\u00111\u0004#\u0003\t9{G-\u001a\t\u0005{\u0005}a.C\u0002\u0002\"!\u0012A\u0002U3s\u001d>$W-U;fk\u0016\fQ\"];fk\u0016\u0004VM\u001d(pI\u0016\u0004\u0013\u0001\u0005:fcV,7\u000f\u001e+j[\u0016|W\u000f^'t+\t\tI\u0003E\u0002u\u0003WI1!!\fe\u0005\rIe\u000e^\u0001\u0012e\u0016\fX/Z:u)&lWm\\;u\u001bN\u0004\u0013\u0001E9v_R\f7i\\8sI&t\u0017\r^8s+\t\t)\u0004\u0005\u0003\u00028\u0005\u0005SBAA\u001d\u0015\u0011\tY$!\u0010\u0002\u000bE,x\u000e^1\u000b\u0007\u0005}\"&A\u0006d_>\u0014H-\u001b8bi>\u0014\u0018\u0002BA\"\u0003s\u0011\u0001#U;pi\u0006\u001cun\u001c:eS:\fGo\u001c:\u0002)E,x\u000e^1D_>\u0014H-\u001b8bi>\u0014x\fJ3r)\u0011\tI%a\u0014\u0011\u0007Q\fY%C\u0002\u0002N\u0011\u0014A!\u00168ji\"I\u0011\u0011K\u0007\u0002\u0002\u0003\u0007\u0011QG\u0001\u0004q\u0012\n\u0014!E9v_R\f7i\\8sI&t\u0017\r^8sA!\u001aa\"a\u0016\u0011\u0007Q\fI&C\u0002\u0002\\\u0011\u0014\u0001B^8mCRLG.Z\u0001\bgR\f'\u000f^3e+\t\t\t\u0007E\u0002u\u0003GJ1!!\u001ae\u0005\u001d\u0011un\u001c7fC:\f1b\u001d;beR,Gm\u0018\u0013fcR!\u0011\u0011JA6\u0011%\t\t\u0006EA\u0001\u0002\u0004\t\t'\u0001\u0005ti\u0006\u0014H/\u001a3!Q\r\t\u0012qK\u0001\u0013e\u0016\fX/Z:u\u001d\u0006lWMT8Ta\u0006\u001cW-F\u0001_\u0003M\u0011X-];fgRt\u0015-\\3O_N\u0003\u0018mY3!\u00031iW\r\u001e:jGN<%o\\;q\u00035iW\r\u001e:jGN<%o\\;qA\u0005\tbn\u001c3f\u0019>|7.\u001e9GC&dWO]3\u0016\u0005\u0005}\u0004c\u0001\"\u0002\u0002&\u0019\u00111Q\"\u0003\rM+gn]8s\u0003Iqw\u000eZ3M_>\\W\u000f\u001d$bS2,(/\u001a\u0011\u0002\u0015I\u00048MR1jYV\u0014X-A\u0006sa\u000e4\u0015-\u001b7ve\u0016\u0004\u0013\u0001\u0003:qGJ+GO]=\u0002\u0013I\u00048MU3uef\u0004\u0013!B:uCJ$H\u0003BA%\u0003'Cq!a\u0010\u001d\u0001\u0004\t)$\u0001\u0005tQV$Hm\\<o)\t\tI%\u0001\u0005tG\",G-\u001e7f)!\tI%!(\u0002\"\u0006-\u0006BBAP=\u0001\u0007a,\u0001\u0003oC6,\u0007bBAR=\u0001\u0007\u0011QU\u0001\u0004MVt\u0007#\u0002;\u0002(\u0006%\u0013bAAUI\nIa)\u001e8di&|g\u000e\r\u0005\b\u0003[s\u0002\u0019AAX\u0003!\u0001XM]5pI6\u001b\bc\u0001;\u00022&\u0019\u00111\u00173\u0003\t1{gnZ\u0001\u0011O\u0016tWM]1uKJ+\u0017/^3tiN$\"!!/\u0011\r\u0005m\u0016QYAf\u001d\u0011\ti,!1\u000f\u0007\u0005\fy,C\u0001f\u0013\r\t\u0019\rZ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9-!3\u0003\u0011%#XM]1cY\u0016T1!a1e!\r\u0001\u0014QZ\u0005\u0004\u0003\u001f\f$a\u0007*fcV,7\u000f^!oI\u000e{W\u000e\u001d7fi&|g\u000eS1oI2,'/A\bbI\u0012,e\u000e\u001e:z\r>\u0014hj\u001c3f)\u0011\tI%!6\t\r\u0005]\u0007\u00051\u0001o\u0003\u0015)g\u000e\u001e:z)\u0019\tI%a7\u0002^\"1\u0011q[\u0011A\u00029Dq!a8\"\u0001\u0004\t\t/\u0001\u0003o_\u0012,\u0007#\u0002;\u0002d\u0006U\u0011bAAsI\n1q\n\u001d;j_:\fa\u0002[1oI2,'+Z:q_:\u001cX\r\u0006\u0004\u0002l\u0006]\u0018\u0011 \u000b\u0005\u0003\u0013\ni\u000fC\u0004\u0002p\n\u0002\r!!=\u0002\u0011I,7\u000f]8og\u0016\u00042ATAz\u0013\r\t)p\u0014\u0002\u000f\u00072LWM\u001c;SKN\u0004xN\\:f\u0011\u001d\tyD\ta\u0001\u0003+Aq!a?#\u0001\u0004\ti0A\u0004f]R\u0014\u0018.Z:\u0011\u000b\u0005}(\u0011\u00028\u000e\u0005\t\u0005!\u0002\u0002B\u0002\u0005\u000b\tA!\u001e;jY*\u0011!qA\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\f\t\u0005!!C!se\u0006LH*[:u\u00035\u0011X\r\u001e:z\r>\u0014XI\u001c;ssR1\u0011\u0011\nB\t\u0005'Aq!a?$\u0001\u0004\ti\u0010C\u0004\u0002`\u000e\u0002\r!!9\u0002\u001b\r\u0014X-\u0019;f%\u0016\fX/Z:u)\u0019\u0011IB!\u0010\u0003@A\"!1\u0004B\u0019!\u0019\u0011iB!\u000b\u000309!!q\u0004B\u0013\u001b\t\u0011\tCC\u0002\u0003$\u0011\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0005O\u0011\t#A\bBEN$(/Y2u%\u0016\fX/Z:u\u0013\u0011\u0011YC!\f\u0003\u000f\t+\u0018\u000e\u001c3fe*!!q\u0005B\u0011!\ry'\u0011\u0007\u0003\f\u0005g!\u0013\u0011!A\u0001\u0006\u0003\u0011)DA\u0002`IE\n2a\u001dB\u001c!\u0011\u0011yB!\u000f\n\t\tm\"\u0011\u0005\u0002\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti\"9\u0011q\u001c\u0013A\u0002\u0005U\u0001bBA~I\u0001\u0007\u0011Q`\u0001\bO\u0016$hj\u001c3f)\u0019\t\tO!\u0012\u0003H!1\u0011q[\u0013A\u00029D\u0011\"a8&!\u0003\u0005\r!!9\u0002#\u001d,GOT8eK\u0012\"WMZ1vYR$#'\u0006\u0002\u0003N)\"\u0011\u0011\u001dB(W\t\u0011\t\u0006\u0005\u0003\u0003T\tuSB\u0001B+\u0015\u0011\u00119F!\u0017\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B.I\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t}#Q\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public abstract class AbstractRequestThread<T>
extends InterBrokerSendThread {
    private final Metrics metrics;
    private final NetworkClient networkClient;
    private final KafkaScheduler kafkaScheduler;
    private final Time time;
    private final String requestName;
    private final Map<Node, PerNodeQueue<T>> queuePerNode;
    private final int requestTimeoutMs;
    private volatile QuotaCoordinator quotaCoordinator;
    private volatile boolean started;
    private final String requestNameNoSpace;
    private final String metricsGroup;
    private final Sensor nodeLookupFailure;
    private final Sensor rpcFailure;
    private final Sensor rpcRetry;

    public Map<Node, PerNodeQueue<T>> queuePerNode() {
        return this.queuePerNode;
    }

    public int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public QuotaCoordinator quotaCoordinator() {
        return this.quotaCoordinator;
    }

    public void quotaCoordinator_$eq(QuotaCoordinator x$1) {
        this.quotaCoordinator = x$1;
    }

    public boolean started() {
        return this.started;
    }

    public void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    public String requestNameNoSpace() {
        return this.requestNameNoSpace;
    }

    public String metricsGroup() {
        return this.metricsGroup;
    }

    public Sensor nodeLookupFailure() {
        return this.nodeLookupFailure;
    }

    public Sensor rpcFailure() {
        return this.rpcFailure;
    }

    public Sensor rpcRetry() {
        return this.rpcRetry;
    }

    public void start(QuotaCoordinator coordinator) {
        super.start();
        this.quotaCoordinator_$eq(coordinator);
        this.started_$eq(true);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.queuePerNode().clear();
        this.metrics.removeSensor(this.nodeLookupFailure().name());
        this.metrics.removeSensor(this.rpcFailure().name());
        this.metrics.removeSensor(this.rpcRetry().name());
        this.quotaCoordinator_$eq(null);
        this.started_$eq(false);
    }

    public void schedule(String name, Function0<BoxedUnit> fun, long periodMs) {
        this.kafkaScheduler.schedule(name, fun, 0L, periodMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public Iterable<RequestAndCompletionHandler> generateRequests() {
        long currentTimeMs = this.time.milliseconds();
        return (Iterable)((IterableOps)((IterableOps)this.queuePerNode().values().map((Function1 & Serializable)queue -> {
            ArrayList entryData = new ArrayList();
            queue.queue().drainTo(entryData);
            return new Tuple2((Object)queue.destination(), entryData);
        })).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractRequestThread.$anonfun$generateRequests$2(x0$1)))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                Node node = (Node)x0$2._1();
                ArrayList entries = (ArrayList)x0$2._2();
                return new RequestAndCompletionHandler(currentTimeMs, node, this.createRequest(node, entries), response -> this.handleResponse(node, entries, response));
            }
            throw new MatchError(null);
        });
    }

    public void addEntryForNode(T entry) {
        this.addEntryForNode(entry, (Option<Node>)None$.MODULE$);
    }

    public void addEntryForNode(T entry, Option<Node> node) {
        if (this.started()) {
            Option<Node> option = this.getNode(entry, node);
            if (option instanceof Some) {
                Object object;
                Node node2 = (Node)((Some)option).value();
                Map<Node, PerNodeQueue<T>> atomicGetOrUpdate_map = this.queuePerNode();
                Option option2 = atomicGetOrUpdate_map.get((Object)node2);
                if (option2 instanceof Some) {
                    object = ((Some)option2).value();
                } else if (None$.MODULE$.equals(option2)) {
                    PerNodeQueue atomicGetOrUpdate_value = new PerNodeQueue(node2);
                    object = atomicGetOrUpdate_map.putIfAbsent((Object)node2, atomicGetOrUpdate_value).getOrElse(() -> CoreUtils$.$anonfun$atomicGetOrUpdate$1(atomicGetOrUpdate_value));
                } else {
                    throw new MatchError((Object)option2);
                }
                Object var5_5 = null;
                option2 = null;
                Object var7_7 = null;
                ((PerNodeQueue)object).addEntry(entry);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append($this.requestName).append(" Request's destination node is unavailable, skipping ").append($this.requestName).append(" for entry ").append(entry).append(".").toString());
                this.nodeLookupFailure().record();
                return;
            }
            throw new MatchError(option);
        }
    }

    private void handleResponse(Node coordinator, ArrayList<T> entries, ClientResponse response) {
        if (response.authenticationException() != null) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append($this.requestName).append(" Request ").append(entries).append(" failed due to authentication error with coordinator").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> response.authenticationException());
            this.rpcFailure().record();
            return;
        }
        if (response.wasDisconnected()) {
            this.retryForEntry(entries, (Option<Node>)new Some((Object)coordinator));
            return;
        }
        if (response.responseBody().errorCounts().containsKey(Errors.NOT_COORDINATOR)) {
            this.networkClient.disconnect(coordinator.idString());
            this.retryForEntry(entries, (Option<Node>)new Some((Object)coordinator));
            return;
        }
        BooleanRef rpcFailed = BooleanRef.create((boolean)false);
        response.responseBody().errorCounts().keySet().forEach(error -> {
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                rpcFailed$1.elem = true;
                return;
            }
        });
        if (rpcFailed.elem) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append($this.requestName).append(" Request failed with Response ").append(response).toString());
            this.rpcFailure().record();
            return;
        }
    }

    private void retryForEntry(ArrayList<T> entries, Option<Node> node) {
        entries.forEach(entry -> this.addEntryForNode(entry, node));
        this.rpcRetry().record();
    }

    public abstract AbstractRequest.Builder<? extends AbstractRequest> createRequest(Node var1, ArrayList<T> var2);

    public abstract Option<Node> getNode(T var1, Option<Node> var2);

    public Option<Node> getNode$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            Node node = (Node)x0$1._1();
            return !((ArrayList)x0$1._2()).isEmpty() && !node.isEmpty();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ PerNodeQueue $anonfun$addEntryForNode$1(Node node$2) {
        return new PerNodeQueue(node$2);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractRequestThread(KafkaConfig config, Metrics metrics, NetworkClient networkClient, KafkaScheduler kafkaScheduler, Time time, String requestName) {
        void add_stat;
        void add_metricName;
        void add_stat2;
        void add_metricName2;
        void add_stat3;
        void add_metricName3;
        this.metrics = metrics;
        this.networkClient = networkClient;
        this.kafkaScheduler = kafkaScheduler;
        this.time = time;
        this.requestName = requestName;
        super(new StringBuilder(25).append("DynamicQuotaSenderThread-").append(config.brokerId()).toString(), (KafkaClient)networkClient, Predef$.MODULE$.Integer2int(config.requestTimeoutMs()), time, true);
        this.logIdent_$eq(new StringBuilder(34).append("[Dynamic Quota Channel Manager ").append(config.brokerId()).append("]: ").toString());
        this.queuePerNode = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        this.requestTimeoutMs = 30000;
        this.started = false;
        this.requestNameNoSpace = requestName.replace(" ", "-");
        this.metricsGroup = new StringBuilder(8).append(this.requestNameNoSpace().toLowerCase()).append("-metrics").toString();
        this.nodeLookupFailure = metrics.sensor(new StringBuilder(17).append(this.requestNameNoSpace()).append("NodeLookupFailure").toString());
        Sensor sensor = this.nodeLookupFailure();
        Rate rate = new Rate();
        MetricName metricName = metrics.metricName("node-lookup-failure", this.metricsGroup(), "The rate of node lookup failure");
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName3, (MeasurableStat)add_stat3, null);
        metricName = null;
        rate = null;
        this.rpcFailure = metrics.sensor(new StringBuilder(10).append(this.requestNameNoSpace()).append("RPCFailure").toString());
        Sensor sensor2 = this.rpcFailure();
        Rate rate2 = new Rate();
        MetricName metricName2 = metrics.metricName("rpc-failure", this.metricsGroup(), new StringBuilder(24).append("The rate of ").append(requestName).append(" RPC failure").toString());
        if (sensor2 == null) {
            throw null;
        }
        sensor2.add((MetricName)add_metricName2, (MeasurableStat)add_stat2, null);
        metricName2 = null;
        rate2 = null;
        this.rpcRetry = metrics.sensor(new StringBuilder(8).append(this.requestNameNoSpace()).append("RPCRetry").toString());
        Sensor sensor3 = this.rpcRetry();
        Rate rate3 = new Rate();
        MetricName metricName3 = metrics.metricName("rpc-retry", this.metricsGroup(), new StringBuilder(22).append("The rate of ").append(requestName).append(" RPC retry").toString());
        if (sensor3 == null) {
            throw null;
        }
        sensor3.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
    }
}

