/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.rest.BeginShutdownControllerHandle;
import io.confluent.rest.BeginShutdownControllerStatus;
import java.io.Serializable;
import java.util.Properties;
import kafka.server.BeginShutdownControllerHandleAdapter$;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumOptions;
import org.apache.kafka.clients.admin.QuorumInfo;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005i<Q\u0001F\u000b\t\u0002i1Q\u0001H\u000b\t\u0002uAQ\u0001J\u0001\u0005\u0002\u0015BqAJ\u0001C\u0002\u0013\u0005q\u0005\u0003\u0004,\u0003\u0001\u0006I\u0001\u000b\u0005\bY\u0005\u0011\r\u0011\"\u0001.\u0011\u00191\u0014\u0001)A\u0005]\u0019!A$\u0006\u00018\u0011!AuA!b\u0001\n\u0003I\u0005\u0002\u0003+\b\u0005\u0003\u0005\u000b\u0011\u0002&\t\u0011U;!Q1A\u0005\u0002\u001dB\u0001BV\u0004\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\t/\u001e\u0011)\u0019!C\u00011\"AQm\u0002B\u0001B\u0003%\u0011\fC\u0003%\u000f\u0011\u0005a\rC\u0003%\u000f\u0011\u00051\u000eC\u0004o\u000f\t\u0007I\u0011\u0001-\t\r=<\u0001\u0015!\u0003Z\u0011\u0015\u0001x\u0001\"\u0011r\u0011\u0015)x\u0001\"\u0011w\u0003\u0011\u0012UmZ5o'\",H\u000fZ8x]\u000e{g\u000e\u001e:pY2,'\u000fS1oI2,\u0017\tZ1qi\u0016\u0014(B\u0001\f\u0018\u0003\u0019\u0019XM\u001d<fe*\t\u0001$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005m\tQ\"A\u000b\u0003I\t+w-\u001b8TQV$Hm\\<o\u0007>tGO]8mY\u0016\u0014\b*\u00198eY\u0016\fE-\u00199uKJ\u001c\"!\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!$A\nNCb\fE\u000e\\8xK\u0012|eMZ:fi2\u000bw-F\u0001)!\ty\u0012&\u0003\u0002+A\t\u0019\u0011J\u001c;\u0002)5\u000b\u00070\u00117m_^,Gm\u00144gg\u0016$H*Y4!\u0003i)fN]3bG\"\f'\r\\3Rk>\u0014X/\\'f[\n,'/T:h+\u0005q\u0003CA\u00185\u001b\u0005\u0001$BA\u00193\u0003\u0011a\u0017M\\4\u000b\u0003M\nAA[1wC&\u0011Q\u0007\r\u0002\u0007'R\u0014\u0018N\\4\u00027Us'/Z1dQ\u0006\u0014G.Z)v_J,X.T3nE\u0016\u0014Xj]4!'\u00119a\u0004\u000f \u0011\u0005ebT\"\u0001\u001e\u000b\u0005m:\u0012!B;uS2\u001c\u0018BA\u001f;\u0005\u001daunZ4j]\u001e\u0004\"a\u0010$\u000e\u0003\u0001S!!\u0011\"\u0002\tI,7\u000f\u001e\u0006\u0003\u0007\u0012\u000b\u0011bY8oM2,XM\u001c;\u000b\u0003\u0015\u000b!![8\n\u0005\u001d\u0003%!\b\"fO&t7\u000b[;uI><hnQ8oiJ|G\u000e\\3s\u0011\u0006tG\r\\3\u0002!\t|w\u000e^:ue\u0006\u00048+\u001a:wKJ\u001cX#\u0001&\u0011\u0005-\u0013fB\u0001'Q!\ti\u0005%D\u0001O\u0015\ty\u0015$\u0001\u0004=e>|GOP\u0005\u0003#\u0002\na\u0001\u0015:fI\u00164\u0017BA\u001bT\u0015\t\t\u0006%A\tc_>$8\u000f\u001e:baN+'O^3sg\u0002\n\u0011\u0002^5nK>,H/T:\u0002\u0015QLW.Z8vi6\u001b\b%A\u0003bI6Lg.F\u0001Z!\tQ6-D\u0001\\\u0015\t9FL\u0003\u0002^=\u000691\r\\5f]R\u001c(B\u0001\r`\u0015\t\u0001\u0017-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002E\u0006\u0019qN]4\n\u0005\u0011\\&AD\"p]\u001adW/\u001a8u\u0003\u0012l\u0017N\\\u0001\u0007C\u0012l\u0017N\u001c\u0011\u0015\t\u001dD\u0017N\u001b\t\u00037\u001dAQ\u0001\u0013\bA\u0002)CQ!\u0016\bA\u0002!BQa\u0016\bA\u0002e#2a\u001a7n\u0011\u0015Au\u00021\u0001K\u0011\u0015)v\u00021\u0001)\u00035Ig\u000e^3s]\u0006d\u0017\tZ7j]\u0006q\u0011N\u001c;fe:\fG.\u00113nS:\u0004\u0013AF4f]\u0016\u0014\u0018\r^3S_2d\u0017M\u00197f'R\fG/^:\u0015\u0003I\u0004\"aP:\n\u0005Q\u0004%!\b\"fO&t7\u000b[;uI><hnQ8oiJ|G\u000e\\3s'R\fG/^:\u0002\u000b\rdwn]3\u0015\u0003]\u0004\"a\b=\n\u0005e\u0004#\u0001B+oSR\u0004")
public class BeginShutdownControllerHandleAdapter
implements Logging,
BeginShutdownControllerHandle {
    private final String bootstrapServers;
    private final int timeoutMs;
    private final ConfluentAdmin admin;
    private final ConfluentAdmin internalAdmin;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String UnreachableQuorumMemberMsg() {
        return BeginShutdownControllerHandleAdapter$.MODULE$.UnreachableQuorumMemberMsg();
    }

    public static int MaxAllowedOffsetLag() {
        return BeginShutdownControllerHandleAdapter$.MODULE$.MaxAllowedOffsetLag();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public ConfluentAdmin admin() {
        return this.admin;
    }

    public ConfluentAdmin internalAdmin() {
        return this.internalAdmin;
    }

    public BeginShutdownControllerStatus generateRollableStatus() {
        try {
            ListBuffer logEndOffsets = new ListBuffer();
            BooleanRef rollable = BooleanRef.create((boolean)true);
            ObjectRef reason = ObjectRef.create((Object)"");
            ((QuorumInfo)this.internalAdmin().describeMetadataQuorum((DescribeMetadataQuorumOptions)new DescribeMetadataQuorumOptions().timeoutMs(Predef$.MODULE$.int2Integer(this.timeoutMs()))).quorumInfo().get()).voters().forEach(v -> {
                if (v.logEndOffset() < 0L) {
                    rollable$1.elem = false;
                    reason$1.elem = BeginShutdownControllerHandleAdapter$.MODULE$.UnreachableQuorumMemberMsg();
                }
                logEndOffsets.$plus$eq((Object)BoxesRunTime.boxToLong((long)v.logEndOffset()));
            });
            if (rollable.elem) {
                long maxOffset = BoxesRunTime.unboxToLong((Object)logEndOffsets.max((Ordering)Ordering.Long$.MODULE$));
                LongRef laggingOffset = LongRef.create((long)maxOffset);
                logEndOffsets.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)o -> {
                    if (rollable$1.elem && o < maxOffset - (long)BeginShutdownControllerHandleAdapter$.MODULE$.MaxAllowedOffsetLag()) {
                        rollable$1.elem = false;
                        laggingOffset$1.elem = o;
                        reason$1.elem = new StringBuilder(123).append("Found at least one quorum voter with an offset ").append(Long.toString(laggingOffset$1.elem)).append(" while the primary controller was at offset ").append(Long.toString(maxOffset)).append(". The max allowed offset lag is ").append(BeginShutdownControllerHandleAdapter$.MODULE$.MaxAllowedOffsetLag()).toString();
                        return;
                    }
                });
            }
            return new BeginShutdownControllerStatus(rollable.elem, (String)reason.elem);
        }
        catch (Throwable e) {
            String reason = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(95).append("There was an exception of type ").append(e.getClass()).append("\n                        |while querying the state of the quorum").toString()));
            this.error((Function0<String>)(Function0 & Serializable)() -> reason, (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return new BeginShutdownControllerStatus(false, reason);
        }
    }

    public void close() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down");
        this.internalAdmin().close();
    }

    public BeginShutdownControllerHandleAdapter(String bootstrapServers, int timeoutMs, ConfluentAdmin admin) {
        ConfluentAdmin confluentAdmin;
        this.bootstrapServers = bootstrapServers;
        this.timeoutMs = timeoutMs;
        this.admin = admin;
        if (admin != null) {
            confluentAdmin = admin;
        } else {
            Properties clientConfig = new Properties();
            clientConfig.put("bootstrap.servers", bootstrapServers);
            clientConfig.put("client.id", "kraft-controller-local-admin");
            clientConfig.put("confluent.use.controller.listener", "true");
            confluentAdmin = (ConfluentAdmin)Admin.create((Properties)clientConfig);
        }
        this.internalAdmin = confluentAdmin;
    }

    public BeginShutdownControllerHandleAdapter(String bootstrapServers, int timeoutMs) {
        this(bootstrapServers, timeoutMs, null);
    }
}

