/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Map;
import java.util.Properties;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.link.ClusterLinkConfig$;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.controller.ConfigurationValidator;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Predef$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005)4A\u0001D\u0007\u0001%!Aa\u0005\u0001BC\u0002\u0013\u0005q\u0005\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003)\u0011!y\u0003A!b\u0001\n\u00039\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u000bE\u0002A\u0011\u0001\u001a\t\u000b]\u0002A\u0011\u0002\u001d\t\u000b%\u0003A\u0011\u0002&\t\u000b1\u0003A\u0011B'\t\u000ba\u0003A\u0011I-\t\u000ba\u0003A\u0011I.\t\u000b\u0011\u0004A\u0011I3\u0003A\r{g\u000e\u001e:pY2,'oQ8oM&<WO]1uS>tg+\u00197jI\u0006$xN\u001d\u0006\u0003\u001d=\taa]3sm\u0016\u0014(\"\u0001\t\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001aE\u000e\u0011\u0005QIR\"A\u000b\u000b\u0005Y9\u0012\u0001\u00027b]\u001eT\u0011\u0001G\u0001\u0005U\u00064\u0018-\u0003\u0002\u001b+\t1qJ\u00196fGR\u0004\"\u0001\b\u0013\u000e\u0003uQ!AH\u0010\u0002\u0015\r|g\u000e\u001e:pY2,'O\u0003\u0002\u0011A)\u0011\u0011EI\u0001\u0007CB\f7\r[3\u000b\u0003\r\n1a\u001c:h\u0013\t)SD\u0001\fD_:4\u0017nZ;sCRLwN\u001c,bY&$\u0017\r^8s\u0003I!\u0018.\u001a:GK\u0006$XO]3F]\u0006\u0014G.\u001a3\u0016\u0003!\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012qAQ8pY\u0016\fg.A\nuS\u0016\u0014h)Z1ukJ,WI\\1cY\u0016$\u0007%A\ruS\u0016\u00148\t\\3b]\u0016\u0014h)Z1ukJ,WI\\1cY\u0016$\u0017A\u0007;jKJ\u001cE.Z1oKJ4U-\u0019;ve\u0016,e.\u00192mK\u0012\u0004\u0013A\u0002\u001fj]&$h\bF\u00024kY\u0002\"\u0001\u000e\u0001\u000e\u00035AQAJ\u0003A\u0002!BQaL\u0003A\u0002!\n\u0011C^1mS\u0012\fG/\u001a+pa&\u001cg*Y7f)\tID\b\u0005\u0002*u%\u00111H\u000b\u0002\u0005+:LG\u000fC\u0003>\r\u0001\u0007a(\u0001\u0003oC6,\u0007CA G\u001d\t\u0001E\t\u0005\u0002BU5\t!I\u0003\u0002D#\u00051AH]8pizJ!!\u0012\u0016\u0002\rA\u0013X\rZ3g\u0013\t9\u0005J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000b*\n!C^1mS\u0012\fG/\u001a\"s_.,'OT1nKR\u0011\u0011h\u0013\u0005\u0006{\u001d\u0001\rAP\u0001%i\"\u0014xn^#yG\u0016\u0004H/[8o\r>\u0014XK\\6o_^t'+Z:pkJ\u001cW\rV=qKR\u0011\u0011H\u0014\u0005\u0006\u001f\"\u0001\r\u0001U\u0001\te\u0016\u001cx.\u001e:dKB\u0011\u0011KV\u0007\u0002%*\u00111\u000bV\u0001\u0007G>tg-[4\u000b\u0005U{\u0012AB2p[6|g.\u0003\u0002X%\nq1i\u001c8gS\u001e\u0014Vm]8ve\u000e,\u0017\u0001\u0003<bY&$\u0017\r^3\u0015\u0005eR\u0006\"B(\n\u0001\u0004\u0001FcA\u001d];\")qJ\u0003a\u0001!\")1K\u0003a\u0001=B!qL\u0019 ?\u001b\u0005\u0001'BA1\u0018\u0003\u0011)H/\u001b7\n\u0005\r\u0004'aA'ba\u0006Ib/\u00197jI\u0006$X\rV8qS\u000e\u001cuN\u001c4jO\u000eC\u0017M\\4f)\rId\r\u001b\u0005\u0006O.\u0001\rAX\u0001\u0013aJ,gOU3t_24X\rZ\"p]\u001aLw\rC\u0003j\u0017\u0001\u0007a,A\toK^\u0014Vm]8mm\u0016$7i\u001c8gS\u001e\u0004")
public class ControllerConfigurationValidator
implements ConfigurationValidator {
    private final boolean tierFeatureEnabled;
    private final boolean tierCleanerFeatureEnabled;

    public boolean tierFeatureEnabled() {
        return this.tierFeatureEnabled;
    }

    public boolean tierCleanerFeatureEnabled() {
        return this.tierCleanerFeatureEnabled;
    }

    private void validateTopicName(String name) {
        if (name.isEmpty()) {
            throw new InvalidRequestException("Default topic resources are not allowed.");
        }
        Topic.validate((String)name);
    }

    private void validateBrokerName(String name) {
        if (!name.isEmpty()) {
            Integer n;
            try {
                n = Integer.valueOf(name);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidRequestException("Unable to parse broker name as a base 10 number.");
            }
            Integer brokerId = n;
            if (Predef$.MODULE$.Integer2int(brokerId) < 0) {
                throw new InvalidRequestException("Invalid negative broker ID.");
            }
            return;
        }
    }

    private void throwExceptionForUnknownResourceType(ConfigResource resource) {
        throw new InvalidRequestException(new StringBuilder(22).append("Unknown resource type ").append(resource.type()).toString());
    }

    public void validate(ConfigResource resource) {
        ConfigResource.Type type = resource.type();
        if (ConfigResource.Type.TOPIC.equals(type)) {
            this.validateTopicName(resource.name());
            return;
        }
        if (ConfigResource.Type.BROKER.equals(type)) {
            this.validateBrokerName(resource.name());
            return;
        }
        if (ConfigResource.Type.CLUSTER_LINK.equals(type)) {
            return;
        }
        this.throwExceptionForUnknownResourceType(resource);
    }

    public void validate(ConfigResource resource, Map<String, String> config) {
        ConfigResource.Type type = resource.type();
        if (ConfigResource.Type.TOPIC.equals(type)) {
            this.validateTopicName(resource.name());
            Properties properties = new Properties();
            ArrayBuffer nullTopicConfigs = new ArrayBuffer();
            config.entrySet().forEach(e -> {
                if (e.getValue() == null) {
                    nullTopicConfigs.$plus$eq(e.getKey());
                    return;
                }
                properties.setProperty((String)e.getKey(), (String)e.getValue());
            });
            if (nullTopicConfigs.nonEmpty()) {
                throw new InvalidConfigurationException(new StringBuilder(44).append("Null value not supported for topic configs: ").append(nullTopicConfigs.mkString(",")).toString());
            }
            LogConfig$.MODULE$.validate(properties);
            return;
        }
        if (ConfigResource.Type.BROKER.equals(type)) {
            this.validateBrokerName(resource.name());
            return;
        }
        if (ConfigResource.Type.CLUSTER_LINK.equals(type)) {
            ClusterLinkConfig$.MODULE$.create(config, true);
            return;
        }
        this.throwExceptionForUnknownResourceType(resource);
    }

    public void validateTopicConfigChange(Map<String, String> prevResolvedConfig, Map<String, String> newResolvedConfig) {
        LogConfig curLogConfig = LogConfig$.MODULE$.fromProps(prevResolvedConfig, new Properties());
        LogConfig nextLogConfig = LogConfig$.MODULE$.fromProps(newResolvedConfig, new Properties());
        LogConfig$.MODULE$.validateChange(curLogConfig, nextLogConfig, MetadataVersion.latest(), this.tierFeatureEnabled(), this.tierCleanerFeatureEnabled());
    }

    public ControllerConfigurationValidator(boolean tierFeatureEnabled, boolean tierCleanerFeatureEnabled) {
        this.tierFeatureEnabled = tierFeatureEnabled;
        this.tierCleanerFeatureEnabled = tierCleanerFeatureEnabled;
    }
}

