/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.server.AbstractQuotaChannelManager;
import kafka.server.ActiveTenantsManager;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientSensors;
import kafka.server.ControllerMutationQuota;
import kafka.server.ControllerMutationQuotaManager$;
import kafka.server.PermissiveControllerMutationQuota;
import kafka.server.QuotaType$ControllerMutation$;
import kafka.server.StrictControllerMutationQuota;
import kafka.server.UnboundedControllerMutationQuota$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Eu!\u0002\u000e\u001c\u0011\u0003\u0001c!\u0002\u0012\u001c\u0011\u0003\u0019\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003b\u0002\u0017\u0002\u0005\u0004%\t!\f\u0005\u0007c\u0005\u0001\u000b\u0011\u0002\u0018\t\u000bI\nA\u0011A\u001a\u0007\t\tZ\u0002A\u0012\u0005\t\u0015\u001a\u0011)\u0019!C\u0005\u0017\"AqJ\u0002B\u0001B\u0003%A\n\u0003\u0005=\r\t\u0015\r\u0011\"\u0003Q\u0011!!fA!A!\u0002\u0013\t\u0006\u0002C+\u0007\u0005\u000b\u0007I\u0011\u000b,\t\u0013u3!\u0011!Q\u0001\n]s\u0006\u0002C0\u0007\u0005\u000b\u0007I\u0011\u00021\t\u001114!\u0011!Q\u0001\n\u0005D\u0001\"\u001c\u0004\u0003\u0006\u0004%IA\u001c\u0005\ts\u001a\u0011\t\u0011)A\u0005_\")!F\u0002C\u0001u\"9\u00111\u0001\u0004\u0005R\u0005\u0015\u0001bBA\r\r\u0011\u0005\u00131\u0004\u0005\b\u0003G1A\u0011IA\u0013\u0011\u001d\t9F\u0002C\u0001\u00033Bq!a\u0016\u0007\t\u0003\t)\u0007C\u0004\u0002v\u0019!\t!a\u001e\t\u000f\u0005Ud\u0001\"\u0001\u0002~!9\u0011\u0011\u0011\u0004\u0005\u0002\u0005\r\u0015AH\"p]R\u0014x\u000e\u001c7fe6+H/\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0015\taR$\u0001\u0004tKJ4XM\u001d\u0006\u0002=\u0005)1.\u00194lC\u000e\u0001\u0001CA\u0011\u0002\u001b\u0005Y\"AH\"p]R\u0014x\u000e\u001c7fe6+H/\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s'\t\tA\u0005\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\na$U;pi\u0006\u001cuN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8EK\u001a\fW\u000f\u001c;\u0016\u00039\u0002\"!J\u0018\n\u0005A2#A\u0002#pk\ndW-A\u0010Rk>$\u0018mQ8oiJ|G\u000e\\3s\u001bV$\u0018\r^5p]\u0012+g-Y;mi\u0002\na\u0002\u001e5s_R$H.\u001a+j[\u0016l5\u000f\u0006\u00025oA\u0011Q%N\u0005\u0003m\u0019\u0012A\u0001T8oO\")\u0001(\u0002a\u0001s\u0005\tQ\r\u0005\u0002;\t6\t1H\u0003\u0002={\u00059Q.\u001a;sS\u000e\u001c(B\u0001 @\u0003\u0019\u0019w.\\7p]*\u0011a\u0004\u0011\u0006\u0003\u0003\n\u000ba!\u00199bG\",'\"A\"\u0002\u0007=\u0014x-\u0003\u0002Fw\t9\u0012+^8uCZKw\u000e\\1uS>tW\t_2faRLwN\\\n\u0003\r\u001d\u0003\"!\t%\n\u0005%[\"AE\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\faaY8oM&<W#\u0001'\u0011\u0005\u0005j\u0015B\u0001(\u001c\u0005a\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:D_:4\u0017nZ\u0001\bG>tg-[4!+\u0005\t\u0006C\u0001\u001eS\u0013\t\u00196HA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\nA\u0001^5nKV\tq\u000b\u0005\u0002Y76\t\u0011L\u0003\u0002[{\u0005)Q\u000f^5mg&\u0011A,\u0017\u0002\u0005)&lW-A\u0003uS6,\u0007%\u0003\u0002V\u0011\u0006\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e_\u000b\u0002CB\u0011!-\u001b\b\u0003G\u001e\u0004\"\u0001\u001a\u0014\u000e\u0003\u0015T!AZ\u0010\u0002\rq\u0012xn\u001c;?\u0013\tAg%\u0001\u0004Qe\u0016$WMZ\u0005\u0003U.\u0014aa\u0015;sS:<'B\u00015'\u0003E!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010I\u0001\u000ecV|G/Y\"bY2\u0014\u0017mY6\u0016\u0003=\u00042!\n9s\u0013\t\thE\u0001\u0004PaRLwN\u001c\t\u0003g^l\u0011\u0001\u001e\u0006\u0003kZ\fQ!];pi\u0006T!\u0001H \n\u0005a$(aE\"mS\u0016tG/U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0017AD9v_R\f7)\u00197mE\u0006\u001c7\u000e\t\u000b\bwrlhp`A\u0001!\t\tc\u0001C\u0003K#\u0001\u0007A\nC\u0003=#\u0001\u0007\u0011\u000bC\u0003V#\u0001\u0007q\u000bC\u0003`#\u0001\u0007\u0011\rC\u0003n#\u0001\u0007q.\u0001\u000bdY&,g\u000e\u001e*bi\u0016lU\r\u001e:jG:\u000bW.\u001a\u000b\u0005\u0003\u000f\ty\u0001\u0005\u0003\u0002\n\u0005-Q\"A\u001f\n\u0007\u00055QH\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016Dq!!\u0005\u0013\u0001\u0004\t\u0019\"A\brk>$\u0018-T3ue&\u001cG+Y4t!\u0015\u0011\u0017QC1b\u0013\r\t9b\u001b\u0002\u0004\u001b\u0006\u0004\u0018a\u00052bG.\u0004(/Z:tkJ,WI\\1cY\u0016$WCAA\u000f!\r)\u0013qD\u0005\u0004\u0003C1#a\u0002\"p_2,\u0017M\\\u0001\u001be\u0016\u001cwN\u001d3B]\u0012<U\r\u001e+ie>$H\u000f\\3US6,Wj\u001d\u000b\u000b\u0003O\ti#a\u0013\u0002P\u0005M\u0003cA\u0013\u0002*%\u0019\u00111\u0006\u0014\u0003\u0007%sG\u000fC\u0004\u00020Q\u0001\r!!\r\u0002\u000fM,7o]5p]B!\u00111GA#\u001d\u0011\t)$a\u0010\u000f\t\u0005]\u00121\b\b\u0004I\u0006e\u0012\"\u0001\u0010\n\u0007\u0005uR$A\u0004oKR<xN]6\n\t\u0005\u0005\u00131I\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0015\r\ti$H\u0005\u0005\u0003\u000f\nIEA\u0004TKN\u001c\u0018n\u001c8\u000b\t\u0005\u0005\u00131\t\u0005\u0007\u0003\u001b\"\u0002\u0019A1\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012Da!!\u0015\u0015\u0001\u0004q\u0013!\u0002<bYV,\u0007BBA+)\u0001\u0007A'\u0001\u0004uS6,Wj]\u0001\u0012]\u0016<8\u000b\u001e:jGR\fVo\u001c;b\r>\u0014HCBA.\u0003C\n\u0019\u0007E\u0002\"\u0003;J1!a\u0018\u001c\u0005]\u0019uN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018\rC\u0004\u00020U\u0001\r!!\r\t\r\u00055S\u00031\u0001b)\u0011\tY&a\u001a\t\u000f\u0005%d\u00031\u0001\u0002l\u00059!/Z9vKN$\b\u0003BA7\u0003crA!a\u001c\u0002@5\u0011\u00111I\u0005\u0005\u0003g\nIEA\u0004SKF,Xm\u001d;\u0002+9,w\u000fU3s[&\u001c8/\u001b<f#V|G/\u0019$peR1\u00111LA=\u0003wBq!a\f\u0018\u0001\u0004\t\t\u0004\u0003\u0004\u0002N]\u0001\r!\u0019\u000b\u0005\u00037\ny\bC\u0004\u0002ja\u0001\r!a\u001b\u0002\u00179,w/U;pi\u00064uN\u001d\u000b\u0007\u00037\n))a\"\t\u000f\u0005%\u0014\u00041\u0001\u0002l!9\u0011\u0011R\rA\u0002\u0005-\u0015AE:ue&\u001cGoU5oG\u00164VM]:j_:\u00042!JAG\u0013\r\tyI\n\u0002\u0006'\"|'\u000f\u001e")
public class ControllerMutationQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> quotaCallback;

    public static long throttleTimeMs(QuotaViolationException e) {
        return ControllerMutationQuotaManager$.MODULE$.throttleTimeMs(e);
    }

    public static double QuotaControllerMutationDefault() {
        return ControllerMutationQuotaManager$.MODULE$.QuotaControllerMutationDefault();
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    @Override
    public Time time() {
        return super.time();
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> quotaCallback() {
        return this.quotaCallback;
    }

    @Override
    public MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("mutation-rate", "ControllerMutation", "Tracking mutation-rate per user/client-id", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    @Override
    public boolean backpressureEnabled() {
        return false;
    }

    @Override
    public int recordAndGetThrottleTimeMs(RequestChannel.Session session, String clientId, double value, long timeMs) {
        Sensor quotaSensor = this.getOrCreateQuotaSensors(session, clientId).quotaSensor();
        try {
            synchronized (quotaSensor) {
                quotaSensor.checkQuotas(timeMs);
                quotaSensor.record(value, timeMs, false);
            }
            return 0;
        }
        catch (QuotaViolationException e) {
            int throttleTimeMs = (int)ControllerMutationQuotaManager$.MODULE$.throttleTimeMs(e);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Quota violated for sensor (").append(quotaSensor.name()).append("). Delay time: (").append(throttleTimeMs).append(")").toString());
            return throttleTimeMs;
        }
    }

    public ControllerMutationQuota newStrictQuotaFor(RequestChannel.Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new StrictControllerMutationQuota(this.time(), clientSensors.quotaSensor());
        }
        return UnboundedControllerMutationQuota$.MODULE$;
    }

    public ControllerMutationQuota newStrictQuotaFor(RequestChannel.Request request) {
        return this.newStrictQuotaFor(request.session(), request.header().clientId());
    }

    public ControllerMutationQuota newPermissiveQuotaFor(RequestChannel.Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new PermissiveControllerMutationQuota(this.time(), clientSensors.quotaSensor());
        }
        return UnboundedControllerMutationQuota$.MODULE$;
    }

    public ControllerMutationQuota newPermissiveQuotaFor(RequestChannel.Request request) {
        return this.newPermissiveQuotaFor(request.session(), request.header().clientId());
    }

    public ControllerMutationQuota newQuotaFor(RequestChannel.Request request, short strictSinceVersion) {
        if (request.header().apiVersion() >= strictSinceVersion) {
            return this.newStrictQuotaFor(request);
        }
        return this.newPermissiveQuotaFor(request);
    }

    public ControllerMutationQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> quotaCallback) {
        this.config = config;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.quotaCallback = quotaCallback;
        super(config, metrics, QuotaType$ControllerMutation$.MODULE$, time, threadNamePrefix, quotaCallback, (Option<ActiveTenantsManager>)None$.MODULE$, (Option<AbstractQuotaChannelManager>)None$.MODULE$);
    }
}

