/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.BrokerReconfigurable;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicBackpressure;
import kafka.server.DynamicBalancerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicBrokerLoadConfig;
import kafka.server.DynamicBrokerTagsConfig;
import kafka.server.DynamicClientQuotaCallback;
import kafka.server.DynamicClusterLinkConfig;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicDurabilityAuditConfig;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicLoginManager;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicQuotaConfig;
import kafka.server.DynamicReplicaManagerConfig;
import kafka.server.DynamicThreadPool;
import kafka.server.DynamicTierPartitionStateMetadataSnapshotsConfig;
import kafka.server.DynamicTransactionCoordinator;
import kafka.server.DynamicZkControllerConfig;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.EncryptingPasswordEncoder;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.NoOpPasswordEncoder;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.DelegatingReconfigurable;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.policy.CreateClusterLinkPolicy;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0011es!B/_\u0011\u0003\u0019g!B3_\u0011\u00031\u0007\"B7\u0002\t\u0003q\u0007\u0002C8\u0002\u0005\u0004%\tA\u00189\t\u000f\u0005\r\u0011\u0001)A\u0005c\"A\u0011QA\u0001C\u0002\u0013\u0005\u0001\u000fC\u0004\u0002\b\u0005\u0001\u000b\u0011B9\t\u0013\u0005%\u0011A1A\u0005\n\u0005-\u0001\u0002CA\n\u0003\u0001\u0006I!!\u0004\t\u0011\u0005U\u0011A1A\u0005\nADq!a\u0006\u0002A\u0003%\u0011\u000fC\u0005\u0002\u001a\u0005\u0011\r\u0011\"\u0003\u0002\f!A\u00111D\u0001!\u0002\u0013\ti\u0001C\u0005\u0002\u001e\u0005\u0011\r\u0011\"\u0003\u0002\f!A\u0011qD\u0001!\u0002\u0013\ti\u0001C\u0005\u0002\"\u0005\u0011\r\u0011\"\u0003\u0002\f!A\u00111E\u0001!\u0002\u0013\ti\u0001C\u0005\u0002&\u0005\u0011\r\u0011\"\u0001\u0002(!A\u0011\u0011H\u0001!\u0002\u0013\tI\u0003\u0003\u0005\u0002<\u0005\u0011\r\u0011\"\u0003q\u0011\u001d\ti$\u0001Q\u0001\nED\u0011\"a\u0010\u0002\u0005\u0004%\t!!\u0011\t\u0011\u0005u\u0013\u0001)A\u0005\u0003\u0007Bq!a\u0018\u0002\t\u0003\t\t\u0007C\u0004\u0002\u0002\u0006!\t!a!\t\u000f\u0005u\u0015\u0001\"\u0001\u0002 \"9\u0011\u0011X\u0001\u0005\n\u0005m\u0006bBAa\u0003\u0011%\u00111\u0019\u0005\b\u0003\u000f\fA\u0011BAe\u0011\u001d\ti-\u0001C\u0005\u0003\u001fDq!a5\u0002\t\u0013\t)\u000e\u0003\u0005\u0002Z\u0006!\tAXAn\u0011!\t\t/\u0001C\u0001=\u0006\r\b\u0002CAv\u0003\u0011\u0005a,!<\u0007\u000b\u0015t\u0006!a=\t\u0015\t\u0005!E!b\u0001\n\u0013\u0011\u0019\u0001\u0003\u0006\u0003\f\t\u0012\t\u0011)A\u0005\u0005\u000bAa!\u001c\u0012\u0005\u0002\t5\u0001B\u0003B\nE\t\u0007I\u0011\u00010\u0003\u0016!A!1\u0004\u0012!\u0002\u0013\u00119\u0002\u0003\u0006\u0003\u001e\t\u0012\r\u0011\"\u0001_\u0005+A\u0001Ba\b#A\u0003%!q\u0003\u0005\n\u0005C\u0011#\u0019!C\u0005\u0005GA\u0001Ba\n#A\u0003%!Q\u0005\u0005\n\u0005S\u0011#\u0019!C\u0005\u0005GA\u0001Ba\u000b#A\u0003%!Q\u0005\u0005\r\u0005[\u0011\u0003\u0019!a\u0001\n\u0003q&q\u0006\u0005\r\u0005o\u0011\u0003\u0019!a\u0001\n\u0003q&\u0011\b\u0005\f\u0005\u007f\u0011\u0003\u0019!A!B\u0013\u0011\t\u0004C\u0005\u0003B\t\u0012\r\u0011\"\u0003\u0003D!A!\u0011\f\u0012!\u0002\u0013\u0011)\u0005C\u0005\u0003\\\t\u0012\r\u0011\"\u0003\u0003^!A!q\r\u0012!\u0002\u0013\u0011y\u0006C\u0005\u0003j\t\u0012\r\u0011\"\u0003\u0003l!A!\u0011\u0010\u0012!\u0002\u0013\u0011i\u0007C\u0005\u0003|\t\u0002\r\u0011\"\u0003\u0003\u0004!I!Q\u0010\u0012A\u0002\u0013%!q\u0010\u0005\t\u0005\u0007\u0013\u0003\u0015)\u0003\u0003\u0006!I!Q\u0011\u0012C\u0002\u0013%!q\u0011\u0005\t\u0005+\u0013\u0003\u0015!\u0003\u0003\n\"A!q\u0013\u0012\u0005\u0002y\u0013I\n\u0003\u0005\u0003.\n\"\tA\u0018BX\u0011\u001d\u0011\tL\tC\u0001\u0005gCqAa0#\t\u0003\u0011\t\rC\u0004\u0003H\n\"\tA!3\t\u000f\t5'\u0005\"\u0001\u0003P\"9!1\u001b\u0012\u0005\n\tU\u0007\u0002\u0003BnE\u0011\u0005aLa\u0001\t\u0011\tu'\u0005\"\u0001_\u0005?D\u0001B!:#\t\u0003q&q\u001c\u0005\t\u0005O\u0014C\u0011\u00010\u0003j\"Q!Q \u0012\u0012\u0002\u0013\u0005aLa@\t\u0011\rU!\u0005\"\u0001_\u0007/A!b!\b##\u0003%\tA\u0018B\u0000\u0011!\u0019yB\tC\u0001=\u000e\u0005\u0002bBB\u0014E\u0011%1\u0011\u0006\u0005\b\u0007{\u0011C\u0011BB \u0011!\u0019\tE\tC\u0001=\u000e\r\u0003\u0002CB&E\u0011\u0005al!\u0014\t\u000f\rM#\u0005\"\u0003\u0004V!911\r\u0012\u0005\n\r\u0015\u0004\u0002CB7E\u0011\u0005ala\u001c\t\u000f\rU$\u0005\"\u0003\u0004x!A1Q\u0010\u0012\u0005\u0002y\u001by\bC\u0004\u0004&\n\"Iaa*\t\u000f\rM'\u0005\"\u0003\u0004V\"A11\u001c\u0012\u0005\u0002y\u001bi\u000eC\u0004\u0004b\n\"Iaa9\t\u0013\rE(%%A\u0005\n\t}\bbBBzE\u0011%1Q\u001f\u0005\b\t\u0007\u0011C\u0011\u0002C\u0003\u0011\u001d!\u0019B\tC\u0005\t+Aq\u0001b\u000f#\t\u0013!i$A\nEs:\fW.[2Ce>\\WM]\"p]\u001aLwM\u0003\u0002`A\u000611/\u001a:wKJT\u0011!Y\u0001\u0006W\u000647.Y\u0002\u0001!\t!\u0017!D\u0001_\u0005M!\u0015P\\1nS\u000e\u0014%o\\6fe\u000e{gNZ5h'\t\tq\r\u0005\u0002iW6\t\u0011NC\u0001k\u0003\u0015\u00198-\u00197b\u0013\ta\u0017N\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\fa\u0003R=oC6L7mU3dkJLG/_\"p]\u001aLwm]\u000b\u0002cB\u0019!o^=\u000e\u0003MT!\u0001^;\u0002\u000f5,H/\u00192mK*\u0011a/[\u0001\u000bG>dG.Z2uS>t\u0017B\u0001=t\u0005\r\u0019V\r\u001e\t\u0003u~l\u0011a\u001f\u0006\u0003yv\fA\u0001\\1oO*\ta0\u0001\u0003kCZ\f\u0017bAA\u0001w\n11\u000b\u001e:j]\u001e\fq\u0003R=oC6L7mU3dkJLG/_\"p]\u001aLwm\u001d\u0011\u0002#\u0005cG\u000eR=oC6L7mQ8oM&<7/\u0001\nBY2$\u0015P\\1nS\u000e\u001cuN\u001c4jON\u0004\u0013aG\"mkN$XM\u001d'fm\u0016dG*[:uK:,'oQ8oM&<7/\u0006\u0002\u0002\u000eA)\u0011qBA\ts6\tQ/\u0003\u0002yk\u0006a2\t\\;ti\u0016\u0014H*\u001a<fY2K7\u000f^3oKJ\u001cuN\u001c4jON\u0004\u0013\u0001\u0005)fe\n\u0013xn[3s\u0007>tg-[4t\u0003E\u0001VM\u001d\"s_.,'oQ8oM&<7\u000fI\u0001\u0019\t\u00164\u0017-\u001e7u\u001f:d\u0017P\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\u0018!\u0007#fM\u0006,H\u000e^(oYf\u0014%o\\6fe\u000e{gNZ5hg\u0002\n\u0001\u0004T5ti\u0016tWM]'fG\"\fg.[:n\u0007>tg-[4t\u0003ea\u0015n\u001d;f]\u0016\u0014X*Z2iC:L7/\\\"p]\u001aLwm\u001d\u0011\u0002+I+Gn\\1eC\ndWMR5mK\u000e{gNZ5hg\u00061\"+\u001a7pC\u0012\f'\r\\3GS2,7i\u001c8gS\u001e\u001c\b%A\nMSN$XM\\3s\u0007>tg-[4SK\u001e,\u00070\u0006\u0002\u0002*A!\u00111FA\u001b\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012\u0001C7bi\u000eD\u0017N\\4\u000b\u0007\u0005M\u0012.\u0001\u0003vi&d\u0017\u0002BA\u001c\u0003[\u0011QAU3hKb\fA\u0003T5ti\u0016tWM]\"p]\u001aLwMU3hKb\u0004\u0013A\u0006#z]\u0006l\u0017n\u0019)bgN<xN\u001d3D_:4\u0017nZ:\u0002/\u0011Kh.Y7jGB\u000b7o]<pe\u0012\u001cuN\u001c4jON\u0004\u0013!E*fGV\u0014\u0018\u000e^=D_:4\u0017n\u001a#fMV\u0011\u00111\t\t\u0005\u0003\u000b\nI&\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003\u0019\u0019wN\u001c4jO*!\u0011QJA(\u0003\u0019\u0019w.\\7p]*\u0019\u0011-!\u0015\u000b\t\u0005M\u0013QK\u0001\u0007CB\f7\r[3\u000b\u0005\u0005]\u0013aA8sO&!\u00111LA$\u0005%\u0019uN\u001c4jO\u0012+g-\u0001\nTK\u000e,(/\u001b;z\u0007>tg-[4EK\u001a\u0004\u0013\u0001E5t!\u0006\u001c8o^8sI\u000e{gNZ5h)\u0011\t\u0019'!\u001b\u0011\u0007!\f)'C\u0002\u0002h%\u0014qAQ8pY\u0016\fg\u000eC\u0004\u0002l]\u0001\r!!\u001c\u0002\t9\fW.\u001a\t\u0005\u0003_\niH\u0004\u0003\u0002r\u0005e\u0004cAA:S6\u0011\u0011Q\u000f\u0006\u0004\u0003o\u0012\u0017A\u0002\u001fs_>$h(C\u0002\u0002|%\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u0001\u0003\u007fR1!a\u001fj\u0003Q\u0011'o\\6fe\u000e{gNZ5h'ftwN\\=ngR1\u0011QQAL\u00033\u0003b!a\"\u0002\u0012\u00065d\u0002BAE\u0003\u001bsA!a\u001d\u0002\f&\t!.C\u0002\u0002\u0010&\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0014\u0006U%\u0001\u0002'jgRT1!a$j\u0011\u001d\tY\u0007\u0007a\u0001\u0003[Bq!a'\u0019\u0001\u0004\t\u0019'A\u000bnCR\u001c\u0007\u000eT5ti\u0016tWM](wKJ\u0014\u0018\u000eZ3\u0002\u001fY\fG.\u001b3bi\u0016\u001cuN\u001c4jON$b!!)\u0002(\u0006U\u0006c\u00015\u0002$&\u0019\u0011QU5\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003SK\u0002\u0019AAV\u0003\u0015\u0001(o\u001c9t!\u0011\ti+!-\u000e\u0005\u0005=&bAA\u001a{&!\u00111WAX\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0003oK\u0002\u0019AA2\u0003=\u0001XM\u001d\"s_.,'oQ8oM&<\u0017\u0001\u00059fe\n\u0013xn[3s\u0007>tg-[4t)\u0011\ti,a0\u0011\r\u0005=\u0011\u0011CA7\u0011\u001d\tIK\u0007a\u0001\u0003W\u000b\u0001\u0004Z3gCVdGo\u00148ms\n\u0013xn[3s\u0007>tg-[4t)\u0011\ti,!2\t\u000f\u0005%6\u00041\u0001\u0002,\u0006\tbn\u001c8Es:\fW.[2D_:4\u0017nZ:\u0015\t\u0005u\u00161\u001a\u0005\b\u0003Sc\u0002\u0019AAV\u0003\u0011\u001aXmY;sSRL8i\u001c8gS\u001e\u001cx+\u001b;i_V$H*[:uK:,'\u000f\u0015:fM&DH\u0003BA_\u0003#Dq!!+\u001e\u0001\u0004\tY+A\nwC2LG-\u0019;f\u0007>tg-[4UsB,7\u000f\u0006\u0003\u0002\"\u0006]\u0007bBAU=\u0001\u0007\u00111V\u0001\u0012C\u0012$G)\u001f8b[&\u001c7i\u001c8gS\u001e\u001cH\u0003BAQ\u0003;Dq!a8 \u0001\u0004\t\u0019%A\u0005d_:4\u0017n\u001a#fM\u0006AB-\u001f8b[&\u001c7i\u001c8gS\u001e,\u0006\u000fZ1uK6{G-Z:\u0016\u0005\u0005\u0015\b\u0003CAW\u0003O\fi'!\u001c\n\t\u0005%\u0018q\u0016\u0002\u0004\u001b\u0006\u0004\u0018A\u0006:fg>dg/\u001a,be&\f'\r\\3D_:4\u0017nZ:\u0015\t\u0005-\u0016q\u001e\u0005\b\u0003c\f\u0003\u0019AAV\u00035\u0001(o\u001c9t\u001fJLw-\u001b8bYN!!eZA{!\u0011\t90!@\u000e\u0005\u0005e(bAA~A\u0006)Q\u000f^5mg&!\u0011q`A}\u0005\u001daunZ4j]\u001e\f1b[1gW\u0006\u001cuN\u001c4jOV\u0011!Q\u0001\t\u0004I\n\u001d\u0011b\u0001B\u0005=\nY1*\u00194lC\u000e{gNZ5h\u00031Y\u0017MZ6b\u0007>tg-[4!)\u0011\u0011yA!\u0005\u0011\u0005\u0011\u0014\u0003b\u0002B\u0001K\u0001\u0007!QA\u0001\u0014gR\fG/[2Ce>\\WM]\"p]\u001aLwm]\u000b\u0003\u0005/\u0001RA\u001dB\rsfL1!!;t\u0003Q\u0019H/\u0019;jG\n\u0013xn[3s\u0007>tg-[4tA\u0005!2\u000f^1uS\u000e$UMZ1vYR\u001cuN\u001c4jON\fQc\u001d;bi&\u001cG)\u001a4bk2$8i\u001c8gS\u001e\u001c\b%\u0001\u000bes:\fW.[2Ce>\\WM]\"p]\u001aLwm]\u000b\u0003\u0005K\u0001rA\u001dB\r\u0003[\ni'A\u000bes:\fW.[2Ce>\\WM]\"p]\u001aLwm\u001d\u0011\u0002+\u0011Lh.Y7jG\u0012+g-Y;mi\u000e{gNZ5hg\u00061B-\u001f8b[&\u001cG)\u001a4bk2$8i\u001c8gS\u001e\u001c\b%A\nes:\fW.[2M_\u001eLg.T1oC\u001e,'/\u0006\u0002\u00032A\u0019AMa\r\n\u0007\tUbLA\nEs:\fW.[2M_\u001eLg.T1oC\u001e,'/A\fes:\fW.[2M_\u001eLg.T1oC\u001e,'o\u0018\u0013fcR!\u0011\u0011\u0015B\u001e\u0011%\u0011idLA\u0001\u0002\u0004\u0011\t$A\u0002yIE\nA\u0003Z=oC6L7\rT8hS:l\u0015M\\1hKJ\u0004\u0013a\u0004:fG>tg-[4ve\u0006\u0014G.Z:\u0016\u0005\t\u0015\u0003C\u0002B$\u0005\u001b\u0012\t&\u0004\u0002\u0003J)!!1JAX\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0005\u001f\u0012IE\u0001\u000bD_BLxJ\\,sSR,\u0017I\u001d:bs2K7\u000f\u001e\t\u0005\u0005'\u0012)&\u0004\u0002\u0002L%!!qKA&\u00059\u0011VmY8oM&<WO]1cY\u0016\f\u0001C]3d_:4\u0017nZ;sC\ndWm\u001d\u0011\u0002+\t\u0014xn[3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197fgV\u0011!q\f\t\u0007\u0005\u000f\u0012iE!\u0019\u0011\u0007\u0011\u0014\u0019'C\u0002\u0003fy\u0013AC\u0011:pW\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,\u0017A\u00062s_.,'OU3d_:4\u0017nZ;sC\ndWm\u001d\u0011\u0002\t1|7m[\u000b\u0003\u0005[\u0002BAa\u001c\u0003v5\u0011!\u0011\u000f\u0006\u0005\u0005g\u0012I%A\u0003m_\u000e\\7/\u0003\u0003\u0003x\tE$A\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\u0002\u000b1|7m\u001b\u0011\u0002\u001b\r,(O]3oi\u000e{gNZ5h\u0003E\u0019WO\u001d:f]R\u001cuN\u001c4jO~#S-\u001d\u000b\u0005\u0003C\u0013\t\tC\u0005\u0003>a\n\t\u00111\u0001\u0003\u0006\u0005q1-\u001e:sK:$8i\u001c8gS\u001e\u0004\u0013\u0001\b3z]\u0006l\u0017nY\"p]\u001aLw\rU1tg^|'\u000fZ#oG>$WM]\u000b\u0003\u0005\u0013\u0003R\u0001\u001bBF\u0005\u001fK1A!$j\u0005\u0019y\u0005\u000f^5p]B!\u0011q\u001fBI\u0013\u0011\u0011\u0019*!?\u0003\u001fA\u000b7o]<pe\u0012,enY8eKJ\fQ\u0004Z=oC6L7mQ8oM&<\u0007+Y:to>\u0014H-\u00128d_\u0012,'\u000fI\u0001\u000bS:LG/[1mSj,G\u0003BAQ\u00057CqA!(=\u0001\u0004\u0011y*A\u0006{W\u000ec\u0017.\u001a8u\u001fB$\b#\u00025\u0003\f\n\u0005\u0006\u0003\u0002BR\u0005Sk!A!*\u000b\u0007\t\u001d\u0006-\u0001\u0002{W&!!1\u0016BS\u00055Y\u0015MZ6b5.\u001cE.[3oi\u0006)1\r\\3beR\u0011\u0011\u0011U\u0001\u0013C\u0012$'+Z2p]\u001aLw-\u001e:bE2,7\u000f\u0006\u0003\u0002\"\nU\u0006b\u0002B\\}\u0001\u0007!\u0011X\u0001\fW\u000647.Y*feZ,'\u000fE\u0002e\u0005wK1A!0_\u0005-Y\u0015MZ6b\u0005J|7.\u001a:\u0002#\u0005$GMU3d_:4\u0017nZ;sC\ndW\r\u0006\u0003\u0002\"\n\r\u0007b\u0002Bc\u007f\u0001\u0007!\u0011K\u0001\u000fe\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0003]\tG\r\u001a\"s_.,'OU3d_:4\u0017nZ;sC\ndW\r\u0006\u0003\u0002\"\n-\u0007b\u0002Bc\u0001\u0002\u0007!\u0011M\u0001\u0015e\u0016lwN^3SK\u000e|gNZ5hkJ\f'\r\\3\u0015\t\u0005\u0005&\u0011\u001b\u0005\b\u0005\u000b\f\u0005\u0019\u0001B)\u0003m1XM]5gsJ+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgR!\u0011\u0011\u0015Bl\u0011\u001d\u0011IN\u0011a\u0001\u0003{\u000b1bY8oM&<g*Y7fg\u0006\u00112-\u001e:sK:$8*\u00194lC\u000e{gNZ5h\u0003m\u0019WO\u001d:f]R$\u0015P\\1nS\u000e\u0014%o\\6fe\u000e{gNZ5hgV\u0011!\u0011\u001d\t\t\u0003\u001f\u0011\u0019/!\u001c\u0002n%\u0019\u0011\u0011^;\u00029\r,(O]3oi\u0012Kh.Y7jG\u0012+g-Y;mi\u000e{gNZ5hg\u0006\u0011R\u000f\u001d3bi\u0016\u0014%o\\6fe\u000e{gNZ5h)!\t\tKa;\u0003v\ne\bb\u0002Bw\r\u0002\u0007!q^\u0001\tEJ|7.\u001a:JIB\u0019\u0001N!=\n\u0007\tM\u0018NA\u0002J]RDqAa>G\u0001\u0004\tY+A\bqKJ\u001c\u0018n\u001d;f]R\u0004&o\u001c9t\u0011%\u0011YP\u0012I\u0001\u0002\u0004\t\u0019'A\u0003e_2{w-\u0001\u000fva\u0012\fG/\u001a\"s_.,'oQ8oM&<G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r\u0005!\u0006BA2\u0007\u0007Y#a!\u0002\u0011\t\r\u001d1\u0011C\u0007\u0003\u0007\u0013QAaa\u0003\u0004\u000e\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007\u001fI\u0017AC1o]>$\u0018\r^5p]&!11CB\u0005\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0014kB$\u0017\r^3EK\u001a\fW\u000f\u001c;D_:4\u0017n\u001a\u000b\u0007\u0003C\u001bIba\u0007\t\u000f\t]\b\n1\u0001\u0002,\"I!1 %\u0011\u0002\u0003\u0007\u00111M\u0001\u001ekB$\u0017\r^3EK\u001a\fW\u000f\u001c;D_:4\u0017n\u001a\u0013eK\u001a\fW\u000f\u001c;%e\u0005)#/\u001a7pC\u0012,\u0006\u000fZ1uK\u00124\u0015\u000e\\3t/&$\bn\\;u\u0007>tg-[4DQ\u0006tw-\u001a\u000b\u0005\u0003C\u001b\u0019\u0003C\u0004\u0004&)\u0003\r!a+\u0002\u00119,w\u000f\u0015:paN\f!$\\1zE\u0016\u001c%/Z1uKB\u000b7o]<pe\u0012,enY8eKJ$BA!#\u0004,!91QF&A\u0002\r=\u0012AB:fGJ,G\u000fE\u0003i\u0005\u0017\u001b\t\u0004\u0005\u0003\u00044\reRBAB\u001b\u0015\u0011\u00199$a\u0012\u0002\u000bQL\b/Z:\n\t\rm2Q\u0007\u0002\t!\u0006\u001c8o^8sI\u0006y\u0001/Y:to>\u0014H-\u00128d_\u0012,'/\u0006\u0002\u0003\u0010\u0006\tBo\u001c)feNL7\u000f^3oiB\u0013x\u000e]:\u0015\r\u0005-6QIB%\u0011\u001d\u00199%\u0014a\u0001\u0003W\u000b1bY8oM&<\u0007K]8qg\"9\u0011qW'A\u0002\u0005\r\u0014a\u00054s_6\u0004VM]:jgR,g\u000e\u001e)s_B\u001cHCBAV\u0007\u001f\u001a\t\u0006C\u0004\u0003x:\u0003\r!a+\t\u000f\u0005]f\n1\u0001\u0002d\u00051R.Y=cKJ+WI\\2pI\u0016\u0004\u0016m]:x_J$7\u000f\u0006\u0004\u0002,\u000e]3\u0011\f\u0005\b\u0005o|\u0005\u0019AAV\u0011\u001d\u0019Yf\u0014a\u0001\u0007;\nQ\"\u00193nS:T6n\u00117jK:$\b\u0003\u0002BR\u0007?JAa!\u0019\u0003&\ni\u0011\tZ7j]j[7\t\\5f]R\f1C^1mS\u0012\fG/\u001a3LC\u001a\\\u0017\r\u0015:paN$bA!9\u0004h\r-\u0004bBB5!\u0002\u0007\u00111V\u0001\u000eaJ|\u0007o](wKJ\u0014\u0018\u000eZ3\t\u000f\u0005]\u0006\u000b1\u0001\u0002d\u0005Aa/\u00197jI\u0006$X\r\u0006\u0004\u0002\"\u000eE41\u000f\u0005\b\u0003S\u000b\u0006\u0019AAV\u0011\u001d\t9,\u0015a\u0001\u0003G\nAC]3n_Z,\u0017J\u001c<bY&$7i\u001c8gS\u001e\u001cHCBAQ\u0007s\u001aY\bC\u0004\u0002*J\u0003\r!a+\t\u000f\u0005]&\u000b1\u0001\u0002d\u0005\u0001R.Y=cKJ+7m\u001c8gS\u001e,(/\u001a\u000b\t\u0003C\u001b\tia!\u0004\b\"9!QY*A\u0002\tE\u0003bBBC'\u0002\u0007!QA\u0001\n_2$7i\u001c8gS\u001eDqa!#T\u0001\u0004\u0019Y)A\u0005oK^\u001cuN\u001c4jOB\"1QRBJ!!\ti+a:\u0002n\r=\u0005\u0003BBI\u0007'c\u0001\u0001\u0002\u0007\u0004\u0016\u000e\u001d\u0015\u0011!A\u0001\u0006\u0003\u00199JA\u0002`IE\nBa!'\u0004 B\u0019\u0001na'\n\u0007\ru\u0015NA\u0004O_RD\u0017N\\4\u0011\u0007!\u001c\t+C\u0002\u0004$&\u00141!\u00118z\u00039)\b\u000fZ1uK\u0012\u001cuN\u001c4jON$ba!+\u0004:\u000e\u0015\u0007c\u00025\u0004,\u000e=\u0016QX\u0005\u0004\u0007[K'A\u0002+va2,'\u0007\r\u0003\u00042\u000eU\u0006c\u0002:\u0003\u001a\u0005541\u0017\t\u0005\u0007#\u001b)\fB\u0006\u00048R\u000b\t\u0011!A\u0003\u0002\r]%aA0%i!91Q\u0005+A\u0002\rm\u0006\u0007BB_\u0007\u0003\u0004\u0002\"!,\u0002h\u000654q\u0018\t\u0005\u0007#\u001b\t\r\u0002\u0007\u0004D\u000ee\u0016\u0011!A\u0001\u0006\u0003\u00199JA\u0002`IIBqaa2U\u0001\u0004\u0019I-\u0001\u0007dkJ\u0014XM\u001c;Qe>\u00048\u000f\r\u0003\u0004L\u000e=\u0007\u0003CAW\u0003O\fig!4\u0011\t\rE5q\u001a\u0003\r\u0007#\u001c)-!A\u0001\u0002\u000b\u00051q\u0013\u0002\u0004?\u0012\u001a\u0014!D8wKJ\u0014\u0018\u000eZ3Qe>\u00048\u000f\u0006\u0004\u0002\"\u000e]7\u0011\u001c\u0005\b\u0003S+\u0006\u0019\u0001B\u0013\u0011\u001d\u0019I'\u0016a\u0001\u0005K\t1#\u001e9eCR,7)\u001e:sK:$8i\u001c8gS\u001e$B!!)\u0004`\"9!1 ,A\u0002\u0005\r\u0014A\u00069s_\u000e,7o\u001d*fG>tg-[4ve\u0006$\u0018n\u001c8\u0015\u0011\r\u00158\u0011^Bv\u0007_\u0004r\u0001[BV\u0005\u000b\u00199\u000f\u0005\u0004\u0002\b\u0006E%\u0011\r\u0005\b\u0007K9\u0006\u0019\u0001Bq\u0011\u001d\u0019io\u0016a\u0001\u0003G\nAB^1mS\u0012\fG/Z(oYfD\u0011Ba?X!\u0003\u0005\r!a\u0019\u0002AA\u0014xnY3tgJ+7m\u001c8gS\u001e,(/\u0019;j_:$C-\u001a4bk2$HeM\u0001\u001bEJ|7.\u001a:OK\u0016$7OU3d_:4\u0017nZ;sCRLwN\u001c\u000b\t\u0003G\u001a9pa?\u0004\u0000\"91\u0011`-A\u0002\t\u0005\u0014\u0001\u00062s_.,'OU3d_:4\u0017nZ;sC\ndW\rC\u0004\u0004~f\u0003\r!!0\u0002\u0017U\u0004H-\u0019;fI.+\u0017p\u001d\u0005\b\t\u0003I\u0006\u0019AA_\u0003-!W\r\\3uK\u0012\\U-_:\u0002)9,W\rZ:SK\u000e|gNZ5hkJ\fG/[8o)!\t\u0019\u0007b\u0002\u0005\u0010\u0011E\u0001b\u0002C\u00055\u0002\u0007A1B\u0001\u0016e\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t!\u0019\ti\u000b\"\u0004\u0002n%\u0019\u00010a,\t\u000f\ru(\f1\u0001\u0002>\"9A\u0011\u0001.A\u0002\u0005u\u0016!\b9s_\u000e,7o\u001d'jgR,g.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\u0015\u0019\u0005\u0005Fq\u0003C\u0014\tS!)\u0004b\u000e\t\u000f\u0011e1\f1\u0001\u0005\u001c\u00051B.[:uK:,'OU3d_:4\u0017nZ;sC\ndW\r\u0005\u0003\u0005\u001e\u0011\rRB\u0001C\u0010\u0015\u0011!\t#a\u0013\u0002\u000f9,Go^8sW&!AQ\u0005C\u0010\u0005Ya\u0015n\u001d;f]\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,\u0007bBBE7\u0002\u0007!Q\u0001\u0005\b\tWY\u0006\u0019\u0001C\u0017\u00035\u0019Wo\u001d;p[\u000e{gNZ5hgBA\u0011QVAt\u0003[\"y\u0003E\u0002{\tcI1\u0001b\r|\u0005\u0019y%M[3di\"91Q^.A\u0002\u0005\r\u0004b\u0002C\u001d7\u0002\u0007\u00111M\u0001\u000be\u0016dw.\u00193P]2L\u0018!\u00069s_\u000e,7o\u001d*fG>tg-[4ve\u0006\u0014G.\u001a\u000b\r\u0003C#y\u0004\"\u0011\u0005F\u0011MCq\u000b\u0005\b\u0005\u000bd\u0006\u0019\u0001B)\u0011\u001d!\u0019\u0005\u0018a\u0001\u0003{\u000b!#\u001e9eCR,GmQ8oM&<g*Y7fg\"9Aq\t/A\u0002\u0011%\u0013!D1mY:+woQ8oM&<7\u000f\r\u0003\u0005L\u0011=\u0003\u0003CAW\u0003O\fi\u0007\"\u0014\u0011\t\rEEq\n\u0003\r\t#\")%!A\u0001\u0002\u000b\u00051q\u0013\u0002\u0004?\u0012*\u0004b\u0002C+9\u0002\u0007AQF\u0001\u0011]\u0016<8)^:u_6\u001cuN\u001c4jONDqa!<]\u0001\u0004\t\u0019\u0007")
public class DynamicBrokerConfig
implements Logging {
    private final KafkaConfig kafkaConfig;
    private final scala.collection.mutable.Map<String, String> staticBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> staticDefaultConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicDefaultConfigs;
    private DynamicLoginManager dynamicLoginManager;
    private final CopyOnWriteArrayList<Reconfigurable> reconfigurables;
    private final CopyOnWriteArrayList<BrokerReconfigurable> brokerReconfigurables;
    private final ReentrantReadWriteLock lock;
    private KafkaConfig currentConfig;
    private final Option<PasswordEncoder> dynamicConfigPasswordEncoder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void validateConfigs(Properties props, boolean perBrokerConfig) {
        DynamicBrokerConfig$.MODULE$.validateConfigs(props, perBrokerConfig);
    }

    public static List<String> brokerConfigSynonyms(String name, boolean matchListenerOverride) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, matchListenerOverride);
    }

    public static boolean isPasswordConfig(String name) {
        return DynamicBrokerConfig$.MODULE$.isPasswordConfig(name);
    }

    public static ConfigDef SecurityConfigDef() {
        return DynamicBrokerConfig$.MODULE$.SecurityConfigDef();
    }

    public static Regex ListenerConfigRegex() {
        return DynamicBrokerConfig$.MODULE$.ListenerConfigRegex();
    }

    public static scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public scala.collection.mutable.Map<String, String> staticBrokerConfigs() {
        return this.staticBrokerConfigs;
    }

    public scala.collection.mutable.Map<String, String> staticDefaultConfigs() {
        return this.staticDefaultConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicBrokerConfigs() {
        return this.dynamicBrokerConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicDefaultConfigs() {
        return this.dynamicDefaultConfigs;
    }

    public DynamicLoginManager dynamicLoginManager() {
        return this.dynamicLoginManager;
    }

    public void dynamicLoginManager_$eq(DynamicLoginManager x$1) {
        this.dynamicLoginManager = x$1;
    }

    private CopyOnWriteArrayList<Reconfigurable> reconfigurables() {
        return this.reconfigurables;
    }

    private CopyOnWriteArrayList<BrokerReconfigurable> brokerReconfigurables() {
        return this.brokerReconfigurables;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private KafkaConfig currentConfig() {
        return this.currentConfig;
    }

    private void currentConfig_$eq(KafkaConfig x$1) {
        this.currentConfig = x$1;
    }

    private Option<PasswordEncoder> dynamicConfigPasswordEncoder() {
        return this.dynamicConfigPasswordEncoder;
    }

    public void initialize(Option<KafkaZkClient> zkClientOpt) {
        this.currentConfig_$eq(new KafkaConfig(this.kafkaConfig().props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$));
        zkClientOpt.foreach((Function1 & Serializable)zkClient -> {
            DynamicBrokerConfig.$anonfun$initialize$1(this, zkClient);
            return BoxedUnit.UNIT;
        });
        this.dynamicLoginManager_$eq(new DynamicLoginManager(this.kafkaConfig()));
    }

    public void clear() {
        this.dynamicBrokerConfigs().clear();
        this.dynamicDefaultConfigs().clear();
        this.reconfigurables().clear();
        this.brokerReconfigurables().clear();
        this.dynamicLoginManager_$eq(null);
    }

    public void addReconfigurables(KafkaBroker kafkaServer) {
        Authorizer authz;
        Option<Authorizer> option = kafkaServer.authorizer();
        if (option instanceof Some && (authz = (Authorizer)((Some)option).value()) instanceof Reconfigurable) {
            this.addReconfigurable((Reconfigurable)authz);
        }
        this.addReconfigurable((Reconfigurable)new DelegatingReconfigurable(() -> kafkaServer.httpServer().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        if (kafkaServer.auditLogProvider() != null) {
            this.addReconfigurable((Reconfigurable)kafkaServer.auditLogProvider());
        }
        this.addReconfigurable((Reconfigurable)kafkaServer.kafkaYammerMetrics());
        this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().brokerId(), kafkaServer.config(), kafkaServer.metrics(), kafkaServer.clusterId(), kafkaServer.socketServer()));
        this.addReconfigurable(new DynamicClientQuotaCallback(kafkaServer));
        if (kafkaServer instanceof KafkaServer) {
            KafkaServer kafkaServer2 = (KafkaServer)kafkaServer;
            kafkaServer2.adminManager().createTopicPolicy().foreach((Function1 & Serializable)x0$1 -> {
                DynamicBrokerConfig.$anonfun$addReconfigurables$2(this, x0$1);
                return BoxedUnit.UNIT;
            });
            if (kafkaServer2.clusterLinkManager() != null) {
                kafkaServer2.clusterLinkManager().createClusterLinkPolicy().foreach((Function1 & Serializable)x0$2 -> {
                    DynamicBrokerConfig.$anonfun$addReconfigurables$3(this, x0$2);
                    return BoxedUnit.UNIT;
                });
            }
        }
        this.addBrokerReconfigurable(new DynamicThreadPool(kafkaServer));
        this.addBrokerReconfigurable(kafkaServer.logManager().segmentDeletionThrottlerConfig());
        this.addBrokerReconfigurable(new DynamicLogConfig(kafkaServer.logManager(), kafkaServer));
        this.addBrokerReconfigurable(new DynamicListenerConfig(kafkaServer));
        this.addBrokerReconfigurable(kafkaServer.socketServer());
        this.addBrokerReconfigurable(new DynamicBackpressure(kafkaServer));
        this.addBrokerReconfigurable(new DynamicBalancerConfig(kafkaServer));
        this.addBrokerReconfigurable(new DynamicClusterLinkConfig(kafkaServer));
        this.addBrokerReconfigurable(new DynamicDurabilityAuditConfig(kafkaServer));
        this.addBrokerReconfigurable(new DynamicTierPartitionStateMetadataSnapshotsConfig(kafkaServer));
        this.addBrokerReconfigurable(new DynamicBrokerTagsConfig(kafkaServer));
        kafkaServer.tierDeletedPartitionsCoordinatorOpt().foreach((Function1 & Serializable)reconfigurable -> {
            this.addBrokerReconfigurable(reconfigurable);
            return BoxedUnit.UNIT;
        });
        kafkaServer.tierFetcherOpt().foreach((Function1 & Serializable)reconfigurable -> {
            this.addBrokerReconfigurable(reconfigurable);
            return BoxedUnit.UNIT;
        });
        kafkaServer.tierTasksOpt().foreach((Function1 & Serializable)reconfigurable -> {
            this.addBrokerReconfigurable(reconfigurable);
            return BoxedUnit.UNIT;
        });
        this.addBrokerReconfigurable(new DynamicBrokerLoadConfig(kafkaServer));
        this.addBrokerReconfigurable(new DynamicReplicaManagerConfig(kafkaServer));
        this.addBrokerReconfigurable(new DynamicTransactionCoordinator(kafkaServer.transactionCoordinator()));
        kafkaServer.quotaCoordinatorOpt().foreach((Function1 & Serializable)reconfigurable -> {
            this.addBrokerReconfigurable(reconfigurable);
            return BoxedUnit.UNIT;
        });
        this.addBrokerReconfigurable(new DynamicQuotaConfig(kafkaServer));
        if (kafkaServer instanceof KafkaServer) {
            KafkaServer kafkaServer3 = (KafkaServer)kafkaServer;
            DynamicZkControllerConfig dynamicControllerConfig = new DynamicZkControllerConfig(kafkaServer3.kafkaController(), kafkaServer3.metadataCache());
            this.addBrokerReconfigurable(dynamicControllerConfig);
        }
        if (kafkaServer.brokerHealthManager() != null) {
            this.addBrokerReconfigurable(kafkaServer.brokerHealthManager());
        }
        if (kafkaServer.networkHealthManager() != null) {
            this.addBrokerReconfigurable(kafkaServer.networkHealthManager());
        }
        kafkaServer.backupObjectLifecycleManagerCoordinatorOpt().foreach((Function1 & Serializable)reconfigurable -> {
            this.addBrokerReconfigurable(reconfigurable);
            return BoxedUnit.UNIT;
        });
    }

    public void addReconfigurable(Reconfigurable reconfigurable) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$addReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void addBrokerReconfigurable(BrokerReconfigurable reconfigurable) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$addBrokerReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void removeReconfigurable(Reconfigurable reconfigurable) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$removeReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private void verifyReconfigurableConfigs(Set<String> configNames) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$1(configNames);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public KafkaConfig currentKafkaConfig() {
        KafkaConfig kafkaConfig;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            kafkaConfig = this.currentConfig();
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return kafkaConfig;
    }

    public Map<String, String> currentDynamicBrokerConfigs() {
        scala.collection.mutable.Map map;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicBrokerConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    public Map<String, String> currentDynamicDefaultConfigs() {
        scala.collection.mutable.Map map;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicDefaultConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    public void updateBrokerConfig(int brokerId, Properties persistentProps, boolean doLog) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateBrokerConfig$1(this, persistentProps, doLog, brokerId);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public boolean updateBrokerConfig$default$3() {
        return true;
    }

    public void updateDefaultConfig(Properties persistentProps, boolean doLog) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateDefaultConfig$1(this, persistentProps, doLog);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public boolean updateDefaultConfig$default$2() {
        return true;
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties newProps) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$1(this, newProps);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private Option<PasswordEncoder> maybeCreatePasswordEncoder(Option<Password> secret2) {
        return secret2.map((Function1 & Serializable)secret -> {
            void encrypting_iterations;
            void encrypting_keyLength;
            int n = Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderIterations());
            int n2 = Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderKeyLength());
            String encrypting_cipherAlgorithm = this.kafkaConfig().passwordEncoderCipherAlgorithm();
            Option<String> encrypting_keyFactoryAlgorithm = this.kafkaConfig().passwordEncoderKeyFactoryAlgorithm();
            return new EncryptingPasswordEncoder((Password)secret, encrypting_keyFactoryAlgorithm, encrypting_cipherAlgorithm, (int)encrypting_keyLength, (int)encrypting_iterations);
        });
    }

    private PasswordEncoder passwordEncoder() {
        return (PasswordEncoder)this.dynamicConfigPasswordEncoder().getOrElse((Function0 & Serializable)() -> {
            throw new ConfigException("Password encoder secret not configured");
        });
    }

    public Properties toPersistentProps(Properties configProps, boolean perBrokerConfig) {
        Properties props = (Properties)configProps.clone();
        CollectionConverters$.MODULE$.PropertiesHasAsScala(configProps).asScala().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(name, value) -> {
            DynamicBrokerConfig.$anonfun$toPersistentProps$1(this, perBrokerConfig, props, name, value);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        return props;
    }

    public Properties fromPersistentProps(Properties persistentProps, boolean perBrokerConfig) {
        Properties props = (Properties)persistentProps.clone();
        this.removeInvalidConfigs(props, perBrokerConfig);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Non-dynamic configs configured in ZooKeeper will be ignored", props);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "Security configs can be dynamically updated only using listener prefix, base configs will be ignored", props);
        if (!perBrokerConfig) {
            this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Per-broker configs defined at default cluster level will be ignored", props);
        }
        CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(name, value) -> {
            DynamicBrokerConfig.$anonfun$fromPersistentProps$5(this, props, name, value);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        return props;
    }

    private Properties maybeReEncodePasswords(Properties persistentProps, AdminZkClient adminZkClient) {
        Properties props = (Properties)persistentProps.clone();
        if (CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().keySet().exists((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)))) {
            this.maybeCreatePasswordEncoder(this.kafkaConfig().passwordEncoderOldSecret()).foreach((Function1 & Serializable)passwordDecoder -> {
                DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$2(this, persistentProps, props, adminZkClient, passwordDecoder);
                return BoxedUnit.UNIT;
            });
        }
        return props;
    }

    private Map<String, String> validatedKafkaProps(Properties propsOverride, boolean perBrokerConfig) {
        Properties propsResolved = DynamicBrokerConfig$.MODULE$.resolveVariableConfigs(propsOverride);
        DynamicBrokerConfig$.MODULE$.validateConfigs(propsResolved, perBrokerConfig);
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        if (perBrokerConfig) {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)CollectionConverters$.MODULE$.PropertiesHasAsScala(propsResolved).asScala());
        } else {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)CollectionConverters$.MODULE$.PropertiesHasAsScala(propsResolved).asScala());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        }
        return newProps;
    }

    public void validate(Properties props, boolean perBrokerConfig) {
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$validate$1(this, props, perBrokerConfig);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private void removeInvalidConfigs(Properties props, boolean perBrokerConfig) {
        try {
            DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
            CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala();
            return;
        }
        catch (Exception e) {
            scala.collection.mutable.Map invalidProps = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$removeInvalidConfigs$1(x0$1)));
            invalidProps.keys().foreach((Function1 & Serializable)x$1 -> props.remove(x$1));
            String configSource = perBrokerConfig ? "broker" : "default cluster";
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Dynamic ").append(configSource).append(" config contains invalid values in: ").append(invalidProps.keys()).append(", these configs will be ignored").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public void maybeReconfigure(Reconfigurable reconfigurable, KafkaConfig oldConfig, java.util.Map<String, ?> newConfig) {
        if (CollectionConverters$.MODULE$.SetHasAsScala(reconfigurable.reconfigurableConfigs()).asScala().exists((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$maybeReconfigure$1(oldConfig, newConfig, key)))) {
            reconfigurable.reconfigure(newConfig);
            return;
        }
    }

    private Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> updatedConfigs(java.util.Map<String, ?> newProps, java.util.Map<String, ?> currentProps) {
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(newProps).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$1(currentProps, x0$1)));
        Set deletedKeySet = ((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(currentProps).asScala().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$2(newProps, x0$2)))).keySet();
        return new Tuple2((Object)changeMap, (Object)deletedKeySet);
    }

    private void overrideProps(scala.collection.mutable.Map<String, String> props, scala.collection.mutable.Map<String, String> propsOverride) {
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(k, v) -> {
            DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms((String)k, false).foreach((Function1 & Serializable)key -> props.remove(key));
            return props.put(k, v);
        };
        propsOverride.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    public void updateCurrentConfig(boolean doLog) {
        void var5_5;
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.BrokerSessionUuidProp()), (Object)this.kafkaConfig().brokerSessionUuid())}))));
        KafkaConfig oldConfig = this.currentConfig();
        Tuple2<KafkaConfig, List<BrokerReconfigurable>> tuple2 = this.processReconfiguration((Map<String, String>)newProps, false, doLog);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig newConfig = (KafkaConfig)tuple2._1();
        List brokerReconfigurablesToUpdate = (List)tuple2._2();
        if (var5_5 != this.currentConfig()) {
            void var6_6;
            this.currentConfig_$eq((KafkaConfig)var5_5);
            this.kafkaConfig().updateCurrentConfig((KafkaConfig)var5_5);
            var6_6.foreach(arg_0 -> DynamicBrokerConfig.$anonfun$updateCurrentConfig$1$adapted(oldConfig, (KafkaConfig)var5_5, arg_0));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<KafkaConfig, List<BrokerReconfigurable>> processReconfiguration(Map<String, String> newProps, boolean validateOnly, boolean doLog) {
        void var7_7;
        void var6_6;
        KafkaConfig newConfig = new KafkaConfig(CollectionConverters$.MODULE$.MapHasAsJava(newProps).asJava(), doLog, (Option<DynamicBrokerConfig>)None$.MODULE$);
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newConfig.originalsFromThisConfig(), this.currentConfig().originals());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeySet = (Set)tuple2._2();
        if (var6_6.nonEmpty() || var7_7.nonEmpty()) {
            try {
                Option$.MODULE$.apply((Object)this.dynamicLoginManager()).foreach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$1$adapted(this, (scala.collection.mutable.Map)var6_6, (Set)var7_7, newConfig, validateOnly, arg_0));
                HashMap<String, Object> customConfigs = new HashMap<String, Object>(newConfig.originalsFromThisConfig());
                newConfig.valuesFromThisConfig().keySet().forEach(k -> customConfigs.remove(k));
                this.reconfigurables().forEach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$3(this, newConfig, customConfigs, validateOnly, (scala.collection.mutable.Map)var6_6, (Set)var7_7, arg_0));
                Buffer brokerReconfigurablesToUpdate = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.brokerReconfigurables().forEach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$4(this, (scala.collection.mutable.Map)var6_6, (Set)var7_7, newConfig, validateOnly, brokerReconfigurablesToUpdate, arg_0));
                return new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate.toList());
            }
            catch (Exception e) {
                if (!validateOnly) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Failed to update broker configuration with configs : ").append(ConfigUtils.configMapToRedactedString(newConfig.originalsFromThisConfig(), (ConfigDef)KafkaConfig$.MODULE$.configDef())).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
                throw new ConfigException("Invalid dynamic configuration", (Object)e);
            }
        }
        return new Tuple2((Object)this.currentConfig(), (Object)package$.MODULE$.List().empty());
    }

    private boolean processReconfiguration$default$3() {
        return false;
    }

    private boolean brokerNeedsReconfiguration(BrokerReconfigurable brokerReconfigurable, Set<String> updatedKeys, Set<String> deletedKeys) {
        if (brokerReconfigurable instanceof DynamicBrokerTagsConfig) {
            return updatedKeys.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.startsWith(KafkaConfig$.MODULE$.BrokerTagsProp()))) || deletedKeys.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.startsWith(KafkaConfig$.MODULE$.BrokerTagsProp())));
        }
        if (brokerReconfigurable instanceof DynamicLoginManager) {
            return true;
        }
        return this.needsReconfiguration(CollectionConverters$.MODULE$.SetHasAsJava(brokerReconfigurable.reconfigurableConfigs()).asJava(), updatedKeys, deletedKeys);
    }

    private boolean needsReconfiguration(java.util.Set<String> reconfigurableConfigs, Set<String> updatedKeys, Set<String> deletedKeys) {
        return CollectionConverters$.MODULE$.SetHasAsScala(reconfigurableConfigs).asScala().intersect(updatedKeys).nonEmpty() || CollectionConverters$.MODULE$.SetHasAsScala(reconfigurableConfigs).asScala().intersect(deletedKeys).nonEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private void processListenerReconfigurable(ListenerReconfigurable listenerReconfigurable, KafkaConfig newConfig, java.util.Map<String, Object> customConfigs, boolean validateOnly, boolean reloadOnly) {
        void var11_11;
        void var10_10;
        ListenerName listenerName = listenerReconfigurable.listenerName();
        java.util.Map<String, Object> oldValues = this.currentConfig().valuesWithPrefixOverride(listenerName.configPrefix());
        java.util.Map<String, Object> newValues = newConfig.valuesFromThisConfigWithPrefixOverride(listenerName.configPrefix());
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newValues, oldValues);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeys = (Set)tuple2._2();
        Set updatedKeys = var10_10.keySet();
        boolean configsChanged = this.needsReconfiguration(listenerReconfigurable.reconfigurableConfigs(), (Set<String>)updatedKeys, (Set<String>)var11_11);
        if (reloadOnly != configsChanged) {
            this.processReconfigurable((Reconfigurable)listenerReconfigurable, (Set<String>)updatedKeys, newValues, customConfigs, validateOnly);
            return;
        }
    }

    private void processReconfigurable(Reconfigurable reconfigurable, Set<String> updatedConfigNames, java.util.Map<String, ?> allNewConfigs, java.util.Map<String, Object> newCustomConfigs, boolean validateOnly) {
        HashMap<String, Object> newConfigs = new HashMap<String, Object>();
        allNewConfigs.forEach((k, v) -> newConfigs.put((String)k, v));
        newConfigs.putAll(newCustomConfigs);
        try {
            reconfigurable.validateReconfiguration(newConfigs);
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            throw new ConfigException(new StringBuilder(58).append("Validation of dynamic config update of ").append(updatedConfigNames).append(" failed with class ").append(reconfigurable.getClass()).toString());
        }
        if (!validateOnly) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Reconfiguring ").append(reconfigurable).append(", updated configs: ").append(updatedConfigNames).append(" ").append("custom configs: ").append(ConfigUtils.configMapToRedactedString((java.util.Map)newCustomConfigs, (ConfigDef)KafkaConfig$.MODULE$.configDef())).toString());
            reconfigurable.reconfigure(newConfigs);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$initialize$1(DynamicBrokerConfig $this, KafkaZkClient zkClient) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        $this.updateDefaultConfig(adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ConfigEntityName$.MODULE$.Default()), false);
        Properties props = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString($this.kafkaConfig().brokerId()));
        Properties brokerConfig = $this.maybeReEncodePasswords(props, adminZkClient);
        $this.updateBrokerConfig($this.kafkaConfig().brokerId(), brokerConfig, $this.updateBrokerConfig$default$3());
    }

    public static final /* synthetic */ void $anonfun$addReconfigurables$2(DynamicBrokerConfig $this, CreateTopicPolicy x0$1) {
        if (x0$1 instanceof Reconfigurable) {
            $this.addReconfigurable((Reconfigurable)x0$1);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$addReconfigurables$3(DynamicBrokerConfig $this, CreateClusterLinkPolicy x0$2) {
        if (x0$2 instanceof Reconfigurable) {
            $this.addReconfigurable((Reconfigurable)x0$2);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$addReconfigurable$1(DynamicBrokerConfig $this, Reconfigurable reconfigurable$1) {
        $this.verifyReconfigurableConfigs((Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(reconfigurable$1.reconfigurableConfigs()).asScala());
        return $this.reconfigurables().add(reconfigurable$1);
    }

    public static final /* synthetic */ boolean $anonfun$addBrokerReconfigurable$1(DynamicBrokerConfig $this, BrokerReconfigurable reconfigurable$2) {
        $this.verifyReconfigurableConfigs(reconfigurable$2.reconfigurableConfigs());
        return $this.brokerReconfigurables().add(reconfigurable$2);
    }

    public static final /* synthetic */ boolean $anonfun$removeReconfigurable$1(DynamicBrokerConfig $this, Reconfigurable reconfigurable$3) {
        return $this.reconfigurables().remove(reconfigurable$3);
    }

    public static final /* synthetic */ boolean $anonfun$verifyReconfigurableConfigs$2(String elem) {
        return DynamicConfig$Broker$.MODULE$.nonDynamicProps().contains((Object)elem);
    }

    public static final /* synthetic */ void $anonfun$verifyReconfigurableConfigs$1(Set configNames$1) {
        Set nonDynamic = (Set)configNames$1.filter((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$2(elem)));
        Predef$.MODULE$.require(nonDynamic.isEmpty(), (Function0 & Serializable)() -> new StringBuilder(44).append("Reconfigurable contains non-dynamic configs ").append(nonDynamic).toString());
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicBrokerConfigs$1(DynamicBrokerConfig $this) {
        return (scala.collection.mutable.Map)$this.dynamicBrokerConfigs().clone();
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicDefaultConfigs$1(DynamicBrokerConfig $this) {
        return (scala.collection.mutable.Map)$this.dynamicDefaultConfigs().clone();
    }

    public static final /* synthetic */ void $anonfun$updateBrokerConfig$1(DynamicBrokerConfig $this, Properties persistentProps$1, boolean doLog$1, int brokerId$1) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$1, true);
            $this.dynamicBrokerConfigs().clear();
            $this.dynamicBrokerConfigs().$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala());
            $this.updateCurrentConfig(doLog$1);
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Per-broker configs of ").append(brokerId$1).append(" could not be applied: ").append(persistentProps$1.keys()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateDefaultConfig$1(DynamicBrokerConfig $this, Properties persistentProps$2, boolean doLog$2) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$2, false);
            $this.dynamicDefaultConfigs().clear();
            $this.dynamicDefaultConfigs().$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala());
            $this.updateCurrentConfig(doLog$2);
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Cluster default configs could not be applied: ").append(persistentProps$2.keys()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$reloadUpdatedFilesWithoutConfigChange$2(Reconfigurable reconfigurable) {
        return DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs().exists(arg_0 -> DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(reconfigurable.reconfigurableConfigs(), arg_0));
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$4(DynamicBrokerConfig $this, Properties newProps$1, Reconfigurable x0$1) {
        if (x0$1 instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)x0$1;
            Map<String, String> kafkaProps = $this.validatedKafkaProps(newProps$1, true);
            KafkaConfig newConfig = new KafkaConfig(CollectionConverters$.MODULE$.MapHasAsJava(kafkaProps).asJava(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig, Collections.emptyMap(), false, true);
            return;
        }
        $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Files will not be reloaded without config change for ").append(x0$1).toString());
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$1(DynamicBrokerConfig $this, Properties newProps$1) {
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala($this.reconfigurables()).asScala().filter((Function1 & Serializable)reconfigurable -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$2(reconfigurable)))).foreach((Function1 & Serializable)x0$1 -> {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$4($this, newProps$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private final void encodePassword$1(String configName, String value, boolean perBrokerConfig$1, Properties props$3) {
        if (value != null) {
            if (!perBrokerConfig$1) {
                throw new ConfigException("Password config can be defined only at broker level");
            }
            props$3.setProperty(configName, this.passwordEncoder().encode(new Password(value)));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$toPersistentProps$1(DynamicBrokerConfig $this, boolean perBrokerConfig$1, Properties props$3, String name, String value) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)) {
            $this.encodePassword$1(name, value, perBrokerConfig$1, props$3);
            return;
        }
    }

    private final void removeInvalidProps$1(Set invalidPropNames, String errorMessage, Properties props$4) {
        if (invalidPropNames.nonEmpty()) {
            invalidPropNames.foreach((Function1 & Serializable)x$1 -> props$4.remove(x$1));
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(2).append(errorMessage).append(": ").append(invalidPropNames).toString());
            return;
        }
    }

    private final void decodePassword$1(String configName, String value, Properties props$4) {
        if (value != null) {
            try {
                props$4.setProperty(configName, this.passwordEncoder().decode(value).value());
                return;
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Dynamic password config ").append(configName).append(" could not be decoded, ignoring.").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                props$4.remove(configName);
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$fromPersistentProps$5(DynamicBrokerConfig $this, Properties props$4, String name, String value) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)) {
            $this.decodePassword$1(name, value, props$4);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$3(DynamicBrokerConfig $this, PasswordEncoder passwordDecoder$1, Properties props$5, String configName, String value2) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(configName) && value2 != null) {
            Some some;
            try {
                some = new Some((Object)passwordDecoder$1.decode(value2).value());
            }
            catch (Exception exception) {
                $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(88).append("Dynamic password config ").append(configName).append(" could not be decoded using old secret, new secret will be used.").toString());
                some = None$.MODULE$;
            }
            some.foreach((Function1 & Serializable)value -> props$5.put(configName, $this.passwordEncoder().encode(new Password(value))));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$2(DynamicBrokerConfig $this, Properties persistentProps$3, Properties props$5, AdminZkClient adminZkClient$1, PasswordEncoder passwordDecoder) {
        CollectionConverters$.MODULE$.PropertiesHasAsScala(persistentProps$3).asScala().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(configName, value) -> {
            DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$3($this, passwordDecoder, props$5, configName, value);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        adminZkClient$1.changeBrokerConfig((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)$this.kafkaConfig().brokerId())), props$5);
    }

    public static final /* synthetic */ Tuple2 $anonfun$validate$1(DynamicBrokerConfig $this, Properties props$6, boolean perBrokerConfig$2) {
        Map<String, String> newProps = $this.validatedKafkaProps(props$6, perBrokerConfig$2);
        return $this.processReconfiguration(newProps, true, false);
    }

    public static final /* synthetic */ boolean $anonfun$removeInvalidConfigs$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Properties props1 = new Properties();
            props1.put(k, v);
            try {
                DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props1);
                return false;
            }
            catch (Exception exception) {
                return true;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$maybeReconfigure$1(KafkaConfig oldConfig$1, java.util.Map newConfig$1, String key) {
        return !BoxesRunTime.equals((Object)oldConfig$1.originals().get(key), newConfig$1.get(key));
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$1(java.util.Map currentProps$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            return !BoxesRunTime.equals((Object)x0$1._2(), currentProps$1.get(k));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$2(java.util.Map newProps$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            String k = (String)x0$2._1();
            return !newProps$2.containsKey(k);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$1(DynamicBrokerConfig $this, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, KafkaConfig newConfig$3, boolean validateOnly$1, DynamicLoginManager loginManager) {
        if ($this.brokerNeedsReconfiguration(loginManager, (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            loginManager.validateReconfiguration(newConfig$3);
            if (!validateOnly$1) {
                loginManager.reconfigure($this.currentConfig(), newConfig$3);
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$3(DynamicBrokerConfig $this, KafkaConfig newConfig$3, HashMap customConfigs$1, boolean validateOnly$1, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, Reconfigurable x0$1) {
        if (x0$1 instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)x0$1;
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig$3, customConfigs$1, validateOnly$1, false);
            return;
        }
        if ($this.needsReconfiguration(x0$1.reconfigurableConfigs(), (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            $this.processReconfigurable(x0$1, (Set<String>)changeMap$1.keySet(), newConfig$3.valuesFromThisConfig(), customConfigs$1, validateOnly$1);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$4(DynamicBrokerConfig $this, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, KafkaConfig newConfig$3, boolean validateOnly$1, Buffer brokerReconfigurablesToUpdate$1, BrokerReconfigurable reconfigurable) {
        if ($this.brokerNeedsReconfiguration(reconfigurable, (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            reconfigurable.validateReconfiguration(newConfig$3);
            if (!validateOnly$1) {
                brokerReconfigurablesToUpdate$1.$plus$eq((Object)reconfigurable);
                return;
            }
            return;
        }
    }

    public DynamicBrokerConfig(KafkaConfig kafkaConfig) {
        Option<PasswordEncoder> option;
        this.kafkaConfig = kafkaConfig;
        this.staticBrokerConfigs = CollectionConverters$.MODULE$.MapHasAsScala(ConfigDef.convertToStringMapWithPasswordValues(kafkaConfig.originalsFromThisConfig())).asScala();
        this.staticDefaultConfigs = CollectionConverters$.MODULE$.MapHasAsScala(ConfigDef.convertToStringMapWithPasswordValues((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(KafkaConfig$.MODULE$.defaultValues()).asJava())).asScala();
        this.dynamicBrokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.dynamicDefaultConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.reconfigurables = new CopyOnWriteArrayList();
        this.brokerReconfigurables = new CopyOnWriteArrayList();
        this.lock = new ReentrantReadWriteLock();
        this.currentConfig = null;
        if (kafkaConfig.processRoles().isEmpty()) {
            option = this.maybeCreatePasswordEncoder(kafkaConfig.passwordEncoderSecret());
        } else {
            Option<PasswordEncoder> option2;
            option = option2;
            super((Object)new NoOpPasswordEncoder());
        }
        this.dynamicConfigPasswordEncoder = option;
    }

    public static final /* synthetic */ Object $anonfun$updateCurrentConfig$1$adapted(KafkaConfig oldConfig$2, KafkaConfig newConfig$2, BrokerReconfigurable x$4) {
        x$4.reconfigure(oldConfig$2, newConfig$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$processReconfiguration$1$adapted(DynamicBrokerConfig $this, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, KafkaConfig newConfig$3, boolean validateOnly$1, DynamicLoginManager loginManager) {
        DynamicBrokerConfig.$anonfun$processReconfiguration$1($this, changeMap$1, deletedKeySet$1, newConfig$3, validateOnly$1, loginManager);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(java.util.Set eta$0$1$1, Object x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.contains(x$1));
    }
}

