/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.quota.QuotaDescription;
import kafka.coordinator.quota.QuotaEntity;
import kafka.server.AbstractRequestThread;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.utils.KafkaScheduler;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.PublishQuotaTargetRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.PublishQuotaTargetRequest;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001B\u0007\u000f\u0001MA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011!q\u0004A!A!\u0002\u0013y\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u000b-\u0003A\u0011\u0001'\t\u000bQ\u0003A\u0011I+\t\u000b\u0015\u0004A\u0011\t4\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e!9\u00111\u0006\u0001\u0005\n\u00055\u0002bBA\u0018\u0001\u0011%\u0011\u0011\u0007\u0002$\tft\u0017-\\5d#V|G/\u0019)vE2L7\u000f[5oOJ+\u0017/^3tiRC'/Z1e\u0015\ty\u0001#\u0001\u0004tKJ4XM\u001d\u0006\u0002#\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0015!\r)b\u0003G\u0007\u0002\u001d%\u0011qC\u0004\u0002\u0016\u0003\n\u001cHO]1diJ+\u0017/^3tiRC'/Z1e!\tIbE\u0004\u0002\u001bI5\t1D\u0003\u0002\u001d;\u00059Q.Z:tC\u001e,'B\u0001\u0010 \u0003\u0019\u0019w.\\7p]*\u0011\u0011\u0003\t\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014x-\u0003\u0002&7\u0005i\u0002+\u001e2mSND\u0017+^8uCR\u000b'oZ3u%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0002(Q\tIQI\u001c;ss\u0012\u000bG/\u0019\u0006\u0003Km\taaY8oM&<\u0007CA\u000b,\u0013\tacBA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB7fiJL7m\u001d\t\u0003_Ej\u0011\u0001\r\u0006\u0003[uI!A\r\u0019\u0003\u000f5+GO]5dg\u0006iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\"!F\u001b\n\u0005Yr!!D'fi\u0006$\u0017\r^1DC\u000eDW-A\u0007oKR<xN]6DY&,g\u000e\u001e\t\u0003sqj\u0011A\u000f\u0006\u0003w}\tqa\u00197jK:$8/\u0003\u0002>u\tia*\u001a;x_J\\7\t\\5f]R\fab[1gW\u0006\u001c6\r[3ek2,'\u000f\u0005\u0002A\u00076\t\u0011I\u0003\u0002C!\u0005)Q\u000f^5mg&\u0011A)\u0011\u0002\u000f\u0017\u000647.Y*dQ\u0016$W\u000f\\3s\u0003\u0011!\u0018.\\3\u0011\u0005\u001dKU\"\u0001%\u000b\u0005\tk\u0012B\u0001&I\u0005\u0011!\u0016.\\3\u0002\rqJg.\u001b;?)\u001diej\u0014)R%N\u0003\"!\u0006\u0001\t\u000b%:\u0001\u0019\u0001\u0016\t\u000b5:\u0001\u0019\u0001\u0018\t\u000bM:\u0001\u0019\u0001\u001b\t\u000b]:\u0001\u0019\u0001\u001d\t\u000by:\u0001\u0019A \t\u000b\u0015;\u0001\u0019\u0001$\u0002\u000bM$\u0018M\u001d;\u0015\u0005Yc\u0006CA,[\u001b\u0005A&\"A-\u0002\u000bM\u001c\u0017\r\\1\n\u0005mC&\u0001B+oSRDQ!\u0018\u0005A\u0002y\u000b1bY8pe\u0012Lg.\u0019;peB\u0011qlY\u0007\u0002A*\u0011\u0011MY\u0001\u0006cV|G/\u0019\u0006\u0003;BI!\u0001\u001a1\u0003!E+x\u000e^1D_>\u0014H-\u001b8bi>\u0014\u0018!D2sK\u0006$XMU3rk\u0016\u001cH\u000f\u0006\u0003h{\u0006\u001d\u0001G\u00015u!\rIwN\u001d\b\u0003U6l\u0011a\u001b\u0006\u0003Yv\t\u0001B]3rk\u0016\u001cHo]\u0005\u0003].\fq\"\u00112tiJ\f7\r\u001e*fcV,7\u000f^\u0005\u0003aF\u0014qAQ;jY\u0012,'O\u0003\u0002oWB\u00111\u000f\u001e\u0007\u0001\t%)\u0018\"!A\u0001\u0002\u000b\u0005aOA\u0002`IM\n\"a\u001e>\u0011\u0005]C\u0018BA=Y\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A[>\n\u0005q\\'aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\t\u000byL\u0001\u0019A@\u0002\t9|G-\u001a\t\u0005\u0003\u0003\t\u0019!D\u0001\u001e\u0013\r\t)!\b\u0002\u0005\u001d>$W\rC\u0004\u0002\n%\u0001\r!a\u0003\u0002\u000f\u0015tGO]5fgB)\u0011QBA\f15\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"\u0001\u0003vi&d'BAA\u000b\u0003\u0011Q\u0017M^1\n\t\u0005e\u0011q\u0002\u0002\n\u0003J\u0014\u0018-\u001f'jgR\fqaZ3u\u001d>$W\r\u0006\u0004\u0002 \u0005\u0015\u0012\u0011\u0006\t\u0005/\u0006\u0005r0C\u0002\u0002$a\u0013aa\u00149uS>t\u0007BBA\u0014\u0015\u0001\u0007\u0001$A\u0003f]R\u0014\u0018\u0010\u0003\u0005\u007f\u0015A\u0005\t\u0019AA\u0010\u0003u\tXo\u001c;b)\u0006\u0014x-\u001a;Qk\nd\u0017n\u001d5j]\u001e\u001c\u0015\r\u001c7cC\u000e\\G#\u0001,\u0002'\r\u0014X-\u0019;f\u000b:$(/\u001f$peF+X-^3\u0015\u000bY\u000b\u0019$!\u0010\t\u000f\u0005UB\u00021\u0001\u00028\u0005Y\u0011/^8uC\u0016sG/\u001b;z!\ry\u0016\u0011H\u0005\u0004\u0003w\u0001'aC)v_R\fWI\u001c;jifDq!a\u0010\r\u0001\u0004\t\t%\u0001\trk>$\u0018\rR3tGJL\u0007\u000f^5p]B\u0019q,a\u0011\n\u0007\u0005\u0015\u0003M\u0001\tRk>$\u0018\rR3tGJL\u0007\u000f^5p]\u0002")
public class DynamicQuotaPublishingRequestThread
extends AbstractRequestThread<PublishQuotaTargetRequestData.EntryData> {
    private final KafkaConfig config;
    private final MetadataCache metadataCache;

    @Override
    public void start(QuotaCoordinator coordinator) {
        super.start(coordinator);
        this.schedule("publish-quota-target", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.quotaTargetPublishingCallback(), Predef$.MODULE$.Long2long(this.config.quotaPublishingIntervalMs()));
    }

    @Override
    public AbstractRequest.Builder<? extends AbstractRequest> createRequest(Node node, ArrayList<PublishQuotaTargetRequestData.EntryData> entries) {
        PublishQuotaTargetRequestData data = new PublishQuotaTargetRequestData().setEntries(entries);
        return new PublishQuotaTargetRequest.Builder(data);
    }

    @Override
    public Option<Node> getNode(PublishQuotaTargetRequestData.EntryData entry, Option<Node> node) {
        return node.flatMap((Function1 & Serializable)n -> $this.metadataCache.getAliveBrokerNode(n.id(), $this.config.interBrokerListenerName()));
    }

    private void quotaTargetPublishingCallback() {
        if (this.quotaCoordinator().isActive().get()) {
            this.quotaCoordinator().quotaStateManager().recomputedQuotaEntities().foreach((Function1 & Serializable)quotaEntity -> {
                DynamicQuotaPublishingRequestThread.$anonfun$quotaTargetPublishingCallback$1(this, quotaEntity);
                return BoxedUnit.UNIT;
            });
            this.wakeup();
            return;
        }
    }

    private void createEntryForQueue(QuotaEntity quotaEntity, QuotaDescription quotaDescription) {
        ArrayList entity = new ArrayList();
        quotaEntity.entityTypes().foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicQuotaPublishingRequestThread.$anonfun$createEntryForQueue$1(entity, x0$1)));
        quotaDescription.brokerQuotas().foreach((Function1 & Serializable)x0$2 -> {
            DynamicQuotaPublishingRequestThread.$anonfun$createEntryForQueue$2(this, entity, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$quotaTargetPublishingCallback$2(QuotaEntity quotaEntity$1, Errors error$1) {
        return new StringBuilder(44).append("Failed to describe quota for entity ").append(quotaEntity$1).append(" due to ").append(error$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$quotaTargetPublishingCallback$1(DynamicQuotaPublishingRequestThread $this, QuotaEntity quotaEntity) {
        void var3_3;
        Tuple2<Errors, QuotaDescription> tuple2 = $this.quotaCoordinator().describeQuota(quotaEntity);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        QuotaDescription quotaDescription = (QuotaDescription)tuple2._2();
        if (Errors.NONE.equals(var3_3)) {
            void var4_4;
            $this.createEntryForQueue(quotaEntity, (QuotaDescription)var4_4);
            return;
        }
        $this.warn((Function0<String>)((Function0 & Serializable)() -> DynamicQuotaPublishingRequestThread.$anonfun$quotaTargetPublishingCallback$2(quotaEntity, (Errors)var3_3)));
    }

    public static final /* synthetic */ boolean $anonfun$createEntryForQueue$1(ArrayList entity$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String entityType = (String)x0$1._1();
            String entityName = (String)x0$1._2();
            return entity$1.add(new PublishQuotaTargetRequestData.EntityData().setEntityType(entityType).setEntityName(entityName));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$createEntryForQueue$3(ArrayList quotas$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String quotaType = (String)x0$3._1();
            double quotaValue = x0$3._2$mcD$sp();
            return quotas$1.add(new PublishQuotaTargetRequestData.QuotaData().setQuotaType(quotaType).setQuota(quotaValue));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$createEntryForQueue$2(DynamicQuotaPublishingRequestThread $this, ArrayList entity$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            int brokerId = x0$2._1$mcI$sp();
            Map perBrokerQuota = (Map)x0$2._2();
            ArrayList quotas = new ArrayList();
            perBrokerQuota.foreach((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)DynamicQuotaPublishingRequestThread.$anonfun$createEntryForQueue$3(quotas, x0$3)));
            PublishQuotaTargetRequestData.EntryData entry = new PublishQuotaTargetRequestData.EntryData().setEntity((List)entity$1).setQuotas(quotas);
            Option<Node> destination = $this.metadataCache.getAliveBrokerNode(brokerId, $this.config.interBrokerListenerName());
            $this.addEntryForNode(entry, destination);
            return;
        }
        throw new MatchError(null);
    }

    public DynamicQuotaPublishingRequestThread(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, NetworkClient networkClient, KafkaScheduler kafkaScheduler, Time time) {
        this.config = config;
        this.metadataCache = metadataCache;
        super(config, metrics, networkClient, kafkaScheduler, time, "Quota Publishing");
    }
}

