/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Map;
import java.util.Optional;
import kafka.cluster.PartitionListener;
import kafka.log.MergedLog$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.PartitionFetchMetadata;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\rua\u0001B*U\u0001eC\u0001\" \u0001\u0003\u0002\u0004%\tA \u0005\u000b\u00033\u0001!\u00111A\u0005\u0002\u0005m\u0001\"CA\u0015\u0001\t\u0005\t\u0015)\u0003\u0000\u0011)\tY\u0003\u0001BC\u0002\u0013\u0005\u0011Q\u0006\u0005\u000b\u0003o\u0001!\u0011!Q\u0001\n\u0005=\u0002BCA\u001d\u0001\t\u0015\r\u0011\"\u0001\u0002<!Q\u00111\t\u0001\u0003\u0002\u0003\u0006I!!\u0010\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H!I\u0011\u0011\u000b\u0001A\u0002\u0013\u0005\u00111\b\u0005\n\u0003'\u0002\u0001\u0019!C\u0001\u0003+B\u0001\"!\u0017\u0001A\u0003&\u0011Q\b\u0005\n\u00037\u0002\u0001\u0019!C\u0001\u0003;B\u0011\"!\u001a\u0001\u0001\u0004%\t!a\u001a\t\u0011\u0005-\u0004\u0001)Q\u0005\u0003?B\u0011\"!\u001c\u0001\u0001\u0004%\t!!\u0018\t\u0013\u0005=\u0004\u00011A\u0005\u0002\u0005E\u0004\u0002CA;\u0001\u0001\u0006K!a\u0018\t\u0013\u0005]\u0004\u00011A\u0005\u0002\u0005m\u0002\"CA=\u0001\u0001\u0007I\u0011AA>\u0011!\ty\b\u0001Q!\n\u0005u\u0002\"CAA\u0001\u0001\u0007I\u0011AAB\u0011%\t9\n\u0001a\u0001\n\u0003\tI\n\u0003\u0005\u0002\u001e\u0002\u0001\u000b\u0015BAC\u0011%\ty\n\u0001a\u0001\n\u0003\t\u0019\tC\u0005\u0002\"\u0002\u0001\r\u0011\"\u0001\u0002$\"A\u0011q\u0015\u0001!B\u0013\t)\tC\u0005\u0002*\u0002\u0001\r\u0011\"\u0001\u0002,\"I\u00111\u0017\u0001A\u0002\u0013\u0005\u0011Q\u0017\u0005\t\u0003s\u0003\u0001\u0015)\u0003\u0002.\"I\u00111\u0018\u0001A\u0002\u0013%\u0011Q\f\u0005\n\u0003{\u0003\u0001\u0019!C\u0005\u0003\u007fC\u0001\"a1\u0001A\u0003&\u0011q\f\u0005\n\u0003\u000b\u0004\u0001\u0019!C\u0005\u0003;B\u0011\"a2\u0001\u0001\u0004%I!!3\t\u0011\u00055\u0007\u0001)Q\u0005\u0003?B1\"a4\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002R\"Y\u0011\u0011\u001c\u0001A\u0002\u0003\u0007I\u0011BAn\u0011-\ty\u000e\u0001a\u0001\u0002\u0003\u0006K!a5\t\u0013\u0005%\b\u00011A\u0005\n\u0005u\u0003\"CAv\u0001\u0001\u0007I\u0011BAw\u0011!\t\t\u0010\u0001Q!\n\u0005}\u0003\"CA{\u0001\u0001\u0007I\u0011BA/\u0011%\t9\u0010\u0001a\u0001\n\u0013\tI\u0010\u0003\u0005\u0002~\u0002\u0001\u000b\u0015BA0\u0011%\u0011\t\u0001\u0001a\u0001\n\u0013\ti\u0006C\u0005\u0003\u0004\u0001\u0001\r\u0011\"\u0003\u0003\u0006!A!\u0011\u0002\u0001!B\u0013\ty\u0006C\u0005\u0003\u000e\u0001\u0001\r\u0011\"\u0003\u0002,\"I!q\u0002\u0001A\u0002\u0013%!\u0011\u0003\u0005\t\u0005+\u0001\u0001\u0015)\u0003\u0002.\"I!\u0011\u0004\u0001A\u0002\u0013\u0005!1\u0004\u0005\n\u0005G\u0001\u0001\u0019!C\u0001\u0005KA\u0001B!\u000b\u0001A\u0003&!Q\u0004\u0005\n\u0005[\u0001\u0001\u0019!C\u0005\u0003wA\u0011Ba\f\u0001\u0001\u0004%IA!\r\t\u0011\tU\u0002\u0001)Q\u0005\u0003{A\u0011Ba\u000e\u0001\u0001\u0004%I!a\u000f\t\u0013\te\u0002\u00011A\u0005\n\tm\u0002\u0002\u0003B \u0001\u0001\u0006K!!\u0010\t\u000f\t\u0005\u0003\u0001\"\u0011\u0003D!9!Q\t\u0001\u0005B\t\u001d\u0003b\u0002B&\u0001\u0011\u0005#1\t\u0005\b\u0005\u001b\u0002A\u0011\tB(\u0011\u001d\u0011\u0019\u0006\u0001C!\u0005+BqA!\u0017\u0001\t\u0003\u0012Y\u0006C\u0004\u0002F\u0001!\tAa\u001a\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0003r!9!\u0011\u0010\u0001\u0005B\tm\u0004b\u0002BE\u0001\u0011\u0005#1\u0012\u0005\b\u0005#\u0003A\u0011\tBJ\u0011\u001d\u0011I\n\u0001C!\u00057CqA!+\u0001\t\u0003\u0012Y\u000bC\u0004\u00030\u0002!\tE!-\t\u000f\tU\u0006\u0001\"\u0011\u00038\"9!Q\u0018\u0001\u0005B\t}\u0006b\u0002Ba\u0001\u0011\u0005#1\u0019\u0005\b\u0005\u000b\u0004A\u0011\u0001Bd\u0011\u001d\u0011\t\u000f\u0001C\u0001\u0005GDqAa>\u0001\t\u0003\u0011I\u0010C\u0004\u0004\u0012\u0001!\tEa\u0011\t\u000f\rM\u0001\u0001\"\u0011\u0004\u0016!91\u0011\u0004\u0001\u0005B\rm!!I%oGJ,W.\u001a8uC2\u0004\u0016M\u001d;ji&|gNR3uG\"lU\r^1eCR\f'BA+W\u0003\u0019\u0019XM\u001d<fe*\tq+A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u000b\u0001Q&m]<\u0011\u0005m\u0003W\"\u0001/\u000b\u0005us\u0016\u0001\u00027b]\u001eT\u0011aX\u0001\u0005U\u00064\u0018-\u0003\u0002b9\n1qJ\u00196fGR\u0004\"a\u00199\u000f\u0005\u0011tW\"A3\u000b\u0005\u0019<\u0017!B;uS2\u001c(B\u00015j\u0003\u0019\u0019w.\\7p]*\u0011qK\u001b\u0006\u0003W2\fa!\u00199bG\",'\"A7\u0002\u0007=\u0014x-\u0003\u0002pK\u0006a\u0012*\u001c9mS\u000eLG\u000fT5oW\u0016$\u0007*Y:i\u0007>dG.Z2uS>t\u0017BA9s\u0005\u001d)E.Z7f]RT!a\\3\u0011\u0005Q,X\"\u0001+\n\u0005Y$&A\u0006)beRLG/[8o\r\u0016$8\r['fi\u0006$\u0017\r^1\u0011\u0005a\\X\"A=\u000b\u0005i4\u0016aB2mkN$XM]\u0005\u0003yf\u0014\u0011\u0003U1si&$\u0018n\u001c8MSN$XM\\3s\u0003\u0015!x\u000e]5d+\u0005y\b\u0003BA\u0001\u0003'qA!a\u0001\u0002\u0010A!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\na\u000ba\u0001\u0010:p_Rt$BAA\u0007\u0003\u0015\u00198-\u00197b\u0013\u0011\t\t\"a\u0003\u0002\rA\u0013X\rZ3g\u0013\u0011\t)\"a\u0006\u0003\rM#(/\u001b8h\u0015\u0011\t\t\"a\u0003\u0002\u0013Q|\u0007/[2`I\u0015\fH\u0003BA\u000f\u0003K\u0001B!a\b\u0002\"5\u0011\u00111B\u0005\u0005\u0003G\tYA\u0001\u0003V]&$\b\u0002CA\u0014\u0005\u0005\u0005\t\u0019A@\u0002\u0007a$\u0013'\u0001\u0004u_BL7\rI\u0001\bi>\u0004\u0018nY%e+\t\ty\u0003\u0005\u0003\u00022\u0005MR\"A4\n\u0007\u0005UrM\u0001\u0003Vk&$\u0017\u0001\u0003;pa&\u001c\u0017\n\u001a\u0011\u0002\u0013A\f'\u000f^5uS>tWCAA\u001f!\u0011\ty\"a\u0010\n\t\u0005\u0005\u00131\u0002\u0002\u0004\u0013:$\u0018A\u00039beRLG/[8oA\u00051A(\u001b8jiz\"\u0002\"!\u0013\u0002L\u00055\u0013q\n\t\u0003i\u0002AQ! \u0005A\u0002}Dq!a\u000b\t\u0001\u0004\ty\u0003C\u0004\u0002:!\u0001\r!!\u0010\u0002\u0013I,\u0007\u000f\\5dC&#\u0017!\u0004:fa2L7-Y%e?\u0012*\u0017\u000f\u0006\u0003\u0002\u001e\u0005]\u0003\"CA\u0014\u0015\u0005\u0005\t\u0019AA\u001f\u0003)\u0011X\r\u001d7jG\u0006LE\rI\u0001\fM\u0016$8\r[(gMN,G/\u0006\u0002\u0002`A!\u0011qDA1\u0013\u0011\t\u0019'a\u0003\u0003\t1{gnZ\u0001\u0010M\u0016$8\r[(gMN,Go\u0018\u0013fcR!\u0011QDA5\u0011%\t9#DA\u0001\u0002\u0004\ty&\u0001\u0007gKR\u001c\u0007n\u00144gg\u0016$\b%A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\u0018aD:uCJ$xJ\u001a4tKR|F%Z9\u0015\t\u0005u\u00111\u000f\u0005\n\u0003O\u0001\u0012\u0011!a\u0001\u0003?\nAb\u001d;beR|eMZ:fi\u0002\n\u0001\"\\1y\u0005f$Xm]\u0001\r[\u0006D()\u001f;fg~#S-\u001d\u000b\u0005\u0003;\ti\bC\u0005\u0002(M\t\t\u00111\u0001\u0002>\u0005IQ.\u0019=CsR,7\u000fI\u0001\u0013GV\u0014(/\u001a8u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.\u0006\u0002\u0002\u0006B1\u0011qQAG\u0003#k!!!#\u000b\u0007\u0005-e,\u0001\u0003vi&d\u0017\u0002BAH\u0003\u0013\u0013\u0001b\u00149uS>t\u0017\r\u001c\t\u00047\u0006M\u0015bAAK9\n9\u0011J\u001c;fO\u0016\u0014\u0018AF2veJ,g\u000e\u001e'fC\u0012,'/\u00129pG\"|F%Z9\u0015\t\u0005u\u00111\u0014\u0005\n\u0003O1\u0012\u0011!a\u0001\u0003\u000b\u000b1cY;se\u0016tG\u000fT3bI\u0016\u0014X\t]8dQ\u0002\n\u0001\u0003\\1ti\u001a+Go\u00195fI\u0016\u0003xn\u00195\u0002)1\f7\u000f\u001e$fi\u000eDW\rZ#q_\u000eDw\fJ3r)\u0011\ti\"!*\t\u0013\u0005\u001d\u0012$!AA\u0002\u0005\u0015\u0015!\u00057bgR4U\r^2iK\u0012,\u0005o\\2iA\u0005!b-\u001a;dQ6+G/\u00193bi\u0006,\u0006\u000fZ1uK\u0012,\"!!,\u0011\t\u0005}\u0011qV\u0005\u0005\u0003c\u000bYAA\u0004C_>dW-\u00198\u00021\u0019,Go\u00195NKR\fG-\u0019;b+B$\u0017\r^3e?\u0012*\u0017\u000f\u0006\u0003\u0002\u001e\u0005]\u0006\"CA\u00149\u0005\u0005\t\u0019AAW\u0003U1W\r^2i\u001b\u0016$\u0018\rZ1uCV\u0003H-\u0019;fI\u0002\nQ\u0003\\1ti\"Kw\r[,bi\u0016\u0014X.\u0019:l'\u0016tG/A\rmCN$\b*[4i/\u0006$XM]7be.\u001cVM\u001c;`I\u0015\fH\u0003BA\u000f\u0003\u0003D\u0011\"a\n \u0003\u0003\u0005\r!a\u0018\u0002-1\f7\u000f\u001e%jO\"<\u0016\r^3s[\u0006\u00148nU3oi\u0002\na\u0003\\1ti2{wm\u0015;beR|eMZ:fiN+g\u000e^\u0001\u001bY\u0006\u001cH\u000fT8h'R\f'\u000f^(gMN,GoU3oi~#S-\u001d\u000b\u0005\u0003;\tY\rC\u0005\u0002(\t\n\t\u00111\u0001\u0002`\u00059B.Y:u\u0019><7\u000b^1si>3gm]3u'\u0016tG\u000fI\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\t\t\u0019\u000eE\u0002u\u0003+L1!a6U\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\f!C]3qY&\u001c\u0017-T1oC\u001e,'o\u0018\u0013fcR!\u0011QDAo\u0011%\t9#JA\u0001\u0002\u0004\t\u0019.A\bsKBd\u0017nY1NC:\fw-\u001a:!Q\r1\u00131\u001d\t\u0005\u0003?\t)/\u0003\u0003\u0002h\u0006-!\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002)A\f'\u000f^5uS>t7\u000b^1si>3gm]3u\u0003a\u0001\u0018M\u001d;ji&|gn\u0015;beR|eMZ:fi~#S-\u001d\u000b\u0005\u0003;\ty\u000fC\u0005\u0002(!\n\t\u00111\u0001\u0002`\u0005)\u0002/\u0019:uSRLwN\\*uCJ$xJ\u001a4tKR\u0004\u0003fA\u0015\u0002d\u0006\u0011\u0002/\u0019:uSRLwN\\#oI>3gm]3u\u0003Y\u0001\u0018M\u001d;ji&|g.\u00128e\u001f\u001a47/\u001a;`I\u0015\fH\u0003BA\u000f\u0003wD\u0011\"a\n,\u0003\u0003\u0005\r!a\u0018\u0002'A\f'\u000f^5uS>tWI\u001c3PM\u001a\u001cX\r\u001e\u0011)\u00071\n\u0019/\u0001\fqCJ$\u0018\u000e^5p]\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0003i\u0001\u0018M\u001d;ji&|g\u000eS5hQ^\u000bG/\u001a:nCJ\\w\fJ3r)\u0011\tiBa\u0002\t\u0013\u0005\u001db&!AA\u0002\u0005}\u0013a\u00069beRLG/[8o\u0011&<\u0007nV1uKJl\u0017M]6!Q\ry\u00131]\u0001\u000fSN\u0014V\r\u001d7jG\u0006Le.S:s\u0003II7OU3qY&\u001c\u0017-\u00138JgJ|F%Z9\u0015\t\u0005u!1\u0003\u0005\n\u0003O\t\u0014\u0011!a\u0001\u0003[\u000bq\"[:SKBd\u0017nY1J]&\u001b(\u000f\t\u0015\u0004e\u0005\r\u0018a\u00054fi\u000eDwJ\u001a4tKRlU\r^1eCR\fWC\u0001B\u000f!\r!(qD\u0005\u0004\u0005C!&!\u0005'pO>3gm]3u\u001b\u0016$\u0018\rZ1uC\u00069b-\u001a;dQ>3gm]3u\u001b\u0016$\u0018\rZ1uC~#S-\u001d\u000b\u0005\u0003;\u00119\u0003C\u0005\u0002(Q\n\t\u00111\u0001\u0003\u001e\u0005!b-\u001a;dQ>3gm]3u\u001b\u0016$\u0018\rZ1uC\u0002B3!NAr\u0003)\u0019\u0017m\u00195fI:+\u0007\u0010^\u0001\u000fG\u0006\u001c\u0007.\u001a3OKb$x\fJ3r)\u0011\tiBa\r\t\u0013\u0005\u001dr'!AA\u0002\u0005u\u0012aC2bG\",GMT3yi\u0002\n!bY1dQ\u0016$\u0007K]3w\u00039\u0019\u0017m\u00195fIB\u0013XM^0%KF$B!!\b\u0003>!I\u0011q\u0005\u001e\u0002\u0002\u0003\u0007\u0011QH\u0001\fG\u0006\u001c\u0007.\u001a3Qe\u00164\b%\u0001\u0003oKb$HCAA\u001f\u0003\u001d\u0019X\r\u001e(fqR$B!!\b\u0003J!9!\u0011I\u001fA\u0002\u0005u\u0012\u0001\u00029sKZ\fqa]3u!J,g\u000f\u0006\u0003\u0002\u001e\tE\u0003b\u0002B&\u007f\u0001\u0007\u0011QH\u0001\u0017g\u0016$h)\u001a;dQ>3gm]3u\u001b\u0016$\u0018\rZ1uCR!\u0011Q\u0004B,\u0011\u001d\u0011I\u0002\u0011a\u0001\u0005;\t1#\u001a7f[\u0016tGoS3zg\u0006\u0013X-R9vC2$B!!,\u0003^!9!qL!A\u0002\t\u0005\u0014\u0001\u0002;iCR\u0004B!a\b\u0003d%!!QMA\u0006\u0005\r\te.\u001f\u000b\u0005\u0003\u0013\u0012I\u0007C\u0004\u0002:\t\u0003\rAa\u001b\u0011\t\u0005E\"QN\u0005\u0004\u0005_:'\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o)\u0019\tIEa\u001d\u0003v!9\u0011\u0011H\"A\u0002\t-\u0004B\u0002B<\u0007\u0002\u00071/A\u000bqCJ$\u0018\u000e^5p]\u001a+Go\u00195SKF,Xm\u001d;\u0002)=t7\u000b^1si>3gm]3u+B$\u0017\r^3e)\u0019\tiB! \u0003\u0006\"9\u0011\u0011\b#A\u0002\t}\u0004\u0003BA\u0019\u0005\u0003K1Aa!h\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:DqAa\"E\u0001\u0004\ty&\u0001\u0004pM\u001a\u001cX\r^\u0001\u0013_:,e\u000eZ(gMN,G/\u00169eCR,G\r\u0006\u0004\u0002\u001e\t5%q\u0012\u0005\b\u0003s)\u0005\u0019\u0001B@\u0011\u001d\u00119)\u0012a\u0001\u0003?\nac\u001c8IS\u001eDw+\u0019;fe6\f'o[+qI\u0006$X\r\u001a\u000b\u0007\u0003;\u0011)Ja&\t\u000f\u0005eb\t1\u0001\u0003\u0000!9!q\u0011$A\u0002\u0005}\u0013\u0001D8o\u0013N\u0014X\u000b\u001d3bi\u0016$GCBA\u000f\u0005;\u0013y\nC\u0004\u0002:\u001d\u0003\rAa \t\u000f\t\u0005v\t1\u0001\u0003$\u0006\u0019\u0011n\u001d:\u0011\r\u0005\u0005!QUA\u001f\u0013\u0011\u00119+a\u0006\u0003\u0007M+G/\u0001\u0005p]\u001a\u000b\u0017\u000e\\3e)\u0011\tiB!,\t\u000f\u0005e\u0002\n1\u0001\u0003\u0000\u0005IqN\u001c#fY\u0016$X\r\u001a\u000b\u0005\u0003;\u0011\u0019\fC\u0004\u0002:%\u0003\rAa \u0002/5\f\u0017PY3SK\u001eL7\u000f^3s\u0003Nd\u0015n\u001d;f]\u0016\u0014HCBA\u000f\u0005s\u0013Y\fC\u0004\u0002R)\u0003\r!!\u0010\t\u000f\u0005='\n1\u0001\u0002T\u0006Q\u0011n]\"bk\u001eDG/\u00169\u0015\u0005\u00055\u0016!B2m_N,GCAA\u000f\u0003M)\b\u000fZ1uKJ+\u0017/^3tiB\u000b'/Y7t)\u0011\tiB!3\t\u000f\t-W\n1\u0001\u0003N\u0006qa-\u001a;dQB\u000b'\u000f^5uS>t\u0007\u0003\u0002Bh\u00057tAA!5\u0003X6\u0011!1\u001b\u0006\u0004\u0005+<\u0017aB7fgN\fw-Z\u0005\u0005\u00053\u0014\u0019.\u0001\tGKR\u001c\u0007NU3rk\u0016\u001cH\u000fR1uC&!!Q\u001cBp\u000591U\r^2i!\u0006\u0014H/\u001b;j_:TAA!7\u0003T\u00069R.Y=cKJ+7o\u001c7wKVs7N\\8x]:\u000bW.\u001a\u000b\u0005\u0003;\u0011)\u000fC\u0004\u0003h:\u0003\rA!;\u0002\u0015Q|\u0007/[2OC6,7\u000f\u0005\u0003\u0003l\nEhb\u0001;\u0003n&\u0019!q\u001e+\u0002\u0019\u0019+Go\u00195TKN\u001c\u0018n\u001c8\n\t\tM(Q\u001f\u0002\u000f)>\u0003\u0016jQ0O\u00036+u,T!Q\u0015\r\u0011y\u000fV\u0001\u0018[\u0006L(-Z+qI\u0006$XMU3ta>t7/\u001a#bi\u0006$b!!,\u0003|\u000e5\u0001b\u0002B\u007f\u001f\u0002\u0007!q`\u0001\te\u0016\u001c\b\u000fR1uCB!1\u0011AB\u0004\u001d\u0011\u0011\tna\u0001\n\t\r\u0015!1[\u0001\u0012\r\u0016$8\r\u001b*fgB|gn]3ECR\f\u0017\u0002BB\u0005\u0007\u0017\u0011Q\u0002U1si&$\u0018n\u001c8ECR\f'\u0002BB\u0003\u0005'Dqaa\u0004P\u0001\u0004\ti+\u0001\u0004va\u0012\fG/Z\u0001\tQ\u0006\u001c\bnQ8eK\u00061Q-];bYN$B!!,\u0004\u0018!9!qL)A\u0002\t\u0005\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003}\u0004")
public class IncrementalPartitionFetchMetadata
implements ImplicitLinkedHashCollection.Element,
PartitionFetchMetadata,
PartitionListener {
    private String topic;
    private final Uuid topicId;
    private final int partition;
    private int replicaId;
    private long fetchOffset;
    private long startOffset;
    private int maxBytes;
    private Optional<Integer> currentLeaderEpoch;
    private Optional<Integer> lastFetchedEpoch;
    private boolean fetchMetadataUpdated;
    private long lastHighWatermarkSent;
    private long lastLogStartOffsetSent;
    private volatile ReplicaManager replicaManager;
    private volatile long partitionStartOffset;
    private volatile long partitionEndOffset;
    private volatile long partitionHighWatermark;
    private volatile boolean isReplicaInIsr;
    private volatile LogOffsetMetadata fetchOffsetMetadata;
    private int cachedNext;
    private int cachedPrev;

    @Override
    public void onLastStableOffsetUpdated(TopicPartition partition, long offset) {
        PartitionListener.onLastStableOffsetUpdated$(this, partition, offset);
    }

    public String topic() {
        return this.topic;
    }

    public void topic_$eq(String x$1) {
        this.topic = x$1;
    }

    @Override
    public Uuid topicId() {
        return this.topicId;
    }

    public int partition() {
        return this.partition;
    }

    public int replicaId() {
        return this.replicaId;
    }

    public void replicaId_$eq(int x$1) {
        this.replicaId = x$1;
    }

    @Override
    public long fetchOffset() {
        return this.fetchOffset;
    }

    public void fetchOffset_$eq(long x$1) {
        this.fetchOffset = x$1;
    }

    @Override
    public long startOffset() {
        return this.startOffset;
    }

    public void startOffset_$eq(long x$1) {
        this.startOffset = x$1;
    }

    @Override
    public int maxBytes() {
        return this.maxBytes;
    }

    public void maxBytes_$eq(int x$1) {
        this.maxBytes = x$1;
    }

    @Override
    public Optional<Integer> currentLeaderEpoch() {
        return this.currentLeaderEpoch;
    }

    public void currentLeaderEpoch_$eq(Optional<Integer> x$1) {
        this.currentLeaderEpoch = x$1;
    }

    @Override
    public Optional<Integer> lastFetchedEpoch() {
        return this.lastFetchedEpoch;
    }

    public void lastFetchedEpoch_$eq(Optional<Integer> x$1) {
        this.lastFetchedEpoch = x$1;
    }

    @Override
    public boolean fetchMetadataUpdated() {
        return this.fetchMetadataUpdated;
    }

    public void fetchMetadataUpdated_$eq(boolean x$1) {
        this.fetchMetadataUpdated = x$1;
    }

    private long lastHighWatermarkSent() {
        return this.lastHighWatermarkSent;
    }

    private void lastHighWatermarkSent_$eq(long x$1) {
        this.lastHighWatermarkSent = x$1;
    }

    private long lastLogStartOffsetSent() {
        return this.lastLogStartOffsetSent;
    }

    private void lastLogStartOffsetSent_$eq(long x$1) {
        this.lastLogStartOffsetSent = x$1;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    private long partitionStartOffset() {
        return this.partitionStartOffset;
    }

    private void partitionStartOffset_$eq(long x$1) {
        this.partitionStartOffset = x$1;
    }

    private long partitionEndOffset() {
        return this.partitionEndOffset;
    }

    private void partitionEndOffset_$eq(long x$1) {
        this.partitionEndOffset = x$1;
    }

    private long partitionHighWatermark() {
        return this.partitionHighWatermark;
    }

    private void partitionHighWatermark_$eq(long x$1) {
        this.partitionHighWatermark = x$1;
    }

    private boolean isReplicaInIsr() {
        return this.isReplicaInIsr;
    }

    private void isReplicaInIsr_$eq(boolean x$1) {
        this.isReplicaInIsr = x$1;
    }

    @Override
    public LogOffsetMetadata fetchOffsetMetadata() {
        return this.fetchOffsetMetadata;
    }

    public void fetchOffsetMetadata_$eq(LogOffsetMetadata x$1) {
        this.fetchOffsetMetadata = x$1;
    }

    private int cachedNext() {
        return this.cachedNext;
    }

    private void cachedNext_$eq(int x$1) {
        this.cachedNext = x$1;
    }

    private int cachedPrev() {
        return this.cachedPrev;
    }

    private void cachedPrev_$eq(int x$1) {
        this.cachedPrev = x$1;
    }

    public int next() {
        return this.cachedNext();
    }

    public void setNext(int next) {
        this.cachedNext_$eq(next);
    }

    public int prev() {
        return this.cachedPrev();
    }

    public void setPrev(int prev) {
        this.cachedPrev_$eq(prev);
    }

    @Override
    public void setFetchOffsetMetadata(LogOffsetMetadata fetchOffsetMetadata) {
        this.fetchOffsetMetadata_$eq(fetchOffsetMetadata);
    }

    public boolean elementKeysAreEqual(Object that) {
        if (that instanceof IncrementalPartitionFetchMetadata) {
            IncrementalPartitionFetchMetadata incrementalPartitionFetchMetadata = (IncrementalPartitionFetchMetadata)that;
            Uuid uuid = this.topicId();
            Uuid uuid2 = Uuid.ZERO_UUID;
            if (uuid == null ? uuid2 != null : !uuid.equals(uuid2)) {
                return ((Object)BoxesRunTime.boxToInteger((int)this.partition())).equals(BoxesRunTime.boxToInteger((int)incrementalPartitionFetchMetadata.partition())) && this.topicId().equals((Object)incrementalPartitionFetchMetadata.topicId());
            }
            return ((Object)BoxesRunTime.boxToInteger((int)this.partition())).equals(BoxesRunTime.boxToInteger((int)incrementalPartitionFetchMetadata.partition())) && this.topic().equals(incrementalPartitionFetchMetadata.topic());
        }
        return false;
    }

    @Override
    public void onStartOffsetUpdated(TopicPartition partition, long offset) {
        this.partitionStartOffset_$eq(offset);
    }

    @Override
    public void onEndOffsetUpdated(TopicPartition partition, long offset) {
        this.partitionEndOffset_$eq(offset);
    }

    @Override
    public void onHighWatermarkUpdated(TopicPartition partition, long offset) {
        this.partitionHighWatermark_$eq(offset);
    }

    @Override
    public void onIsrUpdated(TopicPartition partition, Set<Object> isr) {
        this.isReplicaInIsr_$eq(isr.contains((Object)BoxesRunTime.boxToInteger((int)this.replicaId())));
    }

    @Override
    public void onFailed(TopicPartition partition) {
        this.replicaManager_$eq(null);
    }

    @Override
    public void onDeleted(TopicPartition partition) {
        this.replicaManager_$eq(null);
    }

    @Override
    public void maybeRegisterAsListener(int replicaId, ReplicaManager replicaManager) {
        this.replicaId_$eq(replicaId);
        if (this.replicaManager() == null && replicaId > -1) {
            if (replicaManager.maybeAddListener(new TopicPartition(this.topic(), this.partition()), this)) {
                this.replicaManager_$eq(replicaManager);
                return;
            }
            return;
        }
    }

    @Override
    public boolean isCaughtUp() {
        return this.replicaManager() != null && this.fetchOffset() == this.partitionEndOffset() && this.lastHighWatermarkSent() == this.partitionHighWatermark() && this.lastLogStartOffsetSent() == this.partitionStartOffset() && this.isReplicaInIsr();
    }

    @Override
    public void close() {
        if (this.replicaManager() != null) {
            this.replicaManager().removeListener(new TopicPartition(this.topic(), this.partition()), this);
            this.replicaManager_$eq(null);
            return;
        }
    }

    public void updateRequestParams(FetchRequestData.FetchPartition fetchPartition) {
        if (this.fetchOffset() != fetchPartition.fetchOffset()) {
            this.fetchOffsetMetadata_$eq(new LogOffsetMetadata(fetchPartition.fetchOffset(), MergedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
            this.fetchOffset_$eq(fetchPartition.fetchOffset());
            this.fetchMetadataUpdated_$eq(true);
        }
        if (this.startOffset() != fetchPartition.logStartOffset()) {
            this.startOffset_$eq(fetchPartition.logStartOffset());
            this.fetchMetadataUpdated_$eq(true);
        }
        if (this.maxBytes() != fetchPartition.partitionMaxBytes()) {
            this.maxBytes_$eq(fetchPartition.partitionMaxBytes());
            this.fetchMetadataUpdated_$eq(true);
        }
        Optional newCurrentLeaderEpoch = RequestUtils.getLeaderEpoch((int)fetchPartition.currentLeaderEpoch());
        if (!this.currentLeaderEpoch().equals(newCurrentLeaderEpoch)) {
            this.currentLeaderEpoch_$eq(newCurrentLeaderEpoch);
            this.fetchMetadataUpdated_$eq(true);
        }
        Optional newLastFetchedEpoch = RequestUtils.getLeaderEpoch((int)fetchPartition.lastFetchedEpoch());
        if (!this.lastFetchedEpoch().equals(newLastFetchedEpoch)) {
            this.lastFetchedEpoch_$eq(newLastFetchedEpoch);
            this.fetchMetadataUpdated_$eq(true);
            return;
        }
    }

    public void maybeResolveUnknownName(Map<Uuid, String> topicNames) {
        if (this.topic() == null) {
            this.topic_$eq(topicNames.get(this.topicId()));
            return;
        }
    }

    public boolean maybeUpdateResponseData(FetchResponseData.PartitionData respData, boolean update) {
        boolean mustRespond = false;
        if (FetchResponse.recordsSize((FetchResponseData.PartitionData)respData) > 0) {
            mustRespond = true;
        }
        if (this.lastHighWatermarkSent() != respData.highWatermark()) {
            mustRespond = true;
            if (update) {
                this.lastHighWatermarkSent_$eq(respData.highWatermark());
            }
        }
        if (this.lastLogStartOffsetSent() != respData.logStartOffset()) {
            mustRespond = true;
            if (update) {
                this.lastLogStartOffsetSent_$eq(respData.logStartOffset());
            }
        }
        if (FetchResponse.isPreferredReplica((FetchResponseData.PartitionData)respData)) {
            mustRespond = true;
        }
        if (respData.errorCode() != Errors.NONE.code()) {
            if (update) {
                this.lastHighWatermarkSent_$eq(-1L);
                this.lastLogStartOffsetSent_$eq(-1L);
            }
            mustRespond = true;
        }
        if (FetchResponse.isDivergingEpoch((FetchResponseData.PartitionData)respData)) {
            mustRespond = true;
        }
        if (update) {
            this.fetchMetadataUpdated_$eq(false);
        }
        return mustRespond;
    }

    public int hashCode() {
        Uuid uuid = this.topicId();
        Uuid uuid2 = Uuid.ZERO_UUID;
        if (uuid == null ? uuid2 != null : !uuid.equals(uuid2)) {
            return 31 * this.partition() + this.topicId().hashCode();
        }
        return 31 * this.partition() + this.topic().hashCode();
    }

    public boolean equals(Object that) {
        if (that instanceof IncrementalPartitionFetchMetadata) {
            IncrementalPartitionFetchMetadata incrementalPartitionFetchMetadata = (IncrementalPartitionFetchMetadata)that;
            return this == incrementalPartitionFetchMetadata;
        }
        return false;
    }

    public synchronized String toString() {
        return new StringBuilder(298).append("IncrementalPartitionFetchMetadata(topic=").append(this.topic()).append(", topicId=").append(this.topicId()).append(", partition=").append(this.partition()).append(", fetchOffset=").append(this.fetchOffset()).append(", startOffset=").append(this.startOffset()).append(", maxBytes=").append(this.maxBytes()).append(", currentLeaderEpoch=").append(this.currentLeaderEpoch()).append(", lastFetchedEpoch=").append(this.lastFetchedEpoch()).append(", lastSentHighWatermark=").append(this.lastHighWatermarkSent()).append(", lastSentLogStartOffset=").append(this.lastLogStartOffsetSent()).append(", isRegistered=").append(this.replicaManager() != null).append(", partitionStartOffset=").append(this.partitionStartOffset()).append(", partitionEndOffset=").append(this.partitionEndOffset()).append(", partitionHighWatermark=").append(this.partitionHighWatermark()).append(", fetchMetadataUpdated=").append(this.fetchMetadataUpdated()).append(")").toString();
    }

    public IncrementalPartitionFetchMetadata(String topic, Uuid topicId, int partition) {
        this.topic = topic;
        this.topicId = topicId;
        this.partition = partition;
        this.replicaId = -1;
        this.fetchOffset = -1L;
        this.startOffset = -1L;
        this.maxBytes = -1;
        this.currentLeaderEpoch = Optional.empty();
        this.lastFetchedEpoch = Optional.empty();
        this.fetchMetadataUpdated = false;
        this.lastHighWatermarkSent = -1L;
        this.lastLogStartOffsetSent = -1L;
        this.partitionStartOffset = -1L;
        this.partitionEndOffset = -1L;
        this.partitionHighWatermark = -1L;
        this.isReplicaInIsr = false;
        this.fetchOffsetMetadata = new LogOffsetMetadata(this.fetchOffset(), MergedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition());
        this.cachedNext = -2;
        this.cachedPrev = -2;
    }

    public IncrementalPartitionFetchMetadata(TopicIdPartition partition) {
        this(partition.topic(), partition.topicId(), partition.partition());
    }

    public IncrementalPartitionFetchMetadata(TopicIdPartition partition, PartitionFetchMetadata partitionFetchRequest) {
        this(partition.topic(), partition.topicId(), partition.partition());
        this.fetchOffset_$eq(partitionFetchRequest.fetchOffset());
        this.startOffset_$eq(partitionFetchRequest.startOffset());
        this.maxBytes_$eq(partitionFetchRequest.maxBytes());
        this.currentLeaderEpoch_$eq(partitionFetchRequest.currentLeaderEpoch());
        this.lastFetchedEpoch_$eq(partitionFetchRequest.lastFetchedEpoch());
    }
}

