/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.RequestChannel;
import kafka.server.ApiRequestHandler;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandler;
import kafka.server.ThreadUsageMetrics$;
import kafka.utils.Logging;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001de\u0001\u0002\u000f\u001e\u0001\tB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\tu\u0001\u0011)\u0019!C\u0001w!Aq\t\u0001B\u0001B\u0003%A\b\u0003\u0005I\u0001\t\u0015\r\u0011\"\u0001J\u0011!i\u0005A!A!\u0002\u0013Q\u0005\u0002\u0003(\u0001\u0005\u000b\u0007I\u0011A(\t\u0011Y\u0003!\u0011!Q\u0001\nAC\u0001b\u0016\u0001\u0003\u0006\u0004%\t\u0001\u0017\u0005\t9\u0002\u0011\t\u0011)A\u00053\"AQ\f\u0001B\u0001B\u0003%a\f\u0003\u0005k\u0001\t\u0005\t\u0015!\u0003K\u0011!Y\u0007A!A!\u0002\u0013a\u0004\u0002\u00037\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u0011I\u0002!Q1A\u0005\n5D\u0001b\u001d\u0001\u0003\u0002\u0003\u0006IA\u001c\u0005\ti\u0002\u0011)\u0019!C\u0001k\"I\u00111\u0001\u0001\u0003\u0002\u0003\u0006IA\u001e\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011%\t\t\u0003\u0001b\u0001\n\u0013\t\u0019\u0003\u0003\u0005\u0002>\u0001\u0001\u000b\u0011BA\u0013\u0011%\ty\u0004\u0001b\u0001\n\u0013\t\t\u0005\u0003\u0005\u0002P\u0001\u0001\u000b\u0011BA\"\u0011%\t\t\u0006\u0001b\u0001\n\u0003\t\u0019\u0006\u0003\u0005\u0002l\u0001\u0001\u000b\u0011BA+\u0011\u001d\ti\u0007\u0001C\u0001\u0003_Bq!a\u001f\u0001\t\u0003\ti\bC\u0004\u0002\u0004\u0002!\t!!\"\u0003/-\u000bgm[1SKF,Xm\u001d;IC:$G.\u001a:Q_>d'B\u0001\u0010 \u0003\u0019\u0019XM\u001d<fe*\t\u0001%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001\u0019\u0013f\f\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005)jS\"A\u0016\u000b\u00051z\u0012!B;uS2\u001c\u0018B\u0001\u0018,\u0005\u001daunZ4j]\u001e\u0004\"\u0001M\u001a\u000e\u0003ER!AM\u0010\u0002\u000f5,GO]5dg&\u0011A'\r\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018AB2p]\u001aLw\r\u0005\u00028q5\tQ$\u0003\u0002:;\tY1*\u00194lC\u000e{gNZ5h\u0003%\u0019G.^:uKJLE-F\u0001=!\tiDI\u0004\u0002?\u0005B\u0011q(J\u0007\u0002\u0001*\u0011\u0011)I\u0001\u0007yI|w\u000e\u001e \n\u0005\r+\u0013A\u0002)sK\u0012,g-\u0003\u0002F\r\n11\u000b\u001e:j]\u001eT!aQ\u0013\u0002\u0015\rdWo\u001d;fe&#\u0007%\u0001\u0005ce>\\WM]%e+\u0005Q\u0005C\u0001\u0013L\u0013\taUEA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u001dI,\u0017/^3ti\u000eC\u0017M\u001c8fYV\t\u0001\u000b\u0005\u0002R)6\t!K\u0003\u0002T?\u00059a.\u001a;x_J\\\u0017BA+S\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2\fqB]3rk\u0016\u001cHo\u00115b]:,G\u000eI\u0001\u0005CBL7/F\u0001Z!\t9$,\u0003\u0002\\;\t\t\u0012\t]5SKF,Xm\u001d;IC:$G.\u001a:\u0002\u000b\u0005\u0004\u0018n\u001d\u0011\u0002\tQLW.\u001a\t\u0003?\"l\u0011\u0001\u0019\u0006\u0003Y\u0005T!AY2\u0002\r\r|W.\\8o\u0015\t\u0001CM\u0003\u0002fM\u00061\u0011\r]1dQ\u0016T\u0011aZ\u0001\u0004_J<\u0017BA5a\u0005\u0011!\u0016.\\3\u0002\u00159,X\u000e\u00165sK\u0006$7/A\u0010sKF,Xm\u001d;IC:$G.\u001a:Bm\u001eLE\r\\3NKR\u0014\u0018n\u0019(b[\u0016\fa\u0003\\8h\u0003:$G\u000b\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e_\u000b\u0002]B\u0011q.]\u0007\u0002a*\u0011!'Y\u0005\u0003eB\u0014q!T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003I\twm\u001a:fO\u0006$X-\u00133mK6+G/\u001a:\u0016\u0003Y\u0004\"a^@\u000e\u0003aT!!\u001f>\u0002\t\r|'/\u001a\u0006\u0003emT!\u0001`?\u0002\re\fW.\\3s\u0015\u0005q\u0018aA2p[&\u0019\u0011\u0011\u0001=\u0003\u000b5+G/\u001a:\u0002'\u0005<wM]3hCR,\u0017\n\u001a7f\u001b\u0016$XM\u001d\u0011\u0002\rqJg.\u001b;?)a\tI!a\u0003\u0002\u000e\u0005=\u0011\u0011CA\n\u0003+\t9\"!\u0007\u0002\u001c\u0005u\u0011q\u0004\t\u0003o\u0001AQ!\u000e\nA\u0002YBQA\u000f\nA\u0002qBQ\u0001\u0013\nA\u0002)CQA\u0014\nA\u0002ACQa\u0016\nA\u0002eCQ!\u0018\nA\u0002yCQA\u001b\nA\u0002)CQa\u001b\nA\u0002qBQ\u0001\u001c\nA\u0002qBQA\r\nA\u00029DQ\u0001\u001e\nA\u0002Y\fa\u0002\u001e5sK\u0006$\u0007k\\8m'&TX-\u0006\u0002\u0002&A!\u0011qEA\u001d\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012AB1u_6L7M\u0003\u0003\u00020\u0005E\u0012AC2p]\u000e,(O]3oi*!\u00111GA\u001b\u0003\u0011)H/\u001b7\u000b\u0005\u0005]\u0012\u0001\u00026bm\u0006LA!a\u000f\u0002*\ti\u0011\t^8nS\u000eLe\u000e^3hKJ\fq\u0002\u001e5sK\u0006$\u0007k\\8m'&TX\rI\u0001\u001ci\"\u0014X-\u00193q_>d7)\u00199bG&$\u0018pU3og>\u0014x\n\u001d;\u0016\u0005\u0005\r\u0003#\u0002\u0013\u0002F\u0005%\u0013bAA$K\t1q\n\u001d;j_:\u00042a\\A&\u0013\r\ti\u0005\u001d\u0002\u0007'\u0016t7o\u001c:\u00029QD'/Z1ea>|GnQ1qC\u000eLG/_*f]N|'o\u00149uA\u0005I!/\u001e8oC\ndWm]\u000b\u0003\u0003+\u0002b!a\u0016\u0002b\u0005\u0015TBAA-\u0015\u0011\tY&!\u0018\u0002\u000f5,H/\u00192mK*\u0019\u0011qL\u0013\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002d\u0005e#aC!se\u0006L()\u001e4gKJ\u00042aNA4\u0013\r\tI'\b\u0002\u0014\u0017\u000647.\u0019*fcV,7\u000f\u001e%b]\u0012dWM]\u0001\u000beVtg.\u00192mKN\u0004\u0013!D2sK\u0006$X\rS1oI2,'\u000f\u0006\u0003\u0002r\u0005]\u0004c\u0001\u0013\u0002t%\u0019\u0011QO\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003sJ\u0002\u0019\u0001&\u0002\u0005%$\u0017\u0001\u0005:fg&TX\r\u00165sK\u0006$\u0007k\\8m)\u0011\t\t(a \t\r\u0005\u0005%\u00041\u0001K\u0003\u001dqWm^*ju\u0016\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u0003c\u0002")
public class KafkaRequestHandlerPool
implements KafkaMetricsGroup {
    private final String clusterId;
    private final int brokerId;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final String logAndThreadNamePrefix;
    private final Metrics metrics;
    private final Meter aggregateIdleMeter;
    private final AtomicInteger threadPoolSize;
    private final Option<Sensor> threadpoolCapacitySensorOpt;
    private final ArrayBuffer<KafkaRequestHandler> runnables;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public com.yammer.metrics.core.MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public <T> Gauge<T> newGauge(com.yammer.metrics.core.MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$(this, metricName, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(com.yammer.metrics.core.MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public void removeMetric(com.yammer.metrics.core.MetricName metricName) {
        KafkaMetricsGroup.removeMetric$(this, metricName);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public ApiRequestHandler apis() {
        return this.apis;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    private AtomicInteger threadPoolSize() {
        return this.threadPoolSize;
    }

    private Option<Sensor> threadpoolCapacitySensorOpt() {
        return this.threadpoolCapacitySensorOpt;
    }

    public ArrayBuffer<KafkaRequestHandler> runnables() {
        return this.runnables;
    }

    public synchronized void createHandler(int id) {
        this.runnables().$plus$eq((Object)new KafkaRequestHandler(id, this.clusterId(), this.brokerId(), this.aggregateIdleMeter(), this.threadPoolSize(), this.requestChannel(), this.apis(), this.time));
        Runnable daemon_runnable = (Runnable)this.runnables().apply(id);
        String daemon_name = new StringBuilder(23).append(this.logAndThreadNamePrefix).append("-kafka-request-handler-").append(id).toString();
        Object var2_3 = null;
        Object var3_2 = null;
        new KafkaThread(daemon_name, daemon_runnable, true).start();
    }

    public synchronized void resizeThreadPool(int newSize) {
        int currentSize = this.threadPoolSize().get();
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Resizing request handler thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
        if (newSize > currentSize) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(currentSize), newSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.createHandler(i));
        } else if (newSize < currentSize) {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), currentSize - newSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> ((KafkaRequestHandler)this.runnables().remove(currentSize - i)).stop());
        }
        this.threadPoolSize().set(newSize);
        this.threadpoolCapacitySensorOpt().foreach((Function1 & Serializable)sensor -> {
            sensor.record(100.0 * (double)newSize);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "shutting down");
        this.runnables().foreach((Function1 & Serializable)handler -> {
            handler.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        this.runnables().foreach((Function1 & Serializable)handler -> {
            handler.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable)() -> "shut down completely");
    }

    /*
     * WARNING - void declaration
     */
    public KafkaRequestHandlerPool(KafkaConfig config, String clusterId, int brokerId, RequestChannel requestChannel, ApiRequestHandler apis, Time time, int numThreads, String requestHandlerAvgIdleMetricName, String logAndThreadNamePrefix, Metrics metrics, Meter aggregateIdleMeter) {
        None$ none$;
        this.clusterId = clusterId;
        this.brokerId = brokerId;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        this.logAndThreadNamePrefix = logAndThreadNamePrefix;
        this.metrics = metrics;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.threadPoolSize = new AtomicInteger(numThreads);
        String string = requestHandlerAvgIdleMetricName;
        String string2 = "RequestHandlerAvgIdlePercent";
        if (string != null && string.equals(string2)) {
            void add_stat;
            void add_metricName;
            Sensor sensor = metrics.sensor("TotalIoThreadsPercentage");
            Value value = new Value();
            MetricName metricName = ThreadUsageMetrics$.MODULE$.ioThreadPoolCapacityMetricName(metrics);
            if (sensor == null) {
                throw null;
            }
            sensor.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
            metricName = null;
            value = null;
            sensor.record(100.0 * (double)numThreads);
            none$ = new Some((Object)sensor);
        } else {
            none$ = None$.MODULE$;
        }
        this.threadpoolCapacitySensorOpt = none$;
        this.logIdent_$eq(new StringBuilder(37).append("[").append(logAndThreadNamePrefix).append(" Kafka Request Handler on Broker ").append(brokerId).append("], ").toString());
        this.runnables = new ArrayBuffer(numThreads);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.createHandler(i));
    }
}

