/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.LogAppendInfo;
import kafka.log.TierLogSegment;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.TierState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001B\f\u0019\u0001uA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\na\u0001\u0011\t\u0011)A\u0005cQB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005u!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011%)\u0005A!A!\u0002\u00131\u0015\nC\u0003K\u0001\u0011\u00051\nC\u0003U\u0001\u0011ES\u000bC\u0003k\u0001\u0011E3\u000eC\u0003q\u0001\u0011E\u0013\u000fC\u0003t\u0001\u0011EC\u000fC\u0003}\u0001\u0011\u0005S\u0010C\u0004\u0002\u001e\u0001!\t%a\b\t\u0013\u0005u\u0002A1A\u0005R\u0005}\u0002\u0002CA$\u0001\u0001\u0006I!!\u0011\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L!9\u0011q\f\u0001\u0005R\u0005\u0005\u0004bBA5\u0001\u0011E\u00131\u000e\u0005\b\u0003{\u0002A\u0011KA@\u0011\u001d\t\t\u000b\u0001C)\u0003GCq!!-\u0001\t#\n\u0019LA\rSKBd\u0017nY1BYR,'\u000fT8h\t&\u00148\u000f\u00165sK\u0006$'BA\r\u001b\u0003\u0019\u0019XM\u001d<fe*\t1$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001q\u0002CA\u0010!\u001b\u0005A\u0012BA\u0011\u0019\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\fAA\\1nKB\u0011A%\f\b\u0003K-\u0002\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\u000f\u0002\rq\u0012xn\u001c;?\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0003\u0019\u0001&/\u001a3fM&\u0011af\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051J\u0013A\u00027fC\u0012,'\u000f\u0005\u0002 e%\u00111\u0007\u0007\u0002\u000f\u0019\u0016\fG-\u001a:F]\u0012\u0004v.\u001b8u\u0013\t\u0001\u0004%\u0001\u0007ce>\\WM]\"p]\u001aLw\r\u0005\u0002 o%\u0011\u0001\b\u0007\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\tgC&dW\r\u001a)beRLG/[8ogB\u0011qdO\u0005\u0003ya\u0011\u0001CR1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0002\u0015I,\u0007\u000f\\5dC6;'\u000f\u0005\u0002 \u007f%\u0011\u0001\t\u0007\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003\u0015\tXo\u001c;b!\ty2)\u0003\u0002E1\t9\"+\u001a9mS\u000e\fG/[8o#V|G/Y'b]\u0006<WM]\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN\u0004\"aH$\n\u0005!C\"\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0013\t)\u0005%\u0001\u0004=S:LGO\u0010\u000b\t\u00196su\nU)S'B\u0011q\u0004\u0001\u0005\u0006E!\u0001\ra\t\u0005\u0006a!\u0001\r!\r\u0005\u0006k!\u0001\rA\u000e\u0005\u0006s!\u0001\rA\u000f\u0005\u0006{!\u0001\rA\u0010\u0005\u0006\u0003\"\u0001\rA\u0011\u0005\u0006\u000b\"\u0001\rAR\u0001\fY\u0006$Xm\u001d;Fa>\u001c\u0007\u000e\u0006\u0002W;B\u0019q\u000b\u0017.\u000e\u0003%J!!W\u0015\u0003\r=\u0003H/[8o!\t96,\u0003\u0002]S\t\u0019\u0011J\u001c;\t\u000byK\u0001\u0019A0\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B\u0011\u0001\r[\u0007\u0002C*\u0011!mY\u0001\u0007G>lWn\u001c8\u000b\u0005m!'BA3g\u0003\u0019\t\u0007/Y2iK*\tq-A\u0002pe\u001eL!![1\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$HC\u00017p!\t9V.\u0003\u0002oS\t!Aj\u001c8h\u0011\u0015q&\u00021\u0001`\u00031awnZ#oI>3gm]3u)\ta'\u000fC\u0003_\u0017\u0001\u0007q,A\tf]\u0012|eMZ:fi\u001a{'/\u00129pG\"$2!^={!\r9\u0006L\u001e\t\u0003?]L!\u0001\u001f\r\u0003\u001d=3gm]3u\u0003:$W\t]8dQ\")a\f\u0004a\u0001?\")1\u0010\u0004a\u00015\u0006)Q\r]8dQ\u0006!\u0002O]8dKN\u001c\b+\u0019:uSRLwN\u001c#bi\u0006$rA`A\u0006\u0003\u001b\t\t\u0002E\u0002X1~\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000bQ\u0012a\u00017pO&!\u0011\u0011BA\u0002\u00055aunZ!qa\u0016tG-\u00138g_\")a,\u0004a\u0001?\"1\u0011qB\u0007A\u00021\f1BZ3uG\"|eMZ:fi\"9\u00111C\u0007A\u0002\u0005U\u0011!\u00049beRLG/[8o\t\u0006$\u0018\r\u0005\u0003\u0002\u0018\u0005eQ\"\u0001\u0001\n\u0007\u0005m\u0001EA\u0005GKR\u001c\u0007\u000eR1uC\u0006i\u0011\r\u001a3QCJ$\u0018\u000e^5p]N$B!!\t\u0002.A)\u00111EA\u0015?6\u0011\u0011Q\u0005\u0006\u0004\u0003OI\u0013AC2pY2,7\r^5p]&!\u00111FA\u0013\u0005\r\u0019V\r\u001e\u0005\b\u0003_q\u0001\u0019AA\u0019\u0003IIg.\u001b;jC24U\r^2i'R\fG/Z:\u0011\u000f\u0005\r\u00121G0\u00028%!\u0011QGA\u0013\u0005\ri\u0015\r\u001d\t\u0004?\u0005e\u0012bAA\u001e1\t\t\u0012J\\5uS\u0006dg)\u001a;dQN#\u0018\r^3\u0002?%\u001cxJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u001cV\u000f\u001d9peR,G-\u0006\u0002\u0002BA\u0019q+a\u0011\n\u0007\u0005\u0015\u0013FA\u0004C_>dW-\u00198\u0002A%\u001cxJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u001cV\u000f\u001d9peR,G\rI\u0001\tiJ,hnY1uKR1\u0011QJA*\u0003+\u00022aVA(\u0013\r\t\t&\u000b\u0002\u0005+:LG\u000fC\u0003_#\u0001\u0007q\fC\u0004\u0002XE\u0001\r!!\u0017\u0002\u001fQ\u0014XO\\2bi&|gn\u0015;bi\u0016\u00042aHA.\u0013\r\ti\u0006\u0007\u0002\u0016\u001f\u001a47/\u001a;UeVt7-\u0019;j_:\u001cF/\u0019;f\u0003]!(/\u001e8dCR,g)\u001e7ms\u0006sGm\u0015;beR\fE\u000f\u0006\u0004\u0002N\u0005\r\u0014Q\r\u0005\u0006=J\u0001\ra\u0018\u0005\u0007\u0003O\u0012\u0002\u0019\u00017\u0002\r=4gm]3u\u0003IygNU3ti>\u0014X\rV5feN#\u0018\r^3\u0015\u0011\u00055\u0013QNA8\u0003gBQAX\nA\u0002}Ca!!\u001d\u0014\u0001\u0004a\u0017!\u00069s_B|7/\u001a3M_\u000e\fG\u000eT8h'R\f'\u000f\u001e\u0005\b\u0003k\u001a\u0002\u0019AA<\u0003%!\u0018.\u001a:Ti\u0006$X\rE\u0002 \u0003sJ1!a\u001f\u0019\u0005%!\u0016.\u001a:Ti\u0006$X-\u0001\bgKR\u001c\u0007\u000eV5feN#\u0018\r^3\u0015\r\u0005\u0005\u0015QSAL!\u0019\t\u0019)!%\u0002x5\u0011\u0011Q\u0011\u0006\u0005\u0003\u000f\u000bI)\u0001\u0006d_:\u001cWO\u001d:f]RTA!a#\u0002\u000e\u0006!Q\u000f^5m\u0015\t\ty)\u0001\u0003kCZ\f\u0017\u0002BAJ\u0003\u000b\u0013\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f\u0011\u0015qF\u00031\u0001`\u0011\u001d\tI\n\u0006a\u0001\u00037\u000b1\u0002^5feN+w-\\3oiB!\u0011\u0011AAO\u0013\u0011\ty*a\u0001\u0003\u001dQKWM\u001d'pON+w-\\3oi\u0006yR.\u0019;fe&\fG.\u001b>f)&,'o\u0015;bi\u0016,f\u000e^5m\u001f\u001a47/\u001a;\u0015\r\u0005\u0015\u00161VAW!\u0019\t\u0019)a*\u0002\u001c&!\u0011\u0011VAC\u0005\u00191U\u000f^;sK\")a,\u0006a\u0001?\"1\u0011qV\u000bA\u00021\fA\u0002^1sO\u0016$xJ\u001a4tKR\f\u0011%\\1uKJL\u0017\r\\5{KRKWM]*uCR,WK\u001c;jY>\u0013'.Z2u\u0013\u0012$\"\"!*\u00026\u0006]\u0016\u0011XAc\u0011\u0015qf\u00031\u0001`\u0011\u0019\tyK\u0006a\u0001Y\"9\u00111\u0018\fA\u0002\u0005u\u0016A\u0004;be\u001e,Go\u00142kK\u000e$\u0018\n\u001a\t\u0005\u0003\u007f\u000b\t-\u0004\u0002\u0002\n&!\u00111YAE\u0005\u0011)V+\u0013#\t\r\u0005\u001dg\u00031\u0001[\u0003I!\u0018M]4fiJ+7\u000f^8sK\u0016\u0003xn\u00195")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final boolean isOffsetForLeaderEpochSupported;

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        AbstractLog futureLog = partition.futureLocalLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        if (fetchOffset != futureLog.logEndOffset()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureLog.logEndOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = records.sizeInBytes() > 0 ? partition.appendRecordsToFollowerOrFutureReplica(records, true) : None$.MODULE$;
        futureLog.updateHighWatermark(partitionData.highWatermark());
        futureLog.maybeIncrementLogStartOffset(partitionData.logStartOffset(), LeaderOffsetIncremented$.MODULE$);
        if (partition.maybeReplaceCurrentWithFutureReplica()) {
            this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates) {
        Set<TopicPartition> set;
        this.partitionMapLock().lockInterruptibly();
        try {
            Map filteredFetchStates = (Map)initialFetchStates.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$addPartitions$1(this, x0$1)));
            set = super.addPartitions((Map<TopicPartition, InitialFetchState>)filteredFetchStates);
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateTo(truncationState.offset(), true);
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateFullyAndStartAt(offset, true);
    }

    @Override
    public void onRestoreTierState(TopicPartition topicPartition, long proposedLocalLogStart, TierState tierState) {
        throw new UnsupportedOperationException("Restoring tier state during an alter log dirs operation is not currently supported.");
    }

    public CompletableFuture<TierState> fetchTierState(TopicPartition topicPartition, TierLogSegment tierSegment) {
        throw new UnsupportedOperationException("Fetching tier state during an alter log dirs operation is not currently supported.");
    }

    @Override
    public Future<TierLogSegment> materializeTierStateUntilOffset(TopicPartition topicPartition, long targetOffset) {
        throw new UnsupportedOperationException("Materializing tier state is not supported with alter log dirs.");
    }

    @Override
    public Future<TierLogSegment> materializeTierStateUntilObjectId(TopicPartition topicPartition, long targetOffset, UUID targetObjectId, int targetRestoreEpoch) {
        throw new UnsupportedOperationException("Materializing tier state is not supported with alter log dirs.");
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            return $this.replicaMgr.futureLogExists(tp);
        }
        throw new MatchError(null);
    }

    public ReplicaAlterLogDirsThread(String name, LeaderEndPoint leader, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        super(name, name, leader, failedPartitions, new ExponentialBackoff(brokerConfig.replicaFetchBackoffMs().longValue(), 2, brokerConfig.replicaFetchBackoffMaxMs().longValue(), 0.0), false, brokerTopicStats, (Map<String, String>)((Map)Map$.MODULE$.empty()));
        this.isOffsetForLeaderEpochSupported = true;
    }
}

