/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherManager;
import kafka.server.BrokerBlockingSender;
import kafka.server.BrokerBlockingSender$;
import kafka.server.FailedPartitions;
import kafka.server.FetchConnectionsMode;
import kafka.server.FetchConnectionsMode$Isolated$;
import kafka.server.FetcherPool;
import kafka.server.FollowerFetchThrottler;
import kafka.server.KafkaConfig;
import kafka.server.RemoteLeaderEndPoint;
import kafka.server.RemoteLeaderRequestBuilder;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.utils.Scheduler;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ub\u0001B\t\u0013\u0001]A\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tG\u0001\u0011)\u0019!C\tI!A\u0001\u0006\u0001B\u0001B\u0003%Q\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0011!1\u0004A!A!\u0002\u00139\u0004\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u0011=\u0003!\u0011!Q\u0001\nAC\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\t3\u0002\u0011\t\u0011)A\u00055\")1\r\u0001C\u0001I\")a\u000e\u0001C!_\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001dq!CA\b%\u0005\u0005\t\u0012AA\t\r!\t\"#!A\t\u0002\u0005M\u0001BB2\u000f\t\u0003\tY\u0002C\u0005\u0002\u001e9\t\n\u0011\"\u0001\u0002 \t)\"+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014(BA\n\u0015\u0003\u0019\u0019XM\u001d<fe*\tQ#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0002cA\r\u001b95\t!#\u0003\u0002\u001c%\t1\u0012IY:ue\u0006\u001cGOR3uG\",'/T1oC\u001e,'\u000f\u0005\u0002\u001a;%\u0011aD\u0005\u0002\u0015%\u0016\u0004H.[2b\r\u0016$8\r[3s)\"\u0014X-\u00193\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0011\u0005e\t\u0013B\u0001\u0012\u0013\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\tQ\u0005\u0005\u0002\u001aM%\u0011qE\u0005\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013aB7fiJL7m\u001d\t\u0003WQj\u0011\u0001\f\u0006\u0003S5R!AL\u0018\u0002\r\r|W.\\8o\u0015\t)\u0002G\u0003\u00022e\u00051\u0011\r]1dQ\u0016T\u0011aM\u0001\u0004_J<\u0017BA\u001b-\u0005\u001diU\r\u001e:jGN\fA\u0001^5nKB\u0011\u0001hO\u0007\u0002s)\u0011!(L\u0001\u0006kRLGn]\u0005\u0003ye\u0012A\u0001V5nK\u0006\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\t\u0004\u007f\t#U\"\u0001!\u000b\u0003\u0005\u000bQa]2bY\u0006L!a\u0011!\u0003\r=\u0003H/[8o!\t)EJ\u0004\u0002G\u0015B\u0011q\tQ\u0007\u0002\u0011*\u0011\u0011JF\u0001\u0007yI|w\u000e\u001e \n\u0005-\u0003\u0015A\u0002)sK\u0012,g-\u0003\u0002N\u001d\n11\u000b\u001e:j]\u001eT!a\u0013!\u0002\u0019E,x\u000e^1NC:\fw-\u001a:\u0011\u0005e\t\u0016B\u0001*\u0013\u0005]\u0011V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018-T1oC\u001e,'/A\u0005tG\",G-\u001e7feB\u0011QkV\u0007\u0002-*\u0011!\bF\u0005\u00031Z\u0013\u0011bU2iK\u0012,H.\u001a:\u0002/5,G/\u00193bi\u00064VM]:j_:\u001cV\u000f\u001d9mS\u0016\u0014\bcA \\;&\u0011A\f\u0011\u0002\n\rVt7\r^5p]B\u0002\"AX1\u000e\u0003}S!A\f1\u000b\u0005My\u0013B\u00012`\u0005=iU\r^1eCR\fg+\u001a:tS>t\u0017A\u0002\u001fj]&$h\bF\u0005fM\u001eD\u0017N[6m[B\u0011\u0011\u0004\u0001\u0005\u0006?)\u0001\r\u0001\t\u0005\u0006G)\u0001\r!\n\u0005\u0006S)\u0001\rA\u000b\u0005\u0006m)\u0001\ra\u000e\u0005\b{)\u0001\n\u00111\u0001?\u0011\u0015y%\u00021\u0001Q\u0011\u0015\u0019&\u00021\u0001U\u0011\u0015I&\u00021\u0001[\u0003M\u0019'/Z1uK\u001a+Go\u00195feRC'/Z1e)\u0011a\u0002/^?\t\u000bE\\\u0001\u0019\u0001:\u0002\u0013\u0019,Go\u00195fe&#\u0007CA t\u0013\t!\bIA\u0002J]RDQA^\u0006A\u0002]\fAb]8ve\u000e,'I]8lKJ\u0004\"\u0001_>\u000e\u0003eT!A\u001f\u000b\u0002\u000f\rdWo\u001d;fe&\u0011A0\u001f\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u0011\u0015q8\u00021\u0001\u0000\u0003-1W\r^2iKJ\u0004vn\u001c7\u0011\u0007e\t\t!C\u0002\u0002\u0004I\u00111BR3uG\",'\u000fU8pY\u0006A1\u000f[;uI><h\u000e\u0006\u0002\u0002\nA\u0019q(a\u0003\n\u0007\u00055\u0001I\u0001\u0003V]&$\u0018!\u0006*fa2L7-\u0019$fi\u000eDWM]'b]\u0006<WM\u001d\t\u000339\u00192ADA\u000b!\ry\u0014qC\u0005\u0004\u00033\u0001%AB!osJ+g\r\u0006\u0002\u0002\u0012\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"!!\t+\u0007y\n\u0019c\u000b\u0002\u0002&A!\u0011qEA\u0019\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012!C;oG\",7m[3e\u0015\r\ty\u0003Q\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001a\u0003S\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ReplicaFetcherManager
extends AbstractFetcherManager<ReplicaFetcherThread> {
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaManager;
    private final Metrics metrics;
    private final Time time;
    private final Option<String> threadNamePrefix;
    private final ReplicationQuotaManager quotaManager;
    private final Function0<MetadataVersion> metadataVersionSupplier;

    public static Option<String> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    @Override
    public ReplicaFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
        String prefix = (String)this.threadNamePrefix.map((Function1 & Serializable)tp -> new StringBuilder(1).append((String)tp).append(":").toString()).getOrElse((Function0 & Serializable)() -> "");
        String threadName = new StringBuilder(23).append(prefix).append("ReplicaFetcherThread-").append(fetcherId).append("-").append(sourceBroker.id()).append("-").append(fetcherPool.name()).toString();
        Map tags = (Map)Map$.MODULE$.empty();
        FetchConnectionsMode fetchConnectionsMode = this.replicaFetchConnectionsMode();
        FetchConnectionsMode$Isolated$ fetchConnectionsMode$Isolated$ = FetchConnectionsMode$Isolated$.MODULE$;
        if (fetchConnectionsMode != null && fetchConnectionsMode.equals(fetchConnectionsMode$Isolated$)) {
            tags = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FetcherPool"), (Object)fetcherPool.name())}));
        }
        LogContext logContext = new LogContext(new StringBuilder(51).append("[ReplicaFetcher replicaId=").append(this.brokerConfig.brokerId()).append(", leaderId=").append(sourceBroker.id()).append(", fetcherId=").append(fetcherId).append("] ").toString());
        BrokerBlockingSender endpoint = BrokerBlockingSender$.MODULE$.apply(sourceBroker, this.brokerConfig, this.metrics, this.time, fetcherId, new StringBuilder(16).append("broker-").append(this.brokerConfig.brokerId()).append("-fetcher-").append(fetcherId).toString(), logContext, (Map<String, String>)tags);
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(logContext, sourceBroker.id());
        RemoteLeaderRequestBuilder requestBuilder = new RemoteLeaderRequestBuilder(this.brokerConfig, this.metadataVersionSupplier);
        FollowerFetchThrottler throttler = new FollowerFetchThrottler();
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), endpoint, fetchSessionHandler, requestBuilder, throttler, this.brokerConfig, this.replicaManager(), this.quotaManager, this.metadataVersionSupplier);
        KafkaConfig x$4 = this.brokerConfig;
        FailedPartitions x$5 = this.failedPartitions();
        ReplicaManager x$6 = this.replicaManager();
        ReplicationQuotaManager x$7 = this.quotaManager;
        Function0<MetadataVersion> x$9 = this.metadataVersionSupplier;
        None$ x$10 = None$.MODULE$;
        None$ x$11 = None$.MODULE$;
        None$ x$12 = None$.MODULE$;
        return new ReplicaFetcherThread(threadName, fetcherId, leader, x$4, x$5, x$6, x$7, (Option<LogContext>)x$10, (Map<String, String>)tags, (Option<Object>)x$11, (Option<Object>)x$12, x$9);
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "shutting down");
        this.closeAllFetchers();
        this.info((Function0<String>)(Function0 & Serializable)() -> "shutdown completed");
    }

    public ReplicaFetcherManager(KafkaConfig brokerConfig, ReplicaManager replicaManager, Metrics metrics, Time time, Option<String> threadNamePrefix, ReplicationQuotaManager quotaManager, Scheduler scheduler, Function0<MetadataVersion> metadataVersionSupplier) {
        this.brokerConfig = brokerConfig;
        this.replicaManager = replicaManager;
        this.metrics = metrics;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        this.quotaManager = quotaManager;
        this.metadataVersionSupplier = metadataVersionSupplier;
        super(new StringBuilder(32).append("ReplicaFetcherManager on broker ").append(brokerConfig.brokerId()).toString(), "Replica", Predef$.MODULE$.Integer2int(brokerConfig.numReplicaFetchers()), brokerConfig.replicaFetchConnectionsMode(), (Option<Scheduler>)new Some((Object)scheduler), (Map<String, String>)((Map)Map$.MODULE$.empty()));
    }
}

