/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import io.confluent.kafka.availability.FileChannelWrapper;
import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.KafkaConfig;
import kafka.server.StorageProbe$LogDirMetrics$;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tMg\u0001B A\u0001\u0015C\u0001\"\u0018\u0001\u0003\u0006\u0004%IA\u0018\u0005\tG\u0002\u0011\t\u0011)A\u0005?\"AA\r\u0001BC\u0002\u0013%Q\r\u0003\u0005s\u0001\t\u0005\t\u0015!\u0003g\u0011!\u0019\bA!b\u0001\n\u0013!\b\u0002C>\u0001\u0005\u0003\u0005\u000b\u0011B;\t\u000bq\u0004A\u0011A?\t\u0013\u0005\u0015\u0001A1A\u0005\n\u0005\u001d\u0001\u0002CA\b\u0001\u0001\u0006I!!\u0003\t\u0013\u0005E\u0001A1A\u0005\n\u0005M\u0001\u0002CA\u000e\u0001\u0001\u0006I!!\u0006\t\u0013\u0005u\u0001A1A\u0005\n\u0005M\u0001\u0002CA\u0010\u0001\u0001\u0006I!!\u0006\t\u0013\u0005\u0005\u0002A1A\u0005\n\u0005\r\u0002\u0002CA\u001d\u0001\u0001\u0006I!!\n\t\u0017\u0005m\u0002\u00011AA\u0002\u0013%\u0011Q\b\u0005\f\u0003\u000b\u0002\u0001\u0019!a\u0001\n\u0013\t9\u0005C\u0006\u0002T\u0001\u0001\r\u0011!Q!\n\u0005}\u0002\u0002\u0003+\u0001\u0001\u0004%I!!\u0016\t\u0013\tE\u0003\u00011A\u0005\n\tM\u0003\u0002\u0003B,\u0001\u0001\u0006K!a\u0016\t\u0013\te\u0003A1A\u0005\n\u0005\u001d\u0001\u0002\u0003B.\u0001\u0001\u0006I!!\u0003\t\u000f\tu\u0003\u0001\"\u0001\u0003`!9!\u0011\r\u0001\u0005\u0002\t}\u0003b\u0002B2\u0001\u0011\u0005!Q\r\u0005\b\u0005g\u0002A\u0011\u0001B;\u0011\u001d\u0011i\b\u0001C\u0001\u0005?2a!a\u001d\u0001\u0001\u0006U\u0004BCAE;\tU\r\u0011\"\u0001\u0002\f\"Q\u00111T\u000f\u0003\u0012\u0003\u0006I!!$\t\u0015\u0005uUD!f\u0001\n\u0003\ty\n\u0003\u0006\u0002(v\u0011\t\u0012)A\u0005\u0003CC!\"!+\u001e\u0005+\u0007I\u0011AAV\u0011)\t\u0019-\bB\tB\u0003%\u0011Q\u0016\u0005\u000b\u0003\u000bl\"Q3A\u0005\u0002\u0005\u001d\u0007BCAk;\tE\t\u0015!\u0003\u0002J\"1A0\bC\u0001\u0003/D\u0011\"!9\u001e\u0003\u0003%\t!a9\t\u0013\u00055X$%A\u0005\u0002\u0005=\b\"\u0003B\u0003;E\u0005I\u0011\u0001B\u0004\u0011%\u0011Y!HI\u0001\n\u0003\u0011i\u0001C\u0005\u0003\u0012u\t\n\u0011\"\u0001\u0003\u0014!I!qC\u000f\u0002\u0002\u0013\u0005\u00131\u0003\u0005\n\u00053i\u0012\u0011!C\u0001\u0003\u000fA\u0011Ba\u0007\u001e\u0003\u0003%\tA!\b\t\u0013\t\u001dR$!A\u0005B\t%\u0002\"\u0003B\u001c;\u0005\u0005I\u0011\u0001B\u001d\u0011%\u0011i$HA\u0001\n\u0003\u0012y\u0004C\u0005\u0003Du\t\t\u0011\"\u0011\u0003F!I!qI\u000f\u0002\u0002\u0013\u0005#\u0011\n\u0005\n\u0005\u0017j\u0012\u0011!C!\u0005\u001b:\u0011Ba\"\u0001\u0003\u0003E\tA!#\u0007\u0013\u0005M\u0004!!A\t\u0002\t-\u0005B\u0002?7\t\u0003\u0011\u0019\u000bC\u0005\u0003HY\n\t\u0011\"\u0012\u0003J!I!Q\u0015\u001c\u0002\u0002\u0013\u0005%q\u0015\u0005\n\u0005c3\u0014\u0011!CA\u0005g;\u0011B!2A\u0003\u0003E\tAa2\u0007\u0011}\u0002\u0015\u0011!E\u0001\u0005\u0013Da\u0001 \u001f\u0005\u0002\t-\u0007\"\u0003BgyE\u0005I\u0011\u0001Bh\u00051\u0019Fo\u001c:bO\u0016\u0004&o\u001c2f\u0015\t\t%)\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0007\u0006)1.\u00194lC\u000e\u00011#\u0002\u0001G\u001dF;\u0006CA$M\u001b\u0005A%BA%K\u0003\u0011a\u0017M\\4\u000b\u0003-\u000bAA[1wC&\u0011Q\n\u0013\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u001d{\u0015B\u0001)I\u0005!\u0011VO\u001c8bE2,\u0007C\u0001*V\u001b\u0005\u0019&B\u0001+C\u0003\u001diW\r\u001e:jGNL!AV*\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b\u000f\u0005\u0002Y76\t\u0011L\u0003\u0002[\u0005\u0006)Q\u000f^5mg&\u0011A,\u0017\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jOV\tq\f\u0005\u0002aC6\t\u0001)\u0003\u0002c\u0001\nY1*\u00194lC\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\nA\u0001^5nKV\ta\r\u0005\u0002ha6\t\u0001N\u0003\u0002[S*\u0011!n[\u0001\u0007G>lWn\u001c8\u000b\u0005\rc'BA7o\u0003\u0019\t\u0007/Y2iK*\tq.A\u0002pe\u001eL!!\u001d5\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\fgR\f'\u000f\u001e+ie\u0016\fG-F\u0001v!\t1\u00180D\u0001x\u0015\u0005A\u0018!B:dC2\f\u0017B\u0001>x\u0005\u001d\u0011un\u001c7fC:\fAb\u001d;beR$\u0006N]3bI\u0002\na\u0001P5oSRtDC\u0002@\u0000\u0003\u0003\t\u0019\u0001\u0005\u0002a\u0001!)Ql\u0002a\u0001?\")Am\u0002a\u0001M\"91o\u0002I\u0001\u0002\u0004)\u0018a\u0002<feNLwN\\\u000b\u0003\u0003\u0013\u00012A^A\u0006\u0013\r\tia\u001e\u0002\u0004\u0013:$\u0018\u0001\u0003<feNLwN\u001c\u0011\u0002#1\fG/\u001a8ds6+GO]5d\u001d\u0006lW-\u0006\u0002\u0002\u0016A\u0019q)a\u0006\n\u0007\u0005e\u0001J\u0001\u0004TiJLgnZ\u0001\u0013Y\u0006$XM\\2z\u001b\u0016$(/[2OC6,\u0007%\u0001\fdkJ\u0014XM\u001c;Xe&$X-T3ue&\u001cg*Y7f\u0003]\u0019WO\u001d:f]R<&/\u001b;f\u001b\u0016$(/[2OC6,\u0007%\u0001\u0007tQV$Hm\\<o\r2\fw-\u0006\u0002\u0002&A!\u0011qEA\u001b\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012AB1u_6L7M\u0003\u0003\u00020\u0005E\u0012AC2p]\u000e,(O]3oi*\u0019\u00111\u0007&\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003o\tICA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u000eg\",H\u000fZ8x]\u001ac\u0017m\u001a\u0011\u0002\rQD'/Z1e+\t\ty\u0004E\u0002h\u0003\u0003J1!a\u0011i\u0005-Y\u0015MZ6b)\"\u0014X-\u00193\u0002\u0015QD'/Z1e?\u0012*\u0017\u000f\u0006\u0003\u0002J\u0005=\u0003c\u0001<\u0002L%\u0019\u0011QJ<\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003#\n\u0012\u0011!a\u0001\u0003\u007f\t1\u0001\u001f\u00132\u0003\u001d!\bN]3bI\u0002*\"!a\u0016\u0011\r\u0005e\u0013\u0011NA8\u001d\u0011\tY&!\u001a\u000f\t\u0005u\u00131M\u0007\u0003\u0003?R1!!\u0019E\u0003\u0019a$o\\8u}%\t\u00010C\u0002\u0002h]\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002l\u00055$\u0001\u0002'jgRT1!a\u001ax!\r\t\t(H\u0007\u0002\u0001\tiAj\\4ESJlU\r\u001e:jGN\u001cr!HA<\u0003{\n\u0019\tE\u0002w\u0003sJ1!a\u001fx\u0005\u0019\te.\u001f*fMB\u0019a/a \n\u0007\u0005\u0005uOA\u0004Qe>$Wo\u0019;\u0011\t\u0005e\u0013QQ\u0005\u0005\u0003\u000f\u000biG\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003oC6,WCAAG!\u0011\ty)a&\u000f\t\u0005E\u00151\u0013\t\u0004\u0003;:\u0018bAAKo\u00061\u0001K]3eK\u001aLA!!\u0007\u0002\u001a*\u0019\u0011QS<\u0002\u000b9\fW.\u001a\u0011\u0002+\r,(O]3oi^\u0013\u0018\u000e^3Ti\u0006\u0014H/\u001a3NgV\u0011\u0011\u0011\u0015\t\u0005\u0003O\t\u0019+\u0003\u0003\u0002&\u0006%\"AC!u_6L7\rT8oO\u000612-\u001e:sK:$xK]5uKN#\u0018M\u001d;fI6\u001b\b%A\u0005iSN$xn\u001a:b[V\u0011\u0011Q\u0016\t\u0005\u0003_\u000by,\u0004\u0002\u00022*!\u00111WA[\u0003\u0011\u0019wN]3\u000b\u0007Q\u000b9L\u0003\u0003\u0002:\u0006m\u0016AB=b[6,'O\u0003\u0002\u0002>\u0006\u00191m\\7\n\t\u0005\u0005\u0017\u0011\u0017\u0002\n\u0011&\u001cHo\\4sC6\f!\u0002[5ti><'/Y7!\u0003%AW-\u0019:uE\u0016\fG/\u0006\u0002\u0002JB1\u0011qVAf\u0003\u001fLA!!4\u00022\n)q)Y;hKB\u0019a/!5\n\u0007\u0005MwO\u0001\u0003M_:<\u0017A\u00035fCJ$(-Z1uAQQ\u0011qNAm\u00037\fi.a8\t\u000f\u0005%e\u00051\u0001\u0002\u000e\"9\u0011Q\u0014\u0014A\u0002\u0005\u0005\u0006bBAUM\u0001\u0007\u0011Q\u0016\u0005\b\u0003\u000b4\u0003\u0019AAe\u0003\u0011\u0019w\u000e]=\u0015\u0015\u0005=\u0014Q]At\u0003S\fY\u000fC\u0005\u0002\n\u001e\u0002\n\u00111\u0001\u0002\u000e\"I\u0011QT\u0014\u0011\u0002\u0003\u0007\u0011\u0011\u0015\u0005\n\u0003S;\u0003\u0013!a\u0001\u0003[C\u0011\"!2(!\u0003\u0005\r!!3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u001f\u0016\u0005\u0003\u001b\u000b\u0019p\u000b\u0002\u0002vB!\u0011q\u001fB\u0001\u001b\t\tIP\u0003\u0003\u0002|\u0006u\u0018!C;oG\",7m[3e\u0015\r\typ^\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0002\u0003s\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!\u0003+\t\u0005\u0005\u00161_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011yA\u000b\u0003\u0002.\u0006M\u0018AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005+QC!!3\u0002t\u0006i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003 \t\u0015\u0002c\u0001<\u0003\"%\u0019!1E<\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002R9\n\t\u00111\u0001\u0002\n\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003,A1!Q\u0006B\u001a\u0005?i!Aa\f\u000b\u0007\tEr/\u0001\u0006d_2dWm\u0019;j_:LAA!\u000e\u00030\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r)(1\b\u0005\n\u0003#\u0002\u0014\u0011!a\u0001\u0005?\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011Q\u0003B!\u0011%\t\t&MA\u0001\u0002\u0004\tI!\u0001\u0005iCND7i\u001c3f)\t\tI!\u0001\u0005u_N#(/\u001b8h)\t\t)\"\u0001\u0004fcV\fGn\u001d\u000b\u0004k\n=\u0003\"CA)i\u0005\u0005\t\u0019\u0001B\u0010\u0003-iW\r\u001e:jGN|F%Z9\u0015\t\u0005%#Q\u000b\u0005\n\u0003#\"\u0012\u0011!a\u0001\u0003/\n\u0001\"\\3ue&\u001c7\u000fI\u0001\u0019oJLG/\u001a+j[\u0016<\u0016M\u001d8UQJ,7\u000f[8mI6\u001b\u0018!G<sSR,G+[7f/\u0006\u0014h\u000e\u00165sKNDw\u000e\u001c3Ng\u0002\nqa\u001d;beR,\b\u000f\u0006\u0002\u0002J\u0005A1\u000f[;uI><h.A\u0004qCfdw.\u00193\u0015\u0005\t\u001d\u0004\u0003\u0002B5\u0005_j!Aa\u001b\u000b\u0007\t5$*A\u0002oS>LAA!\u001d\u0003l\tQ!)\u001f;f\u0005V4g-\u001a:\u0002\u000bA\u0014xNY3\u0015\u0005\t]\u0004\u0003CAH\u0005s\ni)a4\n\t\tm\u0014\u0011\u0014\u0002\u0004\u001b\u0006\u0004\u0018a\u0001:v]\"\u001aAD!!\u0011\u0007\u001d\u0013\u0019)C\u0002\u0003\u0006\"\u0013\u0001b\u0014<feJLG-Z\u0001\u000e\u0019><G)\u001b:NKR\u0014\u0018nY:\u0011\u0007\u0005EdgE\u00037\u0005\u001b\u0013I\n\u0005\b\u0003\u0010\nU\u0015QRAQ\u0003[\u000bI-a\u001c\u000e\u0005\tE%b\u0001BJo\u00069!/\u001e8uS6,\u0017\u0002\u0002BL\u0005#\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85!\u0011\u0011YJ!)\u000e\u0005\tu%b\u0001BP\u0015\u0006\u0011\u0011n\\\u0005\u0005\u0003\u000f\u0013i\n\u0006\u0002\u0003\n\u0006)\u0011\r\u001d9msRQ\u0011q\u000eBU\u0005W\u0013iKa,\t\u000f\u0005%\u0015\b1\u0001\u0002\u000e\"9\u0011QT\u001dA\u0002\u0005\u0005\u0006bBAUs\u0001\u0007\u0011Q\u0016\u0005\b\u0003\u000bL\u0004\u0019AAe\u0003\u001d)h.\u00199qYf$BA!.\u0003BB)aOa.\u0003<&\u0019!\u0011X<\u0003\r=\u0003H/[8o!-1(QXAG\u0003C\u000bi+!3\n\u0007\t}vO\u0001\u0004UkBdW\r\u000e\u0005\n\u0005\u0007T\u0014\u0011!a\u0001\u0003_\n1\u0001\u001f\u00131\u00031\u0019Fo\u001c:bO\u0016\u0004&o\u001c2f!\t\u0001GhE\u0002=\u0003o\"\"Aa2\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\tNK\u0002v\u0003g\u0004")
public class StorageProbe
implements Runnable,
KafkaMetricsGroup {
    private volatile StorageProbe$LogDirMetrics$ LogDirMetrics$module;
    private final KafkaConfig config;
    private final Time time;
    private final boolean startThread;
    private final int version;
    private final String latencyMetricName;
    private final String currentWriteMetricName;
    private final AtomicBoolean shutdownFlag;
    private KafkaThread thread;
    private List<LogDirMetrics> metrics;
    private final int writeTimeWarnThresholdMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return true;
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$(this, metricName, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$(this, metricName);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public StorageProbe$LogDirMetrics$ LogDirMetrics() {
        if (this.LogDirMetrics$module == null) {
            this.LogDirMetrics$lzycompute$1();
        }
        return this.LogDirMetrics$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private Time time() {
        return this.time;
    }

    private boolean startThread() {
        return this.startThread;
    }

    private int version() {
        return this.version;
    }

    private String latencyMetricName() {
        return this.latencyMetricName;
    }

    private String currentWriteMetricName() {
        return this.currentWriteMetricName;
    }

    private AtomicBoolean shutdownFlag() {
        return this.shutdownFlag;
    }

    private KafkaThread thread() {
        return this.thread;
    }

    private void thread_$eq(KafkaThread x$1) {
        this.thread = x$1;
    }

    private List<LogDirMetrics> metrics() {
        return this.metrics;
    }

    private void metrics_$eq(List<LogDirMetrics> x$1) {
        this.metrics = x$1;
    }

    private int writeTimeWarnThresholdMs() {
        return this.writeTimeWarnThresholdMs;
    }

    public void startup() {
        if (Predef$.MODULE$.Long2long(this.config().confluentConfig().storageProbePeriodMs()) > 0L) {
            this.metrics_$eq((List<LogDirMetrics>)((IterableOnceOps)this.config().logDirs().map((Function1 & Serializable)logDir -> {
                scala.collection.immutable.Map tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logdir"), logDir)}));
                AtomicLong currentWriteTimeStartedMs = new AtomicLong(-1L);
                return new LogDirMetrics(this, (String)logDir, currentWriteTimeStartedMs, this.newHistogram(this.latencyMetricName(), true, (Map<String, String>)tags), this.newGauge(this.currentWriteMetricName(), new Gauge<Object>(this, currentWriteTimeStartedMs){
                    private final /* synthetic */ StorageProbe $outer;
                    private final AtomicLong currentWriteTimeStartedMs$1;

                    public final long value() {
                        return this.$outer.kafka$server$StorageProbe$$$anonfun$startup$2(this.currentWriteTimeStartedMs$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.currentWriteTimeStartedMs$1 = currentWriteTimeStartedMs$1;
                    }
                }, (Map<String, String>)tags));
            })).toList());
            String nonDaemon_name = "StorageProbe";
            Object var1_1 = null;
            this.thread_$eq(new KafkaThread(nonDaemon_name, (Runnable)this, false));
            if (this.startThread()) {
                this.thread().start();
                return;
            }
            return;
        }
    }

    public void shutdown() {
        this.shutdownFlag().set(true);
        if (Predef$.MODULE$.Long2long(this.config().confluentConfig().storageProbePeriodMs()) > 0L) {
            this.metrics().foreach((Function1 & Serializable)logDir -> {
                StorageProbe.$anonfun$shutdown$1(this, logDir);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public ByteBuffer payload() {
        return ByteBuffer.wrap(new StringBuilder(1).append(this.version()).append(",").append(this.time().milliseconds()).toString().getBytes(StandardCharsets.UTF_8));
    }

    public scala.collection.immutable.Map<String, Object> probe() {
        return this.metrics().map((Function1 & Serializable)logDir -> {
            try {
                Tuple2 tuple2;
                Path path = Paths.get(logDir.name(), "storage.probe");
                ByteBuffer payloadBytes = this.payload();
                logDir.currentWriteStartedMs().set(this.time().hiResClockMs());
                FileChannel fc = FileChannelWrapper.open((Path)path, (OpenOption[])new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE});
                try {
                    FileChannelWrapper.truncate((FileChannel)fc, (long)0L);
                    long startMs = this.time().hiResClockMs();
                    FileChannelWrapper.write((FileChannel)fc, (ByteBuffer)payloadBytes);
                    FileChannelWrapper.force((FileChannel)fc, (boolean)true);
                    long tookMs = this.time().hiResClockMs() - startMs;
                    if (tookMs >= (long)this.writeTimeWarnThresholdMs()) {
                        this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("slow storage probe write detected (>=").append(this.writeTimeWarnThresholdMs()).append("ms). Flush took ").append(tookMs).append("ms").toString());
                    }
                    logDir.histogram().update(tookMs);
                    tuple2 = new Tuple2((Object)logDir.name(), (Object)BoxesRunTime.boxToLong((long)tookMs));
                }
                finally {
                    logDir.currentWriteStartedMs().set(-1L);
                    FileChannelWrapper.close((FileChannel)fc);
                }
                return tuple2;
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Failed writing storage probe data to logdir ").append(logDir.name()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                return new Tuple2((Object)logDir.name(), (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE));
            }
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public void run() {
        ThreadCountersManager.LocalCounters.setThreadType((ThreadLocalCounters.ThreadGroupType)ThreadLocalCounters.ThreadGroupType.BACKGROUND_THREAD);
        do {
            ThreadCountersManager.wrapIO(() -> this.probe());
            Thread.sleep(Predef$.MODULE$.Long2long(this.config().confluentConfig().storageProbePeriodMs()));
        } while (!this.shutdownFlag().get());
    }

    private final void LogDirMetrics$lzycompute$1() {
        synchronized (this) {
            if (this.LogDirMetrics$module == null) {
                this.LogDirMetrics$module = new StorageProbe$LogDirMetrics$(this);
            }
            return;
        }
    }

    public final /* synthetic */ long kafka$server$StorageProbe$$$anonfun$startup$2(AtomicLong currentWriteTimeStartedMs$1) {
        long startedMs = currentWriteTimeStartedMs$1.get();
        if (startedMs == -1L) {
            return 0L;
        }
        return this.time().hiResClockMs() - startedMs;
    }

    public static final /* synthetic */ void $anonfun$shutdown$1(StorageProbe $this, LogDirMetrics logDir) {
        scala.collection.immutable.Map tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logdir"), (Object)logDir.name())}));
        $this.removeMetric($this.latencyMetricName(), (Map<String, String>)tags);
        $this.removeMetric($this.currentWriteMetricName(), (Map<String, String>)tags);
    }

    public StorageProbe(KafkaConfig config, Time time, boolean startThread) {
        this.config = config;
        this.time = time;
        this.startThread = startThread;
        this.version = 0;
        this.latencyMetricName = "StorageProbeLatencyMs";
        this.currentWriteMetricName = "CurrentWriteDurationMs";
        this.shutdownFlag = new AtomicBoolean(false);
        this.metrics = Nil$.MODULE$;
        this.writeTimeWarnThresholdMs = 5000;
    }

    public class LogDirMetrics
    implements Product,
    Serializable {
        private final String name;
        private final AtomicLong currentWriteStartedMs;
        private final Histogram histogram;
        private final Gauge<Object> heartbeat;
        public final /* synthetic */ StorageProbe $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String name() {
            return this.name;
        }

        public AtomicLong currentWriteStartedMs() {
            return this.currentWriteStartedMs;
        }

        public Histogram histogram() {
            return this.histogram;
        }

        public Gauge<Object> heartbeat() {
            return this.heartbeat;
        }

        public LogDirMetrics copy(String name, AtomicLong currentWriteStartedMs, Histogram histogram, Gauge<Object> heartbeat) {
            return new LogDirMetrics(this.kafka$server$StorageProbe$LogDirMetrics$$$outer(), name, currentWriteStartedMs, histogram, heartbeat);
        }

        public String copy$default$1() {
            return this.name();
        }

        public AtomicLong copy$default$2() {
            return this.currentWriteStartedMs();
        }

        public Histogram copy$default$3() {
            return this.histogram();
        }

        public Gauge<Object> copy$default$4() {
            return this.heartbeat();
        }

        public String productPrefix() {
            return "LogDirMetrics";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.name();
                }
                case 1: {
                    return this.currentWriteStartedMs();
                }
                case 2: {
                    return this.histogram();
                }
                case 3: {
                    return this.heartbeat();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LogDirMetrics;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "currentWriteStartedMs";
                }
                case 2: {
                    return "histogram";
                }
                case 3: {
                    return "heartbeat";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof LogDirMetrics && ((LogDirMetrics)x$1).kafka$server$StorageProbe$LogDirMetrics$$$outer() == this.kafka$server$StorageProbe$LogDirMetrics$$$outer())) break block3;
                    LogDirMetrics logDirMetrics = (LogDirMetrics)x$1;
                    String string = this.name();
                    String string2 = logDirMetrics.name();
                    if ((string != null ? !string.equals(string2) : string2 != null) || !BoxesRunTime.equalsNumNum((Number)this.currentWriteStartedMs(), (Number)logDirMetrics.currentWriteStartedMs())) break block3;
                    Histogram histogram = this.histogram();
                    Histogram histogram2 = logDirMetrics.histogram();
                    if (histogram != null ? !histogram.equals(histogram2) : histogram2 != null) break block3;
                    Gauge<Object> gauge = this.heartbeat();
                    Gauge<Object> gauge2 = logDirMetrics.heartbeat();
                    if ((gauge != null ? !gauge.equals(gauge2) : gauge2 != null) || !logDirMetrics.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ StorageProbe kafka$server$StorageProbe$LogDirMetrics$$$outer() {
            return this.$outer;
        }

        public LogDirMetrics(StorageProbe $outer, String name, AtomicLong currentWriteStartedMs, Histogram histogram, Gauge<Object> heartbeat) {
            this.name = name;
            this.currentWriteStartedMs = currentWriteStartedMs;
            this.histogram = histogram;
            this.heartbeat = heartbeat;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

