/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.controller.KafkaController;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.ConfigHandler;
import kafka.server.Constants$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ReplicationQuotaManagerConfig$;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005y4Aa\u0003\u0007\u0001#!A!\u0005\u0001BC\u0002\u0013%1\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003%\u0011!A\u0003A!A!\u0002\u0013I\u0003\u0002\u0003\u0017\u0001\u0005\u000b\u0007I\u0011A\u0017\t\u0011q\u0002!\u0011!Q\u0001\n9B\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\u0006\u000f\u0002!\t\u0001\u0013\u0005\u0006\u001d\u0002!\ta\u0014\u0005\u0006O\u0002!\t\u0001\u001b\u0005\u0006o\u0002!\t\u0001\u001f\u0002\u0013)>\u0004\u0018nY\"p]\u001aLw\rS1oI2,'O\u0003\u0002\u000e\u001d\u000511/\u001a:wKJT\u0011aD\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001!\u0003\u0007\u000f\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g!\tI\"$D\u0001\r\u0013\tYBBA\u0007D_:4\u0017n\u001a%b]\u0012dWM\u001d\t\u0003;\u0001j\u0011A\b\u0006\u0003?9\tQ!\u001e;jYNL!!\t\u0010\u0003\u000f1{wmZ5oO\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014X#\u0001\u0013\u0011\u0005e)\u0013B\u0001\u0014\r\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fqB]3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\fW\u000647.Y\"p]\u001aLw\r\u0005\u0002\u001aU%\u00111\u0006\u0004\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0004rk>$\u0018m]\u000b\u0002]A\u0011q&\u000f\b\u0003a]r!!\r\u001c\u000f\u0005I*T\"A\u001a\u000b\u0005Q\u0002\u0012A\u0002\u001fs_>$h(C\u0001\u0010\u0013\tia\"\u0003\u00029\u0019\u0005a\u0011+^8uC\u001a\u000b7\r^8ss&\u0011!h\u000f\u0002\u000e#V|G/Y'b]\u0006<WM]:\u000b\u0005ab\u0011aB9v_R\f7\u000fI\u0001\u0010W\u000647.Y\"p]R\u0014x\u000e\u001c7feB\u00191cP!\n\u0005\u0001#\"AB(qi&|g\u000e\u0005\u0002C\u000b6\t1I\u0003\u0002E\u001d\u0005Q1m\u001c8ue>dG.\u001a:\n\u0005\u0019\u001b%aD&bM.\f7i\u001c8ue>dG.\u001a:\u0002\rqJg.\u001b;?)\u0015I%j\u0013'N!\tI\u0002\u0001C\u0003#\u000f\u0001\u0007A\u0005C\u0003)\u000f\u0001\u0007\u0011\u0006C\u0003-\u000f\u0001\u0007a\u0006C\u0003>\u000f\u0001\u0007a(\u0001\u000bqe>\u001cWm]:D_:4\u0017nZ\"iC:<Wm\u001d\u000b\u0004!Nk\u0006CA\nR\u0013\t\u0011FC\u0001\u0003V]&$\b\"\u0002+\t\u0001\u0004)\u0016!\u0002;pa&\u001c\u0007C\u0001,[\u001d\t9\u0006\f\u0005\u00023)%\u0011\u0011\fF\u0001\u0007!J,G-\u001a4\n\u0005mc&AB*ue&twM\u0003\u0002Z)!)a\f\u0003a\u0001?\u0006YAo\u001c9jG\u000e{gNZ5h!\t\u0001W-D\u0001b\u0015\t\u00117-\u0001\u0003vi&d'\"\u00013\u0002\t)\fg/Y\u0005\u0003M\u0006\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0003a\u0001\u0018M]:f)\"\u0014x\u000e\u001e;mK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005SJ\u001cX\u000fE\u0002k[>l\u0011a\u001b\u0006\u0003YR\t!bY8mY\u0016\u001cG/[8o\u0013\tq7NA\u0002TKF\u0004\"a\u00059\n\u0005E$\"aA%oi\")a,\u0003a\u0001?\")A/\u0003a\u0001_\u0006A!M]8lKJLE\rC\u0003w\u0013\u0001\u0007Q+\u0001\u0003qe>\u0004\u0018aD3yG2,H-\u001a3D_:4\u0017nZ:\u0015\u0007edX\u0010E\u0002WuVK!a\u001f/\u0003\u0007M+G\u000fC\u0003U\u0015\u0001\u0007Q\u000bC\u0003_\u0015\u0001\u0007q\f")
public class TopicConfigHandler
implements ConfigHandler,
Logging {
    private final ReplicaManager replicaManager;
    private final KafkaConfig kafkaConfig;
    private final QuotaFactory.QuotaManagers quotas;
    private final Option<KafkaController> kafkaController;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    @Override
    public void processConfigChanges(String topic, Properties topicConfig) {
        Set<String> configNamesToExclude = this.excludedConfigs(topic, topicConfig);
        Properties props = new Properties();
        CollectionConverters$.MODULE$.PropertiesHasAsScala(topicConfig).asScala().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(key, value) -> {
            if (!configNamesToExclude.contains(key)) {
                return props.put(key, value);
            }
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        this.replicaManager().updateTopicConfig(topic, props);
        this.updateThrottledList$1(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), this.quotas().leader(), topicConfig, topic);
        this.updateThrottledList$1(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), this.quotas().follower(), topicConfig, topic);
        if (BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(topicConfig.getProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp())))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
            this.kafkaController.foreach((Function1 & Serializable)x$1 -> {
                x$1.enableTopicUncleanLeaderElection(topic);
                return BoxedUnit.UNIT;
            });
        }
        this.kafkaController.foreach((Function1 & Serializable)controller -> {
            TopicConfigHandler.$anonfun$processConfigChanges$7(this, topicConfig, topic, controller);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Object> parseThrottledPartitions(Properties topicConfig, int brokerId, String prop) {
        String configValue = topicConfig.get(prop).toString().trim();
        ThrottledReplicaListValidator$.MODULE$.ensureValidString(prop, configValue);
        if ("".equals(configValue)) {
            return Nil$.MODULE$;
        }
        String string = ReplicationQuotaManagerConfig$.MODULE$.NoThrottledReplicasValue();
        if (!(string != null ? !string.equals(configValue) : configValue != null)) {
            return Constants$.MODULE$.NoReplicas();
        }
        String string2 = ReplicationQuotaManagerConfig$.MODULE$.AllThrottledReplicasValue();
        if (!(string2 != null ? !string2.equals(configValue) : configValue != null)) {
            return Constants$.MODULE$.AllReplicas();
        }
        return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])configValue.trim().split(",")), (Function1 & Serializable)x$3 -> x$3.split(":"), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TopicConfigHandler.$anonfun$parseThrottledPartitions$2(brokerId, x$4)))), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$5[0]))), (ClassTag)ClassTag$.MODULE$.Int())));
    }

    public Set<String> excludedConfigs(String topic, Properties topicConfig) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)topicConfig.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).flatMap((Function1 & Serializable)versionString -> {
            LogConfig.MessageFormatVersion messageFormatVersion = new LogConfig.MessageFormatVersion((String)versionString, $this.kafkaConfig.interBrokerProtocolVersion().version());
            if (messageFormatVersion.shouldIgnore()) {
                if (messageFormatVersion.shouldWarn()) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> messageFormatVersion.topicWarningMessage(topic));
                }
                return new Some((Object)LogConfig$.MODULE$.MessageFormatVersionProp());
            }
            if ($this.kafkaConfig.interBrokerProtocolVersion().isLessThan(messageFormatVersion.messageFormatVersion())) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(120).append("Topic configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append(" is ignored for `").append(topic).append("` because `").append((String)versionString).append("` ").append("is higher than what is allowed by the inter-broker protocol version `").append($this.kafkaConfig.interBrokerProtocolVersionString()).append("`").toString());
                return new Some((Object)LogConfig$.MODULE$.MessageFormatVersionProp());
            }
            return None$.MODULE$;
        })).toSet();
    }

    private final void updateThrottledList$1(String prop, ReplicationQuotaManager quotaManager, Properties topicConfig$1, String topic$1) {
        if (topicConfig$1.containsKey(prop) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(topicConfig$1.getProperty(prop)))) {
            Seq<Object> partitions = this.parseThrottledPartitions(topicConfig$1, this.kafkaConfig.brokerId(), prop);
            quotaManager.markThrottled(topic$1, partitions);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Setting ").append(prop).append(" on broker ").append($this.kafkaConfig.brokerId()).append(" for topic: ").append(topic$1).append(" and partitions ").append(partitions).toString());
            return;
        }
        quotaManager.removeThrottle(topic$1);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Removing ").append(prop).append(" from broker ").append($this.kafkaConfig.brokerId()).append(" for topic ").append(topic$1).toString());
    }

    public static final /* synthetic */ void $anonfun$processConfigChanges$7(TopicConfigHandler $this, Properties topicConfig$1, String topic$1, KafkaController controller) {
        LogConfig logConfig = LogConfig$.MODULE$.fromProps($this.replicaManager().config().originals(), topicConfig$1);
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> controller.controllerContext().putMinIsrConfigValues(topic$1, Predef$.MODULE$.Integer2int(logConfig.minInSyncReplicas())));
        controller.metadataCollector().foreach((Function1 & Serializable)x$2 -> {
            x$2.onTopicConfigChange(topic$1, logConfig);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$parseThrottledPartitions$2(int brokerId$1, String[] x$4) {
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$4[1])) == brokerId$1;
    }

    public TopicConfigHandler(ReplicaManager replicaManager, KafkaConfig kafkaConfig, QuotaFactory.QuotaManagers quotas, Option<KafkaController> kafkaController) {
        this.replicaManager = replicaManager;
        this.kafkaConfig = kafkaConfig;
        this.quotas = quotas;
        this.kafkaController = kafkaController;
    }
}

