/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.EpochSnapshot;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t5e\u0001\u0002\u00180\u0001YB\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\")a\u000b\u0001C\u0001/\"9A\f\u0001b\u0001\n\u0013i\u0006B\u00026\u0001A\u0003%a\fC\u0004l\u0001\t\u0007I\u0011\u00027\t\rM\u0004\u0001\u0015!\u0003n\u0011\u001d!\bA1A\u0005\nUDq!!\u0001\u0001A\u0003%a\u000fC\u0004\u0002\u0004\u0001!\t!!\u0002\t\u0013\u0005=\u0002\u00011A\u0005\n\u0005E\u0002\"CA\u001a\u0001\u0001\u0007I\u0011BA\u001b\u0011\u001d\t\t\u0005\u0001Q!\niD\u0011\"a\u0011\u0001\u0001\u0004%I!!\r\t\u0013\u0005\u0015\u0003\u00011A\u0005\n\u0005\u001d\u0003bBA&\u0001\u0001\u0006KA\u001f\u0005\b\u0003\u001b\u0002A\u0011BA(\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'Bq!a\u0018\u0001\t\u0003\t\t\u0007C\u0004\u0002d\u0001!\t!!\u001a\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002t!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0004bBAM\u0001\u0011%\u00111\u0014\u0005\b\u0003C\u0003A\u0011BAR\u0011\u001d\tY\f\u0001C\u0005\u0003{Cq!!1\u0001\t\u0013\t\u0019\rC\u0004\u0002f\u0002!\t!!\u0019\t\u000f\u0005\u001d\b\u0001\"\u0001\u0002j\"9\u0011\u0011\u001f\u0001\u0005\u0002\u0005M\bbBA|\u0001\u0011\u0005\u00111\u001f\u0005\b\u0003s\u0004A\u0011AAu\u0011\u001d\tY\u0010\u0001C\u0001\u0003{DqA!\u0004\u0001\t\u0003\u0011y\u0001C\u0004\u0003\u0014\u0001!\tA!\u0006\t\u000f\t-\u0002\u0001\"\u0001\u0003.!9!1\u0007\u0001\u0005\u0002\tU\u0002\"\u0003B\u001f\u0001E\u0005I\u0011\u0001B \u0011\u001d\u0011)\u0006\u0001C\u0001\u0003\u001fBqAa\u0016\u0001\t\u0003\ty\u0005C\u0004\u0003Z\u0001!\t!a\u0014\t\u000f\tm\u0003\u0001\"\u0001\u0003^!9!1\r\u0001\u0005\u0002\t\u0015\u0004b\u0002B4\u0001\u0011\u0005!\u0011\u000e\u0005\b\u0005w\u0002A\u0011\u0002B?\u0011\u001d\u0011)\t\u0001C\u0005\u0005\u000f\u0013A\u0003T3bI\u0016\u0014X\t]8dQ\u001aKG.Z\"bG\",'B\u0001\u00192\u0003\u0015)\u0007o\\2i\u0015\t\u00114'\u0001\u0004tKJ4XM\u001d\u0006\u0002i\u0005)1.\u00194lC\u000e\u00011c\u0001\u00018{A\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t1\u0011I\\=SK\u001a\u0004\"AP!\u000e\u0003}R!\u0001Q\u001a\u0002\u000bU$\u0018\u000e\\:\n\u0005\t{$a\u0002'pO\u001eLgnZ\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\t)U*D\u0001G\u0015\t9\u0005*\u0001\u0004d_6lwN\u001c\u0006\u0003i%S!AS&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0015aA8sO&\u0011aJ\u0012\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003)\u0019\u0007.Z2la>Lg\u000e\u001e\t\u0003#Rk\u0011A\u0015\u0006\u0003'F\n1b\u00195fG.\u0004x.\u001b8ug&\u0011QK\u0015\u0002\u0016\u0019\u0016\fG-\u001a:Fa>\u001c\u0007n\u00115fG.\u0004x.\u001b8u\u0003\u0019a\u0014N\\5u}Q\u0019\u0001LW.\u0011\u0005e\u0003Q\"A\u0018\t\u000b\r\u001b\u0001\u0019\u0001#\t\u000b=\u001b\u0001\u0019\u0001)\u0002\u0015U\u0004H-\u0019;f\u0019>\u001c7.F\u0001_!\ty\u0006.D\u0001a\u0015\t\t'-A\u0003m_\u000e\\7O\u0003\u0002dI\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u00154\u0017\u0001B;uS2T\u0011aZ\u0001\u0005U\u00064\u0018-\u0003\u0002jA\n1\"+Z3oiJ\fg\u000e\u001e*fC\u0012<&/\u001b;f\u0019>\u001c7.A\u0006va\u0012\fG/\u001a'pG.\u0004\u0013!\u00034mkNDGj\\2l+\u0005i\u0007C\u00018r\u001b\u0005y'B\u00019g\u0003\u0011a\u0017M\\4\n\u0005I|'AB(cU\u0016\u001cG/\u0001\u0006gYV\u001c\b\u000eT8dW\u0002\na!\u001a9pG\"\u001cX#\u0001<\u0011\t]D(0`\u0007\u0002I&\u0011\u0011\u0010\u001a\u0002\b)J,W-T1q!\tA40\u0003\u0002}s\t\u0019\u0011J\u001c;\u0011\u0005es\u0018BA@0\u0005))\u0005o\\2i\u000b:$(/_\u0001\bKB|7\r[:!\u0003-IgN\u00127vg\"dunY6\u0016\t\u0005\u001d\u0011q\u0002\u000b\u0005\u0003\u0013\tY\u0003\u0006\u0003\u0002\f\u0005\u0005\u0002\u0003BA\u0007\u0003\u001fa\u0001\u0001B\u0004\u0002\u0012)\u0011\r!a\u0005\u0003\u0003Q\u000bB!!\u0006\u0002\u001cA\u0019\u0001(a\u0006\n\u0007\u0005e\u0011HA\u0004O_RD\u0017N\\4\u0011\u0007a\ni\"C\u0002\u0002 e\u00121!\u00118z\u0011!\t\u0019C\u0003CA\u0002\u0005\u0015\u0012a\u00014v]B)\u0001(a\n\u0002\f%\u0019\u0011\u0011F\u001d\u0003\u0011q\u0012\u0017P\\1nKzBa!!\f\u000b\u0001\u0004i\u0017\u0001\u00027pG.\fabX3q_\u000eD7OV3sg&|g.F\u0001{\u0003IyV\r]8dQN4VM]:j_:|F%Z9\u0015\t\u0005]\u0012Q\b\t\u0004q\u0005e\u0012bAA\u001es\t!QK\\5u\u0011!\ty\u0004DA\u0001\u0002\u0004Q\u0018a\u0001=%c\u0005yq,\u001a9pG\"\u001ch+\u001a:tS>t\u0007%A\u000b`M2,8\u000f[3e\u000bB|7\r[:WKJ\u001c\u0018n\u001c8\u00023}3G.^:iK\u0012,\u0005o\\2igZ+'o]5p]~#S-\u001d\u000b\u0005\u0003o\tI\u0005\u0003\u0005\u0002@=\t\t\u00111\u0001{\u0003Yyf\r\\;tQ\u0016$W\t]8dQN4VM]:j_:\u0004\u0013!E3q_\u000eD7OV3sg&|gNQ;naR\u0011\u0011qG\u0001\u0016g\"|W\u000f\u001c3GYV\u001c\b.\u00129pG\"\u001c\u0015m\u00195f)\u0011\t)&a\u0017\u0011\u0007a\n9&C\u0002\u0002Ze\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002^I\u0001\rA_\u0001\u0012GV\u0014(/\u00129pG\"\u001ch+\u001a:tS>t\u0017aB5t\t&\u0014H/_\u000b\u0003\u0003+\na!Y:tS\u001etGCBA\u001c\u0003O\nI\u0007C\u00031)\u0001\u0007!\u0010C\u0004\u0002lQ\u0001\r!!\u001c\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\t\u0004q\u0005=\u0014bAA9s\t!Aj\u001c8h)\u0011\t)&!\u001e\t\r\u0005]T\u00031\u0001~\u0003\u0015)g\u000e\u001e:z\u0003\u001d\u0011Xm\u001d;pe\u0016$B!a\u000e\u0002~!9\u0011q\u0010\fA\u0002\u0005\u0005\u0015aB3oiJLWm\u001d\t\u0006\u0003\u0007\u000b\u0019* \b\u0005\u0003\u000b\u000byI\u0004\u0003\u0002\b\u00065UBAAE\u0015\r\tY)N\u0001\u0007yI|w\u000e\u001e \n\u0003iJ1!!%:\u0003\u001d\u0001\u0018mY6bO\u0016LA!!&\u0002\u0018\n!A*[:u\u0015\r\t\t*O\u0001![\u0006L(-\u001a+sk:\u001c\u0017\r^3O_:luN\\8u_:L7-\u00128ue&,7\u000f\u0006\u0003\u00028\u0005u\u0005BBAP/\u0001\u0007Q0\u0001\u0005oK^,e\u000e\u001e:z\u00035\u0011X-\\8wK\u001a\u0013x.\\#oIR!\u0011QUAY!\u0015\t9+!,~\u001b\t\tIKC\u0002\u0002,f\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty+!+\u0003\u0007M+\u0017\u000fC\u0004\u00024b\u0001\r!!.\u0002\u0013A\u0014X\rZ5dCR,\u0007C\u0002\u001d\u00028v\f)&C\u0002\u0002:f\u0012\u0011BR;oGRLwN\\\u0019\u0002\u001fI,Wn\u001c<f\rJ|Wn\u0015;beR$B!!*\u0002@\"9\u00111W\rA\u0002\u0005U\u0016a\u0005:f[>4Xm\u00165jY\u0016l\u0015\r^2iS:<GCBAS\u0003\u000b\f\u0019\u000fC\u0004\u0002Hj\u0001\r!!3\u0002\u0011%$XM]1u_J\u0004Ra^Af\u0003\u001fL1!!4e\u0005!IE/\u001a:bi>\u0014\bCBAi\u0003;TXP\u0004\u0003\u0002T\u0006eg\u0002BAk\u0003/l\u0011AZ\u0005\u0003K\u001aL1!a7e\u0003\ri\u0015\r]\u0005\u0005\u0003?\f\tOA\u0003F]R\u0014\u0018PC\u0002\u0002\\\u0012Dq!a-\u001b\u0001\u0004\t),\u0001\u0005o_:,U\u000e\u001d;z\u0003-a\u0017\r^3ti\u0016sGO]=\u0016\u0005\u0005-\b\u0003\u0002\u001d\u0002nvL1!a<:\u0005\u0019y\u0005\u000f^5p]\u0006YA.\u0019;fgR,\u0005o\\2i+\t\t)\u0010\u0005\u00039\u0003[T\u0018!\u00049sKZLw.^:Fa>\u001c\u0007.A\u0007fCJd\u0017.Z:u\u000b:$(/_\u0001\rK:$wJ\u001a4tKR4uN\u001d\u000b\u0007\u0003\u007f\u0014)A!\u0003\u0011\ra\u0012\tA_A7\u0013\r\u0011\u0019!\u000f\u0002\u0007)V\u0004H.\u001a\u001a\t\r\t\u001d\u0001\u00051\u0001{\u00039\u0011X-];fgR,G-\u00129pG\"DqAa\u0003!\u0001\u0004\ti'\u0001\u0007m_\u001e,e\u000eZ(gMN,G/\u0001\bpM\u001a\u001cX\r\u001e$pe\u0016\u0003xn\u00195\u0015\t\u00055$\u0011\u0003\u0005\u0007\u0005\u000f\t\u0003\u0019\u0001>\u00025\u0019Lg\u000e\u001a#jm\u0016\u0014x-\u001a8dK&sW\t]8dQ\u000e\u000b7\r[3\u0015\u0019\u00055$q\u0003B\u000e\u0005?\u0011\u0019Ca\n\t\u000f\te!\u00051\u0001\u0002\u0002\u0006\u0001B/[3sK\u0012,\u0005o\\2i'R\fG/\u001a\u0005\b\u0005;\u0011\u0003\u0019AA7\u0003E1\u0017N]:u)&,'/\u001a3PM\u001a\u001cX\r\u001e\u0005\b\u0005C\u0011\u0003\u0019AA7\u0003Aa\u0017m\u001d;US\u0016\u0014X\rZ(gMN,G\u000fC\u0004\u0003&\t\u0002\r!!\u001c\u0002!\u0019L'o\u001d;M_\u000e\fGn\u00144gg\u0016$\bb\u0002B\u0015E\u0001\u0007\u0011QN\u0001\u0010Y\u0006\u001cH\u000fT8dC2|eMZ:fi\u0006yAO];oG\u0006$XM\u0012:p[\u0016sG\r\u0006\u0003\u00028\t=\u0002b\u0002B\u0019G\u0001\u0007\u0011QN\u0001\nK:$wJ\u001a4tKR\f\u0011\u0003\u001e:v]\u000e\fG/\u001a$s_6\u001cF/\u0019:u)\u0019\t9Da\u000e\u0003:!9\u00111\u000e\u0013A\u0002\u00055\u0004\"\u0003B\u001eIA\u0005\t\u0019AA+\u0003A1G.^:i\u0013\u001a$&/\u001e8dCR,G-A\u000eueVt7-\u0019;f\rJ|Wn\u0015;beR$C-\u001a4bk2$HEM\u000b\u0003\u0005\u0003RC!!\u0016\u0003D-\u0012!Q\t\t\u0005\u0005\u000f\u0012\t&\u0004\u0002\u0003J)!!1\nB'\u0003%)hn\u00195fG.,GMC\u0002\u0003Pe\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019F!\u0013\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0006nCf\u0014WM\u00127vg\"\fQb\u00197fCJ\fe\u000e\u001a$mkND\u0017!B2mK\u0006\u0014\u0018!B2m_:,Gc\u0001-\u0003`!1!\u0011M\u0015A\u0002A\u000bQB\\3x\u0007\",7m\u001b9pS:$\u0018\u0001D3q_\u000eDWI\u001c;sS\u0016\u001cXCAAS\u0003I\u0019h.\u00199tQ>$hi\u001c:TK\u001elWM\u001c;\u0015\t\t-$q\u000f\t\u0006q\t5$\u0011O\u0005\u0004\u0005_J$!B!se\u0006L\bc\u0001\u001d\u0003t%\u0019!QO\u001d\u0003\t\tKH/\u001a\u0005\b\u0005sZ\u0003\u0019AA7\u0003I)g\u000eZ(gMN,G/\u00138dYV\u001c\u0018N^3\u0002'\r\u0014X-\u0019;f\u000bB|7\r[*oCB\u001c\bn\u001c;\u0016\u0005\t}\u0004cA-\u0003\u0002&\u0019!1Q\u0018\u0003\u001b\u0015\u0003xn\u00195T]\u0006\u00048\u000f[8u\u0003\u00151G.^:i)\u0011\t9D!#\t\u000f\t-U\u00061\u0001\u0003\u0000\u0005iQ\r]8dQNs\u0017\r]:i_R\u0004")
public class LeaderEpochFileCache
implements Logging {
    private final TopicPartition topicPartition;
    private final LeaderEpochCheckpoint checkpoint;
    private final ReentrantReadWriteLock updateLock;
    private final Object flushLock;
    private final TreeMap<Object, EpochEntry> epochs;
    private int _epochsVersion;
    private int _flushedEpochsVersion;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock updateLock() {
        return this.updateLock;
    }

    private Object flushLock() {
        return this.flushLock;
    }

    private TreeMap<Object, EpochEntry> epochs() {
        return this.epochs;
    }

    public <T> T inFlushLock(Object lock, Function0<T> fun) {
        synchronized (lock) {
            Object object = fun.apply();
            return (T)object;
        }
    }

    private int _epochsVersion() {
        return this._epochsVersion;
    }

    private void _epochsVersion_$eq(int x$1) {
        this._epochsVersion = x$1;
    }

    private int _flushedEpochsVersion() {
        return this._flushedEpochsVersion;
    }

    private void _flushedEpochsVersion_$eq(int x$1) {
        this._flushedEpochsVersion = x$1;
    }

    private void epochsVersionBump() {
        this._epochsVersion_$eq(this._epochsVersion() + 1);
    }

    private boolean shouldFlushEpochCache(int currEpochsVersion) {
        return currEpochsVersion > this._flushedEpochsVersion();
    }

    public boolean isDirty() {
        return this.shouldFlushEpochCache(this._epochsVersion());
    }

    public void assign(int epoch, long startOffset) {
        EpochEntry entry = new EpochEntry(epoch, startOffset);
        if (this.assign(entry)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Appended new epoch entry ").append(entry).append(". Cache now contains ").append(this.epochs().size()).append(" entries.").toString());
            return;
        }
    }

    private boolean assign(EpochEntry entry) {
        boolean bl;
        if (entry.epoch() < 0 || entry.startOffset() < 0L) {
            throw new IllegalArgumentException(new StringBuilder(46).append("Received invalid partition leader epoch entry ").append(entry).toString());
        }
        if (!this.isUpdateNeeded$1(entry)) {
            return false;
        }
        Lock inWriteLock_inLock_lock = this.updateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            bl = LeaderEpochFileCache.$anonfun$assign$2(this, entry);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        return bl;
    }

    public void restore(List<EpochEntry> entries) {
        EpochSnapshot epochSnapshot;
        ReentrantReadWriteLock inWriteLock_lock = this.updateLock();
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            epochSnapshot = LeaderEpochFileCache.$anonfun$restore$1(this, entries);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var4_3 = null;
        Object var3_2 = null;
        EpochSnapshot epochsSnapshotToFlush = epochSnapshot;
        this.flush(epochsSnapshotToFlush);
    }

    private void maybeTruncateNonMonotonicEntries(EpochEntry newEntry) {
        ListBuffer listBuffer;
        block3: {
            java.util.Iterator removeFromEnd_removeWhileMatching_iterator = this.epochs().descendingMap().entrySet().iterator();
            ListBuffer removeFromEnd_removeWhileMatching_removedEpochs = ListBuffer$.MODULE$.empty();
            while (removeFromEnd_removeWhileMatching_iterator.hasNext()) {
                EpochEntry removeFromEnd_removeWhileMatching_entry = (EpochEntry)removeFromEnd_removeWhileMatching_iterator.next().getValue();
                if (LeaderEpochFileCache.$anonfun$maybeTruncateNonMonotonicEntries$1(newEntry, removeFromEnd_removeWhileMatching_entry)) {
                    removeFromEnd_removeWhileMatching_removedEpochs.$plus$eq((Object)removeFromEnd_removeWhileMatching_entry);
                    removeFromEnd_removeWhileMatching_iterator.remove();
                    continue;
                }
                listBuffer = removeFromEnd_removeWhileMatching_removedEpochs;
                break block3;
            }
            listBuffer = removeFromEnd_removeWhileMatching_removedEpochs;
        }
        Object var3_2 = null;
        Object var4_3 = null;
        Object var5_4 = null;
        ListBuffer removedEpochs = listBuffer;
        if (removedEpochs.size() > 1 || removedEpochs.nonEmpty() && ((EpochEntry)removedEpochs.head()).startOffset() != newEntry.startOffset()) {
            this.warn((Function0<String>)((Function0 & Serializable)() -> LeaderEpochFileCache.$anonfun$maybeTruncateNonMonotonicEntries$2(this, newEntry, (Seq)removedEpochs)));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Seq<EpochEntry> removeFromEnd(Function1<EpochEntry, Object> predicate) {
        void var3_3;
        java.util.Iterator removeWhileMatching_iterator = this.epochs().descendingMap().entrySet().iterator();
        ListBuffer removeWhileMatching_removedEpochs = ListBuffer$.MODULE$.empty();
        while (removeWhileMatching_iterator.hasNext()) {
            EpochEntry removeWhileMatching_entry = (EpochEntry)removeWhileMatching_iterator.next().getValue();
            if (BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)removeWhileMatching_entry))) {
                removeWhileMatching_removedEpochs.$plus$eq((Object)removeWhileMatching_entry);
                removeWhileMatching_iterator.remove();
                continue;
            }
            return removeWhileMatching_removedEpochs;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<EpochEntry> removeFromStart(Function1<EpochEntry, Object> predicate) {
        void var3_3;
        java.util.Iterator<Map.Entry<Object, EpochEntry>> removeWhileMatching_iterator = this.epochs().entrySet().iterator();
        ListBuffer removeWhileMatching_removedEpochs = ListBuffer$.MODULE$.empty();
        while (removeWhileMatching_iterator.hasNext()) {
            EpochEntry removeWhileMatching_entry = removeWhileMatching_iterator.next().getValue();
            if (BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)removeWhileMatching_entry))) {
                removeWhileMatching_removedEpochs.$plus$eq((Object)removeWhileMatching_entry);
                removeWhileMatching_iterator.remove();
                continue;
            }
            return removeWhileMatching_removedEpochs;
        }
        return var3_3;
    }

    private Seq<EpochEntry> removeWhileMatching(java.util.Iterator<Map.Entry<Object, EpochEntry>> iterator, Function1<EpochEntry, Object> predicate) {
        ListBuffer removedEpochs = ListBuffer$.MODULE$.empty();
        while (iterator.hasNext()) {
            EpochEntry entry = iterator.next().getValue();
            if (BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)entry))) {
                removedEpochs.$plus$eq((Object)entry);
                iterator.remove();
                continue;
            }
            return removedEpochs;
        }
        return removedEpochs;
    }

    public boolean nonEmpty() {
        boolean bl;
        Lock inReadLock_inLock_lock = this.updateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            bl = LeaderEpochFileCache.$anonfun$nonEmpty$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return bl;
    }

    public Option<EpochEntry> latestEntry() {
        Option option;
        Lock inReadLock_inLock_lock = this.updateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = LeaderEpochFileCache.$anonfun$latestEntry$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    public Option<Object> latestEpoch() {
        return this.latestEntry().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.epoch()));
    }

    public Option<Object> previousEpoch() {
        Option option;
        Lock inReadLock_inLock_lock = this.updateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = LeaderEpochFileCache.$anonfun$previousEpoch$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    public Option<EpochEntry> earliestEntry() {
        Option option;
        Lock inReadLock_inLock_lock = this.updateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = LeaderEpochFileCache.$anonfun$earliestEntry$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    public Tuple2<Object, Object> endOffsetFor(int requestedEpoch, long logEndOffset) {
        Tuple2 tuple2;
        Lock inReadLock_inLock_lock = this.updateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            tuple2 = LeaderEpochFileCache.$anonfun$endOffsetFor$1(this, requestedEpoch, logEndOffset);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return tuple2;
    }

    public long offsetForEpoch(int requestedEpoch) {
        long l;
        Lock inReadLock_inLock_lock = this.updateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            l = LeaderEpochFileCache.$anonfun$offsetForEpoch$1(this, requestedEpoch);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return l;
    }

    public long findDivergenceInEpochCache(List<EpochEntry> tieredEpochState, long firstTieredOffset, long lastTieredOffset, long firstLocalOffset, long lastLocalOffset) {
        Object object = new Object();
        try {
            long l;
            Lock inReadLock_inLock_lock = this.updateLock().readLock();
            inReadLock_inLock_lock.lock();
            try {
                l = LeaderEpochFileCache.$anonfun$findDivergenceInEpochCache$1(this, tieredEpochState, object, firstLocalOffset, lastLocalOffset, firstTieredOffset, lastTieredOffset);
            }
            finally {
                inReadLock_inLock_lock.unlock();
            }
            return l;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcJ$sp();
            }
            throw ex;
        }
    }

    public void truncateFromEnd(long endOffset) {
        Option option;
        Lock inWriteLock_inLock_lock = this.updateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            option = LeaderEpochFileCache.$anonfun$truncateFromEnd$1(this, endOffset);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var3_2 = null;
        option.foreach((Function1 & Serializable)epochSnapshot -> {
            this.flush(epochSnapshot);
            return BoxedUnit.UNIT;
        });
    }

    public void truncateFromStart(long startOffset, boolean flushIfTruncated) {
        Option option;
        Lock inWriteLock_inLock_lock = this.updateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            option = LeaderEpochFileCache.$anonfun$truncateFromStart$1(this, startOffset, flushIfTruncated);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var4_3 = null;
        option.foreach((Function1 & Serializable)epochSnapshot -> {
            this.flush(epochSnapshot);
            return BoxedUnit.UNIT;
        });
    }

    public boolean truncateFromStart$default$2() {
        return true;
    }

    public void maybeFlush() {
        Option option;
        Lock inReadLock_inLock_lock = this.updateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = LeaderEpochFileCache.$anonfun$maybeFlush$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        Object var1_1 = null;
        option.foreach((Function1 & Serializable)epochSnapshot -> {
            this.flush(epochSnapshot);
            return BoxedUnit.UNIT;
        });
    }

    public void clearAndFlush() {
        EpochSnapshot epochSnapshot;
        ReentrantReadWriteLock inWriteLock_lock = this.updateLock();
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            epochSnapshot = LeaderEpochFileCache.$anonfun$clearAndFlush$1(this);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var3_2 = null;
        Object var2_1 = null;
        EpochSnapshot epochsSnapshotToFlush = epochSnapshot;
        this.flush(epochsSnapshotToFlush);
    }

    public void clear() {
        Lock inWriteLock_inLock_lock = this.updateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$clear$1(this);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public LeaderEpochFileCache clone(LeaderEpochCheckpoint newCheckpoint) {
        LeaderEpochFileCache leaderEpochFileCache;
        Lock inReadLock_inLock_lock = this.updateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            leaderEpochFileCache = LeaderEpochFileCache.$anonfun$clone$1(this, newCheckpoint);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return leaderEpochFileCache;
    }

    public Seq<EpochEntry> epochEntries() {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(this.epochs().values()).asScala().toSeq();
    }

    public byte[] snapshotForSegment(long endOffsetInclusive) {
        byte[] byArray;
        Lock inReadLock_inLock_lock = this.updateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            byArray = this.checkpoint.toByteArray((Seq<EpochEntry>)((Seq)this.epochEntries().filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$snapshotForSegment$2(endOffsetInclusive$1, e)))));
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return byArray;
    }

    private EpochSnapshot createEpochSnapshot() {
        return new EpochSnapshot((Iterable<EpochEntry>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.epochs().values()).asScala().toBuffer(), this._epochsVersion());
    }

    private void flush(EpochSnapshot epochSnapshot) {
        this.inFlushLock(this.flushLock(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            if (this.shouldFlushEpochCache(epochSnapshot.version())) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Flushing leader epoch cache for partition ").append($this.topicPartition).append(", isDirty is ").append(this.isDirty()).toString());
                $this.checkpoint.write(epochSnapshot.epochEntries());
                this._flushedEpochsVersion_$eq(epochSnapshot.version());
                return;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$new$1(LeaderEpochFileCache $this) {
        $this.checkpoint.read().foreach((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)$this.assign(entry)));
    }

    private final boolean isUpdateNeeded$1(EpochEntry entry$2) {
        Option<EpochEntry> option = this.latestEntry();
        if (option instanceof Some) {
            EpochEntry lastEntry = (EpochEntry)((Some)option).value();
            return entry$2.epoch() != lastEntry.epoch() || entry$2.startOffset() < lastEntry.startOffset();
        }
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ boolean $anonfun$assign$2(LeaderEpochFileCache $this, EpochEntry entry$2) {
        if ($this.isUpdateNeeded$1(entry$2)) {
            $this.maybeTruncateNonMonotonicEntries(entry$2);
            $this.epochs().put(BoxesRunTime.boxToInteger((int)entry$2.epoch()), entry$2);
            $this.epochsVersionBump();
            return true;
        }
        return false;
    }

    public static final /* synthetic */ EpochSnapshot $anonfun$restore$1(LeaderEpochFileCache $this, List entries$1) {
        $this.epochs().clear();
        entries$1.foreach((Function1 & Serializable)entry -> {
            $this.maybeTruncateNonMonotonicEntries((EpochEntry)entry);
            return $this.epochs().put(BoxesRunTime.boxToInteger((int)entry.epoch()), (EpochEntry)entry);
        });
        $this.epochsVersionBump();
        return $this.createEpochSnapshot();
    }

    public static final /* synthetic */ boolean $anonfun$maybeTruncateNonMonotonicEntries$1(EpochEntry newEntry$1, EpochEntry entry) {
        return entry.epoch() >= newEntry$1.epoch() || entry.startOffset() >= newEntry$1.startOffset();
    }

    public static final /* synthetic */ String $anonfun$maybeTruncateNonMonotonicEntries$2(LeaderEpochFileCache $this, EpochEntry newEntry$1, Seq removedEpochs$1) {
        return new StringBuilder(88).append("New epoch entry ").append(newEntry$1).append(" caused truncation of conflicting entries ").append(removedEpochs$1).append(". ").append("Cache now contains ").append($this.epochs().size()).append(" entries.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$nonEmpty$1(LeaderEpochFileCache $this) {
        return !$this.epochs().isEmpty();
    }

    public static final /* synthetic */ Option $anonfun$latestEntry$1(LeaderEpochFileCache $this) {
        return Option$.MODULE$.apply($this.epochs().lastEntry()).map((Function1 & Serializable)x$1 -> (EpochEntry)x$1.getValue());
    }

    public static final /* synthetic */ int $anonfun$previousEpoch$3(Map.Entry x$3) {
        return BoxesRunTime.unboxToInt(x$3.getKey());
    }

    public static final /* synthetic */ Option $anonfun$previousEpoch$1(LeaderEpochFileCache $this) {
        return $this.latestEntry().flatMap((Function1 & Serializable)entry -> Option$.MODULE$.apply($this.epochs().lowerEntry(BoxesRunTime.boxToInteger((int)entry.epoch())))).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)LeaderEpochFileCache.$anonfun$previousEpoch$3(x$3)));
    }

    public static final /* synthetic */ Option $anonfun$earliestEntry$1(LeaderEpochFileCache $this) {
        return Option$.MODULE$.apply($this.epochs().firstEntry()).map((Function1 & Serializable)x$4 -> (EpochEntry)x$4.getValue());
    }

    public static final /* synthetic */ String $anonfun$endOffsetFor$2(LeaderEpochFileCache $this, int requestedEpoch$1, Tuple2 epochAndOffset$1) {
        return new StringBuilder(103).append("Processed end offset request for epoch ").append(requestedEpoch$1).append(" and returning epoch ").append(epochAndOffset$1._1$mcI$sp()).append(" ").append("with end offset ").append(epochAndOffset$1._2$mcJ$sp()).append(" from epoch cache of size ").append($this.epochs().size()).toString();
    }

    public static final /* synthetic */ Tuple2 $anonfun$endOffsetFor$1(LeaderEpochFileCache $this, int requestedEpoch$1, long logEndOffset$1) {
        Map.Entry<Object, EpochEntry> floorEntry;
        Map.Entry<Object, EpochEntry> higherEntry;
        Tuple2.mcIJ.sp epochAndOffset = requestedEpoch$1 == -1 ? new Tuple2.mcIJ.sp(-1, -1L) : ($this.latestEpoch().contains((Object)BoxesRunTime.boxToInteger((int)requestedEpoch$1)) ? new Tuple2.mcIJ.sp(requestedEpoch$1, logEndOffset$1) : ((higherEntry = $this.epochs().higherEntry(BoxesRunTime.boxToInteger((int)requestedEpoch$1))) == null ? new Tuple2.mcIJ.sp(-1, -1L) : ((floorEntry = $this.epochs().floorEntry(BoxesRunTime.boxToInteger((int)requestedEpoch$1))) == null ? new Tuple2.mcIJ.sp(requestedEpoch$1, higherEntry.getValue().startOffset()) : new Tuple2.mcIJ.sp(floorEntry.getValue().epoch(), higherEntry.getValue().startOffset()))));
        $this.trace((Function0<String>)((Function0 & Serializable)() -> LeaderEpochFileCache.$anonfun$endOffsetFor$2($this, requestedEpoch$1, (Tuple2)epochAndOffset)));
        return epochAndOffset;
    }

    public static final /* synthetic */ long $anonfun$offsetForEpoch$1(LeaderEpochFileCache $this, int requestedEpoch$2) {
        long requestedStartOffset = requestedEpoch$2 == -1 || !$this.epochs().containsKey(BoxesRunTime.boxToInteger((int)requestedEpoch$2)) ? -1L : $this.epochs().get(BoxesRunTime.boxToInteger((int)requestedEpoch$2)).startOffset();
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Processed start offset request for epoch ").append(requestedEpoch$2).append(" and returning start offset ").append(requestedStartOffset).toString());
        return requestedStartOffset;
    }

    public static final /* synthetic */ void $anonfun$findDivergenceInEpochCache$5(LeaderEpochFileCache $this, long lastLocalOffset$1, ObjectRef localEpochAndOffsetRanges$1, Map.Entry entry) {
        Map.Entry<Object, EpochEntry> nextEntry = $this.epochs().higherEntry(entry.getKey());
        long numMessages = nextEntry == null ? lastLocalOffset$1 - ((EpochEntry)entry.getValue()).startOffset() + 1L : nextEntry.getValue().startOffset() - ((EpochEntry)entry.getValue()).startOffset();
        localEpochAndOffsetRanges$1.elem = (Map)((Map)localEpochAndOffsetRanges$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)((EpochEntry)entry.getValue()).epoch())), (Object)new Tuple2.mcJJ.sp(((EpochEntry)entry.getValue()).startOffset(), numMessages)));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$findDivergenceInEpochCache$1(LeaderEpochFileCache $this, List tieredEpochState$1, Object nonLocalReturnKey1$1, long firstLocalOffset$1, long lastLocalOffset$1, long firstTieredOffset$1, long lastTieredOffset$1) {
        LongRef divergenceOffset = LongRef.create((long)-1L);
        if ($this.epochs().isEmpty() || tieredEpochState$1.isEmpty()) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> "Local epoch cache or the tiered state is empty. Hence, no divergence.");
            throw new NonLocalReturnControl.mcJ.sp(nonLocalReturnKey1$1, divergenceOffset.elem);
        }
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(138).append("Find divergence between local leader epoch cache ").append($this.epochs()).append(" [startOffset: ").append(firstLocalOffset$1).append(" lastOffset: ").append(lastLocalOffset$1).append("] ").append("and tiered leader epoch state ").append(tieredEpochState$1).append(" [startOffset: ").append(firstTieredOffset$1).append(" lastOffset: ").append(lastTieredOffset$1).append("]").toString());
        ObjectRef tieredEpochAndOffsetRanges = ObjectRef.create((Object)Nil$.MODULE$);
        tieredEpochState$1.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            long numMessages = i + 1 == tieredEpochState$1.size() ? lastTieredOffset$1 - ((EpochEntry)tieredEpochState$1.apply(i)).startOffset() + 1L : ((EpochEntry)tieredEpochState$1.apply(i + 1)).startOffset() - ((EpochEntry)tieredEpochState$1.apply(i)).startOffset();
            tieredEpochAndOffsetRanges$1.elem = (List)((List)tieredEpochAndOffsetRanges$1.elem).$colon$plus((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)((EpochEntry)tieredEpochState$1.apply(i)).epoch()), (Object)BoxesRunTime.boxToLong((long)((EpochEntry)tieredEpochState$1.apply(i)).startOffset()), (Object)BoxesRunTime.boxToLong((long)numMessages)));
        });
        ObjectRef localEpochAndOffsetRanges = ObjectRef.create((Object)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        CollectionConverters$.MODULE$.SetHasAsScala($this.epochs().entrySet()).asScala().foreach((Function1 & Serializable)entry -> {
            LeaderEpochFileCache.$anonfun$findDivergenceInEpochCache$5($this, lastLocalOffset$1, localEpochAndOffsetRanges, entry);
            return BoxedUnit.UNIT;
        });
        Iterator it = ((List)tieredEpochAndOffsetRanges.elem).iterator();
        while (divergenceOffset.elem == -1L && it.hasNext()) {
            void var19_14;
            void var17_13;
            Tuple2 tuple2;
            void var16_12;
            Tuple3 tuple3 = (Tuple3)it.next();
            if (tuple3 == null) {
                throw new MatchError(null);
            }
            int tieredEpoch = BoxesRunTime.unboxToInt((Object)tuple3._1());
            long tieredEpochStartOffset = BoxesRunTime.unboxToLong((Object)tuple3._2());
            long tieredEpochNumMessages = BoxesRunTime.unboxToLong((Object)tuple3._3());
            Option option = ((Map)localEpochAndOffsetRanges.elem).get((Object)BoxesRunTime.boxToInteger((int)var16_12));
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                long localEpochStartOffset = tuple2._1$mcJ$sp();
                long localEpochNumMessages = tuple2._2$mcJ$sp();
                if (var17_13 != localEpochStartOffset && (var16_12 != $this.epochs().firstEntry().getValue().epoch() || localEpochStartOffset < var17_13)) {
                    divergenceOffset.elem = Math.min((long)var17_13, localEpochStartOffset);
                }
                if (divergenceOffset.elem != -1L) continue;
                if (var17_13 + var19_14 < localEpochStartOffset + localEpochNumMessages && var17_13 + var19_14 - 1L != lastTieredOffset$1) {
                    divergenceOffset.elem = var17_13 + var19_14;
                    continue;
                }
                if (var17_13 + var19_14 <= localEpochStartOffset + localEpochNumMessages || localEpochStartOffset + localEpochNumMessages - 1L == lastLocalOffset$1) continue;
                divergenceOffset.elem = localEpochStartOffset + localEpochNumMessages;
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                if (var17_13 + var19_14 - 1L < firstLocalOffset$1 || var17_13 > lastLocalOffset$1 || var19_14 == 0L) continue;
                divergenceOffset.elem = var17_13;
                continue;
            }
            throw new MatchError((Object)option);
        }
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Divergence reported: ").append(divergenceOffset$1.elem).toString());
        return divergenceOffset.elem;
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromEnd$2(long endOffset$1, EpochEntry x$6) {
        return x$6.startOffset() >= endOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromEnd$3(long endOffset$1, EpochEntry x$7) {
        return x$7.startOffset() >= endOffset$1;
    }

    public static final /* synthetic */ String $anonfun$truncateFromEnd$4(LeaderEpochFileCache $this, Seq removedEntries$1, long endOffset$1) {
        return new StringBuilder(97).append("Cleared entries ").append(removedEntries$1).append(" from epoch cache after ").append("truncating to end offset ").append(endOffset$1).append(", leaving ").append($this.epochs().size()).append(" entries in the cache.").toString();
    }

    public static final /* synthetic */ Option $anonfun$truncateFromEnd$1(LeaderEpochFileCache $this, long endOffset$1) {
        if (endOffset$1 >= 0L && $this.latestEntry().exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromEnd$2(endOffset$1, x$6)))) {
            ListBuffer listBuffer;
            block4: {
                java.util.Iterator removeFromEnd_removeWhileMatching_iterator = $this.epochs().descendingMap().entrySet().iterator();
                ListBuffer removeFromEnd_removeWhileMatching_removedEpochs = ListBuffer$.MODULE$.empty();
                while (removeFromEnd_removeWhileMatching_iterator.hasNext()) {
                    EpochEntry removeFromEnd_removeWhileMatching_entry = (EpochEntry)removeFromEnd_removeWhileMatching_iterator.next().getValue();
                    if (LeaderEpochFileCache.$anonfun$truncateFromEnd$3(endOffset$1, removeFromEnd_removeWhileMatching_entry)) {
                        removeFromEnd_removeWhileMatching_removedEpochs.$plus$eq((Object)removeFromEnd_removeWhileMatching_entry);
                        removeFromEnd_removeWhileMatching_iterator.remove();
                        continue;
                    }
                    listBuffer = removeFromEnd_removeWhileMatching_removedEpochs;
                    break block4;
                }
                listBuffer = removeFromEnd_removeWhileMatching_removedEpochs;
            }
            Object var4_2 = null;
            Object var5_3 = null;
            Object var6_4 = null;
            ListBuffer removedEntries = listBuffer;
            if (removedEntries.nonEmpty()) {
                $this.epochsVersionBump();
            }
            $this.debug((Function0<String>)((Function0 & Serializable)() -> LeaderEpochFileCache.$anonfun$truncateFromEnd$4($this, (Seq)removedEntries, endOffset$1)));
            return new Some((Object)$this.createEpochSnapshot());
        }
        return Option$.MODULE$.empty();
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromStart$2(long startOffset$1, EpochEntry entry) {
        return entry.startOffset() <= startOffset$1;
    }

    public static final /* synthetic */ Option $anonfun$truncateFromStart$3(LeaderEpochFileCache $this, long startOffset$1, boolean flushIfTruncated$1, Seq removedEntries$2, EpochEntry firstBeforeStartOffset) {
        EpochEntry updatedFirstEntry = new EpochEntry(firstBeforeStartOffset.epoch(), startOffset$1);
        $this.epochs().put(BoxesRunTime.boxToInteger((int)updatedFirstEntry.epoch()), updatedFirstEntry);
        $this.epochsVersionBump();
        if (flushIfTruncated$1) {
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(99).append("Cleared entries ").append(removedEntries$2).append(" and rewrote first entry ").append(updatedFirstEntry).append(" after ").append("truncating to start offset ").append(startOffset$1).append(", leaving ").append($this.epochs().size()).append(" in the cache.").toString());
            return new Some((Object)$this.createEpochSnapshot());
        }
        return Option$.MODULE$.empty();
    }

    public static final /* synthetic */ Option $anonfun$truncateFromStart$1(LeaderEpochFileCache $this, long startOffset$1, boolean flushIfTruncated$1) {
        ListBuffer listBuffer;
        block2: {
            java.util.Iterator<Map.Entry<Object, EpochEntry>> removeFromStart_removeWhileMatching_iterator = $this.epochs().entrySet().iterator();
            ListBuffer removeFromStart_removeWhileMatching_removedEpochs = ListBuffer$.MODULE$.empty();
            while (removeFromStart_removeWhileMatching_iterator.hasNext()) {
                EpochEntry removeFromStart_removeWhileMatching_entry = removeFromStart_removeWhileMatching_iterator.next().getValue();
                if (LeaderEpochFileCache.$anonfun$truncateFromStart$2(startOffset$1, removeFromStart_removeWhileMatching_entry)) {
                    removeFromStart_removeWhileMatching_removedEpochs.$plus$eq((Object)removeFromStart_removeWhileMatching_entry);
                    removeFromStart_removeWhileMatching_iterator.remove();
                    continue;
                }
                listBuffer = removeFromStart_removeWhileMatching_removedEpochs;
                break block2;
            }
            listBuffer = removeFromStart_removeWhileMatching_removedEpochs;
        }
        Object var5_3 = null;
        Object var6_4 = null;
        Object var7_5 = null;
        ListBuffer removedEntries = listBuffer;
        return removedEntries.lastOption().flatMap(arg_0 -> LeaderEpochFileCache.$anonfun$truncateFromStart$3($this, startOffset$1, flushIfTruncated$1, (Seq)removedEntries, arg_0));
    }

    public static final /* synthetic */ Option $anonfun$maybeFlush$1(LeaderEpochFileCache $this) {
        if ($this.isDirty()) {
            return new Some((Object)$this.createEpochSnapshot());
        }
        return Option$.MODULE$.empty();
    }

    public static final /* synthetic */ EpochSnapshot $anonfun$clearAndFlush$1(LeaderEpochFileCache $this) {
        $this.epochs().clear();
        $this.epochsVersionBump();
        return $this.createEpochSnapshot();
    }

    public static final /* synthetic */ void $anonfun$clear$1(LeaderEpochFileCache $this) {
        $this.epochs().clear();
        $this.epochsVersionBump();
    }

    public static final /* synthetic */ LeaderEpochFileCache $anonfun$clone$1(LeaderEpochFileCache $this, LeaderEpochCheckpoint newCheckpoint$1) {
        newCheckpoint$1.write((Iterable<EpochEntry>)CollectionConverters$.MODULE$.CollectionHasAsScala($this.epochs().values()).asScala());
        return new LeaderEpochFileCache($this.topicPartition, newCheckpoint$1);
    }

    public static final /* synthetic */ boolean $anonfun$snapshotForSegment$2(long endOffsetInclusive$1, EpochEntry e) {
        return e.startOffset() <= endOffsetInclusive$1;
    }

    public LeaderEpochFileCache(TopicPartition topicPartition, LeaderEpochCheckpoint checkpoint) {
        this.topicPartition = topicPartition;
        this.checkpoint = checkpoint;
        this.logIdent_$eq(new StringBuilder(20).append("[LeaderEpochCache ").append(topicPartition).append("] ").toString());
        this.updateLock = new ReentrantReadWriteLock();
        this.flushLock = new Object();
        this.epochs = new TreeMap();
        Lock inWriteLock_inLock_lock = this.updateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$new$1(this);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        this._epochsVersion = 0;
        this._flushedEpochsVersion = 0;
    }

    public static final /* synthetic */ Object $anonfun$maybeTruncateNonMonotonicEntries$1$adapted(EpochEntry newEntry$1, EpochEntry entry) {
        return BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$maybeTruncateNonMonotonicEntries$1(newEntry$1, entry));
    }

    public static final /* synthetic */ Object $anonfun$truncateFromEnd$3$adapted(long endOffset$1, EpochEntry x$7) {
        return BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromEnd$3(endOffset$1, x$7));
    }

    public static final /* synthetic */ Object $anonfun$truncateFromStart$2$adapted(long startOffset$1, EpochEntry entry) {
        return BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromStart$2(startOffset$1, entry));
    }
}

