/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.link.ClusterLinkUtils;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.server.DelayedFuturePurgatory;
import kafka.server.KafkaConfig;
import kafka.server.link.ActiveClusterLink$;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkAdminClient$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkInfo;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkManager$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.FailedClusterLink$;
import kafka.server.link.LinkMode;
import kafka.server.link.LinkMode$Destination$;
import kafka.server.link.LinkMode$Source$;
import kafka.server.link.LinkState;
import kafka.server.link.PausedClusterLink$;
import kafka.server.link.UnavailableClusterLink$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.ClientInterceptor;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ClusterLinkInUseException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.CreateClusterLinksRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r]e\u0001B\u0012%\u0001-B\u0001\u0002\u0011\u0001\u0003\u0006\u0004%\t!\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u0005\"Aq\t\u0001BC\u0002\u0013\u0005\u0001\n\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003J\u0011!)\u0006A!b\u0001\n\u00031\u0006\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u0011m\u0003!\u0011!Q\u0001\nqC\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\t]\u0002\u0011\t\u0011)A\u0005_\")!\u000f\u0001C\u0001g\"91\u0010\u0001b\u0001\n\u0013a\bbBA\u0001\u0001\u0001\u0006I! \u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u001d\ti\u0006\u0001C!\u0003?Bq!!\u0019\u0001\t\u0003\n\u0019\u0007C\u0004\u0002>\u0002!\t%a0\t\u000f\u0005\u0015\b\u0001\"\u0003\u0002h\"9!1\u0003\u0001\u0005\u0002\tU\u0001b\u0002B&\u0001\u0011\u0005!Q\n\u0005\b\u0005k\u0002A\u0011\u0001B<\u0011\u001d\u0011)\t\u0001C\u0001\u0005\u000fCqAa%\u0001\t\u0003\u0011)\nC\u0004\u00038\u0002!IA!/\t\u000f\t\r\u0007\u0001\"\u0003\u0003F\"9!1\u001a\u0001\u0005\n\t5\u0007b\u0002Bn\u0001\u0011\u0005!Q\u001c\u0005\b\u0005[\u0004A\u0011\u0001Bx\u0011\u001d\u0011Y\u0010\u0001C\u0005\u0005{Dqa!\u0003\u0001\t\u0013\u0019Y\u0001C\u0004\u0004*\u0001!Iaa\u000b\t\u000f\r-\u0003\u0001\"\u0003\u0004N!911\r\u0001\u0005\n\r\u0015\u0004bBB<\u0001\u0011%1\u0011\u0010\u0005\b\u0007{\u0002A\u0011BB@\u0005]\u0019E.^:uKJd\u0015N\\6BI6Lg.T1oC\u001e,'O\u0003\u0002&M\u0005!A.\u001b8l\u0015\t9\u0003&\u0001\u0004tKJ4XM\u001d\u0006\u0002S\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001-ei\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012a!\u00118z%\u00164\u0007CA\u001a8\u001d\t!T'D\u0001%\u0013\t1D%\u0001\nDYV\u001cH/\u001a:MS:\\g)Y2u_JL\u0018B\u0001\u001d:\u00051\tE-\\5o\u001b\u0006t\u0017mZ3s\u0015\t1D\u0005\u0005\u0002<}5\tAH\u0003\u0002>Q\u0005)Q\u000f^5mg&\u0011q\b\u0010\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jOV\t!\t\u0005\u0002D\t6\ta%\u0003\u0002FM\tY1*\u00194lC\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\na\u0002\\8dC2\u001cE.^:uKJLE-F\u0001J!\tQ\u0015K\u0004\u0002L\u001fB\u0011AJL\u0007\u0002\u001b*\u0011aJK\u0001\u0007yI|w\u000e\u001e \n\u0005As\u0013A\u0002)sK\u0012,g-\u0003\u0002S'\n11\u000b\u001e:j]\u001eT!\u0001\u0015\u0018\u0002\u001f1|7-\u00197DYV\u001cH/\u001a:JI\u0002\n!c\u00197vgR,'\u000fT5oW6\u000bg.Y4feV\tq\u000b\u0005\u000251&\u0011\u0011\f\n\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T1oC\u001e,'/A\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014\b%A\u0004nKR\u0014\u0018nY:\u0011\u0005u3W\"\u00010\u000b\u0005m{&B\u00011b\u0003\u0019\u0019w.\\7p]*\u0011\u0011F\u0019\u0006\u0003G\u0012\fa!\u00199bG\",'\"A3\u0002\u0007=\u0014x-\u0003\u0002h=\n9Q*\u001a;sS\u000e\u001c\u0018\u0001\u0002;j[\u0016\u0004\"A\u001b7\u000e\u0003-T!!P0\n\u00055\\'\u0001\u0002+j[\u0016\fQ\"[:Nk2$\u0018\u000eV3oC:$\bCA\u0017q\u0013\t\thFA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u001d!XO^<ysj\u0004\"\u0001\u000e\u0001\t\u000b\u0001S\u0001\u0019\u0001\"\t\u000b\u001dS\u0001\u0019A%\t\u000bUS\u0001\u0019A,\t\u000bmS\u0001\u0019\u0001/\t\u000b!T\u0001\u0019A5\t\u000b9T\u0001\u0019A8\u0002\u0013A,(oZ1u_JLX#A?\u0011\u0005\rs\u0018BA@'\u0005Y!U\r\\1zK\u00124U\u000f^;sKB+(oZ1u_JL\u0018A\u00039ve\u001e\fGo\u001c:zA\u0005!BO]=D_6\u0004H.\u001a;f\u000b2\u001cXmV1uG\",B!a\u0002\u0002BQA\u0011\u0011BA\b\u00033\t\u0019\u0006E\u0002.\u0003\u0017I1!!\u0004/\u0005\u0011)f.\u001b;\t\u000f\u0005EQ\u00021\u0001\u0002\u0014\u0005IA/[7f_V$Xj\u001d\t\u0004[\u0005U\u0011bAA\f]\t!Aj\u001c8h\u0011\u001d\tY\"\u0004a\u0001\u0003;\tqAZ;ukJ,7\u000f\u0005\u0004\u0002 \u0005\u0015\u0012\u0011F\u0007\u0003\u0003CQ1!a\t/\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003O\t\tCA\u0002TKF\u0004b!a\u000b\u0002:\u0005uRBAA\u0017\u0015\u0011\ty#!\r\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u00024\u0005U\u0012\u0001B;uS2T!!a\u000e\u0002\t)\fg/Y\u0005\u0005\u0003w\tiCA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u0004B!a\u0010\u0002B1\u0001AaBA\"\u001b\t\u0007\u0011Q\t\u0002\u0002)F!\u0011qIA'!\ri\u0013\u0011J\u0005\u0004\u0003\u0017r#a\u0002(pi\"Lgn\u001a\t\u0004[\u0005=\u0013bAA)]\t\u0019\u0011I\\=\t\u000f\u0005US\u00021\u0001\u0002X\u0005\u0001\"/Z:q_:\u001cXmQ1mY\n\f7m\u001b\t\u0006[\u0005e\u0013\u0011B\u0005\u0004\u00037r#!\u0003$v]\u000e$\u0018n\u001c81\u0003!\u0019\b.\u001e;e_^tGCAA\u0005\u0003E2\u0018\r\\5eCR,G*\u001b8lg^KG\u000f[\"sK\u0006$Xm\u00117vgR,'\u000fT5oWJ+\u0017/^3ti\u001a{'o\u0013:bMR$\"\"!\u001a\u0002\u0002\u0006E\u0015qSAT!\u001d\ty\"a\u001aJ\u0003WJA!!\u001b\u0002\"\t\u0019Q*\u00199\u0011\r\u0005-\u0012\u0011HA7!\u0019i\u0013qNA:\u0013&\u0019\u0011\u0011\u000f\u0018\u0003\rQ+\b\u000f\\33!\u0015i\u0013QOA=\u0013\r\t9H\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005m\u0014QP\u0007\u0002?&\u0019\u0011qP0\u0003\tU+\u0018\u000e\u001a\u0005\b\u0003\u0007{\u0001\u0019AAC\u0003\u001d\u0011X-];fgR\u0004B!a\"\u0002\u000e6\u0011\u0011\u0011\u0012\u0006\u0004\u0003\u0017{\u0016\u0001\u0003:fcV,7\u000f^:\n\t\u0005=\u0015\u0011\u0012\u0002\u001a\u0007J,\u0017\r^3DYV\u001cH/\u001a:MS:\\7OU3rk\u0016\u001cH\u000fC\u0004\u0002\u0014>\u0001\r!!&\u0002\u0019Q,g.\u00198u!J,g-\u001b=\u0011\t5\n)(\u0013\u0005\b\u00033{\u0001\u0019AAN\u0003M\u0011X-];fgRd\u0015n\u001d;f]\u0016\u0014h*Y7f!\u0011\ti*a)\u000e\u0005\u0005}%bAAQ?\u00069a.\u001a;x_J\\\u0017\u0002BAS\u0003?\u0013A\u0002T5ti\u0016tWM\u001d(b[\u0016Dq!!+\u0010\u0001\u0004\tY+A\u0010wC2LG-\u0019;f+N,'\u000f\u0015:pm&$W\rZ\"p]\u001aLw\r\u0015:paN\u0004\u0012\"LAW\u0003c\u000bY,!\u0003\n\u0007\u0005=fFA\u0005Gk:\u001cG/[8oeA!\u00111WA\\\u001b\t\t)L\u0003\u0002A?&!\u0011\u0011XA[\u00059\u0019uN\u001c4jOJ+7o\\;sG\u0016\u0004b!a\b\u0002h%K\u0015A\u000b9sKB\u0014xnY3tg\u000e\u0013X-\u0019;f\u00072,8\u000f^3s\u0019&t7NU3rk\u0016\u001cHOR8s\u0017J\fg\r\u001e\u000b\r\u0003\u0003\fi-a4\u0002V\u0006\u0005\u00181\u001d\t\u0005\u0003\u0007\fI-\u0004\u0002\u0002F*\u0019\u0011qY0\u0002\u000f5,7o]1hK&!\u00111ZAc\u0005u\u0019%/Z1uK\u000ecWo\u001d;fe2Kgn[:SKF,Xm\u001d;ECR\f\u0007bBAB!\u0001\u0007\u0011Q\u0011\u0005\b\u0003#\u0004\u0002\u0019AAj\u0003M1\u0018\r\\5eCRLwN\\*vG\u000e,7o]3t!\u001d\ty\"a\u001aJ\u0003[Bq!a6\u0011\u0001\u0004\tI.\u0001\twC2LG-\u0019;j_:,%O]8sgB9\u0011qDA4\u0013\u0006m\u0007\u0003BAD\u0003;LA!a8\u0002\n\nA\u0011\t]5FeJ|'\u000fC\u0004\u0002\u0014B\u0001\r!!&\t\u000f\u0005e\u0005\u00031\u0001\u0002\u001c\u0006Q3\r[3dW\u000e{gN\u001a7jGRLgn\u001a'j].\u001cx+\u001b;iS:\u0014V-];fgR4uN]&sC\u001a$H\u0003DA\u0005\u0003S\f\u0019Pa\u0001\u0003\u000e\tE\u0001bBAv#\u0001\u0007\u0011Q^\u0001\u001eY&$XM]1m)>\u0004\u0018n\u0019$jYR,'o\u001d+p\u0019&t7NT1nKB1\u0011q^Ay\u0013&k!!!\r\n\t\u0005%\u0014\u0011\u0007\u0005\b\u0003k\f\u0002\u0019AA|\u0003!\u0001(/\u001a4jq\u0016\u001c\b#BA}\u0003\u007fLUBAA~\u0015\u0011\ti0!\t\u0002\u000f5,H/\u00192mK&!!\u0011AA~\u0005\r\u0019V\r\u001e\u0005\b\u0005\u000b\t\u0002\u0019\u0001B\u0004\u0003)a\u0017N\\6D_:4\u0017n\u001a\t\u0004i\t%\u0011b\u0001B\u0006I\t\t2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\t\r\t=\u0011\u00031\u0001J\u0003!a\u0017N\\6OC6,\u0007bBAJ#\u0001\u0007\u0011QS\u0001\u0012GJ,\u0017\r^3DYV\u001cH/\u001a:MS:\\G\u0003\u0005B\f\u0005?\u0011\u0019D!\u000e\u00038\tm\"q\bB$!\u0019\tY#!\u000f\u0003\u001aA!\u0011q\u001eB\u000e\u0013\u0011\u0011i\"!\r\u0003\tU+\u0016\n\u0012\u0005\b\u0005C\u0011\u0002\u0019\u0001B\u0012\u00039qWm^\"mkN$XM\u001d'j].\u0004BA!\n\u000305\u0011!q\u0005\u0006\u0005\u0005S\u0011Y#A\u0003bI6LgNC\u0002\u0003.\u0005\fqa\u00197jK:$8/\u0003\u0003\u00032\t\u001d\"A\u0004(fo\u000ecWo\u001d;fe2Kgn\u001b\u0005\b\u0003'\u0013\u0002\u0019AAK\u0011\u001d\tIJ\u0005a\u0001\u00037CaA!\u000f\u0013\u0001\u0004y\u0017\u0001\u0004<bY&$\u0017\r^3P]2L\bB\u0002B\u001f%\u0001\u0007q.\u0001\u0007wC2LG-\u0019;f\u0019&t7\u000eC\u0004\u0002\u0012I\u0001\rA!\u0011\u0011\u00075\u0012\u0019%C\u0002\u0003F9\u00121!\u00138u\u0011\u001d\u0011IE\u0005a\u0001\u0005\u0003\n!\"\u00199j-\u0016\u00148/[8o\u0003Aa\u0017n\u001d;DYV\u001cH/\u001a:MS:\\7\u000f\u0006\u0005\u0003P\t\u0015$q\u000eB:!\u0019\u0011\tFa\u0017\u0003`9!!1\u000bB,\u001d\ra%QK\u0005\u0002_%\u0019!\u0011\f\u0018\u0002\u000fA\f7m[1hK&!\u0011q\u0005B/\u0015\r\u0011IF\f\t\u0005\u0005K\u0011\t'\u0003\u0003\u0003d\t\u001d\"AE\"mkN$XM\u001d'j].d\u0015n\u001d;j]\u001eDqAa\u001a\u0014\u0001\u0004\u0011I'A\u0005mS:\\g*Y7fgB)Q&!\u001e\u0003lA!!J!\u001cJ\u0013\r\u0011\ta\u0015\u0005\u0007\u0005c\u001a\u0002\u0019A8\u0002\u001b%t7\r\\;eKR{\u0007/[2t\u0011\u001d\u0011Ie\u0005a\u0001\u0005\u0003\nA\u0003Z3tGJL'-Z\"mkN$XM\u001d'j].\u001cHC\u0002B=\u0005\u0003\u0013\u0019\t\u0005\u0004\u0003R\tm#1\u0010\t\u0005\u0005K\u0011i(\u0003\u0003\u0003\u0000\t\u001d\"AF\"mkN$XM\u001d'j].$Um]2sSB$\u0018n\u001c8\t\u000f\t\u001dD\u00031\u0001\u0003j!1!\u0011\u000f\u000bA\u0002=\f\u0011\u0003Z3mKR,7\t\\;ti\u0016\u0014H*\u001b8l))\tIA!#\u0003\f\n5%\u0011\u0013\u0005\u0007\u0005\u001f)\u0002\u0019A%\t\r\teR\u00031\u0001p\u0011\u0019\u0011y)\u0006a\u0001_\u0006)am\u001c:dK\"9!\u0011J\u000bA\u0002\t\u0005\u0013aC1mi\u0016\u0014X*\u001b:s_J$\"Ba&\u0003&\n%&1\u0017B[!\u0019\tY#!\u000f\u0003\u001aB!!1\u0014BQ\u001b\t\u0011iJ\u0003\u0003\u0003 \u0006U\u0012\u0001\u00027b]\u001eLAAa)\u0003\u001e\n!ak\\5e\u0011\u0019\u00119K\u0006a\u0001\u0013\u0006)Ao\u001c9jG\"9!1\u0016\fA\u0002\t5\u0016AA8q!\u0011\u0011)Ca,\n\t\tE&q\u0005\u0002\u000e\u00032$XM]'jeJ|'o\u00149\t\r\teb\u00031\u0001p\u0011\u001d\u0011IE\u0006a\u0001\u0005\u0003\nqb\u001d;pa6K'O]8s)>\u0004\u0018n\u0019\u000b\t\u0005/\u0013YL!0\u0003B\"1!qU\fA\u0002%CaAa0\u0018\u0001\u0004y\u0017aC:z]\u000eD'o\u001c8ju\u0016DaA!\u000f\u0018\u0001\u0004y\u0017\u0001E2mK\u0006\u0014X*\u001b:s_J$v\u000e]5d)\u0019\u00119Ja2\u0003J\"1!q\u0015\rA\u0002%CaA!\u000f\u0019\u0001\u0004y\u0017\u0001\u00059bkN,W*\u001b:s_J$v\u000e]5d))\u00119Ja4\u0003R\nU'\u0011\u001c\u0005\u0007\u0005OK\u0002\u0019A%\t\r\tM\u0017\u00041\u0001p\u0003\u0019)g.\u00192mK\"1!q[\rA\u0002=\f1\"[:MS:\\G*\u001a<fY\"1!\u0011H\rA\u0002=\f1\u0002\\5ti6K'O]8sgRA!q\u001cBs\u0005O\u0014Y\u000fE\u0003\u0003R\t\u0005\u0018*\u0003\u0003\u0003d\nu#\u0001C%uKJ\f'\r\\3\t\u000f\t=!\u00041\u0001\u0002\u0016\"1!\u0011\u001e\u000eA\u0002=\fa\"\u001b8dYV$Wm\u0015;paB,G\rC\u0004\u0003Ji\u0001\rA!\u0011\u0002\u001d\u0011,7o\u0019:jE\u0016l\u0015N\u001d:peR1!\u0011\u001fB|\u0005s\u0004BA!\n\u0003t&!!Q\u001fB\u0014\u0005Yi\u0015N\u001d:peR{\u0007/[2EKN\u001c'/\u001b9uS>t\u0007B\u0002BT7\u0001\u0007\u0011\nC\u0004\u0003Jm\u0001\rA!\u0011\u0002\u001b%\u001cHk\u001c9jGB\u000bWo]3e)\ry'q \u0005\b\u0007\u0003a\u0002\u0019AB\u0002\u0003\u0015\u0019H/\u0019;f!\r!4QA\u0005\u0004\u0007\u000f!#!F\"mkN$XM\u001d'j].$v\u000e]5d'R\fG/Z\u0001\u0018M&t\u0017n\u001d5De\u0016\fG/Z\"mkN$XM\u001d'j].$\u0002C!\u0007\u0004\u000e\r=1QCB\r\u00077\u0019iba\n\t\r\t=Q\u00041\u0001J\u0011\u001d\u0019\t\"\ba\u0001\u0007'\t\u0011\u0002\\5oW&#w\n\u001d;\u0011\u000b5\n)H!\u0007\t\u000f\r]Q\u00041\u0001\u0002\u0016\u0006iA.\u001b8l\u00072,8\u000f^3s\u0013\u0012Dq!a%\u001e\u0001\u0004\t)\nC\u0004\u0003\u0006u\u0001\rAa\u0002\t\u000f\r}Q\u00041\u0001\u0004\"\u0005y\u0001/\u001a:tSN$XM\u001c;Qe>\u00048\u000f\u0005\u0003\u0002p\u000e\r\u0012\u0002BB\u0013\u0003c\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019\u0011I$\ba\u0001_\u0006yq/\u001b;i%\u0016lw\u000e^3BI6Lg.\u0006\u0003\u0004.\rMB\u0003CB\u0018\u0007\u000b\u001a9e!\u0013\u0015\t\rE2Q\u0007\t\u0005\u0003\u007f\u0019\u0019\u0004B\u0004\u0002Dy\u0011\r!!\u0012\t\u000f\r]b\u00041\u0001\u0004:\u0005!a-\u001e8d!\u001di31HB \u0007cI1a!\u0010/\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0003&\r\u0005\u0013\u0002BB\"\u0005O\u0011abQ8oM2,XM\u001c;BI6Lg\u000e\u0003\u0004\u0003\u0010y\u0001\r!\u0013\u0005\b\u0005\u000bq\u0002\u0019\u0001B\u0004\u0011\u001d\t\u0019J\ba\u0001\u0003+\u000baD^1mS\u0012\fG/\u001a#fgRLg.\u0019;j_:\u001cE.^:uKJd\u0015N\\6\u0015\u0019\u0005U5qJB,\u00077\u001ayf!\u0019\t\u000f\t%r\u00041\u0001\u0004RA!!QEB*\u0013\u0011\u0019)Fa\n\u0003\u000b\u0005#W.\u001b8\t\u000f\res\u00041\u0001\u0002\u0016\u0006\tR\r\u001f9fGR,Gm\u00117vgR,'/\u00133\t\u000f\rus\u00041\u0001\u0004\"\u0005)\u0001O]8qg\"9\u0011\u0011C\u0010A\u0002\t\u0005\u0003B\u0002B\b?\u0001\u0007\u0011*A\rwC2LG-\u0019;f'>,(oY3DYV\u001cH/\u001a:MS:\\G\u0003DB4\u0007S\u001aiga\u001c\u0004r\rU\u0004CB\u0017\u0002p\te\u0011\nC\u0004\u0004l\u0001\u0002\raa\u0010\u0002\u0017I,Wn\u001c;f\u0003\u0012l\u0017N\u001c\u0005\u0007\u0005\u001f\u0001\u0003\u0019A%\t\u000f\u0005M\u0005\u00051\u0001\u0002\u0016\"911\u000f\u0011A\u0002\u0005U\u0015!F3ya\u0016\u001cG/\u001a3EKN$8\t\\;ti\u0016\u0014\u0018\n\u001a\u0005\b\u0003#\u0001\u0003\u0019\u0001B!\u0003]9W\r^!mY6K'O]8s)>\u0004\u0018nY:J]V\u001bX-\u0006\u0002\u0004|A9\u0011qDA4\u0013\u000e\r\u0011a\u0005<bY&$\u0017\r^5p]\u0016C8-\u001a9uS>tG\u0003BBA\u0007\u001b\u0003Baa!\u0004\n6\u00111Q\u0011\u0006\u0004\u0007\u000f{\u0016AB3se>\u00148/\u0003\u0003\u0004\f\u000e\u0015%\u0001D!qS\u0016C8-\u001a9uS>t\u0007bBBHE\u0001\u00071\u0011S\u0001\ni\"\u0014xn^1cY\u0016\u0004BA!\u0015\u0004\u0014&!1Q\u0013B/\u0005%!\u0006N]8xC\ndW\r")
public class ClusterLinkAdminManager
implements ClusterLinkFactory.AdminManager,
Logging {
    private final KafkaConfig config;
    private final String localClusterId;
    private final ClusterLinkManager clusterLinkManager;
    private final Metrics metrics;
    private final Time time;
    private final boolean isMultiTenant;
    private final DelayedFuturePurgatory purgatory;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public boolean clusterLinkingIsDisabled() {
        return ClusterLinkFactory.AdminManager.clusterLinkingIsDisabled$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public String localClusterId() {
        return this.localClusterId;
    }

    @Override
    public ClusterLinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    private DelayedFuturePurgatory purgatory() {
        return this.purgatory;
    }

    @Override
    public <T> void tryCompleteElseWatch(long timeoutMs, Seq<CompletableFuture<T>> futures, Function0<BoxedUnit> responseCallback) {
        this.purgatory().tryCompleteElseWatch(timeoutMs, futures, responseCallback);
    }

    @Override
    public void shutdown() {
        this.purgatory().shutdown();
    }

    @Override
    public Map<String, CompletableFuture<Tuple2<Option<Uuid>, String>>> validateLinksWithCreateClusterLinkRequestForKraft(CreateClusterLinksRequest request, Option<String> tenantPrefix, ListenerName requestListenerName, Function2<ConfigResource, Map<String, String>, BoxedUnit> validateUserProvidedConfigProps) {
        if (this.config().interBrokerProtocolVersion().isLessThan(MetadataVersion.IBP_2_4_IV0)) {
            throw new InvalidClusterLinkException(new StringBuilder(68).append("Cluster linking is not supported with inter-broker ").append("protocol version ").append(this.config().interBrokerProtocolVersion()).toString());
        }
        Iterable newClusterLinks = CollectionConverters$.MODULE$.CollectionHasAsScala(request.newClusterLinks()).asScala();
        scala.collection.mutable.Map resultMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        HashMap literalTopicFiltersToLinkName = new HashMap();
        scala.collection.mutable.Set prefixes = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        newClusterLinks.foreach((Function1 & Serializable)ncl -> {
            Comparable<Boolean> comparable;
            block11: {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Validating cluster link create request for cluster link ").append(ncl).toString());
                CompletableFuture<Tuple2> result = new CompletableFuture<Tuple2>();
                Properties props = new Properties();
                new Implicits.PropertiesOps(props).$plus$plus$eq((Map<String, Object>)CollectionConverters$.MODULE$.MapHasAsScala(ncl.configs()).asScala());
                String linkName = ncl.linkName();
                resultMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkName), result));
                try {
                    ClusterLinkUtils.validateLinkNameOrThrow((String)linkName);
                    this.clusterLinkManager().ensureLinkNameDoesntExist(linkName);
                    ConfigResource resource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, "");
                    validateUserProvidedConfigProps.apply((Object)resource, (Object)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala());
                    if (!props.containsKey(ClusterLinkConfig$.MODULE$.LocalListenerNameProp())) {
                        props.put(ClusterLinkConfig$.MODULE$.LocalListenerNameProp(), requestListenerName.value());
                    }
                    ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create(props, true);
                    this.clusterLinkManager().validateLocalListenerName(linkConfig);
                    Option expectedClusterId = Option$.MODULE$.apply((Object)ncl.clusterId());
                    if (expectedClusterId.contains((Object)this.localClusterId())) {
                        throw new InvalidRequestException(new StringBuilder(85).append("Requested cluster ID matches local cluster ID").append(" '").append(this.localClusterId()).append("' - cannot create cluster link to self").toString());
                    }
                    LinkMode linkMode = linkConfig.linkMode();
                    LinkMode$Destination$ linkMode$Destination$ = LinkMode$Destination$.MODULE$;
                    if (linkMode != null && linkMode.equals(linkMode$Destination$)) {
                        ConnectionMode connectionMode = linkConfig.connectionMode();
                        ConnectionMode$Inbound$ connectionMode$Inbound$ = ConnectionMode$Inbound$.MODULE$;
                        if (connectionMode != null && connectionMode.equals(connectionMode$Inbound$) && expectedClusterId.isEmpty()) {
                            throw new InvalidRequestException("Remote cluster id must be provided for destination cluster link that is source initiated");
                        }
                    }
                    LinkMode linkMode2 = linkConfig.linkMode();
                    LinkMode$Source$ linkMode$Source$ = LinkMode$Source$.MODULE$;
                    if (linkMode2 != null && linkMode2.equals(linkMode$Source$)) {
                        ConnectionMode connectionMode = linkConfig.connectionMode();
                        ConnectionMode$Inbound$ connectionMode$Inbound$ = ConnectionMode$Inbound$.MODULE$;
                        if (connectionMode != null && connectionMode.equals(connectionMode$Inbound$)) {
                            throw new InvalidRequestException("Source links are currently supported only for source initiated links");
                        }
                    }
                    this.clusterLinkManager().ensureClusterLinkPrefixDoesntExist(linkConfig.clusterLinkPrefix());
                    this.clusterLinkManager().maybeCheckForOverlappingTopicFilters(linkConfig, linkName, tenantPrefix);
                    this.checkConflictingLinksWithinRequestForKraft(literalTopicFiltersToLinkName, (scala.collection.mutable.Set<String>)prefixes, linkConfig, linkName, tenantPrefix);
                    LinkMode linkMode3 = linkConfig.linkMode();
                    LinkMode$Source$ linkMode$Source$2 = LinkMode$Source$.MODULE$;
                    if (linkMode3 != null && linkMode3.equals(linkMode$Source$2)) {
                        comparable = this.clusterLinkManager().scheduler().schedule("CreateSourceClusterLink", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                            try {
                                void var10_18;
                                void var9_17;
                                Tuple2 tuple2;
                                LinkMode linkMode;
                                LinkMode$Source$ linkMode$Source$;
                                ClusterLinkAdminClient withRemoteAdmin_admin;
                                block14: {
                                    ClusterLinkAdminClient clusterLinkAdminClient;
                                    try {
                                        clusterLinkAdminClient = ClusterLinkAdminClient$.MODULE$.createRemoteAdmin(this.config(), linkName, linkConfig, (Option<ClusterLinkDestConnectionManager>)None$.MODULE$, "validate-admin", this.config().brokerId(), $this.metrics, $this.time);
                                    }
                                    catch (Throwable withRemoteAdmin_e) {
                                        throw new InvalidConfigurationException(new StringBuilder(84).append("Unable to create client using provided properties when validating the cluster link: ").append(withRemoteAdmin_e.getMessage()).toString(), withRemoteAdmin_e);
                                    }
                                    withRemoteAdmin_admin = clusterLinkAdminClient;
                                    try {
                                        Object object;
                                        if (tenantPrefix.forall((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isEmpty())) && linkConfig.clusterLinkPrefix().forall((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isEmpty()))) {
                                            object = None$.MODULE$;
                                        } else {
                                            LinkMode linkMode2 = linkConfig.linkMode();
                                            linkMode$Source$ = LinkMode$Source$.MODULE$;
                                            object = linkMode2 != null && linkMode2.equals(linkMode$Source$) ? tenantPrefix.map((Function1 & Serializable)prefix -> ClusterLinkManager$.MODULE$.prefixInterceptor((String)prefix, "", linkName, linkConfig.linkMode(), $this.metrics, $this.isMultiTenant, Predef$.MODULE$.Boolean2boolean(linkConfig.clusterLinkPrefixConsumerGroupEnable()))) : new Some((Object)ClusterLinkManager$.MODULE$.prefixInterceptor((String)tenantPrefix.getOrElse((Function0 & Serializable)() -> ""), (String)linkConfig.clusterLinkPrefix().getOrElse((Function0 & Serializable)() -> ""), linkName, linkConfig.linkMode(), $this.metrics, $this.isMultiTenant, Predef$.MODULE$.Boolean2boolean(linkConfig.clusterLinkPrefixConsumerGroupEnable())));
                                        }
                                        None$ withRemoteAdmin_clientInterceptor = object;
                                        linkMode = linkConfig.linkMode();
                                        if (LinkMode$Destination$.MODULE$.equals(linkMode)) {
                                            withRemoteAdmin_admin.networkClient().enableDestinationClusterLink(null, (ClientInterceptor)withRemoteAdmin_clientInterceptor.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), null);
                                            break block14;
                                        }
                                        if (LinkMode$Source$.MODULE$.equals(linkMode)) {
                                            withRemoteAdmin_admin.networkClient().enableSourceClusterLink(null, (ClientInterceptor)withRemoteAdmin_clientInterceptor.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), null, null);
                                            break block14;
                                        }
                                        throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported link mode ").append(linkConfig.linkMode()).toString());
                                    }
                                    catch (Throwable withRemoteAdmin_e) {
                                        throw new InvalidConfigurationException("Unable to enable cluster link for client when validating new link", withRemoteAdmin_e);
                                    }
                                }
                                try {
                                    ConfluentAdmin confluentAdmin = withRemoteAdmin_admin.admin();
                                    tuple2 = this.validateSourceClusterLink(confluentAdmin, linkName, (Option<String>)tenantPrefix, (Option<String>)expectedClusterId, request.timeoutMs());
                                }
                                finally {
                                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> withRemoteAdmin_admin.close(), this, Level.WARN);
                                }
                                Object var12_9 = null;
                                Object var14_11 = null;
                                linkMode$Source$ = null;
                                linkMode = null;
                                Tuple2 tuple22 = tuple2;
                                if (tuple22 == null) {
                                    throw new MatchError(null);
                                }
                                UUID linkId = (UUID)tuple22._1();
                                String destClusterId = (String)tuple22._2();
                                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Successfully validated cluster link request for cluster link ").append(ncl).toString());
                                result.complete(new Tuple2((Object)new Some((Object)Utils.toKafkaUuid((UUID)var9_17)), (Object)var10_18));
                                return;
                            }
                            catch (Throwable e) {
                                result.completeExceptionally(ClusterLinkUtils$.MODULE$.apiException(e, "Unable to validate cluster link"));
                                return;
                            }
                        }, this.clusterLinkManager().scheduler().schedule$default$3(), this.clusterLinkManager().scheduler().schedule$default$4(), this.clusterLinkManager().scheduler().schedule$default$5());
                        break block11;
                    }
                    if (request.validateLink() || expectedClusterId.isEmpty()) {
                        ConnectionMode connectionMode = linkConfig.connectionMode();
                        ConnectionMode$Outbound$ connectionMode$Outbound$ = ConnectionMode$Outbound$.MODULE$;
                        if (connectionMode != null && connectionMode.equals(connectionMode$Outbound$)) {
                            comparable = this.clusterLinkManager().scheduler().schedule("ValidateCreateDestinationClusterLink", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                                try {
                                    String string;
                                    LinkMode linkMode;
                                    LinkMode$Source$ linkMode$Source$;
                                    ClusterLinkAdminClient withRemoteAdmin_admin;
                                    block13: {
                                        ClusterLinkAdminClient clusterLinkAdminClient;
                                        try {
                                            clusterLinkAdminClient = ClusterLinkAdminClient$.MODULE$.createRemoteAdmin(this.config(), linkName, linkConfig, (Option<ClusterLinkDestConnectionManager>)None$.MODULE$, "validate-admin", this.config().brokerId(), $this.metrics, $this.time);
                                        }
                                        catch (Throwable withRemoteAdmin_e) {
                                            throw new InvalidConfigurationException(new StringBuilder(84).append("Unable to create client using provided properties when validating the cluster link: ").append(withRemoteAdmin_e.getMessage()).toString(), withRemoteAdmin_e);
                                        }
                                        withRemoteAdmin_admin = clusterLinkAdminClient;
                                        try {
                                            Object object;
                                            if (tenantPrefix.forall((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isEmpty())) && linkConfig.clusterLinkPrefix().forall((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isEmpty()))) {
                                                object = None$.MODULE$;
                                            } else {
                                                LinkMode linkMode2 = linkConfig.linkMode();
                                                linkMode$Source$ = LinkMode$Source$.MODULE$;
                                                object = linkMode2 != null && linkMode2.equals(linkMode$Source$) ? tenantPrefix.map((Function1 & Serializable)prefix -> ClusterLinkManager$.MODULE$.prefixInterceptor((String)prefix, "", linkName, linkConfig.linkMode(), $this.metrics, $this.isMultiTenant, Predef$.MODULE$.Boolean2boolean(linkConfig.clusterLinkPrefixConsumerGroupEnable()))) : new Some((Object)ClusterLinkManager$.MODULE$.prefixInterceptor((String)tenantPrefix.getOrElse((Function0 & Serializable)() -> ""), (String)linkConfig.clusterLinkPrefix().getOrElse((Function0 & Serializable)() -> ""), linkName, linkConfig.linkMode(), $this.metrics, $this.isMultiTenant, Predef$.MODULE$.Boolean2boolean(linkConfig.clusterLinkPrefixConsumerGroupEnable())));
                                            }
                                            None$ withRemoteAdmin_clientInterceptor = object;
                                            linkMode = linkConfig.linkMode();
                                            if (LinkMode$Destination$.MODULE$.equals(linkMode)) {
                                                withRemoteAdmin_admin.networkClient().enableDestinationClusterLink(null, (ClientInterceptor)withRemoteAdmin_clientInterceptor.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), null);
                                                break block13;
                                            }
                                            if (LinkMode$Source$.MODULE$.equals(linkMode)) {
                                                withRemoteAdmin_admin.networkClient().enableSourceClusterLink(null, (ClientInterceptor)withRemoteAdmin_clientInterceptor.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), null, null);
                                                break block13;
                                            }
                                            throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported link mode ").append(linkConfig.linkMode()).toString());
                                        }
                                        catch (Throwable withRemoteAdmin_e) {
                                            throw new InvalidConfigurationException("Unable to enable cluster link for client when validating new link", withRemoteAdmin_e);
                                        }
                                    }
                                    try {
                                        ConfluentAdmin confluentAdmin = withRemoteAdmin_admin.admin();
                                        string = ClusterLinkAdminManager.$anonfun$validateLinksWithCreateClusterLinkRequestForKraft$7(this, expectedClusterId, props, request, linkName, ncl, confluentAdmin);
                                    }
                                    finally {
                                        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> withRemoteAdmin_admin.close(), this, Level.WARN);
                                    }
                                    Object var11_10 = null;
                                    Object var13_12 = null;
                                    linkMode$Source$ = null;
                                    linkMode = null;
                                    String sourceClusterId = string;
                                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Successfully validated cluster link request for cluster link ").append(ncl).toString());
                                    result.complete(new Tuple2((Object)None$.MODULE$, (Object)sourceClusterId));
                                    return;
                                }
                                catch (Throwable e) {
                                    result.completeExceptionally(ClusterLinkUtils$.MODULE$.apiException(e, "Unable to validate cluster link"));
                                    return;
                                }
                            }, this.clusterLinkManager().scheduler().schedule$default$3(), this.clusterLinkManager().scheduler().schedule$default$4(), this.clusterLinkManager().scheduler().schedule$default$5());
                            break block11;
                        }
                    }
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Successfully validated cluster link request for cluster link ").append(ncl).toString());
                    return BoxesRunTime.boxToBoolean((boolean)result.complete(new Tuple2((Object)None$.MODULE$, expectedClusterId.get())));
                }
                catch (Throwable e) {
                    comparable = BoxesRunTime.boxToBoolean((boolean)result.completeExceptionally(ClusterLinkUtils$.MODULE$.apiException(e, "Unable to validate cluster link")));
                }
            }
            return comparable;
        });
        return resultMap;
    }

    @Override
    public CreateClusterLinksRequestData preprocessCreateClusterLinkRequestForKraft(CreateClusterLinksRequest request, Map<String, Tuple2<Option<Uuid>, String>> validationSuccesses, Map<String, ApiError> validationErrors, Option<String> tenantPrefix, ListenerName requestListenerName) {
        CreateClusterLinksRequestData createClusterLinkRequest = request.data().duplicate();
        Iterator iterator = createClusterLinkRequest.entries().iterator();
        while (iterator.hasNext()) {
            CreateClusterLinksRequestData.EntryData entry = (CreateClusterLinksRequestData.EntryData)iterator.next();
            if (validationErrors.contains((Object)entry.linkName())) {
                iterator.remove();
                continue;
            }
            validationSuccesses.get((Object)entry.linkName()).foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    Option linkIdOpt = (Option)x0$1._1();
                    String remoteClusterId = (String)x0$1._2();
                    linkIdOpt.foreach((Function1 & Serializable)x$1 -> entry.setLinkId(x$1));
                    entry.setClusterId(remoteClusterId);
                    tenantPrefix.foreach((Function1 & Serializable)x$1 -> entry.setTenantPrefix(x$1));
                    Properties props = new Properties();
                    CollectionConverters$.MODULE$.ListHasAsScala(entry.configs()).asScala().foreach((Function1 & Serializable)data -> props.put(data.key(), data.value()));
                    if (!props.containsKey(ClusterLinkConfig$.MODULE$.LocalListenerNameProp())) {
                        CreateClusterLinksRequestData.ConfigData listenerConfig = new CreateClusterLinksRequestData.ConfigData();
                        listenerConfig.setKey(ClusterLinkConfig$.MODULE$.LocalListenerNameProp());
                        listenerConfig.setValue(requestListenerName.value());
                        return BoxesRunTime.boxToBoolean((boolean)entry.configs().add(listenerConfig));
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError(null);
            });
        }
        return createClusterLinkRequest;
    }

    private void checkConflictingLinksWithinRequestForKraft(java.util.Map<String, String> literalTopicFiltersToLinkName, scala.collection.mutable.Set<String> prefixes, ClusterLinkConfig linkConfig, String linkName, Option<String> tenantPrefix) {
        if (linkConfig.autoMirroringEnable()) {
            scala.collection.mutable.Set invalidFilters = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            scala.collection.immutable.Seq<ClusterLinkFilterInfo> filters = ClusterLinkUtils$.MODULE$.clusterLinkFilters(linkConfig.topicFilters(), tenantPrefix, linkConfig.clusterLinkPrefix());
            scala.collection.immutable.Seq literalIncludeFilters = (scala.collection.immutable.Seq)((IterableOps)filters.filter((Function1 & Serializable)filter -> BoxesRunTime.boxToBoolean((boolean)filter.isLiteralInclude()))).map((Function1 & Serializable)filter -> filter.name());
            invalidFilters.$plus$plus$eq((IterableOnce)literalIncludeFilters.filter((Function1 & Serializable)filter -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManager.$anonfun$checkConflictingLinksWithinRequestForKraft$3(literalTopicFiltersToLinkName, linkName, filter))));
            if (invalidFilters.nonEmpty()) {
                String errorMessages = ((IterableOnceOps)invalidFilters.map((Function1 & Serializable)filter -> new StringBuilder(72).append("new topic filter ").append((String)filter).append(" overlaps with existing topic filter").append(" from cluster link ").append(literalTopicFiltersToLinkName.get(filter)).toString())).mkString("", ", ", ".");
                throw new InvalidConfigurationException(new StringBuilder(35).append("Found overlapping topic filter(s): ").append(errorMessages).toString());
            }
            literalTopicFiltersToLinkName.putAll(CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)((IterableOps)filters.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isLiteralInclude()))).map((Function1 & Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x$3.name()), (Object)linkName))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
        }
        if (linkConfig.clusterLinkPrefix().isDefined()) {
            String prefix = (String)linkConfig.clusterLinkPrefix().get();
            if (prefixes.contains((Object)prefix)) {
                throw new InvalidConfigurationException(new StringBuilder(92).append("Cluster link prefix '").append(prefix).append("' already exists in request. Please").append(" choose another cluster link prefix.").toString());
            }
            prefixes.$plus$eq((Object)prefix);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CompletableFuture<UUID> createClusterLink(NewClusterLink newClusterLink, Option<String> tenantPrefix, ListenerName requestListenerName, boolean validateOnly, boolean validateLink, int timeoutMs, int apiVersion) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(86).append("Attempting to create cluster link with link-name ").append(newClusterLink.linkName()).append(" with validateOnly=").append(validateOnly).append(" and validateLink=").append(validateLink).toString());
        if (this.clusterLinkManager().metadataManager().metadataCache().metadataVersion().isLessThan(MetadataVersion.IBP_2_4_IV0)) {
            throw new InvalidClusterLinkException(new StringBuilder(68).append("Cluster linking is not supported with inter-broker protocol version ").append(this.config().interBrokerProtocolVersion()).toString());
        }
        String linkName = newClusterLink.linkName();
        ClusterLinkUtils.validateLinkNameOrThrow((String)linkName);
        this.clusterLinkManager().ensureLinkNameDoesntExist(linkName);
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq((Map<String, Object>)CollectionConverters$.MODULE$.MapHasAsScala(newClusterLink.configs()).asScala());
        if (!props.containsKey(ClusterLinkConfig$.MODULE$.LocalListenerNameProp())) {
            props.put(ClusterLinkConfig$.MODULE$.LocalListenerNameProp(), requestListenerName.value());
        }
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create(props, true);
        Option expectedClusterId = Option$.MODULE$.apply((Object)newClusterLink.clusterId());
        if (expectedClusterId.contains((Object)this.localClusterId())) {
            throw new InvalidRequestException(new StringBuilder(85).append("Requested cluster ID matches local cluster ID '").append(this.localClusterId()).append("' - cannot create cluster link to self").toString());
        }
        LinkMode linkMode = linkConfig.linkMode();
        LinkMode$Destination$ linkMode$Destination$ = LinkMode$Destination$.MODULE$;
        if (linkMode != null && linkMode.equals(linkMode$Destination$)) {
            ConnectionMode connectionMode = linkConfig.connectionMode();
            ConnectionMode$Inbound$ connectionMode$Inbound$ = ConnectionMode$Inbound$.MODULE$;
            if (connectionMode != null && connectionMode.equals(connectionMode$Inbound$) && expectedClusterId.isEmpty()) {
                throw new InvalidRequestException("Remote cluster id must be provided for destination cluster link that is source initiated");
            }
        }
        LinkMode linkMode2 = linkConfig.linkMode();
        LinkMode$Source$ linkMode$Source$ = LinkMode$Source$.MODULE$;
        if (linkMode2 != null && linkMode2.equals(linkMode$Source$)) {
            ConnectionMode connectionMode = linkConfig.connectionMode();
            ConnectionMode$Inbound$ connectionMode$Inbound$ = ConnectionMode$Inbound$.MODULE$;
            if (connectionMode != null && connectionMode.equals(connectionMode$Inbound$)) {
                throw new InvalidRequestException("Source links are currently supported only for source initiated links");
            }
        }
        CompletableFuture<UUID> result = new CompletableFuture<UUID>();
        Properties persistentProps = this.clusterLinkManager().configEncoder().encode(props);
        LinkMode linkMode3 = linkConfig.linkMode();
        LinkMode$Source$ linkMode$Source$2 = LinkMode$Source$.MODULE$;
        if (linkMode3 != null && linkMode3.equals(linkMode$Source$2)) {
            this.clusterLinkManager().scheduler().schedule("CreateSourceClusterLink", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                try {
                    void var11_19;
                    void var10_18;
                    Tuple2 tuple2;
                    LinkMode linkMode;
                    LinkMode$Source$ linkMode$Source$;
                    ClusterLinkAdminClient withRemoteAdmin_admin;
                    block14: {
                        ClusterLinkAdminClient clusterLinkAdminClient;
                        try {
                            clusterLinkAdminClient = ClusterLinkAdminClient$.MODULE$.createRemoteAdmin(this.config(), linkName, linkConfig, (Option<ClusterLinkDestConnectionManager>)None$.MODULE$, "validate-admin", this.config().brokerId(), $this.metrics, $this.time);
                        }
                        catch (Throwable withRemoteAdmin_e) {
                            throw new InvalidConfigurationException(new StringBuilder(84).append("Unable to create client using provided properties when validating the cluster link: ").append(withRemoteAdmin_e.getMessage()).toString(), withRemoteAdmin_e);
                        }
                        withRemoteAdmin_admin = clusterLinkAdminClient;
                        try {
                            Object object;
                            if (tenantPrefix.forall((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isEmpty())) && linkConfig.clusterLinkPrefix().forall((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isEmpty()))) {
                                object = None$.MODULE$;
                            } else {
                                LinkMode linkMode2 = linkConfig.linkMode();
                                linkMode$Source$ = LinkMode$Source$.MODULE$;
                                object = linkMode2 != null && linkMode2.equals(linkMode$Source$) ? tenantPrefix.map((Function1 & Serializable)prefix -> ClusterLinkManager$.MODULE$.prefixInterceptor((String)prefix, "", linkName, linkConfig.linkMode(), $this.metrics, $this.isMultiTenant, Predef$.MODULE$.Boolean2boolean(linkConfig.clusterLinkPrefixConsumerGroupEnable()))) : new Some((Object)ClusterLinkManager$.MODULE$.prefixInterceptor((String)tenantPrefix.getOrElse((Function0 & Serializable)() -> ""), (String)linkConfig.clusterLinkPrefix().getOrElse((Function0 & Serializable)() -> ""), linkName, linkConfig.linkMode(), $this.metrics, $this.isMultiTenant, Predef$.MODULE$.Boolean2boolean(linkConfig.clusterLinkPrefixConsumerGroupEnable())));
                            }
                            None$ withRemoteAdmin_clientInterceptor = object;
                            linkMode = linkConfig.linkMode();
                            if (LinkMode$Destination$.MODULE$.equals(linkMode)) {
                                withRemoteAdmin_admin.networkClient().enableDestinationClusterLink(null, (ClientInterceptor)withRemoteAdmin_clientInterceptor.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), null);
                                break block14;
                            }
                            if (LinkMode$Source$.MODULE$.equals(linkMode)) {
                                withRemoteAdmin_admin.networkClient().enableSourceClusterLink(null, (ClientInterceptor)withRemoteAdmin_clientInterceptor.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), null, null);
                                break block14;
                            }
                            throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported link mode ").append(linkConfig.linkMode()).toString());
                        }
                        catch (Throwable withRemoteAdmin_e) {
                            throw new InvalidConfigurationException("Unable to enable cluster link for client when validating new link", withRemoteAdmin_e);
                        }
                    }
                    try {
                        ConfluentAdmin confluentAdmin = withRemoteAdmin_admin.admin();
                        tuple2 = this.validateSourceClusterLink(confluentAdmin, linkName, (Option<String>)tenantPrefix, (Option<String>)expectedClusterId, timeoutMs);
                    }
                    finally {
                        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> withRemoteAdmin_admin.close(), this, Level.WARN);
                    }
                    Object var13_10 = null;
                    Object var15_12 = null;
                    linkMode$Source$ = null;
                    linkMode = null;
                    Tuple2 tuple22 = tuple2;
                    if (tuple22 == null) {
                        throw new MatchError(null);
                    }
                    UUID linkId = (UUID)tuple22._1();
                    String remoteClusterId = (String)tuple22._2();
                    this.finishCreateClusterLink(linkName, (Option<UUID>)new Some((Object)var10_18), (Option<String>)new Some((Object)var11_19), tenantPrefix, linkConfig, persistentProps, validateOnly);
                    result.complete((UUID)var10_18);
                    return;
                }
                catch (Throwable e) {
                    result.completeExceptionally(ClusterLinkUtils$.MODULE$.apiException(e, "Unable to validate cluster link"));
                    return;
                }
            }, this.clusterLinkManager().scheduler().schedule$default$3(), this.clusterLinkManager().scheduler().schedule$default$4(), this.clusterLinkManager().scheduler().schedule$default$5());
            return result;
        }
        if (validateLink) {
            ConnectionMode connectionMode = linkConfig.connectionMode();
            ConnectionMode$Outbound$ connectionMode$Outbound$ = ConnectionMode$Outbound$.MODULE$;
            if (connectionMode != null && connectionMode.equals(connectionMode$Outbound$)) {
                this.clusterLinkManager().scheduler().schedule("CreateDestinationClusterLink", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    try {
                        Option option;
                        LinkMode linkMode;
                        LinkMode$Source$ linkMode$Source$;
                        ClusterLinkAdminClient withRemoteAdmin_admin;
                        block13: {
                            ClusterLinkAdminClient clusterLinkAdminClient;
                            try {
                                clusterLinkAdminClient = ClusterLinkAdminClient$.MODULE$.createRemoteAdmin(this.config(), linkName, linkConfig, (Option<ClusterLinkDestConnectionManager>)None$.MODULE$, "validate-admin", this.config().brokerId(), $this.metrics, $this.time);
                            }
                            catch (Throwable withRemoteAdmin_e) {
                                throw new InvalidConfigurationException(new StringBuilder(84).append("Unable to create client using provided properties when validating the cluster link: ").append(withRemoteAdmin_e.getMessage()).toString(), withRemoteAdmin_e);
                            }
                            withRemoteAdmin_admin = clusterLinkAdminClient;
                            try {
                                Object object;
                                if (tenantPrefix.forall((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isEmpty())) && linkConfig.clusterLinkPrefix().forall((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isEmpty()))) {
                                    object = None$.MODULE$;
                                } else {
                                    LinkMode linkMode2 = linkConfig.linkMode();
                                    linkMode$Source$ = LinkMode$Source$.MODULE$;
                                    object = linkMode2 != null && linkMode2.equals(linkMode$Source$) ? tenantPrefix.map((Function1 & Serializable)prefix -> ClusterLinkManager$.MODULE$.prefixInterceptor((String)prefix, "", linkName, linkConfig.linkMode(), $this.metrics, $this.isMultiTenant, Predef$.MODULE$.Boolean2boolean(linkConfig.clusterLinkPrefixConsumerGroupEnable()))) : new Some((Object)ClusterLinkManager$.MODULE$.prefixInterceptor((String)tenantPrefix.getOrElse((Function0 & Serializable)() -> ""), (String)linkConfig.clusterLinkPrefix().getOrElse((Function0 & Serializable)() -> ""), linkName, linkConfig.linkMode(), $this.metrics, $this.isMultiTenant, Predef$.MODULE$.Boolean2boolean(linkConfig.clusterLinkPrefixConsumerGroupEnable())));
                                }
                                None$ withRemoteAdmin_clientInterceptor = object;
                                linkMode = linkConfig.linkMode();
                                if (LinkMode$Destination$.MODULE$.equals(linkMode)) {
                                    withRemoteAdmin_admin.networkClient().enableDestinationClusterLink(null, (ClientInterceptor)withRemoteAdmin_clientInterceptor.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), null);
                                    break block13;
                                }
                                if (LinkMode$Source$.MODULE$.equals(linkMode)) {
                                    withRemoteAdmin_admin.networkClient().enableSourceClusterLink(null, (ClientInterceptor)withRemoteAdmin_clientInterceptor.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), null, null);
                                    break block13;
                                }
                                throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported link mode ").append(linkConfig.linkMode()).toString());
                            }
                            catch (Throwable withRemoteAdmin_e) {
                                throw new InvalidConfigurationException("Unable to enable cluster link for client when validating new link", withRemoteAdmin_e);
                            }
                        }
                        try {
                            ConfluentAdmin confluentAdmin = withRemoteAdmin_admin.admin();
                            option = this.validateDestinationClusterLink((Admin)confluentAdmin, (Option<String>)expectedClusterId, props, timeoutMs, linkName);
                        }
                        finally {
                            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> withRemoteAdmin_admin.close(), this, Level.WARN);
                        }
                        Object var13_11 = null;
                        Object var15_13 = null;
                        linkMode$Source$ = null;
                        linkMode = null;
                        Option remoteClusterId = option;
                        UUID linkId = this.finishCreateClusterLink(linkName, (Option<UUID>)None$.MODULE$, (Option<String>)remoteClusterId, tenantPrefix, linkConfig, persistentProps, validateOnly);
                        result.complete(linkId);
                        return;
                    }
                    catch (Throwable e) {
                        result.completeExceptionally(ClusterLinkUtils$.MODULE$.apiException(e, "Unable to validate cluster link"));
                        return;
                    }
                }, this.clusterLinkManager().scheduler().schedule$default$3(), this.clusterLinkManager().scheduler().schedule$default$4(), this.clusterLinkManager().scheduler().schedule$default$5());
                return result;
            }
        }
        try {
            UUID linkId = this.finishCreateClusterLink(linkName, (Option<UUID>)None$.MODULE$, (Option<String>)expectedClusterId, tenantPrefix, linkConfig, persistentProps, validateOnly);
            result.complete(linkId);
            return result;
        }
        catch (Throwable e) {
            result.completeExceptionally(ClusterLinkUtils$.MODULE$.apiException(e, "Unable to validate cluster link"));
        }
        return result;
    }

    public scala.collection.immutable.Seq<ClusterLinkListing> listClusterLinks(Option<scala.collection.immutable.Set<String>> linkNames, boolean includeTopics, int apiVersion) {
        None$ none$;
        scala.collection.immutable.Seq clusterLinkDatas = (scala.collection.immutable.Seq)this.clusterLinkManager().listClusterLinks().filter((Function1 & Serializable)cld -> BoxesRunTime.boxToBoolean((boolean)linkNames.forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains((Object)cld.linkName())))));
        if (includeTopics) {
            scala.collection.immutable.Set linkIds = ((IterableOnceOps)clusterLinkDatas.map((Function1 & Serializable)x$6 -> x$6.linkId())).toSet();
            none$ = new Some(this.clusterLinkManager().metadataManager().allMirrorTopics(false).filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)linkIds.contains((Object)((ClusterLinkTopicState)e._2()).linkId()))));
        } else {
            none$ = None$.MODULE$;
        }
        None$ topics = none$;
        return (scala.collection.immutable.Seq)clusterLinkDatas.map(arg_0 -> ClusterLinkAdminManager.$anonfun$listClusterLinks$5(this, (Option)topics, arg_0));
    }

    public scala.collection.immutable.Seq<ClusterLinkDescription> describeClusterLinks(Option<scala.collection.immutable.Set<String>> linkNames, boolean includeTopics) {
        None$ none$;
        scala.collection.immutable.Seq clusterLinksData = (scala.collection.immutable.Seq)this.clusterLinkManager().listClusterLinks().filter((Function1 & Serializable)cld -> BoxesRunTime.boxToBoolean((boolean)linkNames.forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.contains((Object)cld.linkName())))));
        if (includeTopics) {
            scala.collection.immutable.Set linkIds = ((IterableOnceOps)clusterLinksData.map((Function1 & Serializable)x$9 -> x$9.linkId())).toSet();
            none$ = new Some(this.clusterLinkManager().metadataManager().allMirrorTopics(false).filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)linkIds.contains((Object)((ClusterLinkTopicState)e._2()).linkId()))));
        } else {
            none$ = None$.MODULE$;
        }
        None$ topics = none$;
        return (scala.collection.immutable.Seq)clusterLinksData.map(arg_0 -> ClusterLinkAdminManager.$anonfun$describeClusterLinks$5(this, (Option)topics, arg_0));
    }

    @Override
    public void deleteClusterLink(String linkName, boolean validateOnly, boolean force, int apiVersion) {
        String topicsInUse;
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Attempting to delete cluster link ").append(linkName).append(" with validateOnly=").append(validateOnly).append(" and force=").append(force).toString());
        ClusterLinkUtils.validateLinkNameOrThrow((String)linkName);
        UUID linkId = this.clusterLinkManager().resolveLinkIdOrThrow(linkName);
        if (!force && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(topicsInUse = ((MapOps)this.getAllMirrorTopicsInUse().filter((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManager.$anonfun$deleteClusterLink$2(linkId, x$13)))).keys().mkString(", ")))) {
            throw new ClusterLinkInUseException(new StringBuilder(45).append("Cluster link '").append(linkName).append("' with ID '").append(linkId).append("' in use by topics: ").append(topicsInUse).toString());
        }
        if (!validateOnly) {
            this.clusterLinkManager().deleteClusterLink(linkName, linkId);
            return;
        }
    }

    @Override
    public CompletableFuture<Void> alterMirror(String topic, AlterMirrorOp op, boolean validateOnly, int apiVersion) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Attempting to alter mirror topic ").append(topic).append(" with request ").append(op).append(" and validateOnly=").append(validateOnly).toString());
        if (AlterMirrorOp.PROMOTE.equals(op)) {
            return this.stopMirrorTopic(topic, true, validateOnly);
        }
        if (AlterMirrorOp.FAILOVER.equals(op)) {
            return this.stopMirrorTopic(topic, false, validateOnly);
        }
        if (AlterMirrorOp.CLEAR.equals(op)) {
            return this.clearMirrorTopic(topic, validateOnly);
        }
        if (AlterMirrorOp.PAUSE.equals(op)) {
            return this.pauseMirrorTopic(topic, true, false, validateOnly);
        }
        if (AlterMirrorOp.RESUME.equals(op)) {
            return this.pauseMirrorTopic(topic, false, false, validateOnly);
        }
        if (AlterMirrorOp.PAUSE_LINK.equals(op)) {
            return this.pauseMirrorTopic(topic, true, true, validateOnly);
        }
        if (AlterMirrorOp.RESUME_LINK.equals(op)) {
            return this.pauseMirrorTopic(topic, false, true, validateOnly);
        }
        throw new UnsupportedVersionException("Unknown alter mirrors op type");
    }

    /*
     * Enabled aggressive block sorting
     */
    private CompletableFuture<Void> stopMirrorTopic(String topic, boolean synchronize, boolean validateOnly) {
        ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirror;
        block8: {
            Option option;
            block9: {
                boolean bl;
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(76).append("Requested to stop mirror topic for topic '").append(topic).append("' with synchronize=").append(synchronize).append(", validateOnly=").append(validateOnly).toString());
                Topic.validate((String)topic);
                if (!this.clusterLinkManager().metadataManager().hasTopic(topic)) {
                    throw new UnknownTopicOrPartitionException(new StringBuilder(16).append("Topic ").append(topic).append(" not found").toString());
                }
                option = this.clusterLinkManager().metadataManager().clusterLinkTopicState((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).get((Object)topic);
                if (!(option instanceof Some)) break block9;
                ClusterLinkTopicState clusterLink = (ClusterLinkTopicState)((Some)option).value();
                String linkName = clusterLink.linkName();
                if (clusterLink instanceof ClusterLinkTopicState.Mirror ? true : (clusterLink instanceof ClusterLinkTopicState.FailedMirror ? true : clusterLink instanceof ClusterLinkTopicState.PausedMirror)) {
                    pendingStoppedMirror = new ClusterLinkTopicState.PendingStoppedMirror(linkName, clusterLink.linkId(), clusterLink.sourceTopicId(), synchronize, Time.SYSTEM.milliseconds());
                    break block8;
                } else if (clusterLink instanceof ClusterLinkTopicState.PendingStoppedMirror && (bl = ((ClusterLinkTopicState.PendingStoppedMirror)clusterLink).synchronize()) && !synchronize) {
                    pendingStoppedMirror = new ClusterLinkTopicState.PendingStoppedMirror(linkName, clusterLink.linkId(), clusterLink.sourceTopicId(), false, Time.SYSTEM.milliseconds());
                    break block8;
                } else {
                    if (clusterLink instanceof ClusterLinkTopicState.PendingStoppedMirror ? true : clusterLink instanceof ClusterLinkTopicState.StoppedMirror) {
                        throw new InvalidRequestException(new StringBuilder(47).append("Topic '").append(topic).append("' has already stopped its mirror from '").append(linkName).append("'").toString());
                    }
                    throw new MatchError((Object)clusterLink);
                }
            }
            if (None$.MODULE$.equals(option)) {
                throw new InvalidRequestException(new StringBuilder(24).append("Topic '").append(topic).append("' is not mirrored").toString());
            }
            throw new MatchError((Object)option);
        }
        ClusterLinkTopicState.PendingStoppedMirror newClusterLink = pendingStoppedMirror;
        if (!validateOnly) {
            this.clusterLinkManager().metadataManager().setMirrorTopicState(topic, (Option<ClusterLinkTopicState>)new Some((Object)newClusterLink));
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> clearMirrorTopic(String topic, boolean validateOnly) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Requested to clear mirror topic for topic '").append(topic).append("' with validateOnly=").append(validateOnly).toString());
        Topic.validate((String)topic);
        if (!this.clusterLinkManager().metadataManager().hasTopic(topic)) {
            throw new UnknownTopicOrPartitionException(new StringBuilder(16).append("Topic ").append(topic).append(" not found").toString());
        }
        if (!validateOnly && this.clusterLinkManager().metadataManager().clusterLinkTopicState((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).contains((Object)topic)) {
            this.clusterLinkManager().metadataManager().setMirrorTopicState(topic, (Option<ClusterLinkTopicState>)None$.MODULE$);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * Unable to fully structure code
     */
    private CompletableFuture<Void> pauseMirrorTopic(String topic, boolean enable, boolean isLinkLevel, boolean validateOnly) {
        this.debug((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$pauseMirrorTopic$1(java.lang.String boolean boolean boolean ), ()Ljava/lang/String;)((String)topic, (boolean)enable, (boolean)isLinkLevel, (boolean)validateOnly));
        Topic.validate((String)topic);
        if (!this.clusterLinkManager().metadataManager().hasTopic(topic)) {
            throw new UnknownTopicOrPartitionException(new StringBuilder(16).append("Topic ").append(topic).append(" not found").toString());
        }
        var6_5 = false;
        var7_6 = null;
        var8_7 = this.clusterLinkManager().metadataManager().clusterLinkTopicState((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).get((Object)topic);
        if (!(var8_7 instanceof Some)) ** GOTO lbl-1000
        var6_5 = true;
        var7_6 = (Some)var8_7;
        clusterLink = (ClusterLinkTopicState)var7_6.value();
        if (enable) {
            v0 = clusterLink.toPausedState(isLinkLevel);
        } else if (var6_5) {
            v0 = ((ClusterLinkTopicState)var7_6.value()).toUnpausedState(isLinkLevel);
        } else {
            if (None$.MODULE$.equals(var8_7)) {
                throw new InvalidRequestException(new StringBuilder(24).append("Topic '").append(topic).append("' is not mirrored").toString());
            }
            throw new MatchError((Object)var8_7);
        }
        newClusterLink = v0;
        if (!validateOnly) {
            newClusterLink.foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$pauseMirrorTopic$2$adapted(kafka.server.link.ClusterLinkAdminManager java.lang.String kafka.server.link.ClusterLinkTopicState ), (Lkafka/server/link/ClusterLinkTopicState;)Ljava/lang/Object;)((ClusterLinkAdminManager)this, (String)topic));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Iterable<String> listMirrors(Option<String> linkName, boolean includeStopped, int apiVersion) {
        Option linkId = linkName.map((Function1 & Serializable)ln -> this.clusterLinkManager().resolveLinkIdOrThrow((String)ln));
        return ((MapOps)this.clusterLinkManager().metadataManager().allMirrorTopics(includeStopped).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManager.$anonfun$listMirrors$2(linkId, x0$1)))).keys();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MirrorTopicDescription describeMirror(String topic, int apiVersion) {
        String string;
        Object object;
        List list;
        void var7_7;
        Topic.validate((String)topic);
        int numPartitions = BoxesRunTime.unboxToInt((Object)this.clusterLinkManager().metadataManager().numPartitions(topic).getOrElse((Function0 & Serializable)() -> {
            throw new UnknownTopicOrPartitionException(new StringBuilder(15).append("Unknown topic: ").append(topic).toString());
        }));
        ClusterLinkTopicState state = (ClusterLinkTopicState)this.clusterLinkManager().metadataManager().clusterLinkTopicState((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).getOrElse((Object)topic, (Function0 & Serializable)() -> {
            throw new ClusterLinkNotFoundException(new StringBuilder(24).append("Topic '").append(topic).append("' is not mirrored").toString());
        });
        if (!this.clusterLinkManager().hasKraftSupport() && this.clusterLinkManager().metadataManager().isTopicQueuedUpForDeletion(topic)) {
            throw new UnknownTopicOrPartitionException(new StringBuilder(15).append("Unknown topic: ").append(topic).toString());
        }
        Option<ClusterLinkInfo> clusterLinkInfo = this.clusterLinkManager().clusterLinkInfo(state.linkName());
        Tuple2 tuple2 = (Tuple2)clusterLinkInfo.map((Function1 & Serializable)link -> {
            MirrorTopicDescription.State state = state.mirrorTopicDescriptionState();
            MirrorTopicDescription.State state2 = MirrorTopicDescription.State.STOPPED;
            if (!(state != null ? !state.equals(state2) : state2 != null)) {
                return new Tuple2((Object)state.mirrorTopicDescriptionState(), (Object)BoxesRunTime.boxToLong((long)state.timeMs()));
            }
            LinkState linkState = link.linkStateInfo().linkState();
            FailedClusterLink$ failedClusterLink$ = FailedClusterLink$.MODULE$;
            if (linkState != null && linkState.equals(failedClusterLink$)) {
                return new Tuple2((Object)MirrorTopicDescription.State.LINK_FAILED, (Object)BoxesRunTime.boxToLong((long)state.timeMs()));
            }
            LinkState linkState2 = link.linkStateInfo().linkState();
            UnavailableClusterLink$ unavailableClusterLink$ = UnavailableClusterLink$.MODULE$;
            if (linkState2 != null && linkState2.equals(unavailableClusterLink$)) {
                return new Tuple2((Object)MirrorTopicDescription.State.SOURCE_UNAVAILABLE, (Object)BoxesRunTime.boxToLong((long)this.clusterLinkManager().linkStateMs(state.linkName())));
            }
            if (this.isTopicPaused(state)) {
                return new Tuple2((Object)state.mirrorTopicDescriptionState(), (Object)BoxesRunTime.boxToLong((long)state.timeMs()));
            }
            LinkState linkState3 = link.linkStateInfo().linkState();
            PausedClusterLink$ pausedClusterLink$ = PausedClusterLink$.MODULE$;
            if (linkState3 != null && linkState3.equals(pausedClusterLink$)) {
                return new Tuple2((Object)MirrorTopicDescription.State.LINK_PAUSED, (Object)BoxesRunTime.boxToLong((long)this.clusterLinkManager().linkStateMs(state.linkName())));
            }
            return new Tuple2((Object)state.mirrorTopicDescriptionState(), (Object)BoxesRunTime.boxToLong((long)state.timeMs()));
        }).getOrElse((Function0 & Serializable)() -> new Tuple2((Object)MirrorTopicDescription.State.SOURCE_UNAVAILABLE, (Object)BoxesRunTime.boxToLong((long)state.timeMs())));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MirrorTopicDescription.State mirrorTopicState = (MirrorTopicDescription.State)tuple2._1();
        long l = tuple2._2$mcJ$sp();
        void v0 = var7_7;
        MirrorTopicDescription.State state2 = MirrorTopicDescription.State.STOPPED;
        if (!(v0 != null ? !v0.equals(state2) : state2 != null)) {
            ClusterLinkTopicState.StoppedMirror stoppedMirrorState = (ClusterLinkTopicState.StoppedMirror)state;
            list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)stoppedMirrorState.logEndOffsets().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToLong((Object)x$1))).asJava();
        } else {
            list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava();
        }
        List stoppedLogEndOffsets = list;
        Option option = this.clusterLinkManager().connectionManager(state.linkId()).map((Function1 & Serializable)x$16 -> x$16.currentConfig());
        if (option instanceof Some) {
            ClusterLinkConfig config = (ClusterLinkConfig)((Object)((Some)option).value());
            object = config != null ? config.clusterLinkPrefix() : None$.MODULE$;
        } else if (None$.MODULE$.equals(option)) {
            object = None$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        Option<String> linkPrefix = object;
        if (linkPrefix instanceof Some) {
            String linkPrefix2 = (String)((Some)linkPrefix).value();
            String tenantPrefix = (String)clusterLinkInfo.flatMap((Function1 & Serializable)x$17 -> x$17.clusterLinkData().tenantPrefix()).getOrElse((Function0 & Serializable)() -> "");
            if (!topic.startsWith(new StringBuilder(0).append(tenantPrefix).append(linkPrefix2).toString())) {
                String msg = new StringBuilder(59).append("Invalid topic ").append(topic).append(" with cluster link prefix ").append(linkPrefix2).append(" and tenant prefix ").append(tenantPrefix).toString();
                this.error((Function0<String>)(Function0 & Serializable)() -> msg);
                throw new IllegalStateException(msg);
            }
            string = new StringBuilder(0).append(tenantPrefix).append(topic.substring(tenantPrefix.length() + linkPrefix2.length())).toString();
        } else if (None$.MODULE$.equals(linkPrefix)) {
            string = topic;
        } else {
            throw new MatchError(linkPrefix);
        }
        String sourceTopic = string;
        return new MirrorTopicDescription(state.linkName(), CoreUtils$.MODULE$.toKafkaUUID(state.linkId()), sourceTopic, numPartitions, (MirrorTopicDescription.State)var7_7, l, stoppedLogEndOffsets, state.sourceTopicId());
    }

    private boolean isTopicPaused(ClusterLinkTopicState state) {
        if (state instanceof ClusterLinkTopicState.PausedMirror) {
            return ((ClusterLinkTopicState.PausedMirror)state).topicLevel();
        }
        return false;
    }

    private UUID finishCreateClusterLink(String linkName, Option<UUID> linkIdOpt, Option<String> linkClusterId, Option<String> tenantPrefix, ClusterLinkConfig linkConfig, Properties persistentProps, boolean validateOnly) {
        UUID linkId = (UUID)linkIdOpt.getOrElse((Function0 & Serializable)() -> UUID.randomUUID());
        if (!validateOnly) {
            ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, linkClusterId, tenantPrefix, false);
            this.clusterLinkManager().createClusterLink(clusterLinkData, linkConfig, persistentProps);
        }
        return linkId;
    }

    private <T> T withRemoteAdmin(String linkName, ClusterLinkConfig linkConfig, Option<String> tenantPrefix, Function1<ConfluentAdmin, T> func) {
        Object object;
        ClusterLinkAdminClient admin;
        block11: {
            ClusterLinkAdminClient clusterLinkAdminClient;
            try {
                clusterLinkAdminClient = ClusterLinkAdminClient$.MODULE$.createRemoteAdmin(this.config(), linkName, linkConfig, (Option<ClusterLinkDestConnectionManager>)None$.MODULE$, "validate-admin", this.config().brokerId(), this.metrics, this.time);
            }
            catch (Throwable e) {
                throw new InvalidConfigurationException(new StringBuilder(84).append("Unable to create client using provided properties when validating the cluster link: ").append(e.getMessage()).toString(), e);
            }
            admin = clusterLinkAdminClient;
            try {
                Object object2;
                if (tenantPrefix.forall((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isEmpty())) && linkConfig.clusterLinkPrefix().forall((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isEmpty()))) {
                    object2 = None$.MODULE$;
                } else {
                    LinkMode linkMode = linkConfig.linkMode();
                    LinkMode$Source$ linkMode$Source$ = LinkMode$Source$.MODULE$;
                    object2 = linkMode != null && linkMode.equals(linkMode$Source$) ? tenantPrefix.map((Function1 & Serializable)prefix -> ClusterLinkManager$.MODULE$.prefixInterceptor((String)prefix, "", linkName, linkConfig.linkMode(), $this.metrics, $this.isMultiTenant, Predef$.MODULE$.Boolean2boolean(linkConfig.clusterLinkPrefixConsumerGroupEnable()))) : new Some((Object)ClusterLinkManager$.MODULE$.prefixInterceptor((String)tenantPrefix.getOrElse((Function0 & Serializable)() -> ""), (String)linkConfig.clusterLinkPrefix().getOrElse((Function0 & Serializable)() -> ""), linkName, linkConfig.linkMode(), this.metrics, this.isMultiTenant, Predef$.MODULE$.Boolean2boolean(linkConfig.clusterLinkPrefixConsumerGroupEnable())));
                }
                None$ clientInterceptor = object2;
                LinkMode linkMode = linkConfig.linkMode();
                if (LinkMode$Destination$.MODULE$.equals(linkMode)) {
                    admin.networkClient().enableDestinationClusterLink(null, (ClientInterceptor)clientInterceptor.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), null);
                    break block11;
                }
                if (LinkMode$Source$.MODULE$.equals(linkMode)) {
                    admin.networkClient().enableSourceClusterLink(null, (ClientInterceptor)clientInterceptor.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), null, null);
                    break block11;
                }
                throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported link mode ").append(linkConfig.linkMode()).toString());
            }
            catch (Throwable e) {
                throw new InvalidConfigurationException("Unable to enable cluster link for client when validating new link", e);
            }
        }
        try {
            object = func.apply((Object)admin.admin());
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> withRemoteAdmin_admin.close(), this, Level.WARN);
        }
        return (T)object;
    }

    private Option<String> validateDestinationClusterLink(Admin admin, Option<String> expectedClusterId, Properties props, int timeoutMs, String linkName) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Validating creating destination cluster link ").append(linkName).toString());
        boolean aclSyncEnabled = ClusterLinkConfig$.MODULE$.create(props, true).aclSyncEnable();
        DescribeClusterResult describeResult = admin.describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(aclSyncEnabled).timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs)));
        if (aclSyncEnabled && !((Set)describeResult.authorizedOperations().get()).contains(AclOperation.DESCRIBE)) {
            throw new ClusterAuthorizationException("ACL sync was requested, but link credentials don't have DESCRIBE access for the source cluster");
        }
        Option linkClusterId = Option$.MODULE$.apply(describeResult.clusterId().get());
        if (linkClusterId instanceof Some) {
            String lcid = (String)((Some)linkClusterId).value();
            expectedClusterId.foreach((Function1 & Serializable)ecid -> {
                ClusterLinkAdminManager.$anonfun$validateDestinationClusterLink$2(lcid, ecid);
                return BoxedUnit.UNIT;
            });
        } else if (None$.MODULE$.equals(linkClusterId)) {
            expectedClusterId.foreach((Function1 & Serializable)ecid -> {
                throw new InvalidRequestException(new StringBuilder(67).append("Expected cluster ID '").append((String)ecid).append("' does not match due to no resolved cluster ID").toString());
            });
        } else {
            throw new MatchError((Object)linkClusterId);
        }
        return linkClusterId;
    }

    private Tuple2<UUID, String> validateSourceClusterLink(ConfluentAdmin remoteAdmin, String linkName, Option<String> tenantPrefix2, Option<String> expectedDestClusterId, int timeoutMs) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Validating creating source cluster link ").append(linkName).toString());
        Iterator iterator = ((Collection)remoteAdmin.listClusterLinks((ListClusterLinksOptions)new ListClusterLinksOptions().linkNames(Optional.of(Collections.singletonList(linkName))).timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs))).result().get()).iterator();
        if (!iterator.hasNext()) {
            throw new InvalidConfigurationException(new StringBuilder(105).append("Source initiated link '").append(linkName).append("' cannot be created because the destination cluster does not have a link named '").append(linkName).append("'.").toString());
        }
        ClusterLinkListing result = (ClusterLinkListing)iterator.next();
        if (!((Set)remoteAdmin.describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(true).timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs))).authorizedOperations().get()).contains(AclOperation.ALTER)) {
            throw new ClusterAuthorizationException("Link credentials don't have ALTER access for the destination cluster");
        }
        String destClusterId = result.localClusterId();
        String sourceClusterId = result.remoteClusterId();
        UUID linkId = CoreUtils$.MODULE$.toJavaUUID(result.clusterLinkId());
        Option option = Option$.MODULE$.apply((Object)destClusterId);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new InvalidRequestException("Destination cluster id could not be determined for the cluster link");
            }
            throw new MatchError((Object)option);
        }
        String clusterId = (String)((Some)option).value();
        expectedDestClusterId.foreach((Function1 & Serializable)expectedId -> {
            ClusterLinkAdminManager.$anonfun$validateSourceClusterLink$2(clusterId, expectedId);
            return BoxedUnit.UNIT;
        });
        String expectedSourceClusterId = (String)tenantPrefix2.map((Function1 & Serializable)tenantPrefix -> ClusterLinkUtils$.MODULE$.logicalCluster((String)tenantPrefix)).getOrElse((Function0 & Serializable)() -> this.localClusterId());
        String string = sourceClusterId;
        if (string == null ? expectedSourceClusterId != null : !string.equals(expectedSourceClusterId)) {
            throw new InvalidRequestException(new StringBuilder(84).append("Source cluster id '").append(expectedSourceClusterId).append("' does not match the cluster id '").append(sourceClusterId).append("' configured on the destination.").toString());
        }
        return new Tuple2((Object)linkId, (Object)destClusterId);
    }

    private Map<String, ClusterLinkTopicState> getAllMirrorTopicsInUse() {
        return ((IterableOnceOps)this.clusterLinkManager().metadataManager().allMirrorTopics(false).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManager.$anonfun$getAllMirrorTopicsInUse$1(x0$1)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private ApiException validationException(Throwable throwable) {
        return ClusterLinkUtils$.MODULE$.apiException(throwable, "Unable to validate cluster link");
    }

    public static final /* synthetic */ String $anonfun$validateLinksWithCreateClusterLinkRequestForKraft$7(ClusterLinkAdminManager $this, Option expectedClusterId$1, Properties props$1, CreateClusterLinksRequest request$1, String linkName$1, NewClusterLink ncl$1, ConfluentAdmin admin) {
        return (String)$this.validateDestinationClusterLink((Admin)admin, (Option<String>)expectedClusterId$1, props$1, request$1.timeoutMs(), linkName$1).getOrElse((Function0 & Serializable)() -> {
            throw new InvalidRequestException(new StringBuilder(48).append("Source ClusterId could not be ").append("resolved for link ").append(ncl$1).toString());
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkConflictingLinksWithinRequestForKraft$3(java.util.Map literalTopicFiltersToLinkName$2, String linkName$2, String filter) {
        if (literalTopicFiltersToLinkName$2.containsKey(filter)) {
            Object v = literalTopicFiltersToLinkName$2.get(filter);
            if (v == null ? linkName$2 != null : !v.equals(linkName$2)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$listClusterLinks$6(ClusterLinkData cld$2, Tuple2 x$7) {
        UUID uUID = ((ClusterLinkTopicState)x$7._2()).linkId();
        UUID uUID2 = cld$2.linkId();
        return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
    }

    public static final /* synthetic */ ClusterLinkListing $anonfun$listClusterLinks$5(ClusterLinkAdminManager $this, Option topics$1, ClusterLinkData cld) {
        Optional<Object> optional;
        if (topics$1 instanceof Some) {
            Map lt = (Map)((Some)topics$1).value();
            optional = Optional.of(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)((MapOps)lt.filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManager.$anonfun$listClusterLinks$6(cld, x$7)))).keys().toList()).asJavaCollection());
        } else if (None$.MODULE$.equals(topics$1)) {
            optional = Optional.empty();
        } else {
            throw new MatchError((Object)topics$1);
        }
        Optional linkTopics = optional;
        boolean available = $this.clusterLinkManager().isLinkAvailable(cld.linkName());
        return new ClusterLinkListing(cld.linkName(), CoreUtils$.MODULE$.toKafkaUUID(cld.linkId()), (String)cld.clusterId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), $this.localClusterId(), linkTopics, available);
    }

    public static final /* synthetic */ boolean $anonfun$describeClusterLinks$6(ClusterLinkData cld$4, Tuple2 x$10) {
        UUID uUID = ((ClusterLinkTopicState)x$10._2()).linkId();
        UUID uUID2 = cld$4.linkId();
        return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ClusterLinkDescription $anonfun$describeClusterLinks$5(ClusterLinkAdminManager $this, Option topics$2, ClusterLinkData cld) {
        void var13_14;
        ClusterLinkDescription.ConnectionMode connectionMode;
        ClusterLinkDescription.LinkMode linkMode;
        ClusterLinkDescription.LinkState linkState;
        Collection collection;
        if (topics$2 instanceof Some) {
            Map lt = (Map)((Some)topics$2).value();
            collection = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)((MapOps)lt.filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManager.$anonfun$describeClusterLinks$6(cld, x$10)))).keys().toList()).asJavaCollection();
        } else if (None$.MODULE$.equals(topics$2)) {
            collection = null;
        } else {
            throw new MatchError((Object)topics$2);
        }
        Collection linkTopics = collection;
        LinkState linkState2 = $this.clusterLinkManager().linkState(cld.linkName());
        if (ActiveClusterLink$.MODULE$.equals(linkState2)) {
            linkState = ClusterLinkDescription.LinkState.ACTIVE;
        } else if (FailedClusterLink$.MODULE$.equals(linkState2)) {
            linkState = ClusterLinkDescription.LinkState.FAILED;
        } else if (UnavailableClusterLink$.MODULE$.equals(linkState2)) {
            linkState = ClusterLinkDescription.LinkState.UNAVAILABLE;
        } else if (PausedClusterLink$.MODULE$.equals(linkState2)) {
            linkState = ClusterLinkDescription.LinkState.PAUSED;
        } else {
            throw new IllegalStateException("Unhandled cluster link state");
        }
        ClusterLinkDescription.LinkState linkState3 = linkState;
        Option currentConfig = $this.clusterLinkManager().connectionManager(cld.linkId()).map((Function1 & Serializable)x$11 -> x$11.currentConfig());
        if (currentConfig instanceof Some) {
            ClusterLinkConfig config = (ClusterLinkConfig)((Object)((Some)currentConfig).value());
            if (config == null) {
                linkMode = ClusterLinkDescription.LinkMode.UNKNOWN;
                connectionMode = ClusterLinkDescription.ConnectionMode.UNKNOWN;
            } else {
                ClusterLinkDescription.ConnectionMode connectionMode2;
                ClusterLinkDescription.LinkMode linkMode2;
                LinkMode linkMode3 = config.linkMode();
                if (LinkMode$Destination$.MODULE$.equals(linkMode3)) {
                    linkMode2 = ClusterLinkDescription.LinkMode.DESTINATION;
                } else if (LinkMode$Source$.MODULE$.equals(linkMode3)) {
                    linkMode2 = ClusterLinkDescription.LinkMode.SOURCE;
                } else {
                    throw new IllegalStateException("Unhandled cluster link mode");
                }
                ClusterLinkDescription.LinkMode linkModeEnum = linkMode2;
                ConnectionMode connectionMode3 = config.connectionMode();
                if (ConnectionMode$Outbound$.MODULE$.equals(connectionMode3)) {
                    connectionMode2 = ClusterLinkDescription.ConnectionMode.OUTBOUND;
                } else if (ConnectionMode$Inbound$.MODULE$.equals(connectionMode3)) {
                    connectionMode2 = ClusterLinkDescription.ConnectionMode.INBOUND;
                } else {
                    throw new IllegalStateException("Unhandled cluster link connection mode");
                }
                ClusterLinkDescription.ConnectionMode connectionModeEnum = connectionMode2;
                linkMode = linkModeEnum;
                connectionMode = connectionModeEnum;
            }
        } else {
            if (None$.MODULE$.equals(currentConfig)) {
                throw new IllegalStateException("Cluster link not found");
            }
            throw new MatchError((Object)currentConfig);
        }
        ClusterLinkDescription.ConnectionMode connectionMode4 = connectionMode;
        ClusterLinkDescription.LinkMode linkMode4 = linkMode;
        return new ClusterLinkDescription(cld.linkName(), CoreUtils$.MODULE$.toKafkaUUID(cld.linkId()), (String)cld.clusterId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), $this.localClusterId(), linkTopics, linkState3, (ClusterLinkDescription.LinkMode)var13_14, connectionMode4);
    }

    public static final /* synthetic */ boolean $anonfun$deleteClusterLink$2(UUID linkId$1, Tuple2 x$13) {
        UUID uUID = ((ClusterLinkTopicState)x$13._2()).linkId();
        return !(uUID != null ? !((Object)uUID).equals(linkId$1) : linkId$1 != null);
    }

    public static final /* synthetic */ String $anonfun$pauseMirrorTopic$1(String topic$4, boolean enable$1, boolean isLinkLevel$1, boolean validateOnly$6) {
        return new StringBuilder(86).append("Requested to pause mirror topic for topic '").append(topic$4).append("' with enable=").append(enable$1).append(", isLinkLevel=").append(isLinkLevel$1).append(", validateOnly=").append(validateOnly$6).toString();
    }

    public static final /* synthetic */ void $anonfun$pauseMirrorTopic$2(ClusterLinkAdminManager $this, String topic$4, ClusterLinkTopicState ncl) {
        $this.clusterLinkManager().metadataManager().setMirrorTopicState(topic$4, (Option<ClusterLinkTopicState>)new Some((Object)ncl));
    }

    public static final /* synthetic */ boolean $anonfun$listMirrors$3(ClusterLinkTopicState state$1, UUID x$14) {
        UUID uUID = x$14;
        UUID uUID2 = state$1.linkId();
        return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$listMirrors$2(Option linkId$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            ClusterLinkTopicState state = (ClusterLinkTopicState)x0$1._2();
            return linkId$2.forall((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManager.$anonfun$listMirrors$3(state, x$14)));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$validateDestinationClusterLink$2(String lcid$1, String ecid) {
        String string = ecid;
        if (string == null ? lcid$1 != null : !string.equals(lcid$1)) {
            throw new InvalidRequestException(new StringBuilder(60).append("Expected cluster ID '").append(ecid).append("' does not match resolved cluster ID '").append(lcid$1).append("'").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$validateSourceClusterLink$2(String clusterId$1, String expectedId) {
        String string = expectedId;
        if (string == null ? clusterId$1 != null : !string.equals(clusterId$1)) {
            throw new InvalidRequestException(new StringBuilder(60).append("Expected cluster ID '").append(expectedId).append("' does not match the dest cluster ID '").append(clusterId$1).append("'").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$getAllMirrorTopicsInUse$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return !((ClusterLinkTopicState)x0$1._2() instanceof ClusterLinkTopicState.PendingStoppedMirror);
        }
        throw new MatchError(null);
    }

    public ClusterLinkAdminManager(KafkaConfig config, String localClusterId, ClusterLinkManager clusterLinkManager, Metrics metrics, Time time, boolean isMultiTenant) {
        this.config = config;
        this.localClusterId = localClusterId;
        this.clusterLinkManager = clusterLinkManager;
        this.metrics = metrics;
        this.time = time;
        this.isMultiTenant = isMultiTenant;
        this.logIdent_$eq(new StringBuilder(41).append("[Cluster Link Admin Manager on Broker ").append(config.brokerId()).append("]: ").toString());
        this.purgatory = new DelayedFuturePurgatory("ClusterLink", config.brokerId());
    }

    public static final /* synthetic */ Object $anonfun$pauseMirrorTopic$2$adapted(ClusterLinkAdminManager $this, String topic$4, ClusterLinkTopicState ncl) {
        ClusterLinkAdminManager.$anonfun$pauseMirrorTopic$2($this, topic$4, ncl);
        return BoxedUnit.UNIT;
    }
}

