/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import kafka.server.link.ClusterLinkClearLinkReference$;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataManagerWithKRaftSupport;
import kafka.server.link.ClusterLinkMetadataManagerWithZkSupport;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.utils.CoreUtils$;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001\u0002\u0014(\u00019B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\n\u0001\u0002\u0011\t\u0011)A\u0005\u0003\u0012C\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0015\"A1\f\u0001B\u0001B\u0003%A\f\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003f\u0011!Y\u0007A!A!\u0002\u0013a\u0007\"C8\u0001\u0005\u0003\u0005\u000b\u0011\u00027q\u0011!\u0011\bA!A!\u0002\u0013a\u0007\"B:\u0001\t\u0003!\b\u0002C@\u0001\u0005\u0004%I!!\u0001\t\u0011\u0005M\u0001\u0001)A\u0005\u0003\u0007A\u0011\"!\u0006\u0001\u0001\u0004%I!a\u0006\t\u0013\u0005}\u0001\u00011A\u0005\n\u0005\u0005\u0002\u0002CA\u0014\u0001\u0001\u0006K!!\u0007\t\u0017\u0005%\u0002\u00011AA\u0002\u0013%\u00111\u0006\u0005\f\u00037\u0002\u0001\u0019!a\u0001\n\u0013\ti\u0006C\u0006\u0002b\u0001\u0001\r\u0011!Q!\n\u00055\u0002bBA2\u0001\u0011E\u0013Q\r\u0005\b\u0003O\u0002A\u0011BA3\u0011\u001d\tI\u0007\u0001C\u0005\u0003WBq!!\u001b\u0001\t\u0013\t9\bC\u0004\u0002\u0004\u0002!I!!\u001a\t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002f!9\u0011q\u0011\u0001\u0005\n\u0005%\u0005bBAH\u0001\u0011%\u0011\u0011\u0013\u0005\b\u0003c\u0003A\u0011BA3\u0011\u001d\t\u0019\f\u0001C\u0001\u0003/9q!!.(\u0011\u0003\t9L\u0002\u0004'O!\u0005\u0011\u0011\u0018\u0005\u0007gz!\t!!4\t\u0011\u0005=g\u0004\"\u0001(\u0003#D\u0001\"!7\u001f\t\u00039\u00131\u001c\u0005\t\u0003?tB\u0011A\u0014\u0002b\"I\u0011Q\u001d\u0010\u0012\u0002\u0013\u0005\u0011q\u001d\u0005\n\u0003{t\u0012\u0013!C\u0001\u0003OD\u0011\"a@\u001f#\u0003%\t!a:\u0003;\rcWo\u001d;fe2Kgn[\"mK\u0006\u0014H*\u001b8l%\u00164WM]3oG\u0016T!\u0001K\u0015\u0002\t1Lgn\u001b\u0006\u0003U-\naa]3sm\u0016\u0014(\"\u0001\u0017\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\f\t\u0003aQr!!\r\u001a\u000e\u0003\u001dJ!aM\u0014\u0002)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0013\t)dG\u0001\u0007QKJLw\u000eZ5d)\u0006\u001c8N\u0003\u00024O\u00051A.\u001b8l\u0013\u0012\u0004\"!\u000f \u000e\u0003iR!a\u000f\u001f\u0002\tU$\u0018\u000e\u001c\u0006\u0002{\u0005!!.\u0019<b\u0013\ty$H\u0001\u0003V+&#\u0015!C:dQ\u0016$W\u000f\\3s!\t\t$)\u0003\u0002DO\t!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJL!\u0001\u0011\u001b\u0002\u001f5,G/\u00193bi\u0006l\u0015M\\1hKJ\u0004\"!M$\n\u0005!;#AG\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018AC1vi\"|'/\u001b>feB\u00191J\u0014)\u000e\u00031S\u0011!T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f2\u0013aa\u00149uS>t\u0007CA)Z\u001b\u0005\u0011&BA%T\u0015\tQCK\u0003\u0002-+*\u0011akV\u0001\u0007CB\f7\r[3\u000b\u0003a\u000b1a\u001c:h\u0013\tQ&K\u0001\u0006BkRDwN]5{KJ\f!\u0002\\8dC2\fE-\\5o!\ti&-D\u0001_\u0015\ty\u0006-A\u0003bI6LgN\u0003\u0002b)\u000691\r\\5f]R\u001c\u0018BA2_\u00059\u0019uN\u001c4mk\u0016tG/\u00113nS:\f!cY8na2,G/[8o\u0007\u0006dGNY1dWB\u00191J\u001a5\n\u0005\u001dd%!\u0003$v]\u000e$\u0018n\u001c81!\tY\u0015.\u0003\u0002k\u0019\n!QK\\5u\u00039!x\u000e]5d\u000fJ|W\u000f]*ju\u0016\u0004\"aS7\n\u00059d%aA%oi\u0006Q\u0011N\u001c;feZ\fG.T:\n\u0005E$\u0014!\u0005:fg\u000eDW\rZ;mK\u0012+G.Y=Ng\u0006a!/\u001a;ss\u0012+G.Y=Ng\u00061A(\u001b8jiz\"\"\"\u001e<xqfT8\u0010`?\u007f!\t\t\u0004\u0001C\u00038\u0015\u0001\u0007\u0001\bC\u0003A\u0015\u0001\u0007\u0011\tC\u0003F\u0015\u0001\u0007a\tC\u0003J\u0015\u0001\u0007!\nC\u0003\\\u0015\u0001\u0007A\fC\u0003e\u0015\u0001\u0007Q\rC\u0004l\u0015A\u0005\t\u0019\u00017\t\u000f=T\u0001\u0013!a\u0001Y\"9!O\u0003I\u0001\u0002\u0004a\u0017A\u00037j].4\u0015\u000e\u001c;feV\u0011\u00111\u0001\t\u0005\u0003\u000b\ty!\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003\r\t7\r\u001c\u0006\u0004\u0003\u001b!\u0016AB2p[6|g.\u0003\u0003\u0002\u0012\u0005\u001d!\u0001G!dG\u0016\u001c8oQ8oiJ|G.\u00128uef4\u0015\u000e\u001c;fe\u0006YA.\u001b8l\r&dG/\u001a:!\u0003-)\b\u000fZ1uK\u0012\f5\r\\:\u0016\u0005\u0005e\u0001cA&\u0002\u001c%\u0019\u0011Q\u0004'\u0003\u000f\t{w\u000e\\3b]\u0006yQ\u000f\u001d3bi\u0016$\u0017i\u00197t?\u0012*\u0017\u000fF\u0002i\u0003GA\u0011\"!\n\u000f\u0003\u0003\u0005\r!!\u0007\u0002\u0007a$\u0013'\u0001\u0007va\u0012\fG/\u001a3BG2\u001c\b%A\u0006u_BL7m\u0012:pkB\u001cXCAA\u0017!\u0019\ty#a\u0010\u0002F9!\u0011\u0011GA\u001e\u001d\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001c[\u00051AH]8pizJ\u0011!T\u0005\u0004\u0003{a\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003\u0003\n\u0019E\u0001\u0003MSN$(bAA\u001f\u0019B1\u0011qIA(\u0003+rA!!\u0013\u0002LA\u0019\u00111\u0007'\n\u0007\u00055C*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003#\n\u0019FA\u0002TKRT1!!\u0014M!\u0011\t9%a\u0016\n\t\u0005e\u00131\u000b\u0002\u0007'R\u0014\u0018N\\4\u0002\u001fQ|\u0007/[2He>,\bo]0%KF$2\u0001[A0\u0011%\t)#EA\u0001\u0002\u0004\ti#\u0001\u0007u_BL7m\u0012:pkB\u001c\b%A\u0002sk:$\"!!\u0007\u0002\u0017A\u0014xnY3tg\u0006\u001bGn]\u0001\u0016G2,\u0017M\u001d'j].\f5\r\\:D_6\u0004H.\u001a;f)\u0011\tI\"!\u001c\t\u000f\u0005=T\u00031\u0001\u0002r\u0005\u00012M]3bi\u0016\f5\r\\:SKN,H\u000e\u001e\t\u0004;\u0006M\u0014bAA;=\n\u00012I]3bi\u0016\f5\r\\:SKN,H\u000e\u001e\u000b\u0005\u00033\tI\bC\u0004\u0002|Y\u0001\r!! \u0002!\u0011,G.\u001a;f\u0003\u000ed7OU3tk2$\bcA/\u0002\u0000%\u0019\u0011\u0011\u00110\u0003!\u0011+G.\u001a;f\u0003\u000ed7OU3tk2$\u0018!\u00049s_\u000e,7o\u001d+pa&\u001c7/A\tqe>\u001cWm]:U_BL7m](oG\u0016\f\u0011c\u00197fCJl\u0015N\u001d:peR{\u0007/[2t)\u0011\tI\"a#\t\u000f\u00055\u0015\u00041\u0001\u0002F\u00051Ao\u001c9jGN\f\u0011d\u00197fCJl\u0015N\u001d:peR{\u0007/[2t\u0007>l\u0007\u000f\\3uKR!\u0011\u0011DAJ\u0011\u001d\t)J\u0007a\u0001\u0003/\u000bqA]3tk2$8\u000fE\u0004:\u00033\u000b)&!(\n\u0007\u0005m%HA\u0002NCB\u0004b!a(\u0002\"\u0006\u0015VBAA\u0006\u0013\u0011\t\u0019+a\u0003\u0003\u0017-\u000bgm[1GkR,(/\u001a\t\u0005\u0003O\u000bi+\u0004\u0002\u0002**\u0019\u00111\u0016\u001f\u0002\t1\fgnZ\u0005\u0005\u0003_\u000bIK\u0001\u0003W_&$\u0017\u0001D8o\u0007>l\u0007\u000f\\3uS>t\u0017AD4fiV\u0003H-\u0019;fI\u0006\u001bGn]\u0001\u001e\u00072,8\u000f^3s\u0019&t7n\u00117fCJd\u0015N\\6SK\u001a,'/\u001a8dKB\u0011\u0011GH\n\u0006=\u0005m\u0016\u0011\u0019\t\u0004\u0017\u0006u\u0016bAA`\u0019\n1\u0011I\\=SK\u001a\u0004B!a1\u0002J6\u0011\u0011Q\u0019\u0006\u0004\u0003\u000f\\\u0013!B;uS2\u001c\u0018\u0002BAf\u0003\u000b\u0014q\u0001T8hO&tw\r\u0006\u0002\u00028\u0006A2\u000f[8vY\u0012\u001cE.Z1s\u0019&t7NU3gKJ,gnY3\u0015\r\u0005e\u00111[Ak\u0011\u00159\u0004\u00051\u00019\u0011\u0019\t9\u000e\ta\u0001\r\u00069Q.\u00198bO\u0016\u0014\u0018A\u00065b]\u0012dW\rR3mKR,\u0017i\u00197t%\u0016\u001cX\u000f\u001c;\u0015\t\u0005e\u0011Q\u001c\u0005\b\u0003w\n\u0003\u0019AA?\u0003YA\u0017M\u001c3mK\u000e\u0013X-\u0019;f\u0003\u000ed7OU3tk2$H\u0003BA\r\u0003GDq!a\u001c#\u0001\u0004\t\t(A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeN\u000b\u0003\u0003ST3\u0001\\AvW\t\ti\u000f\u0005\u0003\u0002p\u0006eXBAAy\u0015\u0011\t\u00190!>\u0002\u0013Ut7\r[3dW\u0016$'bAA|\u0019\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0018\u0011\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003(A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\u000f")
public class ClusterLinkClearLinkReference
extends ClusterLinkScheduler.PeriodicTask {
    private final UUID linkId;
    private final ClusterLinkMetadataManager metadataManager;
    private final Option<Authorizer> authorizer;
    private final ConfluentAdmin localAdmin;
    private final Function0<BoxedUnit> completionCallback;
    private final int topicGroupSize;
    private final int retryDelayMs;
    private final AccessControlEntryFilter linkFilter;
    private boolean updatedAcls;
    private List<Set<String>> topicGroups;

    public static int $lessinit$greater$default$9() {
        return 1000;
    }

    public static int $lessinit$greater$default$8() {
        return 5000;
    }

    public static int $lessinit$greater$default$7() {
        return 100;
    }

    private AccessControlEntryFilter linkFilter() {
        return this.linkFilter;
    }

    private boolean updatedAcls() {
        return this.updatedAcls;
    }

    private void updatedAcls_$eq(boolean x$1) {
        this.updatedAcls = x$1;
    }

    private List<Set<String>> topicGroups() {
        return this.topicGroups;
    }

    private void topicGroups_$eq(List<Set<String>> x$1) {
        this.topicGroups = x$1;
    }

    @Override
    public boolean run() {
        if (!ClusterLinkClearLinkReference$.MODULE$.shouldClearLinkReference(this.linkId, this.metadataManager)) {
            return this.onCompletion();
        }
        if (!this.updatedAcls() && this.authorizer.nonEmpty()) {
            return this.processAcls();
        }
        ClusterLinkMetadataManager clusterLinkMetadataManager = this.metadataManager;
        if (clusterLinkMetadataManager instanceof ClusterLinkMetadataManagerWithZkSupport) {
            return this.processTopics();
        }
        if (clusterLinkMetadataManager instanceof ClusterLinkMetadataManagerWithKRaftSupport) {
            return this.onCompletion();
        }
        if (clusterLinkMetadataManager != null) {
            throw new IllegalStateException("Unsupported type of ClusterLinkMetadataManager");
        }
        throw new MatchError(null);
    }

    private boolean processAcls() {
        this.authorizer.foreach((Function1 & Serializable)authz -> {
            Iterable linkAcls = CollectionConverters$.MODULE$.IterableHasAsScala(authz.acls(new AclBindingFilter(ResourcePatternFilter.ANY, this.linkFilter()))).asScala();
            Iterable aclsToAdd = (Iterable)linkAcls.filterNot((Function1 & Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkClearLinkReference.$anonfun$processAcls$2(acl)));
            if (linkAcls.isEmpty()) {
                this.updatedAcls_$eq(true);
                return BoxesRunTime.boxToBoolean((boolean)this.processTopics());
            }
            if (aclsToAdd.nonEmpty()) {
                java.util.List localAcls = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)aclsToAdd.map((Function1 & Serializable)acl -> {
                    AccessControlEntry ace = new AccessControlEntry(acl.entry().principal(), acl.entry().host(), acl.entry().operation(), acl.entry().permissionType());
                    return new AclBinding(acl.pattern(), ace);
                })).toList()).asJava();
                CreateAclsResult createAclResult = $this.localAdmin.createAcls((Collection)localAcls);
                Iterable createAclsFuture = CollectionConverters$.MODULE$.MapHasAsScala(createAclResult.values()).asScala().values();
                this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])createAclsFuture.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.clearLinkAclsComplete(createAclResult));
                return BoxedUnit.UNIT;
            }
            java.util.List aclsToRemove = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)linkAcls.map((Function1 & Serializable)acl -> SecurityUtils.aclWithClusterLinkIds((AclBinding)acl, (Collection)this.linkFilter().clusterLinkIds()).toFilter())).toList()).asJava();
            DeleteAclsResult deleteAclsResult = $this.localAdmin.deleteAcls((Collection)aclsToRemove);
            Iterable deleteAclsResultFutures = CollectionConverters$.MODULE$.MapHasAsScala(deleteAclsResult.values()).asScala().values();
            this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])deleteAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.clearLinkAclsComplete(deleteAclsResult));
            return BoxedUnit.UNIT;
        });
        return this.updatedAcls();
    }

    private boolean clearLinkAclsComplete(CreateAclsResult createAclsResult) {
        boolean success = ClusterLinkClearLinkReference$.MODULE$.handleCreateAclsResult(createAclsResult);
        this.scheduleOnce((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.processAcls(), success ? 0L : (long)this.retryDelayMs);
        return false;
    }

    private boolean clearLinkAclsComplete(DeleteAclsResult deleteAclsResult) {
        boolean success = ClusterLinkClearLinkReference$.MODULE$.handleDeleteAclsResult(deleteAclsResult);
        this.scheduleOnce((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.processAcls(), success ? 0L : (long)this.retryDelayMs);
        return false;
    }

    private boolean processTopics() {
        Set<String> topicSet = this.metadataManager.getAllTopicsInCluster();
        this.topicGroups_$eq((List<Set<String>>)topicSet.grouped(this.topicGroupSize).toList());
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Processing ").append(topicSet.size()).append(" topics for cluster link removal for cluster link id ").append($this.linkId).toString());
        return this.processTopicsOnce();
    }

    private boolean processTopicsOnce() {
        if (this.topicGroups().isEmpty()) {
            return this.onCompletion();
        }
        Map links = (Map)this.metadataManager.clusterLinkTopicState((Set<String>)((Set)this.topicGroups().head())).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkClearLinkReference.$anonfun$processTopicsOnce$1(this, x$2)));
        if (links.nonEmpty()) {
            return this.clearMirrorTopics((Set<String>)links.keys().toSet());
        }
        this.topicGroups_$eq((List<Set<String>>)((List)this.topicGroups().drop(1)));
        this.scheduleOnce((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.processTopicsOnce(), this.scheduleOnce$default$2());
        return false;
    }

    private boolean clearMirrorTopics(Set<String> topics) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Clearing mirror topics for topics '").append(topics).append("' for cluster link id ").append($this.linkId).toString());
        try {
            scala.collection.immutable.Map ops = ((IterableOnceOps)topics.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)AlterMirrorOp.CLEAR))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            AlterMirrorsOptions options = new AlterMirrorsOptions();
            AlterMirrorsResult result = this.localAdmin.alterMirrors(CollectionConverters$.MODULE$.MapHasAsJava((Map)ops).asJava(), options);
            this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.clearMirrorTopicsComplete(result.values()));
        }
        catch (Throwable e) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Encountered error while clearing mirror topics", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.scheduleOnce((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.processTopicsOnce(), this.retryDelayMs);
        }
        return false;
    }

    private boolean clearMirrorTopicsComplete(java.util.Map<String, KafkaFuture<Void>> results) {
        if (CollectionConverters$.MODULE$.MapHasAsScala(results).asScala().forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkClearLinkReference.$anonfun$clearMirrorTopicsComplete$1(this, x0$1)))) {
            this.topicGroups_$eq((List<Set<String>>)((List)this.topicGroups().drop(1)));
            this.scheduleOnce((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.processTopicsOnce(), this.scheduleOnce$default$2());
        } else {
            this.scheduleOnce((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.processTopicsOnce(), this.retryDelayMs);
        }
        return false;
    }

    private boolean onCompletion() {
        this.shutdown();
        super.scheduler().scheduleOnce("ClearLinkReferenceCompleted", this.completionCallback);
        return true;
    }

    public boolean getUpdatedAcls() {
        return this.updatedAcls();
    }

    public static final /* synthetic */ boolean $anonfun$processAcls$2(AclBinding acl) {
        return acl.entry().clusterLinkIds().contains(Uuid.ZERO_UUID);
    }

    public static final /* synthetic */ boolean $anonfun$processTopicsOnce$1(ClusterLinkClearLinkReference $this, Tuple2 x$2) {
        UUID uUID = ((ClusterLinkTopicState)x$2._2()).linkId();
        UUID uUID2 = $this.linkId;
        return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$clearMirrorTopicsComplete$1(ClusterLinkClearLinkReference $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topic = (String)x0$1._1();
            try {
                ((KafkaFuture)x0$1._2()).get();
                return true;
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (throwable instanceof UnknownTopicOrPartitionException) {
                    $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(103).append("Encountered UnknownTopicOrPartitionException while clearing mirror topic '").append(topic).append("'.").append(" Mirror topic may not exist").toString());
                    return true;
                }
                if (throwable != null) {
                    $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Encountered error while clearing mirror topic '").append(topic).append("'").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                    return false;
                }
                throw new MatchError(null);
            }
            catch (Throwable e) {
                $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Encountered error while clearing mirror topic '").append(topic).append("'").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return false;
            }
        }
        throw new MatchError(null);
    }

    public ClusterLinkClearLinkReference(UUID linkId, ClusterLinkScheduler scheduler, ClusterLinkMetadataManager metadataManager, Option<Authorizer> authorizer, ConfluentAdmin localAdmin, Function0<BoxedUnit> completionCallback, int topicGroupSize, int intervalMs, int retryDelayMs) {
        this.linkId = linkId;
        this.metadataManager = metadataManager;
        this.authorizer = authorizer;
        this.localAdmin = localAdmin;
        this.completionCallback = completionCallback;
        this.topicGroupSize = topicGroupSize;
        this.retryDelayMs = retryDelayMs;
        super(scheduler, "ClearLinkReference", intervalMs);
        this.linkFilter = new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY, Collections.singleton(CoreUtils$.MODULE$.toKafkaUUID(linkId)));
        this.updatedAcls = false;
    }
}

