/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.cluster.PartitionStatus;
import kafka.security.authorizer.AclAuthorizer;
import kafka.server.KafkaConfig;
import kafka.server.link.AclBindingFilterTransformer;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkAlterConfigPolicy;
import kafka.server.link.ClusterLinkAutoMirroring;
import kafka.server.link.ClusterLinkCheckAvailability;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkListOffsets;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkPauseMirrorTopics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncAcls;
import kafka.server.link.ClusterLinkSyncOffsets;
import kafka.server.link.ClusterLinkSyncTopicsConfigs;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.LocalClusterLinkAdminClient;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r=g\u0001\u0002(P\u0001YC\u0001b\u001b\u0001\u0003\u0006\u0004%\t\u0001\u001c\u0005\ta\u0002\u0011\t\u0011)A\u0005[\"A\u0011\u000f\u0001B\u0001B\u0003%!\u000f\u0003\u0005w\u0001\t\u0015\r\u0011\"\u0001x\u0011!q\bA!A!\u0002\u0013A\b\"C@\u0001\u0005\u0003\u0005\u000b\u0011BA\u0001\u0011)\t9\u0001\u0001BC\u0002\u0013\u0005\u0011\u0011\u0002\u0005\u000b\u0003#\u0001!\u0011!Q\u0001\n\u0005-\u0001BCA\n\u0001\t\u0005\r\u0011\"\u0003\u0002\u0016!Q\u0011Q\u0004\u0001\u0003\u0002\u0004%I!a\b\t\u0015\u0005-\u0002A!A!B\u0013\t9\u0002\u0003\u0006\u00026\u0001\u0011\t\u0011)A\u0005\u0003oA!\"a\u0015\u0001\u0005\u000b\u0007I\u0011AA+\u0011)\t)\u0007\u0001B\u0001B\u0003%\u0011q\u000b\u0005\u000b\u0003O\u0002!Q1A\u0005\u0002\u0005%\u0004BCA9\u0001\t\u0005\t\u0015!\u0003\u0002l!Q\u00111\u000f\u0001\u0003\u0002\u0003\u0006I!!\u001e\t\u0015\u0005\u0005\u0005A!b\u0001\n\u0003\t\u0019\t\u0003\u0006\u0002\u001c\u0002\u0011\t\u0011)A\u0005\u0003\u000bC!\"!(\u0001\u0005\u000b\u0007I\u0011AAP\u0011)\t9\u000b\u0001B\u0001B\u0003%\u0011\u0011\u0015\u0005\b\u0003S\u0003A\u0011AAV\u0011-\t\t\n\u0001a\u0001\u0002\u0004%I!a2\t\u0017\u0005-\u0007\u00011AA\u0002\u0013%\u0011Q\u001a\u0005\f\u0003#\u0004\u0001\u0019!A!B\u0013\tI\rC\u0005\u0002V\u0002\u0001\r\u0011\"\u0003\u0002X\"I\u0011\u0011\u001d\u0001A\u0002\u0013%\u00111\u001d\u0005\t\u0003O\u0004\u0001\u0015)\u0003\u0002Z\"I\u0011\u0011\u001e\u0001A\u0002\u0013%\u00111\u001e\u0005\n\u0003k\u0004\u0001\u0019!C\u0005\u0003oD\u0001\"a?\u0001A\u0003&\u0011Q\u001e\u0005\n\u0003{\u0004\u0001\u0019!C\u0005\u0003\u007fD\u0011B!\u0003\u0001\u0001\u0004%IAa\u0003\t\u0011\t=\u0001\u0001)Q\u0005\u0005\u0003A\u0011B!\u0005\u0001\u0001\u0004%IAa\u0005\t\u0013\tu\u0001\u00011A\u0005\n\t}\u0001\u0002\u0003B\u0012\u0001\u0001\u0006KA!\u0006\t\u0013\t\u0015\u0002\u00011A\u0005\n\t\u001d\u0002\"\u0003B\u0019\u0001\u0001\u0007I\u0011\u0002B\u001a\u0011!\u00119\u0004\u0001Q!\n\t%\u0002\"\u0003B\u001d\u0001\u0001\u0007I\u0011\u0002B\u001e\u0011%\u0011)\u0005\u0001a\u0001\n\u0013\u00119\u0005\u0003\u0005\u0003L\u0001\u0001\u000b\u0015\u0002B\u001f\u0011%\u0011i\u0005\u0001b\u0001\n\u0013\u0011y\u0005\u0003\u0005\u0003X\u0001\u0001\u000b\u0011\u0002B)\u0011%\u0011I\u0006\u0001b\u0001\n\u0013\u0011Y\u0006\u0003\u0005\u0003n\u0001\u0001\u000b\u0011\u0002B/\u0011%\u0011y\u0007\u0001b\u0001\n\u0013\u0011\t\b\u0003\u0005\u0003\u001a\u0002\u0001\u000b\u0011\u0002B:\u0011\u001d\u0011Y\n\u0001C\u0001\u0005;CqAa(\u0001\t\u0013\u0011i\nC\u0004\u0003\"\u0002!\tA!(\t\u000f\t\r\u0006\u0001\"\u0003\u0003\u001e\"A!Q\u0015\u0001\u0005\u0002=\u00139\u000b\u0003\u0005\u00038\u0002!\te\u0014B]\u0011!\u0011)\r\u0001C\u0001\u001f\n\u001d\u0007\u0002\u0003Bf\u0001\u0011\u0005qJ!4\t\u000f\tE\u0007\u0001\"\u0001\u0003T\"9!Q\u001b\u0001\u0005\u0002\t]\u0007b\u0002Bm\u0001\u0011\u0005!1\u001c\u0005\b\u0005;\u0004A\u0011\u0001Bp\u0011\u001d\u0011\t\u000f\u0001C\u0001\u0003/DqAa9\u0001\t\u0013\u0011)\u000fC\u0004\u0003h\u0002!IA!(\t\u000f\t%\b\u0001\"\u0003\u0003\u001e\"9!1\u001e\u0001\u0005\u0002\t5\bbBB\u0007\u0001\u0011\u00051q\u0002\u0005\b\u0007;\u0001A\u0011BB\u0010\u0011\u001d\u0019I\u0005\u0001C\u0005\u0007\u0017Bqa!\u001b\u0001\t\u0003\u0019Y\u0007C\u0004\u0004\u000e\u0002!Iaa$\t\u000f\re\u0005\u0001\"\u0001\u0002\u0016!911\u0014\u0001\u0005\u0002\ru\u0005bBBW\u0001\u0011\u00051q\u0016\u0005\b\u0007o\u0003A\u0011AB]\u0011\u001d\u0019\t\r\u0001C\u0005\u0007\u0007Dqa!1\u0001\t\u0013\u00199M\u0001\rDYV\u001cH/\u001a:MS:\\7\t\\5f]Rl\u0015M\\1hKJT!\u0001U)\u0002\t1Lgn\u001b\u0006\u0003%N\u000baa]3sm\u0016\u0014(\"\u0001+\u0002\u000b-\fgm[1\u0004\u0001M!\u0001aV/f!\tA6,D\u0001Z\u0015\u0005Q\u0016!B:dC2\f\u0017B\u0001/Z\u0005\u0019\te.\u001f*fMB\u0011aL\u0019\b\u0003?\u0002l\u0011aT\u0005\u0003C>\u000b!c\u00117vgR,'\u000fT5oW\u001a\u000b7\r^8ss&\u00111\r\u001a\u0002\u000e\u00072LWM\u001c;NC:\fw-\u001a:\u000b\u0005\u0005|\u0005C\u00014j\u001b\u00059'B\u00015T\u0003\u0015)H/\u001b7t\u0013\tQwMA\u0004M_\u001e<\u0017N\\4\u0002%\rdWo\u001d;fe2Kgn['b]\u0006<WM]\u000b\u0002[B\u0011qL\\\u0005\u0003_>\u0013!c\u00117vgR,'\u000fT5oW6\u000bg.Y4fe\u0006\u00192\r\\;ti\u0016\u0014H*\u001b8l\u001b\u0006t\u0017mZ3sA\u0005a!M]8lKJ\u001cuN\u001c4jOB\u00111\u000f^\u0007\u0002#&\u0011Q/\u0015\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0005mS:\\G)\u0019;b+\u0005A\bCA=}\u001b\u0005Q(BA>T\u0003\tQ8.\u0003\u0002~u\ny1\t\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018-A\u0005mS:\\G)\u0019;bA\u0005qa-\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014\bcA0\u0002\u0004%\u0019\u0011QA(\u00033\rcWo\u001d;fe2Kgn\u001b$fi\u000eDWM]'b]\u0006<WM]\u0001\ng\u000eDW\rZ;mKJ,\"!a\u0003\u0011\u0007}\u000bi!C\u0002\u0002\u0010=\u0013Ac\u00117vgR,'\u000fT5oWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u000511m\u001c8gS\u001e,\"!a\u0006\u0011\u0007}\u000bI\"C\u0002\u0002\u001c=\u0013\u0011c\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0005\u0003C\t9\u0003E\u0002Y\u0003GI1!!\nZ\u0005\u0011)f.\u001b;\t\u0013\u0005%\"\"!AA\u0002\u0005]\u0011a\u0001=%c\u000591m\u001c8gS\u001e\u0004\u0003fA\u0006\u00020A\u0019\u0001,!\r\n\u0007\u0005M\u0012L\u0001\u0005w_2\fG/\u001b7f\u0003)\tW\u000f\u001e5pe&TXM\u001d\t\u00061\u0006e\u0012QH\u0005\u0004\u0003wI&AB(qi&|g\u000e\u0005\u0003\u0002@\u0005=SBAA!\u0015\u0011\t)$a\u0011\u000b\u0007I\u000b)EC\u0002U\u0003\u000fRA!!\u0013\u0002L\u00051\u0011\r]1dQ\u0016T!!!\u0014\u0002\u0007=\u0014x-\u0003\u0003\u0002R\u0005\u0005#AC!vi\"|'/\u001b>fe\u0006\t\u0012\r\u001c;fe\u000e{gNZ5h!>d\u0017nY=\u0016\u0005\u0005]\u0003#\u0002-\u0002:\u0005e\u0003\u0003BA.\u0003Cj!!!\u0018\u000b\t\u0005}\u00131I\u0001\u0007a>d\u0017nY=\n\t\u0005\r\u0014Q\f\u0002\u0012\u00032$XM]\"p]\u001aLw\rU8mS\u000eL\u0018AE1mi\u0016\u00148i\u001c8gS\u001e\u0004v\u000e\\5ds\u0002\nq!\\3ue&\u001c7/\u0006\u0002\u0002lA\u0019q,!\u001c\n\u0007\u0005=tJ\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002!1Lgn[!e[&tg)Y2u_JL\bc\u0002-\u0002x\u0005]\u00111P\u0005\u0004\u0003sJ&!\u0003$v]\u000e$\u0018n\u001c82!\ry\u0016QP\u0005\u0004\u0003\u007fz%AF\"mkN$XM\u001d'j].\fE-\\5o\u00072LWM\u001c;\u0002!\u0011,7\u000f^!e[&tg)Y2u_JLXCAAC!\u0015A\u0016qQAF\u0013\r\tI)\u0017\u0002\n\rVt7\r^5p]B\u0002B!!$\u0002\u00186\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*A\u0003bI6LgN\u0003\u0003\u0002\u0016\u0006\u0015\u0013aB2mS\u0016tGo]\u0005\u0005\u00033\u000byI\u0001\bD_:4G.^3oi\u0006#W.\u001b8\u0002#\u0011,7\u000f^!e[&tg)Y2u_JL\b%A\u000ebG2\u0014\u0015N\u001c3j]\u001e4\u0015\u000e\u001c;feR\u0013\u0018M\\:g_JlWM]\u000b\u0003\u0003C\u00032aXAR\u0013\r\t)k\u0014\u0002\u001c\u0003\u000ed')\u001b8eS:<g)\u001b7uKJ$&/\u00198tM>\u0014X.\u001a:\u00029\u0005\u001cGNQ5oI&twMR5mi\u0016\u0014HK]1og\u001a|'/\\3sA\u00051A(\u001b8jiz\"\"$!,\u00020\u0006E\u00161WA[\u0003o\u000bI,a/\u0002>\u0006}\u0016\u0011YAb\u0003\u000b\u0004\"a\u0018\u0001\t\u000b-4\u0002\u0019A7\t\u000bE4\u0002\u0019\u0001:\t\u000bY4\u0002\u0019\u0001=\t\r}4\u0002\u0019AA\u0001\u0011\u001d\t9A\u0006a\u0001\u0003\u0017Aq!a\u0005\u0017\u0001\u0004\t9\u0002C\u0004\u00026Y\u0001\r!a\u000e\t\u000f\u0005Mc\u00031\u0001\u0002X!9\u0011q\r\fA\u0002\u0005-\u0004bBA:-\u0001\u0007\u0011Q\u000f\u0005\b\u0003\u00033\u0002\u0019AAC\u0011\u001d\tiJ\u0006a\u0001\u0003C+\"!!3\u0011\u000ba\u000bI$a\u001f\u0002\u0013\u0005$W.\u001b8`I\u0015\fH\u0003BA\u0011\u0003\u001fD\u0011\"!\u000b\u0019\u0003\u0003\u0005\r!!3\u0002\r\u0005$W.\u001b8!Q\rI\u0012qF\u0001\u0014G2,8\u000f^3s\u0019&t7nU=oG\u0006\u001bGn]\u000b\u0003\u00033\u0004R\u0001WA\u001d\u00037\u00042aXAo\u0013\r\tyn\u0014\u0002\u0014\u00072,8\u000f^3s\u0019&t7nU=oG\u0006\u001bGn]\u0001\u0018G2,8\u000f^3s\u0019&t7nU=oG\u0006\u001bGn]0%KF$B!!\t\u0002f\"I\u0011\u0011F\u000e\u0002\u0002\u0003\u0007\u0011\u0011\\\u0001\u0015G2,8\u000f^3s\u0019&t7nU=oG\u0006\u001bGn\u001d\u0011\u0002-\rdWo\u001d;fe2Kgn[*z]\u000e|eMZ:fiN,\"!!<\u0011\u000ba\u000bI$a<\u0011\u0007}\u000b\t0C\u0002\u0002t>\u0013ac\u00117vgR,'\u000fT5oWNKhnY(gMN,Go]\u0001\u001bG2,8\u000f^3s\u0019&t7nU=oG>3gm]3ug~#S-\u001d\u000b\u0005\u0003C\tI\u0010C\u0005\u0002*y\t\t\u00111\u0001\u0002n\u000692\r\\;ti\u0016\u0014H*\u001b8l'ft7m\u00144gg\u0016$8\u000fI\u0001\u001cG2,8\u000f^3s\u0019&t7nU=oGR{\u0007/[2D_:4\u0017nZ:\u0016\u0005\t\u0005\u0001#\u0002-\u0002:\t\r\u0001cA0\u0003\u0006%\u0019!qA(\u00039\rcWo\u001d;fe2Kgn[*z]\u000e$v\u000e]5dg\u000e{gNZ5hg\u0006y2\r\\;ti\u0016\u0014H*\u001b8l'ft7\rV8qS\u000e\u001cuN\u001c4jON|F%Z9\u0015\t\u0005\u0005\"Q\u0002\u0005\n\u0003S\t\u0013\u0011!a\u0001\u0005\u0003\tAd\u00197vgR,'\u000fT5oWNKhn\u0019+pa&\u001c7i\u001c8gS\u001e\u001c\b%\u0001\u000fdYV\u001cH/\u001a:MS:\\7\t[3dW\u00063\u0018-\u001b7bE&d\u0017\u000e^=\u0016\u0005\tU\u0001#\u0002-\u0002:\t]\u0001cA0\u0003\u001a%\u0019!1D(\u00039\rcWo\u001d;fe2Kgn[\"iK\u000e\\\u0017I^1jY\u0006\u0014\u0017\u000e\\5us\u0006\u00013\r\\;ti\u0016\u0014H*\u001b8l\u0007\",7m[!wC&d\u0017MY5mSRLx\fJ3r)\u0011\t\tC!\t\t\u0013\u0005%B%!AA\u0002\tU\u0011!H2mkN$XM\u001d'j].\u001c\u0005.Z2l\u0003Z\f\u0017\u000e\\1cS2LG/\u001f\u0011\u00021\rdWo\u001d;fe2Kgn[!vi>l\u0015N\u001d:pe&tw-\u0006\u0002\u0003*A)\u0001,!\u000f\u0003,A\u0019qL!\f\n\u0007\t=rJ\u0001\rDYV\u001cH/\u001a:MS:\\\u0017)\u001e;p\u001b&\u0014(o\u001c:j]\u001e\fAd\u00197vgR,'\u000fT5oW\u0006+Ho\\'jeJ|'/\u001b8h?\u0012*\u0017\u000f\u0006\u0003\u0002\"\tU\u0002\"CA\u0015O\u0005\u0005\t\u0019\u0001B\u0015\u0003e\u0019G.^:uKJd\u0015N\\6BkR|W*\u001b:s_JLgn\u001a\u0011\u0002-\rdWo\u001d;fe2Kgn\u001b'jgR|eMZ:fiN,\"A!\u0010\u0011\u000ba\u000bIDa\u0010\u0011\u0007}\u0013\t%C\u0002\u0003D=\u0013ac\u00117vgR,'\u000fT5oW2K7\u000f^(gMN,Go]\u0001\u001bG2,8\u000f^3s\u0019&t7\u000eT5ti>3gm]3ug~#S-\u001d\u000b\u0005\u0003C\u0011I\u0005C\u0005\u0002*)\n\t\u00111\u0001\u0003>\u000592\r\\;ti\u0016\u0014H*\u001b8l\u0019&\u001cHo\u00144gg\u0016$8\u000fI\u0001\u001dG2,8\u000f^3s\u0019&t7\u000eU1vg\u0016l\u0015N\u001d:peR{\u0007/[2t+\t\u0011\t\u0006E\u0002`\u0005'J1A!\u0016P\u0005q\u0019E.^:uKJd\u0015N\\6QCV\u001cX-T5se>\u0014Hk\u001c9jGN\fQd\u00197vgR,'\u000fT5oWB\u000bWo]3NSJ\u0014xN\u001d+pa&\u001c7\u000fI\u0001\u0005Y>\u001c7.\u0006\u0002\u0003^A!!q\fB5\u001b\t\u0011\tG\u0003\u0003\u0003d\t\u0015\u0014\u0001\u00027b]\u001eT!Aa\u001a\u0002\t)\fg/Y\u0005\u0005\u0005W\u0012\tG\u0001\u0004PE*,7\r^\u0001\u0006Y>\u001c7\u000eI\u0001\u0007i>\u0004\u0018nY:\u0016\u0005\tM\u0004C\u0002B;\u0005\u007f\u0012\u0019)\u0004\u0002\u0003x)!!\u0011\u0010B>\u0003\u001diW\u000f^1cY\u0016T1A! Z\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u0003\u00139HA\u0002TKR\u0004BA!\"\u0003\u0014:!!q\u0011BH!\r\u0011I)W\u0007\u0003\u0005\u0017S1A!$V\u0003\u0019a$o\\8u}%\u0019!\u0011S-\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011)Ja&\u0003\rM#(/\u001b8h\u0015\r\u0011\t*W\u0001\bi>\u0004\u0018nY:!\u0003\u001d\u0019H/\u0019:ukB$\"!!\t\u0002%M$\u0018M\u001d;va\u0006\u001bG/\u001b<f)\u0006\u001c8n]\u0001\tg\",H\u000fZ8x]\u0006\u00192\u000f[;uI><h.Q2uSZ,G+Y:lg\u0006Y!/Z2p]\u001aLw-\u001e:f)\u0019\t\tC!+\u0003.\"9!1\u0016\u001cA\u0002\u0005]\u0011!\u00038fo\u000e{gNZ5h\u0011\u001d\u0011yK\u000ea\u0001\u0005c\u000b1\"\u001e9eCR,GmS3zgB1!1\u0017B[\u0005\u0007k!Aa\u001f\n\t\t\u0005%1P\u0001\u0015_:\fe/Y5mC\nLG.\u001b;z\u0007\"\fgnZ3\u0015\t\u0005\u0005\"1\u0018\u0005\b\u0005{;\u0004\u0019\u0001B`\u0003-I7/\u0011<bS2\f'\r\\3\u0011\u0007a\u0013\t-C\u0002\u0003Df\u0013qAQ8pY\u0016\fg.A\u0005bI\u0012$v\u000e]5dgR!\u0011\u0011\u0005Be\u0011\u001d\u0011)\r\u000fa\u0001\u0005c\u000bAB]3n_Z,Gk\u001c9jGN$B!!\t\u0003P\"9!1Z\u001dA\u0002\tE\u0016!C4fiR{\u0007/[2t+\t\u0011\t,\u0001\u0005hKR\fE-\\5o+\t\tY)A\rhKR\u001cE.^:uKJd\u0015N\\6BI6Lgn\u00117jK:$XCAA>\u000359W\r^!vi\"|'/\u001b>feV\u0011\u0011qG\u0001\u000fO\u0016$8+\u001f8d\u0003\u000edG+Y:l\u0003!I7/Q2uSZ,GC\u0001B`\u0003E\u0019'/Z1uK\u0006sGmU3u\u0003\u0012l\u0017N\\\u0001\u000bG2|7/Z!e[&t\u0017\u0001\u00064fi\u000eDGk\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0006\u0004\u0003p\u000e\u00151\u0011\u0002\t\u0007\u0005c\u0014YPa@\u000e\u0005\tM(\u0002\u0002B{\u0005o\f!bY8oGV\u0014(/\u001a8u\u0015\u0011\u0011IP!\u001a\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005{\u0014\u0019PA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u00042\u0001WB\u0001\u0013\r\u0019\u0019!\u0017\u0002\u0004\u0013:$\bbBB\u0004\u0005\u0002\u0007!1Q\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0007\u0017\u0011\u0005\u0019\u0001B\u0000\u0003%!\u0018.\\3pkRl5/\u0001\bgKR\u001c\u0007\u000eV8qS\u000eLeNZ8\u0015\r\rE1\u0011DB\u000e!\u0019\u0011\tPa?\u0004\u0014A\u0019ql!\u0006\n\u0007\r]qJ\u0001\u000bDYV\u001cH/\u001a:MS:\\Gk\u001c9jG&sgm\u001c\u0005\b\u0007\u000f\u0019\u0005\u0019\u0001BB\u0011\u001d\u0019Ya\u0011a\u0001\u0005\u007f\f1DZ3uG\"$v\u000e]5d\u0013:4w\u000eS1oI2,'+Z:vYR\u001cHCCA\u0011\u0007C\u0019\u0019c!\u000f\u0004F!91q\u0001#A\u0002\t\r\u0005bBB\u0013\t\u0002\u00071qE\u0001\rG>tg-[4GkR,(/\u001a\t\u0007\u0007S\u0019yca\r\u000e\u0005\r-\"\u0002BB\u0017\u0003\u000b\naaY8n[>t\u0017\u0002BB\u0019\u0007W\u00111bS1gW\u00064U\u000f^;sKB!\u0011QRB\u001b\u0013\u0011\u00199$a$\u0003\r\r{gNZ5h\u0011\u001d\u0019Y\u0004\u0012a\u0001\u0007{\t\u0011\u0003Z3tGJL\u0007\u000f^5p]\u001a+H/\u001e:f!\u0019\u0019Ica\f\u0004@A!\u0011QRB!\u0013\u0011\u0019\u0019%a$\u0003!Q{\u0007/[2EKN\u001c'/\u001b9uS>t\u0007bBB$\t\u0002\u00071\u0011C\u0001\u0007e\u0016\u001cX\u000f\u001c;\u00027\u0019,Go\u00195U_BL7-\u00138g_^\u0013\u0018\r]#yG\u0016\u0004H/[8o)!\u0019iea\u0018\u0004b\r\u0015\u0004\u0003BB(\u00073rAa!\u0015\u0004V9!!\u0011RB*\u0013\u0005Q\u0016bAB,3\u00069\u0001/Y2lC\u001e,\u0017\u0002BB.\u0007;\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\r]\u0013\fC\u0004\u0004\b\u0015\u0003\rAa!\t\u000f\r\rT\t1\u0001\u0004N\u0005\tQ\rC\u0004\u0004h\u0015\u0003\rAa!\u0002\r\u0005\u001cG/[8o\u00035\u0011X\r\u001d7jG\u0006\u001cF/\u0019;vgR!1QNBD!!\u0011\u0019la\u001c\u0004t\re\u0014\u0002BB9\u0005w\u00121!T1q!\u0011\u0019Ic!\u001e\n\t\r]41\u0006\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\u0019\u0011\tPa?\u0004|A!1QPBB\u001b\t\u0019yHC\u0002\u0004\u0002N\u000bqa\u00197vgR,'/\u0003\u0003\u0004\u0006\u000e}$a\u0004)beRLG/[8o'R\fG/^:\t\u000f\r%e\t1\u0001\u0004\f\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\r\tM&QWB:\u0003i!xNU3tk2$X*\u001b:s_JLeNZ8TiJL\u0007\u000f]3e)\u0011\u0019Yh!%\t\u000f\r\u001ds\t1\u0001\u0004\u0014B!\u0011QRBK\u0013\u0011\u00199*a$\u0003\u001fA\u000b'\u000f^5uS>t'+Z:vYR\fQbY;se\u0016tGoQ8oM&<\u0017!\t:fgR\u0014\u0018n\u0019;WC2LG-\u0019;f)>\u0004\u0018nY\"p]\u001aLw\rU8mS\u000eLHCBBP\u0007O\u001bI\u000b\u0005\u0003\u0004\"\u000e\rVB\u0001B|\u0013\u0011\u0019)Ka>\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u0004\b%\u0003\rAa!\t\u000f\r-\u0016\n1\u0001\u0004 \u0006)\u0001O]8qg\u0006!Bo\u001c9jG\u000e{gNZ5h'ft7MU;mKN$\"a!-\u0011\u0007}\u001b\u0019,C\u0002\u00046>\u0013!$T5se>\u0014Hk\u001c9jG\u000e{gNZ5h'ft7MU;mKN\fq\"\\3uC\u0012\fG/Y'b]\u0006<WM]\u000b\u0003\u0007w\u00032aXB_\u0013\r\u0019yl\u0014\u0002\u001b\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y'b]\u0006<WM]\u0001\u0016SN\u001cV\u000f\u001d9peR,G-Q;uQ>\u0014\u0018N_3s)\u0011\u0011yl!2\t\u000f\u0005UB\n1\u0001\u0002>Q1!qXBe\u0007\u001bDqaa3N\u0001\u0004\u0011\u0019)A\u0005dY\u0006\u001c8OT1nK\"9\u0011QG'A\u0002\u0005u\u0002")
public class ClusterLinkClientManager
implements ClusterLinkFactory.ClientManager,
Logging {
    private final ClusterLinkManager clusterLinkManager;
    private final ClusterLinkData linkData;
    private final ClusterLinkFetcherManager fetcherManager;
    private final ClusterLinkScheduler scheduler;
    private volatile ClusterLinkConfig config;
    private final Option<Authorizer> authorizer;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private final ClusterLinkMetrics metrics;
    private final Function1<ClusterLinkConfig, ClusterLinkAdminClient> linkAdminFactory;
    private final Function0<ConfluentAdmin> destAdminFactory;
    private final AclBindingFilterTransformer aclBindingFilterTransformer;
    private volatile Option<ClusterLinkAdminClient> admin;
    private Option<ClusterLinkSyncAcls> clusterLinkSyncAcls;
    private Option<ClusterLinkSyncOffsets> clusterLinkSyncOffsets;
    private Option<ClusterLinkSyncTopicsConfigs> clusterLinkSyncTopicConfigs;
    private Option<ClusterLinkCheckAvailability> clusterLinkCheckAvailability;
    private Option<ClusterLinkAutoMirroring> clusterLinkAutoMirroring;
    private Option<ClusterLinkListOffsets> clusterLinkListOffsets;
    private final ClusterLinkPauseMirrorTopics clusterLinkPauseMirrorTopics;
    private final Object lock;
    private final scala.collection.mutable.Set<String> topics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public ClusterLinkData linkData() {
        return this.linkData;
    }

    public ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ClusterLinkConfig config() {
        return this.config;
    }

    private void config_$eq(ClusterLinkConfig x$1) {
        this.config = x$1;
    }

    public Option<AlterConfigPolicy> alterConfigPolicy() {
        return this.alterConfigPolicy;
    }

    public ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    public Function0<ConfluentAdmin> destAdminFactory() {
        return this.destAdminFactory;
    }

    public AclBindingFilterTransformer aclBindingFilterTransformer() {
        return this.aclBindingFilterTransformer;
    }

    private Option<ClusterLinkAdminClient> admin() {
        return this.admin;
    }

    private void admin_$eq(Option<ClusterLinkAdminClient> x$1) {
        this.admin = x$1;
    }

    private Option<ClusterLinkSyncAcls> clusterLinkSyncAcls() {
        return this.clusterLinkSyncAcls;
    }

    private void clusterLinkSyncAcls_$eq(Option<ClusterLinkSyncAcls> x$1) {
        this.clusterLinkSyncAcls = x$1;
    }

    private Option<ClusterLinkSyncOffsets> clusterLinkSyncOffsets() {
        return this.clusterLinkSyncOffsets;
    }

    private void clusterLinkSyncOffsets_$eq(Option<ClusterLinkSyncOffsets> x$1) {
        this.clusterLinkSyncOffsets = x$1;
    }

    private Option<ClusterLinkSyncTopicsConfigs> clusterLinkSyncTopicConfigs() {
        return this.clusterLinkSyncTopicConfigs;
    }

    private void clusterLinkSyncTopicConfigs_$eq(Option<ClusterLinkSyncTopicsConfigs> x$1) {
        this.clusterLinkSyncTopicConfigs = x$1;
    }

    private Option<ClusterLinkCheckAvailability> clusterLinkCheckAvailability() {
        return this.clusterLinkCheckAvailability;
    }

    private void clusterLinkCheckAvailability_$eq(Option<ClusterLinkCheckAvailability> x$1) {
        this.clusterLinkCheckAvailability = x$1;
    }

    private Option<ClusterLinkAutoMirroring> clusterLinkAutoMirroring() {
        return this.clusterLinkAutoMirroring;
    }

    private void clusterLinkAutoMirroring_$eq(Option<ClusterLinkAutoMirroring> x$1) {
        this.clusterLinkAutoMirroring = x$1;
    }

    private Option<ClusterLinkListOffsets> clusterLinkListOffsets() {
        return this.clusterLinkListOffsets;
    }

    private void clusterLinkListOffsets_$eq(Option<ClusterLinkListOffsets> x$1) {
        this.clusterLinkListOffsets = x$1;
    }

    private ClusterLinkPauseMirrorTopics clusterLinkPauseMirrorTopics() {
        return this.clusterLinkPauseMirrorTopics;
    }

    private Object lock() {
        return this.lock;
    }

    private scala.collection.mutable.Set<String> topics() {
        return this.topics;
    }

    @Override
    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Starting ClusterLinkClientManager with cluster link data ").append(this.linkData()).toString());
        if (this.isActive()) {
            this.createAndSetAdmin();
            this.startupActiveTasks();
        }
        this.clusterLinkPauseMirrorTopics().startup();
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(71).append("Startup of ClusterLinkClientManager with cluster link data ").append(this.linkData()).append(" is complete").toString());
    }

    private void startupActiveTasks() {
        this.clusterLinkSyncOffsets_$eq((Option<ClusterLinkSyncOffsets>)new Some((Object)new ClusterLinkSyncOffsets(this, this.clusterLinkManager().metadataManager(), this.linkData(), this.destAdminFactory(), this.metrics())));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkSyncOffsets().get()).startup();
        this.clusterLinkSyncTopicConfigs_$eq((Option<ClusterLinkSyncTopicsConfigs>)new Some((Object)new ClusterLinkSyncTopicsConfigs(this, this.clusterLinkManager().metadataManager(), new LocalClusterLinkAdminClient((ConfluentAdmin)this.destAdminFactory().apply()), Predef$.MODULE$.Integer2int(this.config().topicConfigSyncMs()), this.metrics())));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkSyncTopicConfigs().get()).startup();
        this.clusterLinkListOffsets_$eq((Option<ClusterLinkListOffsets>)new Some((Object)new ClusterLinkListOffsets(this, this.fetcherManager, Predef$.MODULE$.Integer2int(this.config().availabilityCheckMs()))));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkListOffsets().get()).startup();
        if (this.config().aclSyncEnable()) {
            this.authorizer.getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("ACL migration is enabled but authorizer.class.name is not set. Please set authorizer.class.name to proceed with ACL migration.");
            });
            if (!this.authorizer.exists((Function1 & Serializable)authorizer -> BoxesRunTime.boxToBoolean((boolean)this.isSupportedAuthorizer(authorizer)))) {
                throw new IllegalArgumentException(new StringBuilder(125).append("ACL migration is supported only with the built-in ").append("authorizers AclAuthorizer and ConfluentServerAuthorizer. ").append(this.authorizer.get().getClass()).append(" is not supported.").toString());
            }
            this.config().aclFilters().getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("ACL migration is enabled but acl.filters is not set. Please set acl.filters to proceed with ACL migration.");
            });
            this.clusterLinkSyncAcls_$eq((Option<ClusterLinkSyncAcls>)new Some((Object)new ClusterLinkSyncAcls(this, this.linkData(), this.clusterLinkManager().metadataManager(), this.destAdminFactory(), this.metrics(), this.aclBindingFilterTransformer())));
            ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkSyncAcls().get()).startup();
        }
        this.clusterLinkCheckAvailability_$eq((Option<ClusterLinkCheckAvailability>)new Some((Object)new ClusterLinkCheckAvailability(this, this.config(), this.metrics(), this.clusterLinkManager(), Predef$.MODULE$.Integer2int(this.config().availabilityCheckMs()))));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkCheckAvailability().get()).startup();
        this.clusterLinkAutoMirroring_$eq((Option<ClusterLinkAutoMirroring>)new Some((Object)new ClusterLinkAutoMirroring(this, this.clusterLinkManager().metadataManager(), this.linkData(), this.destAdminFactory(), this.metrics())));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkAutoMirroring().get()).startup();
    }

    @Override
    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Shutting down ClusterLinkClientManager with cluster link data ").append(this.linkData()).toString());
        this.clusterLinkPauseMirrorTopics().shutdown();
        if (this.isActive()) {
            this.shutdownActiveTasks();
            this.closeAdmin();
            this.admin_$eq(null);
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Shutdown of ClusterLinkClientManager with cluster link data ").append(this.linkData()).append(" is complete").toString());
    }

    private void shutdownActiveTasks() {
        this.clusterLinkSyncTopicConfigs().foreach((Function1 & Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkSyncTopicConfigs_$eq((Option<ClusterLinkSyncTopicsConfigs>)None$.MODULE$);
        this.clusterLinkSyncOffsets().foreach((Function1 & Serializable)x$3 -> {
            x$3.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkSyncOffsets_$eq((Option<ClusterLinkSyncOffsets>)None$.MODULE$);
        this.clusterLinkSyncAcls().foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkSyncAcls_$eq((Option<ClusterLinkSyncAcls>)None$.MODULE$);
        this.clusterLinkCheckAvailability().foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkCheckAvailability_$eq((Option<ClusterLinkCheckAvailability>)None$.MODULE$);
        this.clusterLinkAutoMirroring().foreach((Function1 & Serializable)x$6 -> {
            x$6.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkAutoMirroring_$eq((Option<ClusterLinkAutoMirroring>)None$.MODULE$);
        this.clusterLinkListOffsets().foreach((Function1 & Serializable)x$7 -> {
            x$7.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkListOffsets_$eq((Option<ClusterLinkListOffsets>)None$.MODULE$);
    }

    @Override
    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        Object object = this.lock();
        synchronized (object) {
            boolean oldActive = this.isActive();
            this.config_$eq(newConfig);
            boolean newActive = this.isActive();
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Reconfiguring ClusterLinkClientManager. oldActive=").append(oldActive).append(" and newActive=").append(newActive).toString());
            Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(oldActive, newActive);
            if (oldActive || newActive) {
                if (!oldActive && newActive) {
                    this.createAndSetAdmin();
                    this.startupActiveTasks();
                } else if (oldActive && !newActive) {
                    this.shutdownActiveTasks();
                    this.closeAdmin();
                    this.admin_$eq((Option<ClusterLinkAdminClient>)None$.MODULE$);
                } else if (oldActive && newActive) {
                    if (updatedKeys.diff(ClusterLinkConfig$.MODULE$.ReplicationProps()).nonEmpty()) {
                        this.trace((Function0<String>)(Function0 & Serializable)() -> "Reconfiguring AdminClient and restarting tasks for ClusterLinkClientManager");
                        this.createAndSetAdmin();
                        this.shutdownActiveTasks();
                        this.startupActiveTasks();
                    }
                } else {
                    throw new MatchError((Object)sp2);
                }
            }
            return;
        }
    }

    @Override
    public void onAvailabilityChange(boolean isAvailable) {
        Object object = this.lock();
        synchronized (object) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Processing link availability change to ").append(isAvailable).toString());
            this.shutdownActiveTasks();
            if (!Predef$.MODULE$.Boolean2boolean(this.currentConfig().clusterLinkPaused())) {
                if (isAvailable) {
                    this.startupActiveTasks();
                } else {
                    int intervalMs = Math.max(10, Math.min((int)Predef$.MODULE$.Long2long(this.config().reconnectBackoffMaxMs()), Predef$.MODULE$.Integer2int(this.config().availabilityCheckMs())));
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(105).append("Link is unavailable, starting availability checks with periodic interval ").append(intervalMs).append(" ms until link becomes available").toString());
                    this.clusterLinkCheckAvailability_$eq((Option<ClusterLinkCheckAvailability>)new Some((Object)new ClusterLinkCheckAvailability(this, this.config(), this.metrics(), this.clusterLinkManager(), intervalMs)));
                    ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkCheckAvailability().get()).startup();
                }
            }
            return;
        }
    }

    @Override
    public void addTopics(Set<String> addTopics) {
        Object object = this.lock();
        synchronized (object) {
            addTopics.foreach((Function1 & Serializable)topic -> {
                ClusterLinkClientManager.$anonfun$addTopics$1(this, topic);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void removeTopics(Set<String> removeTopics) {
        Object object = this.lock();
        synchronized (object) {
            removeTopics.foreach((Function1 & Serializable)topic -> {
                ClusterLinkClientManager.$anonfun$removeTopics$1(this, topic);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Set<String> getTopics() {
        Object object = this.lock();
        synchronized (object) {
            scala.collection.immutable.Set set = this.topics().toSet();
            return set;
        }
    }

    public ConfluentAdmin getAdmin() {
        Option<ClusterLinkAdminClient> currentAdmin = this.admin();
        if (currentAdmin == null) {
            throw new IllegalStateException(new StringBuilder(37).append("Client manager for cluster link data ").append(this.linkData()).toString());
        }
        return ((ClusterLinkAdminClient)currentAdmin.getOrElse((Function0 & Serializable)() -> {
            throw new ClusterLinkPausedException(new StringBuilder(27).append("Cluster link for ").append(this.linkData().linkName()).append(" is paused").toString());
        })).admin();
    }

    public ClusterLinkAdminClient getClusterLinkAdminClient() {
        Option<ClusterLinkAdminClient> currentAdmin = this.admin();
        if (currentAdmin == null) {
            throw new IllegalStateException(new StringBuilder(37).append("Client manager for cluster link data ").append(this.linkData()).toString());
        }
        return (ClusterLinkAdminClient)currentAdmin.getOrElse((Function0 & Serializable)() -> {
            throw new ClusterLinkPausedException(new StringBuilder(27).append("Cluster link for ").append(this.linkData().linkName()).append(" is paused").toString());
        });
    }

    public Option<Authorizer> getAuthorizer() {
        return this.authorizer;
    }

    public Option<ClusterLinkSyncAcls> getSyncAclTask() {
        return this.clusterLinkSyncAcls();
    }

    private boolean isActive() {
        return !Predef$.MODULE$.Boolean2boolean(this.config().clusterLinkPaused());
    }

    private void createAndSetAdmin() {
        this.closeAdmin();
        this.admin_$eq((Option<ClusterLinkAdminClient>)new Some(this.linkAdminFactory.apply((Object)this.config())));
    }

    private void closeAdmin() {
        Option<ClusterLinkAdminClient> curAdmin = this.admin();
        if (curAdmin != null) {
            curAdmin.foreach((Function1 & Serializable)a -> {
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> a.admin().close(Duration.ZERO), this, Level.WARN);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public CompletableFuture<Object> fetchTopicPartitions(String topic, int timeoutMs) {
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        try {
            DescribeTopicsOptions describeTopicsOptions = new DescribeTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs));
            DescribeTopicsResult describeTopicsResult = this.getAdmin().describeTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava(), describeTopicsOptions);
            this.scheduler().scheduleWhenComplete("ClusterLinkFetchTopicPartitions", describeTopicsResult.allTopicNames(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> result.complete(BoxesRunTime.boxToInteger((int)((TopicDescription)((KafkaFuture)describeTopicsResult.topicNameValues().get(topic)).get()).partitions().size())));
        }
        catch (Throwable e) {
            result.completeExceptionally(this.fetchTopicInfoWrapException(topic, e, "fetching partitions"));
        }
        return result;
    }

    @Override
    public CompletableFuture<ClusterLinkTopicInfo> fetchTopicInfo(String topic, int timeoutMs) {
        CompletableFuture<ClusterLinkTopicInfo> result = new CompletableFuture<ClusterLinkTopicInfo>();
        try {
            DescribeTopicsOptions describeTopicsOptions = new DescribeTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs)).includeAuthorizedOperations(true);
            DescribeTopicsResult describeTopicsResult = this.getAdmin().describeTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava(), describeTopicsOptions);
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
            DescribeConfigsOptions describeConfigsOptions = new DescribeConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs));
            DescribeConfigsResult describeConfigsResult = this.getAdmin().describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)resource, (List)Nil$.MODULE$)).asJava(), describeConfigsOptions);
            KafkaFuture futures = KafkaFuture.allOf((KafkaFuture[])new KafkaFuture[]{describeTopicsResult.allTopicNames(), describeConfigsResult.all()});
            this.scheduler().scheduleWhenComplete("FetchTopicInfo", futures, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.fetchTopicInfoHandleResults(topic, (KafkaFuture<Config>)((KafkaFuture)describeConfigsResult.values().get(resource)), (KafkaFuture<TopicDescription>)((KafkaFuture)describeTopicsResult.topicNameValues().get(topic)), result));
        }
        catch (Throwable e) {
            result.completeExceptionally(this.fetchTopicInfoWrapException(topic, e, "preparing client to fetch information"));
        }
        return result;
    }

    private void fetchTopicInfoHandleResults(String topic, KafkaFuture<Config> configFuture, KafkaFuture<TopicDescription> descriptionFuture, CompletableFuture<ClusterLinkTopicInfo> result) {
        try {
            TopicDescription description = (TopicDescription)this.maybeThrowException$1(topic, descriptionFuture, "fetching description");
            Config config = (Config)this.maybeThrowException$1(topic, configFuture, "fetching configuration");
            result.complete(new ClusterLinkTopicInfo(description, config));
            return;
        }
        catch (Throwable e) {
            result.completeExceptionally(e);
            return;
        }
    }

    private Throwable fetchTopicInfoWrapException(String topic, Throwable e, String action) {
        ApiError error = ApiError.fromThrowable((Throwable)e);
        return error.error().exception(new StringBuilder(42).append("While ").append(action).append(" for topic '").append(topic).append("' over cluster link '").append(this.linkData().linkName()).append("': ").append(error.messageWithFallback()).toString());
    }

    @Override
    public Map<TopicPartition, CompletableFuture<PartitionStatus>> replicaStatus(Set<TopicPartition> partitions) {
        ReplicaStatusOptions options = new ReplicaStatusOptions().includeLinkedReplicas(false);
        return CollectionConverters$.MODULE$.MapHasAsScala(this.getAdmin().replicaStatus(CollectionConverters$.MODULE$.SetHasAsJava(partitions).asJava(), options).partitionResults()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                KafkaFuture future = (KafkaFuture)x0$1._2();
                CompletableFuture completableFuture = new CompletableFuture();
                future.whenComplete((res, ex) -> {
                    Option option = Option$.MODULE$.apply(ex);
                    if (option instanceof Some) {
                        Throwable e = (Throwable)((Some)option).value();
                        completableFuture.completeExceptionally(e);
                        return;
                    }
                    if (None$.MODULE$.equals(option)) {
                        completableFuture.complete(this.toResultMirrorInfoStripped((PartitionResult)res));
                        return;
                    }
                    throw new MatchError((Object)option);
                });
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), completableFuture);
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private PartitionStatus toResultMirrorInfoStripped(PartitionResult result) {
        scala.collection.immutable.Seq replicas = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(result.replicas()).asScala().map((Function1 & Serializable)rs -> new ReplicaStatus(rs.brokerId(), rs.isLeader(), rs.isObserver(), rs.isIsrEligible(), rs.isInIsr(), rs.isCaughtUp(), rs.logStartOffset(), rs.logEndOffset(), rs.lastCaughtUpTimeMs(), rs.lastFetchTimeMs(), Optional.of(this.linkData().linkName()), Optional.empty()))).toSeq();
        return new PartitionStatus(result.leaderId(), result.leaderEpoch().getAsInt(), (Seq<ReplicaStatus>)replicas);
    }

    @Override
    public ClusterLinkConfig currentConfig() {
        return this.config();
    }

    public Properties restrictValidateTopicConfigPolicy(String topic, Properties props) {
        Option<AlterConfigPolicy> option = this.alterConfigPolicy();
        if (option instanceof Some) {
            AlterConfigPolicy policy = (AlterConfigPolicy)((Some)option).value();
            java.util.Map configs = Utils.propsToStringMap((Properties)props);
            if (policy instanceof ClusterLinkAlterConfigPolicy) {
                ClusterLinkAlterConfigPolicy clusterLinkAlterConfigPolicy = (ClusterLinkAlterConfigPolicy)policy;
                java.util.Map<String, String> newConfigs = clusterLinkAlterConfigPolicy.clusterLinkRestrictTopicConfigs(configs);
                clusterLinkAlterConfigPolicy.clusterLinkValidateTopicConfigs(newConfigs);
                return Utils.mkProperties(newConfigs);
            }
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
            policy.validate(new AlterConfigPolicy.RequestMetadata(resource, configs));
            return props;
        }
        if (None$.MODULE$.equals(option)) {
            return props;
        }
        throw new MatchError(option);
    }

    public MirrorTopicConfigSyncRules topicConfigSyncRules() {
        return this.currentConfig().topicConfigSyncRules();
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.clusterLinkManager().metadataManager();
    }

    private boolean isSupportedAuthorizer(Authorizer authorizer) {
        if (authorizer instanceof AclAuthorizer) {
            return true;
        }
        if (authorizer instanceof StandardAuthorizer) {
            return true;
        }
        return this.isSupportedAuthorizer("io.confluent.kafka.security.authorizer.ConfluentServerAuthorizer", authorizer);
    }

    private boolean isSupportedAuthorizer(String className, Authorizer authorizer) {
        try {
            return Utils.loadClass((String)className, Authorizer.class).isInstance(authorizer);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static final /* synthetic */ void $anonfun$addTopics$1(ClusterLinkClientManager $this, String topic) {
        if ($this.topics().add((Object)topic)) {
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Added topic '").append(topic).append("' for cluster link data '").append($this.linkData()).append("'").toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$removeTopics$1(ClusterLinkClientManager $this, String topic) {
        if ($this.topics().remove((Object)topic)) {
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Removed topic '").append(topic).append("' for cluster link data '").append($this.linkData()).append("''").toString());
            return;
        }
    }

    private final Object maybeThrowException$1(String topic, KafkaFuture future, String action) {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            throw this.fetchTopicInfoWrapException(topic, e.getCause(), action);
        }
        catch (Throwable e) {
            throw this.fetchTopicInfoWrapException(topic, e, action);
        }
    }

    public ClusterLinkClientManager(ClusterLinkManager clusterLinkManager, KafkaConfig brokerConfig, ClusterLinkData linkData, ClusterLinkFetcherManager fetcherManager, ClusterLinkScheduler scheduler, ClusterLinkConfig config, Option<Authorizer> authorizer, Option<AlterConfigPolicy> alterConfigPolicy, ClusterLinkMetrics metrics, Function1<ClusterLinkConfig, ClusterLinkAdminClient> linkAdminFactory, Function0<ConfluentAdmin> destAdminFactory, AclBindingFilterTransformer aclBindingFilterTransformer) {
        this.clusterLinkManager = clusterLinkManager;
        this.linkData = linkData;
        this.fetcherManager = fetcherManager;
        this.scheduler = scheduler;
        this.config = config;
        this.authorizer = authorizer;
        this.alterConfigPolicy = alterConfigPolicy;
        this.metrics = metrics;
        this.linkAdminFactory = linkAdminFactory;
        this.destAdminFactory = destAdminFactory;
        this.aclBindingFilterTransformer = aclBindingFilterTransformer;
        this.logIdent_$eq(new StringBuilder(36).append("[ClusterLinkClientManager-").append(linkData.linkName()).append("-broker-").append(brokerConfig.brokerId()).append("] ").toString());
        this.clusterLinkSyncAcls = None$.MODULE$;
        this.clusterLinkSyncOffsets = None$.MODULE$;
        this.clusterLinkSyncTopicConfigs = None$.MODULE$;
        this.clusterLinkCheckAvailability = None$.MODULE$;
        this.clusterLinkAutoMirroring = None$.MODULE$;
        this.clusterLinkListOffsets = None$.MODULE$;
        this.clusterLinkPauseMirrorTopics = new ClusterLinkPauseMirrorTopics(linkData.linkId(), linkData.linkName(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> !this.isActive(), scheduler, clusterLinkManager.metadataManager(), destAdminFactory, 20, 5000, 1000);
        this.lock = new Object();
        this.topics = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    }
}

