/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.LogAppendInfo;
import kafka.server.BrokerBlockingSender;
import kafka.server.FailedPartitions;
import kafka.server.FetcherLagMetrics;
import kafka.server.KafkaConfig;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread$AdjustmentType$;
import kafka.server.link.ClusterLinkFetcherThread$MinPartitionLagOrder$;
import kafka.server.link.ClusterLinkLeaderEndPoint;
import kafka.server.link.ClusterLinkLeaderEndPoint$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.FetchResponseSize;
import kafka.server.link.FetchState;
import kafka.server.link.MirrorFailureType;
import kafka.server.link.MirrorFailureType$;
import kafka.server.link.MirrorFailureType$IllegalState$;
import kafka.server.link.MirrorFailureType$SourceTopicDeleted$;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011}u!\u00021b\u0011\u0003Ag!\u00026b\u0011\u0003Y\u0007\"\u0002:\u0002\t\u0003\u0019\b\"\u0002;\u0002\t\u0003)xaBB\u0012\u0003!\u00051Q\u0005\u0004\b\u0007S\t\u0001\u0012AB\u0016\u0011\u0019\u0011X\u0001\"\u0001\u00044\u001511\u0011F\u0003\u0001\u0007kA\u0011b!\u0010\u0006\u0005\u0004%\taa\u0010\t\u0011\r\u0005S\u0001)A\u0005\u0007kA\u0011ba\u0011\u0006\u0005\u0004%\taa\u0010\t\u0011\r\u0015S\u0001)A\u0005\u0007kA\u0011ba\u0012\u0006\u0005\u0004%\taa\u0010\t\u0011\r%S\u0001)A\u0005\u0007kA\u0011ba\u0013\u0006\u0003\u0003%Ia!\u0014\u0007\r\r=\u0017\u0001QBi\u0011)\u0011Ym\u0004BK\u0002\u0013\u00051q\u001c\u0005\u000b\u0007C|!\u0011#Q\u0001\n\tu\u0001BCB7\u001f\tU\r\u0011\"\u0001\u0004d\"Q1Q]\b\u0003\u0012\u0003\u0006IA!\n\t\rI|A\u0011ABt\u0011%\u0019yoDA\u0001\n\u0003\u0019\t\u0010C\u0005\u0004x>\t\n\u0011\"\u0001\u0004z\"IAqB\b\u0012\u0002\u0013\u0005A\u0011\u0003\u0005\n\t+y\u0011\u0011!C!\u0003cD\u0011\u0002b\u0006\u0010\u0003\u0003%\t\u0001\"\u0007\t\u0013\u0011mq\"!A\u0005\u0002\u0011u\u0001\"\u0003C\u0015\u001f\u0005\u0005I\u0011\tC\u0016\u0011%!\u0019dDA\u0001\n\u0003!)\u0004C\u0005\u0005:=\t\t\u0011\"\u0011\u0005<!IAqH\b\u0002\u0002\u0013\u0005C\u0011\t\u0005\n\t\u0007z\u0011\u0011!C!\t\u000bB\u0011\u0002b\u0012\u0010\u0003\u0003%\t\u0005\"\u0013\b\u0013\u00115\u0013!!A\t\u0002\u0011=c!CBh\u0003\u0005\u0005\t\u0012\u0001C)\u0011\u0019\u0011(\u0005\"\u0001\u0005j!IA1\t\u0012\u0002\u0002\u0013\u0015CQ\t\u0005\ti\n\n\t\u0011\"!\u0005l!IA\u0011\u000f\u0012\u0002\u0002\u0013\u0005E1\u000f\u0005\n\u0007\u0017\u0012\u0013\u0011!C\u0005\u0007\u001b:q\u0001\" \u0002\u0011\u0003!yHB\u0004\u0005\u0002\u0006A\t\u0001b!\t\rILC\u0011\u0001CF\u0011\u001d!i)\u000bC\u0001\t\u001fC\u0011ba\u0013*\u0003\u0003%Ia!\u0014\t\u0013\u0011e\u0015!%A\u0005\u0002\u0011me\u0001\u00026b\u0001]D\u0001\u0002 \u0018\u0003\u0002\u0003\u0006I! \u0005\u000b\u0003#q#\u0011!Q\u0001\n\u0005M\u0001\u0002DA\r]\t\u0005\t\u0015!\u0003\u0002\u001c\u0005\u0005\u0002BCA\u0014]\t\u0005\t\u0015!\u0003\u0002*!Q\u0011q\u0006\u0018\u0003\u0002\u0003\u0006I!!\r\t\u0015\u0005]bF!A!\u0002\u0013\tI\u0004\u0003\u0006\u0002@9\u0012\t\u0011)A\u0005\u0003\u0003B!\"a\u0012/\u0005\u0003\u0005\u000b\u0011BA%\u0011)\tyE\fB\u0001B\u0003%\u0011\u0011\u000b\u0005\u000b\u0003/r#\u0011!Q\u0001\n\u0005e\u0003BCA0]\t\u0005\t\u0015!\u0003\u0002b!Q\u0011q\r\u0018\u0003\u0002\u0003\u0006I!!\u001b\t\u0015\u0005\reF!A!\u0002\u0013\t)\tC\u0006\u0002\u0012:\u0012)\u0019!C\u0001C\u0006M\u0005BCAN]\t\u0005\t\u0015!\u0003\u0002\u0016\"Q\u0011Q\u0014\u0018\u0003\u0002\u0003\u0006I!a(\t\u0015\u0005-fF!A!\u0002\u0013\ti\u000b\u0003\u0004s]\u0011\u0005\u0011q\u0016\u0005\n\u0003#t#\u0019!C\u0005\u0003'D\u0001\"!:/A\u0003%\u0011Q\u001b\u0005\n\u0003Ot#\u0019!C\u0005\u0003'D\u0001\"!;/A\u0003%\u0011Q\u001b\u0005\n\u0003Wt#\u0019!C\u0005\u0003'D\u0001\"!</A\u0003%\u0011Q\u001b\u0005\n\u0003_t#\u0019!C\u0005\u0003cD\u0001\"a>/A\u0003%\u00111\u001f\u0005\n\u0003st#\u0019!C\u0005\u0003wD\u0001Ba\u0002/A\u0003%\u0011Q \u0005\n\u0005\u0013q#\u0019!C\u0005\u0005\u0017A\u0001Ba\u000b/A\u0003%!Q\u0002\u0005\b\u0005[qC\u0011\tB\u0018\u0011%\u00119D\fb\u0001\n\u0003\u0012I\u0004\u0003\u0005\u0003B9\u0002\u000b\u0011\u0002B\u001e\u0011\u001d\u0011\u0019E\fC)\u0005\u000bBqAa\u0016/\t#\u0012I\u0006C\u0004\u0003b9\"\tFa\u0019\t\u000f\tud\u0006\"\u0011\u0003\u0000!A!Q\u0012\u0018\u0005R\u0005\u0014y\tC\u0004\u0003\":\"\tEa)\t\u000f\t\u0015g\u0006\"\u0011\u0003H\"A!1\u001e\u0018\u0005\u0002\u0005\u0014i\u000fC\u0004\u0003r:\"\tEa=\t\u000f\r\u001da\u0006\"\u0001\u0004\n!911\f\u0018\u0005\u0012\ru\u0003\u0002CB2]\u0011\u0005\u0011Ma\f\t\u000f\r\u0015d\u0006\"\u0011\u0004h!91q\u000e\u0018\u0005B\rE\u0004bBB=]\u0011%11\u0010\u0005\t\u0007/sC\u0011A1\u0004\u001a\u0006A2\t\\;ti\u0016\u0014H*\u001b8l\r\u0016$8\r[3s)\"\u0014X-\u00193\u000b\u0005\t\u001c\u0017\u0001\u00027j].T!\u0001Z3\u0002\rM,'O^3s\u0015\u00051\u0017!B6bM.\f7\u0001\u0001\t\u0003S\u0006i\u0011!\u0019\u0002\u0019\u00072,8\u000f^3s\u0019&t7NR3uG\",'\u000f\u00165sK\u0006$7CA\u0001m!\ti\u0007/D\u0001o\u0015\u0005y\u0017!B:dC2\f\u0017BA9o\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001[\u0001\u0006CB\u0004H.\u001f\u000b m\u000e\u000561UBS\u0007O\u001bIka+\u0004.\u000e]6\u0011YBb\u0007\u000b\u001c9m!3\u0004L\u000e5\u0007CA5/'\tq\u0003\u0010\u0005\u0002zu6\t1-\u0003\u0002|G\n!\"+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\fAA\\1nKB\u0019a0a\u0003\u000f\u0007}\f9\u0001E\u0002\u0002\u00029l!!a\u0001\u000b\u0007\u0005\u0015q-\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0013q\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002\u000e\u0005=!AB*ue&twMC\u0002\u0002\n9\f\u0011BZ3uG\",'/\u00133\u0011\u00075\f)\"C\u0002\u0002\u00189\u00141!\u00138u\u0003\u0019aW-\u00193feB\u0019\u0011.!\b\n\u0007\u0005}\u0011MA\rDYV\u001cH/\u001a:MS:\\G*Z1eKJ,e\u000e\u001a)pS:$\u0018\u0002BA\r\u0003GI1!!\nd\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\fAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u00042!_A\u0016\u0013\r\tic\u0019\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\tdYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\u00042![A\u001a\u0013\r\t)$\u0019\u0002\u0012\u00072,8\u000f^3s\u0019&t7nQ8oM&<\u0017aE2mkN$XM\u001d'j].lU\r^1eCR\f\u0007cA5\u0002<%\u0019\u0011QH1\u0003'\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1\u0002\u001d\u0019,Go\u00195fe6\u000bg.Y4feB\u0019\u0011.a\u0011\n\u0007\u0005\u0015\u0013MA\rDYV\u001cH/\u001a:MS:\\g)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014\u0018\u0001\u00054bS2,G\rU1si&$\u0018n\u001c8t!\rI\u00181J\u0005\u0004\u0003\u001b\u001a'\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0003)\u0011X\r\u001d7jG\u0006luM\u001d\t\u0004s\u0006M\u0013bAA+G\nq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018!B9v_R\f\u0007cA=\u0002\\%\u0019\u0011QL2\u0003\u0019I+\u0007\u000f\\5dCF+x\u000e^1\u0002%\rdWo\u001d;fe2Kgn['fiJL7m\u001d\t\u0004S\u0006\r\u0014bAA3C\n\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t\u0003\u0011!\u0018.\\3\u0011\t\u0005-\u0014qP\u0007\u0003\u0003[RA!a\u001c\u0002r\u0005)Q\u000f^5mg*!\u00111OA;\u0003\u0019\u0019w.\\7p]*\u0019a-a\u001e\u000b\t\u0005e\u00141P\u0001\u0007CB\f7\r[3\u000b\u0005\u0005u\u0014aA8sO&!\u0011\u0011QA7\u0005\u0011!\u0016.\\3\u0002!\u0011Lh.Y7jG\u001a+Go\u00195TSj,\u0007#B7\u0002\b\u0006-\u0015bAAE]\nIa)\u001e8di&|g\u000e\r\t\u0004S\u00065\u0015bAAHC\n\tb)\u001a;dQJ+7\u000f]8og\u0016\u001c\u0016N_3\u0002#\rdWo\u001d;fe2Kgn[\"mS\u0016tG/\u0006\u0002\u0002\u0016B\u0019\u0011.a&\n\u0007\u0005e\u0015M\u0001\rDYV\u001cH/\u001a:MS:\\g*\u001a;x_J\\7\t\\5f]R\f!c\u00197vgR,'\u000fT5oW\u000ec\u0017.\u001a8uA\u0005iAn\\4D_:$X\r\u001f;PaR\u0004R!\\AQ\u0003KK1!a)o\u0005\u0019y\u0005\u000f^5p]B!\u00111NAT\u0013\u0011\tI+!\u001c\u0003\u00151{wmQ8oi\u0016DH/\u0001\u0004uK:\fg\u000e\u001e\t\u0005[\u0006\u0005V\u0010F\u0011w\u0003c\u000b\u0019,!.\u00028\u0006e\u00161XA_\u0003\u007f\u000b\t-a1\u0002F\u0006\u001d\u0017\u0011ZAf\u0003\u001b\fy\rC\u0003}\u0001\u0002\u0007Q\u0010C\u0004\u0002\u0012\u0001\u0003\r!a\u0005\t\u000f\u0005e\u0001\t1\u0001\u0002\u001c!9\u0011q\u0005!A\u0002\u0005%\u0002bBA\u0018\u0001\u0002\u0007\u0011\u0011\u0007\u0005\b\u0003o\u0001\u0005\u0019AA\u001d\u0011\u001d\ty\u0004\u0011a\u0001\u0003\u0003Bq!a\u0012A\u0001\u0004\tI\u0005C\u0004\u0002P\u0001\u0003\r!!\u0015\t\u000f\u0005]\u0003\t1\u0001\u0002Z!9\u0011q\f!A\u0002\u0005\u0005\u0004bBA4\u0001\u0002\u0007\u0011\u0011\u000e\u0005\b\u0003\u0007\u0003\u0005\u0019AAC\u0011\u001d\t\t\n\u0011a\u0001\u0003+C\u0011\"!(A!\u0003\u0005\r!a(\t\u000f\u0005-\u0006\t1\u0001\u0002.\u00061B.\u001b8l\r\u0016$8\r[3s\r2|woQ8oiJ|G.\u0006\u0002\u0002VB!\u0011q[Aq\u001b\t\tIN\u0003\u0003\u0002\\\u0006u\u0017\u0001\u00027b]\u001eT!!a8\u0002\t)\fg/Y\u0005\u0005\u0003G\fINA\u0004J]R,w-\u001a:\u0002/1Lgn\u001b$fi\u000eDWM\u001d$m_^\u001cuN\u001c;s_2\u0004\u0013a\b7j].4U\r^2iKJl\u0015\r\u001f'bO\u001eLgn\u001a)beRLG/[8og\u0006\u0001C.\u001b8l\r\u0016$8\r[3s\u001b\u0006DH*Y4hS:<\u0007+\u0019:uSRLwN\\:!\u0003ua\u0017N\\6GKR\u001c\u0007.\u001a:MC\u001e<\u0017N\\4QCJ$\u0018\u000e^5p]6\u001b\u0018A\b7j].4U\r^2iKJd\u0015mZ4j]\u001e\u0004\u0016M\u001d;ji&|g.T:!\u0003I)h\u000e\u001d:fM&DX\r\u001a'j].t\u0015-\\3\u0016\u0005\u0005M\b\u0003BAl\u0003kLA!!\u0004\u0002Z\u0006\u0019RO\u001c9sK\u001aL\u00070\u001a3MS:\\g*Y7fA\u00059Q.\u001a;sS\u000e\u001cXCAA\u007f!\u0011\tyPa\u0001\u000e\u0005\t\u0005!\u0002BA}\u0003cJAA!\u0002\u0003\u0002\t9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u00027A\f'\u000f^5uS>tG*Y:u\u0007\u0006,x\r\u001b;VaRKW.Z't+\t\u0011i\u0001\u0005\u0005\u0003\u0010\te!Q\u0004B\u0013\u001b\t\u0011\tB\u0003\u0003\u0003\u0014\tU\u0011AC2p]\u000e,(O]3oi*!!qCAo\u0003\u0011)H/\u001b7\n\t\tm!\u0011\u0003\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\b\u0003\u0002B\u0010\u0005Ci!!!\u001d\n\t\t\r\u0012\u0011\u000f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\ri'qE\u0005\u0004\u0005Sq'\u0001\u0002'p]\u001e\fA\u0004]1si&$\u0018n\u001c8MCN$8)Y;hQR,\u0006\u000fV5nK6\u001b\b%\u0001\u0004e_^{'o\u001b\u000b\u0003\u0005c\u00012!\u001cB\u001a\u0013\r\u0011)D\u001c\u0002\u0005+:LG/A\u0010jg>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i'V\u0004\bo\u001c:uK\u0012,\"Aa\u000f\u0011\u00075\u0014i$C\u0002\u0003@9\u0014qAQ8pY\u0016\fg.\u0001\u0011jg>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i'V\u0004\bo\u001c:uK\u0012\u0004\u0013AD8o\u001f\u001a47/\u001a;US\u0016\u0014X\r\u001a\u000b\u0007\u0005w\u00119Ea\u0013\t\u000f\t%\u0003\u000b1\u0001\u0003\u001e\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007b\u0002B'!\u0002\u0007!qJ\u0001\re\u0016\fX/Z:u\u000bB|7\r\u001b\t\u0007\u0005#\u0012\u0019&!6\u000e\u0005\tU\u0011\u0002\u0002B+\u0005+\u0011\u0001b\u00149uS>t\u0017\r\\\u0001\u0012_:\u0004\u0016M\u001d;ji&|gNR3oG\u0016$GC\u0002B\u001e\u00057\u0012y\u0006C\u0004\u0003^E\u0003\rA!\b\u0002\u0005Q\u0004\bb\u0002B'#\u0002\u0007!qJ\u0001\u0019Q\u0006tG\r\\3QCJ$\u0018\u000e^5p]\u0016C8-\u001a9uS>tGC\u0002B\u001e\u0005K\u00129\u0007C\u0004\u0003^I\u0003\rA!\b\t\u000f\t%$\u000b1\u0001\u0003l\u0005\tQ\r\u0005\u0003\u0003n\t]d\u0002\u0002B8\u0005grA!!\u0001\u0003r%\tq.C\u0002\u0003v9\fq\u0001]1dW\u0006<W-\u0003\u0003\u0003z\tm$!C#yG\u0016\u0004H/[8o\u0015\r\u0011)H\\\u0001\tiJ,hnY1uKR1!\u0011\u0007BA\u0005\u0007CqA!\u0018T\u0001\u0004\u0011i\u0002C\u0004\u0003\u0006N\u0003\rAa\"\u0002+=4gm]3u)J,hnY1uS>t7\u000b^1uKB\u0019\u0011P!#\n\u0007\t-5MA\u000bPM\u001a\u001cX\r\u001e+sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0002_U\u0004H-\u0019;f\r\u0016$8\r[(gMN,G/\u00118e\u001b\u0006L(-Z'be.$&/\u001e8dCRLwN\\\"p[BdW\r^3\u0015\t\tE\"\u0011\u0013\u0005\b\u0005'#\u0006\u0019\u0001BK\u000311W\r^2i\u001f\u001a47/\u001a;t!!\u00119J!(\u0003\u001e\t\u001dUB\u0001BM\u0015\r\u0011YJ\\\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BP\u00053\u00131!T1q\u0003Q\u0001(o\\2fgN\u0004\u0016M\u001d;ji&|g\u000eR1uCRA!Q\u0015BZ\u0005k\u0013I\fE\u0003n\u0003C\u00139\u000b\u0005\u0003\u0003*\n=VB\u0001BV\u0015\r\u0011i+Z\u0001\u0004Y><\u0017\u0002\u0002BY\u0005W\u0013Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007b\u0002B/+\u0002\u0007!Q\u0004\u0005\b\u0005o+\u0006\u0019\u0001B\u0013\u0003-1W\r^2i\u001f\u001a47/\u001a;\t\u000f\tmV\u000b1\u0001\u0003>\u0006i\u0001/\u0019:uSRLwN\u001c#bi\u0006\u0004BAa0\u0003B6\ta&\u0003\u0003\u0003D\u0006\r\"!\u0003$fi\u000eDG)\u0019;b\u0003\u0005*\b\u000fZ1uK\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0003:$7\u000b^1si>3gm]3u))\u0011)C!3\u0003Z\n\u0005(Q\u001d\u0005\b\u0005\u00174\u0006\u0019\u0001Bg\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0003\u0003P\nUWB\u0001Bi\u0015\r\u0011\u0019.Z\u0001\bG2,8\u000f^3s\u0013\u0011\u00119N!5\u0003\u0013A\u000b'\u000f^5uS>t\u0007b\u0002BW-\u0002\u0007!1\u001c\t\u0005\u0005S\u0013i.\u0003\u0003\u0003`\n-&aC!cgR\u0014\u0018m\u0019;M_\u001eDqAa9W\u0001\u0004\u0011)#A\rt_V\u00148-\u001a'fC\u0012,'\u000fS5hQ^\u000bG/\u001a:nCJ\\\u0007b\u0002Bt-\u0002\u0007!\u0011^\u0001\u001bg>,(oY3MK\u0006$WM\u001d'pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\t\u0006[\u0006\u0005&QE\u0001\u0019[\u0006L(-\u001a(pi&4\u0017PU3bIf4uN\u001d$fi\u000eDG\u0003\u0002B\u0019\u0005_DqAa3X\u0001\u0004\u0011i-\u0001\tsK6|g/\u001a)beRLG/[8ogR!!Q\u001fB\u007f!!\u00119J!(\u0003\u001e\t]\bcA=\u0003z&\u0019!1`2\u0003'A\u000b'\u000f^5uS>tg)\u001a;dQN#\u0018\r^3\t\u000f\t}\b\f1\u0001\u0004\u0002\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0005\u0004\u0003\u0018\u000e\r!QD\u0005\u0005\u0007\u000b\u0011IJA\u0002TKR\fq$\u00193kkN$H*Y4hS:<\u0007+\u0019:uSRLwN\\:SKF,\u0018N]3e)\u0011\u0019Yaa\u0016\u0011\u000f5\u001cia!\u0005\u0004V%\u00191q\u00028\u0003\rQ+\b\u000f\\33!\r\u0019\u0019b\u0002\b\u0004\u0007+!abAB\f\u00019!1\u0011DB\u0011\u001d\u0011\u0019Yba\b\u000f\t\u0005\u00051QD\u0005\u0002M&\u0011A-Z\u0005\u0003E\u000e\fa\"\u00113kkN$X.\u001a8u)f\u0004X\rE\u0002\u0004(\u0015i\u0011!\u0001\u0002\u000f\u0003\u0012TWo\u001d;nK:$H+\u001f9f'\r)1Q\u0006\t\u0004[\u000e=\u0012bAB\u0019]\nYQI\\;nKJ\fG/[8o)\t\u0019)\u0003\u0005\u0003\u00048\reR\"A\u0003\n\t\rm2q\u0006\u0002\u0006-\u0006dW/Z\u0001\r\u001d>\fEM[;ti6,g\u000e^\u000b\u0003\u0007k\tQBT8BI*,8\u000f^7f]R\u0004\u0013\u0001C%oGJ,\u0017m]3\u0002\u0013%s7M]3bg\u0016\u0004\u0013\u0001\u0003#fGJ,\u0017m]3\u0002\u0013\u0011+7M]3bg\u0016\u0004\u0013\u0001D<sSR,'+\u001a9mC\u000e,GCAB(!\u0011\t9n!\u0015\n\t\rM\u0013\u0011\u001c\u0002\u0007\u001f\nTWm\u0019;\u0011\u000b5\f\tk!\u0001\t\u000f\re\u0013\f1\u0001\u0003&\u0005)an\\<Ng\u0006I2\r\\3beB\u000b'\u000f^5uS>tG*\u001b8l\r\u0006LG.\u001e:f)\u0019\u0011\tda\u0018\u0004b!9!Q\f.A\u0002\tu\u0001b\u0002B\\5\u0002\u0007!QE\u0001\u0017kB$\u0017\r^3Es:\fW.[2GKR\u001c\u0007nU5{K\u0006)R\u000f\u001d3bi\u00164U\r^2iKJd\u0015mZ*uCR\u001cHC\u0002B\u0019\u0007S\u001aY\u0007C\u0004\u0003^q\u0003\rA!\b\t\u000f\r5D\f1\u0001\u0003&\u0005\u0019A.Y4\u0002+U\u0004H-\u0019;f\r\u0016$8\r[3s\u0005f$XMU1uKR1!\u0011GB:\u0007kBqA!\u0018^\u0001\u0004\u0011i\u0002C\u0004\u0004xu\u0003\rA!\n\u0002\u000b\tLH/Z:\u0002-\u001d,Go\u0014:De\u0016\fG/\u001a+pa&\u001c7+\u001a8t_J$\"b! \u0004\u0004\u000e\u001d5\u0011RBJ!\u0011\typa \n\t\r\u0005%\u0011\u0001\u0002\u0007'\u0016t7o\u001c:\t\r\r\u0015e\f1\u0001~\u0003\u0015!x\u000e]5d\u0011\u0015ah\f1\u0001~\u0011\u001d\u0019YI\u0018a\u0001\u0007\u001b\u000bAa\u001d;biB!\u0011q`BH\u0013\u0011\u0019\tJ!\u0001\u0003\u001d5+\u0017m];sC\ndWm\u0015;bi\"11Q\u00130A\u0002u\f1\u0002Z3tGJL\u0007\u000f^5p]\u0006yR\u000f\u001d3bi\u0016\u0004\u0016M\u001d;ji&|g\u000eT1ti\u000e\u000bWo\u001a5u+B$\u0016.\\3\u0015\r\tE21TBO\u0011\u001d\u0011if\u0018a\u0001\u0005;Aqaa(`\u0001\u0004\u0011)#\u0001\bdCV<\u0007\u000e^+q)&lW-T:\t\u000bq\u001c\u0001\u0019A?\t\u000f\u0005E1\u00011\u0001\u0002\u0014!9\u0011qE\u0002A\u0002\u0005%\u0002bBA\u0018\u0007\u0001\u0007\u0011\u0011\u0007\u0005\b\u0003o\u0019\u0001\u0019AA\u001d\u0011\u001d\tyd\u0001a\u0001\u0003\u0003Bqaa,\u0004\u0001\u0004\u0019\t,A\u000beKN$8i\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:\u0011\u0007%\u001c\u0019,C\u0002\u00046\u0006\u0014\u0001e\u00117vgR,'\u000fT5oW\u0012+7\u000f^\"p]:,7\r^5p]6\u000bg.Y4fe\"91\u0011X\u0002A\u0002\rm\u0016\u0001D:pkJ\u001cWM\u0011:pW\u0016\u0014\b\u0003\u0002Bh\u0007{KAaa0\u0003R\nq!I]8lKJ,e\u000e\u001a)pS:$\bbBA$\u0007\u0001\u0007\u0011\u0011\n\u0005\b\u0003\u001f\u001a\u0001\u0019AA)\u0011\u001d\t9f\u0001a\u0001\u00033Bq!a\u0018\u0004\u0001\u0004\t\t\u0007C\u0004\u0002h\r\u0001\r!!\u001b\t\u000f\u0005-6\u00011\u0001\u0002.\"9\u00111Q\u0002A\u0002\u0005\u0015%a\u0004)beRLG/[8o\u0003:$G*Y4\u0014\r=a71[Bm!\ri7Q[\u0005\u0004\u0007/t'a\u0002)s_\u0012,8\r\u001e\t\u0005\u0005[\u001aY.\u0003\u0003\u0004^\nm$\u0001D*fe&\fG.\u001b>bE2,WC\u0001B\u000f\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u000b\u0003\u0005K\tA\u0001\\1hAQ11\u0011^Bv\u0007[\u00042aa\n\u0010\u0011\u001d\u0011Y\r\u0006a\u0001\u0005;Aqa!\u001c\u0015\u0001\u0004\u0011)#\u0001\u0003d_BLHCBBu\u0007g\u001c)\u0010C\u0005\u0003LV\u0001\n\u00111\u0001\u0003\u001e!I1QN\u000b\u0011\u0002\u0003\u0007!QE\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019YP\u000b\u0003\u0003\u001e\ru8FAB\u0000!\u0011!\t\u0001b\u0003\u000e\u0005\u0011\r!\u0002\u0002C\u0003\t\u000f\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0011%a.\u0001\u0006b]:|G/\u0019;j_:LA\u0001\"\u0004\u0005\u0004\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011A1\u0003\u0016\u0005\u0005K\u0019i0A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003'\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0005 \u0011\u0015\u0002cA7\u0005\"%\u0019A1\u00058\u0003\u0007\u0005s\u0017\u0010C\u0005\u0005(i\t\t\u00111\u0001\u0002\u0014\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"\u0001\"\f\u0011\r\t]Eq\u0006C\u0010\u0013\u0011!\tD!'\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005w!9\u0004C\u0005\u0005(q\t\t\u00111\u0001\u0005 \u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\u0019\u0010\"\u0010\t\u0013\u0011\u001dR$!AA\u0002\u0005M\u0011\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005M\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005M\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0003<\u0011-\u0003\"\u0003C\u0014A\u0005\u0005\t\u0019\u0001C\u0010\u0003=\u0001\u0016M\u001d;ji&|g.\u00118e\u0019\u0006<\u0007cAB\u0014EM)!\u0005b\u0015\u0005`AQAQ\u000bC.\u0005;\u0011)c!;\u000e\u0005\u0011]#b\u0001C-]\u00069!/\u001e8uS6,\u0017\u0002\u0002C/\t/\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011!\t\u0007b\u001a\u000e\u0005\u0011\r$\u0002\u0002C3\u0003;\f!![8\n\t\ruG1\r\u000b\u0003\t\u001f\"ba!;\u0005n\u0011=\u0004b\u0002BfK\u0001\u0007!Q\u0004\u0005\b\u0007[*\u0003\u0019\u0001B\u0013\u0003\u001d)h.\u00199qYf$B\u0001\"\u001e\u0005zA)Q.!)\u0005xA9Qn!\u0004\u0003\u001e\t\u0015\u0002\"\u0003C>M\u0005\u0005\t\u0019ABu\u0003\rAH\u0005M\u0001\u0015\u001b&t\u0007+\u0019:uSRLwN\u001c'bO>\u0013H-\u001a:\u0011\u0007\r\u001d\u0012F\u0001\u000bNS:\u0004\u0016M\u001d;ji&|g\u000eT1h\u001fJ$WM]\n\u0006S\r=CQ\u0011\t\u0007\u0005[\"9i!;\n\t\u0011%%1\u0010\u0002\t\u001fJ$WM]5oOR\u0011AqP\u0001\bG>l\u0007/\u0019:f)\u0019\t\u0019\u0002\"%\u0005\u0016\"9A1S\u0016A\u0002\r%\u0018!\u0001=\t\u000f\u0011]5\u00061\u0001\u0004j\u0006\t\u00110\u0001\u000f%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u001b\u0016\u0005\u0011u%\u0006BAP\u0007{\u0004")
public class ClusterLinkFetcherThread
extends ReplicaFetcherThread {
    private final ClusterLinkMetadata clusterLinkMetadata;
    private final ClusterLinkFetcherManager fetcherManager;
    private final ReplicaManager replicaMgr;
    private final ClusterLinkMetrics clusterLinkMetrics;
    private final Time time;
    private final Function0<FetchResponseSize> dynamicFetchSize;
    private final ClusterLinkNetworkClient clusterLinkClient;
    private final Option<String> tenant;
    private final Integer linkFetcherFlowControl;
    private final Integer linkFetcherMaxLaggingPartitions;
    private final Integer linkFetcherLaggingPartitionMs;
    private final String unprefixedLinkName;
    private final Metrics metrics;
    private final ConcurrentHashMap<TopicPartition, Object> partitionLastCaughtUpTimeMs;
    private final boolean isOffsetForLeaderEpochSupported;

    public static Option<LogContext> $lessinit$greater$default$15() {
        return None$.MODULE$;
    }

    public static ClusterLinkFetcherThread apply(String name, int fetcherId, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata, ClusterLinkFetcherManager fetcherManager, ClusterLinkDestConnectionManager destConnectionManager, BrokerEndPoint sourceBroker, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics, Time time, Option<String> tenant, Function0<FetchResponseSize> dynamicFetchSize) {
        int apply_brokerId = brokerConfig.brokerId();
        LogContext apply_logContext = new LogContext(new StringBuilder(68).append("[ClusterLinkFetcher brokerId=").append(apply_brokerId).append(" ").append("fetcherId=").append(fetcherId).append("] source(link=").append(clusterLinkMetadata.linkName()).append(", leaderId=").append(sourceBroker.id()).append(")] ").toString(), destConnectionManager.maxLogLevel());
        ClusterLinkNetworkClient apply_clusterLinkClient = new ClusterLinkNetworkClient(brokerConfig, clusterLinkConfig, ClusterLinkMetrics$.MODULE$.throttleTimeSensorName(clusterLinkMetadata.linkName()), (Option<ClusterLinkMetadata>)None$.MODULE$, (Option<MetadataUpdater>)new Some((Object)new ManualMetadataUpdater()), clusterLinkMetrics.metrics(), (Map<String, String>)((Map)ClusterLinkFactory$.MODULE$.linkMetricTags(clusterLinkMetadata.linkName()).$plus$plus((IterableOnce)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)Integer.toString(sourceBroker.id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-id"), (Object)Integer.toString(fetcherId))})))), time, new StringBuilder(22).append("link-").append(clusterLinkMetadata.linkName()).append("-broker-").append(apply_brokerId).append("-fetcher-").append(fetcherId).toString(), "fetcher", apply_logContext);
        destConnectionManager.enableClusterLink(apply_clusterLinkClient, (Option<AdminMetadataManager>)None$.MODULE$);
        BrokerBlockingSender apply_blockingSender = new BrokerBlockingSender(sourceBroker, brokerConfig, Predef$.MODULE$.Integer2int(clusterLinkConfig.replicaSocketTimeoutMs()), time, fetcherId, apply_clusterLinkClient.networkClient(), (Option<Reconfigurable>)None$.MODULE$);
        ClusterLinkLeaderEndPoint apply_leader = ClusterLinkLeaderEndPoint$.MODULE$.apply(apply_logContext, time, apply_blockingSender, brokerConfig, clusterLinkConfig, replicaMgr, quota, clusterLinkMetrics);
        return new ClusterLinkFetcherThread(name, fetcherId, apply_leader, brokerConfig, clusterLinkConfig, clusterLinkMetadata, fetcherManager, failedPartitions, replicaMgr, quota, clusterLinkMetrics, time, dynamicFetchSize, apply_clusterLinkClient, (Option<LogContext>)new Some((Object)apply_logContext), tenant);
    }

    public ClusterLinkNetworkClient clusterLinkClient() {
        return this.clusterLinkClient;
    }

    private Integer linkFetcherFlowControl() {
        return this.linkFetcherFlowControl;
    }

    private Integer linkFetcherMaxLaggingPartitions() {
        return this.linkFetcherMaxLaggingPartitions;
    }

    private Integer linkFetcherLaggingPartitionMs() {
        return this.linkFetcherLaggingPartitionMs;
    }

    private String unprefixedLinkName() {
        return this.unprefixedLinkName;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private ConcurrentHashMap<TopicPartition, Object> partitionLastCaughtUpTimeMs() {
        return this.partitionLastCaughtUpTimeMs;
    }

    @Override
    public void doWork() {
        this.updateDynamicFetchSize();
        super.doWork();
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public boolean onOffsetTiered(TopicPartition topicPartition, Optional<Integer> requestEpoch) {
        this.fetcherManager.onPartitionLinkFailure(topicPartition, MirrorFailureType$IllegalState$.MODULE$, new StringBuilder(36).append("Unexpected tiered offset for ").append(topicPartition).append(" epoch ").append(requestEpoch).toString(), this.fetcherManager.onPartitionLinkFailure$default$4());
        return false;
    }

    @Override
    public boolean onPartitionFenced(TopicPartition tp, Optional<Integer> requestEpoch) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("onPartitionFenced ").append(tp).append(" : request metadata ").toString());
        this.clusterLinkMetadata.requestUpdate();
        return super.onPartitionFenced(tp, requestEpoch);
    }

    @Override
    public boolean handlePartitionException(TopicPartition tp, Exception e) {
        Option<MirrorFailureType> failure2 = MirrorFailureType$.MODULE$.failureType(e);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Handle mirror partition failure ").append(failure2).append(" for partition ").append(tp).append(" due to exception ").append(e).toString());
        if (failure2.exists((Function1 & Serializable)failure -> BoxesRunTime.boxToBoolean((boolean)this.fetcherManager.onPartitionLinkFailure(tp, failure, e.getMessage(), false)))) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Request metadata update because of errors for partition ").append(tp).toString());
            this.clusterLinkMetadata.requestUpdate();
        }
        return true;
    }

    @Override
    public void truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        Partition partition = this.replicaMgr.getPartitionOrException(tp);
        AbstractLog log = partition.localLogOrException();
        if (log.logEndOffset() > offsetTruncationState.offset() && partition.getLinkedLeaderEpoch().contains((Object)BoxesRunTime.boxToInteger((int)0))) {
            String errorMessage = new StringBuilder(164).append("Failing mirror due to unexpected truncation to offset ").append(offsetTruncationState.offset()).append(" ").append("with source leader epoch 0 when destination leader leo is ").append(log.logEndOffset()).append(". ").append("Source topic may have been deleted and recreated.").toString();
            this.error((Function0<String>)(Function0 & Serializable)() -> errorMessage);
            this.fetcherManager.onPartitionLinkFailure(tp, MirrorFailureType$SourceTopicDeleted$.MODULE$, errorMessage, false);
            this.markPartitionFailed(tp);
            return;
        }
        super.truncate(tp, offsetTruncationState);
    }

    @Override
    public void updateFetchOffsetAndMaybeMarkTruncationComplete(Map<TopicPartition, OffsetTruncationState> fetchOffsets) {
        super.updateFetchOffsetAndMaybeMarkTruncationComplete(fetchOffsets);
        fetchOffsets.foreach((Function1 & Serializable)x0$1 -> {
            ClusterLinkFetcherThread.$anonfun$updateFetchOffsetAndMaybeMarkTruncationComplete$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition tp, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        this.fetcherManager.updatePartitionFetchState(tp, new FetchState(((ClusterLinkLeaderEndPoint)super.leader()).lastFetchTimeMs(), partitionData.highWatermark()));
        this.clearPartitionLinkFailure(tp, fetchOffset);
        return super.processPartitionData(tp, fetchOffset, partitionData);
    }

    @Override
    public long updateHighWatermarkAndStartOffset(Partition partition, AbstractLog log, long sourceLeaderHighWatermark, Option<Object> sourceLeaderLogStartOffset) {
        partition.maybeIncrementLinkLeaderHW(log);
        sourceLeaderLogStartOffset.foreach((Function1)(JFunction1.mcZJ.sp & Serializable)sourceStartOffset -> {
            long destStartOffset = package$.MODULE$.min(log.highWatermark(), sourceStartOffset);
            return log.maybeIncrementLogStartOffset(destStartOffset, LeaderOffsetIncremented$.MODULE$);
        });
        return log.highWatermark();
    }

    public void maybeNotifyReadyForFetch(Partition partition) {
        if (ClusterLinkLeaderEndPoint$.MODULE$.isReadyForFetchForPartition(partition, this.clusterLinkMetrics, this.linkFetcherFlowControl(), false)) {
            this.notifyReadyForFetch();
            return;
        }
    }

    @Override
    public Map<TopicPartition, PartitionFetchState> removePartitions(Set<TopicPartition> topicPartitions) {
        Map<TopicPartition, PartitionFetchState> removedPartitions = super.removePartitions(topicPartitions);
        removedPartitions.foreach((Function1 & Serializable)p -> BoxesRunTime.boxToLong((long)ClusterLinkFetcherThread.$anonfun$removePartitions$1(this, p)));
        return removedPartitions;
    }

    public Tuple2<Enumeration.Value, Option<Set<TopicPartition>>> adjustLaggingPartitionsRequired(long nowMs) {
        IntRef numLaggingPartitions = IntRef.create((int)0);
        this.partitionLastCaughtUpTimeMs().forEach((x$2, caughtUpTimeMs) -> ClusterLinkFetcherThread.$anonfun$adjustLaggingPartitionsRequired$1(this, nowMs, numLaggingPartitions, x$2, BoxesRunTime.unboxToLong((Object)caughtUpTimeMs)));
        if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)numLaggingPartitions.elem), (Object)this.linkFetcherMaxLaggingPartitions())) {
            return new Tuple2((Object)ClusterLinkFetcherThread$AdjustmentType$.MODULE$.NoAdjustment(), (Object)None$.MODULE$);
        }
        if (numLaggingPartitions.elem < Predef$.MODULE$.Integer2int(this.linkFetcherMaxLaggingPartitions())) {
            return new Tuple2((Object)ClusterLinkFetcherThread$AdjustmentType$.MODULE$.Increase(), (Object)None$.MODULE$);
        }
        int numPartitionsToRemove = numLaggingPartitions.elem - Predef$.MODULE$.Integer2int(this.linkFetcherMaxLaggingPartitions());
        PriorityQueue minHeap = PriorityQueue$.MODULE$.empty((Ordering)ClusterLinkFetcherThread$MinPartitionLagOrder$.MODULE$);
        this.partitionLastCaughtUpTimeMs().forEach((topicPartition, caughtUpTimeMs) -> ClusterLinkFetcherThread.$anonfun$adjustLaggingPartitionsRequired$2(this, nowMs, minHeap, numPartitionsToRemove, topicPartition, BoxesRunTime.unboxToLong((Object)caughtUpTimeMs)));
        return new Tuple2((Object)ClusterLinkFetcherThread$AdjustmentType$.MODULE$.Decrease(), (Object)new Some((Object)((IterableOnceOps)minHeap.map((Function1 & Serializable)x$3 -> x$3.partition())).toSet()));
    }

    public void clearPartitionLinkFailure(TopicPartition tp, long fetchOffset) {
        this.fetcherManager.clearPartitionLinkFailure(tp, (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("New data fetched from ").append(tp).append(" offset ").append(fetchOffset).toString(), true);
    }

    public void updateDynamicFetchSize() {
        FetchResponseSize dynamicSize = (FetchResponseSize)this.dynamicFetchSize.apply();
        ((ClusterLinkLeaderEndPoint)super.leader()).fetchSize_$eq(Predef$.MODULE$.int2Integer(dynamicSize.perPartitionSize()));
        ((ClusterLinkLeaderEndPoint)super.leader()).updateFetchResponseSize(dynamicSize.responseSize());
    }

    @Override
    public void updateFetcherLagStats(TopicPartition tp, long lag) {
        super.updateFetcherLagStats(tp, lag);
        long topicLag = this.fetcherManager.getTopicLag(tp.topic());
        if (topicLag >= 0L) {
            Sensor sensor = this.getOrCreateTopicSensor(tp.topic(), "mirror-topic-lag", (MeasurableStat)new Value(), "Mirror topic lag");
            long nowMs = this.time.milliseconds();
            sensor.record((double)topicLag, nowMs);
            if (topicLag == 0L) {
                this.partitionLastCaughtUpTimeMs().put(tp, BoxesRunTime.boxToLong((long)nowMs));
                return;
            }
            return;
        }
    }

    @Override
    public void updateFetcherByteRate(TopicPartition tp, long bytes) {
        super.updateFetcherByteRate(tp, bytes);
        this.getOrCreateTopicSensor(tp.topic(), "mirror-topic-byte-total", (MeasurableStat)new CumulativeSum(), "Mirror topic throughput").record((double)bytes);
    }

    private Sensor getOrCreateTopicSensor(String topic, String name, MeasurableStat stat, String description) {
        String unprefixedTopic = (String)this.tenant.map((Function1 & Serializable)t -> topic.substring(t.length() + 1)).getOrElse((Function0 & Serializable)() -> topic);
        String sensorName = new StringBuilder(3).append(name).append("-").append(this.tenant).append("-").append(this.unprefixedLinkName()).append("-").append(unprefixedTopic).toString();
        Sensor sensor = this.metrics().sensor(sensorName, this.metrics().config(), TimeUnit.MINUTES.toSeconds(5L), new Sensor[0]);
        scala.collection.immutable.Map tags = ((IterableOnceOps)new .colon.colon((Object)this.tenant.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), t)), (List)new .colon.colon((Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"link-name"), (Object)this.unprefixedLinkName())), (List)new .colon.colon((Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)unprefixedTopic)), (List)Nil$.MODULE$))).flatten(Predef$.MODULE$.$conforms())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        MetricName metricName = new MetricName(name, "cluster-link-metrics", description, CollectionConverters$.MODULE$.MapHasAsJava((Map)tags).asJava());
        if (sensor == null) {
            throw null;
        }
        sensor.add(metricName, stat, null);
        return sensor;
    }

    public void updatePartitionLastCaughtUpTime(TopicPartition tp, long caughtUpTimeMs) {
        this.partitionLastCaughtUpTimeMs().put(tp, BoxesRunTime.boxToLong((long)caughtUpTimeMs));
    }

    public static final /* synthetic */ void $anonfun$updateFetchOffsetAndMaybeMarkTruncationComplete$1(ClusterLinkFetcherThread $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            if (((OffsetTruncationState)x0$1._2()).truncationCompleted()) {
                $this.fetcherManager.partition(tp).foreach((Function1 & Serializable)x$1 -> {
                    x$1.linkedLeaderOffsetsPending(false);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$removePartitions$1(ClusterLinkFetcherThread $this, Tuple2 p) {
        return BoxesRunTime.unboxToLong((Object)$this.partitionLastCaughtUpTimeMs().remove(p._1()));
    }

    public static final /* synthetic */ void $anonfun$adjustLaggingPartitionsRequired$1(ClusterLinkFetcherThread $this, long nowMs$1, IntRef numLaggingPartitions$1, TopicPartition x$2, long caughtUpTimeMs) {
        if (nowMs$1 - caughtUpTimeMs > (long)Predef$.MODULE$.Integer2int($this.linkFetcherLaggingPartitionMs())) {
            ++numLaggingPartitions$1.elem;
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$adjustLaggingPartitionsRequired$2(ClusterLinkFetcherThread $this, long nowMs$1, PriorityQueue minHeap$1, int numPartitionsToRemove$1, TopicPartition topicPartition, long caughtUpTimeMs) {
        if (nowMs$1 - caughtUpTimeMs > (long)Predef$.MODULE$.Integer2int($this.linkFetcherLaggingPartitionMs())) {
            FetcherLagMetrics lagStats = $this.fetcherLagStats().stats().get(topicPartition);
            if (lagStats != null && lagStats.lag() > 0L) {
                if (minHeap$1.size() >= numPartitionsToRemove$1) {
                    if (((PartitionAndLag)minHeap$1.head()).lag() < lagStats.lag()) {
                        minHeap$1.dequeue();
                        minHeap$1.$plus$eq((Object)new PartitionAndLag(topicPartition, lagStats.lag()));
                        return;
                    }
                    return;
                }
                minHeap$1.$plus$eq((Object)new PartitionAndLag(topicPartition, lagStats.lag()));
                return;
            }
            return;
        }
    }

    public ClusterLinkFetcherThread(String name, int fetcherId, ClusterLinkLeaderEndPoint leader, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata, ClusterLinkFetcherManager fetcherManager, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics, Time time, Function0<FetchResponseSize> dynamicFetchSize, ClusterLinkNetworkClient clusterLinkClient, Option<LogContext> logContextOpt, Option<String> tenant) {
        this.clusterLinkMetadata = clusterLinkMetadata;
        this.fetcherManager = fetcherManager;
        this.replicaMgr = replicaMgr;
        this.clusterLinkMetrics = clusterLinkMetrics;
        this.time = time;
        this.dynamicFetchSize = dynamicFetchSize;
        this.clusterLinkClient = clusterLinkClient;
        this.tenant = tenant;
        super(name, fetcherId, leader, brokerConfig, failedPartitions, replicaMgr, quota, logContextOpt, ClusterLinkFactory$.MODULE$.linkMetricTags(clusterLinkMetadata.linkName()), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)clusterLinkConfig.replicaFetchBackoffMs().longValue())), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)clusterLinkConfig.replicaFetchBackoffMaxMs().longValue())), (Function0<MetadataVersion>)new Serializable(brokerConfig){
            private static final long serialVersionUID = 0L;
            private final KafkaConfig brokerConfig$1;

            public final MetadataVersion apply() {
                return this.brokerConfig$1.interBrokerProtocolVersion();
            }
            {
                this.brokerConfig$1 = brokerConfig$1;
            }
        });
        this.linkFetcherFlowControl = clusterLinkConfig.linkFetcherFlowControl();
        this.linkFetcherMaxLaggingPartitions = clusterLinkConfig.linkFetcherMaxLaggingPartitions();
        this.linkFetcherLaggingPartitionMs = clusterLinkConfig.linkFetcherLaggingPartitionMs();
        this.unprefixedLinkName = (String)tenant.map((Function1 & Serializable)t -> $this.clusterLinkMetadata.linkName().substring(t.length() + 1)).getOrElse((Function0 & Serializable)() -> $this.clusterLinkMetadata.linkName());
        this.metrics = clusterLinkMetrics.metrics();
        this.partitionLastCaughtUpTimeMs = new ConcurrentHashMap();
        this.isOffsetForLeaderEpochSupported = true;
    }

    public static class PartitionAndLag
    implements Product,
    Serializable {
        private final TopicPartition partition;
        private final long lag;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public TopicPartition partition() {
            return this.partition;
        }

        public long lag() {
            return this.lag;
        }

        public PartitionAndLag copy(TopicPartition partition, long lag) {
            return new PartitionAndLag(partition, lag);
        }

        public TopicPartition copy$default$1() {
            return this.partition();
        }

        public long copy$default$2() {
            return this.lag();
        }

        public String productPrefix() {
            return "PartitionAndLag";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.partition();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.lag());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PartitionAndLag;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "partition";
                }
                case 1: {
                    return "lag";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.partition())), (int)Statics.longHash((long)this.lag())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof PartitionAndLag)) break block3;
                    PartitionAndLag partitionAndLag = (PartitionAndLag)x$1;
                    if (this.lag() != partitionAndLag.lag()) break block3;
                    TopicPartition topicPartition = this.partition();
                    TopicPartition topicPartition2 = partitionAndLag.partition();
                    if ((topicPartition != null ? !topicPartition.equals(topicPartition2) : topicPartition2 != null) || !partitionAndLag.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public PartitionAndLag(TopicPartition partition, long lag) {
            this.partition = partition;
            this.lag = lag;
            Product.$init$((Product)this);
        }
    }
}

