/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkControllerRequestCompletionHandler;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.utils.CoreUtils$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.AlterMirrorTopicsRequestData;
import org.apache.kafka.common.message.CreateClusterLinksRequestData;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterMirrorTopicsRequest;
import org.apache.kafka.common.requests.AlterMirrorTopicsResponse;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.requests.CreateClusterLinksResponse;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.ClusterLink;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t=d\u0001B\u0013'\u00015B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!I1\b\u0001B\u0001B\u0003%AH\u0011\u0005\t\u0007\u0002\u0011)\u0019!C\u0001\t\"A\u0001\n\u0001B\u0001B\u0003%Q\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011!i\u0006A!A!\u0002\u0013q\u0006\"B3\u0001\t\u00031\u0007b\u00028\u0001\u0005\u0004%Ia\u001c\u0005\u0007g\u0002\u0001\u000b\u0011\u00029\t\u000bQ\u0004A\u0011I;\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010!9\u00111\u0005\u0001\u0005B\u0005\u0015\u0002bBA\"\u0001\u0011\u0005\u0013Q\t\u0005\b\u0003\u0017\u0002A\u0011IA'\u0011\u001d\t\u0019\u0006\u0001C!\u0003+Bq!a\u0016\u0001\t\u0003\nI\u0006C\u0004\u0002^\u0001!\t%a\u0018\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~!9\u00111\u0010\u0001\u0005\n\u0005\u0005\u0005bBA/\u0001\u0011%\u0011\u0011\u0013\u0005\b\u0003+\u0003A\u0011IAL\u0011\u001d\t)\n\u0001C\u0001\u0003SCq!!,\u0001\t\u0003\ny\u000bC\u0004\u0002:\u0002!\t%a/\t\u000f\u0005\u0015\u0007\u0001\"\u0011\u0002H\"9\u00111\u001a\u0001\u0005B\u00055\u0007bBAk\u0001\u0011\u0005\u0013q\u001b\u0005\b\u0003K\u0004A\u0011IAt\u0011\u001d\ty\u000f\u0001C!\u0003cDq!!>\u0001\t\u0003\n9\u0010C\u0004\u0003\u0002\u0001!\tEa\u0001\t\u000f\t\u001d\u0001\u0001\"\u0003\u0003\n!9!1\u0005\u0001\u0005B\t\u0015\u0002b\u0002B(\u0001\u0011E#\u0011\u000b\u0005\u000e\u0005K\u0002\u0001\u0013aA\u0001\u0002\u0013%!q\r\"\u0003U\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1NC:\fw-\u001a:XSRD7JU1giN+\b\u000f]8si*\u0011q\u0005K\u0001\u0005Y&t7N\u0003\u0002*U\u000511/\u001a:wKJT\u0011aK\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0006\u0005\u00020a5\ta%\u0003\u00022M\tQ2\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0006a!M]8lKJ\u001cuN\u001c4jOB\u0011A'N\u0007\u0002Q%\u0011a\u0007\u000b\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0005tG\",G-\u001e7feB\u0011q&O\u0005\u0003u\u0019\u0012Ac\u00117vgR,'\u000fT5oWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018!D7fi\u0006$\u0017\r^1DC\u000eDW\r\u0005\u0002>\u00016\taH\u0003\u0002@Q\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0002B}\t\u00112JU1gi6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0013\tY\u0004'\u0001\rd_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ,\u0012!\u0012\t\u0003i\u0019K!a\u0012\u0015\u0003A\t\u0013xn[3s)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM]\u0001\u001aG>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\b%A\tm_\u000e\fG.\u00113nS:4\u0015m\u0019;pef\u00042a\u0013(Q\u001b\u0005a%\"A'\u0002\u000bM\u001c\u0017\r\\1\n\u0005=c%!\u0003$v]\u000e$\u0018n\u001c81!\t\t6,D\u0001S\u0015\t\u0019F+A\u0003bI6LgN\u0003\u0002V-\u000691\r\\5f]R\u001c(BA\u0016X\u0015\tA\u0016,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0006\u0019qN]4\n\u0005q\u0013&!B!e[&t\u0017AC:feZ,'/\u00138g_B\u0011qlY\u0007\u0002A*\u0011\u0011MY\u0001\u000bCV$\bn\u001c:ju\u0016\u0014(BA\u0015W\u0013\t!\u0007M\u0001\u000bBkRDwN]5{KJ\u001cVM\u001d<fe&sgm\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f\u001dD\u0017N[6m[B\u0011q\u0006\u0001\u0005\u0006e!\u0001\ra\r\u0005\u0006o!\u0001\r\u0001\u000f\u0005\u0006w!\u0001\r\u0001\u0010\u0005\u0006\u0007\"\u0001\r!\u0012\u0005\u0006\u0013\"\u0001\rA\u0013\u0005\u0006;\"\u0001\rAX\u0001\u0011e\u0016\fX/Z:u)&lWm\\;u\u001bN,\u0012\u0001\u001d\t\u0003\u0017FL!A\u001d'\u0003\u0007%sG/A\tsKF,Xm\u001d;US6,w.\u001e;Ng\u0002\n1#[:BGRLg/Z'jeJ|'\u000fV8qS\u000e$\"A^=\u0011\u0005-;\u0018B\u0001=M\u0005\u001d\u0011un\u001c7fC:DQA_\u0006A\u0002m\fQ\u0001^8qS\u000e\u00042\u0001`A\u0004\u001d\ri\u00181\u0001\t\u0003}2k\u0011a \u0006\u0004\u0003\u0003a\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u00061\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0005\u0003\u0017\u0011aa\u0015;sS:<'bAA\u0003\u0019\u0006YQ.\u001b:s_J$v\u000e]5d)\u0011\t\t\"!\t\u0011\u000b-\u000b\u0019\"a\u0006\n\u0007\u0005UAJ\u0001\u0004PaRLwN\u001c\t\u0005\u00033\ti\"\u0004\u0002\u0002\u001c)\u0011qHV\u0005\u0005\u0003?\tYBA\u0006NSJ\u0014xN\u001d+pa&\u001c\u0007\"\u0002>\r\u0001\u0004Y\u0018!F2mkN$XM\u001d'j].$v\u000e]5d'R\fG/\u001a\u000b\u0005\u0003O\tI\u0004E\u0004\u0002*\u0005=20a\r\u000e\u0005\u0005-\"bAA\u0017\u0019\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005E\u00121\u0006\u0002\u0004\u001b\u0006\u0004\bcA\u0018\u00026%\u0019\u0011q\u0007\u0014\u0003+\rcWo\u001d;fe2Kgn\u001b+pa&\u001c7\u000b^1uK\"9\u00111H\u0007A\u0002\u0005u\u0012A\u0002;pa&\u001c7\u000f\u0005\u0003}\u0003\u007fY\u0018\u0002BA!\u0003\u0017\u00111aU3u\u0003Mi\u0017N\u001d:peR{\u0007/[2t\r>\u0014H*\u001b8l)\u0011\t9#a\u0012\t\r\u0005%c\u00021\u0001|\u0003!a\u0017N\\6OC6,\u0017aD1mY6K'O]8s)>\u0004\u0018nY:\u0015\t\u0005\u001d\u0012q\n\u0005\u0007\u0003#z\u0001\u0019\u0001<\u0002\u001d%t7\r\\;eKN#x\u000e\u001d9fI\u0006)r-\u001a;BY2$v\u000e]5dg&s7\t\\;ti\u0016\u0014HCAA\u001f\u0003iI7\u000fV8qS\u000e\fV/Z;fIV\u0003hi\u001c:EK2,G/[8o)\r1\u00181\f\u0005\u0006uF\u0001\ra_\u0001\u0018K:\u001cXO]3DYV\u001cH/\u001a:MS:\\W\t_5tiN$B!!\u0019\u0002hA\u00191*a\u0019\n\u0007\u0005\u0015DJ\u0001\u0003V]&$\bbBA5%\u0001\u0007\u00111N\u0001\u0007Y&t7.\u00133\u0011\t\u00055\u0014qO\u0007\u0003\u0003_RA!!\u001d\u0002t\u0005!Q\u000f^5m\u0015\t\t)(\u0001\u0003kCZ\f\u0017\u0002BA=\u0003_\u0012A!V+J\t\u0006\t2\r\\;ti\u0016\u0014H*\u001b8l\u000bbL7\u000f^:\u0015\u0007Y\fy\bC\u0004\u0002jM\u0001\r!a\u001b\u0015\u0007Y\f\u0019\tC\u0004\u0002jQ\u0001\r!!\"\u0011\t\u0005\u001d\u0015QR\u0007\u0003\u0003\u0013S1!a#W\u0003\u0019\u0019w.\\7p]&!\u0011qRAE\u0005\u0011)V/\u001b3\u0015\t\u0005\u0005\u00141\u0013\u0005\b\u0003S*\u0002\u0019AAC\u0003I9W\r^\"mkN$XM\u001d'j].$\u0015\r^1\u0015\t\u0005e\u0015q\u0015\t\u0006\u0017\u0006M\u00111\u0014\t\u0005\u0003;\u000b\u0019+\u0004\u0002\u0002 *\u0019\u0011\u0011\u0015\u0016\u0002\u0005i\\\u0017\u0002BAS\u0003?\u0013qb\u00117vgR,'\u000fT5oW\u0012\u000bG/\u0019\u0005\b\u0003S2\u0002\u0019AA6)\u0011\tI*a+\t\r\u0005%s\u00031\u0001|\u0003e9W\r^\"mkN$XM\u001d'j].\u001cuN\u001c4jOB\u0013x\u000e]:\u0015\t\u0005E\u0016q\u0017\t\u0005\u0003[\n\u0019,\u0003\u0003\u00026\u0006=$A\u0003)s_B,'\u000f^5fg\"9\u0011\u0011\u000e\rA\u0002\u0005-\u0014\u0001F4fi\u000ecWo\u001d;fe2Kgn[\"p]\u001aLw\r\u0006\u0003\u0002>\u0006\r\u0007cA\u0018\u0002@&\u0019\u0011\u0011\u0019\u0014\u0003#\rcWo\u001d;fe2Kgn[\"p]\u001aLw\rC\u0004\u0002je\u0001\r!a\u001b\u0002\u001d\u001d,G\u000fV8qS\u000e\u001cuN\u001c4jOR!\u0011\u0011WAe\u0011\u0015Q(\u00041\u0001|\u0003m\tG\u000e^3s\u00072,8\u000f^3s\u0019&t7nQ8oM&<'LT8eKR1\u0011\u0011MAh\u0003#Dq!!\u001b\u001c\u0001\u0004\tY\u0007C\u0004\u0002Tn\u0001\r!!-\u0002\u000bA\u0014x\u000e]:\u0002A5\f\u0017PY3SK\u0016t7M]=qi\u000ecWo\u001d;fe2Kgn[\"p]\u001aLwm\u001d\u000b\u0005\u0003C\nI\u000eC\u0004\u0002\\r\u0001\r!!8\u0002#\r|gNZ5h)J\fgn\u001d4pe6,'\u000fE\u0004L\u0003?\f\t,a9\n\u0007\u0005\u0005HJA\u0005Gk:\u001cG/[8ocA)1*a\u0005\u00022\u000612M]3bi\u0016\u001cE.^:uKJd\u0015N\\6[\u001d>$W\r\u0006\u0004\u0002b\u0005%\u0018Q\u001e\u0005\b\u0003Wl\u0002\u0019AAN\u0003=\u0019G.^:uKJd\u0015N\\6ECR\f\u0007bBAj;\u0001\u0007\u0011\u0011W\u0001\u0014g\u0016$8\t\\;ti\u0016\u0014H*\u001b8l5:{G-\u001a\u000b\u0005\u0003C\n\u0019\u0010C\u0004\u0002lz\u0001\r!a'\u0002'M,G/T5se>\u0014Hk\u001c9jGN#\u0018\r^3\u0015\r\u0005\u0005\u0014\u0011`A~\u0011\u0015Qx\u00041\u0001|\u0011\u001d\tip\ba\u0001\u0003\u007f\f\u0001#\\5se>\u0014Hk\u001c9jGN#\u0018\r^3\u0011\u000b-\u000b\u0019\"a\r\u0002-\u0011,G.\u001a;f\u00072,8\u000f^3s\u0019&t7N\u0017(pI\u0016$B!!\u0019\u0003\u0006!9\u0011\u0011\u000e\u0011A\u0002\u0005-\u0014\u0001E1mi\u0016\u0014X*\u001b:s_J$v\u000e]5d)\u0019\u0011YA!\b\u0003 A1\u0011q\u0011B\u0007\u0005#IAAa\u0004\u0002\n\nY1*\u00194lC\u001a+H/\u001e:f!\u0011\u0011\u0019B!\u0007\u000e\u0005\tU!\u0002\u0002B\f\u0003g\nA\u0001\\1oO&!!1\u0004B\u000b\u0005\u00111v.\u001b3\t\u000bi\f\u0003\u0019A>\t\u000f\t\u0005\u0012\u00051\u0001\u00024\u0005)1\u000f^1uK\u0006\u00112M]3bi\u0016\u001cE.^:uKJd\u0015N\\6t)\u0011\u00119Ca\u0010\u0011\r\t%\"q\u0006B\u001a\u001b\t\u0011YC\u0003\u0003\u0003.\u0005=\u0014AC2p]\u000e,(O]3oi&!!\u0011\u0007B\u0016\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\u0005\u0005k\u0011Y$\u0004\u0002\u00038)!!\u0011HAE\u0003!\u0011X-];fgR\u001c\u0018\u0002\u0002B\u001f\u0005o\u0011!d\u0011:fCR,7\t\\;ti\u0016\u0014H*\u001b8lgJ+7\u000f]8og\u0016DqA!\u0011#\u0001\u0004\u0011\u0019%A\u000fde\u0016\fG/Z\"mkN$XM\u001d'j].\u001c(+Z9vKN$H)\u0019;b!\u0011\u0011)Ea\u0013\u000e\u0005\t\u001d#\u0002\u0002B%\u0003\u0013\u000bq!\\3tg\u0006<W-\u0003\u0003\u0003N\t\u001d#!H\"sK\u0006$Xm\u00117vgR,'\u000fT5oWN\u0014V-];fgR$\u0015\r^1\u0002/\u001d,G/\u00117m\u0019&t7n\u001d$s_6lU\r^1eCR\fGC\u0001B*!\u0019\u0011)Fa\u0018\u0002\u001c:!!q\u000bB.\u001d\rq(\u0011L\u0005\u0002\u001b&\u0019!Q\f'\u0002\u000fA\f7m[1hK&!!\u0011\rB2\u0005\r\u0019V-\u001d\u0006\u0004\u0005;b\u0015aE:va\u0016\u0014H%\\3uC\u0012\fG/Y\"bG\",WC\u0001B5!\r!$1N\u0005\u0004\u0005[B#!D'fi\u0006$\u0017\r^1DC\u000eDW\r")
public class ClusterLinkMetadataManagerWithKRaftSupport
extends ClusterLinkMetadataManager {
    private final BrokerToControllerChannelManager controllerChannelManager;
    private final Function0<Admin> localAdminFactory;
    private final int requestTimeoutMs;

    private /* synthetic */ MetadataCache super$metadataCache() {
        return super.metadataCache();
    }

    public BrokerToControllerChannelManager controllerChannelManager() {
        return this.controllerChannelManager;
    }

    private int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    @Override
    public boolean isActiveMirrorTopic(String topic) {
        return this.mirrorTopic(topic).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$isActiveMirrorTopic$1(x$1)));
    }

    @Override
    public Option<MirrorTopic> mirrorTopic(String topic) {
        return Option$.MODULE$.apply((Object)((KRaftMetadataCache)super.metadataCache()).currentImage().topics().getTopic(topic)).flatMap((Function1 & Serializable)x$2 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$2.mirrorTopic())));
    }

    @Override
    public Map<String, ClusterLinkTopicState> clusterLinkTopicState(scala.collection.immutable.Set<String> topics) {
        MetadataImage image = ((KRaftMetadataCache)super.metadataCache()).currentImage();
        return ((IterableOnceOps)((IterableOps)((IterableOps)topics.map((Function1 & Serializable)topic -> Option$.MODULE$.apply((Object)image.topics().getTopic(topic)).flatMap((Function1 & Serializable)x$3 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$3.mirrorTopic()))))).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDefined()))).map((Function1 & Serializable)stateOpt -> {
            MirrorTopic state = (MirrorTopic)stateOpt.get();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)state.topicName()), (Object)ClusterLinkTopicState$.MODULE$.apply(state, state.linkName()));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicsForLink(String linkName) {
        MetadataImage image2 = ((KRaftMetadataCache)super.metadataCache()).currentImage();
        Option mirrorTopics = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(image2.clusterLinks().clusterLinkId(linkName))).map((Function1 & Serializable)x$5 -> image2.topics().topicsByLinkId(x$5));
        if (mirrorTopics.isEmpty()) {
            return (Map)scala.collection.Map$.MODULE$.empty();
        }
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((List)mirrorTopics.get()).asScala().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$mirrorTopicsForLink$2(x$6)))).map((Function1 & Serializable)image -> {
            ClusterLinkTopicState state = ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)image.mirrorTopic().get(), linkName);
            return new Tuple2((Object)image.name(), (Object)state);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public Map<String, ClusterLinkTopicState> allMirrorTopics(boolean includeStopped) {
        MetadataImage image = ((KRaftMetadataCache)super.metadataCache()).currentImage();
        Set clusterLinkNames = CollectionConverters$.MODULE$.SetHasAsScala(image.clusterLinks().linksByName().keySet()).asScala();
        scala.collection.mutable.Map allMirrorTopics = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        clusterLinkNames.foreach((Function1 & Serializable)linkName -> {
            Map mirrorTopics = !includeStopped ? (Map)this.mirrorTopicsForLink((String)linkName).filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$allMirrorTopics$2(entry))) : this.mirrorTopicsForLink((String)linkName);
            return (scala.collection.mutable.Map)allMirrorTopics.$plus$plus$eq((IterableOnce)mirrorTopics);
        });
        return allMirrorTopics.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public scala.collection.immutable.Set<String> getAllTopicsInCluster() {
        return CollectionConverters$.MODULE$.SetHasAsScala(((KRaftMetadataCache)super.metadataCache()).currentImage().topics().topicsByName().keySet()).asScala().toSet();
    }

    @Override
    public boolean isTopicQueuedUpForDeletion(String topic) {
        throw new IllegalStateException("Cannot check if topic is queued for deletion in KRaft mode.");
    }

    @Override
    public void ensureClusterLinkExists(UUID linkId) {
        this.ensureClusterLinkExists(CoreUtils$.MODULE$.toKafkaUUID(linkId));
    }

    @Override
    public boolean clusterLinkExists(UUID linkId) {
        return this.clusterLinkExists(CoreUtils$.MODULE$.toKafkaUUID(linkId));
    }

    private boolean clusterLinkExists(Uuid linkId) {
        return ((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById().containsKey(linkId);
    }

    private void ensureClusterLinkExists(Uuid linkId) {
        if (!this.clusterLinkExists(linkId)) {
            throw new ClusterLinkNotFoundException(new StringBuilder(39).append("Cluster link with ID '").append(linkId).append("' does not exist.").toString());
        }
    }

    @Override
    public Option<ClusterLinkData> getClusterLinkData(UUID linkId) {
        Uuid kafkaLinkId = CoreUtils$.MODULE$.toKafkaUUID(linkId);
        java.util.Map clusterLinks = ((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById();
        if (clusterLinks.containsKey(kafkaLinkId)) {
            ClusterLink clusterLink = (ClusterLink)clusterLinks.get(kafkaLinkId);
            return new Some((Object)new ClusterLinkData(clusterLink.linkName(), linkId, (Option<String>)new Some((Object)clusterLink.sourceClusterId()), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLink.tenantPrefix())), false));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<ClusterLinkData> getClusterLinkData(String linkName) {
        java.util.Map clusterLinks = ((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksByName();
        if (clusterLinks.containsKey(linkName)) {
            ClusterLink clusterLink = (ClusterLink)clusterLinks.get(linkName);
            return new Some((Object)new ClusterLinkData(clusterLink.linkName(), Utils.toJavaUuid((Uuid)clusterLink.linkId()), (Option<String>)new Some((Object)clusterLink.sourceClusterId()), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLink.tenantPrefix())), false));
        }
        return None$.MODULE$;
    }

    @Override
    public Properties getClusterLinkConfigProps(UUID linkId) {
        Uuid kafkaLinkId = CoreUtils$.MODULE$.toKafkaUUID(linkId);
        this.ensureClusterLinkExists(kafkaLinkId);
        return ((KRaftMetadataCache)super.metadataCache()).config(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, kafkaLinkId.toString()));
    }

    @Override
    public ClusterLinkConfig getClusterLinkConfig(UUID linkId) {
        return ClusterLinkConfig$.MODULE$.create(this.getClusterLinkConfigProps(linkId), false);
    }

    @Override
    public Properties getTopicConfig(String topic) {
        return ((KRaftMetadataCache)super.metadataCache()).config(new ConfigResource(ConfigResource.Type.TOPIC, topic));
    }

    @Override
    public void alterClusterLinkConfigZNode(UUID linkId, Properties props) {
        throw new IllegalStateException("Altering link configs in the ZNode is not supported in KRaft mode.");
    }

    @Override
    public void maybeReencryptClusterLinkConfigs(Function1<Properties, Option<Properties>> configTransformer) {
        scala.collection.mutable.Map clusterLinks = CollectionConverters$.MODULE$.MapHasAsScala(((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById()).asScala();
        HashMap alterConfigRequestMap = new HashMap(clusterLinks.size());
        clusterLinks.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Uuid linkId = (Uuid)x0$1._1();
                ClusterLink clusterLink = (ClusterLink)x0$1._2();
                ConfigResource configResourceLinkId = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString());
                Option newEncodedProps = (Option)configTransformer.apply((Object)((KRaftMetadataCache)this.super$metadataCache()).config(configResourceLinkId));
                if (newEncodedProps instanceof Some) {
                    Properties props = (Properties)((Some)newEncodedProps).value();
                    HashSet newConfigs = new HashSet();
                    CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().foreach((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)newConfigs.add(new AlterConfigOp(new ConfigEntry((String)entry._1(), (String)entry._2()), AlterConfigOp.OpType.SET))));
                    ConfigResource configResourceLinkName = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, clusterLink.linkName());
                    return alterConfigRequestMap.put(configResourceLinkName, newConfigs);
                }
                if (None$.MODULE$.equals(newEncodedProps)) {
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)newEncodedProps);
            }
            throw new MatchError(null);
        });
        if (!alterConfigRequestMap.isEmpty()) {
            if (this.destAdmin() == null) {
                this.destAdmin_$eq((Admin)this.localAdminFactory.apply());
            }
            this.destAdmin().incrementalAlterConfigs(alterConfigRequestMap).all().get();
            return;
        }
    }

    @Override
    public void createClusterLinkZNode(ClusterLinkData clusterLinkData, Properties props) {
        throw new IllegalStateException("Creating a cluster link ZNode is not supported in KRaft mode.");
    }

    @Override
    public void setClusterLinkZNode(ClusterLinkData clusterLinkData) {
        throw new IllegalStateException("Setting a cluster link ZNode is not supported in KRaft mode.");
    }

    @Override
    public void setMirrorTopicState(String topic, Option<ClusterLinkTopicState> mirrorTopicState) {
        if (mirrorTopicState instanceof Some) {
            ClusterLinkTopicState state = (ClusterLinkTopicState)((Some)mirrorTopicState).value();
            try {
                this.alterMirrorTopic(topic, state).get();
                return;
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        if (None$.MODULE$.equals(mirrorTopicState)) {
            throw new UnsupportedVersionException("Clear mirror topic state is not supported in KRaft");
        }
        throw new MatchError(mirrorTopicState);
    }

    @Override
    public void deleteClusterLinkZNode(UUID linkId) {
        throw new IllegalStateException("Deleting a cluster link ZNode is not supported in KRaft mode.");
    }

    private KafkaFuture<Void> alterMirrorTopic(String topic, ClusterLinkTopicState state) {
        AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic = new AlterMirrorTopicsRequestData.AlterMirrorTopic().setTopic(topic);
        if (state instanceof ClusterLinkTopicState.Mirror) {
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.MIRROR.stateName());
        } else if (state instanceof ClusterLinkTopicState.PausedMirror) {
            ClusterLinkTopicState.PausedMirror pausedMirror = (ClusterLinkTopicState.PausedMirror)state;
            boolean linkLevel = pausedMirror.linkLevel();
            boolean topicLevel = pausedMirror.topicLevel();
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PAUSED.stateName()).setLinkLevelPause(linkLevel).setTopicLevelPause(topicLevel);
        } else if (state instanceof ClusterLinkTopicState.FailedMirror) {
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.FAILED.stateName());
        } else if (state instanceof ClusterLinkTopicState.PendingStoppedMirror) {
            boolean synchronize = ((ClusterLinkTopicState.PendingStoppedMirror)state).synchronize();
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PENDING_STOPPED.stateName()).setPromoted(synchronize);
        } else if (state instanceof ClusterLinkTopicState.StoppedMirror) {
            scala.collection.immutable.Seq<Object> logEndOffsets = ((ClusterLinkTopicState.StoppedMirror)state).logEndOffsets();
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.STOPPED.stateName()).setStoppedLogEndOffsets(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)logEndOffsets.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToLong((Object)x$1))).asJava());
        } else {
            throw new MatchError((Object)state);
        }
        KafkaFutureImpl result = new KafkaFutureImpl();
        AlterMirrorTopicsRequest.Builder builder = new AlterMirrorTopicsRequest.Builder(alterMirrorTopic, false, this.requestTimeoutMs());
        ClusterLinkControllerRequestCompletionHandler requestHandler = new ClusterLinkControllerRequestCompletionHandler(null, topic, result){
            private final String topic$1;
            private final KafkaFutureImpl result$1;

            public void handleResponse(AbstractResponse response) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent("Received response for alterMirrorTopicRequest"));
                }
                ((AlterMirrorTopicsResponse)response).complete(Collections.singletonMap(this.topic$1, this.result$1));
            }

            public void onFailure(Throwable ex) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent("alterMirrorTopic request failed with exception"), ex);
                }
                this.result$1.completeExceptionally(ex);
            }

            public static final /* synthetic */ String $anonfun$handleResponse$1() {
                return "Received response for alterMirrorTopicRequest";
            }

            public static final /* synthetic */ String $anonfun$onFailure$1() {
                return "alterMirrorTopic request failed with exception";
            }

            public static final /* synthetic */ Throwable $anonfun$onFailure$2(Throwable ex$1) {
                return ex$1;
            }
            {
                this.topic$1 = topic$1;
                this.result$1 = result$1;
            }
        };
        this.controllerChannelManager().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)builder, requestHandler);
        return result;
    }

    @Override
    public CompletableFuture<CreateClusterLinksResponse> createClusterLinks(CreateClusterLinksRequestData createClusterLinksRequestData) {
        CompletableFuture<CreateClusterLinksResponse> result = new CompletableFuture<CreateClusterLinksResponse>();
        CreateClusterLinksRequest.Builder requestBuilder = new CreateClusterLinksRequest.Builder(createClusterLinksRequestData);
        ClusterLinkControllerRequestCompletionHandler requestHandler = new ClusterLinkControllerRequestCompletionHandler(null, result){
            private final CompletableFuture result$2;

            public void handleResponse(AbstractResponse response) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent("Received response for createClusterLinksRequest"));
                }
                this.result$2.complete((CreateClusterLinksResponse)response);
            }

            public void onFailure(Throwable ex) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent("createClusterLinksRequest failed with exception"), ex);
                }
                this.result$2.completeExceptionally(ex);
            }

            public static final /* synthetic */ String $anonfun$handleResponse$2() {
                return "Received response for createClusterLinksRequest";
            }

            public static final /* synthetic */ String $anonfun$onFailure$3() {
                return "createClusterLinksRequest failed with exception";
            }

            public static final /* synthetic */ Throwable $anonfun$onFailure$4(Throwable ex$2) {
                return ex$2;
            }
            {
                this.result$2 = result$2;
            }
        };
        this.controllerChannelManager().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)requestBuilder, requestHandler);
        return result;
    }

    @Override
    public scala.collection.immutable.Seq<ClusterLinkData> getAllLinksFromMetadata() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById()).asScala().values().map((Function1 & Serializable)clusterLink -> new ClusterLinkData(clusterLink.linkName(), Utils.toJavaUuid((Uuid)clusterLink.linkId()), (Option<String>)new Some((Object)clusterLink.sourceClusterId()), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLink.tenantPrefix())), false))).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$isActiveMirrorTopic$1(MirrorTopic x$1) {
        MirrorTopic.State state = x$1.mirrorState();
        MirrorTopic.State state2 = MirrorTopic.State.MIRROR;
        return !(state != null ? !state.equals(state2) : state2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$mirrorTopicsForLink$2(TopicImage x$6) {
        return x$6.mirrorTopic().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$allMirrorTopics$2(Tuple2 entry) {
        return !(entry._2() instanceof ClusterLinkTopicState.StoppedMirror);
    }

    public ClusterLinkMetadataManagerWithKRaftSupport(KafkaConfig brokerConfig, ClusterLinkScheduler scheduler, KRaftMetadataCache metadataCache, BrokerToControllerChannelManager controllerChannelManager, Function0<Admin> localAdminFactory, AuthorizerServerInfo serverInfo) {
        this.controllerChannelManager = controllerChannelManager;
        this.localAdminFactory = localAdminFactory;
        super(brokerConfig, scheduler, metadataCache, localAdminFactory);
        this.requestTimeoutMs = Predef$.MODULE$.Integer2int(new AdminClientConfig(ConfluentConfigs.interBrokerClientConfigs((AbstractConfig)brokerConfig, (Endpoint)serverInfo.interBrokerEndpoint())).getInt("request.timeout.ms"));
    }
}

