/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.KafkaFuture;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Ed\u0001\u0002\f\u0018\u0001yA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tm\u0001\u0011\t\u0011)A\u0005o!AA\t\u0001B\u0001B\u0003%Q\tC\u0005M\u0001\t\u0005\t\u0015!\u0003N!\"A\u0011\u000b\u0001B\u0001B\u0003%!\u000b\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011!!\u0007A!A!\u0002\u0013)\u0007\"\u00035\u0001\u0005\u0003\u0005\u000b\u0011B3j\u0011!Y\u0007A!A!\u0002\u0013)\u0007\"\u00027\u0001\t\u0003i\u0007\"\u0002=\u0001\t#J\b\"\u0002>\u0001\t\u0013Y\b\"\u0002@\u0001\t\u0013y\bbBA\r\u0001\u0011%\u00111\u0004\u0005\b\u0003\u0003\u0002A\u0011BA\"\u000f%\t9eFA\u0001\u0012\u0003\tIE\u0002\u0005\u0017/\u0005\u0005\t\u0012AA&\u0011\u0019a\u0017\u0003\"\u0001\u0002T!I\u0011QK\t\u0012\u0002\u0013\u0005\u0011q\u000b\u0005\n\u0003[\n\u0012\u0013!C\u0001\u0003/B\u0011\"a\u001c\u0012#\u0003%\t!a\u0016\u00039\rcWo\u001d;fe2Kgn\u001b)bkN,W*\u001b:s_J$v\u000e]5dg*\u0011\u0001$G\u0001\u0005Y&t7N\u0003\u0002\u001b7\u000511/\u001a:wKJT\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001qd\n\t\u0003A\u0011r!!\t\u0012\u000e\u0003]I!aI\f\u0002)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0013\t)cE\u0001\u0007QKJLw\u000eZ5d)\u0006\u001c8N\u0003\u0002$/A\u0011\u0001fK\u0007\u0002S)\u0011!fG\u0001\u0006kRLGn]\u0005\u0003Y%\u0012q\u0001T8hO&tw-\u0001\u0004mS:\\\u0017\n\u001a\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\nA!\u001e;jY*\t1'\u0001\u0003kCZ\f\u0017BA\u001b1\u0005\u0011)V+\u0013#\u0002\u00111Lgn\u001b(b[\u0016\u0004\"\u0001O!\u000f\u0005ez\u0004C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\u001e\u0003\u0019a$o\\8u})\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\u00051\u0001K]3eK\u001aL!AQ\"\u0003\rM#(/\u001b8h\u0015\t\u0001U(\u0001\u0007mS:\\\u0017j\u001d)bkN,G\rE\u0002G\u000f&k\u0011!P\u0005\u0003\u0011v\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0005\u0019S\u0015BA&>\u0005\u001d\u0011un\u001c7fC:\f\u0011b]2iK\u0012,H.\u001a:\u0011\u0005\u0005r\u0015BA(\u0018\u0005Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe&\u0011A\nJ\u0001\u0010[\u0016$\u0018\rZ1uC6\u000bg.Y4feB\u0011\u0011eU\u0005\u0003)^\u0011!d\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006l\u0015M\\1hKJ\f!\u0002\\8dC2\fE-\\5o!\r1ui\u0016\t\u00031\nl\u0011!\u0017\u0006\u00035n\u000bQ!\u00193nS:T!\u0001X/\u0002\u000f\rd\u0017.\u001a8ug*\u0011AD\u0018\u0006\u0003?\u0002\fa!\u00199bG\",'\"A1\u0002\u0007=\u0014x-\u0003\u0002d3\nq1i\u001c8gYV,g\u000e^!e[&t\u0017!F7bqR{\u0007/[2t!\u0016\u0014\u0018\n^3sCRLwN\u001c\t\u0003\r\u001aL!aZ\u001f\u0003\u0007%sG/\u0001\u0006j]R,'O^1m\u001bNL!A\u001b\u0013\u0002#I,7o\u00195fIVdW\rR3mCfl5/\u0001\u0007sKR\u0014\u0018\u0010R3mCfl5/\u0001\u0004=S:LGO\u0010\u000b\u000b]>\u0004\u0018O]:ukZ<\bCA\u0011\u0001\u0011\u0015i#\u00021\u0001/\u0011\u00151$\u00021\u00018\u0011\u0015!%\u00021\u0001F\u0011\u0015a%\u00021\u0001N\u0011\u0015\t&\u00021\u0001S\u0011\u0015)&\u00021\u0001W\u0011\u001d!'\u0002%AA\u0002\u0015Dq\u0001\u001b\u0006\u0011\u0002\u0003\u0007Q\rC\u0004l\u0015A\u0005\t\u0019A3\u0002\u0007I,h\u000eF\u0001J\u00035\u0011Xm]8mm\u0016$v\u000e]5dgR\u0011\u0011\n \u0005\u0006{2\u0001\r!S\u0001\tSN\u0004\u0016-^:fI\u0006i\u0001O]8dKN\u001cHk\u001c9jGN$R!SA\u0001\u0003\u0007AQ!`\u0007A\u0002%Cq!!\u0002\u000e\u0001\u0004\t9!\u0001\u0004u_BL7m\u001d\t\u0006\u0003\u0013\t\u0019b\u000e\b\u0005\u0003\u0017\tyAD\u0002;\u0003\u001bI\u0011AP\u0005\u0004\u0003#i\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003+\t9BA\u0002TKFT1!!\u0005>\u0003U\u0001(o\\2fgN$v\u000e]5dg\u000e{W\u000e\u001d7fi\u0016$R!SA\u000f\u0003?AQ! \bA\u0002%Cq!!\t\u000f\u0001\u0004\t\u0019#A\u0004sKN,H\u000e^:\u0011\r=\n)cNA\u0015\u0013\r\t9\u0003\r\u0002\u0004\u001b\u0006\u0004\bCBA\u0016\u0003c\t)$\u0004\u0002\u0002.)\u0019\u0011qF/\u0002\r\r|W.\\8o\u0013\u0011\t\u0019$!\f\u0003\u0017-\u000bgm[1GkR,(/\u001a\t\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111\b\u001a\u0002\t1\fgnZ\u0005\u0005\u0003\u007f\tID\u0001\u0003W_&$\u0017AB1di&|g\u000eF\u00028\u0003\u000bBQ!`\bA\u0002%\u000bAd\u00117vgR,'\u000fT5oWB\u000bWo]3NSJ\u0014xN\u001d+pa&\u001c7\u000f\u0005\u0002\"#M\u0019\u0011#!\u0014\u0011\u0007\u0019\u000by%C\u0002\u0002Ru\u0012a!\u00118z%\u00164GCAA%\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011\u0011\u0011\f\u0016\u0004K\u0006m3FAA/!\u0011\ty&!\u001b\u000e\u0005\u0005\u0005$\u0002BA2\u0003K\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001dT(\u0001\u0006b]:|G/\u0019;j_:LA!a\u001b\u0002b\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%s\u0001")
public class ClusterLinkPauseMirrorTopics
extends ClusterLinkScheduler.PeriodicTask {
    private final UUID linkId;
    private final String linkName;
    private final Function0<Object> linkIsPaused;
    private final ClusterLinkMetadataManager metadataManager;
    private final Function0<ConfluentAdmin> localAdmin;
    private final int maxTopicsPerIteration;
    private final int retryDelayMs;

    public static int $lessinit$greater$default$9() {
        return 1000;
    }

    public static int $lessinit$greater$default$8() {
        return 5000;
    }

    public static int $lessinit$greater$default$7() {
        return 20;
    }

    @Override
    public boolean run() {
        if (this.metadataManager.isLinkCoordinator(this.linkName, true)) {
            return this.resolveTopics(this.linkIsPaused.apply$mcZ$sp());
        }
        return true;
    }

    private boolean resolveTopics(boolean isPaused) {
        Seq process = ((MapOps)this.metadataManager.mirrorTopicsForLink(this.linkName).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkPauseMirrorTopics.$anonfun$resolveTopics$1(this, isPaused, x0$1)))).keys().toSeq();
        if (process.nonEmpty()) {
            Seq trimmed = process.size() > this.maxTopicsPerIteration ? (Seq)process.drop(process.size() - this.maxTopicsPerIteration) : process;
            return this.processTopics(isPaused, (Seq<String>)trimmed);
        }
        return true;
    }

    private boolean processTopics(boolean isPaused, Seq<String> topics) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Starting ").append(this.action(isPaused)).append(" mirror topics for topics '").append(topics).append("'").toString());
        try {
            scala.collection.immutable.Map ops = ((IterableOnceOps)topics.map((Function1 & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)(isPaused ? AlterMirrorOp.PAUSE_LINK : AlterMirrorOp.RESUME_LINK)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            AlterMirrorsOptions options = new AlterMirrorsOptions();
            AlterMirrorsResult result = ((ConfluentAdmin)this.localAdmin.apply()).alterMirrors(CollectionConverters$.MODULE$.MapHasAsJava((Map)ops).asJava(), options);
            this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.processTopicsComplete(isPaused, result.values()));
        }
        catch (Throwable e) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Encountered error while ").append(this.action(isPaused)).append(" mirror topics").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.scheduleOnce((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.run(), this.retryDelayMs);
        }
        return false;
    }

    private boolean processTopicsComplete(boolean isPaused, java.util.Map<String, KafkaFuture<Void>> results) {
        if (CollectionConverters$.MODULE$.MapHasAsScala(results).asScala().forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkPauseMirrorTopics.$anonfun$processTopicsComplete$3(this, isPaused, x0$1)))) {
            if (isPaused == this.linkIsPaused.apply$mcZ$sp()) {
                return this.resolveTopics(isPaused);
            }
            return true;
        }
        this.scheduleOnce((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.run(), this.retryDelayMs);
        return false;
    }

    private String action(boolean isPaused) {
        if (isPaused) {
            return "pausing";
        }
        return "unpausing";
    }

    public static final /* synthetic */ boolean $anonfun$resolveTopics$1(ClusterLinkPauseMirrorTopics $this, boolean isPaused$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            boolean bl;
            ClusterLinkTopicState state = (ClusterLinkTopicState)x0$1._2();
            UUID uUID = state.linkId();
            UUID uUID2 = $this.linkId;
            if (uUID == null ? uUID2 != null : !((Object)uUID).equals(uUID2)) {
                return false;
            }
            try {
                if (!isPaused$1) {
                    return state.toUnpausedState(true).nonEmpty();
                }
                bl = state.toPausedState(true).nonEmpty();
            }
            catch (Throwable throwable) {
                bl = false;
            }
            return bl;
        }
        throw new MatchError(null);
    }

    private final boolean onError$1(Throwable e, boolean isPaused$3) {
        this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Encountered error while ").append(this.action(isPaused$3)).append(" mirror topics").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$processTopicsComplete$3(ClusterLinkPauseMirrorTopics $this, boolean isPaused$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            try {
                ((KafkaFuture)x0$1._2()).get();
                return true;
            }
            catch (ExecutionException e) {
                return $this.onError$1(e.getCause(), isPaused$3);
            }
            catch (Throwable e) {
                return $this.onError$1(e, isPaused$3);
            }
        }
        throw new MatchError(null);
    }

    public ClusterLinkPauseMirrorTopics(UUID linkId, String linkName, Function0<Object> linkIsPaused, ClusterLinkScheduler scheduler, ClusterLinkMetadataManager metadataManager, Function0<ConfluentAdmin> localAdmin, int maxTopicsPerIteration, int intervalMs, int retryDelayMs) {
        this.linkId = linkId;
        this.linkName = linkName;
        this.linkIsPaused = linkIsPaused;
        this.metadataManager = metadataManager;
        this.localAdmin = localAdmin;
        this.maxTopicsPerIteration = maxTopicsPerIteration;
        this.retryDelayMs = retryDelayMs;
        super(scheduler, "PauseMirrorTopics", intervalMs);
    }
}

